#ifndef __SM_KEYFRAMESEQUENCE

#define __SM_KEYFRAMESEQUENCE

struct  KeyFrame;
class   MVFSFILE;

struct KeyFrameSequence
{
              KeyFrameSequence();
              ~KeyFrameSequence();


  int           Load(MVFSFILE* f);
  int           Save(MVFSFILE* f);

  int           LoadCompressed(MVFSFILE* f);
  int           SaveCompressed(MVFSFILE* f);

  int           Init();
  int           Shutdown();

  void          Compress         (KeyFrameSequence* pCompressed);
  int           Resample         (KeyFrameSequence* pSource, float fSampleRate);


  int           GetKeyFrame      (float fTime, float fStartTime);
  void          GetKeyFrame      (float fTime, float fStartTime, Vector3D* pV3d, Quaternion* pQ);
  KeyFrame*     GetKeyFrame      (float fTime, float fStartTime, KeyFrame* pKeyFrame);
 
  static void   GetPercentageDiff(KeyFrameSequence* pBase, KeyFrameSequence* pSeq, float* fMaxDistance, float* fMaxAngle);

  
  unsigned   m_uKeyFrames;  
  KeyFrame*  m_pKeyFrames;
  unsigned   m_uSamplingRate;
  float      m_fSamplingRate;


};

#endif