#ifndef __SM_D3DLIGHT

#define __SM_D3DLIGHT

#include "SM_KFAnimable.h"


class MVFSFILE;

enum eLightType
{
  E_POINT,
  E_DIRECTIONAL,
  E_SPOT,
};

class D3DLight : public IKFAnimable
{
public:
  void              Update(float fTime);
  
  void              SetPosition(Vector3D*   pPosition);  
  void              SetRotation(Quaternion* pRotation);
  
  D3DLIGHT8*        GetLight()
  {
    return (&m_Light);
  }

  int               Load(MVFSFILE* f);
  int               Save(MVFSFILE* f);

 
protected:
  D3DLIGHT8         m_Light;
};

namespace D3DLightManager
{
  int         Init        ();
  int         Shutdown    ();

  int         CreateLight (D3DLight** ppLight);



  void        SetLight    (unsigned iLight); 
  void        EnableLight (unsigned iLight);
  unsigned    ActiveLights();
}

#endif