#include "SM_CommonFXPCH.h"
#include "SM_DemoEffect.h"
#include "MSurface.h"
#include "SM_Main.h"
#include "SM_Screen.h"
#include "MSystemFunctions.h"


class ScrollFX : public SM_DemoEffect
{
public:              
  ScrollFX(char const* pcName) : SM_DemoEffect(pcName)
  {
  }

  virtual          ~ScrollFX()
  {
  }

  int      Init()
  {
    return (0);
  }

  int      Shutdown()
  {
    return (0);
  }

  int      Start(float fTime)
  {
    m_fStartTime=fTime;
    return (0);
  }

  int      Stop()
  {
    return (0);
  }

  int      Run(float fTime)
  {
    ScreenManager::Render(m_iImage, m_fX-(fTime-m_fStartTime)*m_fSpeed, m_fY, 1, 1, ScreenManager::E_NORMAL);
    return (1);
  }

  
   
  

  int      Command           (float fTime, const char* pcCommand)
  {
    char* pcToken;

    char* pcAux=new char[strlen(pcCommand)+1];
    strcpy(pcAux, pcCommand);

    pcToken=strtok(pcAux, " \t");
    if (strcmp(pcToken, "LOAD")==0)
    {
      char pcPath[256];

      pcToken=strtok(0, " \t");
      strcpy(pcPath, "data/images/");
      
      char pcAux[256];
      MExtractBasename(pcAux, pcToken);
        
      strcat(pcPath, pcAux);    

      if ((m_iImage=ScreenManager::LoadImagen(pcPath))==-1)
      {
        SM_Main::OutputError("Failed to load", pcPath);
        return (-1);
      }

      pcToken=strtok(0, " \t");      
      m_fX=atof(pcToken);  

      pcToken=strtok(0, " \t");      
      m_fY=atof(pcToken);  
    }
    else if (strcmp(pcToken, "SNAPX")==0)
    {
      m_fX=m_fX-(fTime-m_fStartTime)*m_fSpeed;
      m_fStartTime=fTime;
    }
    else if (strcmp(pcToken, "SPEED")==0)
    {
      pcToken=strtok(0, " \t");
      m_fSpeed=atof(pcToken);
    }

    delete[] pcAux;

    return (0);
  }  


  float m_fStartTime;
  float m_fSpeed;
  float m_fX;
  float m_fY;
  int   m_iImage;
  int   m_iBlurTexture;
};

DEFINE_EFFECT(ScrollFX)

ScrollFX Scroll00("SCROLL_00");
ScrollFX Scroll01("SCROLL_01");
ScrollFX Scroll02("SCROLL_02");
ScrollFX Scroll03("SCROLL_03");
