unit matrix;

INTERFACE

type
	PMatrix=^TMatrix;
	TMatrix=array[0..3,0..3] of single;

procedure identity(var m:TMatrix);
procedure MatrixMultiply(var d,m1,m2:TMatrix);
procedure MatrixTranspose(var m:TMatrix);

IMPLEMENTATION

procedure identity(var m:TMatrix);
begin
	m[0][0]:=1;m[1][0]:=0;m[2][0]:=0;m[3][0]:=0;
	m[0][1]:=0;m[1][1]:=1;m[2][1]:=0;m[3][1]:=0;
	m[0][2]:=0;m[1][2]:=0;m[2][2]:=1;m[3][2]:=0;
end;

procedure MatrixMultiply(var d,m1,m2:TMatrix);
begin
	d[0][0]:=m1[0][0]*m2[0][0]+m1[0][1]*m2[1][0]+m1[0][2]*m2[2][0];
	d[0][1]:=m1[0][0]*m2[0][1]+m1[0][1]*m2[1][1]+m1[0][2]*m2[2][1];
	d[0][2]:=m1[0][0]*m2[0][2]+m1[0][1]*m2[1][2]+m1[0][2]*m2[2][2];

	d[1][0]:=m1[1][0]*m2[0][0]+m1[1][1]*m2[1][0]+m1[1][2]*m2[2][0];
	d[1][1]:=m1[1][0]*m2[0][1]+m1[1][1]*m2[1][1]+m1[1][2]*m2[2][1];
	d[1][2]:=m1[1][0]*m2[0][2]+m1[1][1]*m2[1][2]+m1[1][2]*m2[2][2];

	d[2][0]:=m1[2][0]*m2[0][0]+m1[2][1]*m2[1][0]+m1[2][2]*m2[2][0];
	d[2][1]:=m1[2][0]*m2[0][1]+m1[2][1]*m2[1][1]+m1[2][2]*m2[2][1];
	d[2][2]:=m1[2][0]*m2[0][2]+m1[2][1]*m2[1][2]+m1[2][2]*m2[2][2];

{	d[3][0]:=m1[3][0]*m2[0][0]+m1[3][1]*m2[1][0]+m1[3][2]*m2[2][0]+m2[3][0];
	d[3][1]:=m1[3][0]*m2[0][1]+m1[3][1]*m2[1][1]+m1[3][2]*m2[2][1]+m2[3][1];
	d[3][2]:=m1[3][0]*m2[0][2]+m1[3][1]*m2[1][2]+m1[3][2]*m2[2][2]+m2[3][2];}
end;

procedure MatrixTranspose(var m:TMatrix);
var
	row,col:integer;
	d:TMatrix;

begin
	for row:=0 to 2 do
		for col:=0 to 2 do
			d[row,col]:=m[col,row];
	m:=d;
end;

end.
																																																																																							}
																																																																																									}                                              end.