unit mareo;

INTERFACE

procedure go;

IMPLEMENTATION

uses main,Anima13,colors,math,Engine3D,Mode13,keys,MyDOS,MyMidas;

procedure go;
const
	ZMIN=200;ZMAX=800;

	TOTAL=8-1;
	SPEED=5;

	map:array[1..25] of byte=(
		1,0,0,0,1,
		0,1,0,1,0,
		0,0,1,0,0,
		0,1,0,1,0,
		1,0,0,0,1);

var
	incr:array[0..TOTAL] of record
		x,y,z:integer;
	end;
	s:Tscene;
	o:P3D;
	bolas:array[0..TOTAL] of P3D;
	zz,
	a,n,m,mp,
	x,y,w:integer;
	pal:Tpal;
	z:boolean;
	l:PMapLight;
	t1,t2,e:PTexture;
	_TMP_:integer;
	cam:TCamera;

begin
	StartCrono;
	SetTransferMode(COPY_ZOOM);
	SetSyncro(FALSE);

	if not LoadMapLight(l,'MIX3') then fError('MIX3.LGT');
	if not LoadTexture('ORO',e,pal) then fError('ORO.TEX');
	if not LoadTexture('BEIGE031',t2,pal) then fError('BEIGE031.TEX');
	if not LoadTexture('PATRN575',t1,pal) then fError('PATRN575.TEX');
	InitDifumine(0,255,pal);
	w:=GetNearColor(white,pal);

	if not Load3D(o,'BOLA') then fError('BOLA.3DN');
	o^.world.z:=1300;
	SetRenderType(o,ALL_CHILDS,_TEXTURE_ENVMAP_);
	SetTexture(o,ALL_CHILDS,t2);
	SetEnvmap(o,ALL_CHILDS,t2);
	SetMapLight(o,ALL_CHILDS,l);
	ScaleCoordinates(o,ALL_CHILDS,-2);

	for n:=0 to TOTAL do
		begin
			if n=0 then
				begin
					if not Load3D(bolas[n],'DONUT') then fError('DONUT.3DN');
					UnScaleCoordinates(bolas[n],ALL_CHILDS,3);
				end
			else
				MakeClone3D(bolas[0],bolas[n]);
			bolas[n]^.world.z:=aleatorio(300,700);
			bolas[n]^.world.x:=aleatorio(-150,150);
			bolas[n]^.world.y:=aleatorio(-100,100);
			SetMapLight(bolas[n],ALL_CHILDS,l);
			SetRenderType(bolas[n],ALL_CHILDS,_TEXTURE_ENVMAP_);
			SetTexture(bolas[n],ALL_CHILDS,t1);
			SetEnvmap(bolas[n],ALL_CHILDS,e);

			if random(2)=1 then
				incr[n].x:=random(SPEED)
			else
				incr[n].x:=-random(SPEED);

			if random(2)=1 then
				incr[n].y:=random(SPEED)
			else
				incr[n].y:=-random(SPEED);

			if random(2)=1 then
				incr[n].z:=random(SPEED)
			else
				incr[n].z:=-random(SPEED);
		end;

	NewScene(s,MAX_FACES_IN_SCENE);
	ResetCamera(cam);

	zz:=0;
	z:=FALSE;
	mp:=0;
	a:=5;
	SetZoom(a);

	SkipFrames:=StartFrame;
	inc(MyFrames);
	repeat
		SetCamera(s,cam);
		sf:=GetSemaphore(13);
		difumine;

		Rotate3D(o,DADDY,1,-1,0.5);

		for n:=0 to TOTAL do with bolas[n]^ do
			begin
				Rotate3D(bolas[n],DADDY,n/1.5,n+1,n*1.25);

				world.x:=world.x+incr[n].x;
				if abs(world.x)>150 then incr[n].x:=-incr[n].x;
				world.y:=world.y+incr[n].y;
				if abs(world.y)>100 then incr[n].y:=-incr[n].y;
				world.z:=world.z+incr[n].z;
				if (world.z<ZMIN) or (world.z>ZMAX) then incr[n].z:=-incr[n].z;

				Put3D(s,bolas[n],DADDY);
			end;

		if (MyFrames and 1=0) and (a<320) then
			begin
				a:=a*2;
				if a=320 then
					SetTransferMode(COPY)
				else
					SetZoom(a);
			end;

		Put3D(s,o,DADDY);
		RenderScene(s);
		if inkey[K_ESC] then halt;

		if mp>0 then reduce(0,0,w);
		x:=0;y:=0;
		for m:=1 to mp*5 do
			begin
				if x=5 then
					begin
						inc(y);
						x:=0;
					end;
				if map[m]=1 then CopyBitMap(x*64,y*40);
				inc(x);
			end;
		if (ToFinish<400) and (MyFrames and 7=0) and (mp<5) then
			begin
				inc(mp);
				WhitePal;
				InitDifumine(0,255,pal);
			end;

		if mp=5 then
			begin
				z:=TRUE;
				_TMP_:=CaptureSprite(128,80,128+64,80+40);
			end;
		if z then
			begin
				PutScaleSprite(_TMP_,128-zz,80+round(-zz*0.8),192+zz,120+round(zz*0.8));
				FreeCaptureSprite(_TMP_);
				if zz<85 then inc(zz,3);
			end;

		SkipFrames:=anima;
	until finish;
	DifumineToColor(0,255,black);

	FreeMapLight(l);
	FreeTexture(t1);
	FreeTexture(t2);
	FreeTexture(e);
	FreeScene(s);
	Free3D(o);
	for n:=1 to TOTAL do FreeClone3D(bolas[n]);
	Free3D(bolas[0]);
	SetSyncro(TRUE);
end;

end.