unit main;

INTERFACE

uses colors,math,Engine3D;

const
	DEMONAME='ORIENT';

	_CODE_=1;
	_GFX_=_CODE_+1;
	_MUSIC_=_GFX_+1;

	_BOLA_=_MUSIC_+1;

	_FLARE_1_=_BOLA_+1;
	_FLARE_2_=_FLARE_1_+1;

	FIRST_LETTER=_FLARE_2_+1;
	LAST_LETTER=FIRST_LETTER+29-1;

var
	GlobalPal:TPal;
	GlobalTrn:PTransparency;
	GlobalMapLight:PMapLight;
	GlobalW:integer;

	translate:array[char] of byte;
	time,TotalTicks,ticks:LongInt;
	{$IFDEF _DEBUG_}
	fich:text;
	{$ENDIF}

procedure init;
procedure done;

procedure FError(n:string);
procedure error(n:string);

procedure ClearVideo;

function print(x,y:integer;c:string):integer;

function finish:boolean;
procedure StartCrono;
procedure reduce(x,y:integer;color:byte);

IMPLEMENTATION

uses
	Anima13,Mode13,keys,MyMidas,MyDOS,DOS,OP386,speed
{$IFDEF _LZ_}
	,LzFiles
{$ELSE}
	{$IFDEF _RLE_}
	,RLEFiles
	{$ENDIF}
{$ENDIF}
;

const
	message:string=DEMONAME+' by The Banner'+#13+#10+#13+#10+'MIDAS by Sahara Surfers';

	CSS=4;
	C_SPEED=1 shl CSS;

var
	CallOld8:procedure;

	OldProc:pointer;
	ini:boolean;

procedure Myint8;INTERRUPT;
begin
	PUSHF;
	CallOld8;
	inc(ticks);
	inc(TotalTicks);
	STI;
END;

procedure init;
var
	n:integer;

begin
	ini:=FALSE;

	{$IFDEF _LZ_}
		{$IFNDEF _DEBUG_}
	if LzInit(DEMONAME+'.EXE')<>0 then FError(DEMONAME+'.EXE');
		{$ELSE}
	if LzInit(DEMONAME+'.DAT')<>0 then FError(DEMONAME+'.DAT');
		{$ENDIF}
	{$ELSE}
		{$IFDEF _RLE_}
	if not RLEFiles.init(DEMONAME+'.DAT') then FError(DEMONAME+'.DAT');
		{$ENDIF}
	{$ENDIF}

	{$IFDEF __BPPROT__}
	if MemAvail<2000*1024 then error('Need 2 MB free');
	{$ENDIF}

	if Test8086<2 then error('Need a 386+');
	if Test8087<3 then error('Need a 387+');

	{$IFDEF __BPPROT__}
	if not MyMidas.init(4) then halt;
	{$ENDIF}
	keys.init;

	if not Mode13.init(SUPER_BLUR) then error('Need a VGA');
	if not LoadTransparency(GlobalTrn,'GLOBAL') then FError('GLOBAL.TRN');
	if not LoadMapLight(GlobalMapLight,'GLOBAL') then FError('GLOBAL.LGT');
	InitSuperBlur(GlobalTrn);
{	SetSyncro(FALSE);}

	{$IFDEF __BPPROT__}
	if not LoadModule(DEMONAME+'.MOD') then FError(DEMONAME+'.MOD');
	if not PlayModule then error('Error playing');
	{$ENDIF}

	Anima13.init;
	if not LoadSprites(DEMONAME+'.SPR',GlobalPal) then FError(DEMONAME+'.SPR');
	InkAllRGB(0,255,GlobalPal);
	frame;
	GlobalW:=GetNearColor(white,GlobalPal);

	TotalTicks:=0;
	GetIntVec(8,@CallOld8);
	SetIntVec(8,@MyInt8);
	ini:=TRUE;
end;

{$F+}
procedure done;
var
	n:integer;

begin
	{$IFDEF _LZ_}
	LzDeInit;
	{$ELSE}
		{$IFDEF _RLE_}
		RLEFiles.done;
		{$ENDIF}
	{$ENDIF}

	{$IFDEF _DEBUG_}
	system.close(fich);
	{$ENDIF}

	if ini then
		begin
			SetIntVec(8,@CallOld8);
			{$IFDEF __BPPROT__}
			if isPlaying then StopModule;
			MyMidas.done;
			{$ENDIF}
		end;

	DifumineToColor(0,255,black);
	keys.done;
	Mode13.done;
	Anima13.done;

	WriteLn(message);
	ExitProc:=OldProc;

	WriteLn(TotalTicks);{}
end;
{$F-}

procedure FError(n:string);
begin
	message:='Error in file '+n;
	halt;
end;

procedure error(n:string);
begin
	message:=n;
	halt;
end;

procedure ClearVideo;
begin
	FillChar(PBackPage^,vRAMSize,0);
	FillChar(PvRAM^,vRAMSize,0);
	FillChar(VGA^,vRAMSize,0);
end;

function print(x,y:integer;c:string):integer;
var
	n:integer;
	s:Tsprite;
	m:char;

begin
	for n:=1 to length(c) do
		begin
			m:=c[n];
			if m<>' ' then
				begin
					s.n:=translate[m];
					s.x:=x;s.y:=y;
					PutSpriteMaskClipped(s,NIL);
				end;
			inc(x,SprInfo^[FIRST_LETTER].width);
		end;
	print:=x;
end;

function finish:boolean;
begin
	finish:=ticks>=time;
end;

procedure StartCrono;
begin
	ticks:=0;
end;

procedure reduce(x,y:integer;color:byte);
begin
	ASM
		PUSH	DS
		MOV		BX,y
		ADD		BX,BX
		MOV		DI,WORD(MultByWidth[BX])
		ADD		DI,x
		LDS		SI,PvRAM
		MOV		DX,200/5

@Y:
		MOV		CX,320/5
		PUSH	DI

@X:
		MOV		AL,[SI]
		ADD		SI,5
		MOV		[DI],AL
		INC		DI
		DEC		CX
		JNZ		@X

		POP		DI
		ADD		DI,320
		ADD		SI,320*(5-1)
		DEC		DX
		JNZ		@Y

		POP		DS
	END;
	box(x,y,x+64,y+40,color);
end;

var
	n:char;
	m:integer;

begin
	OldProc:=ExitProc;
	ExitProc:=@done;

	randomize;

	m:=FIRST_LETTER;
	for n:='A' to 'Z' do
		begin
			translate[n]:=m;
			inc(m);
		end;
	for n:='1' to '3' do
		begin
			translate[n]:=m;
			inc(m);
		end;

	init;

	{$IFDEF _DEBUG_}
	assign(fich,DEMONAME+'.DBG');
	system.ReWrite(fich);
	{$ENDIF}
end.