unit lente;

INTERFACE

procedure init;
procedure done;
procedure go;

IMPLEMENTATION

uses Mode13,Op386;

const
	LENS_DIAMETER=180;

type
	TLens=array[0..LENS_DIAMETER*LENS_DIAMETER] of word;

var
	lens,buffer:^TLens;
	px,py,ix,iy:integer;
	guarda:word;

procedure FetchBuffer;ASSEMBLER;
ASM
	PUSH		DS

	LES			DI,buffer
	MOV			BX,py
	ADD			BX,BX
	MOV			SI,WORD(MultByWidth[BX])
	ADD			SI,px
	MOV			DS,WORD(PvRAM+2)
	PUSH		SI

	MOV			BH,LENS_DIAMETER

@Y:
	MOV			CX,LENS_DIAMETER/4
	REP;		DB _386;MOVSW     {REP MOVSD}
	ADD			SI,320-LENS_DIAMETER
	DEC			BH
	JNZ			@Y

	POP			SI
	POP			DS
	MOV			guarda,SI
END;

procedure MorphBuffer;ASSEMBLER;
ASM
	PUSH		BP
	PUSH		DS

	MOV			AX,WORD(lens+2)
	DW			MOV_GS_AX
	MOV			BX,WORD(lens)
	LES			DI,PvRAM
	ADD			DI,guarda
	LDS			BP,buffer

	MOV			CH,LENS_DIAMETER

@Y:
	MOV			CL,LENS_DIAMETER/2

@X:
	DB 			GS;MOV	SI,[BX]
	MOV			AL,DS:[BP+SI]
	DB 			GS;MOV	SI,[BX+2]
	MOV			AH,DS:[BP+SI]
	ADD			BX,4
	MOV			ES:[DI],AX
	ADD			DI,2
	DEC			CL
	JNZ			@X

	ADD			DI,320-LENS_DIAMETER
	DEC			CH
	JNZ			@Y

	POP			DS
	POP			BP
END;

procedure LensInit;

	function FindSqrt(numero:LongInt):word;ASSEMBLER;
ASM
	DB		_386;MOV		AX,WORD(numero)
	DB		_386;XOR		DX,DX
	DB		$66,$B9,$01,0,0,0	{MOV ECX,1}

@BUCLE:
	DB		_386;SUB    AX,CX
	JB      @EXIT
	INC			DX
	INC			CX
	INC			CX
	JMP			@BUCLE

@EXIT:
	MOV			AX,DX
END;

const
	AUMENTO=LENS_DIAMETER div 5;		{+=Menos aumento, -=+ms aumento}
	R=LENS_DIAMETER div 2;
	RR=R*R;
	RRR=RR-(AUMENTO*AUMENTO);

var
	xx,yy,a,b,x,y,pos,s,z:integer;
	e,f,g:word;

begin
	GetMem(lens,SizeOf(TLens));

	pos:=0;
	s:=sqr(FindSqrt(RRR));       {Genero la lente}

	for y:=-R to R-1 do
		for x:=-R to R-1 do
			begin
				xx:=sqr(x);
				yy:=sqr(y);

				if xx+yy>s then
					begin
						a:=x;
						b:=y;
					end
				else
					begin    {NORMAL--, otro camino,-+, +-, ++}
						z:=FindSqrt(RR-xx-yy);
						a:=(x*AUMENTO) div z;
						b:=(y*AUMENTO) div z;
					end;

				lens^[pos]:=((b+R)*LENS_DIAMETER)+(a+R);
				inc(pos);
			end;
end;

procedure init;
begin
	LensInit;
	GetMem(buffer,SizeOf(TLens));
	px:=CENTERX-(LENS_DIAMETER div 2);
	ix:=1;
	py:=CENTERY-(LENS_DIAMETER div 2);
	iy:=1;
end;

procedure done;
begin
	FreeMem(lens,SizeOf(TLens));
	FreeMem(buffer,SizeOf(TLens));
end;

procedure go;
begin
	FetchBuffer;
	MorphBuffer;
	inc(px,ix);
	if (px<1) or (px>XMAX-LENS_DIAMETER) then ix:=-ix;
	inc(py,iy);
	if (py<1) or (py>YMAX-LENS_DIAMETER) then iy:=-iy;
end;

end.