unit blobs;

INTERFACE

procedure init;
procedure done;
procedure go;

IMPLEMENTATION

uses main,Mode13,math,Op386;

const
	MAX_COLORS=64;

var
	cuadrado:array[0..255] of word;
	a,m1,a1,m2,a2:integer;

procedure PutBlob(x0,y0,x1,y1,x2,y2:integer);ASSEMBLER;
ASM
	LES			DI,PvRAM
	MOV     CH,100
	MOV     CL,160

@LOOP:
	XOR     BH,BH
	MOV     BL,CL
	SUB     BL,BYTE(x0)
	ADD     BX,BX
	MOV     SI,WORD(cuadrado[BX])

	XOR     BH,BH
	MOV     BL,CH
	SUB     BL,BYTE(y0)
	ADD     BX,BX
	ADD     SI,WORD(cuadrado[BX])					{SI=(x-x0^2)+(y-y0^2)}

	XOR     BH,BH
	MOV     BL,CL
	SUB     BL,BYTE(x1)
	ADD     BX,BX
	MOV     DX,WORD(cuadrado[BX])

	XOR     BH,BH
	MOV     BL,CH
	SUB     BL,BYTE(y1)
	ADD     BX,BX
	ADD     DX,WORD(cuadrado[BX])					{DX=(x-x1^2)+(y-y1^2)}

	XOR     BH,BH
	MOV     BL,CL
	SUB     BL,BYTE(x2)
	ADD     BX,BX
	MOV     AX,WORD(cuadrado[BX])

	XOR     BH,BH
	MOV     BL,CH
	SUB     BL,BYTE(y2)
	ADD     BX,BX
	ADD     AX,WORD(cuadrado[BX])         {AX=(x-x2^2)+(y-y2^2)}

	IMUL		DX
	SHL			DX,2
	MOV 		AX,DX
	IMUL    SI
	SHL			DX,2
	CMP			DX,MAX_COLORS
	JA			@CERO

	MOV			DH,DL
	MOV     ES:[DI],DX
	MOV     ES:[DI+320],DX

@CERO:
	ADD			DI,2
	DEC     CL
	JNZ     @LOOP

	ADD			DI,320
	MOV     CL,160
	DEC     CH
	JNZ     @LOOP
END;

procedure init;
var
	n:integer;

begin
	for n:=0 to 127 do cuadrado[n]:=sqr(n);
	for n:=128 to 255 do cuadrado[n]:=sqr(256-n);

	m1:=32;a1:=-2;
	m2:=16;a2:=1;
	a:=180;
end;

procedure done;
begin
end;

procedure go;
var
	x1,y1,
	x2,y2,
	x3,y3:integer;

begin
	x3:=80-round(m2*cos(a*RAD));
	y3:=50+round(m1*sin(a*RAD));

	x2:=80+round(m1*sin(a*RAD));
	y2:=50+round(m2*cos(a*RAD));

	x1:=80+round(1.5*m2*sin(a*RAD));
	y1:=50+round(m1*cos(a*RAD));

	inc(m1,a1);
	if (m1<1) or (m1>75) then a1:=-a1;

	inc(m2,a2);
	if (m2<1) or (m2>100) then a2:=-a2;

	inc(a);
	if a>DEG then dec(a,DEG);
	PutBlob(x1,y1,x2,y2,x3,y3);
end;

end.