const
	RECORRIDO=30;     {Recorrido de la parbola}
	LEN_DIAMETER=90;  {Dimetro de la lente}
	LEN_TOPE=5;
	DIVISION=8;

var
	Mvirtual:^byte;
	sourcebuffer:array[0..LEN_DIAMETER*LEN_DIAMETER] of byte;
	difumina:array[0..LEN_DIAMETER*LEN_DIAMETER] of boolean;
	lens:array[0..LEN_DIAMETER*LEN_DIAMETER] of word;
	guarda:word;
	xx,yy,positionx,positiony,lx,ladd,lladd:integer;
	vez:boolean;

procedure _lente;
	procedure lente;
		procedure fetch;ASSEMBLER;
ASM
	PUSH		DS
	MOV			AX,DS
	MOV			ES,AX

	MOV			BX,PositionY
	MOV			yy,BX
	MOV			SI,PositionX
	MOV			xx,SI
	ADD			BX,BX
	ADD			SI,WORD(multby320[BX])
	MOV			guarda,SI

	LEA			DI,sourcebuffer
	MOV			DS,vram
	MOV			DX,LEN_DIAMETER
	MOV			BX,320
	SUB			BX,DX

@COPYROW:
	MOV			CX,LEN_DIAMETER/2
	REP			MOVSW

	ADD			SI,BX
	DEC			DX
	JNZ			@COPYROW

	POP			DS
END;

		procedure morph;ASSEMBLER;
ASM
	PUSH		BP

	MOV			ES,vram
	LEA			SI,lens
	MOV			DI,guarda
	MOV			DX,LEN_DIAMETER
	MOV			BP,4

@BUCLE:
	MOV			CX,LEN_DIAMETER/2

@DOPOINT:
	MOV			BX,[SI]
	MOV			AL,BYTE(sourcebuffer[BX])
	MOV			BX,[SI+2]
	MOV			AH,BYTE(sourcebuffer[BX])

	TEST		cambia,NOT 0
	JZ			@SIGUE

	TEST		BYTE(difumina[BX]),NOT 0
	JZ			@SIGUE

	ADD			AH,128
	ADD			AL,128

@SIGUE:
	STOSW
	ADD			SI,BP
	DEC			CX
	JNZ			@DOPOINT

	ADD			DI,320-LEN_DIAMETER
	DEC			DX
	JNZ			@BUCLE

	POP			BP
END;

		procedure restore;ASSEMBLER;
ASM
	MOV			ES,vram
	MOV			DI,xx
	MOV			BX,yy
	ADD			BX,BX
	ADD			DI,WORD(multby320[BX])

	LEA			SI,sourcebuffer
	MOV			DX,LEN_DIAMETER
	MOV			BX,320
	SUB			BX,DX

@COPYROW:
	MOV			CX,LEN_DIAMETER/2
	REP			MOVSW

	ADD			DI,BX
	DEC			DX
	JNZ			@COPYROW
END;

var
	a:integer;

begin
	for a:=1 to 1000 do
		begin
			if vez then restore;
			fetch;
			morph;

			if (not cambia) and (a=395) then cambia:=TRUE;

			SpeedMove(ptr(vram,0)^,ptr($a000,0)^,64000);
			inc(PositionX,ladd);
			frame;
			InkRGB(0,negro);

			if (PositionX>XMAX-LEN_DIAMETER-LEN_TOPE-1) or (PositionX<LEN_TOPE+1) then
				begin
					InkRGB(0,blanco);
					ASM
						MOV			BX,FALSE
						MOV			CX,lladd

						MOV			AX,ladd
						TEST		AX,AX
{					BX=ip:=ladd<0;}
						JGE			@MAYOR

@MAYOR:
						NEG			AX
{					AX=ladd:=-ladd;}

						CMP			AX,-1
						JNZ			@SIGUE
						CMP			CX,-1
						JNZ			@SIGUE
						MOV			CX,1
{					if (ladd=-1) and (lladd=-1) then CX=lladd:=1;}

@SIGUE:
						TEST		AX,AX
						JGE			@CONT
						SUB			AX,CX
						JMP			@SIG

@CONT:
						ADD			AX,CX
{					if ladd<0 then dec(ladd,lladd) else inc(ladd,lladd);}
@SIG:
						CMP			AX,LEN_TOPE
						JL			@ABAJO
						CMP			AX,-LEN_TOPE
						JL			@ABAJO
						NEG			CX
{					if (ladd>LEN_TOPE) or (ladd<-LEN_TOPE) then lladd:=-lladd;}

@ABAJO:
						TEST		AX,AX
						JNZ			@FIN
						TEST		BX,BX
						JZ			@FALSO
						MOV			AX,1

						JMP			@PON

@FALSO:
						MOV			AX,-1

@PON:
{					if ladd=0 then if ip then ladd:=1 else ladd:=-1;}

@FIN:
						MOV			ladd,AX
						MOV			lladd,CX
					END;
				end;

			ASM
				MOV			AX,lx
				IMUL		AX
				SAR			AX,3	{/8}
				MOV			PositionY,AX

				INC			lx
				CMP			lx,RECORRIDO
				JLE			@MENOR
				MOV			lx,-RECORRIDO

@MENOR:
				MOV			vez,TRUE
			END;
		end;

	cambia:=FALSE;
end;

	procedure mandelbrot;ASSEMBLER;
const
	xmine:LongInt=3000;xmaxe:LongInt=6500;
	ymine:LongInt=7800;ymaxe:LongInt=10000;
	xdots:LongInt=320;ydots:LongInt=YMAX;
	iter:LongInt=128;
	topr:LongInt=50000;

var
	pie,qie,poe,qoe,xxe,yye,pvar,qvar:LongInt;

ASM
	MOV		ES,vram
	XOR		DI,DI

	DB		$66;MOV 	AX,WORD(xmaxe)
	DB		$66;SUB 	AX,WORD(xmine)
	DB		$66;XOR 	DX,DX
	DB		$66;MOV 	BX,WORD(xdots)
	DB		$66;IDIV 	BX
	DB		$66;MOV 	WORD(pie),AX
	DB		$66;MOV 	AX,WORD(ymaxe)
	DB		$66;SUB 	AX,WORD(ymine)
	DB		$66;XOR 	DX,DX
	DB		$66;MOV 	BX,WORD(ydots)
	DB		$66;IDIV 	BX
	DB		$66;MOV 	WORD(qie),AX
	DB		$66;MOV 	CX,BX
	DB		$66;DEC		CX

@BUCLEY:
	DB		$66;MOV 	WORD(qvar),CX
	DB		$66;PUSH 	CX
	DB		$66;MOV 	CX,WORD(xdots)

@BUCLEX:
	DB		$66;MOV 	WORD(pvar),CX
	DB		$66;PUSH 	CX
	DB		$66;MOV 	AX,CX
	DB		$66;IMUL 	WORD(pie)
	DB		$66;ADD 	AX,WORD(xmine)
	DB		$66;MOV 	WORD(poe),AX
	DB		$66;MOV 	AX,WORD(qvar)
	DB		$66;IMUL 	WORD(qie)
	DB		$66;ADD 	AX,WORD(ymine)
	DB		$66;MOV 	WORD(qoe),AX
	DB		$66;XOR 	AX,AX
	DB		$66;MOV 	WORD(xxe),AX
	DB		$66;MOV 	WORD(yye),AX
	DB		$66;MOV 	CX,WORD(iter)

@ITERACIONES:
	DB		$66;PUSH 	CX
	DB		$66;MOV 	AX,WORD(yye)
	DB		$66;IMUL 	AX
	DB		$66,$0F,$AC,$D0,$0E	{SHRD 	EAX,EDX,14}

	DB		$66;MOV 	BX,AX
	DB		$66;MOV 	AX,WORD(xxe)
	DB		$66;IMUL 	AX
	DB		$66,$0F,$AC,$D0,$0E	{SHRD 	EAX,EDX,14}

	DB		$66;MOV 	DX,AX
	DB		$66;ADD 	AX,BX
	DB		$66;CMP 	AX,WORD(topr)
	JL 		@MAYOR

	MOV		ES:[DI],CL
	INC		DI

	DB		$66;POP 	CX

@SIGUE:
	DB		$66;POP 	CX
	DEC		CX
	JNZ		@BUCLEX

	DB		$66;POP 	CX
	DEC		CX
	JNZ		@BUCLEY

	JMP 	@FIN

@MAYOR:
	DB		$66;MOV 	AX,DX
	DB		$66;SUB 	AX,BX
	DB		$66;ADD 	AX,WORD(poe)
	DB		$66;MOV 	BX,AX
	DB		$66;MOV 	AX,WORD(xxe)
	DB		$66;ADD		AX,AX
	DB		$66;IMUL 	WORD(yye)
	DB		$66,$0F,$AC,$D0,$0E			{SHRD 	EAX,EDX,14}
	DB		$66;ADD 	AX,WORD(qoe)
	DB		$66;MOV 	WORD(xxe),BX
	DB		$66;MOV 	WORD(yye),AX
	DB		$66;POP 	CX
	DEC		CX
	JNZ		@ITERACIONES

	MOV		BYTE(ES:[DI]),0
	INC		DI
	JMP		@SIGUE

@FIN:
END;

const
	AUMENTO=LEN_DIAMETER div 5;
	R=LEN_DIAMETER div 2;
	RR=R*R;
	RRR=RR-(AUMENTO*AUMENTO);

var
	a,b,x,y,s,zl:integer;
	pos:word;

begin
	ASM
		MOV			AH,$48			{Pido memoria 64K}
		MOV			BX,64000/16
		INT			$21

		MOV			WORD(Mvirtual),0
		MOV			WORD(Mvirtual+2),AX
	END;
	vram:=seg(Mvirtual^);
	SpeedFillChar(Mvirtual^,64000,0);

	ASM
		XOR			DX,DX		{c:=0;}
		MOV			CX,DX		{for a:=0 to 127 do}
		LEA			DI,colours
		MOV			SI,DI
		ADD			SI,128*3

@BUCLE:
		CMP			CX,127	{if a=127 then}
		JNZ			@SIGUE

		MOV			DX,255	{c:=255;}
		MOV			Tpaleta[DI].RGB.azul,DL	{colours[a].azul:=c;}
		JMP			@CONTINUA

@SIGUE:
		MOV			Tpaleta[DI].RGB.azul,CL  {else colours[a].azul:=a;}

@CONTINUA:
		MOV			Tpaleta[DI].RGB.rojo,DL		{colours[a].rojo:=c;}
		MOV			Tpaleta[DI].RGB.verde,DL	{colours[a].verde:=c;}

		MOV			BX,CX    {4*rojo+}
		SHL			BX,2

		IMUL		AX,CX,10  {10*verde+}
		ADD			AX,BX

		MOV			BX,DX
		ADD			BX,BX

		ADD			BX,AX     {2*azul}

		SHR			BX,2      {div 4, BX=b}

		MOV			Tpaleta[SI].RGB.rojo,CL		{colours[a+128].rojo:=b;}
		MOV			Tpaleta[SI].RGB.verde,CL	{colours[a+128].verde:=b;}
		MOV			Tpaleta[SI].RGB.azul,CL		{colours[a+128].azul:=b;}

		ADD			DI,3
		ADD			SI,3
		INC			CX
		CMP			CX,128
		JB		@BUCLE
	END;
	InkAllRGB(0,CMAX,colours);

	mandelbrot;
	OutTextXY(85,35,127,'MICRO');
	OutTextXY(85,140,1,'PALMA');

	ASM
		MOV			AX,1
		MOV			ladd,AX
		MOV			lladd,AX
		MOV			lx,-RECORRIDO
		MOV			positionx,CENTERX-(LEN_DIAMETER/2)
		MOV			positiony,(-RECORRIDO*-RECORRIDO)/DIVISION
		MOV			vez,FALSE

		PUSH		0
		PUSH		RRR
		CALL		FindSqrt
		IMUL		AX
		MOV			s,AX          {s:=sqr(sqrt(RRR));}
	END;

	pos:=0;
	for y:=-R to R-1 do for x:=-R to R-1 do
		begin
			ASM
				MOV			AX,y
				IMUL		AX
				MOV			yy,AX   {yy:=sqr(y);}

				MOV			AX,x
				IMUL		AX
				MOV			xx,AX   {xx:=sqr(x);}
			END;

			if xx+yy>s then
				begin
					a:=x;b:=y;
					difumina[pos]:=FALSE;
				end else
					begin
						zl:=FindSqrt(RR-xx-yy);
						ASM
							MOV			CX,zl
							MOV			BX,AUMENTO

							MOV			AX,BX
							IMUL		x
							IDIV		CX
							MOV			a,AX			{a:=(x*AUMENTO) div zl;}

							MOV			AX,BX
							IMUL		y
							IDIV		CX
							MOV			b,AX      {b:=(y*AUMENTO) div zl;}
						END;
						difumina[pos]:=TRUE;
					end;
			lens[pos]:=((b+R)*LEN_DIAMETER)+(a+R);
			inc(pos);
		end;

	lente;

	ASM
		MOV			AH,$49				{Libero memoria}
		MOV			ES,WORD(Mvirtual+2)
		INT			$21

		MOV			vram,$a000
	END;
end;