unit blobs;

INTERFACE

procedure go;

IMPLEMENTATION

uses main,Mode13,MyDOS,vector,colors,keys,MyMidas;

const
	MAX_COLORS=64;

var
	cuadrado:array[0..255] of word;

(*procedure PutBlob(x0,y0,x1,y1:integer);ASSEMBLER;
ASM
	MOV     ES,vRAM
	XOR     DI,DI

	MOV     CH,100
	MOV     CL,160

@LOOP:
	XOR     BH,BH
	MOV     BL,CL
	SUB     BL,BYTE(x0)
	ADD     BX,BX
	MOV     SI,WORD(cuadrado[BX])

	XOR     BH,BH
	MOV     BL,CH
	SUB     BL,BYTE(y0)
	ADD     BX,BX
	ADD     SI,WORD(cuadrado[BX])					{SI=(x-x0^2)+(y-y0^2)}

	XOR     BH,BH
	MOV     BL,CL
	SUB     BL,BYTE(x1)
	ADD     BX,BX
	MOV     AX,WORD(cuadrado[BX])

	XOR     BH,BH
	MOV     BL,CH
	SUB     BL,BYTE(y1)
	ADD     BX,BX
	ADD     AX,WORD(cuadrado[BX])         {AX=(x-x1^2)+(y-y0^2)}

	IMUL    SI                            {DX=(x-x1^2)+(y-y0^2)*SI}
	CMP			DX,MAX_COLORS 								{if DX>64 then continue;}
	JAE     @CERO
	MOV     DH,DL
	MOV     ES:[DI],DX
	MOV     ES:[DI+320],DX

@CERO:
	ADD			DI,2

	DEC     CL
	JNZ     @LOOP

	ADD			DI,320
	MOV     CL,160

	DEC     CH
	JNZ     @LOOP
END;*)

procedure PutBlob(x0,y0,x1,y1,x2,y2:integer);ASSEMBLER;
ASM
	MOV     ES,vRAM
	XOR     DI,DI

	MOV     CH,100
	MOV     CL,160

@LOOP:
	XOR     BH,BH
	MOV     BL,CL
	SUB     BL,BYTE(x0)
	ADD     BX,BX
	MOV     SI,WORD(cuadrado[BX])

	XOR     BH,BH
	MOV     BL,CH
	SUB     BL,BYTE(y0)
	ADD     BX,BX
	ADD     SI,WORD(cuadrado[BX])					{SI=(x-x0^2)+(y-y0^2)}

	XOR     BH,BH
	MOV     BL,CL
	SUB     BL,BYTE(x1)
	ADD     BX,BX
	MOV     DX,WORD(cuadrado[BX])

	XOR     BH,BH
	MOV     BL,CH
	SUB     BL,BYTE(y1)
	ADD     BX,BX
	ADD     DX,WORD(cuadrado[BX])					{DX=(x-x1^2)+(y-y1^2)}

	XOR     BH,BH
	MOV     BL,CL
	SUB     BL,BYTE(x2)
	ADD     BX,BX
	MOV     AX,WORD(cuadrado[BX])

	XOR     BH,BH
	MOV     BL,CH
	SUB     BL,BYTE(y2)
	ADD     BX,BX
	ADD     AX,WORD(cuadrado[BX])         {AX=(x-x2^2)+(y-y2^2)}

	IMUL		DX
	SHL			DX,2
	MOV 		AX,DX
	IMUL    SI
	SHL			DX,2
	CMP			DX,MAX_COLORS
	JA			@CERO
	MOV     DH,DL
	MOV     ES:[DI],DX
	MOV     ES:[DI+320],DX

@CERO:
	ADD			DI,2

	DEC     CL
	JNZ     @LOOP

	ADD			DI,320
	MOV     CL,160

	DEC     CH
	JNZ     @LOOP
END;

procedure go;
var
	cx,cy,ca,
	x1,y1,m1,a1,
	x2,y2,m2,a2,
	x3,y3,
	a,d,n,s:integer;
	c,c1:Tpal;

begin
	StartCrono;
	ClearVideo;
	SetTransferMode(COPY_BACKGROUND_BLUR);

	if not LoadPal(c,'BLOBS.RGB') then error('BLOBS.RGB');
	if not LoadIMG('BLOBS.IMG',BackPage,c1) then error('BLOBS.IMG');
	for n:=64 to 255 do c[n]:=c1[n];
	c[0]:=white;
	InkAllRGB(0,255,c);
	border(255);

	for n:=0 to 127 do cuadrado[n]:=sqr(n);
	for n:=128 to 255 do cuadrado[n]:=sqr(256-n);

	m1:=32;a1:=-2;
	m2:=16;a2:=1;
	a:=180;

	SkipFrames:=StartFrame;
	n:=0;main.i:=FALSE;
	repeat
		s:=GetSemaphore(15);
		if (s=FLASH) or (s=FADE) then
			blanking
		else
			if not main.i then InkAllRGB(0,255,c);

		for d:=1 to SkipFrames do
			begin
				x3:=80-(m2*sine[COSINE+a]) div ESCALE;
				y3:=50+(m1*sine[a]) div ESCALE;

				x2:=80+(m1*sine[a]) div ESCALE;
				y2:=50+(m2*sine[COSINE+a]) div ESCALE;

				x1:=80+(m2*sine[(a+180) mod DEG]) div ESCALE;
				y1:=50+(m1*sine[(COSINE+a+180) mod DEG+90]) div ESCALE;

				inc(m1,a1);
				if (m1<1) or (m1>75) then a1:=-a1;

				inc(m2,a2);
				if (m2<1) or (m2>100) then a2:=-a2;

				inc(a);
				if a>DEG then dec(a,DEG);

				inc(n);
				if (n=300) and not (main.i) then
					begin
						InitDifumine(0,255,BlackPal);
						main.i:=TRUE;
					end;
			end;

		PutBlob(x1,y1,x2,y2,x3,y3);

		if inkey[K_ESC] then halt;

		if (main.i) and (main.difumine) then break;

		SkipFrames:=anima;
	until StopCrono>times[main.BLOBS];
	{$IFDEF _DEBUG_}
	WriteLn(fich,'BLOBS: ',StopCrono,' ',n);
	{$ENDIF}

	border(0);
end;

end.