///////////////////////////////////////////////
// Copyright
///////////////////////////////////////////////
//
// TextFX4
// Copyright (c) 1995-2001 Jari Komppa
//
//
///////////////////////////////////////////////
// License
///////////////////////////////////////////////
// 
//     This software is provided 'as-is', without any express or implied
//     warranty.    In no event will the authors be held liable for any damages
//     arising from the use of this software.
// 
//     Permission is granted to anyone to use this software for any purpose,
//     including commercial applications, and to alter it and redistribute it
//     freely, subject to the following restrictions:
// 
//     1. The origin of this software must not be misrepresented; you must not
//        claim that you wrote the original software. If you use this software
//        in a product, an acknowledgment in the product documentation would be
//        appreciated but is not required.
//     2. Altered source versions must be plainly marked as such, and must not be
//        misrepresented as being the original software.
//     3. This notice may not be removed or altered from any source distribution.
// 
// (eg. same as ZLIB license)
// 
//
///////////////////////////////////////////////

#include <stdlib.h>
#include <assert.h>
#include "textfx.h"


///////////////////////////////////////////////
// Global data & variables
//

#include "tfx_fontdata.h"

///////////////////////////////////////////////
// Functions
//

TFX_AsciiArt::TFX_AsciiArt()
{
    mAsciiMap=NULL;
}

TFX_AsciiArt::~TFX_AsciiArt()
{
    delete[] mAsciiMap;
}


short int TFX_AsciiArt::CalcColor(int /*red*/, int green, int /*blue*/) 
{
    assert(mAsciiMap!=NULL);
    int c = ((green>>4)<<12)+
            ((green>>4)<<8)+
            ((green>>4)<<4)+
            ((green>>4));

    return mAsciiMap[c];
}

#define IS_BIT(a,b) (((a)&(1<<(7-(b))))?1:0)


// This is _old_ code, and I don't feel like rewriting it at the moment.

void TFX_AsciiArt::BuildLUT(int aFlags)
{
    int startchar=0;
    int endchar=255;
    if (aFlags&TFX_AA_IBMSCII_PRINTABLES || aFlags&TFX_AA_PURE_ASCII)
        startchar=32;
    if (aFlags&TFX_AA_PURE_ASCII)
        endchar=126;
    int a,b,c,d,e,f,g,h,i;  
    int * reg;
    reg = new int[256*4]; // allocate memory for font analyse data 
    unsigned char * pchar = (unsigned char *)TFX_AsciiFontdata;    
    pchar += startchar * 12;
    if (mAsciiMap != NULL)       // regenerating? 
        delete[] mAsciiMap;
    mAsciiMap = new short[65536*2]; // allocate the look-up table 
    // Step one: analyse font 
    for (a=startchar;a<(endchar+1);a++) 
    {
        e=0;
        for (b=0;b<6;b++)
            for (c=0;c<4;c++)
                e+=IS_BIT(*(pchar+b),c);
        *(reg+a*4+0)=(e*16)/24;
        e=0;
        for (b=0;b<6;b++)
            for (c=0;c<4;c++)
                e+=IS_BIT(*(pchar+b),c+4);
        *(reg+a*4+1)=(e*16)/24;
        e=0;
        pchar+=6;
        for (b=0;b<6;b++)
            for (c=0;c<4;c++)
                e+=IS_BIT(*(pchar+b),c);
        *(reg+a*4+2)=(e*16)/24;
        e=0;
        for (b=0;b<6;b++)
            for (c=0;c<4;c++)
                e+=IS_BIT(*(pchar+b),c+4);
        *(reg+a*4+3)=(e*16)/24;
        pchar+=6;
    }
    // Step two: build lookup table with the good old nearest-value mess 
    for (a=0;a<16;a++) 
    {
        for (b=0;b<16;b++)
        {
            for (c=0;c<16;c++)
            {
                for (d=0;d<16;d++) 
                {
                    f=0xffff;
                    g=0;
                    for (h=startchar;h<(endchar+1);h++) 
                    {
                        i=abs(*(reg+h*4+0)-a)+abs(*(reg+h*4+1)-b)+abs(*(reg+h*4+2)-c)+abs(*(reg+h*4+3)-d);
                        if (i<f) 
                        {
                            f=i;
                            g=h;
                        }
                    }
                    *(mAsciiMap+(a<<12)+(b<<8)+(c<<4)+d)=(short)(0x0700+g);
                }
            }            
        }
    }
    delete[] reg;   
}


void TFX_AsciiArt::Dump1x(int *aSource, TFXQuad &aSrcQuad, int aSrcPitch, int aTgtX0, int aTgtY0, short *aTarget)
{
    assert(mAsciiMap!=NULL);
    int xsize = (aSrcQuad.x1 - aSrcQuad.x0);
    int ysize = (aSrcQuad.y1 - aSrcQuad.y0);
    int sourceyofs = aSrcQuad.y0 * aSrcPitch;

    for (int y = 0; y < ysize; y++, sourceyofs += aSrcPitch)
    {
        for (int x = 0, targetpos=(aTgtY0 + y) * TFX_ConsoleWidth + aTgtX0, sourcepos = sourceyofs + aSrcQuad.x0; x < xsize; x++, targetpos++, sourcepos++)
        {
            int c1 = (aSource[sourcepos]>>8)&0xff;

            int c=((c1>>4)<<12)+
                  ((c1>>4)<<8)+
                  ((c1>>4)<<4)+
                  ((c1>>4));

            aTarget[targetpos] = mAsciiMap[c];                                 
                                 
        }
    }
}


void TFX_AsciiArt::Dump2x(int *aSource, TFXQuad &aSrcQuad, int aSrcPitch, int aTgtX0, int aTgtY0, short *aTarget)
{
    assert(mAsciiMap!=NULL);
    int xsize = (aSrcQuad.x1 - aSrcQuad.x0) / 2;
    int ysize = (aSrcQuad.y1 - aSrcQuad.y0) / 2;
    int sourceyofs = aSrcQuad.y0 * aSrcPitch;

    for (int y = 0; y < ysize; y++, sourceyofs += aSrcPitch * 2)
    {
        for (int x = 0, targetpos=(aTgtY0 + y) * TFX_ConsoleWidth + aTgtX0, sourcepos = sourceyofs + aSrcQuad.x0; x < xsize; x++, targetpos++, sourcepos += 2)
        {
            int c1 = (aSource[sourcepos]>>8)&0xff;
            int c2 = (aSource[sourcepos + 1]>>8)&0xff;
            int c3 = (aSource[sourcepos + aSrcPitch]>>8)&0xff;
            int c4 = (aSource[sourcepos + aSrcPitch + 1]>>8)&0xff;

            int c=((c1>>4)<<12)+
                  ((c2>>4)<<8)+
                  ((c3>>4)<<4)+
                  ((c4>>4));

            aTarget[targetpos] = mAsciiMap[c];                                 
                                 
        }
    }
}

void TFX_AsciiArt::Dump4x(int *aSource, TFXQuad &aSrcQuad, int aSrcPitch, int aTgtX0, int aTgtY0, short *aTarget)
{
    assert(mAsciiMap!=NULL);
    int xsize = (aSrcQuad.x1 - aSrcQuad.x0) / 4;
    int ysize = (aSrcQuad.y1 - aSrcQuad.y0) / 4;
    int sourceyofs = aSrcQuad.y0 * aSrcPitch;

    for (int y = 0; y < ysize; y++, sourceyofs += aSrcPitch * 4)
    {
        for (int x = 0, targetpos=(aTgtY0 + y) * TFX_ConsoleWidth + aTgtX0, sourcepos = sourceyofs + aSrcQuad.x0; x < xsize; x++, targetpos++, sourcepos += 4)
        {
            int c1 = (aSource[sourcepos]>>8)&0xff;            
            c1    += (aSource[sourcepos + 1]>>8)&0xff;
            c1    += (aSource[sourcepos + aSrcPitch]>>8)&0xff;
            c1    += (aSource[sourcepos + aSrcPitch + 1]>>8)&0xff;
            c1   >>= 2;

            int c2 = (aSource[2 + sourcepos]>>8)&0xff;            
            c2    += (aSource[2 + sourcepos + 1]>>8)&0xff;
            c2    += (aSource[2 + sourcepos + aSrcPitch]>>8)&0xff;
            c2    += (aSource[2 + sourcepos + aSrcPitch + 1]>>8)&0xff;
            c2   >>= 2;

            int c3 = (aSource[aSrcPitch + sourcepos]>>8)&0xff;            
            c3    += (aSource[aSrcPitch + sourcepos + 1]>>8)&0xff;
            c3    += (aSource[aSrcPitch + sourcepos + aSrcPitch]>>8)&0xff;
            c3    += (aSource[aSrcPitch + sourcepos + aSrcPitch + 1]>>8)&0xff;
            c3   >>= 2;

            int c4 = (aSource[2 + aSrcPitch + sourcepos]>>8)&0xff;            
            c4    += (aSource[2 + aSrcPitch + sourcepos + 1]>>8)&0xff;
            c4    += (aSource[2 + aSrcPitch + sourcepos + aSrcPitch]>>8)&0xff;
            c4    += (aSource[2 + aSrcPitch + sourcepos + aSrcPitch + 1]>>8)&0xff;
            c4   >>= 2;

            int c=((c1>>4)<<12)+
                  ((c2>>4)<<8)+
                  ((c3>>4)<<4)+
                  ((c4>>4));

            aTarget[targetpos] = mAsciiMap[c];                                 
                                 
        }
    }
}
