/*
 * RAMFILE3 - fopen/fseek/ftell/fgetc/fread/fclose replacement to read
 *            from memory buffer.
 * Copyright 2001 Jari Komppa
 *
 * Note: assumes an external CFL * cfl; to exist.
 */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "cfl.h" 

#define cfl cfl

extern CFL * cfl;


typedef struct ramfile3struct {
  char * buffer;
  int offset;
  int length;
  int _flag;
} RAMFILE3;

RAMFILE3 * RAMfopen(char * buffer, int length)
{
  RAMFILE3 * t;
  if (buffer==NULL) return NULL;
  t=new RAMFILE3;
  t->buffer=buffer;
  t->offset=0;
  t->length=length;
  t->_flag=0;
  return t;
}

RAMFILE3 * RAMfopencfl(char * fname)
{
  RAMFILE3 * t;
  if (!cfl->fileExists(fname)) return NULL;
  t=new RAMFILE3;
  t->buffer=cfl->getFile(fname);
  t->offset=0;
  t->length=cfl->getFileSize(fname);
  t->_flag=0;
  return t;
}

int RAMfseek(RAMFILE3 * t, int displacement, int mode)
{
  if (t==NULL) return 1;
  t->_flag=0;
  switch (mode) {
  case SEEK_SET: t->offset=displacement; break;
  case SEEK_END: t->offset=t->length+displacement; break;
  case SEEK_CUR: t->offset+=displacement; break;
  }
  if (t->offset>t->length) {
    t->offset=t->length;
    t->_flag=0xffffffff;
  }
  if (t->offset<0) {
    t->offset=0;
    t->_flag=0xffffffff;
  }
  return 0;
}

int RAMftell(RAMFILE3 * t)
{
  if (t==NULL) return -1;
  return t->offset;
}

int RAMfgetc(RAMFILE3 * t)
{
  if (t==NULL) return EOF;
  t->_flag=0;
  if (t->offset>=t->length) return EOF;
  t->offset++;
  if (t->offset>t->length) {
    t->offset=t->length;
    t->_flag=0xffffffff;
  }
  return (*(t->buffer+t->offset-1));
}

int RAMfread(void * buf, int size, int count, RAMFILE3 * t)
{
  int l;
  if (t==NULL)
    return 0;
  t->_flag=0;
  l=size*count;
  if ((l+t->offset)>t->length)
    l=t->length-t->offset;
  memcpy((char*)buf,t->buffer+t->offset,l);
  t->offset+=l;
  return l/size;
}

int RAMfclose(RAMFILE3 * t)
{
  if (t==NULL) return EOF;
  delete[] t->buffer;
  delete t;
  return 0;
}

int RAMfclose_nofree(RAMFILE3 * t)
{
  if (t==NULL) return EOF;
  delete t;
  return 0;
}
