#version 330
#extension GL_ARB_explicit_uniform_location : enable

layout(location = 1) in vec4 vertexposition;
layout(location = 4) in float vox;

uniform mat4 mvp;

void main()
{
	if (vox < 1) 
	{
		gl_Position = vec4(0);
	}
	else
	{
		int x = gl_InstanceID % 64;
		int y = (gl_InstanceID / 64) % 64;
		int z = (gl_InstanceID / (64*64)) % 64;
		vec4 v = vertexposition + 2 * vec4(x - 32, y - 32, z - 32, 0);

		gl_Position = mvp * v;
	}
}
