#version 330
#extension GL_ARB_explicit_uniform_location : enable

layout(location = 1) in vec4 vertexposition;
layout(location = 2) in vec2 texcoord;
layout(location = 3) in vec4 worldpos;
layout(location = 4) in float spritesize;

uniform mat4 proj;
uniform mat4 view;
out vec4 pos;
out vec2 uv;
out float s;

void main()
{
    mat4 mvp = proj * view;

    vec3 cr = vec3(view[0][0],view[1][0],view[2][0]);
    vec3 cu = vec3(view[0][1],view[1][1],view[2][1]);
    float sz = spritesize * spritesize * 5;
    vec3 vp = worldpos.xyz + cr * vertexposition.x * sz + cu * vertexposition.y * sz;
    s = spritesize;
	uv = texcoord;
	pos = vec4(vp,1);
	gl_Position = mvp * pos;
}
