/*
/////////////////////////////////////////////////////////////////////////////////////////////////


	      	***************   scenes manager class definition ***************


/////////////////////////////////////////////////////////////////////////////////////////////////
*/
bool PaintBackBuffer();
class sceneManager
{
public:
	long nbs;		// number of scenes
	char *filenames[AF_MAX_SCENES];
	long currentScene;

	sceneManager()
	{
		nbs = 0;
		currentScene = 0;
		for(long i=0;i<AF_MAX_SCENES;i++)
			filenames[i]= NULL;
	}

	void add(char *sceneName)
	{
		long a=0;
		while(sceneName[a++] !=0);
		filenames[nbs] = new char[a];
		strcpy(filenames[nbs], sceneName);
		nbs++;
		if(nbs >= AF_MAX_SCENES) quitMessage("sceneManager::add","Too much scenes");
	}

	void deleteAllNames()
	{
		for(long i=0;i<nbs;i++)
		{
			scene[i].deleteObjectsNames();
			scene[i].deleteSurfacesNames();
			scene[i].deleteTexturesNames();
		}
	}

	// if return true quit program
	bool playList()
	{
		if(!scene[currentScene].play())
		{
			scene[currentScene].release4Play();
			currentScene++;
			if (currentScene>= nbs) 
			{
				if( demoMode ) 
				{
//					for(int i=0;i<nbs;i++) scene[i].releaseAll();	// bugy :o
					return true;
				}
				currentScene = 0;
			}
			scene[currentScene].init4Play();
		}
		else PaintBackBuffer();

		return false;
	}

	void sub(long ns)
	{
		delete filenames[ns];
		for(long i=(ns+1);i<nbs;i++)
		{
			filenames[i-1] = filenames[i];
		}
		nbs--;
		filenames[nbs] = NULL;
	}

	void initAll4Play()
	{
		long i;
		for(i=0;i<nbs;i++)
		{
			// init mapc
			for(long ro=0;ro<scene[i].nobject;ro++)
			{
				if( scene[i].entity[ro].type == 0)
				{
					if( scene[i].aObject[ro].dataLocation == &scene[i].aObject[ro] ) initMapc(&scene[i], ro, scene[i].surface, scene[i].texture);
				}
			}
		}
		for(i=0;i<nbs;i++)
		{
			for(long ro=0;ro<scene[i].nobject;ro++)
			{
				if( (scene[i].aObject[ro].dataLocation != &scene[i].aObject[ro] ) &&
					( scene[i].entity[ro].type == 0) )
				{
					scene[i].aObject[ro].mc = scene[i].aObject[ro].dataLocation->mc;
				}
			}
		}

		for(i=0;i<nbs;i++)
		{
			long tPoints = 0;
			long add = 0;
			for(long o=0;o<scene[i].nobject;o++)
			{
				if( scene[i].entity[o].type == 0 )
				{
					// make two things in that loop: init IDF buffer and calculate the allocation for points
					USHORT *r = scene[i].aObject[o].rel;
					USHORT val;
					for(long p=0;p<scene[i].aObject[o].nbf;p++)
					{
						val = scene[i].aObject[o].IDF[p];
							scene[i].aObject[o].IDF[p] = scene[i].aObject[o].oss[val];

						tPoints += *r;
						r += *r+1;
					}
//					delete scene[i].aObject[o].oss;
//					scene[i].aObject[o].oss = NULL;
					add += scene[i].aObject[o].nbf*6;
/* add six points:
	6 because of 5 clip plane: left, up, right, bottom and zcut
	+ one additionnal point for closing polygon(used in clipping)
*/
				}
			}
			scene[i].allocPoint = tPoints;

//			init surfaces :)
			for(long wh=0;wh<scene[i].nsurface;wh++)
			{
				if( (scene[i].surface[wh].flags & AF_FLAGS_GOUR ) )
				{
					// Gouraud prevail on flat
					scene[i].surface[wh].flags &= ~AF_FLAGS_FLAT;
					// init number of additionnals values to clip
					scene[i].surface[wh].nValue = 4;
					if( (scene[i].surface[wh].flags & (AF_FLAGS_FMAP | AF_FLAGS_TMAP) ) )
						scene[i].surface[wh].nValue = 6;
				}
				else if( (scene[i].surface[wh].flags & (AF_FLAGS_FMAP | AF_FLAGS_TMAP) ) )
				{
					// Texture prevail on flat
					scene[i].surface[wh].flags &= ~AF_FLAGS_FLAT;
					scene[i].surface[wh].nValue =6;
				}
				else scene[i].surface[wh].nValue =3;

			}
//	-		-------------------------------

		}

		// lets check some errors while loading and correct it :)
		for(i=0;i<nbs;i++)
		{
			for(long e=0;e<scene[i].nobject;e++)
			{
				if( scene[i].entity[e].type == 0 )
				{
					for(long re=0;re<scene[i].aObject[e].nosurf;re++)
					{
						ULONG & f = scene[i].surface[ scene[i].aObject[e].oss[re] ].flags;
						if( (f & (AF_FLAGS_TMAP | AF_FLAGS_FMAP) ) )
						{
							if( scene[i].aObject[e].mc == NULL ) f &= ~(AF_FLAGS_TMAP | AF_FLAGS_FMAP);
						}

						if( f & AF_FLAGS_GOUR )
						{
							if( scene[i].aObject[e].pNormals == NULL ) f &= ~(AF_FLAGS_GOUR);
						}

					}
					delete scene[i].aObject[e].oss;
					scene[i].aObject[e].oss = NULL;
				}
			}
		}
	}

}scnMan;
