	// all informations that are common to object, light and camera
class ent
{
public:
	long type;
	char flags;
	char sousType;	// 0 normal , 1 quad object type
/*
		flags bits:
		0:	static object	// object is static for that frame

		type values:
		0:	object
		1:	light
		2:	camera
		3:	null object
		4:	particles source
		5:	lens flare
*/
	float dissolve;
	long Parent;
	ChanVec	currentFrame;
	float pivotx, pivoty, pivotz;
//		Matrixs buffers
	float *matrix_Object;	// matrice de rotation/stretch/pivots
	float *matrix_OW;		// matrice de rotation/stretch/pivots/translations/parents
	float *matrix_ObjectWorld;	// matrice rotation/stretch/pivots/translations/parents/camera
	float *matrix_Normal;		// matrice de rotation
	float *matrix_NormalW;		// matrice de rotation/parents
	float *matrix_NormalWorld;	// matrice de rotation/parents/camera

	float *matrix_iO;		// matrice inverse de rotation/stretch/pivots
	float *matrix_iOWorld;	// matrice inverse de rotation/stretch/pivots/translations/parents

//		---------------------------
	Motion anim;	// see momoth.h
	Motion Diss;	// dissolve animation memory
	// methods :
	ent();

	void getCommonMatrix();
	void fillMatrixGL(float, float, float, float, float, float, float *);
	void getCameraMatrixGL(double, double, double);
	void getMatrixToWorldGL();
	void getCommonMatrixGL();

	~ent();
};

//	-----------------------	entities methods ------------------------------
ent::ent()
{
	flags = 0;
	sousType = 0;
	anim.keylist = NULL;
	for(long i=0;i<9;i++) currentFrame[i] = FLT_MAX;// this should never happend :)
	matrix_Object = new float[16];
	matrix_ObjectWorld = new float[16];

	matrix_Normal = new float[16];
	matrix_NormalWorld = new float[16];
	matrix_NormalW = new float[16];

	matrix_iOWorld = new float[16];
	matrix_iO = new float[16];
	matrix_OW = new float[16];

	pivotz = pivoty = pivotx = 0;
	Diss.keys = 0;
	dissolve = 1.0;	// 1.0 = opaque
}

void ent::getCommonMatrix()
{
	float aX,aY,aZ;
	float matrix_Xaxis[16];
	float matrix_Yaxis[16];
	float matrix_Zaxis[16];
	float matrix_Translation[16];

	setToIdentity(matrix_Translation);
	matrix_Translation[12] = pivotx;
	matrix_Translation[13] = pivoty;
	matrix_Translation[14] = pivotz;

	// stretch, matrixs rules!!
	matrix_Translation[0]  *= (float)currentFrame[6];
	matrix_Translation[5]  *= (float)currentFrame[7];
	matrix_Translation[10] *= (float)currentFrame[8];


	aX = -(float)(currentFrame[4])*(float)(pi/180);
	aY =  (float)(currentFrame[3])*(float)(pi/180);
	aZ = -(float)(currentFrame[5])*(float)(pi/180);
	float cosVal, sinVal;

	cosVal = (float)cos(aX);
	sinVal = (float)sin(aX);
	setToIdentity(matrix_Xaxis);
	matrix_Xaxis[5] = cosVal;
	matrix_Xaxis[6] = sinVal;
	matrix_Xaxis[9] = -sinVal;
	matrix_Xaxis[10] = cosVal;

	cosVal = (float)cos(aY);
	sinVal = (float)sin(aY);
	setToIdentity(matrix_Yaxis);
	matrix_Yaxis[0] = cosVal;
	matrix_Yaxis[2] = -sinVal;
	matrix_Yaxis[8] = sinVal;
	matrix_Yaxis[10] = cosVal;

	cosVal = (float)cos(aZ);
	sinVal = (float)sin(aZ);
	setToIdentity(matrix_Zaxis);
	matrix_Zaxis[0] = cosVal;
	matrix_Zaxis[1] = sinVal;
	matrix_Zaxis[4] = -sinVal;
	matrix_Zaxis[5] = cosVal;

	copyMatrix(matrix_Normal, matrix_Zaxis);
	matrix_Normal = matmult( matrix_Normal, matrix_Xaxis);
	matrix_Normal = matmult( matrix_Normal, matrix_Yaxis);

	copyMatrix(matrix_Object, matrix_Translation);
	matrix_Object = matmult( matrix_Object, matrix_Normal);

	// now get inverse matrix
	setToIdentity(matrix_Translation);
	matrix_Translation[12] = -pivotx;
	matrix_Translation[13] = -pivoty;
	matrix_Translation[14] = -pivotz;

	aX =  (float)(currentFrame[4])*(float)(pi/180);
	aY = -(float)(currentFrame[3])*(float)(pi/180);
	aZ =  (float)(currentFrame[5])*(float)(pi/180);
	
	cosVal = (float)cos(aX);
	sinVal = (float)sin(aX);
	setToIdentity(matrix_Xaxis);
	matrix_Xaxis[5] = cosVal;
	matrix_Xaxis[6] = sinVal;
	matrix_Xaxis[9] = -sinVal;
	matrix_Xaxis[10] = cosVal;

	cosVal = (float)cos(aY);
	sinVal = (float)sin(aY);
	setToIdentity(matrix_Yaxis);
	matrix_Yaxis[0] = cosVal;
	matrix_Yaxis[2] = -sinVal;
	matrix_Yaxis[8] = sinVal;
	matrix_Yaxis[10] = cosVal;

	cosVal = (float)cos(aZ);
	sinVal = (float)sin(aZ);
	setToIdentity(matrix_Zaxis);
	matrix_Zaxis[0] = cosVal;
	matrix_Zaxis[1] = sinVal;
	matrix_Zaxis[4] = -sinVal;
	matrix_Zaxis[5] = cosVal;

	float stretchMat[16];
	setToIdentity(stretchMat);
	stretchMat[0] = 1/(float)currentFrame[6];
	stretchMat[5] = 1/(float)currentFrame[7];
	stretchMat[10] = 1/(float)currentFrame[8];

	copyMatrix(matrix_iO, matrix_Yaxis);
	matrix_iO = matmult( matrix_iO, matrix_Xaxis);
	matrix_iO = matmult( matrix_iO, matrix_Zaxis);
	matrix_iO = matmult( matrix_iO, matrix_Translation);
	matrix_iO = matmult( matrix_iO, stretchMat);

}


// calculate matrix using opengl extensions :)
void ent::getCameraMatrixGL(double aX, double aY, double aZ)
{
	glLoadIdentity();

	glRotated(aZ, 0, 0, 1);
	glRotated(aX, 1, 0, 0);
	glRotated(aY, 0, 1, 0);

	glTranslated(-currentFrame[0], currentFrame[1], -currentFrame[2]);
	glGetFloatv(GL_MODELVIEW_MATRIX, matrix_Object);
	copyMatrix(camG,matrix_Object);
}

// doesnt work :(
void ent::getCommonMatrixGL()
{
	glLoadIdentity();
	glTranslatef(pivotx,pivoty,pivotz);
	glRotated(currentFrame[3], 0, 1, 0);
	glRotated(-currentFrame[4], 1, 0, 0);
	glRotated(currentFrame[5], 0, 0, 1);
	glScaled(currentFrame[6],currentFrame[7],currentFrame[8]);
	glGetFloatv(GL_MODELVIEW_MATRIX, matrix_Object);

	// now get inverse matrix
	glLoadIdentity();
	glScaled(1/currentFrame[6],1/currentFrame[7],1/currentFrame[8]);
	glRotated(-currentFrame[5], 0, 0, 1);
	glRotated(currentFrame[4], 1, 0, 0);
	glRotated(-currentFrame[3], 0, 1, 0);
	glTranslatef(-pivotx,-pivoty,-pivotz);
	glGetFloatv(GL_MODELVIEW_MATRIX, matrix_iO);

//	SUPER CRAD!!!!!!!!!!!
	glLoadIdentity();
	glRotated(currentFrame[3], 0, 1, 0);
	glRotated(-currentFrame[4], 1, 0, 0);
	glRotated(currentFrame[5], 0, 0, 1);

	glGetFloatv(GL_MODELVIEW_MATRIX, matrix_Normal);


}

void ent::getMatrixToWorldGL()
{
	glLoadMatrixf(camG);
	glTranslated(currentFrame[0], -currentFrame[1], currentFrame[2]);
	glMultMatrixf(matrix_Object);
	glGetFloatv(GL_MODELVIEW_MATRIX,matrix_ObjectWorld);
}



ent::~ent()
{
	delete matrix_Object;
	delete matrix_ObjectWorld;
	delete matrix_Normal;
	delete matrix_NormalWorld;

	delete matrix_iOWorld;
	delete matrix_iO;

	delete matrix_OW;
	delete matrix_NormalW;

	matrix_Object = NULL;
	matrix_ObjectWorld = NULL;
	matrix_Normal = NULL;
	matrix_NormalWorld = NULL;
	matrix_NormalW = NULL;

	matrix_iOWorld = NULL;
	matrix_iO = NULL;

	matrix_OW = NULL;

	if( anim.keylist != NULL) delete anim.keylist;
	anim.keylist = NULL;
}
