/****************************************

	INI File reader
	code: pK
	http://solstice.scenesp.org

 ****************************************/

#include <stdio.h> 
#include <windows.h> 

class CIniFile
{

	public:
		CIniFile();
		~CIniFile();

		bool OpenIni(char *filename);

		bool WriteIni(char *seccion, char *key, const char *data, ...);
		char *ReadIni(char *seccion, char *key);

	private:
		char mFilename[MAX_PATH];

};

CIniFile::CIniFile() // Constructor
{
	
}

CIniFile::~CIniFile() // Destructor
{

}

bool CIniFile::OpenIni(char *filename)
{
	sprintf(mFilename, "%s", filename);
	return true;
}

bool CIniFile::WriteIni(char *seccion, char *key, const char *data, ...)
{

	char		strText[256];
	va_list		argumentPtr;	

	if (data == NULL) { return false; }
	
	va_start(argumentPtr, data);
	vsprintf(strText, data, argumentPtr);
	va_end(argumentPtr);

	return WritePrivateProfileString (seccion, key, strText, mFilename);
}

char *CIniFile::ReadIni(char *seccion, char *key)
{

	char ret[256];

	GetPrivateProfileString(seccion, key, "NULL", ret, 256, mFilename);	

	return ret;
}

/*
	if (!WritePrivateProfileString ("Section1", "FirstKey", "It all worked out okay.", configfile_pathname))
	{
		MessageBox(hdwnd, "error write ini file!", "Opciones", MB_OK);
	}
	else
	{
		MessageBox(hdwnd, "ini ok", "Opciones", MB_OK);
	}
 */