/******************************************************

	Reborn OpenGL Library
	code: pK^Reborn

 ******************************************************/

#include <windows.h>
#include <stdio.h>
#include <gl\gl.h>
#include <gl\glu.h>
#include <gl\glaux.h>

#pragma comment(lib, "opengl32.lib")
#pragma comment(lib, "glu32.lib")
#pragma comment(lib, "glaux.lib")

HDC			hDC=NULL;
HGLRC		hRC=NULL;
HWND		hWnd=NULL;
HINSTANCE	hInstance;

bool	keys[256];
bool	active=TRUE;
bool	fullscreen;

#include "sysfont.c"

typedef struct
{

	bool LeftButton;
	bool RightButton;

} tRebGLMouseState;

tRebGLMouseState RebGLMouseState;

LRESULT	CALLBACK WndProc(HWND, UINT, WPARAM, LPARAM);

void RebGL_Resize(GLsizei width, GLsizei height)
{
	RECT r;

	if (height==0) { height=1; }

	GetClientRect(hWnd, &r);
	glViewport(0, 0, r.right-r.left, r.bottom-r.top);

	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();

	gluPerspective(45.0f,(GLfloat)width/(GLfloat)height,0.1f,10000.0f);		

	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
}

bool RebGL_MustClose()
{
	if (keys[27]) { return true; }
	else { return false; }
}

void RebGL_Clear()
{

/*
	GetClientRect(hWnd, &r);
	//GLdouble gldAspect = (GLdouble) 800 / (GLdouble) 600;
	GLdouble gldAspect = (GLdouble) r.right-r.left / (GLdouble) r.bottom-r.top ;

	sprintf(text, "Client rect: %dx%d", r.right-r.left, r.bottom-r.top);
	//SetWindowText(hWnd, text);

	glMatrixMode (GL_PROJECTION);
	glLoadIdentity ();
	gluPerspective (90.0, gldAspect, 1.0, 4000.0);
			
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
	glMatrixMode (GL_MODELVIEW);
	glLoadIdentity();				
*/

	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);	// Clear The Screen And The Depth Buffer
	glLoadIdentity();					// Reset The View

}

void RebGL_Flip()
{
	SwapBuffers(hDC);
}

void RebGL_Close(GLvoid)
{	
	
	if (fullscreen)
	{		
		ChangeDisplaySettings(NULL,0);
		ShowCursor(TRUE);
	}

	if (hRC)
	{		
		if (!wglMakeCurrent(NULL,NULL))
		{
			MessageBox(hWnd,"Release Of DC And RC Failed.","RebGL Error",MB_OK | MB_ICONINFORMATION);
		}

		if (!wglDeleteContext(hRC))
		{			
			MessageBox(hWnd,"Release Rendering Context Failed.","RebGL Error",MB_OK | MB_ICONINFORMATION);
		}
		hRC=NULL;
	}
	
	if (hDC && !ReleaseDC(hWnd,hDC))
	{		
		MessageBox(hWnd,"Release Device Context Failed.","RebGL Error",MB_OK | MB_ICONINFORMATION);
		hDC=NULL;
	}

	if (hWnd && !DestroyWindow(hWnd))
	{
		MessageBox(hWnd,"Could Not Release hWnd.","RebGL Error",MB_OK | MB_ICONINFORMATION);
		hWnd=NULL;
	}

	if (!UnregisterClass("OpenGL",hInstance)) { hInstance=NULL; }

}

HWND RebGL_OpenFromHwnd(HWND hParent, char* title, int width, int height, int bits, bool fullscreenflag)
{
	GLuint		PixelFormat;
	WNDCLASS	wc;
	RECT		WindowRect;
	WindowRect.left=(long)0;
	WindowRect.right=(long)width;	
	WindowRect.top=(long)0;
	WindowRect.bottom=(long)height;	

	fullscreen=fullscreenflag;

	hInstance			= GetModuleHandle(NULL);
	wc.style			= CS_HREDRAW | CS_VREDRAW | CS_OWNDC;
	wc.lpfnWndProc		= (WNDPROC) WndProc;
	wc.cbClsExtra		= 0;
	wc.cbWndExtra		= 0;
	wc.hInstance		= hInstance;
	wc.hIcon			= LoadIcon(NULL, IDI_WINLOGO);
	wc.hCursor			= LoadCursor(NULL, IDC_ARROW);
	wc.hbrBackground	= NULL;
	wc.lpszMenuName		= NULL;
	wc.lpszClassName	= "RebGL";

	if (!RegisterClass(&wc))
	{		
		MessageBox(hParent,"Failed To Register The Window Class.","RebGL Error",MB_OK|MB_ICONEXCLAMATION);
		return FALSE;
	}

	hWnd = GetDlgItem(hParent, IDC_RENDER);

	if (hWnd == NULL)
	{		
		MessageBox(hParent,"Error creando la ventana de render!","RebGL Error",MB_OK|MB_ICONEXCLAMATION);
		return FALSE;
	}

	static	PIXELFORMATDESCRIPTOR pfd=
	{
		sizeof(PIXELFORMATDESCRIPTOR),
	    1,                                // version number 
	    PFD_DRAW_TO_WINDOW |              // support window 
	    PFD_SUPPORT_OPENGL |              // support OpenGL 
	    PFD_DOUBLEBUFFER,                 // double buffered 
	    PFD_TYPE_RGBA,                    // RGBA type 
	    24,                               // 24-bit color depth 
	    0, 0, 0, 0, 0, 0,                 // color bits ignored 
	    0,                                // no alpha buffer 
	    0,                                // shift bit ignored 
	    0,                                // no accumulation buffer 
	    0, 0, 0, 0,                       // accum bits ignored 
	    32,                               // 32-bit z-buffer     
	    0,                                // no stencil buffer 
	    0,                                // no auxiliary buffer 
	    PFD_MAIN_PLANE,                   // main layer 
	    0,                                // reserved 
	    0, 0, 0                           // layer masks ignored 
	};	
	
	if (!(hDC=GetDC(hWnd)))
	{		
		RebGL_Close();
		MessageBox(hParent,"Can't Create A GL Device Context.","RebGL Error",MB_OK|MB_ICONEXCLAMATION);
		return FALSE;
	}

	if (!(PixelFormat=ChoosePixelFormat(hDC,&pfd)))
	{		
		RebGL_Close();
		MessageBox(hParent,"Can't Find A Suitable PixelFormat.","RebGL Error",MB_OK|MB_ICONEXCLAMATION);
		return FALSE;
	}

	if(!SetPixelFormat(hDC,PixelFormat,&pfd))
	{
		RebGL_Close();
		MessageBox(hParent,"Can't Set The PixelFormat.","RebGL Error",MB_OK|MB_ICONEXCLAMATION);
		return FALSE;
	}	

	if (!(hRC=wglCreateContext(hDC)))
	{
		RebGL_Close();
		MessageBox(hParent,"Can't Create A GL Rendering Context.","RebGL Error",MB_OK|MB_ICONEXCLAMATION);
		return FALSE;
	}

	if(!wglMakeCurrent(hDC,hRC))
	{

		RebGL_Close();
		MessageBox(hParent,"Can't Activate The GL Rendering Context.","RebGL Error",MB_OK|MB_ICONEXCLAMATION);
		return FALSE;
	}

	//ShowWindow(hWnd,SW_SHOW);
	//SetForegroundWindow(hWnd);
	//SetFocus(hWnd);
	RebGL_Resize(width, height);

	// Set somes OpenGL config
	glEnable(GL_LIGHT0);
	glEnable(GL_LIGHTING);
	glEnable(GL_COLOR_MATERIAL);
	glShadeModel(GL_SMOOTH);
	glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
	glClearDepth(100);
	glEnable(GL_DEPTH_TEST);
	glDepthFunc(GL_LEQUAL);
	glHint(GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST);

	glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);

	glTexGeni(GL_S, GL_TEXTURE_GEN_MODE, GL_SPHERE_MAP);
	glTexGeni(GL_T, GL_TEXTURE_GEN_MODE, GL_SPHERE_MAP);	

	// Two mouse button not pushed
	RebGLMouseState.LeftButton = false;
	RebGLMouseState.RightButton = false;	

	return hWnd;
}

void RebGL_GetMouseState(bool &left, bool &right)
{

	left = RebGLMouseState.LeftButton;
	right = RebGLMouseState.RightButton;

}

LRESULT CALLBACK WndProc(	HWND	hWnd,
							UINT	uMsg,
							WPARAM	wParam,
							LPARAM	lParam)
{	

	switch (uMsg)
	{
		case WM_INITDIALOG:
			{
				RebGL_Clear();
			}			
			break;

		case WM_ACTIVATE:
		{
			if (!HIWORD(wParam))
			{
				SetClassLong(hWnd, GCL_HICON, (LONG)LoadIcon(NULL, IDI_APPLICATION));
				active=TRUE;
			}
			else
			{
				active=FALSE;
			}

			return 0;
		}

		case WM_SYSCOMMAND:
		{
			switch (wParam)
			{
				case SC_SCREENSAVE:
				case SC_MONITORPOWER:
				return 0;
			}
			break;
		}

		case WM_CLOSE:
		{
			PostQuitMessage(0);
			return 0;
		}

		case WM_LBUTTONUP: { RebGLMouseState.LeftButton = false; } break;
		case WM_LBUTTONDOWN: { RebGLMouseState.LeftButton = true; } break;		

		case WM_RBUTTONUP: { RebGLMouseState.RightButton = false; } break;
		case WM_RBUTTONDOWN: { RebGLMouseState.RightButton = true; } break;

		case WM_KEYDOWN:
		{
			keys[wParam] = TRUE;
			return 0;
		}

		case WM_KEYUP:
		{
			keys[wParam] = FALSE;
			return 0;
		}

		case WM_SIZE:
		{
			RebGL_Resize(LOWORD(lParam),HIWORD(lParam));			
			return 0;
		}
	}

	return DefWindowProc(hWnd,uMsg,wParam,lParam);
}