/*****************************************************************

	The Tool by solstice
	64k Intro Generation Tool
	code: pK
	http://solstice.scenesp.org

 *****************************************************************/

#pragma warning(disable : 4101)			// Unreferenced local variable
#pragma warning(disable : 4305)			// truncation from 'X'
#pragma warning(disable : 4309)			// truncation of constant value
#pragma warning(disable : 4018)			// signed/unsigned mismatch
#pragma warning(disable : 4244)			// conversion from 'double' to 'float', possible loss of data
#pragma warning(disable : 238)

using namespace std;

#include "stdafx.h"

#include "resource.h"

#include <windows.h>
#include <vector>
#include <crtdbg.h>
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <commctrl.h>
#include <mmsystem.h>
#include <shellapi.h>
#include <commdlg.h>
#include <shlwapi.h>
#include <shlobj.h>
#include <objbase.h>
#include <direct.h>

#include "inifile.h"
//#include "fmodcontrol.h"

#include "rebgl.c"	// todo el tema GL
#include "ptab.h" // las tabs de mierda

HINSTANCE inst=NULL;
HWND hMain=NULL;

#include "ddebug.c"

#define	CONFIG_FILENAME		"toolconfig.ini"	// Fichero de configuracion de la tool
char configfile_pathname[MAX_PATH];				// Ruta y nombre del fichero de configuracion

// Base engine ;)
#include "base2d.h"
#include "base3d.h"
#include "base2d.cpp"
#include "base3d.cpp"

#include "dlg_opciones.h"
#include "dlg_audio.h"

#include "DialogProc/dlg_render.h"
#include "DialogProc/dlg_render_textura.h"

#define WM_DORENDER WM_USER+1	// Usado para mensaje de RENDER a la ventana

// *** Escena ***
// Contadores (para dar nombres a los objetos)
int NumCilindros=0;
int NumConos=0;
int NumCubos=0;
int NumDiscos=0;
int NumEsferas=0;
int NumTerrenos=0;
int NumPlanos=0;
int NumTorus=0;

int NumCamaras=0;

int LastSelection=0; // ultima selecion (usado en DoRender) para no actualizar siempre los sliders y demas)

igtScene		GlobalScene;			// Escena principal (objetos geometricos)
igtSceneInfo	GlobalSceneInfo;		// Informacion de la escena
unsigned int	**EditorTextures;		// Almacena las texturas de la escena (ATG)

int				AnimationFrames=100;			// Numero de frames en la animacion
int				AnimationFrameRate=25;			// Velocidad de la animacion
DWORD			AnimationCurrentFrame=0;		// Frame actual de la animacion
char			RenderMode=0;					// 0: Polis, 1: wire
bool			RenderPlano=true;				// Dibujar plano de referencia
bool			RenderEjes=true;				// Dibujar ejes
bool			AnimationMode=false;			// Para saver si estamos animando o no
bool			EditorPlaying=false;			// Para saver si estamos reproduciendo la animacion o no
char			RenderCamara=0;				// Vistas del render -> 0: Perspectiva, 1, 2, 3 etc indice de la camara a renderizar
int				SelectedCamera=-1;				// Camara seleccionada actualmente (-1=ninguna)

// Rotacion mediante el raton
float			GlobalRender_RotacionX=0;
float			GlobalRender_RotacionY=30;
float			GlobalRender_LastRotacionX=0;
float			GlobalRender_LastRotacionY=0;

// Posicion mediante el raton
float			GlobalRender_PosicionX=0;
float			GlobalRender_PosicionY=0;
float			GlobalRender_PosicionZ=-10;
float			GlobalRender_LastPosicionX=0;
float			GlobalRender_LastPosicionY=0;
float			GlobalRender_LastPosicionZ=0;

#include "editor_memory.h"
#include "editor_utils.h"			// Varias funciones prpias del editor
#include "editor_io.h"				// Cargar/Guardar proyectos

// *** Control de la ventanas de los generadores
#include "DialogProc/dlg_gen_esfera.h"
#include "DialogProc/dlg_gen_torus.h"
#include "DialogProc/dlg_gen_cilindro.h"
#include "DialogProc/dlg_gen_cono.h"
#include "DialogProc/dlg_gen_disco.h"
#include "DialogProc/dlg_gen_plano.h"
#include "DialogProc/dlg_gen_terreno.h"
#include "DialogProc/dlg_gen_cubo.h"
#include "DialogProc/dlg_gen_camara.h"

#include "DialogProc/dlg_text_crear.h"

#include "DialogProc/dlg_modif_mover.h"
#include "DialogProc/dlg_modif_rotar.h"

#include "DialogProc/dlg_proyecto_texturas.h"

#include "DialogProc/dlg_timeline_animacion.h"
#include "DialogProc/dlg_timeline_timeline.h"


// *** Globales
DWORD RenderTimer=0;

tPTAB TabGeneradores;
tPTAB TabGenTextura;
tPTAB TabRender;
tPTAB TabModificadores;
tPTAB TabProyecto;
tPTAB TabAnimacion;

void __stdcall atg_callback(float f)
{

}

bool EditorLoadATGfromDisk(char *filename)
{

	FILE *in;
	unsigned char *file_data;
	int total_size=0;

	unsigned char *atgList[2];

	DDEBUG_Write("Importando textura %s...", filename);

	in = fopen(filename, "rb");

	fseek(in, 0L, SEEK_END);
	total_size = ftell(in);	// Guardamos tamao total
	fseek(in, 0L, SEEK_SET);

	DDEBUG_Write("\t%d bytes", total_size);

	file_data = (unsigned char *)malloc(total_size*sizeof(unsigned char));

	if (file_data == NULL) 
	{ 
		DDEBUG_Write("\tNo hay memoria!");
		fclose(in); 
		return false; 
	}

	DDEBUG_Write("\tLeyendo datos...");

	// Guardamos los datos
	fread(&file_data, total_size, 1, in);

	DDEBUG_Write("\tPreparando lista");
	atgList[0] = file_data;
	atgList[1] = NULL;

	DDEBUG_Write("\tGenerando textura : %d", sizeof(atgList));	

	atgUseDisk=true; // PONER ESTO EN FALSE!!!
	unsigned int **texture = atgLoadList(atgList, atg_callback);

	DDEBUG_Write("\tLimpiando...");
	free(file_data);

	fclose(in);

	DDEBUG_Write("\tTextura Cargada");

	return true;

}

// Funcion principal que renderiza la escena
void DoRender()
{	

	// Recuperamos el indice del objeto selecionado actualmente
	int ObjSel = SendDlgItemMessage(hMain, IDC_LIST_OBJETOS, LB_GETCURSEL, 0, 0);

	if (RenderCamara == 0) // Solo se mueve con el raton si estamos en vista perspectiva
	{
		// Rotacion global
		if (Render_IsLMouseDown)
		{
			GlobalRender_RotacionX = GlobalRender_LastRotacionX+(Render_MouseXpos - Render_MouseLastXpos);
			GlobalRender_RotacionY = GlobalRender_LastRotacionY+(Render_MouseYpos - Render_MouseLastYpos);
		}
		else
		{
			GlobalRender_LastRotacionX =  GlobalRender_RotacionX;
			GlobalRender_LastRotacionY =  GlobalRender_RotacionY;
		}

		// Posicion global
		if (Render_IsRMouseDown)
		{
			/*		
			GlobalRender_PosicionZ = GlobalRender_LastPosicionZ+(Render_MouseYpos - Render_MouseLastYpos)/4;		
			GlobalRender_PosicionX = GlobalRender_LastPosicionX+(Render_MouseXpos - Render_MouseLastXpos)/4;		
			*/

			if (keys['z'])
			{
				GlobalRender_PosicionY = GlobalRender_LastPosicionY+(Render_MouseYpos - Render_MouseLastYpos)/4;		
				GlobalRender_PosicionX = GlobalRender_LastPosicionX+(Render_MouseXpos - Render_MouseLastXpos)/4;		
			}
			else
			{
				GlobalRender_PosicionZ = GlobalRender_LastPosicionZ+(Render_MouseYpos - Render_MouseLastYpos)/4;		
				GlobalRender_PosicionX = GlobalRender_LastPosicionX+(Render_MouseXpos - Render_MouseLastXpos)/4;		
			}
		}
		else
		{
			// Guardarmos la ultima posicion establidas
			GlobalRender_LastPosicionZ =  GlobalRender_PosicionZ;
			GlobalRender_LastPosicionX =  GlobalRender_PosicionX;
		}

	} // RenderCamara

	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);	// Clear The Screen And The Depth Buffer
	glLoadIdentity();					// Reset The View

	if (AnimationMode) { RenderAnimRectangle(); } // Recuadro rojo si estamos en modo animacion

	if (RenderCamara == 0)
	{
		glDrawText(5, 260-FONT_HEIGHT-5, "Perspectiva");
		glDrawText(5, 260-5, "Frame %d/%d (%dfps)", AnimationCurrentFrame, AnimationFrames, AnimationFrameRate);
	}
	else
	{
		glDrawText(5, 260-FONT_HEIGHT-5, "Vista: Camara %02d", RenderCamara);		
	}

	
	glPushMatrix();		

		if (RenderCamara == 0) // Perspectiva
		{

			// Posicionamiento global		
			glTranslatef(GlobalRender_PosicionX, GlobalRender_PosicionY, GlobalRender_PosicionZ);			
			glRotatef(GlobalRender_RotacionY, 1, 0, 0);				
			glRotatef(GlobalRender_RotacionX, 0, 1, 0);					

		}
		else // Vista de camara
		{

			glMatrixMode(GL_PROJECTION);
			glLoadIdentity();

			gluPerspective(120.0f,(GLfloat)800/(GLfloat)600,0.1f,10000.0f);		

			glMatrixMode(GL_MODELVIEW);
			glLoadIdentity();

			/*
			gluLookAt(GlobalScene.Camera[SelectedCamera-1].Position.x, 
					  GlobalScene.Camera[SelectedCamera-1].Position.y,
					  GlobalScene.Camera[SelectedCamera-1].Position.z,
					  GlobalScene.Camera[SelectedCamera-1].Target.x,
					  GlobalScene.Camera[SelectedCamera-1].Target.y,
					  GlobalScene.Camera[SelectedCamera-1].Target.z,
					  0, 1, 0);
			*/

			gluLookAt(GlobalScene.Camera[0].Position.x, 
					  GlobalScene.Camera[0].Position.y,
					  GlobalScene.Camera[0].Position.z,
					  GlobalScene.Camera[0].Target.x,
					  GlobalScene.Camera[0].Target.y,
					  GlobalScene.Camera[0].Target.z,
					  0, 1, 0);

			DrawCameraRectangleView();
			
		}
		

		DrawQuadricula();

		glEnable(GL_TEXTURE_2D);
		glBindTexture(GL_TEXTURE_2D, Textures[0]);		
		glEnable(GL_LIGHTING);
		
		int i;

		for (int obj=0 ; obj<GlobalScene.NumObjects ; obj++)
		{

			glPushMatrix();			

			// Controlamos la animacion del objeto
			if (GlobalScene.Object[obj].kPosicion.GetKeyCount() > 0)
			{
				float px, py, pz;

				// Draw curve
				glDisable(GL_TEXTURE_2D);
				glDisable(GL_LIGHTING);
				glBegin(GL_LINES);
				glColor3f(1, 0, 0);
				for (i=0 ; i<GlobalScene.Object[obj].kPosicion.GetCurveCount()-2 ; i++)
				{

					px = GlobalScene.Object[obj].kPosicion.GetCurve(i).x;
					py = GlobalScene.Object[obj].kPosicion.GetCurve(i).y;
					pz = GlobalScene.Object[obj].kPosicion.GetCurve(i).z;					
					
					glVertex3f(px, py, pz);

					px = GlobalScene.Object[obj].kPosicion.GetCurve(i+1).x;
					py = GlobalScene.Object[obj].kPosicion.GetCurve(i+1).y;
					pz = GlobalScene.Object[obj].kPosicion.GetCurve(i+1).z;					
					
					glVertex3f(px, py, pz);
				}
				glEnd();

				glPointSize(5);
				glBegin(GL_POINTS);				
				glColor3f(0, 1, 0);

				for (i=0 ; i<GlobalScene.Object[obj].kPosicion.GetCurveCount() ; i++)
				{
					px = GlobalScene.Object[obj].kPosicion.GetCurve(i).x;
					py = GlobalScene.Object[obj].kPosicion.GetCurve(i).y;
					pz = GlobalScene.Object[obj].kPosicion.GetCurve(i).z;					
					
					glVertex3f(px, py, pz);					
				}

				glEnd();

				glEnable(GL_TEXTURE_2D);
				glEnable(GL_LIGHTING);
				glColor3f(1, 1, 1);

				// * Posicion
				if (AnimationCurrentFrame > GlobalScene.Object[obj].kPosicion.GetCurveCount())
				{
					// Ultima key vlida
					//float lastCurveKey = GlobalScene.Object[obj].kPosicion.GetCurveCount()-1;
					float lastCurveKey = 0;

					px = GlobalScene.Object[obj].kPosicion.GetCurve(lastCurveKey).x;
					py = GlobalScene.Object[obj].kPosicion.GetCurve(lastCurveKey).y;
					pz = GlobalScene.Object[obj].kPosicion.GetCurve(lastCurveKey).z;
				}
				else
				{
					px = GlobalScene.Object[obj].kPosicion.GetCurve(AnimationCurrentFrame).x;
					py = GlobalScene.Object[obj].kPosicion.GetCurve(AnimationCurrentFrame).y;
					pz = GlobalScene.Object[obj].kPosicion.GetCurve(AnimationCurrentFrame).z;
				}

				// * Rotacion
				// VACIO

				glTranslatef(px, py, pz);

				glRotatef(GlobalScene.Object[obj].Rotacion.x, 1, 0, 0);				
				glRotatef(GlobalScene.Object[obj].Rotacion.y, 0, 1, 0);				
				glRotatef(GlobalScene.Object[obj].Rotacion.z, 0, 0, 1);							
			}
			else
			{
				glTranslatef(GlobalScene.Object[obj].Posicion.x, GlobalScene.Object[obj].Posicion.y, GlobalScene.Object[obj].Posicion.z);
				glRotatef(GlobalScene.Object[obj].Rotacion.x, 1, 0, 0);				
				glRotatef(GlobalScene.Object[obj].Rotacion.y, 0, 1, 0);				
				glRotatef(GlobalScene.Object[obj].Rotacion.z, 0, 0, 1);							
			}

			// Cubo amarillo de selecin
			if (EditorSelectionInfo[ObjSel].type == EDITOR_TYPE_OBJECT) // Solo si es objeto (no camara etc)
			{
				if (EditorSelectionInfo[ObjSel].index == obj) // Si es el que estamos dibujando
				{
					DrawSelectionCube(EditorSelectionInfo[ObjSel].index);
				}
			}			

			if (RenderMode == 0) // Poligonos
			{
				glEnable(GL_TEXTURE_2D);
				glBegin(GL_TRIANGLES);
			}
			if (RenderMode == 1) // Wireframe
			{
				glDisable(GL_TEXTURE_2D);				
				glBegin(GL_LINE_STRIP);
			}
			
			for (i=0 ; i<GlobalScene.Object[obj].NumFaces ; i+=3)
			{
						
				glNormal3f(GlobalScene.Object[obj].Normal[GlobalScene.Object[obj].Faces[i]].x, GlobalScene.Object[obj].Normal[GlobalScene.Object[obj].Faces[i]].y, GlobalScene.Object[obj].Normal[GlobalScene.Object[obj].Faces[i]].z);
				glTexCoord2f(GlobalScene.Object[obj].TexCoord[GlobalScene.Object[obj].Faces[i]].x, GlobalScene.Object[obj].TexCoord[GlobalScene.Object[obj].Faces[i]].y);					
				glVertex3f(GlobalScene.Object[obj].Vertex[GlobalScene.Object[obj].Faces[i]].x, GlobalScene.Object[obj].Vertex[GlobalScene.Object[obj].Faces[i]].y, GlobalScene.Object[obj].Vertex[GlobalScene.Object[obj].Faces[i]].z);

				glNormal3f(GlobalScene.Object[obj].Normal[GlobalScene.Object[obj].Faces[i+1]].x, GlobalScene.Object[obj].Normal[GlobalScene.Object[obj].Faces[i+1]].y, GlobalScene.Object[obj].Normal[GlobalScene.Object[obj].Faces[i+1]].z);
				glTexCoord2f(GlobalScene.Object[obj].TexCoord[GlobalScene.Object[obj].Faces[i+1]].x, GlobalScene.Object[obj].TexCoord[GlobalScene.Object[obj].Faces[i+1]].y);					
				glVertex3f(GlobalScene.Object[obj].Vertex[GlobalScene.Object[obj].Faces[i+1]].x, GlobalScene.Object[obj].Vertex[GlobalScene.Object[obj].Faces[i+1]].y, GlobalScene.Object[obj].Vertex[GlobalScene.Object[obj].Faces[i+1]].z);

				glNormal3f(GlobalScene.Object[obj].Normal[GlobalScene.Object[obj].Faces[i+2]].x, GlobalScene.Object[obj].Normal[GlobalScene.Object[obj].Faces[i+2]].y, GlobalScene.Object[obj].Normal[GlobalScene.Object[obj].Faces[i+2]].z);
				glTexCoord2f(GlobalScene.Object[obj].TexCoord[GlobalScene.Object[obj].Faces[i+2]].x, GlobalScene.Object[obj].TexCoord[GlobalScene.Object[obj].Faces[i+2]].y);					
				glVertex3f(GlobalScene.Object[obj].Vertex[GlobalScene.Object[obj].Faces[i+2]].x, GlobalScene.Object[obj].Vertex[GlobalScene.Object[obj].Faces[i+2]].y, GlobalScene.Object[obj].Vertex[GlobalScene.Object[obj].Faces[i+2]].z);					

			}

			glEnd();

			glPopMatrix();

		}
				

		glDisable(GL_LIGHTING);
		glDisable(GL_TEXTURE_2D);

		// Renderizamos todas las camaras
		for (int cam=0 ; cam<GlobalScene.NumCameras ; cam++)
		{
			DrawCamera(GlobalScene.Camera[EditorSelectionInfo[cam].index].Position, 
				       GlobalScene.Camera[EditorSelectionInfo[cam].index].Target);
		}		

	glPopMatrix();

	// Dibuja el "play" si estamos reproduciendo la escena
	if (EditorPlaying) { DrawPlayIcon(); }

	SwapBuffers(hDC);	

	// Editor
	char text[256];	

	// Seleccion de objetos (cubo wireframe amarillo)
	if (ObjSel != LastSelection)
	{				

		// Pone los sliders en posicion segun el objeto (Solo si hay uno selecionado)
		if (ObjSel > -1)
		{

			//DDEBUG_Write("Seleccion: %d type: %d array index: %d", ObjSel, EditorSelectionInfo[ObjSel].type, EditorSelectionInfo[ObjSel].index);

			// Objeto comun
			if (EditorSelectionInfo[ObjSel].type == EDITOR_TYPE_OBJECT)
			{

				// Modificadores: Mover
				SendMessage(GetDlgItem(TabModificadores.DialogHandle[0], IDC_X), TBM_SETPOS, true, GlobalScene.Object[EditorSelectionInfo[ObjSel].index].Posicion.x*100);
				SendMessage(GetDlgItem(TabModificadores.DialogHandle[0], IDC_Y), TBM_SETPOS, true, GlobalScene.Object[EditorSelectionInfo[ObjSel].index].Posicion.y*100);
				SendMessage(GetDlgItem(TabModificadores.DialogHandle[0], IDC_Z), TBM_SETPOS, true, GlobalScene.Object[EditorSelectionInfo[ObjSel].index].Posicion.z*100);

				// Actualiza los labels
				sprintf(text, "X: %f", (float)GlobalScene.Object[EditorSelectionInfo[ObjSel].index].Posicion.x);
				SetWindowText(GetDlgItem(TabModificadores.DialogHandle[0], IDC_STATIC_X), text);		
				sprintf(text, "Y: %f", (float)GlobalScene.Object[EditorSelectionInfo[ObjSel].index].Posicion.y);
				SetWindowText(GetDlgItem(TabModificadores.DialogHandle[0], IDC_STATIC_Y), text);		
				sprintf(text, "Z: %f", (float)GlobalScene.Object[EditorSelectionInfo[ObjSel].index].Posicion.z);		
				SetWindowText(GetDlgItem(TabModificadores.DialogHandle[0], IDC_STATIC_Z), text);		

				// Modificadores: Rotar
				SendMessage(GetDlgItem(TabModificadores.DialogHandle[1], IDC_X), TBM_SETPOS, true, GlobalScene.Object[EditorSelectionInfo[ObjSel].index].Rotacion.x);
				SendMessage(GetDlgItem(TabModificadores.DialogHandle[1], IDC_Y), TBM_SETPOS, true, GlobalScene.Object[EditorSelectionInfo[ObjSel].index].Rotacion.y);
				SendMessage(GetDlgItem(TabModificadores.DialogHandle[1], IDC_Z), TBM_SETPOS, true, GlobalScene.Object[EditorSelectionInfo[ObjSel].index].Rotacion.z);
			}

			// Camara: Posicion
			if (EditorSelectionInfo[ObjSel].type == EDITOR_TYPE_CAMERA_POSITION)
			{

				// Modificadores: Mover
				SendMessage(GetDlgItem(TabModificadores.DialogHandle[0], IDC_X), TBM_SETPOS, true, GlobalScene.Camera[EditorSelectionInfo[ObjSel].index].Position.x*100);
				SendMessage(GetDlgItem(TabModificadores.DialogHandle[0], IDC_Y), TBM_SETPOS, true, GlobalScene.Camera[EditorSelectionInfo[ObjSel].index].Position.y*100);
				SendMessage(GetDlgItem(TabModificadores.DialogHandle[0], IDC_Z), TBM_SETPOS, true, GlobalScene.Camera[EditorSelectionInfo[ObjSel].index].Position.z*100);

				// Actualiza los labels
				sprintf(text, "X: %f", (float)GlobalScene.Camera[EditorSelectionInfo[ObjSel].index].Position.x);
				SetWindowText(GetDlgItem(TabModificadores.DialogHandle[0], IDC_STATIC_X), text);		
				sprintf(text, "Y: %f", (float)GlobalScene.Camera[EditorSelectionInfo[ObjSel].index].Position.y);
				SetWindowText(GetDlgItem(TabModificadores.DialogHandle[0], IDC_STATIC_Y), text);		
				sprintf(text, "Z: %f", (float)GlobalScene.Camera[EditorSelectionInfo[ObjSel].index].Position.z);		
				SetWindowText(GetDlgItem(TabModificadores.DialogHandle[0], IDC_STATIC_Z), text);		
			}

			// Camara: Objetivo
			if (EditorSelectionInfo[ObjSel].type == EDITOR_TYPE_CAMERA_TARGET)
			{

				// Modificadores: Mover
				SendMessage(GetDlgItem(TabModificadores.DialogHandle[0], IDC_X), TBM_SETPOS, true, GlobalScene.Camera[EditorSelectionInfo[ObjSel].index].Target.x*100);
				SendMessage(GetDlgItem(TabModificadores.DialogHandle[0], IDC_Y), TBM_SETPOS, true, GlobalScene.Camera[EditorSelectionInfo[ObjSel].index].Target.y*100);
				SendMessage(GetDlgItem(TabModificadores.DialogHandle[0], IDC_Z), TBM_SETPOS, true, GlobalScene.Camera[EditorSelectionInfo[ObjSel].index].Target.z*100);

				// Actualiza los labels
				sprintf(text, "X: %f", (float)GlobalScene.Camera[EditorSelectionInfo[ObjSel].index].Target.x);
				SetWindowText(GetDlgItem(TabModificadores.DialogHandle[0], IDC_STATIC_X), text);		
				sprintf(text, "Y: %f", (float)GlobalScene.Camera[EditorSelectionInfo[ObjSel].index].Target.y);
				SetWindowText(GetDlgItem(TabModificadores.DialogHandle[0], IDC_STATIC_Y), text);		
				sprintf(text, "Z: %f", (float)GlobalScene.Camera[EditorSelectionInfo[ObjSel].index].Target.z);		
				SetWindowText(GetDlgItem(TabModificadores.DialogHandle[0], IDC_STATIC_Z), text);		
			}
		

		}

		LastSelection = ObjSel;

	}

	// Update timeline workspace
	UpdateTimelineWorkspace();

	// Animacion workspace
	UpdateAnimacionWorkspace();

}

LRESULT CALLBACK LoadWindow(HWND hwnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{

	if ( (uMsg==WM_DESTROY) || // ALT+F4 pressed
		((uMsg==WM_KEYDOWN)&&(wParam==VK_ESCAPE))) 
	{ // ESC is pressed
		
	} 
	else 
	{
		return DefWindowProc(hwnd,uMsg,wParam,lParam);
	}
		
	return 0;
}

LRESULT CALLBACK AboutWindow(HWND hdwnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	switch (uMsg)
	{

		case WM_COMMAND:
		case WM_DESTROY:
			{						
				EndDialog(hdwnd, 0);			
				return TRUE;
			}
	}
	
	return FALSE;
}

// Aqui enviamos el mensaje de dibujado a la ventana principal
void CALLBACK RenderTimerProc(UINT uTimerID, UINT uMsg, DWORD dwUser, DWORD dw1, DWORD dw2) { SendMessage(hMain, WM_DORENDER, 0, 0); }

LRESULT CALLBACK dlgSplashProc(HWND hdwnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{

	static OPENFILENAME ofn;
	static char path[MAX_PATH];
	char file[MAX_PATH];

	char text[256];

	switch (uMsg)
	{

		case WM_INITDIALOG:
		{						


			DDEBUG_Write("INITDIALOG");

			hMain = hdwnd;			

			// Ventana de loading
			WNDCLASS wc={
				CS_OWNDC,
				LoadWindow, // callback
				0,
				0,
				NULL,
				NULL,
				NULL,
				NULL,
				NULL,
				"load",
			};

			// *** Init window	
			RegisterClass(&wc);
			HWND hload = CreateWindowEx(
				WS_EX_CLIENTEDGE | WS_EX_DLGMODALFRAME,
				"load","load",
				WS_VISIBLE + WS_POPUPWINDOW,
				(GetSystemMetrics(SM_CXFULLSCREEN)/2)-150,(GetSystemMetrics(SM_CYFULLSCREEN)/2)-25,300,50,
				hdwnd,NULL,inst,NULL);

			RECT rload;
			GetClientRect(hload, &rload);
			//FillRect(GetDC(hload), &rload, (HBRUSH)GetStockObject(BLACK_BRUSH));			
			FillRect(GetDC(hload), &rload, (HBRUSH)COLOR_APPWORKSPACE);
			
			SetBkMode(GetDC(hload), TRANSPARENT);	
			SetTextColor(GetDC(hload), RGB(0, 0, 0));
			SetBkColor(GetDC(hload), RGB(0, 0, 0));
			char textload[] = "Iniciando el editor. Por favor, espere...";
			TextOut(GetDC(hload), 10, 10, textload, strlen(textload));			
			ShowWindow(hdwnd, SW_SHOW);			
			// Fin de ventana de loading

			// Establece la ruta del archivo de configuracion
			GetCurrentDirectory(256, text);
			sprintf(configfile_pathname, "%s\\%s", text, CONFIG_FILENAME);			

			// Comprueba la exsistencia del fichero de configuracin
			FILE *cf = fopen(configfile_pathname, "rb");
			if (cf == NULL) { MessageBox(hdwnd, "Imposible abrir el fichero de configuracion.\n \"toolconfig.ini\" no exsiste o no esta en el directorio actual.", "Error critico", MB_OK | MB_ICONERROR); DestroyWindow(hload); EndDialog(hdwnd, 0); }
			fclose(cf);

			CIniFile *cini = new CIniFile();			

			cini->OpenIni(configfile_pathname);

			sprintf(text, "Tool - %s", cini->ReadIni("tool", "titlebar"));
			SetWindowText(hdwnd, text);

			delete cini;

			// Load the icon - will be set during WM_INITDIALOG
			HICON hIcon = LoadIcon( inst, MAKEINTRESOURCE( IDI_ICON ) );
			PostMessage( hdwnd, WM_SETICON, ICON_BIG, ( LPARAM ) hIcon );
			PostMessage( hdwnd, WM_SETICON, ICON_SMALL, ( LPARAM ) hIcon );					

			// Centramos la ventana
			SetWindowPos(hdwnd, NULL,
						(GetSystemMetrics(SM_CXSCREEN)/2) - (1024/2),
						(GetSystemMetrics(SM_CYSCREEN)/2) - (768/2),
						1024, 768,0);			

			DDEBUG_Write("Creado tabs: Generador objetos");
			
			// Generador de objetos
			PTAB_Create(inst, &TabGeneradores, hdwnd, 10, 10, 200, 300);
			PTAB_InsertPanel(&TabGeneradores, 0, "Esfera", MAKEINTRESOURCE(IDD_GEN_ESFERA),		(DLGPROC)dlgproc_GenEsfera);			
			PTAB_InsertPanel(&TabGeneradores, 1, "Torus", MAKEINTRESOURCE(IDD_GEN_TORUS),		(DLGPROC)dlgproc_GenTorus);			
			PTAB_InsertPanel(&TabGeneradores, 2, "Cono", MAKEINTRESOURCE(IDD_GEN_CONO),			(DLGPROC)dlgproc_GenCono);			
			PTAB_InsertPanel(&TabGeneradores, 3, "Disco", MAKEINTRESOURCE(IDD_GEN_DISCO),		(DLGPROC)dlgproc_GenDisco);			
			PTAB_InsertPanel(&TabGeneradores, 4, "Cilindro", MAKEINTRESOURCE(IDD_GEN_CILINDRO),	(DLGPROC)dlgproc_GenCilindro);			
			PTAB_InsertPanel(&TabGeneradores, 5, "Plano", MAKEINTRESOURCE(IDD_GEN_PLANO),		(DLGPROC)dlgproc_GenPlano);			
			PTAB_InsertPanel(&TabGeneradores, 6, "Terreno", MAKEINTRESOURCE(IDD_GEN_TERRENO),	(DLGPROC)dlgproc_GenTerreno);			
			PTAB_InsertPanel(&TabGeneradores, 7, "Cubo", MAKEINTRESOURCE(IDD_GEN_CUBO),			(DLGPROC)dlgproc_GenCubo);			
			PTAB_InsertPanel(&TabGeneradores, 8, "Camara", MAKEINTRESOURCE(IDD_GEN_CAMARA),		(DLGPROC)dlgproc_GenCamara);


			DDEBUG_Write("Creando Tabs: Generado de texturas");

			// Generador de texturas
			PTAB_Create(inst, &TabGenTextura, hdwnd, 10, 315, 200, 395);
			PTAB_InsertPanel(&TabGenTextura, 0, "Crear", MAKEINTRESOURCE(IDD_TEXT_CREAR),		(DLGPROC)dlgproc_TextCrear);

			PTAB_InsertPanel(&TabGenTextura, 1, "Distorsion", MAKEINTRESOURCE(IDD_GEN_ESFERA),		(DLGPROC)dlgproc_GenEsfera);			
			PTAB_InsertPanel(&TabGenTextura, 2, "Layer", MAKEINTRESOURCE(IDD_GEN_ESFERA),		(DLGPROC)dlgproc_GenEsfera);			
			PTAB_InsertPanel(&TabGenTextura, 3, "Color", MAKEINTRESOURCE(IDD_GEN_ESFERA),		(DLGPROC)dlgproc_GenEsfera);			
			PTAB_InsertPanel(&TabGenTextura, 4, "Blur", MAKEINTRESOURCE(IDD_GEN_ESFERA),		(DLGPROC)dlgproc_GenEsfera);			

			DDEBUG_Write("Creando Tabs: Render");

			// Render
			PTAB_Create(inst, &TabRender, hdwnd, 215, 10, 544, 408);			

			PTAB_InsertPanel(&TabRender, 0, "Render", MAKEINTRESOURCE(IDD_RENDER_ESCENA), (DLGPROC)dlgproc_Render);			
			HWND  wgl = RebGL_OpenFromHwnd(TabRender.DialogHandle[0], "Render", 320, 240, 32, false);

			DDEBUG_Write("Iniciando timer");
			if ( (RenderTimer = timeSetEvent(20,25,(LPTIMECALLBACK)&RenderTimerProc,0,TIME_PERIODIC)) == NULL)
			{
				MessageBox(hdwnd, "Unable to start the play timer!\nCritial error...", "Play", MB_OK | MB_ICONERROR);
			}			

			DDEBUG_Write("Fuente del systema");
			// Crea la fuente
			InitSysFont();
			
			PTAB_InsertPanel(&TabRender, 1, "Textura", MAKEINTRESOURCE(IDD_RENDER_TEXTURA), (DLGPROC)dlgproc_RenderTextura);

			DDEBUG_Write("Creando Tabs: Modificadores");

			// Modificadores
			PTAB_Create(inst, &TabModificadores, hdwnd, 808, 210, 205, 280);
			PTAB_InsertPanel(&TabModificadores, 0, "Mover", MAKEINTRESOURCE(IDD_MODIF_MOVER), (DLGPROC)dlgproc_ModifMover);			
			PTAB_InsertPanel(&TabModificadores, 1, "Rotar", MAKEINTRESOURCE(IDD_MODIF_ROTAR), (DLGPROC)dlgproc_ModifRotar);			
			//PTAB_InsertPanel(&TabModificadores, 2, "Escalar", MAKEINTRESOURCE(IDD_MODIF_ESCALAR), (DLGPROC)procTabChild);			
			//PTAB_InsertPanel(&TabModificadores, 3, "Textura", MAKEINTRESOURCE(IDD_MODIF_ASIGNAR_TEXTURA), (DLGPROC)procTabChild);			

			DDEBUG_Write("Creando Tabs: Proyecto");

			// Proyecto
			PTAB_Create(inst, &TabProyecto, hdwnd, 808, 495, 205, 215);
			PTAB_InsertPanel(&TabProyecto, 0, "Proyecto", MAKEINTRESOURCE(IDD_PROYE_PASOS), (DLGPROC)procTabChild);			
			PTAB_InsertPanel(&TabProyecto, 1, "Texturas", MAKEINTRESOURCE(IDD_PROYE_TEXTURAS), (DLGPROC)dlgproc_ProyectoTexturas);

			DDEBUG_Write("Creando Tabs: Animacion");

			// Animacion			
			PTAB_Create(inst, &TabAnimacion, hdwnd, 215, 421, 590, 289);
			PTAB_InsertPanel(&TabAnimacion, 0, "Animacin", MAKEINTRESOURCE(IDD_TIMELINE_ANIMACION), (DLGPROC)dlgproc_TimeLine_Animacion);			
			PTAB_InsertPanel(&TabAnimacion, 1, "Timeline", MAKEINTRESOURCE(IDD_TIMELINE_TIMELINE), (DLGPROC)dlgproc_TimeLine_Timeline);			

			DDEBUG_Write("Inicializando engine");

			// Inicializamos algunas cosas del engine
			DDEBUG_Write("Valores por defecto");

			ResetProyect(hdwnd, &GlobalScene, &GlobalSceneInfo);

			SendDlgItemMessage(hdwnd, IDC_CMB_SELECCION, CB_ADDSTRING, 0, (LPARAM)"Objetos");
			SendDlgItemMessage(hdwnd, IDC_CMB_SELECCION, CB_ADDSTRING, 0, (LPARAM)"Camaras");
			SendDlgItemMessage(hdwnd, IDC_CMB_SELECCION, CB_ADDSTRING, 0, (LPARAM)"Luces");
			SendDlgItemMessage(hdwnd, IDC_CMB_SELECCION, CB_ADDSTRING, 0, (LPARAM)"Particulas");
			SendDlgItemMessage(hdwnd, IDC_CMB_SELECCION, CB_SETCURSEL, 0, 0);

			MakeTestTexture(); // SOLO PARA TEST!!!
			
			DDEBUG_Write("INITIDIALOG: OK");

			DestroyWindow(hload);

		}
		break;

        case WM_NOTIFY: 
		{

			NMHDR *pnmh = (LPNMHDR) lParam;			
			int iSel;

			// Generadores
			if (pnmh->hwndFrom == TabGeneradores.hdwnd)
			{
				iSel = TabCtrl_GetCurSel(TabGeneradores.hdwnd); 
				PTAB_ShowPanel(&TabGeneradores, iSel);
			}

			// Generador de Texturas
			if (pnmh->hwndFrom == TabGenTextura.hdwnd)
			{
				iSel = TabCtrl_GetCurSel(TabGenTextura.hdwnd); 
				PTAB_ShowPanel(&TabGenTextura, iSel);
			}
			
			// Render
			if (pnmh->hwndFrom == TabRender.hdwnd)
			{
				iSel = TabCtrl_GetCurSel(TabRender.hdwnd); 
				PTAB_ShowPanel(&TabRender, iSel);

				DoRender(); // Render
				SendMessage(TabRender.DialogHandle[1], WM_PAINT, 0, 0); // Redibujado de la ventana de textura
			}

			// Modificadores
			if (pnmh->hwndFrom == TabModificadores.hdwnd)
			{
				iSel = TabCtrl_GetCurSel(TabModificadores.hdwnd); 
				PTAB_ShowPanel(&TabModificadores, iSel);
			}

			// Proyecto
			if (pnmh->hwndFrom == TabProyecto.hdwnd)
			{
				iSel = TabCtrl_GetCurSel(TabProyecto.hdwnd); 
				PTAB_ShowPanel(&TabProyecto, iSel);
			}

			// Timeline
			if (pnmh->hwndFrom == TabAnimacion.hdwnd)
			{
				iSel = TabCtrl_GetCurSel(TabAnimacion.hdwnd); 
				PTAB_ShowPanel(&TabAnimacion, iSel);
			}

		}
		break;

		case WM_KEYDOWN:
		{
			//MessageBox(hdwnd, "keydown", "tool", MB_OK);
		}
		break;

		case WM_DORENDER:
		{
			RECT r;
			GetClientRect(GetDlgItem(TabRender.DialogHandle[0], IDC_RENDER), &r);
			RebGL_Resize(r.right-r.left, r.bottom-r.top);
			glViewport(0, 0, r.right-r.left, r.bottom-r.top);
			DoRender();			
		}
		break;

		case WM_COMMAND:
		{			

			switch (LOWORD(wParam))
			{

				case ID_HERRAMIENTAS_AUDIO:
				{
					DialogBox(inst, MAKEINTRESOURCE(IDD_AUDIO), hdwnd, (DLGPROC)dlgproc_Audio);

				}
				break;

				case ID_HERRAMIENTAS_OPCIONES:
				{
					DialogBox(inst, MAKEINTRESOURCE(IDD_OPCIONES), hdwnd, (DLGPROC)dlgproc_Opciones);
				}
				break;

				case IDC_RENDER_MODE:
				{
					switch (RenderMode)
					{
						case 0:
							{
								SetWindowText(GetDlgItem(hdwnd, IDC_RENDER_MODE), "Poly");
								RenderMode=1;
							}
							break;

						case 1:
							{
								SetWindowText(GetDlgItem(hdwnd, IDC_RENDER_MODE), "Wire");
								RenderMode=0;
							}
							break;
					}
					break;
				}
				break;

				case IDC_RENDER_PLANO:
				{
					RenderPlano =! RenderPlano;
					if (RenderPlano) { SetWindowText(GetDlgItem(hdwnd, IDC_RENDER_PLANO), "!#"); }
					else { SetWindowText(GetDlgItem(hdwnd, IDC_RENDER_PLANO), "#"); }
				}
				break;

				case IDC_RENDER_EJES:
				{
					RenderEjes =! RenderEjes;
					if (RenderEjes) { SetWindowText(GetDlgItem(hdwnd, IDC_RENDER_EJES), "!XYZ"); }
					else { SetWindowText(GetDlgItem(hdwnd, IDC_RENDER_EJES), "XYZ"); }
				}
				break;

				case IDC_RENDER_CAMARA: // Cambio de vista camara X o perspectiva
				{

					/*
					if (GlobalScene.NumCameras == 0) 
					{
						MessageBox(hdwnd, "No hay ninguna camara en la escena.\nPulsa este boton para cambiar la vista (Perspectiva/cmara)", "Cambiar vista", MB_OK | MB_ICONINFORMATION);
					}

					RenderCamara++;

					if (RenderCamara > (GlobalScene.NumCameras)) { RenderCamara=0; }					

					sprintf(text, "camara: %d", SelectedCamera);
					//MessageBox(hdwnd, text, "CAM", MB_OK);
					*/

					/*
					HMENU hMenu = LoadMenu(inst, MAKEINTRESOURCE(IDR_CAMERA_MENU));
					POINT mp;
					GetCursorPos(&mp);

					//TrackPopupMenu(hMenu, TPM_LEFTBUTTON, mp.x, mp.y, 0, hMain, NULL);
					TrackPopupMenuEx(hMenu, TPM_HORIZONTAL, mp.x, mp.y, hMain, NULL);
					*/

					RECT r;				

					GetWindowRect(hdwnd, &r);		

					HMENU hm = LoadMenu(inst, MAKEINTRESOURCE(IDR_CAMERA_MENU));
					HMENU hMenu = GetSubMenu(hm, 0); // Get EDIT submenu		

					POINT mp;
					GetCursorPos(&mp);
				
					TrackPopupMenu(hMenu, TPM_LEFTALIGN | TPM_TOPALIGN | TPM_LEFTBUTTON, mp.x, mp.y, 0, hdwnd, 0);
					

				}
				break;

				case IDC_RENDER_RESETVIEW:
				{
					// Parametros del editor
					GlobalRender_RotacionX=0;
					GlobalRender_RotacionY=30;
					GlobalRender_LastRotacionX=0;
					GlobalRender_LastRotacionY=0;

					// Posicion mediante el raton
					GlobalRender_PosicionX=0;
					GlobalRender_PosicionY=0;
					GlobalRender_PosicionZ=-10;
					GlobalRender_LastPosicionX=0;
					GlobalRender_LastPosicionY=0;
					GlobalRender_LastPosicionZ=0;
				}
				break;

				case ID_ARCHIVO_NUEVO:
				{
					if (MessageBox(hdwnd, "Se perderan los cambios que puedas haber hecho hasta ahora.\nCrear un proyecto nuevo?", "Nuevo proyecto", MB_OK | MB_ICONQUESTION | MB_YESNO) == IDYES)
					{						

						if (GlobalScene.NumObjects > 0) { igtFreeScene(&GlobalScene); } // Liberamos la escena				
						if (EditorSelectionInfo != NULL) { free(EditorSelectionInfo); } // Liberamos la lista de selecion

						ResetProyect(hdwnd, &GlobalScene, &GlobalSceneInfo);
					}
				}
				break;

				case ID_ARCHIVO_ABRIR:
				{
					// Initialize browse dialog
					GetCurrentDirectory(MAX_PATH,path);
					memset(&ofn,0,sizeof(ofn));
					ofn.lStructSize = sizeof(ofn);
					ofn.hwndOwner = hdwnd;
					ofn.hInstance = inst;
					ofn.nMaxFile = MAX_PATH;
					ofn.lpstrInitialDir = path;
					ofn.Flags = OFN_HIDEREADONLY | OFN_EXPLORER | OFN_FILEMUSTEXIST;	
					ofn.lpstrTitle = "Abrir escena";		

					sprintf(file, "");			
					ofn.lpstrFile = file;	
					ofn.lpstrFilter = "Tool Proyect File(*.tpf)\0*.tpf;\0\0\0";

					if (GetOpenFileName(&ofn)) 
					{						

						/*
						if (GlobalScene.NumObjects > 0) { igtFreeScene(&GlobalScene); } // Liberamos la escena				
						if (EditorSelectionInfo != NULL) { free(EditorSelectionInfo); } // Liberamos la lista de selecion

						ResetProyect(hdwnd, &GlobalScene, &GlobalSceneInfo);
						*/

						if (!DoLoadProyect(ofn.lpstrFile))
						{
							//MessageBox(hdwnd, "Ha ocurrido un error abriendo el proyecto!", "Abrir", MB_OK | MB_ICONERROR);
						}
					}	
				}
				break;

				case ID_ARCHIVO_GUARDARCOMO:
				{
					// Initialize browse dialog
					GetCurrentDirectory(MAX_PATH,path);
					memset(&ofn,0,sizeof(ofn));
					ofn.lStructSize = sizeof(ofn);
					ofn.hwndOwner = hdwnd;
					ofn.hInstance = inst;
					ofn.nMaxFile = MAX_PATH;
					ofn.lpstrInitialDir = path;
					ofn.Flags = OFN_HIDEREADONLY | OFN_EXPLORER | OFN_FILEMUSTEXIST;	
					ofn.lpstrTitle = "Guardar escena como...";

					sprintf(file, "escena.tpf");			
					ofn.lpstrFile = file;	
					ofn.lpstrFilter = "Tool Proyect File(*.tpf)\0*.tpf;\0\0\0";

					if (GetSaveFileName(&ofn)) 
					{
						if (!DoSaveProyect(ofn.lpstrFile))
						{
							//MessageBox(hdwnd, "Ha ocurrido un error guardando el proyecto!", "Guardar", MB_OK | MB_ICONERROR);
						}
					}	
				}
				break;

				case ID_ARCHIVO_EXPORTAR_ASCII:
				{					

					// Initialize browse dialog
					GetCurrentDirectory(MAX_PATH,path);
					memset(&ofn,0,sizeof(ofn));
					ofn.lStructSize = sizeof(ofn);
					ofn.hwndOwner = hdwnd;
					ofn.hInstance = inst;
					ofn.nMaxFile = MAX_PATH;
					ofn.lpstrInitialDir = path;
					ofn.Flags = OFN_HIDEREADONLY | OFN_EXPLORER | OFN_FILEMUSTEXIST;	
					ofn.lpstrTitle = "Guardar escena como...";

					sprintf(file, "escena.txt");			
					ofn.lpstrFile = file;	
					ofn.lpstrFilter = "Text File(*.txt)\0*.txt;\0\0\0";

					if (GetSaveFileName(&ofn)) 
					{
						if (!DoExport_ASC(ofn.lpstrFile))
						{
							//MessageBox(hdwnd, "Ha ocurrido un error guardando el proyecto!", "Guardar", MB_OK | MB_ICONERROR);
						}
					}	

				}
				break;

				case ID_ARCHIVO_SALIR:
				{
					SendMessage(hdwnd, WM_DESTROY, 0, 0);
				}
				break;

				case ID_AYUDA_ACERCADE:
					{
						DialogBox(inst, MAKEINTRESOURCE(IDD_ABOUT), hdwnd, (DLGPROC)AboutWindow);
					}
					break;
			}
			break;
			
		}
		break;


    case WM_DESTROY:
		{	
			DDEBUG_Write("Ventana principal: WM_DESTROY");
			EndDialog(hdwnd, 0);			
			PostQuitMessage(0);
			//return 0;
		}
		break;

	case WM_SYSCOMMAND: // Mensaje del sistema (no del usuario) a la ventana. Por ejemplo cuando se apaga el equipo, se manda que se cierre.
	{

		sprintf(text, "syscommand: %d", LOWORD(wParam));
		//MessageBox(hdwnd, text, "", MB_OK);
		
		switch (wParam) // Que mensaje es?
		{

			case SC_CLOSE: // Cerrar la ventana (ALT+F4, System-Menu etc...)
			{

				DDEBUG_Write("Cerrando tool...");
				
				// Aqui se finaliza todo lo que hay que finalizar :)
				if (RenderTimer) { timeKillEvent(RenderTimer); }				
				if (GlobalScene.NumObjects > 0) { igtFreeScene(&GlobalScene); } // Liberamos la escena				
				if (EditorSelectionInfo != NULL) { free(EditorSelectionInfo); } // Liberamos la lista de selecion				
				DestroyFont();
				RebGL_Close();

				//SendMessage(hdwnd, WM_DESTROY, 0, 0);
				PostQuitMessage(0);				
			}
			break;
		}

		break;
	}


	};
	
	return FALSE;
};

int APIENTRY WinMain(HINSTANCE hInstance,
                     HINSTANCE hPrevInstance,
                     LPSTR     lpCmdLine,
                     int       nCmdShow)
{


	BOOL	done=FALSE;

	DDEBUG_Init();

	// Evita una instancia anterior :D
	if (!CheckFirstInstance()) { return 0; }
 	
	InitCommonControls();

	inst = hInstance;

	DDEBUG_Write("Iniciando ventana principal");	
	DialogBox(hInstance, MAKEINTRESOURCE(IDD_DIALOG_MAIN), NULL, (DLGPROC)dlgSplashProc);

	DDEBUG_Close();

	return 0;
}



