#version 330

out vec4 outColor;
in vec2 texCoords;
uniform float time;

#define M_PI 3.1415926535897932384626433832795

float getCard(in vec2 xy, in float magnitude)
{
    float x = xy.x * magnitude;
    float y = xy.y * magnitude;
    float card = pow(y - pow(abs(x),0.5),2.0) + pow(x,2.0);
    card = min(1.0/pow(card,2.0),1.0);
    return card;
}

void mainImage( inout vec4 gfragColour, in vec2 fragCoord )
{
    float timefun = 0.5*sin(M_PI*sin(time*8)*0.4);
    vec4 fragColour = vec4(0,0,0,1);
    vec2 uv = fragCoord.xy * 2.50;
    float rcard = getCard(uv, 1.0+timefun);
    fragColour += vec4(rcard,0,0,0);
    
    float gcard = getCard(uv,1.4 +timefun);
    fragColour += vec4(-gcard,gcard,0,0);
    
    float bcard = getCard(uv,1.8 +timefun);
    fragColour += vec4(0,-bcard,bcard,0);
    if (length(fragColour) > length(gfragColour)) {
        gfragColour = fragColour;
    }
}

void tiledFloor( out vec4 fragColour, in vec2 fragCoord )
{
    //float timefun = 0.5*sin(M_PI*sin(time*8)*0.4);
    vec2 uv = vec2(fragCoord.x*fragCoord.y/2,1/fragCoord.y+time/4);
    float rcard = getCard(mod(uv,0.2)-mod(-uv,0.2), 20);
    fragColour = vec4(rcard,0,0,1.0);
}


void main()
{
    tiledFloor(outColor, texCoords);
    mainImage(outColor, texCoords);
}