#include "surface.h"
#include <malloc.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "3d.h"

void maketabs();

#pragma aux CONVERT15_to_16_ "_*" parm caller [];
#pragma aux hline_flat_ "_*" parm caller [];
#pragma aux hline_flatz_ "_*" parm caller [];
#pragma aux hline_tmap1_ "_*" parm caller [];
#pragma aux hline_tmap_transp_ "_*" parm caller [];
#pragma aux hline_tmap_add_ "_*" parm caller [];
#pragma aux hline_addcol_ "_*" parm caller [];
#pragma aux hline_zshad_ "_*" parm caller [];
#pragma aux hline_tmap_ "_*" parm caller [];
#pragma aux fill16_ "_*" parm caller [];
#pragma aux fill32_ "_*" parm caller [];

#pragma aux imgadd_ "_*" parm caller [];
#pragma aux pixeladd_ "_*" parm caller [];
#pragma aux pixelneg_ "_*" parm caller [];








surface::surface(void)
{
	size=0;
	addr=NULL;
	xdim=0;
	ydim=0;
	depth=0;
}


surface::surface(long bsize,char ddepth,long xxdim, long yydim)
{
	size=bsize;
	addr=(char *)malloc(bsize);
	xdim=xxdim;
	ydim=yydim;
	depth=ddepth;
}

        


surface::clear()
{
	memset(addr,0,size);
}

surface::fill(int color)
{
	if (depth==16)
		fill16_(addr,color,size);
	if (depth==32)
		fill32_(addr,color,size);
}



surface::d2dcopy(char *dest,long xxdim,long yydim,long xxoffs,long yyoffs)
{

if ((xdim==xxdim) && (ydim==yydim))
	{
	memcpy(dest,addr,size);
	return 0;
	}

long x1,y1,x2,y2;
x1=0+xxoffs; y1=0+yyoffs; x2=xdim+xxoffs; y2=ydim+yyoffs;
if (x2<0) return 0;
if (y2<0) return 0;
if (x1>xxdim) return 0;
if (y1>yydim) return 0;

long xx1,yy1,xx2,yy2;
xx1=0; yy1=0; xx2=xdim; yy2=ydim;

if (x1<0) { xx1=abs(x1); x1=0; }
if (y1<0) { yy1=abs(y1); y1=0; }
if (x2>xxdim) { xx2=xdim-abs(x2-xxdim); x2=xxdim; }
if (y2>yydim) { yy2=ydim-abs(y2-yydim); y2=yydim; }

if (depth==16)
	for (long yloop=0; yloop<abs(y2-y1); yloop++)
		memcpy(dest+(x1*2)+((yloop+y1)*xxdim*2),(xx1*2)+addr+((yloop+yy1)*xdim*2),2*(xx2-xx1));

if (depth==32)
	for (long yloop=0; yloop<abs(y2-y1); yloop++)
		memcpy(dest+(x1*4)+((yloop+y1)*xxdim*4),(xx1*4)+addr+((yloop+yy1)*xdim*4),4*(xx2-xx1));

return 0;
}



surface::d2dcopyadd(char *dest,long xxdim,long yydim,long xxoffs,long yyoffs)
{

if ((xdim==xxdim) && (ydim==yydim))
	{
	imgadd_(addr,dest,320*200);
	return 0;
	}


long x1,y1,x2,y2;
x1=0+xxoffs; y1=0+yyoffs; x2=xdim+xxoffs; y2=ydim+yyoffs;

if (x2<0) return 0;
if (y2<0) return 0;
if (x1>xxdim) return 0;
if (y1>yydim) return 0;

long xx1,yy1,xx2,yy2;
xx1=0; yy1=0; xx2=xdim; yy2=ydim;
/*
if (x1<0) { xx1=abs(x1); x1=0; }
if (y1<0) { yy1=abs(y1); y1=0; }
if (x2>xxdim) { xx2=xdim-abs(x2-xxdim); x2=xxdim; }
if (y2>yydim) { yy2=ydim-abs(y2-yydim); y2=yydim; }
*/
short temp;

if (depth==16)
	for (long yloop=0; yloop<abs(y2-y1); yloop++)
		{
		for (long xxloop=xx1; xxloop<xx2; xxloop++)
			{
			if (((x1+xxloop)<xxdim) && ((yloop+y1)<yydim) &&
			    ((x1+xxloop)>0) && ((yloop+y1)>0))
				pixeladd_(((xx1+xxloop)*2)+addr+((yloop+yy1)*xdim*2),dest+((x1+xxloop)*2)+((yloop+y1)*xxdim*2));
			}
		}

if (depth==32)
	for (long yloop=0; yloop<abs(y2-y1); yloop++)
		memcpy(dest+(x1*4)+((yloop+y1)*xxdim*4),(xx1*4)+addr+((yloop+yy1)*xdim*4),4*(xx2-xx1));


return 0;
}




surface::d2dcopyaddr(char *dest,long xxdim,long yydim,long xxoffs,long yyoffs)
{

if ((xdim==xxdim) && (ydim==yydim))
	{
	imgadd_(addr,dest,320*200);
	return 0;
	}


long x1,y1,x2,y2;
x1=0+xxoffs; y1=0+yyoffs; x2=xdim+xxoffs; y2=ydim+yyoffs;
if (x2<0) return 0;
if (y2<0) return 0;
if (x1>xxdim) return 0;
if (y1>yydim) return 0;

long xx1,yy1,xx2,yy2;
xx1=0; yy1=0; xx2=xdim; yy2=ydim;

if (x1<0) { xx1=abs(x1); x1=0; }
if (y1<0) { yy1=abs(y1); y1=0; }
if (x2>xxdim) { xx2=xdim-abs(x2-xxdim); x2=xxdim; }
if (y2>yydim) { yy2=ydim-abs(y2-yydim); y2=yydim; }

short temp;

if (depth==16)
	for (long yloop=0; yloop<abs(y2-y1); yloop++)
		{
		for (long xxloop=xx1; xxloop<xx2; xxloop++)
			{
			pixeladd_(((xx2-xxloop)*2)+addr+((yloop+yy1)*xdim*2),dest+((x1+xxloop)*2)+((yloop+y1)*xxdim*2));
			//temp=0;
			//memcpy(&temp,((xx1+xxloop)*2)+addr+((yloop+yy1)*xdim*2),1);
			//if (temp!=0)
			//memset(dest+((x1+xxloop)*2)+((yloop+y1)*xxdim*2),temp,2);
			}
		}

if (depth==32)
	for (long yloop=0; yloop<abs(y2-y1); yloop++)
		memcpy(dest+(x1*4)+((yloop+y1)*xxdim*4),(xx1*4)+addr+((yloop+yy1)*xdim*4),4*(xx2-xx1));


return 0;
}






surface::d2dcopyneg(char *dest,long xxdim,long yydim,long xxoffs,long yyoffs)
{
/*
if ((xdim==xxdim) && (ydim==yydim))
	{
	//imgneg_(addr,dest,320*200);
	return 0;
	}
*/

long x1,y1,x2,y2;
x1=0+xxoffs; y1=0+yyoffs; x2=xdim+xxoffs; y2=ydim+yyoffs;
if (x2<0) return 0;
if (y2<0) return 0;
if (x1>xxdim) return 0;
if (y1>yydim) return 0;

long xx1,yy1,xx2,yy2;
xx1=0; yy1=0; xx2=xdim; yy2=ydim;

if (x1<0) { xx1=abs(x1); x1=0; }
if (y1<0) { yy1=abs(y1); y1=0; }
if (x2>xxdim) { xx2=xdim-abs(x2-xxdim); x2=xxdim; }
if (y2>yydim) { yy2=ydim-abs(y2-yydim); y2=yydim; }

short temp;

if (depth==16)
	for (long yloop=0; yloop<abs(y2-y1); yloop++)
		{
		for (long xxloop=xx1; xxloop<xx2; xxloop++)
			{
			pixelneg_(((xx1+xxloop)*2)+addr+((yloop+yy1)*xdim*2),dest+((x1+xxloop)*2)+((yloop+y1)*xxdim*2));
			//temp=0;
			//memcpy(&temp,((xx1+xxloop)*2)+addr+((yloop+yy1)*xdim*2),1);
			//if (temp!=0)
			//memset(dest+((x1+xxloop)*2)+((yloop+y1)*xxdim*2),temp,2);
			}
		}

if (depth==32)
	for (long yloop=0; yloop<abs(y2-y1); yloop++)
		memcpy(dest+(x1*4)+((yloop+y1)*xxdim*4),(xx1*4)+addr+((yloop+yy1)*xdim*4),4*(xx2-xx1));


return 0;
}




surface::scale(char *dest,long scale)
{
float xstep,ystep,x,y;
	xstep=1;
	ystep=1;
	x=0;
	y=0;
	for (int yloop=0; yloop<ydim; yloop++)
	{
	y=y+1;
	for (int xloop=0; xloop<xdim; xloop++)
	{
//	if ((x<xdim) && (y<ydim) && (x>=0) && (y>=0))
		memcpy(dest+long(x*2)+long(y*2*xdim),addr+(xloop*2)+(yloop*2*xdim),2);
	x=x+xstep;
	}
	}

return 0;
}




surface::pixel(long x, long y, int data)
{
if ((x>=0) && (y>=0) && (x<xdim) && (y<ydim))
	{
	if (depth==16) 
		{
		memset(addr+(x*2)+(y*xdim*2),data,2);
		}
	if (depth==32) 
		{
		memset(addr+(x*4)+(y*xdim*4),data,4);
		}
	}

}




surface::line(long x1,long y1,long x2,long y2,short color)  //fixed-point LINE
{
	long x,y,grad;

	if ((y2-y1)!=0) grad=abs( ((x2-x1)<<16) / (y2-y1));
	if ((x2-x1)<0) grad=-grad;
	x=x1<<16;
	y=y1<<16;
	for (int lineloop=0; lineloop<abs(y2-y1); lineloop++)
		{
		surface::pixel(x>>16,y>>16,65535);
		if ((y2-y1)<0) y-=(1<<16);
		if ((y2-y1)>0) y+=(1<<16);
		x=x+grad;
		}

	if ((x2-x1)!=0) grad=abs( ((y2-y1)<<16) / (x2-x1));
	if ((y2-y1)<0) grad=-grad;
	y=y1<<16;
	x=x1<<16;
	for (lineloop=0; lineloop<abs(x2-x1); lineloop++)
		{
		surface::pixel(x>>16,y>>16,65535);
		if ((x2-x1)<0) x-=(1<<16);
		if ((x2-x1)>0) x+=(1<<16);
		y=y+grad;
		}
}



surface::circle(long xpos, long ypos, long radius, long thick, short color)
{
int x,y;
for (int uloop=-(thick>>1); uloop<(thick>>1); uloop++)
for (int loop=0; loop<3600; loop++)
	{
	x=sin(loop*3.141592654/1800)*(radius+uloop);
	x=x+xpos;
	y=cos(loop*3.141592654/1800)*(radius+uloop);
	y=y+ypos;


	if ((x>=0) && (y>=0) && (x<xdim) && (y<ydim))
		{
		if (depth==16) 
			{
			memset(addr+(x*2)+(y*xdim*2),color,2);
			}
		if (depth==32) 
			{
			memset(addr+(x*4)+(y*xdim*4),color,4);
			}
		}

	}
}




surface::tri(long x1,long y1,long z1, 
             long x2,long y2,long z2,
             long x3,long y3,long z3,
             long tx1,long ty1,
             long tx2,long ty2,
             long tx3,long ty3,
             unsigned int col,char* zbufy,char* srcy,long xxdim,long yydim,
             unsigned short drawstyle)
{

signed long mnx,mxx,mny,mxy;
signed long m1,m2,m3,f1,f2,f3,d1,d2,d3;
signed long tmark0x,tmark1x,tmark2x,tstep0x,tstep1x,tstep2x;
signed long tmark0y,tmark1y,tmark2y,tstep0y,tstep1y,tstep2y;
signed long tmxx,tmnx,tmxy,tmny;
signed long xx1,xx2,xx3,zz1,zz2,zz3;
signed long step0x,step1x,step2x,step0z,step1z,step2z;
signed long mark0x,mark1x,mark2x,mark0z,mark1z,mark2z;
signed long lz,rz;
signed long tdx,tdy,dx1,dy1,y;
long xloop;

//if ((z1<0000) || (z2<0000) || (z3<0000)) return 0;
                          //Cheks to see if polys Y values are on screen!
   mny=y1; mxy=y1;
   if (y2<mny)  mny=y2;
   if (y2>mxy)  mxy=y2;
   if (y3<mny)  mny=y3;      
   if (y3>mxy)  mxy=y3;
   if (mxy<0)   return 0;    //exit();
   if (mny>=ydim) return 0;  //exit();

                          //Cheks to see if polys X values are on screen!}
   mnx=x1; mxx=x1;
   if (x2<mnx)  mnx=x2;
   if (x2>mxx)  mxx=x2;
   if (x3<mnx)  mnx=x3;
   if (x3>mxx)  mxx=x3;
   if (mxx<0)   return 0;    //exit();
   if (mnx>=xdim) return 0;  //exit();


tx1=tx1 << 16;
ty1=ty1 << 16;
tx2=tx2 << 16;
ty2=ty2 << 16;
tx3=tx3 << 16;
ty3=ty3 << 16;

if ((y3-y1)!=0) {
  tstep0y=(ty3-ty1) / (y3-y1);
  tstep0x=(tx3-tx1) / (y3-y1);
  }
if ((y1-y2)!=0) {
  tstep1y=(ty1-ty2) / (y1-y2);
  tstep1x=(tx1-tx2) / (y1-y2);
  }
if ((y2-y3)!=0) {
  tstep2y=(ty2-ty3) / (y2-y3);
  tstep2x=(tx2-tx3) / (y2-y3);
  }

if (y1<y3) {
  tmark0y=ty1;
  tmark0x=tx1; 
  } else {
         tmark0y=ty3;
         tmark0x=tx3;
         }
if (y1<y2) {
  tmark1y=ty1;
  tmark1x=tx1;
  } else {
         tmark1y=ty2;
         tmark1x=tx2;
         } 
if (y2<y3) {
  tmark2y=ty2;
  tmark2x=tx2;
  } else {
         tmark2y=ty3;
         tmark2x=tx3;
         } 

xx1=x1 << 16;
xx2=x2 << 16;
xx3=x3 << 16;

if ((y3-y1)!=0) step0x=(xx3-xx1) / (y3-y1);
if ((y1-y2)!=0) step1x=(xx1-xx2) / (y1-y2);
if ((y2-y3)!=0) step2x=(xx2-xx3) / (y2-y3);
if (y1<y3) mark0x=xx1; else mark0x=xx3;
if (y1<y2) mark1x=xx1; else mark1x=xx2;
if (y2<y3) mark2x=xx2; else mark2x=xx3;


zz1=z1 << 15;
zz2=z2 << 15;
zz3=z3 << 15;
if ((y3-y1)!=0) step0z=(zz3-zz1) / (y3-y1);
if ((y1-y2)!=0) step1z=(zz1-zz2) / (y1-y2);
if ((y2-y3)!=0) step2z=(zz2-zz3) / (y2-y3);
if (y1<y3) mark0z=zz1; else mark0z=zz3;
if (y1<y2) mark1z=zz1; else mark1z=zz2;
if (y2<y3) mark2z=zz2; else mark2z=zz3;


for (y=mny; y<mxy; y++)
{
    mnx=xdim << 16;                  //to clip the screen
    mxx=000  << 16;
   tmnx=xxdim << 16;
   tmxx=000  << 16;
   tmny=yydim << 16;    
   tmxy=000  << 16;



   if (y1!=y3) {
     if (((y3>=y) && (y1<=y)) || ((y1>=y) && (y3<=y))) {
         if (mark0x>mxx) { rz=mark0z; mxx=mark0x; tmxx=tmark0x; tmxy=tmark0y; }
         if (mark0x<mnx) { lz=mark0z; mnx=mark0x; tmnx=tmark0x; tmny=tmark0y; }
         tmark0x=(tmark0x+tstep0x);
         tmark0y=(tmark0y+tstep0y);
         mark0x=(mark0x+step0x);
         mark0z=(mark0z+step0z);
        }
   }

   if (y1!=y2) {
     if (((y2>=y) && (y1<=y)) || ((y1>=y) && (y2<=y))) {
         if (mark1x>mxx) { rz=mark1z; mxx=mark1x; tmxy=tmark1y; tmxx=tmark1x; }
         if (mark1x<mnx) { lz=mark1z; mnx=mark1x; tmny=tmark1y; tmnx=tmark1x; }
         tmark1x=(tmark1x+tstep1x);
         tmark1y=(tmark1y+tstep1y);
         mark1x=(mark1x+step1x);
         mark1z=(mark1z+step1z);
        }
   }

   if (y2!=y3) {
     if (((y3>=y) && (y2<=y)) || ((y2>=y) && (y3<=y))) {
         if (mark2x>mxx) { rz=mark2z; mxx=mark2x; tmxx=tmark2x; tmxy=tmark2y; }
         if (mark2x<mnx) { lz=mark2z; mnx=mark2x; tmnx=tmark2x; tmny=tmark2y; }
         tmark2x=(tmark2x+tstep2x);
         tmark2y=(tmark2y+tstep2y);
         mark2x=(mark2x+step2x);
         mark2z=(mark2z+step2z);
        }
   }
   
   mnx=mnx >> 16;
   mxx=mxx >> 16;
   if ((y>=0) && (y<ydim)) 
     if (mnx<mxx) {
       lz=lz >> 15;
       rz=rz >> 15; 
       //lz=abs(lz);
       //rz=abs(rz);
  
          if ((mnx-mxx)!=0) tdx=(tmnx-tmxx) / ((mnx-mxx));
          if ((mnx-mxx)!=0) tdy=(tmny-tmxy) / ((mnx-mxx));
       dx1=tmnx;
       dy1=tmny;
          while (mnx<0) 
          {
            dx1=dx1+tdx;
            dy1=dy1+tdy;
            mnx=mnx+1;
          }
       tmnx=dx1;
       tmny=dy1;

       dx1=tmxx;
       dy1=tmxy;
          while (mxx>xdim) 
          {
            dx1=dx1-tdx;
            dy1=dy1-tdy;      
            mxx=mxx-1;
          }; 
       tmxx=dx1;
       tmxy=dy1;

       if ((mnx-mxx)!=0) tdx=(tmnx-tmxx) / ((mnx-mxx));
       if ((mnx-mxx)!=0) tdy=(tmny-tmxy) / ((mnx-mxx));
       dx1=tmnx;
       dy1=tmny;
   
       if (drawstyle==0) hline_flat_(mnx,mxx,y,addr,col);
       if (drawstyle==1) hline_tmap1_(mnx,mxx,y,long(dx1),long(dy1),long(tdx),long(tdy),long(lz),long(rz),zbufy,srcy,addr);
       if (drawstyle==2) hline_tmap_transp_(mnx,mxx,y,dx1,dy1,tdx,tdy,srcy,addr);
       if (drawstyle==3) hline_zshad_(mnx,mxx,y,lz,rz,srcy,addr);
       //if (drawstyle==4) hline_flatz_(mnx,mxx,lz,rz,y,zbufy,addr,r,g,b);
       if (drawstyle==5) hline_tmap_add_(mnx+1,mxx,y,dx1,dy1,tdx,tdy,srcy,addr);
       if (drawstyle==6) hline_addcol_(mnx+1,mxx,y,addr,col);
       if (drawstyle==7) hline_tmap_(mnx,mxx,y,dx1,dy1,tdx,tdy,srcy,addr);


   }
 }
return 0;
}






surface::quad(long x1,long y1,
              long x2,long y2,
              long x3,long y3,
              long x4,long y4,
              long tx1,long ty1,
              long tx2,long ty2,
              long tx3,long ty3,
              long tx4,long ty4,
              unsigned int col,char* srcy,long xxdim,long yydim,unsigned short drawstyle,char backcull)
{
signed long mnx,mxx,mny,mxy;
signed long m1,m2,m3,m4,f1,f2,f3,f4,d1,d2,d3,d4;
signed long tmark0x,tmark1x,tmark2x,tmark3x,tstep0x,tstep1x,tstep2x,tstep3x;
signed long tmark0y,tmark1y,tmark2y,tmark3y,tstep0y,tstep1y,tstep2y,tstep3y;
signed long tmxx,tmnx,tmxy,tmny;
signed long xx1,xx2,xx3,xx4,zz1,zz2,zz3;
signed long step0x,step1x,step2x,step0z,step1z,step2z,step3x;
signed long mark0x,mark1x,mark2x,mark0z,mark1z,mark2z,mark3x;
signed long lz,rz;
signed long tdx,tdy,dx1,dy1,y;
long xloop;

                          //Cheks to see if polys Y values are on screen!
   mny=y1; mxy=y1;
   if (y2<mny)  mny=y2;
   if (y2>mxy)  mxy=y2;
   if (y3<mny)  mny=y3;      
   if (y3>mxy)  mxy=y3;
   if (y4<mny)  mny=y4;      
   if (y4>mxy)  mxy=y4;
   if (mxy<0)   return 0;    //exit();
   if (mny>yydim) return 0;  //exit();
                          //Cheks to see if polys X values are on screen!}
   mnx=x1; mxx=x1;
   if (x2<mnx)  mnx=x2;
   if (x2>mxx)  mxx=x2;
   if (x3<mnx)  mnx=x3;
   if (x3>mxx)  mxx=x3;
   if (x4<mnx)  mnx=x4;
   if (x4>mxx)  mxx=x4;
   if (mxx<0)   return 0;    //exit();
   if (mnx>xxdim) return 0;  //exit();

   m1=x1-x4; d1=y1-y4;
   m2=x2-x1; d2=y2-y1;
   m3=x3-x2; d3=y3-y2;
   m4=x4-x3; d4=y4-y3;

tx1=tx1 << 16;
ty1=ty1 << 16;
tx2=tx2 << 16;
ty2=ty2 << 16;
tx3=tx3 << 16;
ty3=ty3 << 16;
tx4=tx4 << 16;
ty4=ty4 << 16;

if ((y4-y1)!=0) {
  tstep0y=(ty4-ty1) / (y4-y1);
  tstep0x=(tx4-tx1) / (y4-y1);
  }
if ((y1-y2)!=0) {
  tstep1y=(ty1-ty2) / (y1-y2);
  tstep1x=(tx1-tx2) / (y1-y2);
  }
if ((y2-y3)!=0) {
  tstep2y=(ty2-ty3) / (y2-y3);
  tstep2x=(tx2-tx3) / (y2-y3);
  }
if ((y3-y4)!=0) {
  tstep3y=(ty3-ty4) / (y3-y4);
  tstep3x=(tx3-tx4) / (y3-y4);
  }

if (y1<y4) {
  tmark0y=ty1;
  tmark0x=tx1; 
  } else {
         tmark0y=ty4;
         tmark0x=tx4;
         }
if (y1<y2) {
  tmark1y=ty1;
  tmark1x=tx1;
  } else {
         tmark1y=ty2;
         tmark1x=tx2;
         } 
if (y2<y3) {
  tmark2y=ty2;
  tmark2x=tx2;
  } else {
         tmark2y=ty3;
         tmark2x=tx3;
         } 
if (y3<y4) {
  tmark3y=ty3;
  tmark3x=tx3;
  } else {
         tmark3y=ty4;
         tmark3x=tx4;
         } 

xx1=x1 << 16;
xx2=x2 << 16;
xx3=x3 << 16;
xx4=x4 << 16;

if ((y4-y1)!=0) step0x=(xx4-xx1) / (y4-y1);
if ((y1-y2)!=0) step1x=(xx1-xx2) / (y1-y2);
if ((y2-y3)!=0) step2x=(xx2-xx3) / (y2-y3);
if ((y3-y4)!=0) step3x=(xx3-xx4) / (y3-y4);
if (y1<y4) mark0x=xx1; else mark0x=xx4;
if (y1<y2) mark1x=xx1; else mark1x=xx2;
if (y2<y3) mark2x=xx2; else mark2x=xx3;
if (y3<y4) mark3x=xx3; else mark3x=xx4;

if (backcull==1)
	{
	m1=x1-x4; d1=y1-y4;
	m2=x2-x1; d2=y2-y1;
	if ((m2*-d1)-(d2*-m1)<0) return 0;   //backface culling
	}

for (y=mny; y<mxy; y++)
{
    mnx=xxdim << 16;                  //to clip the screen
    mxx=000   << 16;
   tmnx=xxdim << 16;
   tmxx=000   << 16;
   tmny=yydim << 16;
   tmxy=000   << 16;

   if (y1!=y4) {
     if (((y4>=y) && (y1<=y)) || ((y1>=y) && (y4<=y))) {
         if (mark0x>mxx) { mxx=mark0x; tmxx=tmark0x; tmxy=tmark0y; }
         if (mark0x<mnx) { mnx=mark0x; tmnx=tmark0x; tmny=tmark0y; }
         tmark0x=(tmark0x+tstep0x);
         tmark0y=(tmark0y+tstep0y);
         mark0x=(mark0x+step0x);
        }
   }

   if (y1!=y2) {
     if (((y2>=y) && (y1<=y)) || ((y1>=y) && (y2<=y))) {
         if (mark1x>mxx) { mxx=mark1x; tmxy=tmark1y; tmxx=tmark1x; }
         if (mark1x<mnx) { mnx=mark1x; tmny=tmark1y; tmnx=tmark1x; }
         tmark1x=(tmark1x+tstep1x);
         tmark1y=(tmark1y+tstep1y);
         mark1x=(mark1x+step1x);
        }
   }

   if (y2!=y3) {
     if (((y3>=y) && (y2<=y)) || ((y2>=y) && (y3<=y))) {
         if (mark2x>mxx) { mxx=mark2x; tmxx=tmark2x; tmxy=tmark2y; }
         if (mark2x<mnx) { mnx=mark2x; tmnx=tmark2x; tmny=tmark2y; }
         tmark2x=(tmark2x+tstep2x);
         tmark2y=(tmark2y+tstep2y);
         mark2x=(mark2x+step2x);
        }
   }
   
   if (y3!=y4) {
     if (((y4>=y) && (y3<=y)) || ((y3>=y) && (y4<=y))) {
         if (mark3x>mxx) { mxx=mark3x; tmxx=tmark3x; tmxy=tmark3y; }
         if (mark3x<mnx) { mnx=mark3x; tmnx=tmark3x; tmny=tmark3y; }
         tmark3x=(tmark3x+tstep3x);
         tmark3y=(tmark3y+tstep3y);
         mark3x=(mark3x+step3x);
     }
   }
   
   mnx=mnx >> 16;
   mxx=mxx >> 16;
   if ((y>=0) && (y<yydim)) 
     if (mnx<mxx) {

          if ((mnx-mxx)!=0) tdx=(tmnx-tmxx) / ((mnx-mxx));
          if ((mnx-mxx)!=0) tdy=(tmny-tmxy) / ((mnx-mxx));
       dx1=tmnx;
       dy1=tmny;
          while (mnx<0) 
          {
            dx1=dx1+tdx;
            dy1=dy1+tdy;
            mnx=mnx+1;
          }
       tmnx=dx1;
       tmny=dy1;

       dx1=tmxx;
       dy1=tmxy;
          while (mxx>xxdim) 
          {
            dx1=dx1-tdx;
            dy1=dy1-tdy;      
            mxx=mxx-1;
          }; 
       tmxx=dx1;
       tmxy=dy1;

       if ((mnx-mxx)!=0) tdx=(tmnx-tmxx) / ((mnx-mxx));
       if ((mnx-mxx)!=0) tdy=(tmny-tmxy) / ((mnx-mxx));
       dx1=tmnx;
       dy1=tmny;
       if (drawstyle==0) hline_flat_(mnx,mxx,y,addr,col);
       if (drawstyle==2) hline_tmap_transp_(mnx,mxx,y,dx1,dy1,tdx,tdy,srcy,addr);
       if (drawstyle==7) hline_tmap_(mnx,mxx,y,dx1,dy1,tdx,tdy,srcy,addr);

   }
 }
return 0;
}







surface::loadTGA(char *pakname, char *textstring)   
{

struct TGAdata {

     char  ifield_size;

     char  cmap_type;

     char  imap_type;

     short cmap_origin;
     char  cmap_length;
     char  cmap_size;

     short imap_x,imap_y;
     short imap_width,imap_height;
     char  imap_depth;
     char  imap_info;

     char  image_id[256];
     };
struct TGAdata tga;




if ((size==0) && (addr==NULL))
	{
	
	//1st find the file in the .PAK archive.
	char fname[13];
	char fname2[13];
	long pos;
	long fsize;
	FILE *indexfile;

	strncpy(fname,"************",13);
	strncpy(fname2,"************",13);
	strncpy(fname2,textstring,strlen(textstring));
	fname2[12]=0;
	//printf("$$ [%s]\n",fname2);
	//printf("$$ [%s]\n",fname);
	pos=0; fsize=0;
	indexfile = fopen("index.dat","rb");
	while ((!feof(indexfile)) && (strcmp(fname,fname2)))  //(fname!=fname2))
		{
		pos+=fsize;
		fread(&fname,12,1,indexfile);
		fname[12]=0;
		fread(&fsize,4,1,indexfile);
		}

	fclose(indexfile);

	//if (!feof(indexfile)) printf("[%s] - %i bytes - <%i>\n\n",fname,fsize,pos);

	FILE *fp1;
	fp1 = fopen(pakname,"rb");
	fseek(fp1,pos,SEEK_SET);
	fread(&tga,18,1,fp1);
	fread(&tga.image_id[0],sizeof(tga.ifield_size)-1,1,fp1);
	tga.cmap_origin=(tga.cmap_origin>>8)+(tga.cmap_origin<<8);
	tga.cmap_length=(tga.cmap_length<<8)-1;

	size=(tga.imap_width*tga.imap_height*2);
	addr=(char *)malloc(size);
	xdim=tga.imap_width;
	ydim=tga.imap_height;
	depth=16;	//constant until l8r!!
	fread(addr,(tga.imap_width*tga.imap_height),2,fp1);
	fclose(fp1);
	if (depth==16) CONVERT15_to_16_(addr,size);
	}
}



surface::ripple(char *dest,long xxdim,long yydim,long angle1,long angle2,long angle3)
{
//hardcoded for speed.

long x,y;
long pos1,pos2;

pos1=0;
angle2=angle2%40;
if (depth==16)
	for (int yloop=0; yloop<ydim; yloop++)
	{
	angle3++;
	angle1=angle3*2;
	angle3=angle3%360;
	x=((sintab[angle3]*angle2)>>15);
	for (int xloop=0; xloop<xdim; xloop++)
	{
	angle1++;
	angle1=angle1%360;
	y=yloop+((costab[angle1]*angle2)>>15);
	pos1+=2;
	if ((x+xloop<xdim) && (y<ydim) && (x+xloop>=0) && (y>=0))
		{
//		memcpy(dest+(xloop<<1)+((yloop<<1)*xxdim),addr+(x<<1)+((y<<1)*xdim),2);
		//pos1=(((yloop<<8)+(yloop<<6))<<1)+(xloop<<1);
		pos2=( ( (y<<8)+(y<<6) )<<1)+((x+xloop)<<1);
		memcpy(dest+pos1,addr+pos2,2);
		}
	}
	}
}


surface::killl()
{
	free(addr);
	size=0;
	addr=NULL;
	xdim=0;
	ydim=0;
	depth=0;
}
