
//${CONFIG_BEGIN}
CFG_BINARY_FILES="*.bin|*.dat";
CFG_BRL_GAMETARGET_IMPLEMENTED="1";
CFG_BRL_THREAD_IMPLEMENTED="1";
CFG_CD="";
CFG_CONFIG="release";
CFG_GLFW_COPY_LIBS="openal32";
CFG_GLFW_GCC_LIB_OPTS="-lopenal32";
CFG_HOST="winnt";
CFG_HTML5_WEBAUDIO_ENABLED="1";
CFG_IMAGE_FILES="*.png|*.jpg";
CFG_LANG="js";
CFG_MODPATH="";
CFG_MOJO_AUTO_SUSPEND_ENABLED="1";
CFG_MOJO_DRIVER_IMPLEMENTED="1";
CFG_MUSIC_FILES="*.wav|*.ogg|*.mp3|*.m4a";
CFG_OPENGL_GLES20_ENABLED="0";
CFG_SAFEMODE="0";
CFG_SOUND_FILES="*.wav|*.ogg|*.mp3|*.m4a";
CFG_TARGET="html5";
CFG_TEXT_FILES="*.txt|*.xml|*.json";
//${CONFIG_END}

//${METADATA_BEGIN}
var META_DATA="[mojo_font.png];type=image/png;width=864;height=13;\n[back.png];type=image/png;width=640;height=480;\n[back_bk.png];type=image/png;width=640;height=480;\n[ball.png];type=image/png;width=51;height=51;\n[ball_shadow.png];type=image/png;width=51;height=51;\n[ballbk.png];type=image/png;width=64;height=64;\n[cub.png];type=image/png;width=327;height=647;\n[cubetex.png];type=image/png;width=64;height=64;\n[fonti.png];type=image/png;width=1728;height=26;\n[fonti_big.png];type=image/png;width=5184;height=64;\n[fonti_mir.png];type=image/png;width=1728;height=26;\n[mojo_font.png];type=image/png;width=864;height=13;\n[scanlines.png];type=image/png;width=640;height=480;\n[stars.png];type=image/png;width=640;height=240;\n[stars2.png];type=image/png;width=640;height=240;\n";
//${METADATA_END}

//${TRANSCODE_BEGIN}

// Javascript Cerberus runtime.
//
// Placed into the public domain 24/02/2011.
// No warranty implied; use at your own risk.

//***** JavaScript Runtime *****

var D2R=0.017453292519943295;
var R2D=57.29577951308232;

var err_info="";
var err_stack=[];

var dbg_index=0;

function push_err(){
	err_stack.push( err_info );
}

function pop_err(){
	err_info=err_stack.pop();
}

function stackTrace(){
	if( !err_info.length ) return "";
	var str=err_info+"\n";
	for( var i=err_stack.length-1;i>0;--i ){
		str+=err_stack[i]+"\n";
	}
	return str;
}

function print( str ){
	var cons=document.getElementById( "GameConsole" );
	if( cons ){
		cons.value+=str+"\n";
		cons.scrollTop=cons.scrollHeight-cons.clientHeight;
	}else if( window.console!=undefined ){
		window.console.log( str );
	}
	return 0;
}

function alertError( err ){
	if( typeof(err)=="string" && err=="" ) return;
	alert( "Cerberus Runtime Error : "+err.toString()+"\n\n"+stackTrace() );
}

function error( err ){
	throw err;
}

//function debugLog( str ){
//	if( window.console!=undefined ) window.console.log( str );
//}

function debugLog( str ){
	var cons=document.getElementById( "GameConsole" );
	if( cons ){
		cons.value+=str+"\n";
		cons.scrollTop=cons.scrollHeight-cons.clientHeight;
	}else if( window.console!=undefined ){
		window.console.log( str );
	}
	return 0;
}

function debugStop(){
	debugger;	//	error( "STOP" );
}

function dbg_object( obj ){
	if( obj ) return obj;
	error( "Null object access" );
}

function dbg_charCodeAt( str,index ){
	if( index<0 || index>=str.length ) error( "Character index out of range" );
	return str.charCodeAt( index );
}

function dbg_array( arr,index ){
	if( index<0 || index>=arr.length ) error( "Array index out of range" );
	dbg_index=index;
	return arr;
}

function new_bool_array( len ){
	var arr=Array( len );
	for( var i=0;i<len;++i ) arr[i]=false;
	return arr;
}

function new_number_array( len ){
	var arr=Array( len );
	for( var i=0;i<len;++i ) arr[i]=0;
	return arr;
}

function new_string_array( len ){
	var arr=Array( len );
	for( var i=0;i<len;++i ) arr[i]='';
	return arr;
}

function new_array_array( len ){
	var arr=Array( len );
	for( var i=0;i<len;++i ) arr[i]=[];
	return arr;
}

function new_object_array( len ){
	var arr=Array( len );
	for( var i=0;i<len;++i ) arr[i]=null;
	return arr;
}

function resize_bool_array( arr,len ){
	var i=arr.length;
	arr=arr.slice(0,len);
	if( len<=i ) return arr;
	arr.length=len;
	while( i<len ) arr[i++]=false;
	return arr;
}

function resize_number_array( arr,len ){
	var i=arr.length;
	arr=arr.slice(0,len);
	if( len<=i ) return arr;
	arr.length=len;
	while( i<len ) arr[i++]=0;
	return arr;
}

function resize_string_array( arr,len ){
	var i=arr.length;
	arr=arr.slice(0,len);
	if( len<=i ) return arr;
	arr.length=len;
	while( i<len ) arr[i++]="";
	return arr;
}

function resize_array_array( arr,len ){
	var i=arr.length;
	arr=arr.slice(0,len);
	if( len<=i ) return arr;
	arr.length=len;
	while( i<len ) arr[i++]=[];
	return arr;
}

function resize_object_array( arr,len ){
	var i=arr.length;
	arr=arr.slice(0,len);
	if( len<=i ) return arr;
	arr.length=len;
	while( i<len ) arr[i++]=null;
	return arr;
}

function string_compare( lhs,rhs ){
	var n=Math.min( lhs.length,rhs.length ),i,t;
	for( i=0;i<n;++i ){
		t=lhs.charCodeAt(i)-rhs.charCodeAt(i);
		if( t ) return t;
	}
	return lhs.length-rhs.length;
}

function string_replace( str,find,rep ){	//no unregex replace all?!?
	var i=0;
	for(;;){
		i=str.indexOf( find,i );
		if( i==-1 ) return str;
		str=str.substring( 0,i )+rep+str.substring( i+find.length );
		i+=rep.length;
	}
}

function string_trim( str ){
	var i=0,i2=str.length;
	while( i<i2 && str.charCodeAt(i)<=32 ) i+=1;
	while( i2>i && str.charCodeAt(i2-1)<=32 ) i2-=1;
	return str.slice( i,i2 );
}

function string_startswith( str,substr ){
	return substr.length<=str.length && str.slice(0,substr.length)==substr;
}

function string_endswith( str,substr ){
	return substr.length<=str.length && str.slice(str.length-substr.length,str.length)==substr;
}

function string_tochars( str ){
	var arr=new Array( str.length );
	for( var i=0;i<str.length;++i ) arr[i]=str.charCodeAt(i);
	return arr;
}

function string_fromchars( chars ){
	var str="",i;
	for( i=0;i<chars.length;++i ){
		str+=String.fromCharCode( chars[i] );
	}
	return str;
}

function object_downcast( obj,clas ){
	if( obj instanceof clas ) return obj;
	return null;
}

function object_implements( obj,iface ){
	if( obj && obj.implments && obj.implments[iface] ) return obj;
	return null;
}

function extend_class( clas ){
	var tmp=function(){};
	tmp.prototype=clas.prototype;
	return new tmp;
}

function ThrowableObject(){
}

ThrowableObject.prototype.toString=function(){ 
	return "Uncaught Cerberus Exception"; 
}


function BBGameEvent(){}
BBGameEvent.KeyDown=1;
BBGameEvent.KeyUp=2;
BBGameEvent.KeyChar=3;
BBGameEvent.MouseDown=4;
BBGameEvent.MouseUp=5;
BBGameEvent.MouseMove=6;
BBGameEvent.TouchDown=7;
BBGameEvent.TouchUp=8;
BBGameEvent.TouchMove=9;
BBGameEvent.MotionAccel=10;

function BBGameDelegate(){}
BBGameDelegate.prototype.StartGame=function(){}
BBGameDelegate.prototype.SuspendGame=function(){}
BBGameDelegate.prototype.ResumeGame=function(){}
BBGameDelegate.prototype.UpdateGame=function(){}
BBGameDelegate.prototype.RenderGame=function(){}
BBGameDelegate.prototype.KeyEvent=function( ev,data ){}
BBGameDelegate.prototype.MouseEvent=function( ev,data,x,y,z ){}
BBGameDelegate.prototype.TouchEvent=function( ev,data,x,y ){}
BBGameDelegate.prototype.MotionEvent=function( ev,data,x,y,z ){}
BBGameDelegate.prototype.DiscardGraphics=function(){}

function BBDisplayMode( width,height ){
	this.width=width;
	this.height=height;
}

function BBGame(){
	BBGame._game=this;
	this._delegate=null;
	this._keyboardEnabled=false;
	this._updateRate=0;
	this._started=false;
	this._suspended=false;
	this._debugExs=(CFG_CONFIG=="debug");
	this._startms=Date.now();
}

BBGame.Game=function(){
	return BBGame._game;
}

BBGame.prototype.SetDelegate=function( delegate ){
	this._delegate=delegate;
}

BBGame.prototype.Delegate=function(){
	return this._delegate;
}

BBGame.prototype.SetUpdateRate=function( updateRate ){
	this._updateRate=updateRate;
}

BBGame.prototype.SetKeyboardEnabled=function( keyboardEnabled ){
	this._keyboardEnabled=keyboardEnabled;
}

BBGame.prototype.Started=function(){
	return this._started;
}

BBGame.prototype.Suspended=function(){
	return this._suspended;
}

BBGame.prototype.Millisecs=function(){
	return Date.now()-this._startms;
}

BBGame.prototype.GetDate=function( date ){
	var n=date.length;
	if( n>0 ){
		var t=new Date();
		date[0]=t.getFullYear();
		if( n>1 ){
			date[1]=t.getMonth()+1;
			if( n>2 ){
				date[2]=t.getDate();
				if( n>3 ){
					date[3]=t.getHours();
					if( n>4 ){
						date[4]=t.getMinutes();
						if( n>5 ){
							date[5]=t.getSeconds();
							if( n>6 ){
								date[6]=t.getMilliseconds();
							}
						}
					}
				}
			}
		}
	}
}

BBGame.prototype.SaveState=function( state ){
	localStorage.setItem( "cerberusstate@"+document.URL,state );	//key can't start with dot in Chrome!
	return 1;
}

BBGame.prototype.LoadState=function(){
	var state=localStorage.getItem( "cerberusstate@"+document.URL );
	if( state ) return state;
	return "";
}

BBGame.prototype.LoadString=function( path ){

	var xhr=new XMLHttpRequest();
	xhr.open( "GET",this.PathToUrl( path ),false );
	
//	if( navigator.userAgent.indexOf( "Chrome/48." )>0 ){
//		xhr.setRequestHeader( "If-Modified-Since","Sat, 1 Jan 2000 00:00:00 GMT" );
//	}
	
	xhr.send( null );
	
	if( xhr.status==200 || xhr.status==0 ) return xhr.responseText;
	
	return "";
}

BBGame.prototype.CountJoysticks=function( update ){
	return 0;
}

BBGame.prototype.PollJoystick=function( port,joyx,joyy,joyz,buttons ){
	return false;
}

BBGame.prototype.OpenUrl=function( url ){
	window.location=url;
}

BBGame.prototype.SetMouseVisible=function( visible ){
	if( visible ){
		this._canvas.style.cursor='default';	
	}else{
		this._canvas.style.cursor="url('data:image/cur;base64,AAACAAEAICAAAAAAAACoEAAAFgAAACgAAAAgAAAAQAAAAAEAIAAAAAAAgBAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA55ZXBgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAOeWVxAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAADnllcGAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////9////////////////////+////////f/////////8%3D'), auto";
	}
}

BBGame.prototype.GetDeviceWidth=function(){
	return 0;
}

BBGame.prototype.GetDeviceHeight=function(){
	return 0;
}

BBGame.prototype.SetDeviceWindow=function( width,height,flags ){
}

BBGame.prototype.GetDisplayModes=function(){
	return new Array();
}

BBGame.prototype.GetDesktopMode=function(){
	return null;
}

BBGame.prototype.SetSwapInterval=function( interval ){
}

BBGame.prototype.PathToFilePath=function( path ){
	return "";
}

//***** js Game *****

BBGame.prototype.PathToUrl=function( path ){
	return path;
}

BBGame.prototype.LoadData=function( path ){

	var xhr=new XMLHttpRequest();
	xhr.open( "GET",this.PathToUrl( path ),false );

	if( xhr.overrideMimeType ) xhr.overrideMimeType( "text/plain; charset=x-user-defined" );
	
//	if( navigator.userAgent.indexOf( "Chrome/48." )>0 ){
//		xhr.setRequestHeader( "If-Modified-Since","Sat, 1 Jan 2000 00:00:00 GMT" );
//	}

	xhr.send( null );
	if( xhr.status!=200 && xhr.status!=0 ) return null;

	var r=xhr.responseText;
	var buf=new ArrayBuffer( r.length );
	var bytes=new Int8Array( buf );
	for( var i=0;i<r.length;++i ){
		bytes[i]=r.charCodeAt( i );
	}
	return buf;
}

//***** INTERNAL ******

BBGame.prototype.Die=function( ex ){

	this._delegate=new BBGameDelegate();
	
	if( !ex.toString() ){
		return;
	}
	
	if( this._debugExs ){
		print( "Cerberus Runtime Error : "+ex.toString() );
		print( stackTrace() );
	}
	
	throw ex;
}

BBGame.prototype.StartGame=function(){

	if( this._started ) return;
	this._started=true;
	
	if( this._debugExs ){
		try{
			this._delegate.StartGame();
		}catch( ex ){
			this.Die( ex );
		}
	}else{
		this._delegate.StartGame();
	}
}

BBGame.prototype.SuspendGame=function(){

	if( !this._started || this._suspended ) return;
	this._suspended=true;
	
	if( this._debugExs ){
		try{
			this._delegate.SuspendGame();
		}catch( ex ){
			this.Die( ex );
		}
	}else{
		this._delegate.SuspendGame();
	}
}

BBGame.prototype.ResumeGame=function(){

	if( !this._started || !this._suspended ) return;
	this._suspended=false;
	
	if( this._debugExs ){
		try{
			this._delegate.ResumeGame();
		}catch( ex ){
			this.Die( ex );
		}
	}else{
		this._delegate.ResumeGame();
	}
}

BBGame.prototype.UpdateGame=function(){

	if( !this._started || this._suspended ) return;

	if( this._debugExs ){
		try{
			this._delegate.UpdateGame();
		}catch( ex ){
			this.Die( ex );
		}	
	}else{
		this._delegate.UpdateGame();
	}
}

BBGame.prototype.RenderGame=function(){

	if( !this._started ) return;
	
	if( this._debugExs ){
		try{
			this._delegate.RenderGame();
		}catch( ex ){
			this.Die( ex );
		}	
	}else{
		this._delegate.RenderGame();
	}
}

BBGame.prototype.KeyEvent=function( ev,data ){

	if( !this._started ) return;
	
	if( this._debugExs ){
		try{
			this._delegate.KeyEvent( ev,data );
		}catch( ex ){
			this.Die( ex );
		}
	}else{
		this._delegate.KeyEvent( ev,data );
	}
}

BBGame.prototype.MouseEvent=function( ev,data,x,y,z ){

	if( !this._started ) return;
	
	if( this._debugExs ){
		try{
			this._delegate.MouseEvent( ev,data,x,y,z );
		}catch( ex ){
			this.Die( ex );
		}
	}else{
		this._delegate.MouseEvent( ev,data,x,y,z );
	}
}

BBGame.prototype.TouchEvent=function( ev,data,x,y ){

	if( !this._started ) return;
	
	if( this._debugExs ){
		try{
			this._delegate.TouchEvent( ev,data,x,y );
		}catch( ex ){
			this.Die( ex );
		}
	}else{
		this._delegate.TouchEvent( ev,data,x,y );
	}
}

BBGame.prototype.MotionEvent=function( ev,data,x,y,z ){

	if( !this._started ) return;
	
	if( this._debugExs ){
		try{
			this._delegate.MotionEvent( ev,data,x,y,z );
		}catch( ex ){
			this.Die( ex );
		}
	}else{
		this._delegate.MotionEvent( ev,data,x,y,z );
	}
}

BBGame.prototype.DiscardGraphics=function(){

	if( !this._started ) return;
	
	if( this._debugExs ){
		try{
			this._delegate.DiscardGraphics();
		}catch( ex ){
			this.Die( ex );
		}
	}else{
		this._delegate.DiscardGraphics();
	}
}


var webglGraphicsSeq=1;

function BBHtml5Game( canvas ){

	BBGame.call( this );
	BBHtml5Game._game=this;
	this._canvas=canvas;
	this._loading=0;
	this._timerSeq=0;
	this._gl=null;
	
	if( CFG_OPENGL_GLES20_ENABLED=="1" ){

		//can't get these to fire!
		canvas.addEventListener( "webglcontextlost",function( event ){
			event.preventDefault();
//			print( "WebGL context lost!" );
		},false );

		canvas.addEventListener( "webglcontextrestored",function( event ){
			++webglGraphicsSeq;
//			print( "WebGL context restored!" );
		},false );

		var attrs={ alpha:false };
	
		this._gl=this._canvas.getContext( "webgl",attrs );

		if( !this._gl ) this._gl=this._canvas.getContext( "experimental-webgl",attrs );
		
		if( !this._gl ) this.Die( "Can't create WebGL" );
		
		gl=this._gl;
	}
	
	// --- start gamepad api by skn3 ---------
	this._gamepads = null;
	this._gamepadLookup = [-1,-1,-1,-1];//support 4 gamepads
	var that = this;
	window.addEventListener("gamepadconnected", function(e) {
		that.connectGamepad(e.gamepad);
	});
	
	window.addEventListener("gamepaddisconnected", function(e) {
		that.disconnectGamepad(e.gamepad);
	});
	
	//need to process already connected gamepads (before page was loaded)
	var gamepads = this.getGamepads();
	if (gamepads && gamepads.length > 0) {
		for(var index=0;index < gamepads.length;index++) {
			this.connectGamepad(gamepads[index]);
		}
	}
	// --- end gamepad api by skn3 ---------
}

BBHtml5Game.prototype=extend_class( BBGame );

BBHtml5Game.Html5Game=function(){
	return BBHtml5Game._game;
}

// --- start gamepad api by skn3 ---------
BBHtml5Game.prototype.getGamepads = function() {
	return navigator.getGamepads ? navigator.getGamepads() : (navigator.webkitGetGamepads ? navigator.webkitGetGamepads : []);
}

BBHtml5Game.prototype.connectGamepad = function(gamepad) {
	if (!gamepad) {
		return false;
	}
	
	//check if this is a standard gamepad
	if (gamepad.mapping == "standard") {
		//yup so lets add it to an array of valid gamepads
		//find empty controller slot
		var slot = -1;
		for(var index = 0;index < this._gamepadLookup.length;index++) {
			if (this._gamepadLookup[index] == -1) {
				slot = index;
				break;
			}
		}
		
		//can we add this?
		if (slot != -1) {
			this._gamepadLookup[slot] = gamepad.index;
			
			//console.log("gamepad at html5 index "+gamepad.index+" mapped to Cerberus gamepad unit "+slot);
		}
	} else {
		console.log('Cerberus has ignored gamepad at raw port #'+gamepad.index+' with unrecognised mapping scheme \''+gamepad.mapping+'\'.');
	}
}

BBHtml5Game.prototype.disconnectGamepad = function(gamepad) {
	if (!gamepad) {
		return false;
	}
	
	//scan all gamepads for matching index
	for(var index = 0;index < this._gamepadLookup.length;index++) {
		if (this._gamepadLookup[index] == gamepad.index) {
			//remove this gamepad
			this._gamepadLookup[index] = -1
			break;
		}
	}
}

BBHtml5Game.prototype.PollJoystick=function(port, joyx, joyy, joyz, buttons){
	//is this the first gamepad being polled
	if (port == 0) {
		//yes it is so we use the web api to get all gamepad info
		//we can then use this in subsequent calls to PollJoystick
		this._gamepads = this.getGamepads();
	}
	
	//dont bother processing if nothing to process
	if (!this._gamepads) {
	  return false;
	}
	
	//so use the Cerberus port to find the correct raw data
	var index = this._gamepadLookup[port];
	if (index == -1) {
		return false;
	}

	var gamepad = this._gamepads[index];
	if (!gamepad) {
		return false;
	}
	//so now process gamepad axis/buttons according to the standard mappings
	//https://w3c.github.io/gamepad/#remapping
	
	//left stick axis
	joyx[0] = gamepad.axes[0];
	joyy[0] = -gamepad.axes[1];
	
	//right stick axis
	joyx[1] = gamepad.axes[2];
	joyy[1] = -gamepad.axes[3];
	
	//left trigger
	joyz[0] = gamepad.buttons[6] ? gamepad.buttons[6].value : 0.0;
	
	//right trigger
	joyz[1] = gamepad.buttons[7] ? gamepad.buttons[7].value : 0.0;
	
	//clear button states
	for(var index = 0;index <32;index++) {
		buttons[index] = false;
	}
	
	//map html5 "standard" mapping to Cerberuss joy codes
	/*
	Const JOY_A=0
	Const JOY_B=1
	Const JOY_X=2
	Const JOY_Y=3
	Const JOY_LB=4
	Const JOY_RB=5
	Const JOY_BACK=6
	Const JOY_START=7
	Const JOY_LEFT=8
	Const JOY_UP=9
	Const JOY_RIGHT=10
	Const JOY_DOWN=11
	Const JOY_LSB=12
	Const JOY_RSB=13
	Const JOY_MENU=14
	*/
	buttons[0] = gamepad.buttons[0] && gamepad.buttons[0].pressed;
	buttons[1] = gamepad.buttons[1] && gamepad.buttons[1].pressed;
	buttons[2] = gamepad.buttons[2] && gamepad.buttons[2].pressed;
	buttons[3] = gamepad.buttons[3] && gamepad.buttons[3].pressed;
	buttons[4] = gamepad.buttons[4] && gamepad.buttons[4].pressed;
	buttons[5] = gamepad.buttons[5] && gamepad.buttons[5].pressed;
	buttons[6] = gamepad.buttons[8] && gamepad.buttons[8].pressed;
	buttons[7] = gamepad.buttons[9] && gamepad.buttons[9].pressed;
	buttons[8] = gamepad.buttons[14] && gamepad.buttons[14].pressed;
	buttons[9] = gamepad.buttons[12] && gamepad.buttons[12].pressed;
	buttons[10] = gamepad.buttons[15] && gamepad.buttons[15].pressed;
	buttons[11] = gamepad.buttons[13] && gamepad.buttons[13].pressed;
	buttons[12] = gamepad.buttons[10] && gamepad.buttons[10].pressed;
	buttons[13] = gamepad.buttons[11] && gamepad.buttons[11].pressed;
	buttons[14] = gamepad.buttons[16] && gamepad.buttons[16].pressed;
	
	//success
	return true
}
// --- end gamepad api by skn3 ---------


BBHtml5Game.prototype.ValidateUpdateTimer=function(){

	++this._timerSeq;
	if( this._suspended ) return;
	
	var game=this;
	var seq=game._timerSeq;
	
	var maxUpdates=4;
	var updateRate=this._updateRate;
	
	if( !updateRate ){

		var reqAnimFrame=(window.requestAnimationFrame || window.webkitRequestAnimationFrame || window.mozRequestAnimationFrame || window.oRequestAnimationFrame || window.msRequestAnimationFrame);
	
		if( reqAnimFrame ){
			function animate(){
				if( seq!=game._timerSeq ) return;
	
				game.UpdateGame();
				if( seq!=game._timerSeq ) return;
	
				reqAnimFrame( animate );
				game.RenderGame();
			}
			reqAnimFrame( animate );
			return;
		}
		
		maxUpdates=1;
		updateRate=60;
	}
	
	var updatePeriod=1000.0/updateRate;
	var nextUpdate=0;

	function timeElapsed(){
		if( seq!=game._timerSeq ) return;
		
		if( !nextUpdate ) nextUpdate=Date.now();
		
		for( var i=0;i<maxUpdates;++i ){
		
			game.UpdateGame();
			if( seq!=game._timerSeq ) return;
			
			nextUpdate+=updatePeriod;
			var delay=nextUpdate-Date.now();
			
			if( delay>0 ){
				setTimeout( timeElapsed,delay );
				game.RenderGame();
				return;
			}
		}
		nextUpdate=0;
		setTimeout( timeElapsed,0 );
		game.RenderGame();
	}

	setTimeout( timeElapsed,0 );
}

//***** BBGame methods *****

BBHtml5Game.prototype.SetUpdateRate=function( updateRate ){

	BBGame.prototype.SetUpdateRate.call( this,updateRate );
	
	this.ValidateUpdateTimer();
}

BBHtml5Game.prototype.GetMetaData=function( path,key ){
	if( path.indexOf( "cerberus://data/" )!=0 ) return "";
	path=path.slice(16);

	var i=META_DATA.indexOf( "["+path+"]" );
	if( i==-1 ) return "";
	i+=path.length+2;

	var e=META_DATA.indexOf( "\n",i );
	if( e==-1 ) e=META_DATA.length;

	i=META_DATA.indexOf( ";"+key+"=",i )
	if( i==-1 || i>=e ) return "";
	i+=key.length+2;

	e=META_DATA.indexOf( ";",i );
	if( e==-1 ) return "";

	return META_DATA.slice( i,e );
}

BBHtml5Game.prototype.PathToUrl=function( path ){
	if( path.indexOf( "cerberus:" )!=0 ){
		return path;
	}else if( path.indexOf( "cerberus://data/" )==0 ) {
		return "data/"+path.slice( 16 );
	}
	return "";
}

BBHtml5Game.prototype.GetLoading=function(){
	return this._loading;
}

BBHtml5Game.prototype.IncLoading=function(){
	++this._loading;
	return this._loading;
}

BBHtml5Game.prototype.DecLoading=function(){
	--this._loading;
	return this._loading;
}

BBHtml5Game.prototype.GetCanvas=function(){
	return this._canvas;
}

BBHtml5Game.prototype.GetWebGL=function(){
	return this._gl;
}

BBHtml5Game.prototype.GetDeviceWidth=function(){
	return this._canvas.width;
}

BBHtml5Game.prototype.GetDeviceHeight=function(){
	return this._canvas.height;
}

//***** INTERNAL *****

BBHtml5Game.prototype.UpdateGame=function(){

	if( !this._loading ) BBGame.prototype.UpdateGame.call( this );
}

BBHtml5Game.prototype.SuspendGame=function(){

	BBGame.prototype.SuspendGame.call( this );
	
	BBGame.prototype.RenderGame.call( this );
	
	this.ValidateUpdateTimer();
}

BBHtml5Game.prototype.ResumeGame=function(){

	BBGame.prototype.ResumeGame.call( this );
	
	this.ValidateUpdateTimer();
}

BBHtml5Game.prototype.Run=function(){

	var game=this;
	var canvas=game._canvas;
	
	var xscale=1;
	var yscale=1;
	
	var touchIds=new Array( 32 );
	for( i=0;i<32;++i ) touchIds[i]=-1;
	
	function eatEvent( e ){
		if( e.stopPropagation ){
			e.stopPropagation();
			e.preventDefault();
		}else{
			e.cancelBubble=true;
			e.returnValue=false;
		}
	}
	
	function keyToChar( key ){
		switch( key ){
		case 8:case 9:case 13:case 27:case 32:return key;
		case 33:case 34:case 35:case 36:case 37:case 38:case 39:case 40:case 45:return key|0x10000;
		case 46:return 127;
		}
		return 0;
	}
	
	function mouseX( e ){
		var x=e.clientX+document.body.scrollLeft;
		var c=canvas;
		while( c ){
			x-=c.offsetLeft;
			c=c.offsetParent;
		}
		return x*xscale;
	}
	
	function mouseY( e ){
		var y=e.clientY+document.body.scrollTop;
		var c=canvas;
		while( c ){
			y-=c.offsetTop;
			c=c.offsetParent;
		}
		return y*yscale;
	}

	function touchX( touch ){
		var x=touch.pageX;
		var c=canvas;
		while( c ){
			x-=c.offsetLeft;
			c=c.offsetParent;
		}
		return x*xscale;
	}			
	
	function touchY( touch ){
		var y=touch.pageY;
		var c=canvas;
		while( c ){
			y-=c.offsetTop;
			c=c.offsetParent;
		}
		return y*yscale;
	}
	
	canvas.onkeydown=function( e ){
		game.KeyEvent( BBGameEvent.KeyDown,e.keyCode );
		var chr=keyToChar( e.keyCode );
		if( chr ) game.KeyEvent( BBGameEvent.KeyChar,chr );
		if( e.keyCode<48 || (e.keyCode>111 && e.keyCode<122) ) eatEvent( e );
	}

	canvas.onkeyup=function( e ){
		game.KeyEvent( BBGameEvent.KeyUp,e.keyCode );
	}

	canvas.onkeypress=function( e ){
		if( e.charCode ){
			game.KeyEvent( BBGameEvent.KeyChar,e.charCode );
		}else if( e.which ){
			game.KeyEvent( BBGameEvent.KeyChar,e.which );
		}
	}

	canvas.onmousedown=function( e ){
		switch( e.button ){
		case 0:game.MouseEvent( BBGameEvent.MouseDown,0,mouseX(e),mouseY(e) );break;
		case 1:game.MouseEvent( BBGameEvent.MouseDown,2,mouseX(e),mouseY(e) );break;
		case 2:game.MouseEvent( BBGameEvent.MouseDown,1,mouseX(e),mouseY(e) );break;
		}
		eatEvent( e );
	}
	
	canvas.onmouseup=function( e ){
		switch( e.button ){
		case 0:game.MouseEvent( BBGameEvent.MouseUp,0,mouseX(e),mouseY(e) );break;
		case 1:game.MouseEvent( BBGameEvent.MouseUp,2,mouseX(e),mouseY(e) );break;
		case 2:game.MouseEvent( BBGameEvent.MouseUp,1,mouseX(e),mouseY(e) );break;
		}
		eatEvent( e );
	}
	
	canvas.onmousemove=function( e ){
		game.MouseEvent( BBGameEvent.MouseMove,-1,mouseX(e),mouseY(e),0 );
		eatEvent( e );
	}

	canvas.onmouseout=function( e ){
		game.MouseEvent( BBGameEvent.MouseUp,0,mouseX(e),mouseY(e) );
		game.MouseEvent( BBGameEvent.MouseUp,1,mouseX(e),mouseY(e) );
		game.MouseEvent( BBGameEvent.MouseUp,2,mouseX(e),mouseY(e) );
		eatEvent( e );
	}
	
	canvas.onclick=function( e ){
		if( game.Suspended() ){
			canvas.focus();
		}
		eatEvent( e );
		return;
	}
	
	canvas.oncontextmenu=function( e ){
		return false;
	}
	
	canvas.ontouchstart=function( e ){
		if( game.Suspended() ){
			canvas.focus();
		}
		for( var i=0;i<e.changedTouches.length;++i ){
			var touch=e.changedTouches[i];
			for( var j=0;j<32;++j ){
				if( touchIds[j]!=-1 ) continue;
				touchIds[j]=touch.identifier;
				game.TouchEvent( BBGameEvent.TouchDown,j,touchX(touch),touchY(touch) );
				break;
			}
		}
		eatEvent( e );
	}
	
	canvas.ontouchmove=function( e ){
		for( var i=0;i<e.changedTouches.length;++i ){
			var touch=e.changedTouches[i];
			for( var j=0;j<32;++j ){
				if( touchIds[j]!=touch.identifier ) continue;
				game.TouchEvent( BBGameEvent.TouchMove,j,touchX(touch),touchY(touch) );
				break;
			}
		}
		eatEvent( e );
	}
	
	canvas.ontouchend=function( e ){
		for( var i=0;i<e.changedTouches.length;++i ){
			var touch=e.changedTouches[i];
			for( var j=0;j<32;++j ){
				if( touchIds[j]!=touch.identifier ) continue;
				touchIds[j]=-1;
				game.TouchEvent( BBGameEvent.TouchUp,j,touchX(touch),touchY(touch) );
				break;
			}
		}
		eatEvent( e );
	}
	
	window.ondevicemotion=function( e ){
		var tx=e.accelerationIncludingGravity.x/9.81;
		var ty=e.accelerationIncludingGravity.y/9.81;
		var tz=e.accelerationIncludingGravity.z/9.81;
		var x,y;
		switch( window.orientation ){
		case   0:x=+tx;y=-ty;break;
		case 180:x=-tx;y=+ty;break;
		case  90:x=-ty;y=-tx;break;
		case -90:x=+ty;y=+tx;break;
		}
		game.MotionEvent( BBGameEvent.MotionAccel,0,x,y,tz );
		eatEvent( e );
	}

	canvas.onfocus=function( e ){
		if( CFG_MOJO_AUTO_SUSPEND_ENABLED=="1" ){
			game.ResumeGame();
		}else{
			game.ValidateUpdateTimer();
		}
	}
	
	canvas.onblur=function( e ){
		for( var i=0;i<256;++i ) game.KeyEvent( BBGameEvent.KeyUp,i );
		if( CFG_MOJO_AUTO_SUSPEND_ENABLED=="1" ){
			game.SuspendGame();
		}
	}

	canvas.updateSize=function(){
		xscale=canvas.width/canvas.clientWidth;
		yscale=canvas.height/canvas.clientHeight;
		game.RenderGame();
	}
	
	canvas.updateSize();
	
	canvas.focus();
	
	game.StartGame();
	
	game.RenderGame();
}


function BBCerberusGame( canvas ){
	BBHtml5Game.call( this,canvas );
}

BBCerberusGame.prototype=extend_class( BBHtml5Game );

BBCerberusGame.Main=function( canvas ){

	var game=new BBCerberusGame( canvas );

	try{

		bbInit();
		bbMain();

	}catch( ex ){
	
		game.Die( ex );
		return;
	}

	if( !game.Delegate() ) return;
	
	game.Run();
}


// HTML5 mojo runtime.
//
// Copyright 2011 Mark Sibly, all rights reserved.
// No warranty implied; use at your own risk.

// ***** gxtkGraphics class *****

function gxtkGraphics(){
	this.game=BBHtml5Game.Html5Game();
	this.canvas=this.game.GetCanvas()
	this.width=this.canvas.width;
	this.height=this.canvas.height;
	this.gl=null;
	this.gc=this.canvas.getContext( '2d' );
	this.tmpCanvas=null;
	this.r=255;
	this.b=255;
	this.g=255;
	this.white=true;
	this.color="rgb(255,255,255)"
	this.alpha=1;
	this.blend="source-over";
	this.ix=1;this.iy=0;
	this.jx=0;this.jy=1;
	this.tx=0;this.ty=0;
	this.tformed=false;
	this.scissorX=0;
	this.scissorY=0;
	this.scissorWidth=0;
	this.scissorHeight=0;
	this.clipped=false;
}

gxtkGraphics.prototype.BeginRender=function(){
	this.width=this.canvas.width;
	this.height=this.canvas.height;
	if( !this.gc ) return 0;
	this.gc.save();
	if( this.game.GetLoading() ) return 2;
	return 1;
}

gxtkGraphics.prototype.EndRender=function(){
	if( this.gc ) this.gc.restore();
}

gxtkGraphics.prototype.Width=function(){
	return this.width;
}

gxtkGraphics.prototype.Height=function(){
	return this.height;
}

gxtkGraphics.prototype.LoadSurface=function( path ){
	var game=this.game;

	var ty=game.GetMetaData( path,"type" );
	if( ty.indexOf( "image/" )!=0 ) return null;
	
	game.IncLoading();

	var image=new Image();
	image.onload=function(){ game.DecLoading(); }
	image.onerror=function(){ game.DecLoading(); }
	image.meta_width=parseInt( game.GetMetaData( path,"width" ) );
	image.meta_height=parseInt( game.GetMetaData( path,"height" ) );
	image.src=game.PathToUrl( path );

	return new gxtkSurface( image,this );
}

gxtkGraphics.prototype.CreateSurface=function( width,height ){
	var canvas=document.createElement( 'canvas' );
	
	canvas.width=width;
	canvas.height=height;
	canvas.meta_width=width;
	canvas.meta_height=height;
	canvas.complete=true;
	
	var surface=new gxtkSurface( canvas,this );
	
	surface.gc=canvas.getContext( '2d' );
	
	return surface;
}

gxtkGraphics.prototype.SetAlpha=function( alpha ){
	this.alpha=alpha;
	this.gc.globalAlpha=alpha;
}

gxtkGraphics.prototype.SetColor=function( r,g,b ){
	this.r=r;
	this.g=g;
	this.b=b;
	this.white=(r==255 && g==255 && b==255);
	this.color="rgb("+(r|0)+","+(g|0)+","+(b|0)+")";
	this.gc.fillStyle=this.color;
	this.gc.strokeStyle=this.color;
}

gxtkGraphics.prototype.SetBlend=function( blend ){
	switch( blend ){
	case 1:
		this.blend="lighter";
		break;
	default:
		this.blend="source-over";
	}
	this.gc.globalCompositeOperation=this.blend;
}

gxtkGraphics.prototype.SetScissor=function( x,y,w,h ){
	this.scissorX=x;
	this.scissorY=y;
	this.scissorWidth=w;
	this.scissorHeight=h;
	this.clipped=(x!=0 || y!=0 || w!=this.canvas.width || h!=this.canvas.height);
	this.gc.restore();
	this.gc.save();
	if( this.clipped ){
		this.gc.beginPath();
		this.gc.rect( x,y,w,h );
		this.gc.clip();
		this.gc.closePath();
	}
	this.gc.fillStyle=this.color;
	this.gc.strokeStyle=this.color;	
	this.gc.globalAlpha=this.alpha;	
	this.gc.globalCompositeOperation=this.blend;
	if( this.tformed ) this.gc.setTransform( this.ix,this.iy,this.jx,this.jy,this.tx,this.ty );
}

gxtkGraphics.prototype.SetMatrix=function( ix,iy,jx,jy,tx,ty ){
	this.ix=ix;this.iy=iy;
	this.jx=jx;this.jy=jy;
	this.tx=tx;this.ty=ty;
	this.gc.setTransform( ix,iy,jx,jy,tx,ty );
	this.tformed=(ix!=1 || iy!=0 || jx!=0 || jy!=1 || tx!=0 || ty!=0);
}

gxtkGraphics.prototype.Cls=function( r,g,b ){
	if( this.tformed ) this.gc.setTransform( 1,0,0,1,0,0 );
	this.gc.fillStyle="rgb("+(r|0)+","+(g|0)+","+(b|0)+")";
	this.gc.globalAlpha=1;
	this.gc.globalCompositeOperation="source-over";
	this.gc.fillRect( 0,0,this.canvas.width,this.canvas.height );
	this.gc.fillStyle=this.color;
	this.gc.globalAlpha=this.alpha;
	this.gc.globalCompositeOperation=this.blend;
	if( this.tformed ) this.gc.setTransform( this.ix,this.iy,this.jx,this.jy,this.tx,this.ty );
}

gxtkGraphics.prototype.DrawPoint=function( x,y ){
	if( this.tformed ){
		var px=x;
		x=px * this.ix + y * this.jx + this.tx;
		y=px * this.iy + y * this.jy + this.ty;
		this.gc.setTransform( 1,0,0,1,0,0 );
		this.gc.fillRect( x,y,1,1 );
		this.gc.setTransform( this.ix,this.iy,this.jx,this.jy,this.tx,this.ty );
	}else{
		this.gc.fillRect( x,y,1,1 );
	}
}

gxtkGraphics.prototype.DrawRect=function( x,y,w,h ){
	if( w<0 ){ x+=w;w=-w; }
	if( h<0 ){ y+=h;h=-h; }
	if( w<=0 || h<=0 ) return;
	//
	this.gc.fillRect( x,y,w,h );
}

gxtkGraphics.prototype.DrawLine=function( x1,y1,x2,y2 ){
	if( this.tformed ){
		var x1_t=x1 * this.ix + y1 * this.jx + this.tx;
		var y1_t=x1 * this.iy + y1 * this.jy + this.ty;
		var x2_t=x2 * this.ix + y2 * this.jx + this.tx;
		var y2_t=x2 * this.iy + y2 * this.jy + this.ty;
		this.gc.setTransform( 1,0,0,1,0,0 );
	  	this.gc.beginPath();
	  	this.gc.moveTo( x1_t,y1_t );
	  	this.gc.lineTo( x2_t,y2_t );
	  	this.gc.stroke();
	  	this.gc.closePath();
		this.gc.setTransform( this.ix,this.iy,this.jx,this.jy,this.tx,this.ty );
	}else{
	  	this.gc.beginPath();
	  	this.gc.moveTo( x1,y1 );
	  	this.gc.lineTo( x2,y2 );
	  	this.gc.stroke();
	  	this.gc.closePath();
	}
}

gxtkGraphics.prototype.DrawOval=function( x,y,w,h ){
	if( w<0 ){ x+=w;w=-w; }
	if( h<0 ){ y+=h;h=-h; }
	if( w<=0 || h<=0 ) return;
	//
  	var w2=w/2,h2=h/2;
	this.gc.save();
	this.gc.translate( x+w2,y+h2 );
	this.gc.scale( w2,h2 );
  	this.gc.beginPath();
	this.gc.arc( 0,0,1,0,Math.PI*2,false );
	this.gc.fill();
  	this.gc.closePath();
	this.gc.restore();
}

gxtkGraphics.prototype.DrawPoly=function( verts ){
	if( verts.length<2 ) return;
	this.gc.beginPath();
	this.gc.moveTo( verts[0],verts[1] );
	for( var i=2;i<verts.length;i+=2 ){
		this.gc.lineTo( verts[i],verts[i+1] );
	}
	this.gc.fill();
	this.gc.closePath();
}

gxtkGraphics.prototype.DrawPoly2=function( verts,surface,srx,srcy ){
	if( verts.length<4 ) return;
	this.gc.beginPath();
	this.gc.moveTo( verts[0],verts[1] );
	for( var i=4;i<verts.length;i+=4 ){
		this.gc.lineTo( verts[i],verts[i+1] );
	}
	this.gc.fill();
	this.gc.closePath();
}

gxtkGraphics.prototype.DrawSurface=function( surface,x,y ){
	if( !surface.image.complete ) return;
	
	if( this.white ){
		this.gc.drawImage( surface.image,x,y );
		return;
	}
	
	this.DrawImageTinted( surface.image,x,y,0,0,surface.swidth,surface.sheight );
}

gxtkGraphics.prototype.DrawSurface2=function( surface,x,y,srcx,srcy,srcw,srch ){
	if( !surface.image.complete ) return;

	if( srcw<0 ){ srcx+=srcw;srcw=-srcw; }
	if( srch<0 ){ srcy+=srch;srch=-srch; }
	if( srcw<=0 || srch<=0 ) return;

	if( this.white ){
		this.gc.drawImage( surface.image,srcx,srcy,srcw,srch,x,y,srcw,srch );
		return;
	}
	
	this.DrawImageTinted( surface.image,x,y,srcx,srcy,srcw,srch  );
}

gxtkGraphics.prototype.DrawImageTinted=function( image,dx,dy,sx,sy,sw,sh ){

	if( !this.tmpCanvas ){
		this.tmpCanvas=document.createElement( "canvas" );
	}

	if( sw>this.tmpCanvas.width || sh>this.tmpCanvas.height ){
		this.tmpCanvas.width=Math.max( sw,this.tmpCanvas.width );
		this.tmpCanvas.height=Math.max( sh,this.tmpCanvas.height );
	}
	
	var tmpGC=this.tmpCanvas.getContext( "2d" );
	tmpGC.globalCompositeOperation="copy";
	
	tmpGC.drawImage( image,sx,sy,sw,sh,0,0,sw,sh );
	
	var imgData=tmpGC.getImageData( 0,0,sw,sh );
	
	var p=imgData.data,sz=sw*sh*4,i;
	
	for( i=0;i<sz;i+=4 ){
		p[i]=p[i]*this.r/255;
		p[i+1]=p[i+1]*this.g/255;
		p[i+2]=p[i+2]*this.b/255;
	}
	
	tmpGC.putImageData( imgData,0,0 );
	
	this.gc.drawImage( this.tmpCanvas,0,0,sw,sh,dx,dy,sw,sh );
}

gxtkGraphics.prototype.ReadPixels=function( pixels,x,y,width,height,offset,pitch ){

	var imgData=this.gc.getImageData( x,y,width,height );
	
	var p=imgData.data,i=0,j=offset,px,py;
	
	for( py=0;py<height;++py ){
		for( px=0;px<width;++px ){
			pixels[j++]=(p[i+3]<<24)|(p[i]<<16)|(p[i+1]<<8)|p[i+2];
			i+=4;
		}
		j+=pitch-width;
	}
}

gxtkGraphics.prototype.WritePixels2=function( surface,pixels,x,y,width,height,offset,pitch ){

	if( !surface.gc ){
		if( !surface.image.complete ) return;
		var canvas=document.createElement( "canvas" );
		canvas.width=surface.swidth;
		canvas.height=surface.sheight;
		surface.gc=canvas.getContext( "2d" );
		surface.gc.globalCompositeOperation="copy";
		surface.gc.drawImage( surface.image,0,0 );
		surface.image=canvas;
	}

	var imgData=surface.gc.createImageData( width,height );

	var p=imgData.data,i=0,j=offset,px,py,argb;
	
	for( py=0;py<height;++py ){
		for( px=0;px<width;++px ){
			argb=pixels[j++];
			p[i]=(argb>>16) & 0xff;
			p[i+1]=(argb>>8) & 0xff;
			p[i+2]=argb & 0xff;
			p[i+3]=(argb>>24) & 0xff;
			i+=4;
		}
		j+=pitch-width;
	}
	
	surface.gc.putImageData( imgData,x,y );
}

// ***** gxtkSurface class *****

function gxtkSurface( image,graphics ){
	this.image=image;
	this.graphics=graphics;
	this.swidth=image.meta_width;
	this.sheight=image.meta_height;
}

// ***** GXTK API *****

gxtkSurface.prototype.Discard=function(){
	if( this.image ){
		this.image=null;
	}
}

gxtkSurface.prototype.Width=function(){
	return this.swidth;
}

gxtkSurface.prototype.Height=function(){
	return this.sheight;
}

gxtkSurface.prototype.Loaded=function(){
	return this.image.complete;
}

gxtkSurface.prototype.OnUnsafeLoadComplete=function(){
}

if( CFG_HTML5_WEBAUDIO_ENABLED=="1" && (window.AudioContext || window.webkitAudioContext) ){

//print( "Using WebAudio!" );

// ***** WebAudio *****

var wa=null;

// ***** WebAudio gxtkSample *****

var gxtkSample=function(){
	this.waBuffer=null;
	this.state=0;
}

gxtkSample.prototype.Load=function( path ){
	if( this.state ) return false;

	var req=new XMLHttpRequest();
	
	req.open( "get",BBGame.Game().PathToUrl( path ),true );
	req.responseType="arraybuffer";
	
	var abuf=this;
	
	req.onload=function(){
		wa.decodeAudioData( req.response,function( buffer ){
			//success!
			abuf.waBuffer=buffer;
			abuf.state=1;
		},function(){
			abuf.state=-1;
		} );
	}
	
	req.onerror=function(){
		abuf.state=-1;
	}
	
	req.send();
	
	this.state=2;
			
	return true;
}

gxtkSample.prototype.Discard=function(){
}

// ***** WebAudio gxtkChannel *****

var gxtkChannel=function(){
	this.buffer=null;
	this.flags=0;
	this.volume=1;
	this.pan=0;
	this.rate=1;
	this.waSource=null;
	this.waPan=wa.create
	this.waGain=wa.createGain();
	this.waGain.connect( wa.destination );
	this.waPanner=wa.createPanner();
	this.waPanner.rolloffFactor=0;
	this.waPanner.panningModel="equalpower";
	this.waPanner.connect( this.waGain );
	this.startTime=0;
	this.offset=0;
	this.state=0;
}

// ***** WebAudio gxtkAudio *****

var gxtkAudio=function(){

	if( !wa ){
		window.AudioContext=window.AudioContext || window.webkitAudioContext;
		wa=new AudioContext();
	}
	
	this.okay=true;
	this.music=null;
	this.musicState=0;
	this.musicVolume=1;
	this.channels=new Array();
	for( var i=0;i<32;++i ){
		this.channels[i]=new gxtkChannel();
	}
}

gxtkAudio.prototype.Suspend=function(){
	if( this.MusicState()==1 ) this.music.pause();
	for( var i=0;i<32;++i ){
		var chan=this.channels[i];
		if( chan.state!=1 ) continue;
		this.PauseChannel( i );
		chan.state=5;
	}
}

gxtkAudio.prototype.Resume=function(){
	if( this.MusicState()==1 ) this.music.play();
	for( var i=0;i<32;++i ){
		var chan=this.channels[i];
		if( chan.state!=5 ) continue;
		chan.state=2;
		this.ResumeChannel( i );
	}
}

gxtkAudio.prototype.LoadSample=function( path ){

	var sample=new gxtkSample();
	if( !sample.Load( BBHtml5Game.Html5Game().PathToUrl( path ) ) ) return null;
	
	return sample;
}

gxtkAudio.prototype.PlaySample=function( buffer,channel,flags ){

	if( buffer.state!=1 ) return;

	var chan=this.channels[channel];
	
	if( chan.state ){
		chan.waSource.onended=null
		try {
			chan.waSource.stop( 0 );
			chan.state = 0			
		} catch (err) {			
		}
	}
	
	chan.buffer=buffer;
	chan.flags=flags;

	chan.waSource=wa.createBufferSource();
	chan.waSource.buffer=buffer.waBuffer;
	chan.waSource.playbackRate.value=chan.rate;
	chan.waSource.loop=(flags&1)!=0;
	chan.waSource.connect( chan.waPanner );
	
	chan.waSource.onended=function( e ){
		chan.waSource=null;
		chan.state=0;
	}

	chan.offset=0;	
	chan.startTime=wa.currentTime;
	chan.waSource.start( 0 );

	chan.state=1;
}

gxtkAudio.prototype.StopChannel=function( channel ){

	var chan=this.channels[channel];
	if( !chan.state ) return;
	
	if( chan.state==1 ){
		chan.waSource.onended=null;
		try {
			chan.waSource.stop( 0 );
		} catch (err) {			
		}
		chan.waSource=null;
	}

	chan.state=0;
}

gxtkAudio.prototype.PauseChannel=function( channel ){

	var chan=this.channels[channel];
	if( chan.state!=1 ) return;
	
	chan.offset=(chan.offset+(wa.currentTime-chan.startTime)*chan.rate)%chan.buffer.waBuffer.duration;
	
	chan.waSource.onended=null;
	try {
		chan.waSource.stop( 0 );
	} catch (err) {			
	}
	chan.waSource=null;
	
	chan.state=2;
}

gxtkAudio.prototype.ResumeChannel=function( channel ){

	var chan=this.channels[channel];
	if( chan.state!=2 ) return;
	
	chan.waSource=wa.createBufferSource();
	chan.waSource.buffer=chan.buffer.waBuffer;
	chan.waSource.playbackRate.value=chan.rate;
	chan.waSource.loop=(chan.flags&1)!=0;
	chan.waSource.connect( chan.waPanner );
	
	chan.waSource.onended=function( e ){
		chan.waSource=null;
		chan.state=0;
	}
	
	chan.startTime=wa.currentTime;
	chan.waSource.start( 0,chan.offset );

	chan.state=1;
}

gxtkAudio.prototype.ChannelState=function( channel ){
	return this.channels[channel].state & 3;
}

gxtkAudio.prototype.SetVolume=function( channel,volume ){
	var chan=this.channels[channel];

	chan.volume=volume;
	
	chan.waGain.gain.value=volume;
}

gxtkAudio.prototype.SetPan=function( channel,pan ){
	var chan=this.channels[channel];

	chan.pan=pan;
	
	var sin=Math.sin( pan*3.14159265359/2 );
	var cos=Math.cos( pan*3.14159265359/2 );
	
	chan.waPanner.setPosition( sin,0,-cos );
}

gxtkAudio.prototype.SetRate=function( channel,rate ){

	var chan=this.channels[channel];

	if( chan.state==1 ){
		//update offset for pause/resume
		var time=wa.currentTime;
		chan.offset=(chan.offset+(time-chan.startTime)*chan.rate)%chan.buffer.waBuffer.duration;
		chan.startTime=time;
	}

	chan.rate=rate;
	
	if( chan.waSource ) chan.waSource.playbackRate.value=rate;
}

gxtkAudio.prototype.PlayMusic=function( path,flags ){
	if( this.musicState ) this.music.pause();
	this.music=new Audio( BBGame.Game().PathToUrl( path ) );
	this.music.loop=(flags&1)!=0;
	this.music.play();
	this.musicState=1;
}

gxtkAudio.prototype.StopMusic=function(){
	if( !this.musicState ) return;
	this.music.pause();
	this.music=null;
	this.musicState=0;
}

gxtkAudio.prototype.PauseMusic=function(){
	if( this.musicState!=1 ) return;
	this.music.pause();
	this.musicState=2;
}

gxtkAudio.prototype.ResumeMusic=function(){
	if( this.musicState!=2 ) return;
	this.music.play();
	this.musicState=1;
}

gxtkAudio.prototype.MusicState=function(){
	if( this.musicState==1 && this.music.ended && !this.music.loop ){
		this.music=null;
		this.musicState=0;
	}
	return this.musicState;
}

gxtkAudio.prototype.SetMusicVolume=function( volume ){
	this.musicVolume=volume;
	if( this.musicState ) this.music.volume=volume;
}

}else{

//print( "Using OldAudio!" );

// ***** gxtkChannel class *****

var gxtkChannel=function(){
	this.sample=null;
	this.audio=null;
	this.volume=1;
	this.pan=0;
	this.rate=1;
	this.flags=0;
	this.state=0;
}

// ***** gxtkAudio class *****

var gxtkAudio=function(){
	this.game=BBHtml5Game.Html5Game();
	this.okay=typeof(Audio)!="undefined";
	this.music=null;
	this.channels=new Array(33);
	for( var i=0;i<33;++i ){
		this.channels[i]=new gxtkChannel();
		if( !this.okay ) this.channels[i].state=-1;
	}
}

gxtkAudio.prototype.Suspend=function(){
	var i;
	for( i=0;i<33;++i ){
		var chan=this.channels[i];
		if( chan.state==1 ){
			if( chan.audio.ended && !chan.audio.loop ){
				chan.state=0;
			}else{
				chan.audio.pause();
				chan.state=3;
			}
		}
	}
}

gxtkAudio.prototype.Resume=function(){
	var i;
	for( i=0;i<33;++i ){
		var chan=this.channels[i];
		if( chan.state==3 ){
			chan.audio.play();
			chan.state=1;
		}
	}
}

gxtkAudio.prototype.LoadSample=function( path ){
	if( !this.okay ) return null;

	var audio=new Audio( this.game.PathToUrl( path ) );
	if( !audio ) return null;
	
	return new gxtkSample( audio );
}

gxtkAudio.prototype.PlaySample=function( sample,channel,flags ){
	if( !this.okay ) return;
	
	var chan=this.channels[channel];

	if( chan.state>0 ){
		chan.audio.pause();
		chan.state=0;
	}
	
	for( var i=0;i<33;++i ){
		var chan2=this.channels[i];
		if( chan2.state==1 && chan2.audio.ended && !chan2.audio.loop ) chan.state=0;
		if( chan2.state==0 && chan2.sample ){
			chan2.sample.FreeAudio( chan2.audio );
			chan2.sample=null;
			chan2.audio=null;
		}
	}

	var audio=sample.AllocAudio();
	if( !audio ) return;

	audio.loop=(flags&1)!=0;
	audio.volume=chan.volume;
	audio.play();

	chan.sample=sample;
	chan.audio=audio;
	chan.flags=flags;
	chan.state=1;
}

gxtkAudio.prototype.StopChannel=function( channel ){
	var chan=this.channels[channel];
	
	if( chan.state>0 ){
		chan.audio.pause();
		chan.state=0;
	}
}

gxtkAudio.prototype.PauseChannel=function( channel ){
	var chan=this.channels[channel];
	
	if( chan.state==1 ){
		if( chan.audio.ended && !chan.audio.loop ){
			chan.state=0;
		}else{
			chan.audio.pause();
			chan.state=2;
		}
	}
}

gxtkAudio.prototype.ResumeChannel=function( channel ){
	var chan=this.channels[channel];
	
	if( chan.state==2 ){
		chan.audio.play();
		chan.state=1;
	}
}

gxtkAudio.prototype.ChannelState=function( channel ){
	var chan=this.channels[channel];
	if( chan.state==1 && chan.audio.ended && !chan.audio.loop ) chan.state=0;
	if( chan.state==3 ) return 1;
	return chan.state;
}

gxtkAudio.prototype.SetVolume=function( channel,volume ){
	var chan=this.channels[channel];
	if( chan.state>0 ) chan.audio.volume=volume;
	chan.volume=volume;
}

gxtkAudio.prototype.SetPan=function( channel,pan ){
	var chan=this.channels[channel];
	chan.pan=pan;
}

gxtkAudio.prototype.SetRate=function( channel,rate ){
	var chan=this.channels[channel];
	chan.rate=rate;
}

gxtkAudio.prototype.PlayMusic=function( path,flags ){
	this.StopMusic();
	
	this.music=this.LoadSample( path );
	if( !this.music ) return;
	
	this.PlaySample( this.music,32,flags );
}

gxtkAudio.prototype.StopMusic=function(){
	this.StopChannel( 32 );

	if( this.music ){
		this.music.Discard();
		this.music=null;
	}
}

gxtkAudio.prototype.PauseMusic=function(){
	this.PauseChannel( 32 );
}

gxtkAudio.prototype.ResumeMusic=function(){
	this.ResumeChannel( 32 );
}

gxtkAudio.prototype.MusicState=function(){
	return this.ChannelState( 32 );
}

gxtkAudio.prototype.SetMusicVolume=function( volume ){
	this.SetVolume( 32,volume );
}

// ***** gxtkSample class *****

//function gxtkSample( audio ){
var gxtkSample=function( audio ){
	this.audio=audio;
	this.free=new Array();
	this.insts=new Array();
}

gxtkSample.prototype.FreeAudio=function( audio ){
	this.free.push( audio );
}

gxtkSample.prototype.AllocAudio=function(){
	var audio;
	while( this.free.length ){
		audio=this.free.pop();
		try{
			audio.currentTime=0;
			return audio;
		}catch( ex ){
//			print( "AUDIO ERROR1!" );
		}
	}
	
	//Max out?
	if( this.insts.length==8 ) return null;
	
	audio=new Audio( this.audio.src );
	
	//yucky loop handler for firefox!
	//
	audio.addEventListener( 'ended',function(){
		if( this.loop ){
			try{
				this.currentTime=0;
				this.play();
			}catch( ex ){
//				print( "AUDIO ERROR2!" );
			}
		}
	},false );

	this.insts.push( audio );
	return audio;
}

gxtkSample.prototype.Discard=function(){
}

}


function BBThread(){
	this.result=null;
	this.running=false;
}

BBThread.prototype.Start=function(){
	this.result=null;
	this.running=true;
	this.Run__UNSAFE__();
}

BBThread.prototype.IsRunning=function(){
	return this.running;
}

BBThread.prototype.Result=function(){
	return this.result;
}

BBThread.prototype.Run__UNSAFE__=function(){
	this.running=false;
}


function BBAsyncImageLoaderThread(){
	this._running=false;
}

BBAsyncImageLoaderThread.prototype.Start=function(){

	var thread=this;

	thread._surface=null;
	thread._result=false;
	thread._running=true;

	var image=new Image();

	image.onload=function( e ){
		image.meta_width=image.width;
		image.meta_height=image.height;
		thread._surface=new gxtkSurface( image,thread._device )
		thread._result=true;
		thread._running=false;
	}
	
	image.onerror=function( e ){
		thread._running=false;
	}
	
	image.src=BBGame.Game().PathToUrl( thread._path );
}

BBAsyncImageLoaderThread.prototype.IsRunning=function(){
	return this._running;
}



function BBAsyncSoundLoaderThread(){
	this._running=false;
}
  
if( CFG_HTML5_WEBAUDIO_ENABLED=="1" && (window.AudioContext || window.webkitAudioContext) ){

BBAsyncSoundLoaderThread.prototype.Start=function(){

	this._sample=null;
	if( !this._device.okay ) return;
	
	var thread=this;
	
	thread._sample=null;
	thread._result=false;
	thread._running=true;

	var req=new XMLHttpRequest();
	req.open( "get",BBGame.Game().PathToUrl( this._path ),true );
	req.responseType="arraybuffer";
	
	req.onload=function(){
		//load success!
		wa.decodeAudioData( req.response,function( buffer ){
			//decode success!
			thread._sample=new gxtkSample();
			thread._sample.waBuffer=buffer;
			thread._sample.state=1;
			thread._result=true;
			thread._running=false;
		},function(){	
			//decode fail!
			thread._running=false;
		} );
	}
	
	req.onerror=function(){
		//load fail!
		thread._running=false;
	}
	
	req.send();
}
	
}else{
 
BBAsyncSoundLoaderThread.prototype.Start=function(){

	this._sample=null;
	if( !this._device.okay ) return;
	
	var audio=new Audio();
	if( !audio ) return;
	
	var thread=this;
	
	thread._sample=null;
	thread._result=false;
	thread._running=true;

	audio.src=BBGame.Game().PathToUrl( this._path );
	audio.preload='auto';	
	
	var success=function( e ){
		thread._sample=new gxtkSample( audio );
		thread._result=true;
		thread._running=false;
		audio.removeEventListener( 'canplaythrough',success,false );
		audio.removeEventListener( 'error',error,false );
	}
	
	var error=function( e ){
		thread._running=false;
		audio.removeEventListener( 'canplaythrough',success,false );
		audio.removeEventListener( 'error',error,false );
	}
	
	audio.addEventListener( 'canplaythrough',success,false );
	audio.addEventListener( 'error',error,false );
	
	//voodoo fix for Chrome!
	var timer=setInterval( function(){ if( !thread._running ) clearInterval( timer ); },200 );
	
	audio.load();
}

}
  
BBAsyncSoundLoaderThread.prototype.IsRunning=function(){
	return this._running;
}

function c_App(){
	Object.call(this);
}
c_App.m_new=function(){
	if((bb_app__app)!=null){
		error("App has already been created");
	}
	bb_app__app=this;
	bb_app__delegate=c_GameDelegate.m_new.call(new c_GameDelegate);
	bb_app__game.SetDelegate(bb_app__delegate);
	return this;
}
c_App.prototype.p_OnResize=function(){
	return 0;
}
c_App.prototype.p_OnCreate=function(){
	return 0;
}
c_App.prototype.p_OnSuspend=function(){
	return 0;
}
c_App.prototype.p_OnResume=function(){
	return 0;
}
c_App.prototype.p_OnUpdate=function(){
	return 0;
}
c_App.prototype.p_OnLoading=function(){
	return 0;
}
c_App.prototype.p_OnRender=function(){
	return 0;
}
c_App.prototype.p_OnClose=function(){
	bb_app_EndApp();
	return 0;
}
c_App.prototype.p_OnBack=function(){
	this.p_OnClose();
	return 0;
}
function c_MyApp(){
	c_App.call(this);
}
c_MyApp.prototype=extend_class(c_App);
c_MyApp.m_new=function(){
	c_App.m_new.call(this);
	return this;
}
c_MyApp.m_Texture="";
c_MyApp.m_Ball=null;
c_MyApp.m_BallShadow=null;
c_MyApp.m_ScanLines=null;
c_MyApp.m_CubeTex=null;
c_MyApp.m_Stars=null;
c_MyApp.m_Stars2=null;
c_MyApp.m_Back=null;
c_MyApp.m_Font=null;
c_MyApp.m_FontMir=null;
c_MyApp.m_FontBig=null;
c_MyApp.m_Textos="";
c_MyApp.m_Muzak=null;
c_MyApp.m_MuzakInfo="";
c_MyApp.m_x=0;
c_MyApp.prototype.p_OnCreate=function(){
	bb_app_SetUpdateRate(51);
	c_MyApp.m_Texture="111111110000111111111111000011111111111111110011110011110011110011110011111111110011110000110111110011111111";
	c_MyApp.m_Ball=bb_graphics_LoadImage("ball.png",1,c_Image.m_DefaultFlags);
	c_MyApp.m_BallShadow=bb_graphics_LoadImage("ball_shadow.png",1,c_Image.m_DefaultFlags);
	c_MyApp.m_ScanLines=bb_graphics_LoadImage("scanlines.png",1,c_Image.m_DefaultFlags);
	c_MyApp.m_CubeTex=bb_graphics_LoadImage("cubetex.png",1,c_Image.m_DefaultFlags);
	c_MyApp.m_Stars=bb_graphics_LoadImage("stars.png",1,c_Image.m_DefaultFlags);
	c_MyApp.m_Stars2=bb_graphics_LoadImage("stars2.png",1,c_Image.m_DefaultFlags);
	c_MyApp.m_Back=bb_graphics_LoadImage("back.png",1,c_Image.m_DefaultFlags);
	c_MyApp.m_Font=c_Font.m_Load("fonti.png",32,91,false);
	c_MyApp.m_FontMir=c_Font.m_Load("fonti_mir.png",32,91,false);
	c_MyApp.m_FontBig=c_Font.m_Load("fonti_big.png",32,90,false);
	bb_graphics_SetFont(c_MyApp.m_Font);
	c_MyApp.m_Textos="hi folks... this is a saunagroup intro for presenting a few demosongs for ppsg-tracker ! YEAH... That is the REAL Replay ! i'm still here and doing my stuff, however. Greetings to the SAUNAGROUPERS and the rest of the WORLD !";
	c_MyApp.m_Muzak=c_ppsgPlay.m_new.call(new c_ppsgPlay);
	c_MyApp.m_Muzak.p_LoadFile("songs/fletchb.dat","-1");
	c_MyApp.m_MuzakInfo="Fletch";
	c_MyApp.m_x=640;
	return 0;
}
c_MyApp.prototype.p_OnUpdate=function(){
	c_MyApp.m_Muzak.p_Play();
	c_MyApp.m_x=c_MyApp.m_x-4;
	if(c_MyApp.m_x<-c_MyApp.m_Textos.length*18){
		c_MyApp.m_x=640;
	}
	if((bb_input_KeyHit(112))!=0){
		c_MyApp.m_Muzak=c_ppsgPlay.m_new.call(new c_ppsgPlay);
		c_MyApp.m_Muzak.p_LoadFile("songs/fletchb.dat","-1");
		c_MyApp.m_MuzakInfo="Fletch";
	}
	if((bb_input_KeyHit(113))!=0){
		c_MyApp.m_Muzak=c_ppsgPlay.m_new.call(new c_ppsgPlay);
		c_MyApp.m_Muzak.p_LoadFile("songs/battlesquadron.dat","-1");
		c_MyApp.m_MuzakInfo="Battle Squadron";
	}
	if((bb_input_KeyHit(114))!=0){
		c_MyApp.m_Muzak=c_ppsgPlay.m_new.call(new c_ppsgPlay);
		c_MyApp.m_Muzak.p_LoadFile("songs/pernopal.dat","-1");
		c_MyApp.m_MuzakInfo="Pernopal";
	}
	if((bb_input_KeyHit(115))!=0){
		c_MyApp.m_Muzak=c_ppsgPlay.m_new.call(new c_ppsgPlay);
		c_MyApp.m_Muzak.p_LoadFile("songs/storm.dat","-1");
		c_MyApp.m_MuzakInfo="Storm";
	}
	if((bb_input_KeyHit(116))!=0){
		c_MyApp.m_Muzak=c_ppsgPlay.m_new.call(new c_ppsgPlay);
		c_MyApp.m_Muzak.p_LoadFile("songs/paradoxv.dat","-1");
		c_MyApp.m_MuzakInfo="Paradox";
	}
	if((bb_input_KeyHit(117))!=0){
		c_MyApp.m_Muzak=c_ppsgPlay.m_new.call(new c_ppsgPlay);
		c_MyApp.m_Muzak.p_LoadFile("songs/giana.dat","-1");
		c_MyApp.m_MuzakInfo="Giana Intro";
	}
	if((bb_input_KeyHit(118))!=0){
		c_MyApp.m_Muzak=c_ppsgPlay.m_new.call(new c_ppsgPlay);
		c_MyApp.m_Muzak.p_LoadFile("songs/skidance.dat","-1");
		c_MyApp.m_MuzakInfo="Skidance";
	}
	if((bb_input_KeyHit(119))!=0){
		c_MyApp.m_Muzak=c_ppsgPlay.m_new.call(new c_ppsgPlay);
		c_MyApp.m_Muzak.p_LoadFile("songs/hybris.dat","-1");
		c_MyApp.m_MuzakInfo="Hybris Intro";
	}
	if((bb_input_KeyHit(120))!=0){
		c_MyApp.m_Muzak=c_ppsgPlay.m_new.call(new c_ppsgPlay);
		c_MyApp.m_Muzak.p_LoadFile("songs/shadesii.dat","-1");
		c_MyApp.m_MuzakInfo="Shades";
	}
	if((bb_input_KeyHit(121))!=0){
		c_MyApp.m_Muzak=c_ppsgPlay.m_new.call(new c_ppsgPlay);
		c_MyApp.m_Muzak.p_LoadFile("songs/shizofreniab.dat","-1");
		c_MyApp.m_MuzakInfo="Shizofrenia";
	}
	if((bb_input_KeyHit(122))!=0){
		c_MyApp.m_Muzak=c_ppsgPlay.m_new.call(new c_ppsgPlay);
		c_MyApp.m_Muzak.p_LoadFile("songs/mycommodore.dat","-1");
		c_MyApp.m_MuzakInfo="My Commodore";
	}
	if((bb_input_KeyHit(123))!=0){
		c_MyApp.m_Muzak=c_ppsgPlay.m_new.call(new c_ppsgPlay);
		c_MyApp.m_Muzak.p_LoadFile("songs/ik.dat","-1");
		c_MyApp.m_MuzakInfo="IK+";
	}
	if((bb_input_KeyHit(13))!=0){
		c_MyApp.m_Muzak.p_Stop();
	}
	return 0;
}
c_MyApp.m_y=0;
c_MyApp.m_xs=0;
c_MyApp.m_Rate=0;
c_MyApp.m_ScanY=0;
c_MyApp.m_Rate2=0;
c_MyApp.m_gtx=0;
c_MyApp.m_v=0;
c_MyApp.m_v2=0;
c_MyApp.m_v3=0;
c_MyApp.m_v4=0;
c_MyApp.m_qx=0;
c_MyApp.m_qy=0;
c_MyApp.m_Zoom=0;
c_MyApp.m_MatX=0;
c_MyApp.m_MatY=0;
c_MyApp.m_mir=0;
c_MyApp.m_NextChar=0;
c_MyApp.m_wob=0;
c_MyApp.prototype.p_OnRender=function(){
	c_MyApp.m_y=240.0;
	bb_graphics_Cls(0.0,0.0,0.0);
	bb_graphics_DrawImage(c_MyApp.m_Back,0.0,0.0,0);
	c_MyApp.m_xs=c_MyApp.m_xs+4;
	if(c_MyApp.m_xs==1280){
		c_MyApp.m_xs=0;
	}
	bb_graphics_DrawImageRect(c_MyApp.m_Stars,(0-c_MyApp.m_xs),136.0,0,0,640,160,0);
	bb_graphics_DrawImageRect(c_MyApp.m_Stars,(640-c_MyApp.m_xs),136.0,0,0,640,160,0);
	bb_graphics_DrawImageRect(c_MyApp.m_Stars,(1280-c_MyApp.m_xs),136.0,0,0,640,160,0);
	bb_graphics_DrawImageRect(c_MyApp.m_Stars2,(0-((c_MyApp.m_xs/2)|0)),136.0,0,0,640,160,0);
	bb_graphics_DrawImageRect(c_MyApp.m_Stars2,(640-((c_MyApp.m_xs/2)|0)),136.0,0,0,640,160,0);
	for(var t_ScanX=0;t_ScanX<=c_MyApp.m_Textos.length;t_ScanX=t_ScanX+1){
		bb_graphics_SetColor(255.0,255.0,255.0);
		bb_graphics_SetFont(c_MyApp.m_Font);
		bb_graphics_SetAlpha(1.0);
		bb_graphics_DrawText(c_MyApp.m_Textos.slice(t_ScanX,t_ScanX+1),(((c_MyApp.m_x+18*t_ScanX)+c_MyApp.m_Rate)|0),((c_MyApp.m_Rate*2.0+c_MyApp.m_y+(16*c_MyApp.m_ScanY))|0),0.0,0.0);
		bb_graphics_SetColor(255.0,255.0,255.0);
		bb_graphics_SetAlpha(0.2);
		bb_graphics_SetFont(c_MyApp.m_FontMir);
		bb_graphics_DrawText(c_MyApp.m_Textos.slice(t_ScanX,t_ScanX+1),(((c_MyApp.m_x+18*t_ScanX)+c_MyApp.m_Rate)|0),((c_MyApp.m_Rate2*2.0+c_MyApp.m_y+(16*c_MyApp.m_ScanY)+140.0)|0),0.0,0.0);
		c_MyApp.m_gtx=c_MyApp.m_gtx+0.01;
		c_MyApp.m_Rate=Math.sin((c_MyApp.m_x+40*t_ScanX)*D2R)*8.0;
		c_MyApp.m_Rate2=Math.cos((c_MyApp.m_x+40*t_ScanX)*D2R)*8.0;
		if(c_MyApp.m_gtx==2.0){
			c_MyApp.m_gtx=0.0;
		}
	}
	c_MyApp.m_v=c_MyApp.m_v+1;
	c_MyApp.m_v2=c_MyApp.m_v2+4;
	c_MyApp.m_v3=(((c_MyApp.m_v3)+1.5)|0);
	c_MyApp.m_v4=c_MyApp.m_v4+1;
	c_MyApp.m_qx=264;
	c_MyApp.m_qy=200;
	c_MyApp.m_Zoom=0;
	if(c_MyApp.m_v>32){
		c_MyApp.m_v=0;
	}
	if(c_MyApp.m_v3>32){
		c_MyApp.m_v3=0;
	}
	if(c_MyApp.m_v2>180){
		c_MyApp.m_v2=0;
	}
	if(c_MyApp.m_v4>360){
		c_MyApp.m_v4=0;
	}
	c_MyApp.m_MatX=((Math.sin((c_MyApp.m_v2)*D2R)*36.0)|0);
	c_MyApp.m_MatY=((Math.cos((c_MyApp.m_v4)*D2R)*360.0)|0);
	for(var t_dx=1;t_dx<=1024;t_dx=t_dx+32){
		bb_graphics_SetColor(0.0,(128+((t_dx/16)|0)),(255-((t_dx/32)|0)));
		bb_graphics_DrawLine((320-((t_dx/2)|0)),300.0,(320-t_dx),480.0);
		bb_graphics_DrawLine((320+((t_dx/2)|0)),300.0,(320+t_dx),480.0);
		bb_graphics_DrawLine(0.0,(300+((t_dx/2)|0)+c_MyApp.m_v),640.0,(300+((t_dx/2)|0)+c_MyApp.m_v));
	}
	bb_graphics_SetColor(255.0,255.0,255.0);
	var t_max=0;
	t_max=5;
	if(c_MyApp.m_mir==2){
		c_MyApp.m_mir=0;
	}
	for(var t_more=0;t_more<=t_max;t_more=t_more+1){
		var t_bz=32;
		if(c_MyApp.m_mir==0){
			for(var t_g=0;t_g<=5;t_g=t_g+1){
				if(c_MyApp.m_Texture.slice(t_more*6+t_g+c_MyApp.m_NextChar*6*6,t_more*6+t_g+c_MyApp.m_NextChar*6*6+1)=="1"){
					bb_graphics_SetAlpha(0.4);
				}
				if(c_MyApp.m_Texture.slice(t_more*6+t_g+c_MyApp.m_NextChar*6*6,t_more*6+t_g+c_MyApp.m_NextChar*6*6+1)=="0"){
					bb_graphics_SetAlpha(0.0);
				}
				bb_graphics_DrawImage(c_MyApp.m_Ball,256.0-256.0*Math.sin((c_MyApp.m_v2)*D2R)+(t_g*64)*Math.cos((c_MyApp.m_v2)*D2R)+Math.sin((c_MyApp.m_wob)*D2R)*16.0+(t_more)*Math.sin((c_MyApp.m_v2)*D2R)*(t_bz)/2.0,416.0+(t_more)*Math.sin((t_bz)*D2R)*64.0-(t_max*64)+Math.cos((c_MyApp.m_wob)*D2R)*16.0,0);
				bb_graphics_DrawImage(c_MyApp.m_BallShadow,256.0-256.0*Math.sin((c_MyApp.m_v2)*D2R)+(t_g*64)*Math.cos((c_MyApp.m_v2)*D2R)-Math.sin((c_MyApp.m_wob)*D2R)*16.0+(t_more)*Math.sin((c_MyApp.m_v2)*D2R)*(t_bz)/2.0,480.0-(t_more)*Math.sin((t_bz)*D2R)*64.0-(t_max*64)-Math.cos((c_MyApp.m_wob)*D2R)*16.0+352.0,0);
			}
		}else{
			for(var t_g2=0;t_g2<=5;t_g2=t_g2+1){
				if(c_MyApp.m_Texture.slice(t_more*6+5-t_g2+c_MyApp.m_NextChar*6*6,t_more*6+5-t_g2+c_MyApp.m_NextChar*6*6+1)=="1"){
					bb_graphics_SetAlpha(0.4);
				}
				if(c_MyApp.m_Texture.slice(t_more*6+5-t_g2+c_MyApp.m_NextChar*6*6,t_more*6+5-t_g2+c_MyApp.m_NextChar*6*6+1)=="0"){
					bb_graphics_SetAlpha(0.0);
				}
				bb_graphics_DrawImage(c_MyApp.m_Ball,256.0+256.0*Math.sin((c_MyApp.m_v2)*D2R)-((5-t_g2)*64)*Math.cos((c_MyApp.m_v2)*D2R)+Math.sin((c_MyApp.m_wob)*D2R)*16.0-(t_more)*Math.sin((c_MyApp.m_v2)*D2R)*(t_bz)/2.0,416.0+(t_more)*Math.sin((t_bz)*D2R)*64.0-(t_max*64)+Math.cos((c_MyApp.m_wob)*D2R)*16.0,0);
				bb_graphics_DrawImage(c_MyApp.m_BallShadow,256.0+256.0*Math.sin((c_MyApp.m_v2)*D2R)-((5-t_g2)*64)*Math.cos((c_MyApp.m_v2)*D2R)-Math.sin((c_MyApp.m_wob)*D2R)*16.0-(t_more)*Math.sin((c_MyApp.m_v2)*D2R)*(t_bz)/2.0,480.0-(t_more)*Math.sin((t_bz)*D2R)*64.0-(t_max*64)-Math.cos((c_MyApp.m_wob)*D2R)*16.0+352.0,0);
			}
		}
	}
	if(c_MyApp.m_v2==180){
		c_MyApp.m_mir=c_MyApp.m_mir+1;
	}
	if(c_MyApp.m_v2==180){
		c_MyApp.m_NextChar=c_MyApp.m_NextChar+1;
	}
	if(c_MyApp.m_NextChar==3){
		c_MyApp.m_NextChar=0;
	}
	bb_graphics_SetFont(c_MyApp.m_Font);
	bb_graphics_SetAlpha(1.0);
	bb_graphics_DrawText("   press f1-f12 to select a song !",0,20,0.0,0.0);
	bb_graphics_DrawText("     ENTER = for reset current !",0,40,0.0,0.0);
	bb_graphics_SetAlpha(0.5);
	bb_graphics_DrawText(" now playing... "+c_MyApp.m_MuzakInfo,0,420,0.0,0.0);
	bb_graphics_SetAlpha(1.0);
	bb_graphics_DrawImage(c_MyApp.m_ScanLines,0.0,0.0,0);
	return 0;
}
var bb_app__app=null;
function c_GameDelegate(){
	BBGameDelegate.call(this);
	this.m__graphics=null;
	this.m__audio=null;
	this.m__input=null;
}
c_GameDelegate.prototype=extend_class(BBGameDelegate);
c_GameDelegate.m_new=function(){
	return this;
}
c_GameDelegate.prototype.StartGame=function(){
	this.m__graphics=(new gxtkGraphics);
	bb_graphics_SetGraphicsDevice(this.m__graphics);
	bb_graphics_SetFont(null);
	this.m__audio=(new gxtkAudio);
	bb_audio_SetAudioDevice(this.m__audio);
	this.m__input=c_InputDevice.m_new.call(new c_InputDevice);
	bb_input_SetInputDevice(this.m__input);
	bb_app_ValidateDeviceWindow(false);
	bb_app_EnumDisplayModes();
	bb_app__app.p_OnCreate();
}
c_GameDelegate.prototype.SuspendGame=function(){
	bb_app__app.p_OnSuspend();
	this.m__audio.Suspend();
}
c_GameDelegate.prototype.ResumeGame=function(){
	this.m__audio.Resume();
	bb_app__app.p_OnResume();
}
c_GameDelegate.prototype.UpdateGame=function(){
	bb_app_ValidateDeviceWindow(true);
	this.m__input.p_BeginUpdate();
	bb_app__app.p_OnUpdate();
	this.m__input.p_EndUpdate();
}
c_GameDelegate.prototype.RenderGame=function(){
	bb_app_ValidateDeviceWindow(true);
	var t_mode=this.m__graphics.BeginRender();
	if((t_mode)!=0){
		bb_graphics_BeginRender();
	}
	if(t_mode==2){
		bb_app__app.p_OnLoading();
	}else{
		bb_app__app.p_OnRender();
	}
	if((t_mode)!=0){
		bb_graphics_EndRender();
	}
	this.m__graphics.EndRender();
}
c_GameDelegate.prototype.KeyEvent=function(t_event,t_data){
	this.m__input.p_KeyEvent(t_event,t_data);
	if(t_event!=1){
		return;
	}
	var t_1=t_data;
	if(t_1==432){
		bb_app__app.p_OnClose();
	}else{
		if(t_1==416){
			bb_app__app.p_OnBack();
		}
	}
}
c_GameDelegate.prototype.MouseEvent=function(t_event,t_data,t_x,t_y,t_z){
	this.m__input.p_MouseEvent(t_event,t_data,t_x,t_y,t_z);
}
c_GameDelegate.prototype.TouchEvent=function(t_event,t_data,t_x,t_y){
	this.m__input.p_TouchEvent(t_event,t_data,t_x,t_y);
}
c_GameDelegate.prototype.MotionEvent=function(t_event,t_data,t_x,t_y,t_z){
	this.m__input.p_MotionEvent(t_event,t_data,t_x,t_y,t_z);
}
c_GameDelegate.prototype.DiscardGraphics=function(){
	this.m__graphics.DiscardGraphics();
}
var bb_app__delegate=null;
var bb_app__game=null;
function bbMain(){
	c_MyApp.m_new.call(new c_MyApp);
	return 0;
}
var bb_graphics_device=null;
function bb_graphics_SetGraphicsDevice(t_dev){
	bb_graphics_device=t_dev;
	return 0;
}
function c_Font(){
	Object.call(this);
	this.m__pages=[];
	this.m__pageCount=0;
	this.m__firstChar=0;
	this.m__height=.0;
	this.m__charMap=c_IntMap.m_new.call(new c_IntMap);
}
c_Font.m_new=function(t_pages,t_pageCount,t_chars,t_firstChar,t_height){
	this.m__pages=t_pages;
	this.m__pageCount=t_pageCount;
	this.m__firstChar=t_firstChar;
	this.m__height=t_height;
	this.m__charMap=t_chars;
	return this;
}
c_Font.m_new2=function(){
	return this;
}
c_Font.m_Load=function(t_path,t_firstChar,t_numChars,t_padded){
	var t_image=bb_graphics_LoadImage(t_path,1,c_Image.m_DefaultFlags);
	var t__pages=new_object_array(1);
	t__pages[0]=t_image;
	var t__charMap=c_IntMap.m_new.call(new c_IntMap);
	var t__pageCount=1;
	if(!((t_image)!=null)){
		return null;
	}
	var t_cellWidth=((t_image.p_Width()/t_numChars)|0);
	var t_cellHeight=t_image.p_Height();
	var t_glyphX=0;
	var t_glyphY=0;
	var t_glyphWidth=t_cellWidth;
	var t_glyphHeight=t_cellHeight;
	if(t_padded==true){
		t_glyphX+=1;
		t_glyphY+=1;
		t_glyphWidth-=2;
		t_glyphHeight-=2;
	}
	var t_w=((t_image.p_Width()/t_cellWidth)|0);
	var t_h=((t_image.p_Height()/t_cellHeight)|0);
	for(var t_i=0;t_i<t_numChars;t_i=t_i+1){
		var t_y=((t_i/t_w)|0);
		var t_x=t_i % t_w;
		var t_glyph=c_Glyph.m_new.call(new c_Glyph,0,t_firstChar+t_i,t_x*t_cellWidth+t_glyphX,t_y*t_cellHeight+t_glyphY,t_glyphWidth,t_glyphHeight,t_glyphWidth);
		t__charMap.p_Add(t_firstChar+t_i,t_glyph);
	}
	return c_Font.m_new.call(new c_Font,t__pages,t__pageCount,t__charMap,t_firstChar,(t_glyphHeight));
}
c_Font.m_Load2=function(t_path,t_cellWidth,t_cellHeight,t_glyphX,t_glyphY,t_glyphWidth,t_glyphHeight,t_firstChar,t_numChars){
	var t_image=bb_graphics_LoadImage(t_path,1,c_Image.m_DefaultFlags);
	var t__pages=new_object_array(1);
	t__pages[0]=t_image;
	var t__charMap=c_IntMap.m_new.call(new c_IntMap);
	var t__pageCount=1;
	if(!((t_image)!=null)){
		return null;
	}
	var t_w=((t_image.p_Width()/t_cellWidth)|0);
	var t_h=((t_image.p_Height()/t_cellHeight)|0);
	for(var t_i=0;t_i<t_numChars;t_i=t_i+1){
		var t_y=((t_i/t_w)|0);
		var t_x=t_i % t_w;
		var t_glyph=c_Glyph.m_new.call(new c_Glyph,0,t_firstChar+t_i,t_x*t_cellWidth+t_glyphX,t_y*t_cellHeight+t_glyphY,t_glyphWidth,t_glyphHeight,t_glyphWidth);
		t__charMap.p_Add(t_firstChar+t_i,t_glyph);
	}
	return c_Font.m_new.call(new c_Font,t__pages,t__pageCount,t__charMap,t_firstChar,(t_glyphHeight));
}
c_Font.m_Load3=function(t_url){
	var t_iniText="";
	var t_pageNum=0;
	var t_idnum=0;
	var t_tmpChar=null;
	var t_plLen=0;
	var t_lines=[];
	var t_filename="";
	var t_lineHeight=0;
	var t__pages=[];
	var t__charMap=c_IntMap.m_new.call(new c_IntMap);
	var t__pageCount=0;
	var t_path="";
	if(t_url.indexOf("/",0)>-1){
		var t_pl=t_url.split("/");
		t_plLen=t_pl.length;
		for(var t_pi=0;t_pi<=t_plLen-2;t_pi=t_pi+1){
			t_path=t_path+t_pl[t_pi]+"/";
		}
	}
	var t_ts=t_url.toLowerCase();
	if(t_ts.indexOf(".txt",0)>0){
		t_iniText=bb_app_LoadString(t_url);
	}else{
		t_iniText=bb_app_LoadString(t_url+".txt");
	}
	t_lines=t_iniText.split(String.fromCharCode(13)+String.fromCharCode(10));
	if(t_lines.length<2){
		t_lines=t_iniText.split(String.fromCharCode(10));
	}
	var t_=t_lines;
	var t_2=0;
	while(t_2<t_.length){
		var t_line=t_[t_2];
		t_2=t_2+1;
		t_line=string_trim(t_line);
		if(string_startswith(t_line,"info") || t_line==""){
			continue;
		}
		if(string_startswith(t_line,"padding")){
			continue;
		}
		if(string_startswith(t_line,"common")){
			var t_commondata=t_line.split(String.fromCharCode(32));
			var t_3=t_commondata;
			var t_4=0;
			while(t_4<t_3.length){
				var t_common=t_3[t_4];
				t_4=t_4+1;
				if(string_startswith(t_common,"lineHeight=")){
					var t_lnh=t_common.split("=");
					t_lnh[1]=string_trim(t_lnh[1]);
					t_lineHeight=parseInt((t_lnh[1]),10);
				}
				if(string_startswith(t_common,"pages=")){
					var t_lnh2=t_common.split("=");
					t_lnh2[1]=string_trim(t_lnh2[1]);
					t__pageCount=parseInt((t_lnh2[1]),10);
					t__pages=new_object_array(t__pageCount);
				}
			}
		}
		if(string_startswith(t_line,"page")){
			var t_pagedata=t_line.split(String.fromCharCode(32));
			var t_5=t_pagedata;
			var t_6=0;
			while(t_6<t_5.length){
				var t_data=t_5[t_6];
				t_6=t_6+1;
				if(string_startswith(t_data,"file=")){
					var t_fn=t_data.split("=");
					t_fn[1]=string_trim(t_fn[1]);
					t_filename=t_fn[1];
					if(t_filename.charCodeAt(0)==34){
						t_filename=t_filename.slice(1,t_filename.length-1);
					}
					t_filename=t_path+string_trim(t_filename);
					t__pages[t_pageNum]=bb_graphics_LoadImage(t_filename,1,c_Image.m_DefaultFlags);
					t_pageNum=t_pageNum+1;
				}
			}
		}
		if(string_startswith(t_line,"chars")){
			continue;
		}
		if(string_startswith(t_line,"char")){
			t_tmpChar=c_Glyph.m_new2.call(new c_Glyph);
			var t_linedata=t_line.split(String.fromCharCode(32));
			var t_7=t_linedata;
			var t_8=0;
			while(t_8<t_7.length){
				var t_data2=t_7[t_8];
				t_8=t_8+1;
				if(string_startswith(t_data2,"id=")){
					var t_idc=t_data2.split("=");
					t_idc[1]=string_trim(t_idc[1]);
					t_tmpChar.m_id=parseInt((t_idc[1]),10);
				}
				if(string_startswith(t_data2,"x=")){
					var t_xc=t_data2.split("=");
					t_xc[1]=string_trim(t_xc[1]);
					t_tmpChar.m_x=parseInt((t_xc[1]),10);
				}
				if(string_startswith(t_data2,"y=")){
					var t_yc=t_data2.split("=");
					t_yc[1]=string_trim(t_yc[1]);
					t_tmpChar.m_y=parseInt((t_yc[1]),10);
				}
				if(string_startswith(t_data2,"width=")){
					var t_wc=t_data2.split("=");
					t_wc[1]=string_trim(t_wc[1]);
					t_tmpChar.m_width=parseInt((t_wc[1]),10);
				}
				if(string_startswith(t_data2,"height=")){
					var t_hc=t_data2.split("=");
					t_hc[1]=string_trim(t_hc[1]);
					t_tmpChar.m_height=parseInt((t_hc[1]),10);
				}
				if(string_startswith(t_data2,"xoffset=")){
					var t_xoc=t_data2.split("=");
					t_xoc[1]=string_trim(t_xoc[1]);
					t_tmpChar.m_xoff=parseInt((t_xoc[1]),10);
				}
				if(string_startswith(t_data2,"yoffset=")){
					var t_yoc=t_data2.split("=");
					t_yoc[1]=string_trim(t_yoc[1]);
					t_tmpChar.m_yoff=parseInt((t_yoc[1]),10);
				}
				if(string_startswith(t_data2,"xadvance=")){
					var t_advc=t_data2.split("=");
					t_advc[1]=string_trim(t_advc[1]);
					t_tmpChar.m_advance=parseInt((t_advc[1]),10);
				}
				if(string_startswith(t_data2,"page=")){
					var t_advc2=t_data2.split("=");
					t_advc2[1]=string_trim(t_advc2[1]);
					t_tmpChar.m_page=parseInt((t_advc2[1]),10);
				}
			}
			t__charMap.p_Add(t_tmpChar.m_id,t_tmpChar);
		}
		continue;
	}
	return c_Font.m_new.call(new c_Font,t__pages,t__pageCount,t__charMap,-1,(t_lineHeight));
}
c_Font.prototype.p_GetGlyph=function(t_char){
	return this.m__charMap.p_Get(t_char);
}
c_Font.prototype.p_TextWidth=function(t_text){
	var t_w=0.0;
	var t_char=0;
	var t_=t_text;
	var t_2=0;
	while(t_2<t_.length){
		t_char=t_.charCodeAt(t_2);
		t_2=t_2+1;
		var t_glyph=this.p_GetGlyph(t_char);
		if(!((t_glyph)!=null)){
			continue;
		}
		t_w=t_w+(t_glyph.m_advance);
	}
	return t_w;
}
c_Font.prototype.p_TextHeight=function(t_text){
	return this.m__height;
}
function c_GraphicsContext(){
	Object.call(this);
	this.m_defaultFont=null;
	this.m_font=null;
	this.m_matrixSp=0;
	this.m_ix=1.0;
	this.m_iy=.0;
	this.m_jx=.0;
	this.m_jy=1.0;
	this.m_tx=.0;
	this.m_ty=.0;
	this.m_tformed=0;
	this.m_matDirty=0;
	this.m_color_r=.0;
	this.m_color_g=.0;
	this.m_color_b=.0;
	this.m_alpha=.0;
	this.m_blend=0;
	this.m_scissor_x=.0;
	this.m_scissor_y=.0;
	this.m_scissor_width=.0;
	this.m_scissor_height=.0;
	this.m_matrixStack=new_number_array(192);
}
c_GraphicsContext.m_new=function(){
	return this;
}
c_GraphicsContext.prototype.p_Validate=function(){
	if((this.m_matDirty)!=0){
		bb_graphics_renderDevice.SetMatrix(bb_graphics_context.m_ix,bb_graphics_context.m_iy,bb_graphics_context.m_jx,bb_graphics_context.m_jy,bb_graphics_context.m_tx,bb_graphics_context.m_ty);
		this.m_matDirty=0;
	}
	return 0;
}
var bb_graphics_context=null;
function c_Image(){
	Object.call(this);
	this.m_surface=null;
	this.m_width=0;
	this.m_height=0;
	this.m_frames=[];
	this.m_flags=0;
	this.m_tx=.0;
	this.m_ty=.0;
	this.m_source=null;
}
c_Image.m_DefaultFlags=0;
c_Image.m_new=function(){
	return this;
}
c_Image.prototype.p_SetHandle=function(t_tx,t_ty){
	this.m_tx=t_tx;
	this.m_ty=t_ty;
	this.m_flags=this.m_flags&-2;
	return 0;
}
c_Image.prototype.p_ApplyFlags=function(t_iflags){
	this.m_flags=t_iflags;
	if((this.m_flags&2)!=0){
		var t_=this.m_frames;
		var t_2=0;
		while(t_2<t_.length){
			var t_f=t_[t_2];
			t_2=t_2+1;
			t_f.m_x+=1;
		}
		this.m_width-=2;
	}
	if((this.m_flags&4)!=0){
		var t_3=this.m_frames;
		var t_4=0;
		while(t_4<t_3.length){
			var t_f2=t_3[t_4];
			t_4=t_4+1;
			t_f2.m_y+=1;
		}
		this.m_height-=2;
	}
	if((this.m_flags&1)!=0){
		this.p_SetHandle((this.m_width)/2.0,(this.m_height)/2.0);
	}
	if(this.m_frames.length==1 && this.m_frames[0].m_x==0 && this.m_frames[0].m_y==0 && this.m_width==this.m_surface.Width() && this.m_height==this.m_surface.Height()){
		this.m_flags|=65536;
	}
	return 0;
}
c_Image.prototype.p_Init=function(t_surf,t_nframes,t_iflags){
	if((this.m_surface)!=null){
		error("Image already initialized");
	}
	this.m_surface=t_surf;
	this.m_width=((this.m_surface.Width()/t_nframes)|0);
	this.m_height=this.m_surface.Height();
	this.m_frames=new_object_array(t_nframes);
	for(var t_i=0;t_i<t_nframes;t_i=t_i+1){
		this.m_frames[t_i]=c_Frame.m_new.call(new c_Frame,t_i*this.m_width,0);
	}
	this.p_ApplyFlags(t_iflags);
	return this;
}
c_Image.prototype.p_Init2=function(t_surf,t_x,t_y,t_iwidth,t_iheight,t_nframes,t_iflags,t_src,t_srcx,t_srcy,t_srcw,t_srch){
	if((this.m_surface)!=null){
		error("Image already initialized");
	}
	this.m_surface=t_surf;
	this.m_source=t_src;
	this.m_width=t_iwidth;
	this.m_height=t_iheight;
	this.m_frames=new_object_array(t_nframes);
	var t_ix=t_x;
	var t_iy=t_y;
	for(var t_i=0;t_i<t_nframes;t_i=t_i+1){
		if(t_ix+this.m_width>t_srcw){
			t_ix=0;
			t_iy+=this.m_height;
		}
		if(t_ix+this.m_width>t_srcw || t_iy+this.m_height>t_srch){
			error("Image frame outside surface");
		}
		this.m_frames[t_i]=c_Frame.m_new.call(new c_Frame,t_ix+t_srcx,t_iy+t_srcy);
		t_ix+=this.m_width;
	}
	this.p_ApplyFlags(t_iflags);
	return this;
}
c_Image.prototype.p_Width=function(){
	return this.m_width;
}
c_Image.prototype.p_Height=function(){
	return this.m_height;
}
function bb_data_FixDataPath(t_path){
	var t_i=t_path.indexOf(":/",0);
	if(t_i!=-1 && t_path.indexOf("/",0)==t_i+1){
		return t_path;
	}
	if(string_startswith(t_path,"./") || string_startswith(t_path,"/")){
		return t_path;
	}
	return "cerberus://data/"+t_path;
}
function c_Frame(){
	Object.call(this);
	this.m_x=0;
	this.m_y=0;
}
c_Frame.m_new=function(t_x,t_y){
	this.m_x=t_x;
	this.m_y=t_y;
	return this;
}
c_Frame.m_new2=function(){
	return this;
}
function bb_lang_DebugLog(t_message){
	var t_b=0;
	return 0;
}
function bb_graphics_LoadImage(t_path,t_frameCount,t_flags){
	var t_surf=bb_graphics_device.LoadSurface(bb_data_FixDataPath(t_path));
	if((t_surf)!=null){
		return (c_Image.m_new.call(new c_Image)).p_Init(t_surf,t_frameCount,t_flags);
	}else{
		bb_lang_DebugLog("Error - Unable to load image: "+t_path);
	}
	return null;
}
function bb_graphics_LoadImage2(t_path,t_frameWidth,t_frameHeight,t_frameCount,t_flags){
	var t_surf=bb_graphics_device.LoadSurface(bb_data_FixDataPath(t_path));
	if((t_surf)!=null){
		return (c_Image.m_new.call(new c_Image)).p_Init2(t_surf,0,0,t_frameWidth,t_frameHeight,t_frameCount,t_flags,null,0,0,t_surf.Width(),t_surf.Height());
	}else{
		bb_lang_DebugLog("Error - Unable to load image: "+t_path);
	}
	return null;
}
function c_Glyph(){
	Object.call(this);
	this.m_page=0;
	this.m_id=0;
	this.m_x=0;
	this.m_y=0;
	this.m_width=0;
	this.m_height=0;
	this.m_advance=0;
	this.m_xoff=0;
	this.m_yoff=0;
}
c_Glyph.m_new=function(t_page,t_id,t_x,t_y,t_width,t_height,t_advance){
	this.m_page=t_page;
	this.m_id=t_id;
	this.m_x=t_x;
	this.m_y=t_y;
	this.m_width=t_width;
	this.m_height=t_height;
	this.m_advance=t_advance;
	this.m_xoff=0;
	this.m_yoff=0;
	return this;
}
c_Glyph.m_new2=function(){
	return this;
}
function c_Map(){
	Object.call(this);
	this.m_root=null;
}
c_Map.m_new=function(){
	return this;
}
c_Map.prototype.p_Compare=function(t_lhs,t_rhs){
}
c_Map.prototype.p_RotateLeft=function(t_node){
	var t_child=t_node.m_right;
	t_node.m_right=t_child.m_left;
	if((t_child.m_left)!=null){
		t_child.m_left.m_parent=t_node;
	}
	t_child.m_parent=t_node.m_parent;
	if((t_node.m_parent)!=null){
		if(t_node==t_node.m_parent.m_left){
			t_node.m_parent.m_left=t_child;
		}else{
			t_node.m_parent.m_right=t_child;
		}
	}else{
		this.m_root=t_child;
	}
	t_child.m_left=t_node;
	t_node.m_parent=t_child;
	return 0;
}
c_Map.prototype.p_RotateRight=function(t_node){
	var t_child=t_node.m_left;
	t_node.m_left=t_child.m_right;
	if((t_child.m_right)!=null){
		t_child.m_right.m_parent=t_node;
	}
	t_child.m_parent=t_node.m_parent;
	if((t_node.m_parent)!=null){
		if(t_node==t_node.m_parent.m_right){
			t_node.m_parent.m_right=t_child;
		}else{
			t_node.m_parent.m_left=t_child;
		}
	}else{
		this.m_root=t_child;
	}
	t_child.m_right=t_node;
	t_node.m_parent=t_child;
	return 0;
}
c_Map.prototype.p_InsertFixup=function(t_node){
	while(((t_node.m_parent)!=null) && t_node.m_parent.m_color==-1 && ((t_node.m_parent.m_parent)!=null)){
		if(t_node.m_parent==t_node.m_parent.m_parent.m_left){
			var t_uncle=t_node.m_parent.m_parent.m_right;
			if(((t_uncle)!=null) && t_uncle.m_color==-1){
				t_node.m_parent.m_color=1;
				t_uncle.m_color=1;
				t_uncle.m_parent.m_color=-1;
				t_node=t_uncle.m_parent;
			}else{
				if(t_node==t_node.m_parent.m_right){
					t_node=t_node.m_parent;
					this.p_RotateLeft(t_node);
				}
				t_node.m_parent.m_color=1;
				t_node.m_parent.m_parent.m_color=-1;
				this.p_RotateRight(t_node.m_parent.m_parent);
			}
		}else{
			var t_uncle2=t_node.m_parent.m_parent.m_left;
			if(((t_uncle2)!=null) && t_uncle2.m_color==-1){
				t_node.m_parent.m_color=1;
				t_uncle2.m_color=1;
				t_uncle2.m_parent.m_color=-1;
				t_node=t_uncle2.m_parent;
			}else{
				if(t_node==t_node.m_parent.m_left){
					t_node=t_node.m_parent;
					this.p_RotateRight(t_node);
				}
				t_node.m_parent.m_color=1;
				t_node.m_parent.m_parent.m_color=-1;
				this.p_RotateLeft(t_node.m_parent.m_parent);
			}
		}
	}
	this.m_root.m_color=1;
	return 0;
}
c_Map.prototype.p_Add=function(t_key,t_value){
	var t_node=this.m_root;
	var t_parent=null;
	var t_cmp=0;
	while((t_node)!=null){
		t_parent=t_node;
		t_cmp=this.p_Compare(t_key,t_node.m_key);
		if(t_cmp>0){
			t_node=t_node.m_right;
		}else{
			if(t_cmp<0){
				t_node=t_node.m_left;
			}else{
				return false;
			}
		}
	}
	t_node=c_Node.m_new.call(new c_Node,t_key,t_value,-1,t_parent);
	if((t_parent)!=null){
		if(t_cmp>0){
			t_parent.m_right=t_node;
		}else{
			t_parent.m_left=t_node;
		}
		this.p_InsertFixup(t_node);
	}else{
		this.m_root=t_node;
	}
	return true;
}
c_Map.prototype.p_FindNode=function(t_key){
	var t_node=this.m_root;
	while((t_node)!=null){
		var t_cmp=this.p_Compare(t_key,t_node.m_key);
		if(t_cmp>0){
			t_node=t_node.m_right;
		}else{
			if(t_cmp<0){
				t_node=t_node.m_left;
			}else{
				return t_node;
			}
		}
	}
	return t_node;
}
c_Map.prototype.p_Get=function(t_key){
	var t_node=this.p_FindNode(t_key);
	if((t_node)!=null){
		return t_node.m_value;
	}
	return null;
}
function c_IntMap(){
	c_Map.call(this);
}
c_IntMap.prototype=extend_class(c_Map);
c_IntMap.m_new=function(){
	c_Map.m_new.call(this);
	return this;
}
c_IntMap.prototype.p_Compare=function(t_lhs,t_rhs){
	return t_lhs-t_rhs;
}
function c_Node(){
	Object.call(this);
	this.m_key=0;
	this.m_right=null;
	this.m_left=null;
	this.m_value=null;
	this.m_color=0;
	this.m_parent=null;
}
c_Node.m_new=function(t_key,t_value,t_color,t_parent){
	this.m_key=t_key;
	this.m_value=t_value;
	this.m_color=t_color;
	this.m_parent=t_parent;
	return this;
}
c_Node.m_new2=function(){
	return this;
}
function bb_app_LoadString(t_path){
	return bb_app__game.LoadString(bb_data_FixDataPath(t_path));
}
function bb_graphics_SetFont(t_font){
	if(!((t_font)!=null)){
		if(!((bb_graphics_context.m_defaultFont)!=null)){
			bb_graphics_context.m_defaultFont=c_Font.m_Load("mojo_font.png",32,96,true);
		}
		t_font=bb_graphics_context.m_defaultFont;
	}
	bb_graphics_context.m_font=t_font;
}
var bb_audio_device=null;
function bb_audio_SetAudioDevice(t_dev){
	bb_audio_device=t_dev;
	return 0;
}
function c_InputDevice(){
	Object.call(this);
	this.m__joyStates=new_object_array(4);
	this.m__keyDown=new_bool_array(512);
	this.m__keyHitPut=0;
	this.m__keyHitQueue=new_number_array(33);
	this.m__keyHit=new_number_array(512);
	this.m__charGet=0;
	this.m__charPut=0;
	this.m__charQueue=new_number_array(32);
	this.m__mouseX=.0;
	this.m__mouseY=.0;
	this.m__mouseZ=.0;
	this.m__touchX=new_number_array(32);
	this.m__touchY=new_number_array(32);
	this.m__accelX=.0;
	this.m__accelY=.0;
	this.m__accelZ=.0;
}
c_InputDevice.m_new=function(){
	for(var t_i=0;t_i<4;t_i=t_i+1){
		this.m__joyStates[t_i]=c_JoyState.m_new.call(new c_JoyState);
	}
	return this;
}
c_InputDevice.prototype.p_PutKeyHit=function(t_key){
	if(this.m__keyHitPut==this.m__keyHitQueue.length){
		return;
	}
	this.m__keyHit[t_key]+=1;
	this.m__keyHitQueue[this.m__keyHitPut]=t_key;
	this.m__keyHitPut+=1;
}
c_InputDevice.prototype.p_BeginUpdate=function(){
	for(var t_i=0;t_i<4;t_i=t_i+1){
		var t_state=this.m__joyStates[t_i];
		if(!BBGame.Game().PollJoystick(t_i,t_state.m_joyx,t_state.m_joyy,t_state.m_joyz,t_state.m_buttons)){
			break;
		}
		for(var t_j=0;t_j<32;t_j=t_j+1){
			var t_key=256+t_i*32+t_j;
			if(t_state.m_buttons[t_j]){
				if(!this.m__keyDown[t_key]){
					this.m__keyDown[t_key]=true;
					this.p_PutKeyHit(t_key);
				}
			}else{
				this.m__keyDown[t_key]=false;
			}
		}
	}
}
c_InputDevice.prototype.p_EndUpdate=function(){
	for(var t_i=0;t_i<this.m__keyHitPut;t_i=t_i+1){
		this.m__keyHit[this.m__keyHitQueue[t_i]]=0;
	}
	this.m__keyHitPut=0;
	this.m__charGet=0;
	this.m__charPut=0;
}
c_InputDevice.prototype.p_KeyEvent=function(t_event,t_data){
	var t_1=t_event;
	if(t_1==1){
		if(!this.m__keyDown[t_data]){
			this.m__keyDown[t_data]=true;
			this.p_PutKeyHit(t_data);
			if(t_data==1){
				this.m__keyDown[384]=true;
				this.p_PutKeyHit(384);
			}else{
				if(t_data==384){
					this.m__keyDown[1]=true;
					this.p_PutKeyHit(1);
				}
			}
		}
	}else{
		if(t_1==2){
			if(this.m__keyDown[t_data]){
				this.m__keyDown[t_data]=false;
				if(t_data==1){
					this.m__keyDown[384]=false;
				}else{
					if(t_data==384){
						this.m__keyDown[1]=false;
					}
				}
			}
		}else{
			if(t_1==3){
				if(this.m__charPut<this.m__charQueue.length){
					this.m__charQueue[this.m__charPut]=t_data;
					this.m__charPut+=1;
				}
			}
		}
	}
}
c_InputDevice.prototype.p_MouseEvent=function(t_event,t_data,t_x,t_y,t_z){
	var t_2=t_event;
	if(t_2==4){
		this.p_KeyEvent(1,1+t_data);
	}else{
		if(t_2==5){
			this.p_KeyEvent(2,1+t_data);
			return;
		}else{
			if(t_2==6){
			}else{
				return;
			}
		}
	}
	this.m__mouseX=t_x;
	this.m__mouseY=t_y;
	this.m__mouseZ=t_z;
	this.m__touchX[0]=t_x;
	this.m__touchY[0]=t_y;
}
c_InputDevice.prototype.p_TouchEvent=function(t_event,t_data,t_x,t_y){
	var t_3=t_event;
	if(t_3==7){
		this.p_KeyEvent(1,384+t_data);
	}else{
		if(t_3==8){
			this.p_KeyEvent(2,384+t_data);
			return;
		}else{
			if(t_3==9){
			}else{
				return;
			}
		}
	}
	this.m__touchX[t_data]=t_x;
	this.m__touchY[t_data]=t_y;
	if(t_data==0){
		this.m__mouseX=t_x;
		this.m__mouseY=t_y;
	}
}
c_InputDevice.prototype.p_MotionEvent=function(t_event,t_data,t_x,t_y,t_z){
	var t_4=t_event;
	if(t_4==10){
	}else{
		return;
	}
	this.m__accelX=t_x;
	this.m__accelY=t_y;
	this.m__accelZ=t_z;
}
c_InputDevice.prototype.p_KeyHit=function(t_key){
	if(t_key>0 && t_key<512){
		return this.m__keyHit[t_key];
	}
	return 0;
}
function c_JoyState(){
	Object.call(this);
	this.m_joyx=new_number_array(2);
	this.m_joyy=new_number_array(2);
	this.m_joyz=new_number_array(2);
	this.m_buttons=new_bool_array(32);
}
c_JoyState.m_new=function(){
	return this;
}
var bb_input_device=null;
function bb_input_SetInputDevice(t_dev){
	bb_input_device=t_dev;
	return 0;
}
var bb_app__devWidth=0;
var bb_app__devHeight=0;
function bb_app_ValidateDeviceWindow(t_notifyApp){
	var t_w=bb_app__game.GetDeviceWidth();
	var t_h=bb_app__game.GetDeviceHeight();
	if(t_w==bb_app__devWidth && t_h==bb_app__devHeight){
		return;
	}
	bb_app__devWidth=t_w;
	bb_app__devHeight=t_h;
	if(t_notifyApp){
		bb_app__app.p_OnResize();
	}
}
function c_DisplayMode(){
	Object.call(this);
	this.m__width=0;
	this.m__height=0;
}
c_DisplayMode.m_new=function(t_width,t_height){
	this.m__width=t_width;
	this.m__height=t_height;
	return this;
}
c_DisplayMode.m_new2=function(){
	return this;
}
function c_Map2(){
	Object.call(this);
	this.m_root=null;
}
c_Map2.m_new=function(){
	return this;
}
c_Map2.prototype.p_Compare=function(t_lhs,t_rhs){
}
c_Map2.prototype.p_FindNode=function(t_key){
	var t_node=this.m_root;
	while((t_node)!=null){
		var t_cmp=this.p_Compare(t_key,t_node.m_key);
		if(t_cmp>0){
			t_node=t_node.m_right;
		}else{
			if(t_cmp<0){
				t_node=t_node.m_left;
			}else{
				return t_node;
			}
		}
	}
	return t_node;
}
c_Map2.prototype.p_Contains=function(t_key){
	return this.p_FindNode(t_key)!=null;
}
c_Map2.prototype.p_RotateLeft2=function(t_node){
	var t_child=t_node.m_right;
	t_node.m_right=t_child.m_left;
	if((t_child.m_left)!=null){
		t_child.m_left.m_parent=t_node;
	}
	t_child.m_parent=t_node.m_parent;
	if((t_node.m_parent)!=null){
		if(t_node==t_node.m_parent.m_left){
			t_node.m_parent.m_left=t_child;
		}else{
			t_node.m_parent.m_right=t_child;
		}
	}else{
		this.m_root=t_child;
	}
	t_child.m_left=t_node;
	t_node.m_parent=t_child;
	return 0;
}
c_Map2.prototype.p_RotateRight2=function(t_node){
	var t_child=t_node.m_left;
	t_node.m_left=t_child.m_right;
	if((t_child.m_right)!=null){
		t_child.m_right.m_parent=t_node;
	}
	t_child.m_parent=t_node.m_parent;
	if((t_node.m_parent)!=null){
		if(t_node==t_node.m_parent.m_right){
			t_node.m_parent.m_right=t_child;
		}else{
			t_node.m_parent.m_left=t_child;
		}
	}else{
		this.m_root=t_child;
	}
	t_child.m_right=t_node;
	t_node.m_parent=t_child;
	return 0;
}
c_Map2.prototype.p_InsertFixup2=function(t_node){
	while(((t_node.m_parent)!=null) && t_node.m_parent.m_color==-1 && ((t_node.m_parent.m_parent)!=null)){
		if(t_node.m_parent==t_node.m_parent.m_parent.m_left){
			var t_uncle=t_node.m_parent.m_parent.m_right;
			if(((t_uncle)!=null) && t_uncle.m_color==-1){
				t_node.m_parent.m_color=1;
				t_uncle.m_color=1;
				t_uncle.m_parent.m_color=-1;
				t_node=t_uncle.m_parent;
			}else{
				if(t_node==t_node.m_parent.m_right){
					t_node=t_node.m_parent;
					this.p_RotateLeft2(t_node);
				}
				t_node.m_parent.m_color=1;
				t_node.m_parent.m_parent.m_color=-1;
				this.p_RotateRight2(t_node.m_parent.m_parent);
			}
		}else{
			var t_uncle2=t_node.m_parent.m_parent.m_left;
			if(((t_uncle2)!=null) && t_uncle2.m_color==-1){
				t_node.m_parent.m_color=1;
				t_uncle2.m_color=1;
				t_uncle2.m_parent.m_color=-1;
				t_node=t_uncle2.m_parent;
			}else{
				if(t_node==t_node.m_parent.m_left){
					t_node=t_node.m_parent;
					this.p_RotateRight2(t_node);
				}
				t_node.m_parent.m_color=1;
				t_node.m_parent.m_parent.m_color=-1;
				this.p_RotateLeft2(t_node.m_parent.m_parent);
			}
		}
	}
	this.m_root.m_color=1;
	return 0;
}
c_Map2.prototype.p_Set=function(t_key,t_value){
	var t_node=this.m_root;
	var t_parent=null;
	var t_cmp=0;
	while((t_node)!=null){
		t_parent=t_node;
		t_cmp=this.p_Compare(t_key,t_node.m_key);
		if(t_cmp>0){
			t_node=t_node.m_right;
		}else{
			if(t_cmp<0){
				t_node=t_node.m_left;
			}else{
				t_node.m_value=t_value;
				return false;
			}
		}
	}
	t_node=c_Node2.m_new.call(new c_Node2,t_key,t_value,-1,t_parent);
	if((t_parent)!=null){
		if(t_cmp>0){
			t_parent.m_right=t_node;
		}else{
			t_parent.m_left=t_node;
		}
		this.p_InsertFixup2(t_node);
	}else{
		this.m_root=t_node;
	}
	return true;
}
c_Map2.prototype.p_Insert=function(t_key,t_value){
	return this.p_Set(t_key,t_value);
}
function c_IntMap2(){
	c_Map2.call(this);
}
c_IntMap2.prototype=extend_class(c_Map2);
c_IntMap2.m_new=function(){
	c_Map2.m_new.call(this);
	return this;
}
c_IntMap2.prototype.p_Compare=function(t_lhs,t_rhs){
	return t_lhs-t_rhs;
}
function c_Stack(){
	Object.call(this);
	this.m_data=[];
	this.m_length=0;
}
c_Stack.m_new=function(){
	return this;
}
c_Stack.m_new2=function(t_data){
	this.m_data=t_data.slice(0);
	this.m_length=t_data.length;
	return this;
}
c_Stack.prototype.p_Push=function(t_value){
	if(this.m_length==this.m_data.length){
		this.m_data=resize_object_array(this.m_data,this.m_length*2+10);
	}
	this.m_data[this.m_length]=t_value;
	this.m_length+=1;
}
c_Stack.prototype.p_Push2=function(t_values,t_offset,t_count){
	for(var t_i=0;t_i<t_count;t_i=t_i+1){
		this.p_Push(t_values[t_offset+t_i]);
	}
}
c_Stack.prototype.p_Push3=function(t_values,t_offset){
	this.p_Push2(t_values,t_offset,t_values.length-t_offset);
}
c_Stack.prototype.p_ToArray=function(){
	var t_t=new_object_array(this.m_length);
	for(var t_i=0;t_i<this.m_length;t_i=t_i+1){
		t_t[t_i]=this.m_data[t_i];
	}
	return t_t;
}
function c_Node2(){
	Object.call(this);
	this.m_key=0;
	this.m_right=null;
	this.m_left=null;
	this.m_value=null;
	this.m_color=0;
	this.m_parent=null;
}
c_Node2.m_new=function(t_key,t_value,t_color,t_parent){
	this.m_key=t_key;
	this.m_value=t_value;
	this.m_color=t_color;
	this.m_parent=t_parent;
	return this;
}
c_Node2.m_new2=function(){
	return this;
}
var bb_app__displayModes=[];
var bb_app__desktopMode=null;
function bb_app_DeviceWidth(){
	return bb_app__devWidth;
}
function bb_app_DeviceHeight(){
	return bb_app__devHeight;
}
function bb_app_EnumDisplayModes(){
	var t_modes=bb_app__game.GetDisplayModes();
	var t_mmap=c_IntMap2.m_new.call(new c_IntMap2);
	var t_mstack=c_Stack.m_new.call(new c_Stack);
	for(var t_i=0;t_i<t_modes.length;t_i=t_i+1){
		var t_w=t_modes[t_i].width;
		var t_h=t_modes[t_i].height;
		var t_size=t_w<<16|t_h;
		if(t_mmap.p_Contains(t_size)){
		}else{
			var t_mode=c_DisplayMode.m_new.call(new c_DisplayMode,t_modes[t_i].width,t_modes[t_i].height);
			t_mmap.p_Insert(t_size,t_mode);
			t_mstack.p_Push(t_mode);
		}
	}
	bb_app__displayModes=t_mstack.p_ToArray();
	var t_mode2=bb_app__game.GetDesktopMode();
	if((t_mode2)!=null){
		bb_app__desktopMode=c_DisplayMode.m_new.call(new c_DisplayMode,t_mode2.width,t_mode2.height);
	}else{
		bb_app__desktopMode=c_DisplayMode.m_new.call(new c_DisplayMode,bb_app_DeviceWidth(),bb_app_DeviceHeight());
	}
}
var bb_graphics_renderDevice=null;
function bb_graphics_SetMatrix(t_ix,t_iy,t_jx,t_jy,t_tx,t_ty){
	bb_graphics_context.m_ix=t_ix;
	bb_graphics_context.m_iy=t_iy;
	bb_graphics_context.m_jx=t_jx;
	bb_graphics_context.m_jy=t_jy;
	bb_graphics_context.m_tx=t_tx;
	bb_graphics_context.m_ty=t_ty;
	bb_graphics_context.m_tformed=((t_ix!=1.0 || t_iy!=0.0 || t_jx!=0.0 || t_jy!=1.0 || t_tx!=0.0 || t_ty!=0.0)?1:0);
	bb_graphics_context.m_matDirty=1;
	return 0;
}
function bb_graphics_SetMatrix2(t_m){
	bb_graphics_SetMatrix(t_m[0],t_m[1],t_m[2],t_m[3],t_m[4],t_m[5]);
	return 0;
}
function bb_graphics_SetColor(t_r,t_g,t_b){
	bb_graphics_context.m_color_r=t_r;
	bb_graphics_context.m_color_g=t_g;
	bb_graphics_context.m_color_b=t_b;
	bb_graphics_renderDevice.SetColor(t_r,t_g,t_b);
	return 0;
}
function bb_graphics_SetColor2(t_rgb){
	bb_graphics_context.m_color_r=(((t_rgb)|0)>>16&255);
	bb_graphics_context.m_color_g=(((t_rgb)|0)>>8&255);
	bb_graphics_context.m_color_b=(((t_rgb)|0)&255);
	bb_graphics_renderDevice.SetColor(bb_graphics_context.m_color_r,bb_graphics_context.m_color_g,bb_graphics_context.m_color_b);
	return 0;
}
function bb_graphics_SetAlpha(t_alpha){
	bb_graphics_context.m_alpha=t_alpha;
	bb_graphics_renderDevice.SetAlpha(t_alpha);
	return 0;
}
function bb_graphics_SetBlend(t_blend){
	bb_graphics_context.m_blend=t_blend;
	bb_graphics_renderDevice.SetBlend(t_blend);
	return 0;
}
function bb_graphics_SetScissor(t_x,t_y,t_width,t_height){
	bb_graphics_context.m_scissor_x=t_x;
	bb_graphics_context.m_scissor_y=t_y;
	bb_graphics_context.m_scissor_width=t_width;
	bb_graphics_context.m_scissor_height=t_height;
	bb_graphics_renderDevice.SetScissor(((t_x)|0),((t_y)|0),((t_width)|0),((t_height)|0));
	return 0;
}
function bb_graphics_BeginRender(){
	bb_graphics_renderDevice=bb_graphics_device;
	bb_graphics_context.m_matrixSp=0;
	bb_graphics_SetMatrix(1.0,0.0,0.0,1.0,0.0,0.0);
	bb_graphics_SetColor(255.0,255.0,255.0);
	bb_graphics_SetAlpha(1.0);
	bb_graphics_SetBlend(0);
	bb_graphics_SetScissor(0.0,0.0,(bb_app_DeviceWidth()),(bb_app_DeviceHeight()));
	return 0;
}
function bb_graphics_EndRender(){
	bb_graphics_renderDevice=null;
	return 0;
}
function c_BBGameEvent(){
	Object.call(this);
}
function bb_app_EndApp(){
	error("");
}
var bb_app__updateRate=0;
function bb_app_SetUpdateRate(t_hertz){
	bb_app__updateRate=t_hertz;
	bb_app__game.SetUpdateRate(t_hertz);
}
function c_ppsgPlay(){
	Object.call(this);
	this.m_Square=null;
	this.m_Ramp=null;
	this.m_Ramp2=null;
	this.m_Saw=null;
	this.m_Noise=null;
	this.m_Bass=null;
	this.m_HNoise=null;
	this.m_Track1="";
	this.m_Track2="";
	this.m_Track3="";
	this.m_Track4="";
	this.m_VolumeTrack1="";
	this.m_VolumeTrack2="";
	this.m_VolumeTrack3="";
	this.m_VolumeTrack4="";
	this.m_InstTrack1="";
	this.m_InstTrack2="";
	this.m_InstTrack3="";
	this.m_InstTrack4="";
	this.m_OctaveTrack1="";
	this.m_OctaveTrack2="";
	this.m_OctaveTrack3="";
	this.m_OctaveTrack4="";
	this.m_Songlength=32;
	this.m_spd=4;
	this.m_Patterns=new_number_array(255);
	this.m_InsArrayData=new_number_array(255);
	this.m_Descriptions=new_string_array(32);
	this.m_Frame=0;
	this.m_i=0;
	this.m_ppos=0;
	this.m_p1=.0;
	this.m_last_p1=.0;
	this.m_fine_p1=.0;
	this.m_fxval1=.0;
	this.m_Vib1=.0;
	this.m_Arpcounter1=0;
	this.m_PWCount1=0;
	this.m_Decay1=.0;
	this.m_p2=.0;
	this.m_last_p2=.0;
	this.m_fine_p2=.0;
	this.m_fxval2=.0;
	this.m_Vib2=.0;
	this.m_Arpcounter2=0;
	this.m_PWCount2=0;
	this.m_Decay2=.0;
	this.m_p3=.0;
	this.m_last_p3=.0;
	this.m_fine_p3=.0;
	this.m_fxval3=.0;
	this.m_Vib3=.0;
	this.m_Arpcounter3=0;
	this.m_PWCount3=0;
	this.m_Decay3=.0;
	this.m_p4=.0;
	this.m_last_p4=.0;
	this.m_fine_p4=.0;
	this.m_fxval4=.0;
	this.m_Vib4=.0;
	this.m_Arpcounter4=0;
	this.m_PWCount4=0;
	this.m_Decay4=.0;
	this.m_InstNo1=0;
	this.m_InstNo2=0;
	this.m_InstNo3=0;
	this.m_InstNo4=0;
	this.m_CHOn1=1.0;
	this.m_volval1=.0;
	this.m_CHOn2=1.0;
	this.m_volval2=.0;
	this.m_CHOn3=1.0;
	this.m_volval3=.0;
	this.m_CHOn4=1.0;
	this.m_volval4=.0;
	this.m_oct1=0;
	this.m_oct2=0;
	this.m_oct3=0;
	this.m_oct4=0;
	this.m_Chan1wav=null;
	this.m_Chan5wav=null;
	this.m_Zero=null;
	this.m_Chan2wav=null;
	this.m_Chan6wav=null;
	this.m_Chan3wav=null;
	this.m_Chan7wav=null;
	this.m_Chan4wav=null;
	this.m_Chan8wav=null;
	this.m_PWM1=.0;
	this.m_PWM2=.0;
	this.m_PWM3=.0;
	this.m_PWM4=.0;
	this.m_LastInstNo1=0;
	this.m_LastInstNo2=0;
	this.m_LastInstNo3=0;
	this.m_LastInstNo4=0;
	this.m_LastOct1=0;
	this.m_LastOct2=0;
	this.m_LastOct3=0;
	this.m_LastOct4=0;
	this.m_pcount=0;
	this.m_Dec2Pitch1=.0;
	this.m_Dec2Pitch2=.0;
	this.m_Dec2Pitch3=.0;
	this.m_Dec2Pitch4=.0;
	this.m_ArpSpd1=0;
	this.m_ArpSpd2=0;
	this.m_ArpSpd3=0;
	this.m_ArpSpd4=0;
	this.m_PWDepth1=8;
	this.m_PWVal1=0;
	this.m_PWDepth2=8;
	this.m_PWVal2=0;
	this.m_PWDepth3=8;
	this.m_PWVal3=0;
	this.m_PWDepth4=8;
	this.m_PWVal4=0;
}
c_ppsgPlay.m_new=function(){
	return this;
}
c_ppsgPlay.prototype.p_LoadFile=function(t_Filename,t_FileData){
	this.m_Square=bb_audio_LoadSound("wav/ramp_64.wav");
	this.m_Ramp=bb_audio_LoadSound("wav/ramp_b_64.wav");
	this.m_Ramp2=bb_audio_LoadSound("wav/ramp_c_64.wav");
	this.m_Saw=bb_audio_LoadSound("wav/saw_64.wav");
	this.m_Noise=bb_audio_LoadSound("wav/fx2b.wav");
	this.m_Bass=bb_audio_LoadSound("wav/tri_64.wav");
	this.m_HNoise=bb_audio_LoadSound("wav/hnoise.wav");
	if((t_FileData).length!=0){
		t_FileData=bb_app_LoadString(t_Filename);
	}else{
		var t_FileData2=bb_app_LoadString(t_Filename);
	}
	if(!((t_FileData).length!=0)){
		return "Loading Failed!";
	}
	this.m_Track1="";
	this.m_Track2="";
	this.m_Track3="";
	this.m_Track4="";
	this.m_VolumeTrack1="";
	this.m_VolumeTrack2="";
	this.m_VolumeTrack3="";
	this.m_VolumeTrack4="";
	this.m_InstTrack1="";
	this.m_InstTrack2="";
	this.m_InstTrack3="";
	this.m_InstTrack4="";
	this.m_OctaveTrack1="";
	this.m_OctaveTrack2="";
	this.m_OctaveTrack3="";
	this.m_OctaveTrack4="";
	this.m_Songlength=t_FileData.charCodeAt(4)*32;
	this.m_spd=t_FileData.charCodeAt(5);
	if(!((this.m_spd)!=0)){
		this.m_spd=5;
	}
	var t_plength=t_FileData.charCodeAt(6);
	this.m_Track1=t_FileData.slice(7,t_plength*32+7);
	this.m_Track2=t_FileData.slice(t_plength*32+7,t_plength*32*2+7);
	this.m_Track3=t_FileData.slice(t_plength*32*2+7,t_plength*32*3+7);
	this.m_Track4=t_FileData.slice(t_plength*32*3+7,t_plength*32*4+7);
	this.m_VolumeTrack1=t_FileData.slice(t_plength*32*4+7,t_plength*32*5+7);
	this.m_VolumeTrack2=t_FileData.slice(t_plength*32*5+7,t_plength*32*6+7);
	this.m_VolumeTrack3=t_FileData.slice(t_plength*32*6+7,t_plength*32*7+7);
	this.m_VolumeTrack4=t_FileData.slice(t_plength*32*7+7,t_plength*32*8+7);
	this.m_InstTrack1=t_FileData.slice(t_plength*32*8+7,t_plength*32*9+7);
	this.m_InstTrack2=t_FileData.slice(t_plength*32*9+7,t_plength*32*10+7);
	this.m_InstTrack3=t_FileData.slice(t_plength*32*10+7,t_plength*32*11+7);
	this.m_InstTrack4=t_FileData.slice(t_plength*32*11+7,t_plength*32*12+7);
	this.m_OctaveTrack1=t_FileData.slice(t_plength*32*12+7,t_plength*32*13+7);
	this.m_OctaveTrack2=t_FileData.slice(t_plength*32*13+7,t_plength*32*14+7);
	this.m_OctaveTrack3=t_FileData.slice(t_plength*32*14+7,t_plength*32*15+7);
	this.m_OctaveTrack4=t_FileData.slice(t_plength*32*15+7,t_plength*32*16+7);
	for(var t_j=0;t_j<=255-t_plength;t_j=t_j+1){
		for(var t_p=0;t_p<=31;t_p=t_p+1){
			this.m_Track1=this.m_Track1+".";
			this.m_Track2=this.m_Track2+".";
			this.m_Track3=this.m_Track3+".";
			this.m_Track4=this.m_Track4+".";
			this.m_VolumeTrack1=this.m_VolumeTrack1+"0";
			this.m_VolumeTrack2=this.m_VolumeTrack2+"0";
			this.m_VolumeTrack3=this.m_VolumeTrack3+"0";
			this.m_VolumeTrack4=this.m_VolumeTrack4+"0";
			this.m_InstTrack1=this.m_InstTrack1+"0";
			this.m_InstTrack2=this.m_InstTrack2+"0";
			this.m_InstTrack3=this.m_InstTrack3+"0";
			this.m_InstTrack4=this.m_InstTrack4+"0";
			this.m_OctaveTrack1=this.m_OctaveTrack1+"0";
			this.m_OctaveTrack2=this.m_OctaveTrack2+"0";
			this.m_OctaveTrack3=this.m_OctaveTrack3+"0";
			this.m_OctaveTrack4=this.m_OctaveTrack4+"0";
		}
	}
	for(var t_i=0;t_i<=255;t_i=t_i+1){
		this.m_Patterns[t_i]=t_FileData.charCodeAt(t_plength*32*16+7+t_i);
	}
	for(var t_i2=0;t_i2<=248;t_i2=t_i2+1){
		this.m_InsArrayData[t_i2]=t_FileData.charCodeAt(t_plength*32*16+7+256+t_i2);
	}
	for(var t_i3=1;t_i3<=31;t_i3=t_i3+1){
		this.m_Descriptions[t_i3]=t_FileData.slice(t_plength*32*16+7+256+248+(t_i3-1)*21+1,t_plength*32*16+7+256+248+t_i3*21+1);
	}
	if((t_FileData).length!=0){
		return "File Loaded...";
	}
	return "";
}
c_ppsgPlay.prototype.p_PlayTrack=function(t_Track,t_i){
	var t_p1=0;
	if(t_Track.slice(t_i,t_i+1)=="<"){
		t_p1=128;
	}
	if(t_Track.slice(t_i,t_i+1)=="."){
		t_p1=255;
	}
	if(t_Track.slice(t_i,t_i+1)=="y"){
		t_p1=0;
	}
	if(t_Track.slice(t_i,t_i+1)=="s"){
		t_p1=1;
	}
	if(t_Track.slice(t_i,t_i+1)=="x"){
		t_p1=2;
	}
	if(t_Track.slice(t_i,t_i+1)=="d"){
		t_p1=3;
	}
	if(t_Track.slice(t_i,t_i+1)=="c"){
		t_p1=4;
	}
	if(t_Track.slice(t_i,t_i+1)=="v"){
		t_p1=5;
	}
	if(t_Track.slice(t_i,t_i+1)=="g"){
		t_p1=6;
	}
	if(t_Track.slice(t_i,t_i+1)=="b"){
		t_p1=7;
	}
	if(t_Track.slice(t_i,t_i+1)=="h"){
		t_p1=8;
	}
	if(t_Track.slice(t_i,t_i+1)=="n"){
		t_p1=9;
	}
	if(t_Track.slice(t_i,t_i+1)=="j"){
		t_p1=10;
	}
	if(t_Track.slice(t_i,t_i+1)=="m"){
		t_p1=11;
	}
	if(t_Track.slice(t_i,t_i+1)=="q"){
		t_p1=12;
	}
	if(t_Track.slice(t_i,t_i+1)=="2"){
		t_p1=13;
	}
	if(t_Track.slice(t_i,t_i+1)=="w"){
		t_p1=14;
	}
	if(t_Track.slice(t_i,t_i+1)=="3"){
		t_p1=15;
	}
	if(t_Track.slice(t_i,t_i+1)=="e"){
		t_p1=16;
	}
	if(t_Track.slice(t_i,t_i+1)=="r"){
		t_p1=17;
	}
	if(t_Track.slice(t_i,t_i+1)=="5"){
		t_p1=18;
	}
	if(t_Track.slice(t_i,t_i+1)=="t"){
		t_p1=19;
	}
	if(t_Track.slice(t_i,t_i+1)=="6"){
		t_p1=20;
	}
	if(t_Track.slice(t_i,t_i+1)=="z"){
		t_p1=21;
	}
	if(t_Track.slice(t_i,t_i+1)=="7"){
		t_p1=22;
	}
	if(t_Track.slice(t_i,t_i+1)=="u"){
		t_p1=23;
	}
	if(t_Track.slice(t_i,t_i+1)=="i"){
		t_p1=24;
	}
	if(t_Track.slice(t_i,t_i+1)=="9"){
		t_p1=25;
	}
	if(t_Track.slice(t_i,t_i+1)=="o"){
		t_p1=26;
	}
	if(t_Track.slice(t_i,t_i+1)=="0"){
		t_p1=27;
	}
	if(t_Track.slice(t_i,t_i+1)=="p"){
		t_p1=28;
	}
	if(t_Track.slice(t_i,t_i+1)=="+"){
		t_p1=127;
	}
	if(t_Track.slice(t_i,t_i+1)=="#"){
		t_p1=129;
	}
	if(t_Track.slice(t_i,t_i+1)=="-"){
		t_p1=130;
	}
	return t_p1;
}
c_ppsgPlay.prototype.p_Char2Int=function(t_i){
	var t_n=0;
	t_n=parseInt((t_i),10);
	if(t_i=="a" || t_i=="A"){
		t_n=10;
	}
	if(t_i=="b" || t_i=="B"){
		t_n=11;
	}
	if(t_i=="c" || t_i=="C"){
		t_n=12;
	}
	if(t_i=="d" || t_i=="D"){
		t_n=13;
	}
	if(t_i=="e" || t_i=="E"){
		t_n=14;
	}
	if(t_i=="f" || t_i=="F"){
		t_n=15;
	}
	return t_n;
}
c_ppsgPlay.prototype.p_PlayInst=function(t_wave,t_note,t_channel,t_loop,t_Ramp,t_PWM,t_pwmfix,t_fine,t_oct){
	if(t_note==104+12*t_oct){
		bb_audio_StopChannel(t_channel);
	}
	if(t_note==104+12*t_oct){
		bb_audio_StopChannel(t_channel+4);
	}
	if(t_note<44){
		bb_audio_SetChannelRate(t_channel,Math.pow(1.059463094,(t_note))+t_fine);
		bb_audio_SetChannelRate(t_channel+4,Math.pow(1.059463094,(t_note))+t_fine+t_PWM/800.0);
		if(t_pwmfix>0){
			bb_audio_StopChannel(t_channel+4);
			bb_audio_PlaySound(t_wave,t_channel,t_loop);
			bb_audio_PlaySound(t_Ramp,t_channel+4,t_loop);
		}
	}
	return 0.0;
}
c_ppsgPlay.prototype.p_Play=function(){
	if(this.m_Frame==this.m_spd){
		this.m_p1=(this.p_PlayTrack(this.m_Track1,this.m_i+this.m_ppos));
		if(this.m_p1>47.0 && this.m_p1<127.0){
			this.m_p1=this.m_last_p1;
		}
		if(this.m_p1<127.0){
			this.m_fine_p1=this.m_p1;
		}
		if(this.m_p1<127.0){
			this.m_fxval1=0.0;
		}
		if(this.m_p1<127.0){
			this.m_Vib1=0.0;
		}
		if(this.m_p1<127.0){
			this.m_Arpcounter1=0;
		}
		if(this.m_p1<127.0){
			this.m_PWCount1=0;
		}
		if(this.m_p1<127.0){
			this.m_Decay1=0.00;
		}
		this.m_p2=(this.p_PlayTrack(this.m_Track2,this.m_i+this.m_ppos));
		if(this.m_p2>47.0 && this.m_p2<127.0){
			this.m_p2=this.m_last_p2;
		}
		if(this.m_p2<127.0){
			this.m_fine_p2=this.m_p2;
		}
		if(this.m_p2<127.0){
			this.m_fxval2=0.0;
		}
		if(this.m_p2<127.0){
			this.m_Vib2=0.0;
		}
		if(this.m_p2<127.0){
			this.m_Arpcounter2=0;
		}
		if(this.m_p2<127.0){
			this.m_PWCount2=0;
		}
		if(this.m_p2<127.0){
			this.m_Decay2=0.00;
		}
		this.m_p3=(this.p_PlayTrack(this.m_Track3,this.m_i+this.m_ppos));
		if(this.m_p3>47.0 && this.m_p3<127.0){
			this.m_p3=this.m_last_p3;
		}
		if(this.m_p3<127.0){
			this.m_fine_p3=this.m_p3;
		}
		if(this.m_p3<127.0){
			this.m_fxval3=0.0;
		}
		if(this.m_p3<127.0){
			this.m_Vib3=0.0;
		}
		if(this.m_p3<127.0){
			this.m_Arpcounter3=0;
		}
		if(this.m_p3<127.0){
			this.m_PWCount3=0;
		}
		if(this.m_p3<127.0){
			this.m_Decay3=0.00;
		}
		this.m_p4=(this.p_PlayTrack(this.m_Track4,this.m_i+this.m_ppos));
		if(this.m_p4>47.0 && this.m_p4<127.0){
			this.m_p4=this.m_last_p4;
		}
		if(this.m_p4<127.0){
			this.m_fine_p4=this.m_p4;
		}
		if(this.m_p4<127.0){
			this.m_fxval4=0.0;
		}
		if(this.m_p4<127.0){
			this.m_Vib4=0.0;
		}
		if(this.m_p4<127.0){
			this.m_Arpcounter4=0;
		}
		if(this.m_p4<127.0){
			this.m_PWCount4=0;
		}
		if(this.m_p4<127.0){
			this.m_Decay4=0.00;
		}
		this.m_InstNo1=this.p_Char2Int(this.m_InstTrack1.slice(this.m_i+this.m_ppos,this.m_i+this.m_ppos+1));
		this.m_InstNo2=this.p_Char2Int(this.m_InstTrack2.slice(this.m_i+this.m_ppos,this.m_i+this.m_ppos+1));
		this.m_InstNo3=this.p_Char2Int(this.m_InstTrack3.slice(this.m_i+this.m_ppos,this.m_i+this.m_ppos+1));
		this.m_InstNo4=this.p_Char2Int(this.m_InstTrack4.slice(this.m_i+this.m_ppos,this.m_i+this.m_ppos+1));
		if((this.p_Char2Int(this.m_VolumeTrack1.slice(this.m_i+this.m_ppos,this.m_i+this.m_ppos+1)))!=0){
			this.m_volval1=0.125*(this.p_Char2Int(this.m_VolumeTrack1.slice(this.m_i+this.m_ppos,this.m_i+this.m_ppos+1)))*this.m_CHOn1;
		}
		if((this.p_Char2Int(this.m_VolumeTrack2.slice(this.m_i+this.m_ppos,this.m_i+this.m_ppos+1)))!=0){
			this.m_volval2=0.125*(this.p_Char2Int(this.m_VolumeTrack2.slice(this.m_i+this.m_ppos,this.m_i+this.m_ppos+1)))*this.m_CHOn2;
		}
		if((this.p_Char2Int(this.m_VolumeTrack3.slice(this.m_i+this.m_ppos,this.m_i+this.m_ppos+1)))!=0){
			this.m_volval3=0.125*(this.p_Char2Int(this.m_VolumeTrack3.slice(this.m_i+this.m_ppos,this.m_i+this.m_ppos+1)))*this.m_CHOn3;
		}
		if((this.p_Char2Int(this.m_VolumeTrack4.slice(this.m_i+this.m_ppos,this.m_i+this.m_ppos+1)))!=0){
			this.m_volval4=0.125*(this.p_Char2Int(this.m_VolumeTrack4.slice(this.m_i+this.m_ppos,this.m_i+this.m_ppos+1)))*this.m_CHOn4;
		}
		this.m_oct1=parseInt((this.m_OctaveTrack1.slice(this.m_i+this.m_ppos,this.m_i+this.m_ppos+1)),10);
		this.m_oct2=parseInt((this.m_OctaveTrack2.slice(this.m_i+this.m_ppos,this.m_i+this.m_ppos+1)),10);
		this.m_oct3=parseInt((this.m_OctaveTrack3.slice(this.m_i+this.m_ppos,this.m_i+this.m_ppos+1)),10);
		this.m_oct4=parseInt((this.m_OctaveTrack4.slice(this.m_i+this.m_ppos,this.m_i+this.m_ppos+1)),10);
		if(this.m_InsArrayData[this.m_InstNo1*8]==1){
			this.m_Chan1wav=this.m_Ramp;
		}
		if(this.m_InsArrayData[this.m_InstNo1*8]==2){
			this.m_Chan1wav=this.m_Ramp2;
		}
		if(this.m_InsArrayData[this.m_InstNo1*8]==3){
			this.m_Chan1wav=this.m_Square;
		}
		if(this.m_InsArrayData[this.m_InstNo1*8]==4){
			this.m_Chan1wav=this.m_Bass;
		}
		if(this.m_InsArrayData[this.m_InstNo1*8]==5){
			this.m_Chan1wav=this.m_Ramp;
		}
		if(this.m_InsArrayData[this.m_InstNo1*8]==6){
			this.m_Chan1wav=this.m_Noise;
		}
		if(this.m_InsArrayData[this.m_InstNo1*8]==7){
			this.m_Chan1wav=this.m_HNoise;
		}
		if(this.m_InsArrayData[this.m_InstNo1*8]==1){
			this.m_Chan5wav=this.m_Saw;
		}
		if(this.m_InsArrayData[this.m_InstNo1*8]==2){
			this.m_Chan5wav=this.m_Saw;
		}
		if(this.m_InsArrayData[this.m_InstNo1*8]==3){
			this.m_Chan5wav=this.m_Saw;
		}
		if(this.m_InsArrayData[this.m_InstNo1*8]==4){
			this.m_Chan5wav=this.m_Zero;
		}
		if(this.m_InsArrayData[this.m_InstNo1*8]==5){
			this.m_Chan5wav=this.m_Zero;
		}
		if(this.m_InsArrayData[this.m_InstNo1*8]==6){
			this.m_Chan5wav=this.m_Zero;
		}
		if(this.m_InsArrayData[this.m_InstNo1*8]==7){
			this.m_Chan5wav=this.m_Zero;
		}
		if(this.m_InsArrayData[this.m_InstNo2*8]==1){
			this.m_Chan2wav=this.m_Ramp;
		}
		if(this.m_InsArrayData[this.m_InstNo2*8]==2){
			this.m_Chan2wav=this.m_Ramp2;
		}
		if(this.m_InsArrayData[this.m_InstNo2*8]==3){
			this.m_Chan2wav=this.m_Square;
		}
		if(this.m_InsArrayData[this.m_InstNo2*8]==4){
			this.m_Chan2wav=this.m_Bass;
		}
		if(this.m_InsArrayData[this.m_InstNo2*8]==5){
			this.m_Chan2wav=this.m_Ramp;
		}
		if(this.m_InsArrayData[this.m_InstNo2*8]==6){
			this.m_Chan2wav=this.m_Noise;
		}
		if(this.m_InsArrayData[this.m_InstNo2*8]==7){
			this.m_Chan2wav=this.m_HNoise;
		}
		if(this.m_InsArrayData[this.m_InstNo2*8]==1){
			this.m_Chan6wav=this.m_Saw;
		}
		if(this.m_InsArrayData[this.m_InstNo2*8]==2){
			this.m_Chan6wav=this.m_Saw;
		}
		if(this.m_InsArrayData[this.m_InstNo2*8]==3){
			this.m_Chan6wav=this.m_Saw;
		}
		if(this.m_InsArrayData[this.m_InstNo2*8]==4){
			this.m_Chan6wav=this.m_Zero;
		}
		if(this.m_InsArrayData[this.m_InstNo2*8]==5){
			this.m_Chan6wav=this.m_Zero;
		}
		if(this.m_InsArrayData[this.m_InstNo2*8]==6){
			this.m_Chan6wav=this.m_Zero;
		}
		if(this.m_InsArrayData[this.m_InstNo2*8]==7){
			this.m_Chan6wav=this.m_Zero;
		}
		if(this.m_InsArrayData[this.m_InstNo3*8]==1){
			this.m_Chan3wav=this.m_Ramp;
		}
		if(this.m_InsArrayData[this.m_InstNo3*8]==2){
			this.m_Chan3wav=this.m_Ramp2;
		}
		if(this.m_InsArrayData[this.m_InstNo3*8]==3){
			this.m_Chan3wav=this.m_Square;
		}
		if(this.m_InsArrayData[this.m_InstNo3*8]==4){
			this.m_Chan3wav=this.m_Bass;
		}
		if(this.m_InsArrayData[this.m_InstNo3*8]==5){
			this.m_Chan3wav=this.m_Ramp;
		}
		if(this.m_InsArrayData[this.m_InstNo3*8]==6){
			this.m_Chan3wav=this.m_Noise;
		}
		if(this.m_InsArrayData[this.m_InstNo3*8]==7){
			this.m_Chan3wav=this.m_HNoise;
		}
		if(this.m_InsArrayData[this.m_InstNo3*8]==1){
			this.m_Chan7wav=this.m_Saw;
		}
		if(this.m_InsArrayData[this.m_InstNo3*8]==2){
			this.m_Chan7wav=this.m_Saw;
		}
		if(this.m_InsArrayData[this.m_InstNo3*8]==3){
			this.m_Chan7wav=this.m_Saw;
		}
		if(this.m_InsArrayData[this.m_InstNo3*8]==4){
			this.m_Chan7wav=this.m_Zero;
		}
		if(this.m_InsArrayData[this.m_InstNo3*8]==5){
			this.m_Chan7wav=this.m_Zero;
		}
		if(this.m_InsArrayData[this.m_InstNo3*8]==6){
			this.m_Chan7wav=this.m_Zero;
		}
		if(this.m_InsArrayData[this.m_InstNo3*8]==7){
			this.m_Chan7wav=this.m_Zero;
		}
		if(this.m_InsArrayData[this.m_InstNo4*8]==1){
			this.m_Chan4wav=this.m_Ramp;
		}
		if(this.m_InsArrayData[this.m_InstNo4*8]==2){
			this.m_Chan4wav=this.m_Ramp2;
		}
		if(this.m_InsArrayData[this.m_InstNo4*8]==3){
			this.m_Chan4wav=this.m_Square;
		}
		if(this.m_InsArrayData[this.m_InstNo4*8]==4){
			this.m_Chan4wav=this.m_Bass;
		}
		if(this.m_InsArrayData[this.m_InstNo4*8]==5){
			this.m_Chan4wav=this.m_Ramp;
		}
		if(this.m_InsArrayData[this.m_InstNo4*8]==6){
			this.m_Chan4wav=this.m_Noise;
		}
		if(this.m_InsArrayData[this.m_InstNo4*8]==7){
			this.m_Chan4wav=this.m_HNoise;
		}
		if(this.m_InsArrayData[this.m_InstNo4*8]==1){
			this.m_Chan8wav=this.m_Saw;
		}
		if(this.m_InsArrayData[this.m_InstNo4*8]==2){
			this.m_Chan8wav=this.m_Saw;
		}
		if(this.m_InsArrayData[this.m_InstNo4*8]==3){
			this.m_Chan8wav=this.m_Saw;
		}
		if(this.m_InsArrayData[this.m_InstNo4*8]==4){
			this.m_Chan8wav=this.m_Zero;
		}
		if(this.m_InsArrayData[this.m_InstNo4*8]==5){
			this.m_Chan8wav=this.m_Zero;
		}
		if(this.m_InsArrayData[this.m_InstNo4*8]==6){
			this.m_Chan8wav=this.m_Zero;
		}
		if(this.m_InsArrayData[this.m_InstNo4*8]==7){
			this.m_Chan8wav=this.m_Zero;
		}
		if((this.m_InstNo1)!=0){
			this.m_PWM1=(this.m_InsArrayData[this.m_InstNo1*8+1]);
		}
		if((this.m_InstNo2)!=0){
			this.m_PWM2=(this.m_InsArrayData[this.m_InstNo2*8+1]);
		}
		if((this.m_InstNo3)!=0){
			this.m_PWM3=(this.m_InsArrayData[this.m_InstNo3*8+1]);
		}
		if((this.m_InstNo4)!=0){
			this.m_PWM4=(this.m_InsArrayData[this.m_InstNo4*8+1]);
		}
		this.p_PlayInst(this.m_Chan1wav,((this.m_p1-24.0+(parseInt((this.m_OctaveTrack1.slice(this.m_i+this.m_ppos,this.m_i+this.m_ppos+1)),10)*12))|0),1,1,this.m_Chan5wav,this.m_PWM1,((this.p_Char2Int(this.m_VolumeTrack1.slice(this.m_i+this.m_ppos,this.m_i+this.m_ppos+1)))|0),this.m_fxval1,this.m_oct1);
		this.p_PlayInst(this.m_Chan2wav,((this.m_p2-24.0+(parseInt((this.m_OctaveTrack2.slice(this.m_i+this.m_ppos,this.m_i+this.m_ppos+1)),10)*12))|0),2,1,this.m_Chan6wav,this.m_PWM2,((this.p_Char2Int(this.m_VolumeTrack2.slice(this.m_i+this.m_ppos,this.m_i+this.m_ppos+1)))|0),this.m_fxval2,this.m_oct2);
		this.p_PlayInst(this.m_Chan3wav,((this.m_p3-24.0+(parseInt((this.m_OctaveTrack3.slice(this.m_i+this.m_ppos,this.m_i+this.m_ppos+1)),10)*12))|0),3,1,this.m_Chan7wav,this.m_PWM3,((this.p_Char2Int(this.m_VolumeTrack3.slice(this.m_i+this.m_ppos,this.m_i+this.m_ppos+1)))|0),this.m_fxval3,this.m_oct3);
		this.p_PlayInst(this.m_Chan4wav,((this.m_p4-24.0+(parseInt((this.m_OctaveTrack4.slice(this.m_i+this.m_ppos,this.m_i+this.m_ppos+1)),10)*12))|0),4,1,this.m_Chan8wav,this.m_PWM4,((this.p_Char2Int(this.m_VolumeTrack4.slice(this.m_i+this.m_ppos,this.m_i+this.m_ppos+1)))|0),this.m_fxval4,this.m_oct4);
		if((this.m_InstNo1)!=0){
			this.m_LastInstNo1=this.m_InstNo1;
		}
		if((this.m_InstNo2)!=0){
			this.m_LastInstNo2=this.m_InstNo2;
		}
		if((this.m_InstNo3)!=0){
			this.m_LastInstNo3=this.m_InstNo3;
		}
		if((this.m_InstNo4)!=0){
			this.m_LastInstNo4=this.m_InstNo4;
		}
		if((this.m_InstNo1)!=0){
			this.m_LastOct1=this.m_oct1;
		}
		if((this.m_InstNo2)!=0){
			this.m_LastOct2=this.m_oct2;
		}
		if((this.m_InstNo3)!=0){
			this.m_LastOct3=this.m_oct3;
		}
		if((this.m_InstNo4)!=0){
			this.m_LastOct4=this.m_oct4;
		}
		this.m_last_p1=this.m_p1;
		this.m_last_p2=this.m_p2;
		this.m_last_p3=this.m_p3;
		this.m_last_p4=this.m_p4;
		if(this.m_last_p1==130.0){
			this.m_i=31;
		}
		if(this.m_last_p2==130.0){
			this.m_i=31;
		}
		if(this.m_last_p3==130.0){
			this.m_i=31;
		}
		if(this.m_last_p4==130.0){
			this.m_i=31;
		}
		this.m_i+=1;
		if(this.m_i==32){
			this.m_pcount+=1;
			if(this.m_pcount==((this.m_Songlength/32)|0)){
				this.m_pcount=0;
			}
			this.m_i=0;
		}
		this.m_ppos=this.m_Patterns[this.m_pcount]*32;
		this.m_Frame=0;
	}
	this.m_Frame+=1;
	if(this.m_Decay1<1.0){
		this.m_Decay1+=0.10000000000000001/(this.m_InsArrayData[this.m_LastInstNo1*8+4]);
	}
	if(this.m_volval1-this.m_Decay1<0.0){
		this.m_volval1=0.0;
		this.m_Decay1=0.0;
	}
	if(this.m_Decay2<1.0){
		this.m_Decay2+=0.10000000000000001/(this.m_InsArrayData[this.m_LastInstNo2*8+4]);
	}
	if(this.m_volval2-this.m_Decay2<0.0){
		this.m_volval2=0.0;
		this.m_Decay2=0.0;
	}
	if(this.m_Decay3<1.0){
		this.m_Decay3+=0.10000000000000001/(this.m_InsArrayData[this.m_LastInstNo3*8+4]);
	}
	if(this.m_volval3-this.m_Decay3<0.0){
		this.m_volval3=0.0;
		this.m_Decay3=0.0;
	}
	if(this.m_Decay4<1.0){
		this.m_Decay4+=0.10000000000000001/(this.m_InsArrayData[this.m_LastInstNo4*8+4]);
	}
	if(this.m_volval4-this.m_Decay4<0.0){
		this.m_volval4=0.0;
		this.m_Decay4=0.0;
	}
	bb_audio_SetChannelVolume(1,this.m_volval1-this.m_Decay1);
	bb_audio_SetChannelVolume(5,this.m_volval1-this.m_Decay1);
	bb_audio_SetChannelVolume(2,this.m_volval2-this.m_Decay2);
	bb_audio_SetChannelVolume(6,this.m_volval2-this.m_Decay2);
	bb_audio_SetChannelVolume(3,this.m_volval3-this.m_Decay3);
	bb_audio_SetChannelVolume(7,this.m_volval3-this.m_Decay3);
	bb_audio_SetChannelVolume(4,this.m_volval4-this.m_Decay4);
	bb_audio_SetChannelVolume(8,this.m_volval4-this.m_Decay4);
	if((this.m_InsArrayData[this.m_LastInstNo1*8+2])!=0){
		this.m_Dec2Pitch1=this.m_Decay1;
	}
	if((this.m_InsArrayData[this.m_LastInstNo2*8+2])!=0){
		this.m_Dec2Pitch2=this.m_Decay2;
	}
	if((this.m_InsArrayData[this.m_LastInstNo3*8+2])!=0){
		this.m_Dec2Pitch3=this.m_Decay3;
	}
	if((this.m_InsArrayData[this.m_LastInstNo4*8+2])!=0){
		this.m_Dec2Pitch4=this.m_Decay4;
	}
	this.m_ArpSpd1=this.m_InsArrayData[this.m_LastInstNo1*8+5];
	this.m_ArpSpd2=this.m_InsArrayData[this.m_LastInstNo2*8+5];
	this.m_ArpSpd3=this.m_InsArrayData[this.m_LastInstNo3*8+5];
	this.m_ArpSpd4=this.m_InsArrayData[this.m_LastInstNo4*8+5];
	if(this.m_Arpcounter1==0){
		this.m_fxval1=0.0;
	}
	if(this.m_Arpcounter1==1*this.m_ArpSpd1){
		this.m_fxval1=(this.m_InsArrayData[this.m_LastInstNo1*8+6])/15.0*(this.m_InsArrayData[this.m_LastInstNo1*8+3]-((this.m_InsArrayData[this.m_LastInstNo1*8+3]/16)|0)*16);
	}
	if(this.m_Arpcounter1==2*this.m_ArpSpd1){
		this.m_fxval1=(this.m_InsArrayData[this.m_LastInstNo1*8+7])/15.0*(this.m_InsArrayData[this.m_LastInstNo1*8+3]-((this.m_InsArrayData[this.m_LastInstNo1*8+3]/16)|0)*16);
	}
	if(this.m_Arpcounter2==0){
		this.m_fxval2=0.0;
	}
	if(this.m_Arpcounter2==1*this.m_ArpSpd2){
		this.m_fxval2=(this.m_InsArrayData[this.m_LastInstNo2*8+6])/15.0*(this.m_InsArrayData[this.m_LastInstNo2*8+3]-((this.m_InsArrayData[this.m_LastInstNo2*8+3]/16)|0)*16);
	}
	if(this.m_Arpcounter2==2*this.m_ArpSpd2){
		this.m_fxval2=(this.m_InsArrayData[this.m_LastInstNo2*8+7])/15.0*(this.m_InsArrayData[this.m_LastInstNo2*8+3]-((this.m_InsArrayData[this.m_LastInstNo2*8+3]/16)|0)*16);
	}
	if(this.m_Arpcounter3==0){
		this.m_fxval3=0.0;
	}
	if(this.m_Arpcounter3==1*this.m_ArpSpd3){
		this.m_fxval3=(this.m_InsArrayData[this.m_LastInstNo3*8+6])/15.0*(this.m_InsArrayData[this.m_LastInstNo3*8+3]-((this.m_InsArrayData[this.m_LastInstNo3*8+3]/16)|0)*16);
	}
	if(this.m_Arpcounter3==2*this.m_ArpSpd3){
		this.m_fxval3=(this.m_InsArrayData[this.m_LastInstNo3*8+7])/15.0*(this.m_InsArrayData[this.m_LastInstNo3*8+3]-((this.m_InsArrayData[this.m_LastInstNo3*8+3]/16)|0)*16);
	}
	if(this.m_Arpcounter4==0){
		this.m_fxval4=0.0;
	}
	if(this.m_Arpcounter4==1*this.m_ArpSpd4){
		this.m_fxval4=(this.m_InsArrayData[this.m_LastInstNo4*8+6])/15.0*(this.m_InsArrayData[this.m_LastInstNo4*8+3]-((this.m_InsArrayData[this.m_LastInstNo4*8+3]/16)|0)*16);
	}
	if(this.m_Arpcounter4==2*this.m_ArpSpd4){
		this.m_fxval4=(this.m_InsArrayData[this.m_LastInstNo4*8+7])/15.0*(this.m_InsArrayData[this.m_LastInstNo4*8+3]-((this.m_InsArrayData[this.m_LastInstNo4*8+3]/16)|0)*16);
	}
	this.m_Arpcounter1+=1;
	if(this.m_Arpcounter1==3*this.m_ArpSpd1){
		this.m_Arpcounter1=0;
	}
	this.m_Arpcounter2+=1;
	if(this.m_Arpcounter2==3*this.m_ArpSpd2){
		this.m_Arpcounter2=0;
	}
	this.m_Arpcounter3+=1;
	if(this.m_Arpcounter3==3*this.m_ArpSpd3){
		this.m_Arpcounter3=0;
	}
	this.m_Arpcounter4+=1;
	if(this.m_Arpcounter4==3*this.m_ArpSpd4){
		this.m_Arpcounter4=0;
	}
	this.m_PWDepth1=((this.m_InsArrayData[this.m_LastInstNo1*8+3]/16)|0)*2;
	this.m_PWCount1+=1;
	if(this.m_PWCount1<((this.m_PWDepth1/2)|0)){
		this.m_PWVal1=1;
	}
	if(this.m_PWCount1>((this.m_PWDepth1/2)|0)){
		this.m_PWVal1=-1;
	}
	if(this.m_PWCount1==this.m_PWDepth1){
		this.m_PWCount1=0;
	}
	if(this.m_PWDepth1==0){
		this.m_PWVal1=1;
	}
	this.m_PWDepth2=((this.m_InsArrayData[this.m_LastInstNo2*8+3]/16)|0)*2;
	this.m_PWCount2+=1;
	if(this.m_PWCount2<((this.m_PWDepth2/2)|0)){
		this.m_PWVal2=1;
	}
	if(this.m_PWCount2>((this.m_PWDepth2/2)|0)){
		this.m_PWVal2=-1;
	}
	if(this.m_PWCount2==this.m_PWDepth2){
		this.m_PWCount2=0;
	}
	if(this.m_PWDepth2==0){
		this.m_PWVal2=1;
	}
	this.m_PWDepth3=((this.m_InsArrayData[this.m_LastInstNo3*8+3]/16)|0)*2;
	this.m_PWCount3+=1;
	if(this.m_PWCount3<((this.m_PWDepth3/2)|0)){
		this.m_PWVal3=1;
	}
	if(this.m_PWCount3>((this.m_PWDepth3/2)|0)){
		this.m_PWVal3=-1;
	}
	if(this.m_PWCount3==this.m_PWDepth3){
		this.m_PWCount3=0;
	}
	if(this.m_PWDepth3==0){
		this.m_PWVal3=1;
	}
	this.m_PWDepth4=((this.m_InsArrayData[this.m_LastInstNo4*8+3]/16)|0)*2;
	this.m_PWCount4+=1;
	if(this.m_PWCount4<((this.m_PWDepth4/2)|0)){
		this.m_PWVal4=1;
	}
	if(this.m_PWCount4>((this.m_PWDepth4/2)|0)){
		this.m_PWVal4=-1;
	}
	if(this.m_PWCount4==this.m_PWDepth4){
		this.m_PWCount4=0;
	}
	if(this.m_PWDepth4==0){
		this.m_PWVal4=1;
	}
	if(this.m_last_p1==127.0){
		this.m_Vib1-=0.005*(this.m_volval1*8.0);
	}
	if(this.m_last_p1==129.0){
		this.m_Vib1+=0.005*(this.m_volval1*8.0);
	}
	if(this.m_last_p2==127.0){
		this.m_Vib2-=0.005*(this.m_volval2*8.0);
	}
	if(this.m_last_p2==129.0){
		this.m_Vib2+=0.005*(this.m_volval2*8.0);
	}
	if(this.m_last_p3==127.0){
		this.m_Vib3-=0.005*(this.m_volval3*8.0);
	}
	if(this.m_last_p3==129.0){
		this.m_Vib3+=0.005*(this.m_volval3*8.0);
	}
	if(this.m_last_p4==127.0){
		this.m_Vib4-=0.005*(this.m_volval4*8.0);
	}
	if(this.m_last_p4==129.0){
		this.m_Vib4+=0.005*(this.m_volval4*8.0);
	}
	bb_audio_SetChannelRate(1,Math.pow(1.059463094,this.m_fine_p1-24.0+(this.m_LastOct1*12)+this.m_fxval1)+this.m_Vib1-this.m_Dec2Pitch1*(this.m_InsArrayData[this.m_LastInstNo1*8+2]));
	bb_audio_SetChannelRate(5,Math.pow(1.059463094,this.m_fine_p1-24.0+(this.m_LastOct1*12)+this.m_fxval1)+this.m_Vib1+this.m_PWM1/800.0*(this.m_PWVal1)-this.m_Dec2Pitch1*(this.m_InsArrayData[this.m_LastInstNo1*8+2]));
	bb_audio_SetChannelRate(2,Math.pow(1.059463094,this.m_fine_p2-24.0+(this.m_LastOct2*12)+this.m_fxval2)+this.m_Vib2-this.m_Dec2Pitch2*(this.m_InsArrayData[this.m_LastInstNo2*8+2]));
	bb_audio_SetChannelRate(6,Math.pow(1.059463094,this.m_fine_p2-24.0+(this.m_LastOct2*12)+this.m_fxval2)+this.m_Vib2+this.m_PWM2/800.0*(this.m_PWVal2)-this.m_Dec2Pitch2*(this.m_InsArrayData[this.m_LastInstNo2*8+2]));
	bb_audio_SetChannelRate(3,Math.pow(1.059463094,this.m_fine_p3-24.0+(this.m_LastOct3*12)+this.m_fxval3)+this.m_Vib3-this.m_Dec2Pitch3*(this.m_InsArrayData[this.m_LastInstNo3*8+2]));
	bb_audio_SetChannelRate(7,Math.pow(1.059463094,this.m_fine_p3-24.0+(this.m_LastOct3*12)+this.m_fxval3)+this.m_Vib3+this.m_PWM3/800.0*(this.m_PWVal3)-this.m_Dec2Pitch3*(this.m_InsArrayData[this.m_LastInstNo3*8+2]));
	bb_audio_SetChannelRate(4,Math.pow(1.059463094,this.m_fine_p4-24.0+(this.m_LastOct4*12)+this.m_fxval4)+this.m_Vib4-this.m_Dec2Pitch4*(this.m_InsArrayData[this.m_LastInstNo4*8+2]));
	bb_audio_SetChannelRate(8,Math.pow(1.059463094,this.m_fine_p4-24.0+(this.m_LastOct4*12)+this.m_fxval4)+this.m_Vib4+this.m_PWM4/800.0*(this.m_PWVal4)-this.m_Dec2Pitch4*(this.m_InsArrayData[this.m_LastInstNo4*8+2]));
	return 0;
}
c_ppsgPlay.prototype.p_PauseAll=function(){
	bb_audio_StopChannel(1);
	bb_audio_StopChannel(2);
	bb_audio_StopChannel(3);
	bb_audio_StopChannel(4);
	bb_audio_StopChannel(6);
	bb_audio_StopChannel(5);
	bb_audio_StopChannel(8);
	bb_audio_StopChannel(7);
	return 0;
}
c_ppsgPlay.prototype.p_Stop=function(){
	this.p_PauseAll();
	this.m_Frame=0;
	this.m_pcount=0;
	this.m_ppos=0;
	this.m_i=0;
	return 0;
}
function c_Sound(){
	Object.call(this);
	this.m_sample=null;
}
c_Sound.m_new=function(t_sample){
	this.m_sample=t_sample;
	return this;
}
c_Sound.m_new2=function(){
	return this;
}
function bb_audio_LoadSound(t_path){
	var t_sample=bb_audio_device.LoadSample(bb_data_FixDataPath(t_path));
	if((t_sample)!=null){
		return c_Sound.m_new.call(new c_Sound,t_sample);
	}
	return null;
}
function bb_audio_StopChannel(t_channel){
	bb_audio_device.StopChannel(t_channel);
	return 0;
}
function bb_audio_SetChannelRate(t_channel,t_rate){
	bb_audio_device.SetRate(t_channel,t_rate);
	return 0;
}
function bb_audio_PlaySound(t_sound,t_channel,t_flags){
	if(((t_sound)!=null) && ((t_sound.m_sample)!=null)){
		bb_audio_device.PlaySample(t_sound.m_sample,t_channel,t_flags);
	}
	return 0;
}
function bb_audio_SetChannelVolume(t_channel,t_volume){
	bb_audio_device.SetVolume(t_channel,t_volume);
	return 0;
}
function bb_input_KeyHit(t_key){
	return bb_input_device.p_KeyHit(t_key);
}
function bb_graphics_Cls(t_r,t_g,t_b){
	bb_graphics_renderDevice.Cls(t_r,t_g,t_b);
	return 0;
}
function bb_graphics_DrawImage(t_image,t_x,t_y,t_frame){
	var t_f=t_image.m_frames[t_frame];
	bb_graphics_context.p_Validate();
	if((t_image.m_flags&65536)!=0){
		bb_graphics_renderDevice.DrawSurface(t_image.m_surface,t_x-t_image.m_tx,t_y-t_image.m_ty);
	}else{
		bb_graphics_renderDevice.DrawSurface2(t_image.m_surface,t_x-t_image.m_tx,t_y-t_image.m_ty,t_f.m_x,t_f.m_y,t_image.m_width,t_image.m_height);
	}
	return 0;
}
function bb_graphics_PushMatrix(){
	var t_sp=bb_graphics_context.m_matrixSp;
	if(t_sp==bb_graphics_context.m_matrixStack.length){
		bb_graphics_context.m_matrixStack=resize_number_array(bb_graphics_context.m_matrixStack,t_sp*2);
	}
	bb_graphics_context.m_matrixStack[t_sp+0]=bb_graphics_context.m_ix;
	bb_graphics_context.m_matrixStack[t_sp+1]=bb_graphics_context.m_iy;
	bb_graphics_context.m_matrixStack[t_sp+2]=bb_graphics_context.m_jx;
	bb_graphics_context.m_matrixStack[t_sp+3]=bb_graphics_context.m_jy;
	bb_graphics_context.m_matrixStack[t_sp+4]=bb_graphics_context.m_tx;
	bb_graphics_context.m_matrixStack[t_sp+5]=bb_graphics_context.m_ty;
	bb_graphics_context.m_matrixSp=t_sp+6;
	return 0;
}
function bb_graphics_Transform(t_ix,t_iy,t_jx,t_jy,t_tx,t_ty){
	var t_ix2=t_ix*bb_graphics_context.m_ix+t_iy*bb_graphics_context.m_jx;
	var t_iy2=t_ix*bb_graphics_context.m_iy+t_iy*bb_graphics_context.m_jy;
	var t_jx2=t_jx*bb_graphics_context.m_ix+t_jy*bb_graphics_context.m_jx;
	var t_jy2=t_jx*bb_graphics_context.m_iy+t_jy*bb_graphics_context.m_jy;
	var t_tx2=t_tx*bb_graphics_context.m_ix+t_ty*bb_graphics_context.m_jx+bb_graphics_context.m_tx;
	var t_ty2=t_tx*bb_graphics_context.m_iy+t_ty*bb_graphics_context.m_jy+bb_graphics_context.m_ty;
	bb_graphics_SetMatrix(t_ix2,t_iy2,t_jx2,t_jy2,t_tx2,t_ty2);
	return 0;
}
function bb_graphics_Transform2(t_m){
	bb_graphics_Transform(t_m[0],t_m[1],t_m[2],t_m[3],t_m[4],t_m[5]);
	return 0;
}
function bb_graphics_Translate(t_x,t_y){
	bb_graphics_Transform(1.0,0.0,0.0,1.0,t_x,t_y);
	return 0;
}
function bb_graphics_Rotate(t_angle){
	bb_graphics_Transform(Math.cos((t_angle)*D2R),-Math.sin((t_angle)*D2R),Math.sin((t_angle)*D2R),Math.cos((t_angle)*D2R),0.0,0.0);
	return 0;
}
function bb_graphics_Scale(t_x,t_y){
	bb_graphics_Transform(t_x,0.0,0.0,t_y,0.0,0.0);
	return 0;
}
function bb_graphics_PopMatrix(){
	var t_sp=bb_graphics_context.m_matrixSp-6;
	bb_graphics_SetMatrix(bb_graphics_context.m_matrixStack[t_sp+0],bb_graphics_context.m_matrixStack[t_sp+1],bb_graphics_context.m_matrixStack[t_sp+2],bb_graphics_context.m_matrixStack[t_sp+3],bb_graphics_context.m_matrixStack[t_sp+4],bb_graphics_context.m_matrixStack[t_sp+5]);
	bb_graphics_context.m_matrixSp=t_sp;
	return 0;
}
function bb_graphics_DrawImage2(t_image,t_x,t_y,t_rotation,t_scaleX,t_scaleY,t_frame){
	var t_f=t_image.m_frames[t_frame];
	bb_graphics_PushMatrix();
	bb_graphics_Translate(t_x,t_y);
	bb_graphics_Rotate(t_rotation);
	bb_graphics_Scale(t_scaleX,t_scaleY);
	bb_graphics_Translate(-t_image.m_tx,-t_image.m_ty);
	bb_graphics_context.p_Validate();
	if((t_image.m_flags&65536)!=0){
		bb_graphics_renderDevice.DrawSurface(t_image.m_surface,0.0,0.0);
	}else{
		bb_graphics_renderDevice.DrawSurface2(t_image.m_surface,0.0,0.0,t_f.m_x,t_f.m_y,t_image.m_width,t_image.m_height);
	}
	bb_graphics_PopMatrix();
	return 0;
}
function bb_graphics_DrawImageRect(t_image,t_x,t_y,t_srcX,t_srcY,t_srcWidth,t_srcHeight,t_frame){
	var t_f=t_image.m_frames[t_frame];
	bb_graphics_context.p_Validate();
	bb_graphics_renderDevice.DrawSurface2(t_image.m_surface,-t_image.m_tx+t_x,-t_image.m_ty+t_y,t_srcX+t_f.m_x,t_srcY+t_f.m_y,t_srcWidth,t_srcHeight);
	return 0;
}
function bb_graphics_DrawImageRect2(t_image,t_x,t_y,t_srcX,t_srcY,t_srcWidth,t_srcHeight,t_rotation,t_scaleX,t_scaleY,t_frame){
	var t_f=t_image.m_frames[t_frame];
	bb_graphics_PushMatrix();
	bb_graphics_Translate(t_x,t_y);
	bb_graphics_Rotate(t_rotation);
	bb_graphics_Scale(t_scaleX,t_scaleY);
	bb_graphics_Translate(-t_image.m_tx,-t_image.m_ty);
	bb_graphics_context.p_Validate();
	bb_graphics_renderDevice.DrawSurface2(t_image.m_surface,0.0,0.0,t_srcX+t_f.m_x,t_srcY+t_f.m_y,t_srcWidth,t_srcHeight);
	bb_graphics_PopMatrix();
	return 0;
}
function bb_graphics_DrawText(t_text,t_x,t_y,t_xhandle,t_yhandle){
	var t_char=0;
	var t_tmpChar=null;
	if(!((bb_graphics_context.m_font)!=null)){
		return;
	}
	t_x=(((t_x)-bb_graphics_context.m_font.p_TextWidth(t_text)*t_xhandle)|0);
	t_y=(((t_y)-bb_graphics_context.m_font.p_TextHeight(t_text)*t_yhandle)|0);
	var t_=t_text;
	var t_2=0;
	while(t_2<t_.length){
		t_char=t_.charCodeAt(t_2);
		t_2=t_2+1;
		var t_tmpChar2=bb_graphics_context.m_font.m__charMap.p_Get(t_char);
		if(!((t_tmpChar2)!=null)){
			continue;
		}
		bb_graphics_DrawImageRect(bb_graphics_context.m_font.m__pages[t_tmpChar2.m_page],(t_x+t_tmpChar2.m_xoff),(t_y+t_tmpChar2.m_yoff),t_tmpChar2.m_x,t_tmpChar2.m_y,t_tmpChar2.m_width,t_tmpChar2.m_height,0);
		t_x+=t_tmpChar2.m_advance;
	}
}
function bb_graphics_DrawText2(t_textLines,t_x,t_y,t_xhandle,t_yhandle){
	var t_char=0;
	var t_tmpChar=null;
	var t_currX=.0;
	var t_text="";
	var t_linesCount=t_textLines.length;
	t_y=(((t_y)-bb_graphics_context.m_font.p_TextHeight("")*t_yhandle*(t_linesCount))|0);
	t_currX=(t_x);
	for(var t__y=1;t__y<=t_linesCount;t__y=t__y+1){
		t_text=t_textLines[t__y-1];
		t_x=(((t_x)-bb_graphics_context.m_font.p_TextWidth(t_text)*t_xhandle)|0);
		var t_=t_text;
		var t_2=0;
		while(t_2<t_.length){
			t_char=t_.charCodeAt(t_2);
			t_2=t_2+1;
			var t_tmpChar2=bb_graphics_context.m_font.m__charMap.p_Get(t_char);
			if(!((t_tmpChar2)!=null)){
				continue;
			}
			bb_graphics_DrawImageRect(bb_graphics_context.m_font.m__pages[t_tmpChar2.m_page],(t_x+t_tmpChar2.m_xoff),(t_y+t_tmpChar2.m_yoff),t_tmpChar2.m_x,t_tmpChar2.m_y,t_tmpChar2.m_width,t_tmpChar2.m_height,0);
			t_x+=t_tmpChar2.m_advance;
		}
		t_y=(((t_y)+bb_graphics_context.m_font.p_TextHeight(t_text))|0);
		t_x=((t_currX)|0);
	}
}
function bb_graphics_DrawLine(t_x1,t_y1,t_x2,t_y2){
	bb_graphics_context.p_Validate();
	bb_graphics_renderDevice.DrawLine(t_x1,t_y1,t_x2,t_y2);
	return 0;
}
function bbInit(){
	bb_app__app=null;
	bb_app__delegate=null;
	bb_app__game=BBGame.Game();
	bb_graphics_device=null;
	bb_graphics_context=c_GraphicsContext.m_new.call(new c_GraphicsContext);
	c_Image.m_DefaultFlags=0;
	bb_audio_device=null;
	bb_input_device=null;
	bb_app__devWidth=0;
	bb_app__devHeight=0;
	bb_app__displayModes=[];
	bb_app__desktopMode=null;
	bb_graphics_renderDevice=null;
	bb_app__updateRate=0;
	c_MyApp.m_Texture="";
	c_MyApp.m_Ball=null;
	c_MyApp.m_BallShadow=null;
	c_MyApp.m_ScanLines=null;
	c_MyApp.m_CubeTex=null;
	c_MyApp.m_Stars=null;
	c_MyApp.m_Stars2=null;
	c_MyApp.m_Back=null;
	c_MyApp.m_Font=null;
	c_MyApp.m_FontMir=null;
	c_MyApp.m_FontBig=null;
	c_MyApp.m_Textos="";
	c_MyApp.m_Muzak=null;
	c_MyApp.m_MuzakInfo="";
	c_MyApp.m_x=0;
	c_MyApp.m_y=.0;
	c_MyApp.m_xs=0;
	c_MyApp.m_Rate=.0;
	c_MyApp.m_ScanY=0;
	c_MyApp.m_Rate2=.0;
	c_MyApp.m_gtx=.0;
	c_MyApp.m_v=0;
	c_MyApp.m_v2=0;
	c_MyApp.m_v3=0;
	c_MyApp.m_v4=0;
	c_MyApp.m_qx=0;
	c_MyApp.m_qy=0;
	c_MyApp.m_Zoom=0;
	c_MyApp.m_MatX=0;
	c_MyApp.m_MatY=0;
	c_MyApp.m_mir=0;
	c_MyApp.m_NextChar=0;
	c_MyApp.m_wob=0;
}
//${TRANSCODE_END}
