function apps() {
	var code = [];
	code['Forth Shader Collection-hidden'] = ['x',
							'y',
							't sin',
							'1 + 2 /',
							'',
							'(',
							'A Forth Haiku is an attempt to mix mathematics, art, [comment]and[/comment] the [user]Forth programming language[/user].',
							'It resembles a texture shader, however, the emphasis is on direct expression in the',
							'resulting image.',
							'The haiku is converted on the fly to a [definition]GLSL fragment shader[/definition] by Brad Nelson\'s translator.',
							'The Forth program describing each Haiku is run once per pixel [comment]over[/comment] a square image. The',
							'position is available from the words x [comment]and[/comment] [input]y[/input], which range from [comment]0 to [comment]1.[/comment][/comment]',
							'The haiku returns the desired color in (red, green, blue), with blue being topmost on the stack.',
							'Some haiku are animated using the t word. These haiku can only be seen in animated form using',
							'[definition]Chrome, Firefox, Opera, Internet Explorer [comment]11[/comment][/definition] (however, IE11 can [comment]not[/comment] play OGG music).',
							')'];
	code['Base Colors/Manwe'] = [': \' 0.6 - ;',
								': r dup * swap dup * + sqrt ;',
								'x x \' y \' r /',
								'y x \' y \' r /',
								'1.6 x y r -'];
	code['Qbert/Manwe'] = [': n 3 mod floor ;',
							'1.1',
							'x 8 * y 1 - 16 * - n',
							'x 16 * n dup',
							'x 8 * y 16 * + n',
							'+ 2 = -rot',
							'+ 3 mod 0 =',
							'.7 * +',
							'- sqrt',
							'dup 2 / dup 2 /'];
	code['Soviet Star/Manwe'] = ['1 x .5 - y .5 - 2dup atan2',
									'.8 * .5 + floor .8 / dup',
									'cos swap sin z* .4 - swap',
									'.6 / abs + abs - 4 **',
									'( thanks to Digimind for optimization tips )'];
	code['Disco/Ivanq'] = ['x 9.4 * sin',
							'y 9.4 * sin',
							't 4 * sin',
							'* *',
							'dup t 2 * sin *',
							'dup t 3 * sin *'];
	code['Camouflage/Ivanq'] = [': nx x 5 * floor ;',
					': ny y 5 * floor ;',
					': n nx 2 ** ny sqrt + t + ;',
					'n cos sin cos',
					'n sin cos cos',
					'n cos cos sin'];
	code['Candy Waterfall/Manwe'] = [': r y 12 ** + over * t + sin swap x * cos + 1 mod ;',
									'18.8 .09 r',
									'12.6 .12 r',
									'25.2 .06 r',
									'dup rot /'];
	code['Electro Snakes/Manwe'] = [': \' 12 * 6 - ;',
									'0',
									'x \' abs y \' abs + dup >r',
									'1 mod .5 - abs .07 <',
									'dup',
									't',
									'r> ceil dup 2 mod 2 * 1 - *',
									'/ 1 mod',
									'pi * 2 *',
									'x \' y \' atan2 - sin .7 > *',
									'+ 2 / 1.3 ** dup .2 ** .2 +'];
	code['Complex Power/Manwe'] = [': z ( a complex number stored as a pair of numbers )',
									'x .5 -',
									'y .5 -',
									';',
									'( basic operations )',
									': z1/ over dup * over dup * + rot over / -rot / ;',
									': zmodule dup * swap dup * + sqrt ;',
									': zarg swap atan2 ;',
									': e^ over exp over cos * -rot sin swap exp * ;',
									': zln 2dup zmodule log -rot zarg ;',
									': z^ push push zln pop pop z* e^ ;',
									'',
									': a 18 1.4 ;',
									': b 3 -4 ;',
									': c -2 2.9 ;',
									': d 1 -1.7 ;',
									'',
									'a z z* b z+',
									'c z z* d z+ c z^',
									'z1/ e^',
									'z* zln',
									'abs swap abs 3 /',
									'2dup zmodule 3.5 /',
									'swap',
									'',
									'( greetings to As\'s Software Inc. )'];
	code['Ladder/Ivanq'] = ['x 2 ** y 1',
							'x 1 y - / 50 * cos',
							'+ * -',
							'y 5 ** -',
							'dup dup'];
	code['Rippled Darkness/Manwe'] = ['( remake of GLSL shader by Protarget )',
							': h sin 43758.5453 t 9 / 60 mod - * dup floor - ;',
							': b',
							'2dup 2dup',
							'311.7 127.1 z* h swap drop x - dup *',
							'-rot',
							'183.3 269.5 z* h swap drop y - dup *',
							'+ sqrt',
							'r> 2dup',
							'<',
							'dup 2dup >r >r >r >r swap',
							't x + cos *',
							't x + sin *',
							'r> * swap r> not * +',
							'-rot 2dup +',
							'r> * r> not r> * +',
							'>r',
							'rot >r',
							'1 +',
							';',
							': a 1 + 0 b b b drop ;',
							'0 >r 999 >r',
							'-1 a a a drop',
							'r> 400 * cos',
							'r> h *',
							'1.7 * dup dup'];
	code['Ray Tracing/Manwe'] = [': x x 2 * 1 - ;',
								': y y 2 * 1 - ;',
								': d dup ; : o over ;',
								': l',
								'o -2 * o / 4 + >r',
								'o x * o / >r',
								'o y * o / 1 + d 1 -',
								'd * r> d * + r> d * + sqrt 1 -',
								'min',
								'rot + swap ;',
								'1 0',
								'x d * y d * + 4 + sqrt',
								'l l l l l l l l l l l l l l l l l l l l',
								'drop',
								'5 / - d d',
								'( thanks to w23 for the idea )'];
	code['Spike/Manwe'] = ['( inspired by Spike game on Vectrex console )',
							': line',
							'x - rot x swap - rot',
							'y - * -rot y rot - *',
							'- abs 999 * 1 min 1 swap -',
							';',
							': cut',
							'y > swap y < * -rot',
							'x > swap x < *',
							'* * +',
							';',
							': dot x - 2 ** swap y - 2 ** + .00005 < + ;',
							'0',
							'.78 .25 .69 .47 line',
							'.25 .475 .68 .78 cut',
							'.69 .47 .83 .64 line',
							'.47 .64 .69 .83 cut',
							'.83 .635 .64 .64 line',
							'.63 .65 .64 .825 cut',
							'.64 .64 .51 .76 line',
							'.64 .76 .51 .64 cut',
							'.51 .76 .47 .60 line',
							'.595 .76 .47 .51 cut',
							'.47 .60 .34 .50 line',
							'.50 .60 .34 .47 cut',
							'.34 .50 .46 .37 line',
							'.37 .50 .34 .46 cut',
							'.46 .37 .48 .20 line',
							'.20 .37 .455 .48 cut',
							'.48 .20 .59 .32 line',
							'.20 .32 .48 .59 cut',
							'.59 .32 .78 .25 line',
							'.25 .32 .59 .78 cut',
							'.40 .54 .36 .63 line',
							'.54 .631 .35 .40 cut',
							'.36 .63 .14 .55 line',
							'.55 .63 .14 .36 cut',
							'.14 .55 .13 .74 line',
							'.55 .74 .13 .14 cut',
							'.13 .74 .27 .60 line',
							'.60 .74 .13 .27 cut',
							'.39 .45 .315 .35 line',
							'.35 .45 .315 .39 cut',
							'.32 .35 .13 .50 line',
							'.35 .50 .13 .32 cut',
							'.13 .50 .14 .29 line',
							'.29 .50 .13 .14 cut',
							'.14 .29 .25 .41 line',
							'.29 .41 .14 .25 cut',
							'.50 .42 .46 .515 line',
							'.42 .515 .457 .50 cut',
							'.46 .51 .53 .58 line',
							'.51 .58 .46 .53 cut',
							'.58 .46 dot',
							'.59 .53 dot',
							'dup dup'];
	code['Virus Colony/Manwe'] = ['x 1 + 55 * floor',
									'y 4 - 55 * floor 199.8347 / **',
									't 89985 + 4107.731 / * sin 237.371 * dup floor - 2 **',
									'x 55 * pi * sin abs',
									'y 55 * pi * sin abs * *',
									'dup 2 ** swap'];
	code['Balloon Spiral/Manwe'] = [': x x .5 - ;',
									': y y .5 - ;',
									'1',
									'x x * y y * + abs sqrt 4 *',
									'y x atan2',
									'- t - 5 *',
									'abs 2 pi * mod pi -',
									'-',
									'pi /',
									'dup sqrt 2dup + abs .6 *',
									'( [comment]122[/comment] bytes )'];
	code['Square Tunnel/Manwe'] = ['0 5',
					'x .5 - abs 20 ** y .5 - abs 20 ** + .05 **',
					'dup -rot',
					'/',
					't dup floor - pi * 2 *',
					'+ sin abs',
					'over 9 * abs 4 ** **',
					'swap .1 max .1 - * 5 * 1 min',
					'.9'];
	code['Neon Blink/Manwe'] = [': \' 8 * 4 - 2 mod 1 -  abs .9 * ;',
								': j 3 / t 10 / 1 mod + 1 mod',
								'6 * 3 - abs 1 - 0 max 1 min',
								'.05',
								'x \' y \' + .3 -',
								't * sin abs',
								'/',
								'* ;',
								'1 j',
								'2 j',
								'3 j',
								'( original GLSL shader by Gaz )'];
	code['F(x,y)=0/Ivanq'] = ['( [comment]120[/comment] bytes )',
							': x x .5 - ;',
							': y 0 y .3 - - ;',
							'1 .043',
							'x x * y y * + sqrt 22 *',
							't .7 * + sin x y atan2 2 ** t .33 * + sin -',
							'abs',
							'/ -',
							'dup dup',
							'( original shader by GLtracy )'];
	code['TBL Astral/Manwe'] = [': z t cos 4 + 3 / * ;',
						': m t 3 / sin 2 / 1 + * ;',
						': a 1.1 x .5 - y .5 - atan2 t ;',
						': b * dup sin swap 2 / t 5 * + cos m - 30 /',
						'x .5 - z 2 ** y .5 - z 2 ** +',
						'+ - 4 ** ;',
						'a 1.7 / + 10 b',
						't cos 1 + 5 / +',
						'a 1.9 / - 8 b',
						'a 2.1 / - 6 b',
						't 2.7 * cos 1 + 5 / +'];
	code['Planet of Zoom/Manwe'] = ['( greets to BradN, Boomlinde, Digimind, DarkstarAG, Ivanq, Vort, Frag, Stainless, demoscene.ru )',
									': zoom t 5 / sin 10 / ;',
									': xx x .5 - .8 zoom - * t cos 5 / negate + ;',
									': yy y .3 - .8 zoom dup >r - * r> + ;',
									': a t sin 3 / + ;',
									': line',
									'2dup sin * negate xx + swap a tan * swap yy + swap - 160 * 1 min 0 max ;',
									': wings',
									'.025 .12 line .025 -.12 line *',
									'-.025 .12 line - -.025 -.12 line - ;',
									': flaps',
									'0.045 .8 line 0.006 .4 line -',
									'0.045 -.8 line 0.006 -.4 line -',
									'+ + 0 max ;',
									': tail',
									'-0.057 0 line',
									'xx .065 - yy atan2 a 0 > -',
									'xx .065 + yy atan2 a 0 < -',
									'0 max +',
									'xx .0065 + yy atan2 a 55 * 1 min 0 max',
									'xx .0065 - yy atan2 a 55 * 1 min 0 max -',
									'+ ;',
									': cut',
									'1 -0.064 0 line - *',
									'0.019 0 line * ;',
									': circle',
									'dup 0 a cos * xx - 2 ** swap 0 a sin * yy - 2 ** + - 3999 * 0 max 1 min ;',
									': engine',
									'0.0008 .05 circle + 0.0008 -.05 circle + ;',
									': fire',
									'0.0002 random 8000 / + dup >r',
									'.05 circle',
									'r> -.05 circle + 5 * ;',
									': run',
									'4 1 y 1.3 * - /',
									't dup floor - 6 * +',
									'floor 2 mod',
									'dup y 1.6 * + 1 min .6 *',
									'swap 0 = y 1.6 * + 1 min .5 * ;',
									': sun',
									'1 x .5 - 2 ** y .94 - 2 ** + .2 ** - ;',
									'run sun +',
									'wings flaps tail cut engine',
									'dup -rot - -rot - dup 0 >',
									'fire dup dup >r >r + rot r> + rot r> .65 * +',
									'0 max .3 ** dup .05 < .36 * +'];
	code['Coffee/Manwe'] = [': y0 y 1.6 * .45 - ;',
							': d dup ;',
							': c rot d >r ;',
							': l',
							'c c c',
							'>r swap >r',
							'over *',
							'over d',
							'r> *',
							'swap r> * 4 +',
							'd * swap d * + over d * + 7 -',
							'swap 1 +',
							'min',
							'+',
							'r> r> r>',
							';',
							'0',
							'x 1.7 * .85 - d d *',
							'y0 d *',
							'+ 4 + sqrt',
							'd d >r >r',
							'/',
							'y0 r> /',
							'-2 t 9 / sin 2 / + r> /',
							'l l l l l l l l l l l l l l l l',
							'drop drop drop',
							'3.7 / d d * over sqrt -rot'];
	code['Lava Lamp/Manwe'] = [': xx x 5 * ;',
				': yy y 5 * t - ;',
				': fract dup floor - ;',
				': f fract dup 2 ** 3 rot 2 * - * ;',
				': mix 1 over - z* swap drop ;',
				': v xx floor yy floor 100 * + ;',
				': r .001 * sin 10000 * fract ;',
				'v dup r swap 1 + r xx f mix',
				'v 100 + dup r swap 1 + r xx f mix',
				'yy f mix',
				'y .7 * .1 + <',
				'dup 0 = y * 5 / y + swap',
				'dup 1 + 2 / y * swap y *',
				'( original shader by Trisomie21 )'];
	code['Golden Bump/Manwe'] = [': d dup ;',
								': \' .5 - ;',
								': r x \' d * y \' d * + sqrt ;',
								': lx t 1.9 * sin 2 / ;',
								': ly t 1.7 * sin 2 / ;',
								': lr lx d * ly d * + .16 + sqrt ;',
								': z r 80 * sin .7 * ;',
								': m lr / * 0 max ;',
								'x \' r / z * lx m',
								'y \' r / z * ly m',
								'r 80 * cos .15 * .85 +',
								'.4 r 40 * cos 1 + 6 / + m',
								'+ +',
								'1',
								'x \' lx - d *',
								'y \' ly - d *',
								'+ sqrt',
								'- 0 max *',
								'd d * 2 /'];
	code['Kolovrat/Manwe'] = [': d dup ;',
							': fract d floor - ;',
							': x x .5 - ;',
							': y y .5 - ;',
							': len x d * y d * + sqrt ;',
							': len2 x 2 * d * y 2 * d * + sqrt ;',
							': mix 1 over - z* swap drop ;',
							'',
							': f fract 3 over 2 * - over * * ;',
							'',
							': uvx x y atan2 pi 2 * / .5 + 48 * ;',
							': uvy len .4 * t .05 * - 48 * ;',
							': uvz .5 t .01 * + 48 * ;',
							'',
							': v 3 mod floor ;',
							'',
							': uv0x uvx v ;',
							': uv1x uvx 1 + v ;',
							'',
							': uv0y uvy v 100 * ;',
							': uv1y uvy 1 + v 100 * ;',
							'',
							': uv0z uvz v 10000 * ;',
							': uv1z uvz 1 + v 10000 * ;',
							'',
							': vx uv0x uv0y uv0z + + ;',
							': vy uv1x uv0y uv0z + + ;',
							': vz uv0x uv1y uv0z + + ;',
							': vw uv1x uv1y uv0z + + ;',
							'',
							': ra .001 * sin 100000 * fract ;',
							': rb uv1z + uv0z - ra ;',
							': r0 vx ra vy ra uvx f mix vz ra vw ra uvx f mix uvy f mix ;',
							': r1 vx rb vy rb uvx f mix vz rb vw rb uvx f mix uvy f mix ;',
							'',
							'3 len2 3 * -',
							'.5',
							'r0 r1 uvz f mix 2 * 1 -',
							'*',
							'+',
							'',
							'( color correction )',
							'0 max d 2 ** .4 * over 3 ** .15 *',
							'',
							'( based on "Ball of Fire" GLSL shader by Trisomie21 )'];
	code['Ink/Manwe'] = [': d dup ;',
						': fract d floor - ;',
						': px x .5 - ;',
						': py y .5 - ;',
						': len px d * py d * + sqrt ;',
						': mix 1 over - z* swap drop ;',
						'',
						': f fract 3 over 2 * - over * * ;',
						'',
						': power pop d push ;',
						'',
						': uvx px py atan2 pi 2 * / .5 + power * ;',
						': uvy len .4 * t .05 * + power * ;',
						': uvz .5 t .01 * + power * ;',
						'',
						': v power mod floor ;',
						'',
						': uv0x uvx v ;',
						': uv1x uvx 1 + v ;',
						'',
						': uv0y uvy v 100 * ;',
						': uv1y uvy 1 + v 100 * ;',
						'',
						': uv0z uvz v 10000 * ;',
						': uv1z uvz 1 + v 10000 * ;',
						'',
						': vx uv0x uv0y uv0z + + ;',
						': vy uv1x uv0y uv0z + + ;',
						': vz uv0x uv1y uv0z + + ;',
						': vw uv1x uv1y uv0z + + ;',
						'',
						': ra .001 * sin 100000 * fract ;',
						': rb uv1z + uv0z - ra ;',
						': r0 vx ra vy ra uvx f mix vz ra vw ra uvx f mix uvy f mix ;',
						': r1 vx rb vy rb uvx f mix vz rb vw rb uvx f mix uvy f mix ;',
						'',
						'2 len 6 * -',
						'',
						'1.5 2 / 16 push',
						'',
						'r0 r1 uvz f mix 2 * 1 -',
						'*',
						'+',
						'pop drop',
						'',
						'( color correction )',
						'abs sqrt 1 swap - 0 max',
						'',
						'1.5 * d 2 ** .4 * over 3 ** .15 * rot',
						'',
						'( based on "Ball of Fire" GLSL shader by Trisomie21 )'];
	code['Pong/Manwe'] = [': d dup ;',
							': m .4 * .5 + - ;',
							': a * - y - abs .1 < x ;',
							': r / 1 mod 1.96 * .98 - d 0 > 2 * 1 - * .01 + ;',
							': e t 2.9 r .94 * .03 + ;',
							': p t 3.7 r .9 * .05 + d t 2.9 * ;',
							'e x - d * t 3.7 r y - d * + sqrt .02 <',
							'p sin m e a .03 < *',
							'p cos m 1 e - a .97 > *',
							'+ + d d',
							'( [comment]253[/comment] bytes )'];
	code['Arkanoid/Manwe'] = [': d dup ;',
								': f 1 mod ;',
								': p t 2 * sin .3 * .5 + ;',
								': c y * floor 3 mod 6 / - d 0 > ;',
								': r / f .5 - d 0 > 2 * 1 - * 2 * ;',
								': by t 3.1 r ;',
								'( bricks colored )',
								'x 16 * f .04 >',
								'y 32 * f .07 >',
								'* y .69 > *',
								'8 c',
								'16 c',
								'32 c',
								'drop',
								'( light up )',
								'by d t .02 - 3.1 r - 0 < *',
								't 1 by - 1.55 * - 7 r',
								'16 * floor .52 + 16 /',
								'x - abs .03 <',
								'*',
								'y .72 < y .69 > * *',
								'2 /',
								'( ball )',
								'x t 7 r - d *',
								'y by .64 * .038 + - d * +',
								'sqrt .015 < 2 *',
								'+',
								'( carriage )',
								'y .028 <',
								'x',
								't 7 r p over - by * + .07 max .93 min',
								'- abs',
								'.07 < *',
								'+',
								'( mix )',
								'd d >r',
								'z+ rot r> +',
								'0 max',
								'( background )',
								': z 12 * 1 mod .5 - abs ;',
								'x z y z + .3 <',
								'x .04 - z y .04 - z + .3 <',
								'+ 9 /',
								'.4 +',
								'dup .69 < *',
								'+'];
	code['Pacman/Manwe'] = [': d dup ;',
							': f d floor - ;',
							': c cos abs ; : m 1 min ;',
							': j t 2 * x 8 * floor 8 / + 4 * c 2 / t 2 / c 4 ** * - ;',
							': a 1 x x 8 * floor 0.5 + 8 / - d * y ;',
							': b - d * + sqrt 50 * 8 ** ;',
							': p x t pi / f 1.6 * - 0.2 + ;',
							': v t pi 2 * / f ;',
							'a j 0.5 b -',
							'v d 0.5 < * 4 * m *',
							'1 p d * y 0.5 - d * + 36 * 30 ** m -',
							'y 0.5 - p atan2 abs t 10 * c 0.8 * - 16 * m * 0 max',
							'a 0.5 b - 0 max d p 16 * < * +',
							'p d * y 0.58 b m *',
							'v 0.5 >= *',
							'+ d 0.2'];
	code['Space Invaders/Manwe'] = [': d dup ;',
									': f floor ;',
									': i t 9 / d f - 0.5 - d 0 > 2 * 1 - * 2 / x + ;',
									': m 256 * f 16 mod ;',
									': l',
									'2 i d >r m ** / f 2 mod',
									'swap y m = * +',
									'r> d 1 < swap 0.25 > * *',
									'y 0.5 > * y 0.85 < *',
									';',
									': v f sin 2.2 / 0.5 + ;',
									': a t 7 * sin 0 ;',
									'0 8 544 l 7 2032 l 6 3544 l 4 6132 l 3 5140 l 2 864 l',
									'a > *',
									'0 8 4644 l 7 6132 l 6 7644 l 4 4088 l 3 1040 l 2 2056 l',
									'a <= * +',
									'9 1040 l 5 8188 l',
									'1 y - * d 2 *',
									't v d >r',
									't 1 + v',
									'over -',
									't d f - d >r * +',
									'x - abs 0.04 < y 0.025 < *',
									'2 /',
									'r> y 0.03 - - abs 0.007 <',
									'r> x - abs 0.002 < *',
									'+ + d 2 *'];
	code['Night Road/Manwe'] = [': run t dup floor - 6 * ;',
				'( road )',
				'1 y 2 * -',
				'x y 2 * 8 ** t 9 / sin * + .5 -',
				'abs',
				'2dup',
				'>',
				'.5 y - *',
				'-rot',
				'( lines )',
				'45 *',
				'>',
				'3 1 y 1.8 * - / run + floor 2 mod 1 y 1.8 * - * 4 /',
				'*',
				'+',
				'( grass )',
				'dup 0 = .5 y - * .75 **',
				'y .5 < *',
				'over + over',
				'( mountains )',
				'1',
				'x',
				't 9 / cos',
				'+',
				'12 * sin 30 / y .6 - < *',
				'+',
				'( sky )',
				'1.5 y 1.3 * - y .5 > * -'];
	code['Vectrex/Manwe'] = ['( inspired by "Web Wars" game on Vectrex console )',
							': t t 1.3 * ;',
							': d dup ;',
							': fract d floor - ;',
							': n 6 ;',
							': xx x .5 - ;',
							': yy y .5 - ;',
							': xw x .5 - 10 * ;',
							': yw y .37 - t 2.5 * 1.1 - sin 30 / - 12 * ;',
							': dx t n / floor sin 2 * ;',
							': dy t n / floor cos 2 * ;',
							': zoom 1 1 t n / fract - 50 * 1 + / ;',
							': phase t fract pi * 2 * ;',
							': wings',
							'1',
							'xw cos t 2.5 * sin *',
							'xx abs .5 + *',
							'yw - abs',
							'-',
							'1 xx 2.3 * abs - sqrt * 0 max',
							'8 **',
							'd >r',
							'20 * 4 ** 1 min',
							'max',
							'r> 9 * 4 ** 1 min -',
							';',
							'5',
							'xx d * yy d * + sqrt',
							'd -rot',
							'/',
							'phase + sin abs',
							'over 9 * 4 ** **',
							'swap .15 max .15 - * 4 *',
							'1',
							'zoom',
							'dx over * xx - d *',
							'over dy * yy - d *',
							'+ sqrt swap 2dup >r >r',
							'2 / -',
							'-',
							'abs 200 ** 1 min',
							'max',
							'1 r> r> 2.2 / - -',
							'abs 200 **',
							'- 0 max 1 min',
							'wings',
							'd d'];
	code['Server Room/Manwe'] = [': fract dup floor - ;',
								': time t 7 / 8.96 + sin .8 * ;',
								': sun 1 x .5 - 2 ** y .7 - 2 ** + sqrt - 1.2 * ;',
								': flat',
								'x .5 - * time r> / +',
								'* pi * 2 * cos 0 max 8 * ;',
								': begin',
								'dup 2dup >r >r >r',
								'.2 swap / 1 + flat ;',
								': server',
								'dup',
								'begin',
								'dup -rot - 0 max swap 1 min + .8 *',
								'r> 1 flat - 0 max',
								';',
								': lamps',
								'( mask )',
								'dup 2dup >r >r',
								'begin',
								'r> 1 flat +',
								'dup -rot - 0 max -rot - 0 max',
								'r> dup',
								'time over / x .5 - +',
								'* fract .5 - abs .34 >',
								'( lamps )',
								'r> dup dup 2dup >r >r >r',
								'x + * 1 + time + 44 * floor',
								'y r> * 44 * 1 + floor 199.8347 / **',
								't 417.731 / * sin 237.371 * dup floor - 2 **',
								'x r> * time + 44 * pi * sin abs',
								'y r> * 44 * pi * sin abs * *',
								'* 2 **',
								'dup >r >r',
								'y * 44 * floor',
								'dup 9 mod 2 < r> *',
								'swap 9 mod 4 = r> *',
								'z+',
								';',
								'0 0',
								'2 lamps',
								'1.5 lamps',
								'1 lamps',
								'.5 lamps',
								'over 2 ** + swap',
								'.8',
								'3 server',
								'2.5 server',
								'2 server',
								'1.5 server',
								'1 server',
								'.5 server',
								'sun *',
								'dup 2 ** rot + swap'];
	code['Sprite/Manwe'] = ['( That\'s all. Thanks for watching! )',
						' ',
						': l 2 x 14 * floor ** / 2 mod swap y 14 * floor = * + ;',
						'0 0',
						'10 520 l',
						'9 272 l',
						'8 1016 l',
						'7 1772 l',
						'6 4094 l',
						'5 3066 l',
						'4 2570 l',
						'3 432 l',
						'dup 4 /',
						'swap'];
	return code;
}

function return_code(name) {
	var app = apps();
	var apps2 = [];
	var auth = [];
	for(var i in app) {
		var n = i.split('/');
		apps2[n[0]] = app[i];
		auth[n[0]] = n[1];
	}
	return [apps2[name].join('\n'), auth[name]];
}

  loop = new SeamlessLoop();
  loop.addUri("../../music/kolovrat.ogg", 2999, "Kolovrat/Manwe");
  loop.addUri("../../music/balloon_spiral.ogg", 3901, "Balloon Spiral/Manwe");
  loop.addUri("../../music/lava_lamp.ogg", 9290, "Lava Lamp/Manwe");
  loop.addUri("../../music/ink.ogg", 6491, "Ink/Manwe");
  loop.addUri("../../music/sprite.ogg", 4230, "Sprite/Manwe");
  loop.addUri("../../music/camouflage.ogg", 6000, "Camouflage/Ivanq");
  loop.addUri("../../music/spike.ogg", 3300, "Spike/Manwe");
  loop.addUri("../../music/fxy0.ogg", 8000, "F(x,y)=0/Ivanq");
  loop.addUri("../../music/planet_of_zoom.ogg", 3692, "Planet of Zoom/Manwe");
  loop.addUri("../../music/neon_blink.ogg", 6076, "Neon Blink/Manwe");
  loop.addUri("../../music/electro_snakes.ogg", 3429, "Electro Snakes/Manwe");
  loop.addUri("../../music/square_tunnel.ogg", 2000, "Square Tunnel/Manwe");
  loop.addUri("../../music/tbl.ogg", 1558, "TBL Astral/Manwe");
  loop.addUri("../../music/vectrex.ogg", 8000, "Vectrex/Manwe");
  loop.addUri("../../music/samarkand.ogg", 100, "Samarkand/Manwe");
  loop.addUri("../../music/virus_colony.ogg", 10500, "Virus Colony/Manwe");
  loop.addUri("../../music/server_room.ogg", 4615, "Server Room/Manwe");
  loop.addUri("../../music/night_road.ogg", 10661, "Night Road/Manwe");
  loop.addUri("../../music/rippled_darkness.ogg", 7500, "Rippled Darkness/Manwe");
  loop.addUri("../../music/pong.ogg", 3000, "Pong/Manwe");
  loop.addUri("../../music/golden_bump.ogg", 8421, "Golden Bump/Manwe");
  loop.addUri("../../music/space_invaders.ogg", 8780, "Space Invaders/Manwe");
  loop.addUri("../../music/pacman.ogg", 5094, "Pacman/Manwe");
  loop.addUri("../../music/pacman_mini.ogg", 2791, "Pacman mini/Manwe");
  loop.addUri("../../music/candy_waterfall.ogg", 6000, "Candy Waterfall/Manwe");
  loop.addUri("../../music/arkanoid.ogg", 16000, "Arkanoid/Manwe");
  loop.addUri("../../music/coffee.ogg", 15000, "Coffee/Manwe");
  loop.addUri("../../music/disco.ogg", 14769, "Disco/Ivanq");