; 2B or not 2B demo - snow
; generates chars in range $21...$7E (except forbidden) that can be entered manually
; copy this draft to your intro name and then write the code
; (c) 2020 / ShakeSpirt / RMDA

; fasm 1

format binary as 'bat'

org $82-@cmdlen
@cmd:
;db '@' ; uncomment this to cancel command line echo
db '2b ' ; execution command
@cmdlen = $-@cmd

org $82
start:

;-------------------------------------------------------------------------------

	; assume: ax = bx = 0

; decoder (only opcodes in range $21...$7E)
db '`4AP](Ff5-0)FYU_SX3Fh-AKAA!]h1EhEEGIu+a'

main:

;===============================================================================

	; ax = 0, di = sp = $FFFE

	mov al,$13
	int $10			; 320x200, 256 colors

	push $A000
	pop ds			; ds = video segment

@@:	imul di,77		; random position
	mov byte [di],15	; set snow flake
	loop @B

next:
	shr byte [di],4		; check and clear snowflake
	jnc @F			; jump if no snowflake
	imul dx,77
	inc dx
	mov bl,dh
	and bl,2		; random value 0 or 2 (move left or right)
	mov byte [di+bx+319],15	; move snowflake down
@@:	dec di			; next (previous) position

	in al,$60		; delay :)
	dec al
	jnz next		; check for any keypress

	ret

;===============================================================================

mainend:
mainsize = mainend-main
rb mainsize

repeat mainsize
  load x byte from mainend-%
  x = (x and $F + 'A') + (x shr 4 + 'K') shl 8
  store word x at $-%*2
end repeat

;-------------------------------------------------------------------------------

include '2b.check.inc' ; code check (highly desirable)
include '2b.debug.inc' ; create .com and .bin files for debugging (can be commented)
