/*
 * Decompiled with CFR 0.152.
 */
package resident;

import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;
import resident.MathFP;

public class WormHole
extends GameCanvas {
    private int timer;
    private int WIDTH;
    private int HEIGHT;
    private int[] palette = new int[]{0xFE0000, 16647680, 16649216, 16650752, 16652288, 16653824, 16655360, 16656896, 16658432, 16659968, 16661504, 16663040, 16664576, 16666112, 16667648, 16668928, 16670464, 16672000, 16673536, 16675072, 16676608, 16678144, 16679680, 16681216, 16682752, 16684288, 16685824, 16687360, 16688896, 16690176, 16691712, 16693248, 16694784, 16696320, 16697856, 16699392, 16700928, 16702464, 16704000, 16705536, 0xFEEE00, 16708608, 16710144, 16580096, 16186880, 0xF0FE00, 15400448, 15007232, 14614016, 14220800, 13827584, 13434368, 13041152, 12647936, 12254720, 11861504, 11468288, 11140608, 10747392, 10354176, 9960960, 9567744, 9174528, 8781312, 8388096, 7994880, 7601664, 7208448, 6815232, 6422016, 6028800, 5635584, 5307904, 4914688, 4521472, 4128256, 3735040, 3341824, 2948608, 2555392, 2162176, 1768960, 1375744, 982528, 589312, 196096, 65028, 65034, 65040, 65046, 65052, 65058, 65064, 65070, 65076, 65082, 65088, 65094, 65100, 65106, 65111, 65117, 65123, 65129, 65135, 65141, 65147, 65153, 65159, 65165, 65171, 65177, 65183, 65189, 65194, 65200, 65206, 65212, 65218, 65224, 65230, 65236, 65242, 65248, 65254, 65260, 65266, 65272, 65278, 63742, 62206, 60670, 59134, 57598, 56062, 54526, 52990, 51454, 49918, 48382, 46846, 45310, 43774, 42494, 40958, 39422, 37886, 36350, 34814, 33278, 31742, 30206, 28670, 27134, 25598, 24062, 22526, 21246, 19710, 18174, 16638, 15102, 13566, 12030, 10494, 8958, 7422, 5886, 4350, 2814, 1278, 131326, 524542, 917758, 1310974, 1704190, 2097406, 2490622, 2883838, 3277054, 3670270, 4063486, 4456702, 4849918, 5243134, 5570814, 5964030, 6357246, 6750462, 7143678, 7536894, 7930110, 8323326, 8716542, 9109758, 9502974, 9896190, 10289406, 10682622, 11075838, 11403518, 11796734, 12189950, 12583166, 12976382, 13369598, 13762814, 14156030, 14549246, 14942462, 15335678, 0xF000FE, 16122110, 16515326, 16646394, 16646388, 0xFE00EE, 16646376, 16646370, 16646364, 16646358, 16646352, 16646346, 16646340, 16646334, 16646328, 16646322, 16646316, 16646311, 16646305, 16646299, 16646293, 16646287, 16646281, 16646275, 16646269, 16646263, 16646257, 16646251, 16646245, 16646239, 16646233, 16646228, 16646222, 16646216, 16646210, 16646204, 16646198, 16646192, 16646186, 16646180, 16646174, 16646168, 16646162, 16646156, 16646150};
    private Image chip;
    private int worm = 0;
    private int harm = 3;
    private int imageUp = 0;

    protected WormHole(int WIDTH, int HEIGHT) {
        super(true);
        this.WIDTH = WIDTH;
        this.HEIGHT = HEIGHT;
        this.timer = 0;
        try {
            this.chip = Image.createImage((String)"/chip.png");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Image getImage() {
        return this.chip;
    }

    public void draw(Graphics g) {
        if (this.worm < -110 || this.worm > 70) {
            this.harm = -this.harm;
        }
        this.worm += this.harm;
        int i = 0;
        while (i < 130) {
            g.setColor(this.palette[(i + this.timer) % 256]);
            int pos1 = MathFP.sin(this.timer * 100 + i * 100) / (MathFP.sin(this.timer * 100) / 75 + 200 + this.worm);
            int pos2 = MathFP.cos(this.timer * 100 + i * 100) / (MathFP.sin(this.timer * 100) / 75 + 200 - this.worm);
            g.drawArc(-75 + pos1 + i, -75 + pos2 + i, 300 - i * 2, 300 - i * 2, 0, pos1 + this.timer);
            i += 2;
        }
        if (this.timer > 1200) {
            g.drawImage(this.chip, 0, this.HEIGHT - this.imageUp, 0);
            this.imageUp += 4;
            if (this.imageUp > this.HEIGHT) {
                this.imageUp = this.HEIGHT;
            }
        }
        this.timer += 12;
    }
}

