/*
 * Decompiled with CFR 0.152.
 */
package resident;

import java.io.InputStream;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.GameCanvas;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import resident.Credits;
import resident.Greets;
import resident.LoaderPart;
import resident.PlasmaPart;
import resident.RecTrees;
import resident.WastedMain;
import resident.WaverPart;
import resident.WormHole;

public class DemoEngine
extends GameCanvas {
    private int demoTime = 0;
    private boolean isPlasmaLoaded;
    private boolean isWaverLoaded;
    private boolean isLoaderPartLoaded;
    private boolean isTreeLoaded;
    private boolean isDemoFinished;
    private boolean isGreetsLoaded;
    private boolean isWormHoleLoaded;
    private boolean isCreditsLoaded;
    private Player music1;
    private final int WIDTH;
    private final int HEIGHT;
    private int[] bufferArray1;
    private int[] bufferArray2;
    private LoaderPart loaderPart;
    private PlasmaPart plasma;
    private WaverPart waverPart;
    private RecTrees tree;
    private Greets greet;
    private WormHole wormPart;
    private Credits creditPart;

    public DemoEngine() {
        super(true);
        this.setFullScreenMode(true);
        this.setPlayerAndMusic();
        this.WIDTH = 176;
        this.HEIGHT = 208;
        this.bufferArray1 = new int[this.WIDTH * this.HEIGHT];
        this.bufferArray2 = new int[this.WIDTH * this.HEIGHT];
        this.isPlasmaLoaded = false;
        this.isWaverLoaded = false;
        this.isLoaderPartLoaded = false;
        this.isTreeLoaded = false;
        this.isDemoFinished = false;
        this.isGreetsLoaded = false;
    }

    public void startAnimation(final WastedMain jm) {
        TimerTask task = new TimerTask(){

            public void run() {
                DemoEngine.this.refresh();
                if ((DemoEngine.this.getKeyStates() & 0x100) != 0 || DemoEngine.this.isDemoFinished) {
                    jm.destroyApp(false);
                    jm.notifyDestroyed();
                }
            }
        };
        Timer timer = new Timer();
        timer.schedule(task, new Date(), 10L);
    }

    private void refresh() {
        Graphics g = this.getGraphics();
        this.clear(g);
        if (this.demoTime < 571) {
            if (!this.isLoaderPartLoaded) {
                this.loaderPart = new LoaderPart(this.WIDTH, this.HEIGHT, this.bufferArray1);
                this.isLoaderPartLoaded = true;
            } else {
                this.loaderPart.draw(g);
            }
        } else if (this.demoTime < 1150) {
            if (!this.isPlasmaLoaded) {
                this.plasma = new PlasmaPart(this.WIDTH, this.HEIGHT, this.bufferArray1, this.bufferArray2);
                this.plasma.setRGBImage(this.loaderPart.getRGBimage());
                this.isPlasmaLoaded = true;
                this.startMusic();
                this.plasma.draw(g);
            } else {
                this.plasma.draw(g);
            }
        } else if (this.demoTime < 2550) {
            if (!this.isWaverLoaded) {
                this.waverPart = new WaverPart(this.WIDTH, this.HEIGHT);
                this.isWaverLoaded = true;
                this.waverPart.draw(g);
            } else {
                this.waverPart.draw(g);
            }
        } else if (this.demoTime < 3000) {
            if (!this.isTreeLoaded) {
                this.tree = new RecTrees();
                this.tree.setImage(this.waverPart.getImage());
                this.isTreeLoaded = true;
                this.tree.draw(g);
            } else {
                this.tree.draw(g);
            }
        } else if (this.demoTime < 3160) {
            if (!this.isWormHoleLoaded) {
                this.wormPart = new WormHole(this.WIDTH, this.HEIGHT);
                this.isWormHoleLoaded = true;
                this.wormPart.draw(g);
            } else {
                this.wormPart.draw(g);
            }
        } else if (this.demoTime < 3830) {
            if (!this.isCreditsLoaded) {
                this.creditPart = new Credits(this.WIDTH, this.HEIGHT);
                this.creditPart.setImage(this.wormPart.getImage());
                this.isCreditsLoaded = true;
                this.creditPart.draw(g);
            } else {
                this.creditPart.draw(g);
            }
        } else if (this.demoTime < 6000) {
            if (!this.isGreetsLoaded) {
                this.greet = new Greets(this.WIDTH, this.HEIGHT);
                this.isGreetsLoaded = true;
                this.greet.draw(g);
            } else {
                this.greet.draw(g);
            }
        } else {
            this.isDemoFinished = true;
        }
        g.setColor(0);
        g.fillRect(this.WIDTH, 0, this.WIDTH, this.HEIGHT);
        g.fillRect(0, this.HEIGHT, this.WIDTH * 2, this.HEIGHT);
        this.flushGraphics();
        ++this.demoTime;
    }

    private void clear(Graphics g) {
        g.setColor(0, 0, 0);
        g.fillRect(0, 0, this.WIDTH, this.HEIGHT);
    }

    private void setPlayerAndMusic() {
        try {
            InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream("/bart.mid");
            this.music1 = Manager.createPlayer((InputStream)in, (String)"audio/midi");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void startMusic() {
        this.music1.setLoopCount(6);
        try {
            this.music1.start();
        }
        catch (MediaException e) {
            e.printStackTrace();
        }
    }
}

