DECLARE SUB Rel.BoxF (DestSeg%, DestOff%, X1%, Y1%, X2%, Y2%, Clr%, Luty%())
DECLARE SUB BirthDay (Fps%, Vsynch%, MaxFrame%)
DECLARE SUB Rel.FontSwirl (DestSeg%, DestOff%, x%, y%, Text$, Centered%, FontArray%(), FontArrayIndex%(), GammaDisp%, angle%, Ly%(), Lsin!())
DECLARE FUNCTION Texter$ (Index%)
DECLARE SUB DoTitle (Fps%, Vsynch%, MaxFrame%)
DECLARE SUB Rel.Font256 (DestSeg%, DestOff%, x%, y%, Text$, Centered%, FontArray%(), FontArrayIndex%(), GammaDisp%, Ly%())
DECLARE SUB Rel.PrintDisco (DestSeg%, DestOff%, Xpos%, Ypos%, Text$, col%, xscale%, yscale%, Luty%(), Lsin1%(), Lsin2%(), Lsin3%())
DECLARE SUB LoadPlg (Model() AS ANY, Tri() AS ANY, Fil$, ScaleFactor!)
DECLARE SUB RotNormals (V() AS ANY, v2() AS ANY, anglex%, angley%, anglez%)
DECLARE SUB Amoeba (Fps%, Vsynch%, MaxFrame%, Intensity%)
DECLARE SUB CleanDisplay ()
DECLARE SUB Init ()
DECLARE SUB DrawPlgGradGT (Model() AS ANY, Poly() AS ANY)
DECLARE SUB SinusGlenzTeapot (Fps%, Vsynch%, MaxFrame%)
DECLARE SUB HGLineT (X1%, X2%, y%, col1&, col2&)
DECLARE SUB TriGouraudT (xx1%, yy1%, cc1%, xx2%, yy2%, cc2%, xx3%, yy3%, Cc3%)
DECLARE SUB Blobs (Fps%, Vsynch%, MaxFrame%, Intensity%)
DECLARE SUB DrawBlob (bx%, by%)
DECLARE SUB WateronPlasma (Fps%, Vsynch%, MaxFrame%)
DECLARE SUB WateronRotozoom (Fps%, Vsynch%, MaxFrame%)
DECLARE SUB DoRotoMono (Fps%, Vsynch%, MaxFrame%)
DECLARE SUB DoRotoTrans (Fps%, Vsynch%, MaxFrame%)
DECLARE SUB RotoZoom (Trans%, angle%, scale%)
DECLARE SUB Mode7Texture (Fps%, Vsynch%, Trans%, MaxFrame%, sx%, sy%, sz%, horz%)
DECLARE SUB LensPlasmaRT (x%, y%, Radius%, counter%, countdir%, Trans%)
DECLARE SUB DoLensPlasma (Fps%, Vsynch%, MaxFrame%)
DECLARE SUB DoLensTrans (Fps%, Vsynch%, MaxFrame%)
DECLARE SUB Mode7DiscoMask (Fps%, Vsynch%, MaxFrame%, sx%, sy%, sz%, horz%)
DECLARE SUB DrawPlgG (Model() AS ANY, Poly() AS ANY)
DECLARE SUB HGLine (X1%, X2%, y%, col1&, col2&)
DECLARE SUB TriGouraud (xx1%, yy1%, cc1%, xx2%, yy2%, cc2%, xx3%, yy3%, Cc3%)
DECLARE SUB RotMatrix (m AS ANY, anglex%, angley%, anglez%)
DECLARE SUB RotateAndProject (Model() AS ANY, anglex%, angley%, anglez%)
DECLARE SUB Plasma (Mono%, Fps%, Trans%, MaxFrame%, ptype%)
DECLARE SUB Tunnel (Fps%, Mono%, Vsynch%, MaxFrame%)
DECLARE SUB Fire (Fps%, Vsynch%, MaxFrame%)
DECLARE SUB Feedback (Fps%, Vsynch%, MaxFrame%)
DECLARE SUB Mode7 (Fps%, Trans%, Vsynch%, MaxFrame%, sx%, sy%, sz%, horz%)
DECLARE SUB LensTexture (x%, y%, Radius%, TextSize%, Trans%)
DECLARE SUB DoBump (Fps%, Vsynch%, MaxFrame%)
DECLARE SUB DrawLight (bx%, by%, size%)
DECLARE SUB Rel.Sprite (Layer%, LayerOffs%, x%, y%, sprite%(), SpriteOffset%, GammaDisp%, Ly%())
DECLARE SUB ReadPlgHeader (File$, NumPoints%, NumPolys%)
DECLARE SUB ReadPlgObject (File$, Model() AS ANY, Tri() AS ANY, NumPoints%, NumPolys%)
DECLARE SUB CenterObject (Maxo%, Model() AS ANY)
DECLARE SUB ScalePlg (Model() AS ANY, ScaleFactor!)
DECLARE SUB Rel.ReadPal (PalString$)
DECLARE SUB Zeropal ()
DECLARE SUB Rel.FadeToPalStep (StartCol%, EndCol%, PalString$)
DECLARE SUB Rel.FadeStep (StartCol%, EndCol%, r%, G%, b%)
DECLARE SUB Rel.LoadBMP (DestSeg%, Destoffs%, File$, SwitchPal%, TextSize%)
DECLARE SUB Rel.LoadPalPp256 (File$)
DECLARE SUB CalcNormals (Model() AS ANY, ModelConnect() AS ANY, V() AS ANY, v2() AS ANY)
DECLARE SUB SortPolys (Model() AS ANY, Poly() AS ANY)
DECLARE SUB InitMorph (Model() AS ANY, OldModel() AS ANY, NewModel() AS ANY)
DECLARE SUB InitImageData (FileName$, ImageArray%())
DECLARE SUB MakeImageIndex (ImageArray%(), IndexArray%())
DECLARE SUB Morphit (Model() AS ANY)
DECLARE SUB LoadSphere (SphereRadius%, Slices%, Bands%, ModelArray() AS ANY)
DECLARE SUB LoadTorus (Rings%, Bands%, RINGRADIUS%, BandRadius%, Model() AS ANY)
DECLARE SUB GreyPal (Pal$)
DECLARE SUB SetPolyBaseColor (Poly() AS ANY)
DECLARE SUB Grad (col1%, r1%, g1%, b1%, col2%, r2%, g2%, b2%)
DECLARE SUB Rel.PrintScale (DestSeg%, DestOff%, Xpos%, Ypos%, Text$, col%, xscale%, yscale%, Luty%())
DECLARE SUB Smooth (Dest%, Doffs%, Ly%(), div4%(), div8%(), div16%(), passes%)
'256*126 = 32256
'((256*126)+4)\2 =16130
'256*8 =2048
'Put(32,37)

DEFINT A-Z

TYPE BMPHeaderType                              'All values are for 320*200*256 bmp
        ID              AS STRING * 2           '"BM"
        size            AS LONG                 'width*heigth+1078= 65078
        RSV1            AS INTEGER              '0 Reserved
        RSV2            AS INTEGER              '0 Reserved
        offset          AS LONG                 '1078  First Pixel(Scanline order)
        horz            AS LONG                 '40
        WID             AS LONG                 '320
        HEI             AS LONG                 '200
        PLANES          AS INTEGER              '1   num of Planes
        BPP             AS INTEGER              '8   Bits per Plane
        COMPRESSION     AS LONG                 '0
        IMAGESIZE       AS LONG                 '64000  Width *Height
        XRES            AS LONG                 '3790  X pels
        YRES            AS LONG                 '3780  Y pels
        CLRUSED         AS LONG                 '0 Colors used
        CLRIMPORT       AS LONG                 '0 Colors Important
        Pal             AS STRING * 1024        'Order=Blue*4, Green*4, Red*4, 0 * 4
END TYPE

TYPE Point3d
        x       AS SINGLE                   'Normal 3d coords
        y       AS SINGLE
        z       AS SINGLE
        Xr      AS SINGLE
        Yr      AS SINGLE
        zr      AS SINGLE
        ScrX    AS INTEGER                  'Translated and projected
        ScrY    AS INTEGER                  '2d Coords
END TYPE
TYPE Morph3d
        x       AS SINGLE                   'Normal 3d coords
        y       AS SINGLE
        z       AS SINGLE
        xv      AS SINGLE                   'Normal 3d coords
        yv      AS SINGLE
        zv      AS SINGLE
        Xr      AS SINGLE
        Yr      AS SINGLE
        zr      AS SINGLE
        ScrX    AS INTEGER                  'Translated and projected
        ScrY    AS INTEGER                  '2d Coords
        C       AS INTEGER
END TYPE


TYPE PolyType
        p1      AS INTEGER
        p2      AS INTEGER
        p3      AS INTEGER
        clr1    AS INTEGER
        clr2    AS INTEGER
        clr3    AS INTEGER
        u1      AS INTEGER
        v1      AS INTEGER
        u2      AS INTEGER
        v2      AS INTEGER
        u3      AS INTEGER
        v3      AS INTEGER
        zcenter AS SINGLE
        Zorder  AS INTEGER
        idx     AS INTEGER
END TYPE

TYPE VectorType
        x      AS SINGLE
        y      AS SINGLE
        z      AS SINGLE
END TYPE

TYPE MatrixType
    tx1     AS SINGLE
    tx2     AS SINGLE
    tx3     AS SINGLE
    ty1     AS SINGLE
    ty2     AS SINGLE
    ty3     AS SINGLE
    tz1     AS SINGLE
    tz2     AS SINGLE
    tz3     AS SINGLE
END TYPE

TYPE PartType
        x               AS INTEGER
        y               AS INTEGER
        xv              AS INTEGER
        yv              AS INTEGER
        tx              AS INTEGER
        ty              AS INTEGER
        angle           AS INTEGER
        newtarget       AS INTEGER
END TYPE

TYPE TextType
    Txt         AS STRING * 60
    x           AS INTEGER
    y           AS INTEGER
    angle       AS INTEGER
    Gamma       AS INTEGER
END TYPE

CONST FALSE = 0, TRUE = NOT FALSE
CONST PI = 3.14151693#

CONST TORNUMRINGS = 30          'Number of Rings outside TORUS
CONST TORNUMBANDS = 10          'Number of PIXEL per RING
CONST TORRINGRADIUS = 50        'Radius of the Ring
CONST TORBANDRADIUS = 15        'Radius of the BAND

'Sphere
CONST SRADIUS = 40              'Radius of Sphere
CONST SPSLICES = 15             'Number of Slices
CONST SPBANDS = 20              'number of Pixel per slice

CONST LENS = 256                            'Z
CONST XCENTER = 128                         '??
CONST YCENTER = 64                         '??

DIM isr(0 TO 5) AS LONG
isr(0) = &H53EC8B55: isr(1) = &H83025E8B
isr(2) = &H8E0602EB: isr(3) = &HC7260446
isr(4) = &H79B9007: isr(5) = &HCF9B5D5B
DEF SEG = 0
OldISR1 = PEEK(&HF4)
OldISR2 = PEEK(&HF5)
OldISR3 = PEEK(&HF6)
OldISR4 = PEEK(&HF7)
POKE &HF4, VARPTR(isr(0)) AND 255
POKE &HF5, (CLNG(VARPTR(isr(0))) AND &HFF00&) \ 256
POKE &HF6, VARSEG(isr(0)) AND 255
POKE &HF7, (CLNG(VARSEG(isr(0))) AND &HFF00&) \ 256

'$DYNAMIC
DIM SHARED Vpage1%(0 TO 16130)
DIM SHARED Vpage2%(0 TO 16130)

DIM SHARED PlgModel(1) AS Point3d
DIM SHARED PlgPoly(1) AS PolyType
DIM SHARED PlgNormal(1) AS VectorType
DIM SHARED PlgNormal2(1) AS VectorType
DIM SHARED PlgVertexNormal(1) AS VectorType
DIM SHARED PlgVertexNormal2(1) AS VectorType

DIM SHARED sprite%(1 TO 1)
DIM SHARED spriteidx%(1 TO 1)
DIM SHARED Font%(1 TO 1)
DIM SHARED FontIndex%(1 TO 1)




'$STATIC
DIM SHARED div4%(0 TO 256 * 5)              'smooth
DIM SHARED div8%(0 TO 256 * 5)
DIM SHARED div16%(0 TO 256 * 5)
DIM SHARED scanline%(0 TO 255)

DIM SHARED Lsin1%(-1024 TO 1024)
DIM SHARED Lsin2%(-1024 TO 1024)
DIM SHARED Lsin3%(-1024 TO 1024)
DIM SHARED Lsin!(-10 TO 370)
DIM SHARED Lcos!(-10 TO 370)
DIM SHARED Ly%(0 TO 125)
DIM SHARED Sqrt%(0 TO 64 * 64)
DIM SHARED ATAN%(-63 TO -1, -128 TO -1)
DIM SHARED Texture%(((128 ^ 2) + 4) \ 2)'128*128
DIM SHARED Light%(63, 63)



DIM SHARED thetax%, thetay%, thetaz%
DIM SHARED zcenter%, camx%, camy%
DIM SHARED LightNormal AS VectorType
DIM SHARED Matrix AS MatrixType
DIM SHARED Path$
DIM SHARED GradPal AS STRING * 768
DIM SHARED RGBPal AS STRING * 768


DIM SHARED Layer1%, Offs1%
DIM SHARED Layer2%, offs2%
DIM SHARED TextSeg%, TextOff%


Path$ = "C:\qbasic\Monodisc\"
Path$ = ""

Init

CLS
SCREEN 13
COLOR 15
PRINT "Enter the black hole."
PRINT "Press your computer speed..."
PRINT ""
PRINT "1. Less than 200 Mhz"
PRINT "2. 200 to 800"
PRINT "3. 800 and above"
PRINT ""
PRINT "<Enter> won't Vsynch except for Plasmas"

DO
    K$ = INPUT$(1)
    Ret% = INSTR("123456", K$)
LOOP UNTIL Ret > 0 OR K$ = CHR$(13)
IF K$ = CHR$(13) THEN Ret% = 1


WaitBump% = FALSE
FpsBump% = 0
WaitTitle% = FALSE
FpsTitle% = 0
WaitMorph% = FALSE
FpsMorph% = 0
WaitFeedBack% = FALSE
FpsFeedback% = 0
WaitFire% = FALSE
FpsFire% = 0
WaitPlasma1% = FALSE
FpsPlasma1% = 0
WaitRotoMono% = FALSE
FpsRotoMono% = 0
WaitBlobs% = FALSE
FpsBlobs% = 0
WaitH20Plasma% = FALSE
FpsH20Plasma% = 0
WaitTunnel1% = FALSE
FpsTunnel1% = 0
WaitMode71% = FALSE
FpsMode71% = 0
WaitLensTrans% = FALSE
FpsLensTrans% = 0
WaitPlasma2% = FALSE
FpsPlasma2% = 0
WaitAmoeba% = FALSE
FpsAmoeba% = 0
WaitRotoTrans% = FALSE
FpsRotoTrans% = 0
WaitMode72% = FALSE
FpsMode72% = 0
WaitLensPlasma% = FALSE
FpsLensPlasma% = 0
WaitH20Roto% = FALSE
FpsH20Roto% = 0
WaitTunnel2% = FALSE
FpsTunnel2% = 0
WaitGlenz% = FALSE
FpsGlenz% = 0
WaitMask% = FALSE
FpsMask% = 0
WaitEnding% = FALSE
FpsEnding% = 0
WaitBday% = FALSE
FpsBday% = 0


SELECT CASE Ret%
    CASE 1
    CASE 2
        WaitBump% = TRUE
        WaitTitle% = FALSE
        WaitMorph% = TRUE
        WaitFeedBack% = FALSE
        WaitFire% = FALSE
        WaitPlasma1% = TRUE
        WaitRotoMono% = TRUE
        WaitBlobs% = TRUE
        WaitH20Plasma% = FALSE
        WaitTunnel1% = FALSE
        WaitMode71% = FALSE
        WaitLensTrans% = FALSE
        WaitPlasma2% = TRUE
        WaitAmoeba% = TRUE
        WaitRotoTrans% = FALSE
        WaitMode72% = FALSE
        WaitLensPlasma% = TRUE
        WaitH20Roto% = FALSE
        WaitTunnel2% = FALSE
        WaitGlenz% = FALSE
        WaitMask% = FALSE
        WaitEnding% = FALSE
        WaitBday% = FALSE
    CASE 3
        WaitBump% = TRUE
        WaitTitle% = TRUE
        WaitMorph% = TRUE
        WaitFeedBack% = TRUE
        WaitFire% = TRUE
        WaitPlasma1% = TRUE
        WaitRotoMono% = TRUE
        WaitBlobs% = TRUE
        WaitH20Plasma% = TRUE
        WaitTunnel1% = TRUE
        WaitMode71% = TRUE
        WaitLensTrans% = TRUE
        WaitPlasma2% = TRUE
        WaitAmoeba% = TRUE
        WaitRotoTrans% = TRUE
        WaitMode72% = TRUE
        WaitLensPlasma% = TRUE
        WaitH20Roto% = TRUE
        WaitTunnel2% = TRUE
        WaitGlenz% = TRUE
        WaitMask% = TRUE
        WaitEnding% = TRUE
        WaitBday% = TRUE
    CASE ELSE
END SELECT
CLS


MaxFrame = 1800
DoBump FpsBump%, WaitBump%, MaxFrame%

MaxFrame = 900
DoTitle FpsTitle%, WaitTitle%, MaxFrame%

sx% = 128
sy% = 128
sz% = 1
horz% = 5
Trans% = FALSE
MaxFrame = 1300
Mode7Texture FpsMorph%, WaitMorph%, Trans%, MaxFrame%, sx%, sy%, sz%, horz%

MaxFrame = 500
Feedback FpsFeedback%, WaitFeedBack%, MaxFrame%

MaxFrame = 900
Fire FpsFire%, WaitFire%, MaxFrame%

MaxFrame = 1600
Plasma Mono%, FpsPlasma1%, FALSE, MaxFrame%, 0

MaxFrame = 900
DoRotoMono FpsRotoMono%, WaitRotoMono%, MaxFrame%

MaxFrame = 1800
Blobs FpsBlobs%, WaitBlobs%, MaxFrame%, 64

MaxFrame = 900
WateronPlasma FpsH20Plasma%, WaitH20Plasma%, MaxFrame%

Mono% = TRUE
MaxFrame% = 700
Tunnel FpsTunnel1%, Mono%, WaitTunnel1%, MaxFrame%

sx% = 150
sy% = 150
sz% = 15
horz% = 5
MaxFrame = 1600
Mode7 FpsMode71%, FALSE, WaitMode71%, MaxFrame%, sx%, sy%, sz%, horz%

MaxFrame% = 900
DoLensTrans FpsLensTrans%, WaitLensTrans%, MaxFrame%

Mono% = FALSE
MaxFrame = 1600
Plasma Mono%, FpsPlasma2%, TRUE, MaxFrame%, 0


MaxFrame = 1200
Amoeba FpsAmoeba%, WaitAmoeba%, MaxFrame%, 64

MaxFrame% = 700
DoRotoTrans FpsRotoTrans%, WaitRotoTrans%, MaxFrame%

sx% = 150
sy% = 150
sz% = 15
horz% = 5
MaxFrame = 1600
Mode7 FpsMode72%, TRUE, WaitMode72%, MaxFrame%, sx%, sy%, sz%, horz%

MaxFrame = 900
DoLensPlasma FpsLensPlasma%, WaitLensPlasma%, MaxFrame%

MaxFrame = 700
WateronRotozoom FpsH20Roto%, WaitH20Roto%, MaxFrame%

Mono% = FALSE
MaxFrame = 900
Tunnel FpsTunnel2%, Mono%, WaitTunnel2%, MaxFrame%

MaxFrame = 1200
SinusGlenzTeapot FpsGlenz%, WaitGlenz%, MaxFrame%


MaxFrame = 700
Mode7DiscoMask FpsMask%, WaitMask%, MaxFrame%, sx%, sy%, sz%, horz%


sx% = 128
sy% = 128
sz% = 1
horz% = 5
Trans% = TRUE
MaxFrame = 7500
Mode7Texture FpsEnding%, WaitEnding%, Trans%, MaxFrame%, sx%, sy%, sz%, horz%

MaxFrame% = 900
BirthDay FpsBday%, WaitBday%, MaxFrame%

DEF SEG



DEF SEG = 0
POKE &HF4, OldISR1
POKE &HF5, OldISR2
POKE &HF6, OldISR3
POKE &HF7, OldISR4

CLS
SCREEN 0
WIDTH 80

PRINT "Bumpy="; FpsBump%
PRINT "Title="; FpsTitle%
PRINT "3dmorph="; FpsMorph%
PRINT "Feedback="; FpsFeedback%
PRINT "Fire="; FpsFire%
PRINT "MonoPlasma="; FpsPlasma1%
PRINT "RotoZoom="; FpsRotoMono%
PRINT "Metaballs="; FpsBlobs%
PRINT "Water on H20="; FpsH20Plasma%
PRINT "Tunnel="; FpsTunnel1%
PRINT "Mode7 Plasma="; FpsMode71%
PRINT "SphereMapping="; FpsLensTrans%
PRINT "Translucent Plasma="; FpsPlasma2%
PRINT "Amoeba="; FpsAmoeba%
PRINT "Blended Rotozoomer="; FpsRotoTrans%
PRINT "Translucent Floormap="; FpsMode72%
PRINT "Plasma on Sphere="; FpsLensPlasma%
PRINT "Water on Rotozoomer="; FpsH20Roto%
PRINT "Disco Tunnel="; FpsTunnel2%
PRINT "Gouraud Glenzing="; FpsGlenz%
PRINT "Mode7 Mask="; FpsMask%
PRINT "Ending="; FpsEnding%
PRINT "Happy Birthday!!!="; FpsBday%

PRINT "";
PRINT "Rel.Bettewebber.com";

C$ = INPUT$(1)
END

SUB Amoeba (Fps%, Vsynch%, MaxFrame%, Intensity%)
CleanDisplay
'Note!!! Newtarget is radius,Xv as Polar velocity
NumAmoeba = 9
Numblobs = 10
DIM blob(Numblobs, NumAmoeba) AS PartType
DIM Amoebas%(10, 1)              '0=x,y=1
FOR j% = 0 TO NumAmoeba
    Amoebas%(j%, 0) = INT(RND * 255)
    Amoebas%(j%, 1) = INT(RND * 125)
    FOR i% = 0 TO Numblobs
        blob(i%, j%).x = 120
        blob(i%, j%).y = 60
        blob(i%, j%).angle = INT(RND * 359)
        blob(i%, j%).xv = -10 + INT(RND * 20)
        blob(i%, j%).newtarget = INT(RND * 29)       'radius
    NEXT i%
NEXT j%

FOR x% = -32 TO 31
FOR y% = -32 TO 31
    Light%(x% + 32, y% + 32) = 0
NEXT y%
NEXT x%

FOR x% = -15 TO 15
FOR y% = -15 TO 15
        IF x% = 0 AND y% = 0 THEN
            C% = 255
        ELSE
            C% = ((8 / SQR((x% * x%) + (y% * y%))) * Intensity%) - (SQR((x% * x%) + (y% * y%)) * 2)
        END IF
    IF C% < 0 THEN C% = 0
    IF C% > 255 THEN C% = 255
    Light%(x% + 15, y% + 15) = C%
NEXT y%
NEXT x%

Grad 64, 63, 0, 0, 127, 63, 32, 0
Grad 128, 63, 32, 0, 255, 25, 0, 32
j! = 255 / 360 * 1
K! = 255 / 360 * 7
l! = 255 / 360 * 1
FOR i% = 0 TO 100
    OUT &H3C8, i%
    m% = INT(A!)
    n% = INT(b!)
    o% = INT(C!)
    r% = 63 * ABS(SIN(m% * PI / 180))
    IF r% > 63 THEN r% = 63
    G% = 32 * ABS(SIN(n% * PI / 180))
    IF G% > 63 THEN G% = 63
    b% = 32 * ABS(SIN(o% * PI / 180))
    IF b% > 63 THEN b% = 63
    A! = A! + j!
    b! = b! + K!
    C! = C! + l!
    OUT &H3C9, r%
    OUT &H3C9, G%
    OUT &H3C9, b%
NEXT

Rel.ReadPal RGBPal
Zeropal

F& = 0
Tim# = TIMER
DEF SEG = Layer1%
DO
    F& = (F& + 1) AND &H7FFFFFFF

    IF F& < 65 THEN
        Rel.FadeToPalStep 0, 255, RGBPal
    ELSEIF F& > MaxFrame% - 65 THEN
        Rel.FadeStep 0, 255, EndR%, EndG%, EndB%
    END IF

    REDIM Vpage1%(0 TO 16130)
    Vpage1%(0) = 2048
    Vpage1%(1) = 126

    bx0% = 120
    by0% = 55
    FOR j% = 0 TO NumAmoeba
            GOSUB MoveAmoeba
        FOR i% = 0 TO Numblobs
            GOSUB DoAmoeba
        NEXT i%
    NEXT j%
    FOR j% = 0 TO NumAmoeba
        FOR i% = 0 TO Numblobs
            abx% = blob(i%, j%).x
            aby% = blob(i%, j%).y
            DrawBlob abx%, aby%
        NEXT i%
    NEXT j%

    IF Vsynch% THEN WAIT &H3DA, 8
    PUT (32, 37), Vpage1%(0), PSET
LOOP UNTIL INKEY$ <> "" OR F& > MaxFrame%


Fps% = F& / (TIMER - Tim#)
ERASE blob, Amoebas%
EXIT SUB

DoAmoeba:
    blob(i%, j%).angle = (blob(i%, j%).angle + blob(i%, j%).xv)
    IF blob(i%, j%).angle < 0 THEN
        blob(i%, j%).angle = 359
    ELSEIF blob(i%, j%).angle > 359 THEN
        blob(i%, j%).angle = 0
    END IF
    blob(i%, j%).x = Amoebas%(j%, 0) + Lcos!(blob(i%, j%).angle) * blob(i%, j%).newtarget
    blob(i%, j%).y = Amoebas%(j%, 1) + Lsin!(blob(i%, j%).angle) * blob(i%, j%).newtarget
RETURN

MoveAmoeba:
    T! = (F& + j% * i%) / 10
    ax% = INT(COS(T! * .4) + SIN(T! * .4) * 128)
    ay% = INT(SIN(T! + .2) * SIN(T! * .5) * 64)
    Amoebas%(j%, 0) = ax% + 128
    Amoebas%(j%, 1) = ay% + 64
RETURN

END SUB

SUB BirthDay (Fps%, Vsynch%, MaxFrame%)

CleanDisplay
FOR i% = -1024 TO 1024
   Lsin1%(i%) = SIN(i% * PI / (128)) * 28
   Lsin2%(i%) = SIN(i% * PI / (64)) * 28
   Lsin3%(i%) = SIN(i% * PI / (32)) * 32
NEXT i%

j! = 255 / 360 * 2
K! = 255 / 360 * 1
l! = 255 / 360 * 2
FOR i% = 0 TO 255
    OUT &H3C8, i%
    m% = INT(A!)
    n% = INT(b!)
    o% = INT(C!)
    r% = 63 * ABS(SIN(m% * PI / 180))
    G% = 63 * ABS(SIN(n% * PI / 180))
    b% = 63 * ABS(SIN(o% * PI / 180))
    A! = A! + j!
    b! = b! + K!
    C! = C! + l!
    OUT &H3C9, r%
    OUT &H3C9, G%
    OUT &H3C9, b%
NEXT

Rel.ReadPal RGBPal
Zeropal


F& = 0
T# = TIMER
DO
    F& = (F& + 1) AND &H7FFFFFFF
    IF F& < 65 THEN
        Rel.FadeToPalStep 0, 255, RGBPal
    END IF
    Rel.PrintDisco Layer1%, Offs1%, 20, 5, "Rosmelly Lope", 81, 2, 3, Ly%(), Lsin1%(), Lsin2%(), Lsin3%()
    Rel.PrintDisco Layer1%, Offs1%, 20, 45, "HAPPY", 81, 5, 2, Ly%(), Lsin1%(), Lsin2%(), Lsin3%()
    Rel.PrintDisco Layer1%, Offs1%, 10, 75, "BirthDay!!", 81, 3, 2, Ly%(), Lsin1%(), Lsin2%(), Lsin3%()
    Rel.PrintDisco Layer1%, Offs1%, 40, 100, "08/13/2003", 81, 2, 3, Ly%(), Lsin1%(), Lsin2%(), Lsin3%()
    IF Vsynch% THEN WAIT &H3DA, 8
    PUT (32, 37), Vpage1%, PSET
LOOP UNTIL INKEY$ <> "" OR F& > MaxFrame%

DEF SEG = Layer1%
offset% = 0
FOR y = 0 TO 125
FOR x = 0 TO 255
    POKE Offs1% + offset%, 1 + (INT(RND * 255))
    offset% = offset% + 1
NEXT x
NEXT y

PUT (32, 37), Vpage1%, PSET
ystart% = 0
xstart% = 0
tx# = TIMER
DO
    F& = (F& + 1) AND &H7FFFFFFF
    FOR i% = 1 TO 255
       OUT &H3C8, i%
       j% = INT(RND * 64)
       OUT &H3C9, j%
       OUT &H3C9, j%
       OUT &H3C9, j%
    NEXT i%
    IF TIMER - tx# > 4 THEN
        Rel.BoxF Layer1%, Offs1%, 0, 0, xstart%, ystart%, 0, Ly%()
        Rel.BoxF Layer1%, Offs1%, 255, 0, 255 - xstart%, ystart%, 0, Ly%()
        Rel.BoxF Layer1%, Offs1%, 255, 125, 255 - xstart%, 125 - ystart%, 0, Ly%()
        Rel.BoxF Layer1%, Offs1%, 0, 125, xstart%, 125 - ystart%, 0, Ly%()
        PUT (32, 37), Vpage1%, PSET
        IF ystart% < 63 THEN
            ystart% = ystart% + 1
        END IF
        xstart% = xstart% + 2
    END IF
    WAIT &H3DA, 8
LOOP UNTIL INKEY$ <> "" OR xstart% >= 127



Fps% = F& / (TIMER - T#)
END SUB

SUB Blobs (Fps%, Vsynch%, MaxFrame%, Intensity%)
CleanDisplay
Numblobs = 100
DIM blob(Numblobs) AS PartType
FOR i% = 0 TO UBOUND(blob)
        blob(i%).x = 120
        blob(i%).y = 60
        blob(i%).angle = 0
NEXT i%


'Blobs
Grad 64, 63, 0, 0, 127, 63, 32, 0
Grad 128, 63, 32, 0, 255, 0, 63, 32
j! = 255 / 360 * 6
K! = 255 / 360 * 4
l! = 255 / 360 * 6
FOR i% = 0 TO 100
    OUT &H3C8, i%
    m% = INT(A!)
    n% = INT(b!)
    o% = INT(C!)
    r% = 63 * ABS(SIN(m% * PI / 180))
    IF r% > 63 THEN r% = 63
    G% = 32 * ABS(SIN(n% * PI / 180))
    IF G% > 63 THEN G% = 63
    b% = 32 * ABS(SIN(o% * PI / 180))
    IF b% > 63 THEN b% = 63
    A! = A! + j!
    b! = b! + K!
    C! = C! + l!
    OUT &H3C9, r%
    OUT &H3C9, G%
    OUT &H3C9, b%
NEXT
Rel.ReadPal RGBPal
'Light Show
Grad 0, 0, 0, 0, 2, 0, 0, 0
Grad 2, 15, 0, 0, 63, 63, 0, 0
Grad 64, 63, 0, 0, 127, 63, 63, 0
Grad 128, 63, 63, 0, 255, 63, 63, 32

FOR x% = -32 TO 31
FOR y% = -32 TO 31
    Light%(x% + 32, y% + 32) = 0
NEXT y%
NEXT x%


FOR x% = -15 TO 15
FOR y% = -15 TO 15
        IF x% = 0 AND y% = 0 THEN
            C% = 255
        ELSE
            C% = ((8 / SQR((x% * x%) + (y% * y%))) * Intensity%) - (SQR((x% * x%) + (y% * y%)) * 2)
        END IF
    IF C% < 0 THEN C% = 0
    IF C% > 255 THEN C% = 255
    Light%(x% + 15, y% + 15) = C%
NEXT y%
NEXT x%

F& = 0
Tim# = TIMER
DEF SEG = Layer1%
DO
    F& = (F& + 1) AND &H7FFFFFFF
    IF F& > (MaxFrame% \ 2) AND F& < (MaxFrame% \ 2) + 65 THEN
        Rel.FadeToPalStep 0, 255, RGBPal
    ELSEIF F& > MaxFrame% - 65 THEN
        Rel.FadeStep 0, 255, EndR%, EndG%, EndB%
    END IF

    REDIM Vpage1%(0 TO 16130)
    Vpage1%(0) = 2048
    Vpage1%(1) = 126

    FOR i% = 0 TO UBOUND(blob)
        GOSUB DoBlobs
    NEXT i%

    FOR i% = 0 TO UBOUND(blob)
        bx% = blob(i%).x
        by% = blob(i%).y
        DrawBlob bx%, by%
    NEXT i%
    IF Vsynch% THEN WAIT &H3DA, 8
    PUT (32, 37), Vpage1%(0), PSET
LOOP UNTIL INKEY$ <> "" OR F& > MaxFrame%


Fps% = F& / (TIMER - Tim#)
ERASE blob
EXIT SUB

DoBlobs:

    IF blob(i%).newtarget THEN
            blob(i%).tx = 20 + INT(RND * 200)
            blob(i%).ty = 20 + INT(RND * 100)
            blob(i%).newtarget = FALSE
    END IF

    'move the blobs
    blob(i%).xv = (Lcos!(blob(i%).angle)) * 3
    blob(i%).yv = (Lsin!(blob(i%).angle)) * 3

    blob(i%).x = blob(i%).x + blob(i%).xv
    blob(i%).y = blob(i%).y + blob(i%).yv

    IF ABS(blob(i%).tx - blob(i%).x) AND ABS(blob(i%).ty - blob(i%).y) < 5 THEN
            blob(i%).newtarget = TRUE
    END IF

    'Check if Result>0 then Dec else Inc
    'the actual angle is not important
    Dot = ((blob(i%).yv * (blob(i%).tx - blob(i%).x)) - (blob(i%).xv * (blob(i%).ty - blob(i%).y)))
    IF Dot > 0 THEN
            blob(i%).angle = (blob(i%).angle - 3)
            IF blob(i%).angle < 0 THEN blob(i%).angle = blob(i%).angle + 360
    ELSE
            blob(i%).angle = (blob(i%).angle + 3) MOD 360
    END IF

RETURN

END SUB

SUB CleanDisplay
    REDIM Vpage1%(0 TO 16130)
    Vpage1%(0) = 2048
    Vpage1%(1) = 126
    REDIM Vpage2%(0 TO 16130)
    Vpage2%(0) = 2048
    Vpage2%(1) = 126
    PUT (32, 37), Vpage1%(0), PSET
    FOR i% = 0 TO 255
        OUT &H3C8, i%
        OUT &H3C9, 0
        OUT &H3C9, 0
        OUT &H3C9, 0
    NEXT i%
END SUB

SUB DoBump (Fps%, Vsynch%, MaxFrame%)
DIM car%(4, 3)              'angle,rad

FOR i% = 0 TO 255 * 5
    div16%(i%) = i% \ 16
    div8%(i%) = i% \ 8
    div4%(i%) = i% \ 4
NEXT i%

Radius! = SQR(32 * 32)
FOR y% = -32 TO 31
    FOR x% = -32 TO 31
        dist! = (x% * x% + y% * y%)
        IF ABS(dist!) > 1 THEN dist! = SQR(dist!)
            C% = INT(7 * dist! + (RND * 5))
            IF C% < 0 THEN
                C% = 0
            ELSEIF C% > 255 THEN
                C% = 255
            END IF
            Light%(32 + x%, 32 + y%) = 255 - C%
            IF dist! > Radius! THEN
                Light%(32 + x%, 32 + y%) = 0
            END IF
    NEXT x%
NEXT y%


FOR i% = 0 TO 4
    car%(i%, 0) = INT(RND * 128 + 25)
    car%(i%, 1) = INT(RND * 64 + 25)
    car%(i%, 2) = INT(RND * 128 + 25)
    car%(i%, 3) = INT(RND * 64 + 25)
NEXT i%


FOR i% = 0 TO 255
    OUT &H3C8, i%
    OUT &H3C9, i% \ 4
    OUT &H3C9, i% \ 6
    OUT &H3C9, i% \ 12
NEXT i%

Rel.ReadPal RGBPal
Zeropal

DEF SEG = Layer2%
offset% = 256
FOR y = 0 TO 123
FOR x = 0 TO 255
    POKE offs2% + offset%, SIN(y XOR x) * 127 + COS(y XOR x) * 127
    offset% = offset% + 1
NEXT x
NEXT y

Rel.PrintScale Layer2%, offs2%, 40, 4, "Relsoft", 240, 3, 5, Ly%()
Rel.PrintScale Layer2%, offs2%, 90, 45, "and", 240, 3, 4, Ly%()
Rel.PrintScale Layer2%, offs2%, 27, 78, "Anyatech", 240, 3, 5, Ly%()
Smooth Layer2%, offs2%, Ly%(), div4%(), div8%(), div16%(), 5


T# = TIMER
DO
    F& = (F& + 1) AND &H7FFFFFFF

    IF F& < 65 THEN
        Rel.FadeToPalStep 0, 255, RGBPal
    ELSEIF F& > MaxFrame% - 65 THEN
        Rel.FadeStep 0, 255, EndR%, EndG%, EndB%
    END IF

    REDIM Vpage1%(0 TO 16130)
    Vpage1%(0) = 2048
    Vpage1%(1) = 126
    FOR i% = 0 TO 4
        ax% = SIN(F& / car%(i%, 0)) * car%(i%, 2) + 128
        ay% = COS(F& / car%(i%, 1)) * car%(i%, 3) + 64
        DrawLight ax%, ay%, 64
    NEXT i%
    IF Vsynch% THEN WAIT &H3DA, 8
    PUT (32, 37), Vpage1%, PSET
LOOP UNTIL INKEY$ <> "" OR F& > MaxFrame%

Fps% = F& / (TIMER - T#)

ERASE car%

END SUB

SUB DoLensPlasma (Fps%, Vsynch%, MaxFrame%)

CleanDisplay
xmin% = 0
ymin% = 0
xmax% = 256
ymax% = 126
xmid% = xmax% \ 2
ymid% = ymax% \ 2

starspeed! = .3
magrot% = 2
maxcounter% = 200
mag% = magrot%

MaxStars% = 128
DIM stars%(1 TO MaxStars%, 5)
DIM starsspd!(1 TO MaxStars%)
     
FOR i = 1 TO MaxStars%
    starangle% = INT(RND * 360)
    starradius% = 20 + INT(RND * 180)
    starx% = xmid% + (Lcos!(starangle%) * starradius%)
    stary% = ymid% + (Lsin!(starangle%) * starradius%)
    stars%(i, 0) = starx%
    stars%(i, 1) = stary%
    stars%(i, 3) = starradius%
    stars%(i, 4) = starangle%
    stars%(i, 5) = 16 + INT(RND * (255 - 16))
    starsspd!(i) = .5
NEXT i



FOR i% = -1024 TO 1024
   Lsin1%(i%) = SIN(i% * PI / (128)) * 256
   Lsin2%(i%) = SIN(i% * PI / (64)) * 128
   Lsin3%(i%) = SIN(i% * PI / (32)) * 64
NEXT i%

j! = 255 / 360 * 3
K! = 255 / 360 * 4
l! = 255 / 360 * 4
FOR i% = 0 TO 255
    OUT &H3C8, i%
    m% = INT(A!)
    n% = INT(b!)
    o% = INT(C!)
    r% = 63 * ABS(SIN(m% * PI / 180))
    IF r% > 63 THEN r% = 63
    G% = 63 * ABS(SIN(n% * PI / 180))
    IF i < 128 THEN G% = 0
    b% = 32 * ABS(SIN(o% * PI / 180))
    A! = A! + j!
    b! = b! + K!
    C! = C! + l!
    OUT &H3C9, r%
    OUT &H3C9, G%
    OUT &H3C9, b%
NEXT

Rel.ReadPal RGBPal
Zeropal
cd% = 1
Lensrad% = 20
raddir% = 1
countdir% = 1

DEF SEG = Layer1%
T# = TIMER
DO
    F& = (F& + 1) AND &H7FFFFFFF

    IF F& < 65 THEN
        Rel.FadeToPalStep 0, 255, RGBPal
    ELSEIF F& > MaxFrame% - 65 THEN
        Rel.FadeStep 0, 255, EndR%, EndG%, EndB%
    END IF

    REDIM Vpage1%(0 TO 16130)

    Vpage1%(0) = 2048
    Vpage1%(1) = 126

    starcounter% = (starcounter% MOD maxcounter%) + 1
    IF starcounter% = 1 THEN
            IF SGN(oldmag%) = 1 THEN
                    mag% = -magrot%
            ELSE
                    mag% = magrot%
            END IF
    ELSEIF starcounter% = maxcounter% \ 2 THEN
            oldmag% = mag%
            mag% = 0
    END IF

    FOR i = 1 TO MaxStars%
            stars%(i, 4) = stars%(i, 4) + mag%
            IF SGN(mag%) = 1 THEN
                    IF stars%(i, 4) > 359 THEN stars%(i, 4) = 0
            ELSE
                    IF stars%(i, 4) < 0 THEN stars%(i, 4) = 359
            END IF
            starsspd!(i) = starsspd!(i) + starspeed!
            stars%(i, 3) = stars%(i, 3) + starsspd!(i)
            stars%(i, 0) = xmid% + (Lcos!(stars%(i, 4)) * stars%(i, 3))
            stars%(i, 1) = ymid% + (Lsin!(stars%(i, 4)) * stars%(i, 3))
            IF stars%(i, 0) > xmax% - 4 OR stars%(i, 0) < xmin% + 4 OR stars%(i, 1) > ymax% - 4 OR stars%(i, 1) < ymin% + 4 THEN
                starangle% = INT(RND * 360)
                starradius% = 20 + INT(RND * 30)
                starx% = xmid% + (Lcos!(starangle%) * starradius%)
                stary% = ymid% + (Lsin!(starangle%) * starradius%)
                stars%(i, 0) = starx%
                stars%(i, 1) = stary%
                stars%(i, 3) = starradius%
                stars%(i, 4) = starangle%
                starsspd!(i) = .5
            END IF
            sx% = stars%(i, 0)
            sy% = stars%(i, 1)
            sc% = stars%(i, 5)
            IF sx% > 0 AND sx% < 256 AND sy% > 0 AND sy% < 126 THEN
                POKE Offs1% + Ly%(sy%) + sx%, sc%
            END IF
    NEXT i


    T! = (F&) * 3.141593 / 180
    Lensx% = INT(COS(T! * 6) + SIN(T!) * 130)
    Lensy% = INT(SIN(T! + 2) * SIN(T! * 2) * 50)
    Lensx% = Lensx% + 94
    Lensy% = Lensy% + 8
    Lensrad% = Lensrad% + raddir%
    IF Lensrad% < 20 THEN
        raddir% = -raddir%
    ELSEIF Lensrad% > 63 THEN
        raddir% = -raddir%
    END IF
    LensPlasmaRT Lensx%, Lensy%, Lensrad%, C%, cd%, TRUE
    LensPlasmaRT 256 - Lensx% - (Lensrad% * 2), 126 - Lensy% - (Lensrad% * 2), 20 + 63 - Lensrad%, C%, cd%, FALSE
    PUT (32, 37), Vpage1%(0), PSET
LOOP UNTIL INKEY$ <> "" OR F& > MaxFrame%
Fps% = F& / (TIMER - T#)
ERASE starsspd!, stars%
END SUB

SUB DoLensTrans (Fps%, Vsynch%, MaxFrame%)
CleanDisplay
File$ = Path$ + "Anya128C.Bmp"
Rel.LoadBMP TextSeg%, TextOff%, File$, FALSE, 128
cd% = 1
Lensrad% = 20
raddir% = 1
countdir% = 1

Freq! = 16
Ys = -1
FOR A = 0 TO 1024
    Ys = (Ys + 1) MOD 360           'Move Downwards
    Yss! = Ys * 3.141593 / 180      'Convert to rad
    Lsin1%(A) = SIN(Yss! + A / Freq!) * 128
NEXT A


DEF SEG = Layer1%

T# = TIMER
DO
    F& = (F& + 1) AND &H7FFFFFFF
    IF F& < 65 THEN
        Rel.FadeToPalStep 0, 255, GradPal
    ELSEIF F& > MaxFrame% - 65 THEN
        Rel.FadeStep 0, 255, EndR%, EndG%, EndB%
    END IF
    offset% = Offs1%
    xs% = (xs% + 1) AND 255
    Ys% = (Ys% + 1) AND 255
    FOR ya% = 0 TO 125
    FOR xa% = 0 TO 255
        xxs% = (xa% + xs%) AND 255
        yys% = (ya% + Ys%) AND 255
        C% = 128 + Lsin!(yys% XOR xxs%) * 128
        POKE offset%, C%
        offset% = offset% + 1
    NEXT xa%
    NEXT ya%


    T! = (F&) * 3.141593 / 180
    Lensx% = INT(COS(T! * 6) + SIN(T!) * 130)
    Lensy% = INT(SIN(T! + 2) * SIN(T! * 2) * 50)
    Lensx% = Lensx% + 94
    Lensy% = Lensy% + 8
    Lensrad% = Lensrad% + raddir%
    IF Lensrad% < 20 THEN
        raddir% = -raddir%
    ELSEIF Lensrad% > 63 THEN
        raddir% = -raddir%
    END IF
    LensTexture Lensx%, Lensy%, Lensrad%, 128, FALSE
    LensTexture 256 - Lensx% - (Lensrad% * 2), 126 - Lensy% - (Lensrad% * 2), 20 + 63 - Lensrad%, 128, TRUE

    IF F& > MaxFrame% - 105 THEN
        offset1% = Offs1%
        offset2% = offs2%
        xs% = (xs% + 1) AND 1023
        xmag% = xmag% + 1
        FOR y% = 0 TO 125
            xsin% = Lsin1%((xs% + y%) AND 1023) * xmag% \ 128
            DEF SEG = Layer1%
            FOR x% = 0 TO 255
                xx% = (xsin% + x%) AND 255
                scanline%(x%) = PEEK(offset1% + xx%)
            NEXT x%
                DEF SEG = Layer2%
            FOR x% = 0 TO 255
                POKE offset2%, scanline%(x%)
                offset2% = offset2% + 1
            NEXT x%
                offset1% = offset1% + 256
        NEXT y
    END IF
    IF Vsynch% THEN WAIT &H3DA, 8
    IF F& > MaxFrame% - 105 THEN
        PUT (32, 37), Vpage2%(0), PSET
    ELSE
        PUT (32, 37), Vpage1%(0), PSET
    END IF

LOOP UNTIL INKEY$ <> "" OR F& > MaxFrame%
Fps% = F& / (TIMER - T#)

END SUB

SUB DoRotoMono (Fps%, Vsynch%, MaxFrame%)
CleanDisplay

File$ = Path$ + "Anya128.Bmp"
Rel.LoadBMP TextSeg%, TextOff%, File$, FALSE, 128
GreyPal RGBPal
Zeropal
scale% = 100
scaledir% = -1
angle% = 10
DEF SEG = Layer1%
T# = TIMER
DO
    F& = (F& + 1) AND &H7FFFFFFF
    IF F& < 65 THEN
        Rel.FadeToPalStep 0, 255, RGBPal
    ELSEIF F& > MaxFrame% - 65 THEN
        Rel.FadeStep 0, 255, EndR%, EndG%, EndB%
    END IF

    scale% = scale% + scaledir%
    IF scale% < 10 THEN
        scaledir% = -scaledir%
    ELSEIF scale% > 200 THEN
        scaledir% = -scaledir%
    END IF
    angle% = (angle% + 1) MOD 360
    RotoZoom FALSE, angle%, scale%
    PUT (32, 37), Vpage1%(0), PSET
LOOP UNTIL INKEY$ <> "" OR F& > MaxFrame%

Fps% = F& / (TIMER - T#)

END SUB

SUB DoRotoTrans (Fps%, Vsynch%, MaxFrame%)
CleanDisplay
File$ = Path$ + "Anya128c.Bmp"
Rel.LoadBMP TextSeg%, TextOff%, File$, FALSE, 128

scale% = 100
scaledir% = -1
angle% = 10
angle2% = 320
DEF SEG = Layer1%
T# = TIMER
DO
    F& = (F& + 1) AND &H7FFFFFFF
    IF F& < 65 THEN
        Rel.FadeToPalStep 0, 255, GradPal
    ELSEIF F& > MaxFrame% - 65 THEN
        Rel.FadeStep 0, 255, EndR%, EndG%, EndB%
    END IF

    scale% = scale% + scaledir%
    IF scale% < 10 THEN
        scaledir% = -scaledir%
    ELSEIF scale% > 200 THEN
        scaledir% = -scaledir%
    END IF
    angle% = (angle% + 1) MOD 360
    angle2% = (angle2% - 1)
    IF angle2% < 0 THEN angle2% = 359 ' 360 - angle2%
    scale2% = 212 - scale%
    RotoZoom FALSE, angle%, scale%
    RotoZoom TRUE, angle2%, scale2%
    PUT (32, 37), Vpage1%(0), PSET
LOOP UNTIL INKEY$ <> "" OR F& > MaxFrame%

Fps% = F& / (TIMER - T#)

END SUB

SUB DoTitle (Fps%, Vsynch%, MaxFrame%)
CleanDisplay
Rel.LoadPalPp256 Path$ + "Fj.pal"
Tim! = TIMER
pdx% = 100
DO
    REDIM Vpage1%(0 TO 16130)
    Vpage1%(0) = 2048
    Vpage1%(1) = 126

    IF TIMER - Tim! > 4 THEN
        pdx% = pdx - 1
    END IF
    A% = (A% + 1) MOD 359
    G% = ABS(SIN(A% * PI / 180) * 9) + 1
    Rel.Font256 Layer1%, Offs1%, pdx% + 0, 50, "Present...", FALSE, Font(), FontIndex(), G%, Ly%()
    WAIT &H3DA, 8
PUT (32, 37), Vpage1%, PSET
LOOP UNTIL pdx% < -70 OR INKEY$ <> ""


FOR i% = 0 TO 256 * 5
    div4%(i%) = i% \ 4
    div8%(i%) = i% \ 8
    div16%(i%) = i% \ 16
NEXT i%


FOR i% = -1024 TO 1024
   Lsin1%(i%) = SIN(i% * PI / (128)) * 256
   Lsin2%(i%) = SIN(i% * PI / (64)) * 128
   Lsin3%(i%) = SIN(i% * PI / (32)) * 32
NEXT i%

j! = 255 / 360 * 2
K! = 255 / 360 * 1
l! = 255 / 360 * 2
FOR i% = 0 TO 255
    OUT &H3C8, i%
    m% = INT(A!)
    n% = INT(b!)
    o% = INT(C!)
    r% = 63 * ABS(SIN(m% * PI / 180))
    G% = 63 * ABS(SIN(n% * PI / 180))
    b% = 32 * ABS(SIN(o% * PI / 180))
    A! = A! + j!
    b! = b! + K!
    C! = C! + l!
    OUT &H3C9, r%
    OUT &H3C9, G%
    OUT &H3C9, b%
NEXT


F& = 0
passes% = 35
DX% = -256
xscale% = 6
yscale% = 7
T# = TIMER
DO
    F& = (F& + 1) AND &H7FFFFFFF
    IF F& > MaxFrame% - 65 THEN
        Rel.FadeStep 0, 255, EndR%, EndG%, EndB%
    END IF

    REDIM Vpage1%(0 TO 16130)
    Vpage1%(0) = 2048
    Vpage1%(1) = 126
    Rel.PrintDisco Layer1%, Offs1%, DX%, 70, "Disco", 81, xscale%, yscale%, Ly%(), Lsin1%(), Lsin2%(), Lsin3%()
    IF passes% = 0 THEN Rel.PrintDisco Layer1%, Offs1%, 115, 50, "&", 81, 4, 2, Ly%(), Lsin1%(), Lsin2%(), Lsin3%()
    Rel.PrintScale Layer1%, Offs1%, 20, 5, "Mono", 85, xscale% + 1, yscale% - 3, Ly%()
    Rel.PrintScale Layer1%, Offs1%, 118, 54, "&", 85, 4, 2, Ly%()

    'Inverse blur
    FOR j% = 1 TO passes%
        offs% = 256 + Offs1%
        FOR i% = 256 TO 10240
            corners% = div16%(PEEK(offs% - 257) + PEEK(offs% - 255) + PEEK(offs% + 257) + PEEK(offs% + 255))
            sides% = div8%(PEEK(offs% - 256) + PEEK(offs% - 1) + PEEK(offs% + 256) + PEEK(offs% + 1))
            center% = div4%(PEEK(offs%))
            px1% = (corners% + sides% + center%)
            POKE offs%, px1%
            offs% = offs% + 1
        NEXT i%
    NEXT j%
    IF passes% > 0 THEN passes% = passes% - 1
    IF passes% = 0 THEN
        IF DX% < 10 THEN DX% = DX% + 1
    END IF
    IF Vsynch% THEN WAIT &H3DA, 8
    PUT (32, 37), Vpage1%, PSET
LOOP UNTIL INKEY$ <> "" OR F& > MaxFrame%

Fps% = F& / (TIMER - T#)
END SUB

SUB DrawBlob (bx%, by%)


x% = bx% - 16
y% = by% - 16

xsize% = 32
ysize% = 32

newx% = x%                        'get coords
newy% = y%

minx% = 0
miny% = 0

'Clip/Crop it
IF newy% < 0 THEN
        cy = -newy%
        ysize% = ysize% - cy
        newy% = 0
        miny% = cy
ELSEIF newy% > 125 THEN
        EXIT SUB
ELSE
        ndy = newy% + ysize%
        IF ndy > 125 THEN
                ysize% = ysize% - (ndy - (126))
        END IF
END IF

IF newx% < 0 THEN
        cx = -newx%
        xsize% = xsize% - cx
        newx% = 0
        minx% = cx
ELSEIF newx% > 255 THEN
        EXIT SUB
ELSE
        ndx = newx% + xsize%
        IF ndx > 255 THEN
                xsize% = xsize% - (ndx - 256)
        END IF
END IF


offset% = Offs1% + Ly%(newy%) + newx%

FOR y% = 0 TO ysize% - 1
FOR x% = 0 TO xsize% - 1
    C% = Light%(x% + minx%, y% + miny%)
    IF C% THEN
        oc% = PEEK(offset% + x%)
        occ% = C% + oc%
        IF occ% > 255 THEN
            occ% = 255
        END IF
        POKE offset% + x%, occ%
    END IF
NEXT x
    offset% = offset% + 256
NEXT y

END SUB

SUB DrawLight (bx%, by%, size%)

'Bumpy!!
hs% = size% \ 2
sizem1% = size% - 1
x% = bx% - hs%
y% = by% - hs%

xsize% = size%
ysize% = size%

newx% = x%                        'get coords
newy% = y%

minx% = 0
miny% = 0

'Clip/Crop it
IF newy% < 0 THEN
        cy = -newy%
        ysize% = ysize% - cy
        newy% = 0
        miny% = cy
ELSEIF newy% > 125 THEN
        EXIT SUB
ELSE
        ndy = newy% + ysize%
        IF ndy > 125 THEN
                ysize% = ysize% - (ndy - (126))
        END IF
END IF

IF newx% < 0 THEN
        cx = -newx%
        xsize% = xsize% - cx
        newx% = 0
        minx% = cx
ELSEIF newx% > 255 THEN
        EXIT SUB
ELSE
        ndx = newx% + xsize%
        IF ndx > 255 THEN
                xsize% = xsize% - (ndx - 256)
        END IF
END IF


offset% = Offs1% + Ly%(newy%) + newx%
offset2% = offs2% + Ly%(newy%) + newx%

FOR y% = 0 TO ysize% - 1
FOR x% = 0 TO xsize% - 1
    pix% = Light%(x% + minx%, y% + miny%)
    IF pix% THEN
        DEF SEG = Layer2%
        of% = offset2% + x%
        xoff% = (PEEK(of% - 1) - PEEK(of% + 1))
        yoff% = (PEEK(of% - 256) - PEEK(of% + 256))
        Lx% = (x% + yoff%) AND sizem1%
        Ly% = (y% + xoff%) AND sizem1%
        C% = Light%(Lx%, Ly%)
        DEF SEG = Layer1%
        C% = PEEK(offset% + x%) + C%
        IF C% > 255 THEN C% = 255
        POKE offset% + x%, C%
    END IF
NEXT x
    offset% = offset% + 256
    offset2% = offset2% + 256
NEXT y


END SUB

SUB DrawPlgG (Model() AS Point3d, Poly() AS PolyType) STATIC

FOR j = 1 TO UBOUND(Poly)
    i = Poly(j).idx
    X1 = Model(Poly(i).p1).ScrX       'Get triangles from "projected"
    X2 = Model(Poly(i).p2).ScrX       'X and Y coords since Znormal
    x3 = Model(Poly(i).p3).ScrX       'Does not require a Z coord
    Y1 = Model(Poly(i).p1).ScrY       'V1= Point1 connected to V2 then
    Y2 = Model(Poly(i).p2).ScrY       'V2 to V3 and so on...
    y3 = Model(Poly(i).p3).ScrY


    znormal = (X2 - X1) * (Y1 - y3) - (Y2 - Y1) * (X1 - x3)
    IF znormal < 0 THEN
        nx1! = PlgVertexNormal2(Poly(i).p1).x
        ny1! = PlgVertexNormal2(Poly(i).p1).y
        nz1! = PlgVertexNormal2(Poly(i).p1).z
        nx2! = PlgVertexNormal2(Poly(i).p2).x
        ny2! = PlgVertexNormal2(Poly(i).p2).y
        nz2! = PlgVertexNormal2(Poly(i).p2).z
        nx3! = PlgVertexNormal2(Poly(i).p3).x
        ny3! = PlgVertexNormal2(Poly(i).p3).y
        nz3! = PlgVertexNormal2(Poly(i).p3).z
        Lx! = LightNormal.x
        Ly! = LightNormal.y
        lz! = LightNormal.z
        Dot1! = (nx1! * Lx!) + (ny1! * Ly!) + (nz1! * lz!)
        IF Dot1! < 0 THEN
            Dot1! = 0
        ELSEIF Dot1! > 1 THEN
            Dot1! = 1
        END IF
        Dot2! = (nx2! * Lx!) + (ny2! * Ly!) + (nz2! * lz!)
        IF Dot2! < 0 THEN
            Dot2! = 0
        ELSEIF Dot2! > 1 THEN
            Dot2! = 1
        END IF
        Dot3! = (nx3! * Lx!) + (ny3! * Ly!) + (nz3! * lz!)
        IF Dot3! < 0 THEN
            Dot3! = 0
        ELSEIF Dot3! > 1 THEN
            Dot3! = 1
        END IF
            clr1 = (Dot1! * 255)
            clr2 = (Dot2! * 255)
            clr3 = (Dot3! * 255)
            TriGouraud X1, Y1, clr1, X2, Y2, clr2, x3, y3, clr3
    END IF
NEXT j

END SUB

SUB DrawPlgGradGT (Model() AS Point3d, Poly() AS PolyType) STATIC
'Glenzed gouraud shader
FOR j = 1 TO UBOUND(Poly)
    i = Poly(j).idx
    X1 = Model(Poly(i).p1).ScrX      'Get triangles from "projected"
    X2 = Model(Poly(i).p2).ScrX       'X and Y coords since Znormal
    x3 = Model(Poly(i).p3).ScrX       'Does not require a Z coord
    Y1 = Model(Poly(i).p1).ScrY       'V1= Point1 connected to V2 then
    Y2 = Model(Poly(i).p2).ScrY       'V2 to V3 and so on...
    y3 = Model(Poly(i).p3).ScrY


    'Use the Znormal,the Ray perpendicular(Orthogonal) to the XY plane
    'Defined by the Triangle (X1,Y1,X2,Y2,X3,Y3)
    'if Less(<) 0 then its facing in the opposite direction so
    'don't plot. If =>0 then its facing towards you so Plot.
    znormal = (X2 - X1) * (Y1 - y3) - (Y2 - Y1) * (X1 - x3)
    IF znormal < 0 THEN
        nx1! = PlgVertexNormal2(Poly(i).p1).x
        ny1! = PlgVertexNormal2(Poly(i).p1).y
        nz1! = PlgVertexNormal2(Poly(i).p1).z
        nx2! = PlgVertexNormal2(Poly(i).p2).x
        ny2! = PlgVertexNormal2(Poly(i).p2).y
        nz2! = PlgVertexNormal2(Poly(i).p2).z
        nx3! = PlgVertexNormal2(Poly(i).p3).x
        ny3! = PlgVertexNormal2(Poly(i).p3).y
        nz3! = PlgVertexNormal2(Poly(i).p3).z
        Lx! = LightNormal.x
        Ly! = LightNormal.y
        lz! = LightNormal.z
        Dot1! = (nx1! * Lx!) + (ny1! * Ly!) + (nz1! * lz!)
        IF Dot1! < 0 THEN
            Dot1! = 0
        ELSEIF Dot1! > 1 THEN
            Dot1! = 1
        END IF
        Dot2! = (nx2! * Lx!) + (ny2! * Ly!) + (nz2! * lz!)
        IF Dot2! < 0 THEN
            Dot2! = 0
        ELSEIF Dot2! > 1 THEN
            Dot2! = 1
        END IF
        Dot3! = (nx3! * Lx!) + (ny3! * Ly!) + (nz3! * lz!)
        IF Dot3! < 0 THEN
            Dot3! = 0
        ELSEIF Dot3! > 1 THEN
            Dot3! = 1
        END IF
            clr1 = (Dot1! * 15)
            clr1 = clr1 + Poly(i).clr1
            clr2 = (Dot2! * 15)
            clr2 = clr2 + Poly(i).clr2
            clr3 = (Dot3! * 15)
            clr3 = clr3 + Poly(i).clr3
            TriGouraudT X1, Y1, clr1, X2, Y2, clr2, x3, y3, clr3
    END IF
NEXT j

END SUB

SUB Feedback (Fps%, Vsynch%, MaxFrame%)
CleanDisplay
'uses Lsin1%,Lsin2%,Lsin3%
'uses div16%,div8%,div4%

DIM Text%(7, 7, 3)
DIM comets%(4, 1)           'x,y
DIM car%(4, 4)              'angle,rad

MaxStars = 128
DIM starsx%(MaxStars), starsy%(MaxStars)

FOR i% = 0 TO 256 * 5
    div4%(i%) = i% \ 4
    div8%(i%) = i% \ 8
    div16%(i%) = i% \ 16
NEXT i%
FOR i% = 0 TO 255
    j% = i% - 5
    IF j% < 0 THEN j% = 0
    Lsin3%(i%) = j%
NEXT i%


FOR i% = -10 TO 370
    ax! = i% * 3.141593 / 180
    Lsin!(i%) = SIN(ax!)
    Lcos!(i%) = COS(ax!)
NEXT i%


FOR i% = 0 TO 125
    Ly%(i%) = i% * 256
NEXT i%
xx! = 0
FOR x% = 0 TO 255
    xscale! = (84 / 100)
    Lsin1%(x%) = Offs1% + INT((128 + ((x% - 128) * xscale!)))
NEXT x%
yy! = 0
FOR y% = 0 TO 126
    yscale! = (83 / 100)
    Lsin2%(y%) = 256 * INT((63 + ((y% - 63) * yscale!)))
NEXT y%


FOR s% = 0 TO MaxStars
  starsx%(s%) = RND * 32256 - (32256 \ 2)
  starsy%(s%) = RND * 32256 - (32256 \ 2)
NEXT s%
FOR i% = 0 TO 4
    car%(i%, 0) = INT(RND * 15 + 5)
    car%(i%, 1) = INT(RND * 15 + 5)
    car%(i%, 2) = INT(RND * 20 + 20)
    car%(i%, 3) = INT(RND * 15 + 10)
    car%(i%, 4) = INT(RND * 15 + 30)
NEXT i%

FOR i% = 0 TO 255
    OUT &H3C8, i%
    OUT &H3C9, i% \ 4
    OUT &H3C9, i% \ 7
    OUT &H3C9, 0
NEXT i%

Rel.ReadPal RGBPal
Zeropal
FOR i% = 0 TO 3
    SELECT CASE i%
        CASE 0
            Char$ = "*"
            GOSUB FeedbackGetFont
        CASE 1
            Char$ = ""
            GOSUB FeedbackGetFont
        CASE 2
            Char$ = ""
            GOSUB FeedbackGetFont
        CASE ELSE
            Char$ = ""
            GOSUB FeedbackGetFont
    END SELECT
NEXT i%



Xrad% = 6
Yrad% = 5
Freq% = 6
FoldLeng! = 0
Fdir! = .3
rotdir% = 1
Acount% = 358
T# = TIMER
DO
    F& = (F& + 1) AND &H7FFFFFFF
    IF F& < 65 THEN
        Rel.FadeToPalStep 0, 255, RGBPal
    END IF

    REDIM Vpage2%(0 TO 16130)

    DEF SEG = Layer1%

    FOR i% = 0 TO 3
        comets%(i%, 0) = SIN(F& / car%(i%, 0)) * car%(i%, 2) + 120
        comets%(i%, 1) = COS(F& / car%(i%, 1)) * car%(i%, 3) + 40
        GOSUB FeedBackDrawSprite
    NEXT i%



    Acount% = Acount% + 1
    IF Acount% > 360 THEN Acount% = 360
    ang% = (ang% + rotdir%)
    IF ang% < 0 THEN
        rotdir% = -rotdir%
    ELSEIF ang% > 360 THEN
        rotdir% = -rotdir%
    END IF
    FoldLeng! = FoldLeng! + Fdir!
    IF FoldLeng! < -3 THEN
        Fdir! = -Fdir!
    ELSEIF FoldLeng! > 3 THEN
        Fdir! = -Fdir!
    END IF


    comets%(4, 0) = SIN(F& / car%(4, 0)) * car%(4, 2) + 120
    comets%(4, 1) = COS(F& / car%(4, 1)) * car%(4, 3) + 60

    tsx% = comets%(4, 0)
    tsy% = comets%(4, 1)

    FOR angle% = 0 TO Acount%
        A% = ((Freq% * angle%) MOD 360)
        b% = (angle% + ang%) MOD 360
        x% = (Xrad% + FoldLeng! * Lsin!((A%))) * Lsin!((b%)) + tsx%
        y% = (Yrad% + FoldLeng! * Lsin!((A%))) * Lcos!((b%)) + tsy%
        '1
        POKE Offs1% + Ly%(y%) + x%, 255
        POKE Offs1% + Ly%(y% + 1) + x%, 255
    NEXT angle%

    offs% = Offs1%
    FOR y% = 0 TO 125
         DEF SEG = Layer1%
         FOR x% = 0 TO 255
            scanline%(x%) = PEEK(Lsin2%(y%) + Lsin1%(x%))
         NEXT x%
            DEF SEG = Layer2%
         FOR x% = 0 TO 255
            POKE offs%, scanline%(x%)
            offs% = offs% + 1
         NEXT x%
    NEXT y%


    FOR i% = 3 TO 16130
        Vpage1%(i%) = Vpage2%(i%)
    NEXT i%


    DEF SEG = Layer1%
    offs% = 256 + Offs1%
    FOR i% = 256 TO 32256 - 256 STEP 4
        ''1
        corners% = div16%(PEEK(offs% - 257) + PEEK(offs% - 255) + PEEK(offs% + 257) + PEEK(offs% + 255))
        sides% = div8%(PEEK(offs% - 256) + PEEK(offs% - 1) + PEEK(offs% + 256) + PEEK(offs% + 1))
        center% = div4%(PEEK(offs%))
        px1% = Lsin3%(corners% + sides% + center%)
        POKE offs%, px1%
        offs% = offs% + 1
        ''2
        corners% = div16%(PEEK(offs% - 257) + PEEK(offs% - 255) + PEEK(offs% + 257) + PEEK(offs% + 255))
        sides% = div8%(PEEK(offs% - 256) + PEEK(offs% - 1) + PEEK(offs% + 256) + PEEK(offs% + 1))
        center% = div4%(PEEK(offs%))
        px1% = Lsin3%(corners% + sides% + center%)
        POKE offs%, px1%
        offs% = offs% + 1
        ''3
        corners% = div16%(PEEK(offs% - 257) + PEEK(offs% - 255) + PEEK(offs% + 257) + PEEK(offs% + 255))
        sides% = div8%(PEEK(offs% - 256) + PEEK(offs% - 1) + PEEK(offs% + 256) + PEEK(offs% + 1))
        center% = div4%(PEEK(offs%))
        px1% = Lsin3%(corners% + sides% + center%)
        POKE offs%, px1%
        offs% = offs% + 1
        ''4
        corners% = div16%(PEEK(offs% - 257) + PEEK(offs% - 255) + PEEK(offs% + 257) + PEEK(offs% + 255))
        sides% = div8%(PEEK(offs% - 256) + PEEK(offs% - 1) + PEEK(offs% + 256) + PEEK(offs% + 1))
        center% = div4%(PEEK(offs%))
        px1% = Lsin3%(corners% + sides% + center%)
        POKE offs%, px1%
        offs% = offs% + 1
    NEXT i%

    DEF SEG = Layer1%
    'starzzzzz
    FOR s% = 0 TO MaxStars
        K% = (s% + V%) AND 127
        C% = 255 - K%
        K% = K% + K% + 2
        sx1% = 128 + starsx%(s%) \ K%
        sy1% = 64 + starsy%(s%) \ K%
        IF sx1% > 0 AND sx1% < 255 AND sy1% > 0 AND sy1% < 125 THEN
           POKE Offs1% + Ly%(sy1%) + sx1%, C%
           POKE Offs1% + Ly%(sy1% - 1) + sx1%, C%
           POKE Offs1% + Ly%(sy1% + 1) + sx1%, C%
           POKE Offs1% + Ly%(sy1%) + sx1% + 1, C%
           POKE Offs1% + Ly%(sy1%) + sx1% - 1, C%
        END IF

    NEXT
    V% = V% - 3
IF Vsynch% THEN WAIT &H3DA, 8
PUT (32, 37), Vpage1%(0), PSET

LOOP UNTIL INKEY$ <> "" OR F& > MaxFrame%

Fps% = F& / (TIMER - T#)
DEF SEG

ERASE Text%, car%, starsx%, starsy%, comets%
EXIT SUB
       

'/============Sprite blitter
FeedBackDrawSprite:
    tsx% = comets%(i%, 0)
    tsy% = comets%(i%, 1)
    xty% = 0
    foos% = Offs1% + Ly%(tsy%) + tsx%
    FOR ty% = 0 TO 7
    FOR tx% = 0 TO 7
        tc% = Text%(tx%, ty%, i%)
        IF tc% > 0 THEN
            POKE foos%, 255
            POKE foos% + 1, 255
            POKE foos% + 256, 255
            POKE foos% + 257, 255
        END IF
        foos% = foos% + 2
    NEXT tx%
        foos% = foos% + 512 - 16
    NEXT ty%

RETURN

'//================Font getter
FeedbackGetFont:
    offset% = (8 * ASC(LTRIM$(RTRIM$(Char$)))) + 14
    FOR j% = 0 TO 7
      DEF SEG = &HFFA6
      Bit% = PEEK(offset% + j%)
      IF Bit% AND 1 THEN Text%(7, j%, i%) = 1
      IF Bit% AND 2 THEN Text%(7 - 1, j%, i%) = 1
      IF Bit% AND 4 THEN Text%(7 - 2, j%, i%) = 1
      IF Bit% AND 8 THEN Text%(7 - 3, j%, i%) = 1
      IF Bit% AND 16 THEN Text%(7 - 4, j%, i%) = 1
      IF Bit% AND 32 THEN Text%(7 - 5, j%, i%) = 1
      IF Bit% AND 64 THEN Text%(7 - 6, j%, i%) = 1
      IF Bit% AND 128 THEN Text%(7 - 7, j%, i%) = 1
    NEXT j%
    DEF SEG
RETURN

END SUB

SUB Fire (Fps%, Vsynch%, MaxFrame%)

'uses div4%() as as a look up of \5
'uses scanline%() as a color map

Vpage1%(0) = 2048
Vpage1%(1) = 126
Vpage2%(0) = 2048
Vpage2%(1) = 126

DIM car%(1, 3)                        'angle and radius
FOR i% = 0 TO 1
    car%(i%, 0) = INT(RND * 15 + 30)
    car%(i%, 1) = INT(RND * 15 + 30)
    car%(i%, 2) = INT(RND * 15 + 30)
    car%(i%, 3) = INT(RND * 15 + 30)
NEXT i%

FOR i% = 0 TO 255
    scanline%(i%) = 1 + INT(RND * 5)
NEXT i%

FOR i% = 0 TO 255 * 5
    div4%(i%) = i% \ 5
NEXT i%


Grad 0, 0, 0, 0, 2, 0, 0, 0
Grad 2, 15, 0, 0, 63, 63, 0, 0
Grad 64, 63, 0, 0, 127, 63, 63, 0
Grad 128, 63, 63, 0, 255, 63, 63, 0


Xrad% = 16
Yrad% = 14
Freq% = 6
FoldLeng! = 0
Fdir! = .3
rotdir% = 2
Acount% = 0


DEF SEG = Layer2%
p% = offs2% + Ly%(125)
FOR j% = 0 TO 255
    POKE p% + j%, 0
NEXT j%

DEF SEG = Layer1%
p% = Offs1% + Ly%(125)
FOR j% = 0 TO 255
    POKE p% + j%, 0
NEXT j%

T# = TIMER
DO
        F& = F& + 1 AND &H7FFFFFFF
        IF F& > MaxFrame% - 65 THEN
            Rel.FadeStep 0, 255, EndR%, EndG%, EndB%
        END IF

        FOR i% = 0 TO 1
            Flowersx% = SIN(F& / car%(i%, 0)) * car%(i%, 2) + 120
            Flowersy% = COS(F& / car%(i%, 1)) * car%(i%, 3) + 60
        NEXT i%

        DEF SEG = Layer1%
        Acount% = Acount% + 1
        IF Acount% > 360 THEN Acount% = 360
        ang% = (ang% + rotdir%)
        IF ang% < 0 THEN
            rotdir% = -rotdir%
        ELSEIF ang% > 360 THEN
            rotdir% = -rotdir%
        END IF
        FoldLeng! = FoldLeng! + Fdir!
        IF FoldLeng! < -10 THEN
            Fdir! = -Fdir!
        ELSEIF FoldLeng! > 10 THEN
            Fdir! = -Fdir!
        END IF


        tsx% = Flowersx%
        tsy% = Flowersy%

        FOR angle% = 0 TO Acount% STEP 2
            A% = ((Freq% * angle%) MOD 360)
            b% = (angle% + ang%) MOD 360
            x% = (Xrad% + FoldLeng! * Lsin!((A%))) * Lsin!((b%)) + tsx%
            y% = (Yrad% + FoldLeng! * Lsin!((A%))) * Lcos!((b%)) + tsy%
            '1
            POKE Offs1% + Ly%(y%) + x%, 220
        NEXT angle%

        T! = (F&) * 3.141593 / 180
        x% = INT(COS(T! * 4) + SIN(T!) * 120)
        y% = INT(SIN(T! + 1) * SIN(T! * 1) * 60)
        xx% = x% + 128
        yy% = y% + 63
        IF xx% > 2 AND yy% > 2 AND xx% < 254 AND yy% < 124 THEN
            POKE Offs1% + Ly%(yy%) + xx%, 255
            POKE Offs1% + Ly%(yy%) + xx% + 1, 255
            POKE Offs1% + Ly%(yy%) + xx% - 1, 255
            POKE Offs1% + Ly%(yy% - 1) + xx%, 255
            POKE Offs1% + Ly%(yy% + 1) + xx%, 255

            POKE Offs1% + Ly%(126 - yy% + 1) + (256 - xx%), 255
            POKE Offs1% + Ly%(126 - yy% - 1) + (256 - xx%), 255
            POKE Offs1% + Ly%(126 - yy%) + (256 - xx% + 1), 255
            POKE Offs1% + Ly%(126 - yy%) + (256 - xx% - 1), 255

        END IF

        T! = TIMER
        x% = INT(COS(T! * 3) + SIN(T!) * 120)
        y% = INT(SIN(T! + 2) * SIN(T! * 2) * 60)
        xx% = x% + 128
        yy% = y% + 63
        IF xx% > 2 AND yy% > 2 AND xx% < 254 AND yy% < 124 THEN
            POKE Offs1% + Ly%(yy%) + xx%, 255
            POKE Offs1% + Ly%(yy%) + xx% + 1, 255
            POKE Offs1% + Ly%(yy%) + xx% - 1, 255
            POKE Offs1% + Ly%(yy% - 1) + xx%, 255
            POKE Offs1% + Ly%(yy% + 1) + xx%, 255

            POKE Offs1% + Ly%(126 - yy% + 1) + (256 - xx%), 255
            POKE Offs1% + Ly%(126 - yy% - 1) + (256 - xx%), 255
            POKE Offs1% + Ly%(126 - yy%) + (256 - xx% + 1), 255
            POKE Offs1% + Ly%(126 - yy%) + (256 - xx% - 1), 255
        END IF
        p% = Offs1% + Ly%(124)
        Frames% = F& AND 1023
        FOR j% = 1 TO 254 STEP 3
            POKE p% + j%, (Lsin!(((j% OR p%) + Frames%) AND 255) * 255) * (Lcos!(((j% OR p%) + Frames%) AND 255) * 127)
            POKE p% + j% + 1, (Lcos!(((j% OR p%) + Frames%) AND 255) * 255) * (Lcos!(((j% OR p%) + Frames%) AND 255) * 127)
            POKE p% + j% + 2, (Lsin!(((j% OR p%) + Frames%) AND 255) * 255) * (Lsin!(((j% OR p%) + Frames%) AND 255) * 127)
        NEXT j%

        GOSUB FireDrawRect
        GOSUB FireDrawRect
    clrmap% = INT(RND * 255)
    FOR C% = 256 TO 32256 - 256
        DEF SEG = Layer1%
        p% = Offs1% + C%
        Clr% = PEEK(p% + 1) + PEEK(p% - 1) + PEEK(p% - 256) + PEEK(p% + 256) + PEEK(p%)
        Clr% = div4%(Clr%)
        clrmap% = (clrmap% + 1) AND 255
        Clr% = Clr% - scanline%(clrmap%)
        IF Clr% < 0 THEN Clr% = 0
        DEF SEG = Layer2%
        p2% = offs2% + C% - 256
        POKE p2%, Clr%
    NEXT C%
    PUT (32, 37), Vpage2%(0), PSET
    FOR i% = 3 TO 16130
        Vpage1%(i%) = Vpage2%(i%)
    NEXT i%
LOOP UNTIL INKEY$ <> "" OR F& > MaxFrame%

DEF SEG


Fps% = F& / (TIMER - T#)
ERASE car%
EXIT SUB

FireDrawRect:
    rx% = INT(RND * 256)
    ry% = INT(RND * 100)
    Ptr% = Ly%(ry%) + rx%
    FOR ry% = 0 TO 7 STEP 2
    FOR rx% = 0 TO 10 STEP 2
        POKE Ptr% + rx%, 255
    NEXT rx%
        Ptr% = Ptr% + 512
    NEXT ry%
RETURN

END SUB

SUB HGLine (X1%, X2%, y%, col1&, col2&)
'Generic's routine..
xx1% = X1%
xx2% = X2%
yy% = y%
clr1& = col1&
clr2& = col2&

IF xx1% > xx2% THEN SWAP xx1%, xx2%: SWAP clr1&, clr2&
xdiff% = 1 + xx2% - xx1%

dc& = (clr2& - clr1&) \ xdiff%
col& = clr1&
offset% = Offs1% + Ly%(yy%)
FOR l% = xx1% TO xx2%
POKE offset% + l%, col& \ 1024&
col& = col& + dc&
NEXT l%

END SUB

SUB HGLineT (X1%, X2%, y%, col1&, col2&)
xx1% = X1%
xx2% = X2%
yy% = y%
clr1& = col1&
clr2& = col2&

IF xx1% > xx2% THEN SWAP xx1%, xx2%: SWAP clr1&, clr2&
xdiff% = 1 + xx2% - xx1%

dc& = (clr2& - clr1&) \ xdiff%
col& = clr1&
offset% = Offs1% + Ly%(yy%)
FOR l% = xx1% TO xx2%
    C% = col& \ 1024&
    tc% = C% AND 15
    bc% = C% - tc%
    dc% = PEEK(offset% + l%) AND 15
    C% = (tc% + dc%) \ 2 + bc%
    POKE offset% + l%, C%
    col& = col& + dc&
NEXT l%


END SUB

SUB Init


Vpage1%(0) = 2048
Vpage1%(1) = 126
Vpage2%(0) = 2048
Vpage2%(1) = 126
Texture%(0) = 1024
Texture%(1) = 128


TextSeg% = VARSEG(Texture%(2))
TextOff% = VARPTR(Texture%(2))

Layer1% = VARSEG(Vpage1%(2))
Offs1% = VARPTR(Vpage1%(2))
Layer2% = VARSEG(Vpage2%(2))
offs2% = VARPTR(Vpage2%(2))


FOR i% = 0 TO 125
    Ly%(i%) = i% * 256
NEXT i%
FOR i% = 0 TO 359
    RA! = i% * (3.141593 / 180)
    Lcos!(i%) = COS(RA!)
    Lsin!(i%) = SIN(RA!)
NEXT i%

FOR i% = 0 TO 64 * 64
    Sqrt%(i%) = SQR(i%)
NEXT i%


FOR i% = -1024 TO 1024
   Lsin1%(i%) = SIN(i% * PI / (128)) * 256
   Lsin2%(i%) = SIN(i% * PI / (64)) * 128
   Lsin3%(i%) = SIN(i% * PI / (32)) * 64
NEXT i%



LightNormal.x = 0               'Light is from the camera
LightNormal.y = 1
LightNormal.z = -.7

Rel.LoadPalPp256 Path$ + "Fj.pal"
Rel.ReadPal GradPal

InitImageData Path$ + "Monofont.put", Font%()
MakeImageIndex Font%(), FontIndex%()

Zeropal
END SUB

SUB LensPlasmaRT (x%, y%, Radius%, counter%, countdir%, Trans%) STATIC

'RealTime Lens with Plasma
SphereHeight% = 15
Cleaner% = SphereHeight% * 10

RadiusSquared% = Radius% * Radius%


xsize% = Radius% * 2
ysize% = xsize%

newx% = x%                        'get coords
newy% = y%

minx% = 0
miny% = 0

'Clip/Crop it
IF newy% < 0 THEN
        cy = -newy%
        ysize% = ysize% - cy
        newy% = 0
        miny% = cy
ELSEIF newy% > 125 THEN
        EXIT SUB
ELSE
        ndy = newy% + ysize%
        IF ndy > 125 THEN
                ysize% = ysize% - (ndy - (126))
        END IF
END IF

IF newx% < 0 THEN
        cx = -newx%
        xsize% = xsize% - cx
        newx% = 0
        minx% = cx
ELSEIF newx% > 255 THEN
        EXIT SUB
ELSE
        ndx = newx% + xsize%
        IF ndx > 255 THEN
                xsize% = xsize% - (ndx - 256)
        END IF
END IF



counter% = (counter% + countdir%)
IF counter% < -700 THEN
    countdir% = -countdir%
ELSEIF counter% > 900 THEN
    countdir% = -countdir%
END IF
rot% = 64 * (((counter% AND 1) = 1) OR 1)
offset% = Offs1% + Ly%(newy%) + newx%       'calc start offset
IF NOT Trans% THEN
    FOR yt% = 0 TO ysize% - 1
     FOR xt% = 0 TO xsize% - 1
          X1% = (xt% - Radius%) + minx%
          Y1% = (yt% - Radius%) + miny%
                                
          HypotSquared% = (X1% * X1%) + (Y1% * Y1%)
          IF HypotSquared% < (RadiusSquared% - Cleaner%) THEN 'clean some nasty model errors
           H% = Sqrt%(RadiusSquared% - HypotSquared%)
           sx% = (SphereHeight% - H%)
           sy% = (SphereHeight% - H%)
           sx% = sx% * (X1% / H%)       'Here is the actual height calcs
           sy% = sy% * (Y1% / H%)       'XY/H is for normalization

           py% = (sy% + yt% + newy%)
           px% = (sx% + xt% + newx%)
           C% = Lsin3%(px% - counter%) + Lsin1%(py% - counter%) + Lsin2%(py% + px)
           POKE offset% + xt%, C%
          END IF
     NEXT xt%
        offset% = offset% + 256
    NEXT yt%
ELSE
    xsize% = xsize% - 1
    xsizeCleaner% = (xsize% AND 1)      'if 1=odd should be even since
                                        'we start at 0
    xsize% = xsize% - xsizeCleaner%
    FOR yt% = 0 TO ysize% - 1
     FOR xt% = 0 TO xsize%
          X1% = (xt% - Radius%) + minx%
          Y1% = (yt% - Radius%) + miny%
          rot% = -rot%
          HypotSquared% = (X1% * X1%) + (Y1% * Y1%)
          IF HypotSquared% < (RadiusSquared% - Cleaner%) THEN 'clean some nasty model errors
           H% = Sqrt%(RadiusSquared% - HypotSquared%)
           sx% = (SphereHeight% - H%)
           sy% = (SphereHeight% - H%)
           sx% = sx% * (X1% / H%)       'Here is the actual height calcs
           sy% = sy% * (Y1% / H%)       'XY/H is for normalization

           py% = (sy% + yt% + newy%)
           px% = (sx% + xt% + newx%)
           C% = Lsin3%(px% + rot%) + Lsin1%(px% + rot% + counter%) + Lsin2%(py% + rot%)
           POKE offset% + xt%, C%
          END IF
     NEXT xt%
        offset% = offset% + 256
    NEXT yt%
END IF

END SUB

SUB LensTexture (x%, y%, Radius%, TextSize%, Trans%) STATIC

'RealTime Lens with texture
'trans% controls translucency
SphereHeight% = 15
Cleaner% = SphereHeight% * 10

RadiusSquared% = Radius% * Radius%

TextsizeM1% = TextSize% - 1
xsize% = Radius% * 2
ysize% = xsize%

newx% = x%                        'get coords
newy% = y%

minx% = 0
miny% = 0

'Clip/Crop it
IF newy% < 0 THEN
        cy = -newy%
        ysize% = ysize% - cy
        newy% = 0
        miny% = cy
ELSEIF newy% > 125 THEN
        EXIT SUB
ELSE
        ndy = newy% + ysize%
        IF ndy > 125 THEN
                ysize% = ysize% - (ndy - (126))
        END IF
END IF

IF newx% < 0 THEN
        cx = -newx%
        xsize% = xsize% - cx
        newx% = 0
        minx% = cx
ELSEIF newx% > 255 THEN
        EXIT SUB
ELSE
        ndx = newx% + xsize%
        IF ndx > 255 THEN
                xsize% = xsize% - (ndx - 256)
        END IF
END IF

offset% = Offs1% + Ly%(newy%) + newx%       'calc start offset
IF NOT Trans% THEN
    FOR yt% = 0 TO ysize% - 1
        DEF SEG = TextSeg%
     FOR xt% = 0 TO xsize% - 1
          X1% = (xt% - Radius%) + minx%
          Y1% = (yt% - Radius%) + miny%
                                 
          HypotSquared% = (X1% * X1%) + (Y1% * Y1%)
          IF HypotSquared% < (RadiusSquared% - Cleaner%) THEN 'clean some nasty model errors
           H% = Sqrt%(RadiusSquared% - HypotSquared%)
           sx% = (SphereHeight% - H%)
           sy% = (SphereHeight% - H%)
           sx% = sx% * (X1% / H%)       'Here is the actual height calcs
           sy% = sy% * (Y1% / H%)       'XY/H is for normalization

           py% = (sy% + yt% + newy%) AND TextsizeM1%
           px% = (sx% + xt% + newx%) AND TextsizeM1%
            scanline%(newx% + xt%) = PEEK(TextOff% + py% * TextSize% + px%)
          ELSE
            scanline%(newx% + xt%) = 0
          END IF
     NEXT xt%
     DEF SEG = Layer1%
     FOR xt% = 0 TO xsize% - 1
            C% = scanline%(newx% + xt%)
            IF C% THEN
                POKE offset% + xt%, C%
            END IF
     NEXT xt%

        offset% = offset% + 256
    NEXT yt%

ELSE                'translucent

    FOR yt% = 0 TO ysize% - 1
        DEF SEG = TextSeg%
     FOR xt% = 0 TO xsize% - 1
          X1% = (xt% - Radius%) + minx%
          Y1% = (yt% - Radius%) + miny%
                                
          HypotSquared% = (X1% * X1%) + (Y1% * Y1%)
          IF HypotSquared% < (RadiusSquared% - Cleaner%) THEN 'clean some nasty model errors
           H% = Sqrt%(RadiusSquared% - HypotSquared%)
           sx% = (SphereHeight% - H%)
           sy% = (SphereHeight% - H%)
           sx% = sx% * (X1% / H%)       'Here is the actual height calcs
           sy% = sy% * (Y1% / H%)       'XY/H is for normalization

           py% = (sy% + yt% + newy%) AND TextsizeM1%
           px% = (sx% + xt% + newx%) AND TextsizeM1%
            scanline%(newx% + xt%) = PEEK(TextOff% + py% * TextSize% + px%)
          ELSE
            scanline%(newx% + xt%) = 0
          END IF
     NEXT xt%
     DEF SEG = Layer1%
     FOR xt% = 0 TO xsize% - 1
            C% = scanline%(newx% + xt%)
            IF C% THEN
                tc% = C% AND 15
                bc% = C% - tc%
                dc% = PEEK(offset% + xt%) AND 15
                C% = (tc% + dc%) \ 2 + bc%
                POKE offset% + xt%, C%
            END IF
     NEXT xt%
        offset% = offset% + 256
    NEXT yt%

END IF

END SUB

SUB LoadPlg (Model() AS Point3d, Tri() AS PolyType, Fil$, ScaleFactor!) STATIC

File$ = Fil$
ReadPlgHeader File$, MaxVertex, MaxPolys
REDIM Model(1 TO MaxVertex) AS Point3d
REDIM Tri(1 TO MaxPolys) AS PolyType


REDIM PlgNormal(1 TO UBOUND(Tri)) AS VectorType
REDIM PlgNormal2(1 TO UBOUND(Tri)) AS VectorType

REDIM PlgVertexNormal(1 TO UBOUND(Model)) AS VectorType
REDIM PlgVertexNormal2(1 TO UBOUND(Model)) AS VectorType

ReadPlgObject File$, Model(), Tri(), MaxVertex, MaxPolys
CenterObject 31, Model()
ScalePlg Model(), ScaleFactor!



END SUB

SUB Mode7 (Fps%, Trans%, Vsynch%, MaxFrame%, sx%, sy%, sz%, horz%)
CleanDisplay

'256*126 = 32256
'((256*126)+4)\2 =16130
'256*8 =2048
'32256\2=16128



IF NOT Trans% THEN
    FOR i% = -1024 TO 1024
        Lsin1%(i%) = SIN(i% / (45)) * 160
        Lsin2%(i%) = SIN(i% / (28)) * 64
        Lsin3%(i%) = SIN(i% / (15)) * 32
    NEXT i%
    j! = 255 / 360 * 2
    K! = 255 / 360 * 2
    l! = 255 / 360 * 1
    FOR i% = 0 TO 255
        OUT &H3C8, i%
        m% = INT(A!)
        n% = INT(b!)
        o% = INT(C!)
        r% = 63 * ABS(SIN(m% * PI / 180))
        G% = 63 * ABS(SIN(n% * PI / 180))
        IF i < 128 THEN G% = 0
        b% = 63 * ABS(SIN(o% * PI / 180))
        A! = A! + j!
        b! = b! + K!
        C! = C! + l!
        OUT &H3C9, r%
        OUT &H3C9, G%
        OUT &H3C9, b%
    NEXT
    Rel.ReadPal RGBPal
    Zeropal
ELSE
    FOR i% = -1024 TO 1024
       Lsin1%(i%) = SIN(i% / (32)) * 256
       Lsin2%(i%) = SIN(i% / (28)) * 164
       Lsin3%(i%) = SIN(i% / (15)) * 132
    NEXT i%

    j! = 255 / 360 * 1
    K! = 255 / 360 * 2
    l! = 255 / 360 * 1
    FOR i% = 0 TO 255
        OUT &H3C8, i%
        m% = INT(A!)
        n% = INT(b!)
        o% = INT(C!)
        r% = 63 * ABS(SIN(m% * PI / 180))
        IF r% > 63 THEN r% = 63
        G% = 63 * ABS(SIN(n% * PI / 180))
        IF i < 128 THEN G% = 0
        b% = 32 * ABS(SIN(o% * PI / 180))
        A! = A! + j!
        b! = b! + K!
        C! = C! + l!
        OUT &H3C9, r%
        OUT &H3C9, G%
        OUT &H3C9, b%
    NEXT
    Rel.ReadPal RGBPal
    Zeropal
END IF


SpaceZ! = sz%
Scaley! = sy%
Scalex! = sx%
Horizon% = horz%

countdir% = 1
counter% = 50
DEF SEG = Layer1%
T# = TIMER
DO
    F& = (F& + 1) AND &H7FFFFFFF
    IF F& < 65 THEN
        Rel.FadeToPalStep 0, 255, RGBPal
    ELSEIF F& > MaxFrame% - 65 THEN
        Rel.FadeStep 0, 255, EndR%, EndG%, EndB%
    END IF

    counter% = (counter% + countdir%)
    IF counter% < 2 THEN
        countdir% = -countdir%
    ELSEIF counter% > 700 THEN
        countdir% = -countdir%
    END IF
    rot% = 64 * (((counter% AND 1) = 1) OR 1)
    ci% = (ci% + 1) AND (2 ^ 3)
    px% = SIN(ci% / counter%) * 128
    py% = COS(ci% / counter%) * 64

    angle = (angle + 1) MOD 360

    xv! = Lcos!(angle)
    yv! = Lsin!(angle)
    offset% = Offs1%
    IF NOT Trans% THEN
        FOR ya% = 5 TO 63
                distance! = (SpaceZ! * Scaley!) / (ya% + Horizon%)
                HorizScale! = (distance! / Scalex!)
                LineDX! = (-yv! * HorizScale!)
                LineDy! = (xv! * HorizScale!)
                SpaceX! = ((distance! * xv!)) - (128 * LineDX!)
                SpaceY! = ((distance! * yv!)) - (63 * LineDy!)
                ldx& = LineDX! * 1024
                ldy& = LineDy! * 1024
                sx& = SpaceX! * 1024
                sy& = SpaceY! * 1024
                pxysin% = Lsin3%(px% + py%)
        FOR xa% = 0 TO 255
                xx% = sx& \ 1024
                yy% = sy& \ 1024
                C% = Lsin1%(xx% + px%) + Lsin2%(yy% + py%) + pxysin%
                C% = Lsin2%(xx% - counter%) + Lsin3%(Lsin1%(yy% - counter%) - Lsin3%(xx% - counter% - C%))
                POKE offset% + 17152, C%
                POKE 15111 - offset%, C%
                sx& = sx& + ldx&
                sy& = sy& + ldy&
                offset% = offset% + 1
        NEXT xa%
        NEXT ya%
    ELSE
        FOR ya% = 5 TO 63
                distance! = (SpaceZ! * Scaley!) / (ya% + Horizon%)
                HorizScale! = (distance! / Scalex!)
                LineDX! = (-yv! * HorizScale!)
                LineDy! = (xv! * HorizScale!)
                SpaceX! = ((distance! * xv!)) - (128 * LineDX!)
                SpaceY! = ((distance! * yv!)) - (63 * LineDy!)
                ldx& = LineDX! * 1024
                ldy& = LineDy! * 1024
                sx& = SpaceX! * 1024
                sy& = SpaceY! * 1024
        FOR xa% = 0 TO 254
                xx% = sx& \ 1024
                yy% = sy& \ 1024
                rot% = -rot%
                C% = Lsin3%(xx% + rot%) + Lsin1%(xx% + rot% + counter%) + Lsin2%(yy% + rot%)
                POKE offset% + 17152, C%
                POKE 15111 - offset%, C%
                sx& = sx& + ldx&
                sy& = sy& + ldy&
                offset% = offset% + 1
        NEXT xa%
            offset% = offset% + 1
        NEXT ya%
    END IF
IF Vsynch% THEN WAIT &H3DA, 8
PUT (32, 37), Vpage1%(0), PSET

LOOP UNTIL INKEY$ <> "" OR F& > MaxFrame%

DEF SEG


Fps% = F& / (TIMER - T#)

END SUB

SUB Mode7DiscoMask (Fps%, Vsynch%, MaxFrame%, sx%, sy%, sz%, horz%)
CleanDisplay

thetax% = 0
thetay% = 0
thetaz% = 0
scale! = 3.7
FileName$ = Path$ + "mask.Plg"

LoadPlg PlgModel(), PlgPoly(), FileName$, scale!
RotateAndProject PlgModel(), thetax%, thetay%, thetaz%
CalcNormals PlgModel(), PlgPoly(), PlgNormal(), PlgVertexNormal()
zcenter% = LENS


FOR i% = -1024 TO 1024
    Lsin1%(i%) = SIN(i% / (64)) * 256
    Lsin2%(i%) = SIN(i% / (32)) * 64
    Lsin3%(i%) = SIN(i% / (16)) * 32
NEXT i%

j! = 255 / 360 * 2
K! = 255 / 360 * 1
l! = 255 / 360 * 1
FOR i% = 0 TO 255
    OUT &H3C8, i%
    m% = INT(A!)
    n% = INT(b!)
    o% = INT(C!)
    r% = 63 * ABS(SIN(m% * PI / 180))
    G% = 63 * ABS(SIN(n% * PI / 180))
    b% = 63 * ABS(SIN(o% * PI / 180))
    A! = A! + j!
    b! = b! + K!
    C! = C! + l!
    OUT &H3C9, r%
    OUT &H3C9, G%
    OUT &H3C9, b%
NEXT

Rel.ReadPal RGBPal
Zeropal
SpaceZ! = sz%
Scaley! = sy%
Scalex! = sx%
Horizon% = horz%

countdir% = 1
counter% = 50
DEF SEG = Layer1%
T# = TIMER
DO
    F& = (F& + 1) AND &H7FFFFFFF
    IF F& < 65 THEN
        Rel.FadeToPalStep 0, 255, RGBPal
    ELSEIF F& > MaxFrame% - 65 THEN
        Rel.FadeStep 0, 255, EndR%, EndG%, EndB%
    END IF

    counter% = (counter% + countdir%)
    IF counter% < 2 THEN
        countdir% = -countdir%
    ELSEIF counter% > 700 THEN
        countdir% = -countdir%
    END IF
    rot% = 64 * (((counter% AND 1) = 1) OR 1)
    ci% = (ci% + 1) AND (1023)
    px% = SIN(ci% / counter%) * 128
    py% = COS(ci% / counter%) * 64

    angle = (angle + 1) MOD 360

    xv! = Lcos!(angle)
    yv! = Lsin!(angle)
    REDIM Vpage1%(0 TO 16130)
    Vpage1%(0) = 2048
    Vpage1%(1) = 126

    offset% = Offs1%
    FOR ya% = 5 TO 63
            distance! = (SpaceZ! * Scaley!) / (ya% + Horizon%)
            HorizScale! = (distance! / Scalex!)
            LineDX! = (-yv! * HorizScale!)
            LineDy! = (xv! * HorizScale!)
            SpaceX! = ((distance! * xv!)) - (128 * LineDX!)
            SpaceY! = ((distance! * yv!)) - (63 * LineDy!)
            ldx& = LineDX! * 1024
            ldy& = LineDy! * 1024
            sx& = SpaceX! * 1024
            sy& = SpaceY! * 1024
            pxysin% = Lsin3%(px% + py%)
    FOR xa% = 0 TO 255
            xx% = sx& \ 1024
            yy% = sy& \ 1024
            C% = Lsin1%(xx% + px%) + Lsin2%(yy% + py%) + pxysin%
            C% = Lsin2%(xx% - counter%) + Lsin3%(Lsin1%(yy% - counter%) - Lsin3%(xx% - counter% - C%))
            POKE offset% + 17152, C%
            POKE 15111 - offset%, C%
            sx& = sx& + ldx&
            sy& = sy& + ldy&
            offset% = offset% + 1
    NEXT xa%
    NEXT ya%

    '////=====3d mask
    thetax% = (thetax% + 1) MOD 360
    thetay% = (thetay% + 1) MOD 360
    thetaz% = (thetaz% + 1) MOD 360
    RotMatrix Matrix, thetax%, thetay%, thetaz%
    RotateAndProject PlgModel(), thetax%, thetay%, thetaz%
    RotNormals PlgVertexNormal(), PlgVertexNormal2(), thetax%, thetay%, thetaz%
    SortPolys PlgModel(), PlgPoly()
    DrawPlgG PlgModel(), PlgPoly()
IF Vsynch% THEN WAIT &H3DA, 8
PUT (32, 37), Vpage1%(0), PSET

LOOP UNTIL INKEY$ <> "" OR F& > MaxFrame%

DEF SEG


Fps% = F& / (TIMER - T#)

END SUB

SUB Mode7Texture (Fps%, Vsynch%, Trans%, MaxFrame%, sx%, sy%, sz%, horz%)
CleanDisplay

IF NOT Trans% THEN
    DIM Morph(1) AS Morph3d
    DIM Torus(1) AS Point3d
    DIM Sphere(1) AS Point3d
    thetax% = 0
    thetay% = 0
    thetaz% = 0
    LoadTorus TORNUMRINGS, TORNUMBANDS, TORRINGRADIUS, TORBANDRADIUS, Torus()
    LoadSphere SRADIUS, SPSLICES, SPBANDS, Sphere()
    InitMorph Morph(), Torus(), Sphere()
    MorphCounter% = 0
    Morphto% = -1
    zcenter% = LENS
    File$ = Path$ + "Anya128.Bmp"
    Rel.LoadBMP TextSeg%, TextOff%, File$, TRUE, 128
    Rel.ReadPal RGBPal
    Zeropal
ELSE
    File$ = Path$ + "Anya128C.Bmp"
    InitImageData Path$ + "ZeroRun.put", sprite%()
    MakeImageIndex sprite%(), spriteidx%()
    Rel.LoadBMP TextSeg%, TextOff%, File$, FALSE, 128
    Maxtext% = 10
    DIM Text(Maxtext%) AS TextType
END IF


xmin% = 0
ymin% = 0
xmax% = 256
ymax% = 126
xmid% = xmax% \ 2
ymid% = ymax% \ 2

starspeed! = .3
magrot% = 2
maxcounter% = 200
mag% = magrot%

MaxStars% = 128
DIM stars%(1 TO MaxStars%, 5)
DIM starsspd!(1 TO MaxStars%)
      
FOR i = 1 TO MaxStars%
    starangle% = INT(RND * 360)
    starradius% = 20 + INT(RND * 180)
    starx% = xmid% + (Lcos!(starangle%) * starradius%)
    stary% = ymid% + (Lsin!(starangle%) * starradius%)
    stars%(i, 0) = starx%
    stars%(i, 1) = stary%
    stars%(i, 3) = starradius%
    stars%(i, 4) = starangle%
    stars%(i, 5) = 16 + INT(RND * (255 - 16))
    starsspd!(i) = .5
NEXT i


SpaceZ! = sz%
Scaley! = sy%
Scalex! = sx%
Horizon% = horz%


IF NOT Trans% THEN

    DEF SEG = Layer1%
    T# = TIMER
    DO
        F& = (F& + 1) AND &H7FFFFFFF
        IF F& < 65 THEN
            Rel.FadeToPalStep 0, 255, RGBPal
        ELSEIF F& > MaxFrame% - 65 THEN
            Rel.FadeStep 0, 255, EndR%, EndG%, EndB%
        END IF

        REDIM Vpage1%(0 TO 16130)

        Vpage1%(0) = 2048
        Vpage1%(1) = 126


        angle = (angle + 1) MOD 360
        SpaceZ! = SpaceZ! + .02
        IF SpaceZ! > 50 THEN SpaceZ! = 50

        xv! = Lcos!(angle)
        yv! = Lsin!(angle)
        offset% = Offs1% + 256 * 35
        FOR ya% = 0 TO 90
                distance! = (SpaceZ! * Scaley!) / (ya% + Horizon%)
                HorizScale! = (distance! / Scalex!)
                LineDX! = (-yv! * HorizScale!)
                LineDy! = (xv! * HorizScale!)
                SpaceX! = ((distance! * xv!)) - (128 * LineDX!)
                SpaceY! = ((distance! * yv!)) - (63 * LineDy!)
                ldx& = LineDX! * 1024
                ldy& = LineDy! * 1024
                sx& = SpaceX! * 1024
                sy& = SpaceY! * 1024
                DEF SEG = TextSeg%
        FOR xa% = 0 TO 255
                xx% = (sx& \ 1024) AND 127
                yy% = (sy& \ 1024) AND 127
                scanline%(xa%) = PEEK((yy% * 128) + xx%)
                sx& = sx& + ldx&
                sy& = sy& + ldy&
        NEXT xa%
                DEF SEG = Layer1%
        FOR xa% = 0 TO 255
                POKE offset%, scanline%(xa%)
                offset% = offset% + 1
        NEXT xa%
        NEXT ya%

        thetax = (thetax + 1) MOD 360
        thetay = (thetay + 1) MOD 360
        thetaz = (thetaz + 1) MOD 360

        MorphCounter% = MorphCounter% + 1

        IF MorphCounter% > 300 THEN Morphit Morph()
        IF MorphCounter% > 400 THEN
            MorphCounter% = 0

            Morphto% = NOT Morphto%
            IF Morphto% THEN
                InitMorph Morph(), Torus(), Sphere()
            ELSE
                InitMorph Morph(), Sphere(), Torus()
            END IF

        END IF

        RotMatrix Matrix, thetax%, thetay%, thetaz%
        GOSUB MorphRotate
        GOSUB MorphDraw

    IF Vsynch% THEN WAIT &H3DA, 8
    PUT (32, 37), Vpage1%(0), PSET

    LOOP UNTIL INKEY$ <> "" OR F& > MaxFrame%

ELSE    'translucent

    C$ = Texter$(0)
    FOR i% = 0 TO Maxtext%
        Text(i%).Txt = Texter$(i%)
        Text(i%).x = 64
        Text(i%).y = 126 + (i% * 20)
        Text(i%).angle = (i% * 30) MOD 360
        Text(i%).Gamma = ABS(Lsin!(INT(RND * 360)) * 12) + 1
    NEXT i%
    MaxMess% = 182
    TextCounter% = Maxtext%

    DEF SEG = Layer1%
    T# = TIMER
    DO
        F& = (F& + 1) AND &H7FFFFFFF
        IF F& < 65 THEN
            Rel.FadeToPalStep 0, 255, GradPal
        ELSEIF F& > MaxFrame% - 65 THEN
            Rel.FadeStep 0, 255, EndR%, EndG%, EndB%
        END IF

        REDIM Vpage1%(0 TO 16130)

        Vpage1%(0) = 2048
        Vpage1%(1) = 126

        starcounter% = (starcounter% MOD maxcounter%) + 1
        IF starcounter% = 1 THEN
                IF SGN(oldmag%) = 1 THEN
                        mag% = -magrot%
                ELSE
                        mag% = magrot%
                END IF
        ELSEIF starcounter% = maxcounter% \ 2 THEN
                oldmag% = mag%
                mag% = 0
        END IF

        FOR i = 1 TO MaxStars%
                stars%(i, 4) = stars%(i, 4) + mag%
                IF SGN(mag%) = 1 THEN
                        IF stars%(i, 4) > 359 THEN stars%(i, 4) = 0
                ELSE
                        IF stars%(i, 4) < 0 THEN stars%(i, 4) = 359
                END IF
                starsspd!(i) = starsspd!(i) + starspeed!
                stars%(i, 3) = stars%(i, 3) + starsspd!(i)
                stars%(i, 0) = xmid% + (Lcos!(stars%(i, 4)) * stars%(i, 3))
                stars%(i, 1) = ymid% + (Lsin!(stars%(i, 4)) * stars%(i, 3))
                IF stars%(i, 0) > xmax% - 4 OR stars%(i, 0) < xmin% + 4 OR stars%(i, 1) > ymax% - 4 OR stars%(i, 1) < ymin% + 4 THEN
                    starangle% = INT(RND * 360)
                    starradius% = 20 + INT(RND * 30)
                    starx% = xmid% + (Lcos!(starangle%) * starradius%)
                    stary% = ymid% + (Lsin!(starangle%) * starradius%)
                    stars%(i, 0) = starx%
                    stars%(i, 1) = stary%
                    stars%(i, 3) = starradius%
                    stars%(i, 4) = starangle%
                    starsspd!(i) = .5
                END IF
                sx% = stars%(i, 0)
                sy% = stars%(i, 1)
                sc% = stars%(i, 5)
                IF sx% > 0 AND sx% < 256 AND sy% > 0 AND sy% < 126 THEN
                    POKE Offs1% + Ly%(sy%) + sx%, sc%
                END IF
        NEXT i
      

        angle = (angle + 1) MOD 360
        SpaceZ! = SpaceZ! + .02
        IF SpaceZ! > 50 THEN SpaceZ! = 50

        xv! = Lcos!(angle)
        yv! = Lsin!(angle)
        offset% = Offs1% + 256 * 35
        FOR ya% = 0 TO 90
                distance! = (SpaceZ! * Scaley!) / (ya% + Horizon%)
                HorizScale! = (distance! / Scalex!)
                LineDX! = (-yv! * HorizScale!)
                LineDy! = (xv! * HorizScale!)
                SpaceX! = ((distance! * xv!)) - (128 * LineDX!)
                SpaceY! = ((distance! * yv!)) - (63 * LineDy!)
                ldx& = LineDX! * 1024
                ldy& = LineDy! * 1024
                sx& = SpaceX! * 1024
                sy& = SpaceY! * 1024
                DEF SEG = TextSeg%
        FOR xa% = 0 TO 255
                xx% = (sx& \ 1024) AND 127
                yy% = (sy& \ 1024) AND 127
                scanline%(xa%) = PEEK((yy% * 128) + xx%)
                sx& = sx& + ldx&
                sy& = sy& + ldy&
        NEXT xa%
                DEF SEG = Layer1%
        FOR xa% = 0 TO 255
                C% = scanline%(xa%)
                tc% = C% AND 15
                bc% = C% - tc%
                dc% = PEEK(offset%) AND 15
                C% = (tc% + dc%) \ 2 + bc%
                POKE offset%, C%
                offset% = offset% + 1
        NEXT xa%
        NEXT ya%
        IF (F& AND 3) = 1 THEN sindex% = (sindex% MOD 10) + 1
        Rel.Sprite Layer1%, Offs1%, 105, 15, sprite%(), spriteidx%(sindex%), 0, Ly%()

        'Texter
        IF StopPrint% = 0 THEN
            FOR i% = 0 TO Maxtext%
                Text(i%).angle = (Text(i%).angle + 1) MOD 360
                StrLen% = 0
                Txt$ = LTRIM$(RTRIM$(Text(i%).Txt))
                FOR j% = 1 TO LEN(Txt$)
                        FontChar% = ASC(MID$(Txt$, j%, 1)) - 31
                        StrLen% = StrLen% + (Font%(FontIndex%(FontChar%)))
                NEXT j%
                StrLen% = StrLen% \ 8  'Calculate length
                tx% = (256 - StrLen%) \ 2
                tty% = Text(i%).y \ 10
                Text(i%).x = (tx% + StrLen% \ 8) + Lcos!(Text(i%).angle) * 25
                Text(i%).x = (tx%) + Lcos!(Text(i%).angle) * 25
                IF (F& AND 1) = 1 THEN Text(i%).y = Text(i%).y - 1
                IF Text(i%).y < -10 THEN
                    IF TextCounter% < MaxMess% THEN
                        TextCounter% = TextCounter% + 1
                        A$ = Texter$(TextCounter%)
                        Text(i%).Txt = A$
                        Text(i%).y = (Maxtext%) * 20 + 8
                        IF TextCounter% = MaxMess% THEN
                            IF Numlast% = 0 THEN
                                Numlast% = i%
                            END IF
                        END IF
                    END IF
                END IF
                IF Text(Numlast%).y < -10 THEN StopPrint% = TRUE
                Text(i%).Gamma = ABS(Lsin!(Text(i%).angle) * 12) + 1
                xx% = Text(i%).x
                yy% = Text(i%).y
                A$ = Text(i%).Txt
                G% = Text(i%).Gamma
                A% = Text(i%).angle
                Rel.FontSwirl Layer1%, Offs1%, xx%, yy%, A$, FALSE, Font(), FontIndex(), G%, A%, Ly%(), Lsin!()
            NEXT i%
        END IF

    IF Vsynch% THEN WAIT &H3DA, 8
    PUT (32, 37), Vpage1%(0), PSET
    LOOP UNTIL INKEY$ <> "" OR F& > MaxFrame%
END IF
DEF SEG

ERASE starsspd!, stars%
ERASE Morph, Torus, Sphere, Text

Fps% = F& / (TIMER - T#)

EXIT SUB

MorphRotate:

    FOR i = 1 TO UBOUND(Morph)
        x! = Morph(i).x       'Load Original model
        y! = Morph(i).y
        z! = Morph(i).z

        RotX! = (x! * Matrix.tx1 + y! * Matrix.ty1 + z! * Matrix.tz1)
        RotY! = (x! * Matrix.tx2 + y! * Matrix.ty2 + z! * Matrix.tz2)
        rotz! = (x! * Matrix.tx3 + y! * Matrix.ty3 + z! * Matrix.tz3)

        Morph(i).Xr = RotX!
        Morph(i).Yr = RotY!
        Morph(i).zr = rotz!


        'Project
        distance% = (LENS - rotz!)
        IF distance% THEN
            Morph(i).ScrX = (zcenter% * RotX! / distance%) + XCENTER + camx%
            Morph(i).ScrY = -(zcenter% * RotY! / distance%) + YCENTER + camy%
            Morph(i).C = 255
        ELSE
        END IF
    NEXT i

RETURN

MorphDraw:
    FOR i = 1 TO UBOUND(Morph)
        screenx = Morph(i).ScrX
        screeny = Morph(i).ScrY
        IF screenx >= 1 AND screenx <= 254 AND screeny >= 1 AND screeny <= 124 THEN
            c1% = 155
            c2% = 200
            c3% = 64
            c4% = 126
            X1% = screenx
            Y1% = screeny
            X2% = screenx - 1
            Y2% = screeny + 1

            POKE Offs1% + Ly%(Y1%) + X1%, c1%
            POKE Offs1% + Ly%(Y1%) + X2%, c2%
            POKE Offs1% + Ly%(Y2%) + X1%, c3%
            POKE Offs1% + Ly%(Y2%) + X2%, c4%
        END IF
    NEXT i

RETURN


END SUB

SUB Plasma (Mono%, Fps%, Trans%, MaxFrame%, ptype%)
CleanDisplay
'256*126 = 32256
'((256*126)+4)\2 =16130
'256*8 =2048
'32256\2=16128

IF NOT Trans% THEN
    GOSUB PlasmaPalDisco
    Rel.ReadPal RGBPal
    Zeropal
ELSE
    GOSUB PlasmaPalDiscoT
    Rel.ReadPal RGBPal
    Zeropal
END IF


countdir% = 1
counter% = 50
DEF SEG = Layer1%
T# = TIMER
DO
    F& = (F& + 1) AND &H7FFFFFFF
    IF F& < 65 THEN
        Rel.FadeToPalStep 0, 255, RGBPal
    ELSEIF F& > MaxFrame% - 65 THEN
        Rel.FadeStep 0, 255, EndR%, EndG%, EndB%
    END IF

    angle = (angle + 1) MOD 359
    offset% = Offs1%
    IF NOT Trans% THEN
        GOSUB PlasmaGenDisco
    ELSE
        GOSUB PlasmaGenDiscoT
    END IF
WAIT &H3DA, 8
PUT (32, 37), Vpage1%(0), PSET

LOOP UNTIL INKEY$ <> "" OR F& > MaxFrame%

DEF SEG


Fps% = F& / (TIMER - T#)
EXIT SUB

'===========Plasma Pal generators and Luts
PlasmaPalDisco:
    SELECT CASE ptype%
        CASE 0
            FOR i% = -1024 TO 1024
               Lsin1%(i%) = SIN(i% * PI / (128)) * 256
               Lsin2%(i%) = SIN(i% * PI / (64)) * 128
               Lsin3%(i%) = SIN(i% * PI / (32)) * 64
            NEXT i%
            j! = 255 / 360 * 1
            K! = 255 / 360 * 1
            l! = 255 / 360 * 1
            FOR i% = 0 TO 255
                OUT &H3C8, i%
                m% = INT(A!)
                n% = INT(b!)
                o% = INT(C!)
                r% = 63 * ABS(SIN(m% * PI / 180))
                G% = 63 * ABS(SIN(n% * PI / 180))
                b% = 63 * ABS(SIN(o% * PI / 180))
                A! = A! + j!
                b! = b! + K!
                C! = C! + l!
                OUT &H3C9, r%
                OUT &H3C9, G%
                OUT &H3C9, b%
            NEXT

        CASE 1
    END SELECT
RETURN

PlasmaPalDiscoT:
    SELECT CASE ptype%
        CASE 0
            FOR i% = -1024 TO 1024
               Lsin1%(i%) = SIN(i% / (64)) * 256
               Lsin2%(i%) = SIN(i% / (32)) * 164
               Lsin3%(i%) = SIN(i% / (64)) * 132
            NEXT i%

            j! = 255 / 360 * 2
            K! = 255 / 360 * 2
            l! = 255 / 360 * 3
            FOR i% = 0 TO 255
                OUT &H3C8, i%
                m% = INT(A!)
                n% = INT(b!)
                o% = INT(C!)
                r% = 63 * ABS(SIN(m% * PI / 180))
                IF r% > 63 THEN r% = 63
                G% = 63 * ABS(SIN(n% * PI / 180))
                IF i < 128 THEN G% = 0
                b% = 32 * ABS(SIN(o% * PI / 180))
                A! = A! + j!
                b! = b! + K!
                C! = C! + l!
                OUT &H3C9, r%
                OUT &H3C9, G%
                OUT &H3C9, b%
            NEXT
        CASE 1
    END SELECT
RETURN

PlasmaPalMono:
    SELECT CASE ptype%
        CASE 0
        CASE 1
    END SELECT
RETURN

PlasmaPalMonoT:
    SELECT CASE ptype%
        CASE 0
        CASE 1
    END SELECT
RETURN


'/==============Plasmas
PlasmaGenDisco:
    SELECT CASE ptype%
        CASE 0
            counter% = (counter% + countdir%)
            IF counter% < -700 THEN
                countdir% = -countdir%
            ELSEIF counter% > 900 THEN
                countdir% = -countdir%
            END IF

            FOR ya% = 0 TO 125
                ysin% = Lsin1%(ya% - counter%)
            FOR xa% = 0 TO 255
                        C% = Lsin3%(xa% - counter%) + ysin% + Lsin2%(ya% + xa%)
                        POKE offset%, C%
                        offset% = offset% + 1
            NEXT xa%
            NEXT ya%
        CASE 1
    END SELECT
RETURN

PlasmaGenDiscoT:
    SELECT CASE ptype%
        CASE 0
            counter% = (counter% + countdir%)
            IF counter% < -700 THEN
                countdir% = -countdir%
            ELSEIF counter% > 700 THEN
                countdir% = -countdir%
            END IF
            rot% = 64 * (((counter% AND 1) = 1) OR 1)

            FOR ya% = 0 TO 125
            FOR xa% = 0 TO 254
                    rot% = -rot%
                    C% = Lsin3%(xa% - counter%) + Lsin1%(xa% + rot% + counter%) + Lsin2%(ya% + rot%) + Lsin2%(xa% + rot% + counter%)
                    POKE offset%, C%
                    offset% = offset% + 1
            NEXT xa%
                offset% = offset% + 1
            NEXT ya%
        CASE 1
    END SELECT
RETURN

END SUB

SUB RotateAndProject (Model() AS Point3d, anglex, angley, anglez) STATIC

FOR i = 1 TO UBOUND(Model)

        x! = Model(i).x       'Load Original model
        y! = Model(i).y
        z! = Model(i).z

        RotX! = (x! * Matrix.tx1 + y! * Matrix.ty1 + z! * Matrix.tz1)
        RotY! = (x! * Matrix.tx2 + y! * Matrix.ty2 + z! * Matrix.tz2)
        rotz! = (x! * Matrix.tx3 + y! * Matrix.ty3 + z! * Matrix.tz3)

        Model(i).Xr = RotX!
        Model(i).Yr = RotY!
        Model(i).zr = rotz!


        'Project
        distance% = (LENS + rotz!)
        IF distance% THEN
            Model(i).ScrX = (zcenter% * RotX! / distance%) + XCENTER + camx%
            Model(i).ScrY = -(zcenter% * RotY! / distance%) + YCENTER + camy%
        ELSE
            Model(i).ScrX = RotX!
            Model(i).ScrY = RotY!
        END IF
NEXT i

END SUB

SUB RotMatrix (m AS MatrixType, anglex%, angley%, anglez%)
'Precalculate the SIN and COS of each angle
cx! = Lcos!(anglex%)
sx! = Lsin!(anglex%)
cy! = Lcos!(angley%)
sy! = Lsin!(angley%)
cz! = Lcos!(anglez%)
sz! = Lsin!(anglez%)

'Transformation matrix formula
'This is actually 16(or 12) equations but I pared it down to 9
'since TX4=0,TY4=0,TZ4=0,13 to 16th =0,0,0,1 (yes Doom!!!)

m.tx1 = cy! * cz!
m.tx2 = cy! * sz!
m.tx3 = -sy!
m.ty1 = cx! * -sz! + sx! * sy! * cz!
m.ty2 = cx! * cz! + sx! * sy! * sz!
m.ty3 = sx! * cy!
m.tz1 = -sx! * -sz! + cx! * sy! * cz!
m.tz2 = -sx! * cz! + cz! * sy! * sz!
m.tz3 = cx! * cy!


END SUB

SUB RotNormals (V() AS VectorType, v2() AS VectorType, anglex, angley, anglez)

FOR i = 1 TO UBOUND(V)

        x! = V(i).x       'Load Original vector
        y! = V(i).y
        z! = V(i).z


        RotX! = (x! * Matrix.tx1 + y! * Matrix.ty1 + z! * Matrix.tz1)
        RotY! = (x! * Matrix.tx2 + y! * Matrix.ty2 + z! * Matrix.tz2)
        rotz! = (x! * Matrix.tx3 + y! * Matrix.ty3 + z! * Matrix.tz3)


        IF rotz! < -1 THEN
            rotz! = -1
        ELSEIF rotz! > 1 THEN
            rotz! = 1
        END IF

        IF RotX! < -1 THEN
            RotX! = -1
        ELSEIF RotX! > 1 THEN
            RotX! = 1
        END IF

        IF RotY! < -1 THEN
            RotY! = -1
        ELSEIF RotY! > 1 THEN
            RotY! = 1
        END IF


        v2(i).x = RotX!
        v2(i).y = RotY!
        v2(i).z = rotz!
NEXT i


END SUB

SUB RotoZoom (Trans%, angle%, scale%)

TXmid% = 128
TYmid% = 63
IF scale% < 1 THEN scale% = 1
DX& = (Lcos!(angle%) * 1024) / (scale% / 100)
DY& = -(Lsin!(angle%) * 1024) / (scale% / 100)
xstart& = ((TXmid% * 1) - (TXmid% * DX&)) + (TYmid * DY&)
ystart& = ((TYmid% * 1) - (TYmid% * DX&)) - (TXmid * DY&)
                                   
Toff% = TextOff%
offset% = Offs1%

IF NOT Trans% THEN
    FOR ya% = 0 TO 125
            SrcX& = xstart&
            SrcY& = ystart&
            DEF SEG = TextSeg%
    FOR xa% = 0 TO 255
            xx% = 64 + (SrcX& \ 1024) AND 127
            yy% = 64 + (SrcY& \ 1024) AND 127
            scanline%(xa%) = PEEK(TextOff% + (yy% * 128) + xx%)
            SrcX& = SrcX& + DX&
            SrcY& = SrcY& + DY&
    NEXT xa
            DEF SEG = Layer1%
    FOR xa% = 0 TO 255
            POKE offset%, scanline%(xa%)
            offset% = offset% + 1
    NEXT xa
            xstart& = xstart& - DY&
            ystart& = ystart& + DX&
    NEXT ya
ELSE
    FOR ya% = 0 TO 125
            SrcX& = xstart&
            SrcY& = ystart&
            DEF SEG = TextSeg%
    FOR xa% = 0 TO 255
            xx% = 64 + (SrcX& \ 1024) AND 127
            yy% = 64 + (SrcY& \ 1024) AND 127
            scanline%(xa%) = PEEK(TextOff% + (yy% * 128) + xx%)
            SrcX& = SrcX& + DX&
            SrcY& = SrcY& + DY&
    NEXT xa
            DEF SEG = Layer1%
    FOR xa% = 0 TO 255
            C% = scanline%(xa%)
            tc% = C% AND 15
            bc% = C% - tc%
            dc% = PEEK(offset%) AND 15
            C% = (tc% + dc%) \ 2 + bc%
            POKE offset%, C%
            offset% = offset% + 1
    NEXT xa
            xstart& = xstart& - DY&
            ystart& = ystart& + DX&
    NEXT ya

END IF

END SUB

SUB SinusGlenzTeapot (Fps%, Vsynch%, MaxFrame%)
CleanDisplay

thetax% = 0
thetay% = 0
thetaz% = 0
scale! = 2.3
FileName$ = Path$ + "Teapot.Plg"
LoadPlg PlgModel(), PlgPoly(), FileName$, scale!
RotateAndProject PlgModel(), thetax%, thetay%, thetaz%
CalcNormals PlgModel(), PlgPoly(), PlgNormal(), PlgVertexNormal()
zcenter% = LENS

SetPolyBaseColor PlgPoly()

File$ = Path$ + "Anya128c.Bmp"
Rel.LoadBMP TextSeg%, TextOff%, File$, FALSE, 128

DEF SEG = Layer2%
offset% = 0
FOR y = 0 TO 125
FOR x = 0 TO 255
    DEF SEG = TextSeg%
    C% = PEEK(TextOff% + y * 128 + (x AND 127))
    DEF SEG = Layer2%
    POKE offs2% + offset%, C%
    offset% = offset% + 1
NEXT x
NEXT y

mag! = 0
Adder! = 1
Freq! = 16
mag! = 1
Ys = -1
FOR A = 0 TO 1024
    Ys = (Ys + 1) MOD 360           'Move Downwards
    Yss! = Ys * 3.141593 / 180      'Convert to rad
    Lsin1%(A) = SIN(Yss! + A / Freq!) * 128
NEXT A

T# = TIMER
DO
    F& = (F& + 1) AND &H7FFFFFF
    IF F& < 65 THEN
        Rel.FadeToPalStep 0, 255, GradPal
    ELSEIF F& > MaxFrame% - 65 THEN
        Rel.FadeStep 0, 255, EndR%, EndG%, EndB%
    END IF
    offset1% = Offs1%
    offset2% = offs2%
    xs% = (xs% + 1) AND 1023
    xmag! = mag!
    FOR y% = 0 TO 125
        xsin% = Lsin1%((xs% + y%) AND 1023) / 128 * xmag!
        xmag! = xmag! + .25
        DEF SEG = Layer2%
        FOR x% = 0 TO 255
            xx% = (x% + xsin% + xs%) AND 255
            scanline%(x%) = PEEK(offset2% + xx%)
        NEXT x%
            DEF SEG = Layer1%
        FOR x% = 0 TO 255
            POKE offset1%, scanline%(x%)
            offset1% = offset1% + 1
        NEXT x%
            offset2% = offset2% + 256
    NEXT y

        '////=====3d Teapot
        thetax% = (thetax% + 1) MOD 360
        thetay% = (thetay% + 1) MOD 360
        thetaz% = (thetaz% + 1) MOD 360
        RotMatrix Matrix, thetax%, thetay%, thetaz%
        RotateAndProject PlgModel(), thetax%, thetay%, thetaz%
        RotNormals PlgVertexNormal(), PlgVertexNormal2(), thetax%, thetay%, thetaz%
        SortPolys PlgModel(), PlgPoly()
        DrawPlgGradGT PlgModel(), PlgPoly()

    IF Vsynch% THEN WAIT &H3DA, 8
    PUT (32, 37), Vpage1%(0), PSET
LOOP UNTIL INKEY$ <> "" OR F& > MaxFrame%

DEF SEG
Fps% = F& / (TIMER - T#)

END SUB

SUB TriGouraud (xx1%, yy1%, cc1%, xx2%, yy2%, cc2%, xx3%, yy3%, Cc3%)
'Generic's routine..

Y1% = yy1%          'Added this since swapping stuff made some
Y2% = yy2%          'errors on my first version
y3% = yy3%          'Sorry Alan  ;*)
X1% = xx1%
X2% = xx2%
x3% = xx3%
c1% = cc1%
c2% = cc2%
c3% = Cc3%

IF Y1% > Y2% THEN SWAP Y1%, Y2%: SWAP X1%, X2%: SWAP c1%, c2%
IF Y1% > y3% THEN SWAP Y1%, y3%: SWAP X1%, x3%: SWAP c1%, c3%
IF Y2% > y3% THEN SWAP Y2%, y3%: SWAP X2%, x3%: SWAP c2%, c3%

'       (1)
'      /   \
'    (2)
'         \  (3)

' need to check for divide by zero - Not any more!
' call me mad! find more madness elsewhere for less and
' get double the difference refunded back, that's right
' double the difference ......... GUARANTEED!

ydiffa% = Y2% - Y1%
IF ydiffa% THEN
  d1& = ((X2% - X1%) * 1024&) \ ydiffa%  ' NOTE:
  gd1& = ((c2% - c1%) * 1024&) \ ydiffa%' LONG because need to represent
END IF                                 ' -255 AND 255... experimented with
                                       ' 16 bit rep. with a 7 fixed bit shift
                                       ' (128 of course) but the gradient
                                       ' looked a bit dodgy.
ydiffb% = y3% - Y2%
IF ydiffb% THEN
  d2& = ((x3% - X2%) * 1024&) \ ydiffb%
  gd2& = ((c3% - c2%) * 1024&) \ ydiffb%
END IF

ydiffc% = y3% - Y1%
IF ydiffc% THEN
  d3& = ((x3% - X1%) * 1024&) \ ydiffc%
  gd3& = ((c3% - c1%) * 1024&) \ ydiffc%
END IF

Lx& = X1% * 1024&
rx& = X1% * 1024&

lc& = c1% * 1024&
rc& = lc&

FOR y% = Y1% TO Y2% - 1
HGLine (Lx& \ 1024&), (rx& \ 1024&), y%, (lc&), (rc&)
  Lx& = Lx& + d1&
  rx& = rx& + d3&
  lc& = lc& + gd1&
  rc& = rc& + gd3&
NEXT
' HERE d1 has been added (y2%-y1%)+1 times to lx  = x2
'      d3 has been added (y2%-y1%)+1 times to rx

Lx& = (X2% * 1024&)     ' NOT NEEDED (for accuracy only)
lc& = c2% * 1024&        ' NOT NEEDED (for accuracy only)

FOR y% = Y2% TO y3%
  HGLine (Lx& \ 1024&), (rx& \ 1024&), y%, (lc&), (rc&)
  Lx& = Lx& + d2&
  rx& = rx& + d3&
  lc& = lc& + gd2&
  rc& = rc& + gd3&
NEXT y%

END SUB

SUB TriGouraudT (xx1%, yy1%, cc1%, xx2%, yy2%, cc2%, xx3%, yy3%, Cc3%)
'Translucent Gpoly
Y1% = yy1%          'Added this since swapping stuff made some
Y2% = yy2%          'errors on my first version
y3% = yy3%          'Sorry Alan  ;*)
X1% = xx1%
X2% = xx2%
x3% = xx3%
c1% = cc1%
c2% = cc2%
c3% = Cc3%

IF Y1% > Y2% THEN SWAP Y1%, Y2%: SWAP X1%, X2%: SWAP c1%, c2%
IF Y1% > y3% THEN SWAP Y1%, y3%: SWAP X1%, x3%: SWAP c1%, c3%
IF Y2% > y3% THEN SWAP Y2%, y3%: SWAP X2%, x3%: SWAP c2%, c3%

'       (1)
'      /   \
'    (2)
'         \  (3)

' need to check for divide by zero - Not any more!
' call me mad! find more madness elsewhere for less and
' get double the difference refunded back, that's right
' double the difference ......... GUARANTEED!

ydiffa% = Y2% - Y1%
IF ydiffa% THEN
  d1& = ((X2% - X1%) * 1024&) \ ydiffa%  ' NOTE:
  gd1& = ((c2% - c1%) * 1024&) \ ydiffa%' LONG because need to represent
END IF                                 ' -255 AND 255... experimented with
                                       ' 16 bit rep. with a 7 fixed bit shift
                                       ' (128 of course) but the gradient
                                       ' looked a bit dodgy.
ydiffb% = y3% - Y2%
IF ydiffb% THEN
  d2& = ((x3% - X2%) * 1024&) \ ydiffb%
  gd2& = ((c3% - c2%) * 1024&) \ ydiffb%
END IF

ydiffc% = y3% - Y1%
IF ydiffc% THEN
  d3& = ((x3% - X1%) * 1024&) \ ydiffc%
  gd3& = ((c3% - c1%) * 1024&) \ ydiffc%
END IF

Lx& = X1% * 1024&
rx& = X1% * 1024&

lc& = c1% * 1024&
rc& = lc&

FOR y% = Y1% TO Y2% - 1
HGLineT (Lx& \ 1024&), (rx& \ 1024&), y%, (lc&), (rc&)
  Lx& = Lx& + d1&
  rx& = rx& + d3&
  lc& = lc& + gd1&
  rc& = rc& + gd3&
NEXT
' HERE d1 has been added (y2%-y1%)+1 times to lx  = x2
'      d3 has been added (y2%-y1%)+1 times to rx

Lx& = (X2% * 1024&)     ' NOT NEEDED (for accuracy only)
lc& = c2% * 1024&        ' NOT NEEDED (for accuracy only)

FOR y% = Y2% TO y3%
  HGLineT (Lx& \ 1024&), (rx& \ 1024&), y%, (lc&), (rc&)
  Lx& = Lx& + d2&
  rx& = rx& + d3&
  lc& = lc& + gd2&
  rc& = rc& + gd3&
NEXT y%

END SUB

SUB Tunnel (Fps%, Mono%, Vsynch%, MaxFrame%)

CleanDisplay

'uses Lsin1%() and Lsin2%()
IF Mono% THEN

    thetax% = 0
    thetay% = 0
    thetaz% = 0
    scale! = 2.3
    FileName$ = Path$ + "Teapot.Plg"
    LoadPlg PlgModel(), PlgPoly(), FileName$, scale!
    RotateAndProject PlgModel(), thetax%, thetay%, thetaz%
    CalcNormals PlgModel(), PlgPoly(), PlgNormal(), PlgVertexNormal()
    zcenter% = LENS

    FOR y% = 0 TO 63
    FOR x% = 0 TO 63
        PSET (x%, y%), (SQR((x% - 32) ^ 2 + (y% - 32) ^ 2) * 5) AND 255
    NEXT x%
    NEXT y%
    GET (0, 0)-(63, 63), Texture%
    LINE (0, 0)-(319, 199), 0, BF
    FOR ya% = -63 TO -1
        FOR xa% = -128 TO -1
            ATAN%(ya%, xa%) = ATN(ya% / xa%) * 360 / PI
        NEXT xa%
    NEXT ya%

    FOR i = 0 TO 255
     r% = i \ 4
     G% = i \ 4
     b% = i \ 4
     OUT &H3C8, i
     OUT &H3C9, r%
     OUT &H3C9, G%
     OUT &H3C9, b%
    NEXT i
    Rel.ReadPal RGBPal
    Zeropal
    speed% = 2
    theta% = 2
    T# = TIMER
    DO
        F& = (F& + 1) AND &H7FFFFFFF
        IF F& < 65 THEN
            Rel.FadeToPalStep 0, 255, RGBPal
        ELSEIF F& > MaxFrame% - 65 THEN
            Rel.FadeStep 0, 255, EndR%, EndG%, EndB%
        END IF

        ptr1% = 128
        ydist% = 3969  '63 * 63
        FOR ya% = -63 TO -1
            DEF SEG = TextSeg%
            xx% = 16384  '128 * 128
            FOR xa% = -128 TO -1
                Radius% = SQR(ydist% + xx%)
                IF Radius% > 1 THEN
                    ptr2% = 64 * ((15000 \ Radius% + zdist%) AND 63) + TextOff%
                    Ta% = ATAN%(ya%, xa%)
                    Tb% = 64 - Ta% + anglerot% - Radius%
                    Ta% = Ta% + anglerot% - Radius%
                    Lsin1%(xa%) = 2 + PEEK((Ta% AND 63) + ptr2%) * Radius% \ 256
                    Lsin2%(xa%) = 2 + PEEK((Tb% AND 63) + ptr2%) * Radius% \ 256
                END IF
                xx% = xx% + xa% + xa% + 1
            NEXT xa%
            DEF SEG = Layer1%
            FOR xa% = -128 TO -1
                POKE ptr1% + xa% + Offs1%, Lsin1%(xa%)
                POKE ptr1% - xa% - 1 + Offs1%, Lsin2%(xa%)
                POKE 32256 - ptr1% + xa% + Offs1%, Lsin2%(xa%)
                POKE 32255 - ptr1% - xa% + Offs1%, Lsin1%(xa%)
            NEXT xa%
            ptr1% = ptr1% + 256
            ydist% = ydist% + ya% + ya% + 1
        NEXT ya%
        anglerot% = anglerot% + speed%
        zdist% = zdist% + theta%

        '////=====3d Teapot
        thetax% = (thetax% + 1) MOD 360
        thetay% = (thetay% + 1) MOD 360
        thetaz% = (thetaz% + 1) MOD 360
        RotMatrix Matrix, thetax%, thetay%, thetaz%
        RotateAndProject PlgModel(), thetax%, thetay%, thetaz%
        RotNormals PlgVertexNormal(), PlgVertexNormal2(), thetax%, thetay%, thetaz%
        SortPolys PlgModel(), PlgPoly()
        DrawPlgG PlgModel(), PlgPoly()

        IF Vsynch% THEN WAIT &H3DA, 8
        PUT (32, 37), Vpage1%(0), PSET
    LOOP UNTIL INKEY$ <> "" OR F& > MaxFrame%
ELSE        'disco


    thetax% = 0
    thetay% = 0
    thetaz% = 0
    scale! = 2.3
    FileName$ = Path$ + "Teapot.Plg"
    LoadPlg PlgModel(), PlgPoly(), FileName$, scale!
    RotateAndProject PlgModel(), thetax%, thetay%, thetaz%
    CalcNormals PlgModel(), PlgPoly(), PlgNormal(), PlgVertexNormal()
    zcenter% = LENS

    FOR y% = 0 TO 63
    FOR x% = 0 TO 63
        PSET (x%, y%), (SQR((x% - 32) ^ 2 + (y% - 32) ^ 2) * 5) AND 255
    NEXT x%
    NEXT y%
    GET (0, 0)-(63, 63), Texture%
    LINE (0, 0)-(319, 199), 0, BF
    j! = 255 / 360 * 2
    K! = 255 / 360 * 3
    l! = 255 / 360 * 1
    FOR i% = 0 TO 255
        OUT &H3C8, i%
        m% = INT(A!)
        n% = INT(b!)
        o% = INT(C!)
        r% = 63 * ABS(SIN(m% * PI / 180))
        G% = 63 * ABS(SIN(n% * PI / 180))
        b% = 32 * ABS(SIN(o% * PI / 180))
        A! = A! + j!
        b! = b! + K!
        C! = C! + l!
        OUT &H3C9, r%
        OUT &H3C9, G%
        OUT &H3C9, b%
    NEXT
    Rel.ReadPal RGBPal
    Zeropal
    FOR ya% = -63 TO -1
        FOR xa% = -128 TO -1
            ATAN%(ya%, xa%) = ATN(ya% / xa%) * 360 / PI
        NEXT xa%
    NEXT ya%

    speed% = 2
    theta% = 2
    countdir% = 1
    T# = TIMER
    DO
        F& = (F& + 1) AND &H7FFFFFFF
        IF F& < 65 THEN
            Rel.FadeToPalStep 0, 255, RGBPal
        ELSEIF F& > MaxFrame% - 65 THEN
            Rel.FadeStep 0, 255, EndR%, EndG%, EndB%
        END IF
        ptr1% = 128
        ydist% = 3969  '63 * 63
        FOR ya% = -63 TO -1
            DEF SEG = TextSeg%
            xx% = 16384  '128 * 128
            FOR xa% = -128 TO -1
                Radius% = SQR(ydist% + xx%)
                IF Radius% > 1 THEN
                    ptr2% = 64 * ((15000 \ Radius% + zdist%) AND 63) + TextOff%
                    Ta% = ATAN%(ya%, xa%)
                    Tb% = 64 - Ta% + anglerot% - Radius%
                    Ta% = Ta% + anglerot% - Radius%
                    Lsin1%(xa%) = 16 + PEEK((Ta% AND 63) + ptr2%) * Radius% \ 256
                    Lsin2%(xa%) = 16 + PEEK((Tb% AND 63) + ptr2%) * Radius% \ 256
                END IF
                xx% = xx% + xa% + xa% + 1
            NEXT xa%
            DEF SEG = Layer1%
            FOR xa% = -128 TO -1
                POKE ptr1% + xa% + Offs1%, Lsin1%(xa%)
                POKE ptr1% - xa% - 1 + Offs1%, Lsin2%(xa%)
                POKE 32256 - ptr1% + xa% + Offs1%, Lsin2%(xa%)
                POKE 32255 - ptr1% - xa% + Offs1%, Lsin1%(xa%)
            NEXT xa%
            ptr1% = ptr1% + 256
            ydist% = ydist% + ya% + ya% + 1
        NEXT ya%
        anglerot% = anglerot% + speed%
        zdist% = zdist% + theta%
        
        '////=====3d Teapot
        thetax% = (thetax% + 1) MOD 360
        thetay% = (thetay% + 1) MOD 360
        thetaz% = (thetaz% + 1) MOD 360
        RotMatrix Matrix, thetax%, thetay%, thetaz%
        RotateAndProject PlgModel(), thetax%, thetay%, thetaz%
        RotNormals PlgVertexNormal(), PlgVertexNormal2(), thetax%, thetay%, thetaz%
        SortPolys PlgModel(), PlgPoly()
        DrawPlgG PlgModel(), PlgPoly()

        IF Vsynch% THEN WAIT &H3DA, 8
        PUT (32, 37), Vpage1%(0), PSET
    LOOP UNTIL INKEY$ <> "" OR F& > MaxFrame%

END IF

Fps% = F& / (TIMER - T#)

END SUB

SUB WateronPlasma (Fps%, Vsynch%, MaxFrame%)
CleanDisplay
'uses Lsin1% for (\4) lookup

DIM w1%(256 * 126 \ 2)
DIM w2%(256 * 126 \ 2)


REDIM Vpage1%(0 TO 16130)
Vpage1%(0) = 2048
Vpage1%(1) = 126
PUT (32, 37), Vpage1%(0), PSET

xmax% = 256
ymax% = 126
xmaxm1% = xmax% - 1
ymaxm1% = ymax% - 1

xmaxp1% = xmax% + 1
ymaxp1% = ymax% + 1


FOR i% = -1024 TO 1024
   Lsin1%(i%) = i% \ 4
   Lsin2%(i%) = SIN(i% / (64)) * 128      'Horiz bands
   Lsin3%(i%) = SIN(i% / (32)) * 56     'Vertical bands
NEXT i%


wseg1% = VARSEG(w1%(0))
wseg2% = VARSEG(w2%(0))
woff1% = VARPTR(w1%(0))
woff2% = VARPTR(w2%(0))


j! = 255 / 360 * 3
K! = 255 / 360 * 4
l! = 255 / 360 * 4
FOR i% = 0 TO 255
    OUT &H3C8, i%
    m% = INT(A!)
    n% = INT(b!)
    o% = INT(C!)
    r% = 63 * ABS(SIN(m% * PI / 180))
    IF r% > 63 THEN r% = 63
    G% = 63 * ABS(SIN(n% * PI / 180))
    IF i < 128 THEN G% = 0
    b% = 32 * ABS(SIN(o% * PI / 180))
    A! = A! + j!
    b! = b! + K!
    C! = C! + l!
    OUT &H3C9, r%
    OUT &H3C9, G%
    OUT &H3C9, b%
NEXT
Rel.ReadPal RGBPal
Zeropal
countdir% = 1
F& = 0
T# = TIMER
DO
    F& = (F& + 1) AND &H7FFFFFFF
    IF F& < 65 THEN
        Rel.FadeToPalStep 0, 255, RGBPal
    ELSEIF F& > MaxFrame% - 65 THEN
        Rel.FadeStep 0, 255, EndR%, EndG%, EndB%
    END IF

    counter% = (counter% + countdir%)
    IF counter% < 1 THEN
        countdir% = -countdir%
    ELSEIF counter% > 500 THEN
        countdir% = -countdir%
    END IF

    IF F& AND 1 THEN
        DEF SEG = wseg1%
        ty% = 2 + INT(RND * ymaxm1% - 3)            'Rain
        tx% = 2 + INT(RND * xmaxm1% - 3)
        IF tx% > 1 AND ty% > 1 AND tx% < xmaxm1% AND ty% < ymaxm1% THEN
            POKE woff1% + Ly%(ty%) + tx%, 255
            POKE woff1% + Ly%(125 - ty%) + (255 - tx%), 255
        END IF
        T! = TIMER                                  'Your finger
        x% = INT(COS(T! * .4) + SIN(T!) * 100)
        y% = INT(SIN(T! + .2) * SIN(T! * .5) * 64)
        xx% = x% + xmax% \ 2
        yy% = y% + ymax% \ 2
        IF xx% > 1 AND yy% > 1 AND xx% < xmaxm1% AND yy% < ymaxm1% THEN
            POKE woff1% + Ly%(yy%) + xx%, 255
            POKE woff1% + Ly%(125 - yy%) + (255 - xx%), 255
        END IF
    END IF


    off1% = woff1% + xmaxp1%
    off2% = woff2% + xmaxp1%

    'Water simulation
    FOR y% = 1 TO ymaxm1% - 1
         DEF SEG = wseg1%
         FOR x% = 1 TO xmaxm1%
           C% = PEEK(off1% + 1) + PEEK(off1% - 1) + PEEK(off1% + xmax%) + PEEK(off1% - xmax%)
           C% = C% + PEEK(off1% + xmaxm1%) + PEEK(off1% - xmaxm1%) + PEEK(off1% + xmaxp1%) + PEEK(off1% - xmaxp1%)
           scanline%(x%) = C% AND 1023
           off1% = off1% + 1
         NEXT x%
         DEF SEG = wseg2%
         FOR x% = 1 TO xmaxm1%
            C% = (Lsin1%(scanline%(x%)) - PEEK(off2%))
            C% = ABS(C% - C% \ 256)
            POKE off2%, C%
            off2% = off2% + 1
         NEXT x%
            off1% = off1% + 1
            off2% = off2% + 1
    NEXT y%

    offs% = Offs1%
    off1% = woff1% + xmaxp1%
    off2% = woff2% + xmaxp1%


    'Refraction
    FOR y% = 1 TO ymaxm1% - 1
         DEF SEG = wseg1%
      FOR x% = 1 TO xmaxm1%
         xoff% = PEEK(off1% - 1) - PEEK(off1% + 1)
         yoff% = PEEK(off1% - xmax%) - PEEK(off1% + xmax%)
         xt% = x% + Lsin1%(yoff%)
         yt% = y% + Lsin1%(xoff%)
         yy% = (yt% + counter%)
         xx% = (xt% + counter%)
         xyt% = (yy% + xt%) AND 1023
         xxt% = (xx% + xt%) AND 1023
         scanline%(x%) = Lsin3%(xt% + yt%) + Lsin3%(xxt%) + Lsin2%(xyt%)
         off1% = off1% + 1
     NEXT x%
         DEF SEG = Layer1%
     FOR x% = 1 TO xmaxm1%
         POKE offs% + x%, scanline%(x%)
     NEXT x%
        offs% = offs% + 256
        off1% = off1% + 1
    NEXT y%
        SWAP wseg1%, wseg2%
    PUT (32, 37), Vpage1%(0), PSET
LOOP UNTIL INKEY$ <> "" OR F& > MaxFrame%

Fps% = F& / (TIMER - T#)
DEF SEG
ERASE w1%, w2%

END SUB

SUB WateronRotozoom (Fps%, Vsynch%, MaxFrame%)

CleanDisplay
'uses Lsin1% for (\4) lookup

DIM w1%(256 * 126 \ 2)
DIM w2%(256 * 126 \ 2)

REDIM Vpage1%(0 TO 16130)
Vpage1%(0) = 2048
Vpage1%(1) = 126
PUT (32, 37), Vpage1%(0), PSET


File$ = Path$ + "Anya128.Bmp"
Rel.LoadBMP TextSeg%, TextOff%, File$, TRUE, 128
Rel.ReadPal RGBPal
Zeropal

xmax% = 256
ymax% = 126
xmaxm1% = xmax% - 1
ymaxm1% = ymax% - 1

xmaxp1% = xmax% + 1
ymaxp1% = ymax% + 1


FOR i% = -1024 TO 1024
   Lsin1%(i%) = i% \ 4
   Lsin2%(i%) = SIN(i% / (64)) * 128      'Horiz bands
   Lsin3%(i%) = SIN(i% / (32)) * 56     'Vertical bands
NEXT i%


wseg1% = VARSEG(w1%(0))
wseg2% = VARSEG(w2%(0))
woff1% = VARPTR(w1%(0))
woff2% = VARPTR(w2%(0))


countdir% = 1
F& = 0
TXmid% = 128
TYmid% = 63
scale% = 100
angle% = 0
scaledir% = 1
T# = TIMER
DO
    F& = (F& + 1) AND &H7FFFFFFF
    IF F& < 65 THEN
        Rel.FadeToPalStep 0, 255, RGBPal
    ELSEIF F& > MaxFrame% - 65 THEN
        Rel.FadeStep 0, 255, EndR%, EndG%, EndB%
    END IF

    'rotozoom
    angle% = (angle% + 1) MOD 360
    scale% = scale% + scaledir%
    IF scale% < 10 THEN
        scaledir% = -scaledir%
    ELSEIF scale% > 200 THEN
        scaledir% = -scaledir%
    END IF
    IF scale% < 1 THEN scale% = 1
    DX& = (Lcos!(angle%) * 1024) / (scale% / 100)
    DY& = -(Lsin!(angle%) * 1024) / (scale% / 100)
    xstart& = ((TXmid% * 1) - (TXmid% * DX&)) + (TYmid * DY&)
    ystart& = ((TYmid% * 1) - (TYmid% * DX&)) - (TXmid * DY&)
    Toff% = TextOff%
    offset% = offs2%
    FOR ya% = 0 TO 125
            SrcX& = xstart&
            SrcY& = ystart&
            DEF SEG = TextSeg%
    FOR xa% = 0 TO 255
            xx% = 64 + (SrcX& \ 1024) AND 127
            yy% = 64 + (SrcY& \ 1024) AND 127
            scanline%(xa%) = PEEK(TextOff% + (yy% * 128) + xx%)
            SrcX& = SrcX& + DX&
            SrcY& = SrcY& + DY&
    NEXT xa
            DEF SEG = Layer2%
    FOR xa% = 0 TO 255
            POKE offset%, scanline%(xa%)
            offset% = offset% + 1
    NEXT xa
            xstart& = xstart& - DY&
            ystart& = ystart& + DX&
    NEXT ya


    'water
    counter% = (counter% + countdir%)
    IF counter% < 1 THEN
        countdir% = -countdir%
    ELSEIF counter% > 500 THEN
        countdir% = -countdir%
    END IF

    IF F& AND 1 THEN
        DEF SEG = wseg1%
        ty% = 2 + INT(RND * ymaxm1% - 3)            'Rain
        tx% = 2 + INT(RND * xmaxm1% - 3)
        IF tx% > 1 AND ty% > 1 AND tx% < xmaxm1% AND ty% < ymaxm1% THEN
            POKE woff1% + Ly%(ty%) + tx%, 255
            POKE woff1% + Ly%(125 - ty%) + (255 - tx%), 255
        END IF
        T! = TIMER                                  'Your finger
        x% = INT(COS(T! * .4) + SIN(T!) * 100)
        y% = INT(SIN(T! + .2) * SIN(T! * .5) * 64)
        xx% = x% + 128
        yy% = y% + 63
        IF xx% > 1 AND yy% > 1 AND xx% < xmaxm1% AND yy% < ymaxm1% THEN
            POKE woff1% + Ly%(yy%) + xx%, 255
            POKE woff1% + Ly%(125 - yy%) + (255 - xx%), 255
        END IF
    END IF


    off1% = woff1% + xmaxp1%
    off2% = woff2% + xmaxp1%

    'Water simulation
    FOR y% = 1 TO ymaxm1% - 1
         DEF SEG = wseg1%
         FOR x% = 1 TO xmaxm1%
           C% = PEEK(off1% + 1) + PEEK(off1% - 1) + PEEK(off1% + xmax%) + PEEK(off1% - xmax%)
           C% = C% + PEEK(off1% + xmaxm1%) + PEEK(off1% - xmaxm1%) + PEEK(off1% + xmaxp1%) + PEEK(off1% - xmaxp1%)
           scanline%(x%) = C% AND 1023
           off1% = off1% + 1
         NEXT x%
         DEF SEG = wseg2%
         FOR x% = 1 TO xmaxm1%
            C% = (Lsin1%(scanline%(x%)) - PEEK(off2%))
            C% = ABS(C% - C% \ 256)
            POKE off2%, C%
            off2% = off2% + 1
         NEXT x%
            off1% = off1% + 1
            off2% = off2% + 1
    NEXT y%

    offs% = Offs1%
    offset2% = offs2%
    off1% = woff1% + xmaxp1%
    off2% = woff2% + xmaxp1%


    'Refraction
    FOR y% = 1 TO ymaxm1%
      FOR x% = 1 TO xmaxm1%
         DEF SEG = wseg1%
         xoff% = PEEK(off1% - 1) - PEEK(off1% + 1)
         yoff% = PEEK(off1% - xmax%) - PEEK(off1% + xmax%)
         xt% = x% + Lsin1%(yoff%)
         yt% = y% + Lsin1%(xoff%)
         IF xt% > 0 AND xt% < 255 AND yt% > 0 AND yt% < 125 THEN
            DEF SEG = Layer2%
            C% = PEEK(offset2% + Ly%(yt%) + xt%)
         ELSE
            C% = 0
         END IF
         scanline%(x%) = C%
         off1% = off1% + 1
     NEXT x%
         DEF SEG = Layer1%
     FOR x% = 1 TO xmaxm1%
         POKE offs% + x%, scanline%(x%)
     NEXT x%
        offs% = offs% + 256
        off1% = off1% + 1
    NEXT y%
        SWAP wseg1%, wseg2%
    PUT (32, 37), Vpage1%(0), PSET
LOOP UNTIL INKEY$ <> "" OR F& > MaxFrame%

Fps% = F& / (TIMER - T#)
DEF SEG
ERASE w1%, w2%

END SUB

