DECLARE FUNCTION Texter$ (Index%)
DECLARE SUB Rel.Sprite (Layer%, LayerOffs%, x%, y%, sprite%(), SpriteOffset%, GammaDisp%, Ly%())
DECLARE SUB Rel.ReadPal (PalString$)
DECLARE SUB Rel.BoxF (DestSeg%, DestOff%, X1%, Y1%, X2%, Y2%, Clr%, Luty%())
DECLARE SUB Rel.WriteRGB (ColorNum%, r%, g%, b%)
DECLARE SUB SortIndex (Poly() AS ANY, Min%, Max%)
DECLARE SUB Rel.ReadRGB (ColorVal%, r%, g%, b%)

DEFINT A-Z

TYPE BMPHeaderType                              'All values are for 320*200*256 bmp
        ID              AS STRING * 2           '"BM"
        Size            AS LONG                 'width*heigth+1078= 65078
        RSV1            AS INTEGER              '0 Reserved
        RSV2            AS INTEGER              '0 Reserved
        offset          AS LONG                 '1078  First Pixel(Scanline order)
        horz            AS LONG                 '40
        WID             AS LONG                 '320
        HEI             AS LONG                 '200
        PLANES          AS INTEGER              '1   num of Planes
        BPP             AS INTEGER              '8   Bits per Plane
        COMPRESSION     AS LONG                 '0
        IMAGESIZE       AS LONG                 '64000  Width *Height
        XRES            AS LONG                 '3790  X pels
        YRES            AS LONG                 '3780  Y pels
        CLRUSED         AS LONG                 '0 Colors used
        CLRIMPORT       AS LONG                 '0 Colors Important
        Pal             AS STRING * 1024        'Order=Blue*4, Green*4, Red*4, 0 * 4
END TYPE

TYPE Point3d
        x       AS SINGLE                   'Normal 3d coords
        y       AS SINGLE
        z       AS SINGLE
        Xr      AS SINGLE
        Yr      AS SINGLE
        zr      AS SINGLE
        ScrX    AS INTEGER                  'Translated and projected
        ScrY    AS INTEGER                  '2d Coords
END TYPE
TYPE Morph3d
        x       AS SINGLE                   'Normal 3d coords
        y       AS SINGLE
        z       AS SINGLE
        xv      AS SINGLE                   'Normal 3d coords
        yv      AS SINGLE
        zv      AS SINGLE
        Xr      AS SINGLE
        Yr      AS SINGLE
        zr      AS SINGLE
        ScrX    AS INTEGER                  'Translated and projected
        ScrY    AS INTEGER                  '2d Coords
        c       AS INTEGER
END TYPE


TYPE PolyType
        p1      AS INTEGER
        p2      AS INTEGER
        p3      AS INTEGER
        clr1    AS INTEGER
        clr2    AS INTEGER
        clr3    AS INTEGER
        u1      AS INTEGER
        v1      AS INTEGER
        u2      AS INTEGER
        v2      AS INTEGER
        u3      AS INTEGER
        v3      AS INTEGER
        zcenter AS SINGLE
        Zorder  AS INTEGER
        idx     AS INTEGER
END TYPE

TYPE VectorType
        x      AS SINGLE
        y      AS SINGLE
        z      AS SINGLE
END TYPE

TYPE MatrixType
    tx1     AS SINGLE
    tx2     AS SINGLE
    tx3     AS SINGLE
    ty1     AS SINGLE
    ty2     AS SINGLE
    ty3     AS SINGLE
    tz1     AS SINGLE
    tz2     AS SINGLE
    tz3     AS SINGLE
END TYPE

TYPE PartType
        x               AS INTEGER
        y               AS INTEGER
        xv              AS INTEGER
        yv              AS INTEGER
        tx              AS INTEGER
        ty              AS INTEGER
        angle           AS INTEGER
        newtarget       AS INTEGER
END TYPE



CONST FALSE = 0, TRUE = NOT FALSE
CONST PI = 3.14151693#

CONST TORNUMRINGS = 30          'Number of Rings outside TORUS
CONST TORNUMBANDS = 10          'Number of PIXEL per RING
CONST TORRINGRADIUS = 50        'Radius of the Ring
CONST TORBANDRADIUS = 15        'Radius of the BAND

'Sphere
CONST SRADIUS = 40              'Radius of Sphere
CONST SPSLICES = 15             'Number of Slices
CONST SPBANDS = 20              'number of Pixel per slice

CONST LENS = 256                            'Z
CONST XCENTER = 128                         '??
CONST YCENTER = 64                         '??

SUB CalcNormals (Model() AS Point3d, ModelConnect() AS PolyType, V() AS VectorType, v2() AS VectorType)

FOR i = 1 TO UBOUND(V)

    p1 = ModelConnect(i).p1
    p2 = ModelConnect(i).p2
    p3 = ModelConnect(i).p3
    X1 = Model(p1).x
    X2 = Model(p2).x
    x3 = Model(p3).x
    Y1 = Model(p1).y
    Y2 = Model(p2).y
    y3 = Model(p3).y
    Z1 = Model(p1).z
    Z2 = Model(p2).z
    Z3 = Model(p3).z

    ax! = X2 - X1
    bx! = x3 - X2
    ay! = Y2 - Y1
    by! = y3 - Y2
    az! = Z2 - Z1
    bz! = Z3 - Z2

    'Cross product
    xnormal! = ay! * bz! - az! * by!
    ynormal! = az! * bx! - ax! * bz!
    znormal! = ax! * by! - ay! * bx!

    'Normalize
    mag! = SQR(xnormal! ^ 2 + ynormal! ^ 2 + znormal! ^ 2)
    IF mag! <> 0 THEN
        xnormal! = xnormal! / mag!
        ynormal! = ynormal! / mag!
        znormal! = znormal! / mag!
    END IF

        IF znormal! < -1 THEN
            znormal! = -1
        ELSEIF znormal! > 1 THEN
            znormal! = 1
        END IF

        IF xnormal! < -1 THEN
            xnormal! = -1
        ELSEIF xnormal! > 1 THEN
            xnormal! = 1
        END IF

        IF ynormal! < -1 THEN
            yxnormal! = -1
        ELSEIF ynormal! > 1 THEN
            ynormal! = 1
        END IF

    V(i).x = xnormal!
    V(i).y = ynormal!
    V(i).z = znormal!

NEXT i

'VertexNormal
FOR i = 1 TO UBOUND(Model)
    nx! = 0
    ny! = 0
    nz! = 0
    count = 0
    FOR j = 1 TO UBOUND(ModelConnect)
        IF ModelConnect(j).p1 = i OR ModelConnect(j).p2 = i OR ModelConnect(j).p3 = i THEN
            nx! = nx! + V(j).x
            ny! = ny! + V(j).y
            nz! = nz! + V(j).z
            count = count + 1
        END IF
    NEXT j
    nx! = nx! / count
    ny! = ny! / count
    nz! = nz! / count
    v2(i).x = nx!
    v2(i).y = ny!
    v2(i).z = nz!
NEXT i

END SUB

SUB CenterObject (Maxo%, Model() AS Point3d)

NumPoints = UBOUND(Model)
maxx! = Model(1).x
minx! = Model(1).x
maxy! = Model(1).y
miny! = Model(1).y
maxz! = Model(1).z
minz! = Model(1).z

FOR p = 1 TO NumPoints
    IF maxx! < Model(p).x THEN maxx! = Model(p).x
    IF minx! > Model(p).x THEN minx! = Model(p).x
    IF maxy! < Model(p).y THEN maxy! = Model(p).y
    IF miny! > Model(p).y THEN miny! = Model(p).y
    IF maxz! < Model(p).z THEN maxz! = Model(p).z
    IF minz! > Model(p).z THEN minz! = Model(p).z
NEXT

normx! = (maxx! + minx!) / 2
normy! = (maxy! + miny!) / 2
normz! = (maxz! + minz!) / 2
IF maxx! > maxy! THEN S1! = maxx! ELSE S1! = maxy!
IF S1! < maxz! THEN S1! = maxz!
IF S1! <> 0 THEN S2! = Maxo% / S1! ELSE S2! = 1

FOR p = 1 TO NumPoints
    Model(p).x = (Model(p).x - normx!) * S2!
    Model(p).y = (Model(p).y - normy!) * S2!
    Model(p).z = (Model(p).z - normz!) * S2!
NEXT

END SUB

SUB Grad (col1, r1, g1, b1, col2, r2, g2, b2)

cols = col2 - col1 + 1
rstep! = (r2 - r1) / cols
gstep! = (g2 - g1) / cols
bstep! = (b2 - b1) / cols
r! = r1
g! = g1
b! = b1
FOR col = col1 TO col2
  r! = r! + rstep!
  g! = g! + gstep!
  b! = b! + bstep!
  red% = INT(r!)
  Green% = INT(g!)
  Blue% = INT(b!)
  OUT &H3C8, col
  OUT &H3C9, red%
  OUT &H3C9, Green%
  OUT &H3C9, Blue%
NEXT col

END SUB

SUB GreyPal (Pal$)
    FOR i% = 0 TO 255
        OUT &H3C8, i%
        OUT &H3C9, i% \ 4
        OUT &H3C9, i% \ 4
        OUT &H3C9, i% \ 4
    NEXT i%
    Rel.ReadPal Pal$
END SUB

SUB InitImageData (FileName$, ImageArray())

    IF FileName$ <> "" THEN
        '***** Read image data from file *****

        'Establish size of integer array required.
        FileNo = FREEFILE
        OPEN FileName$ FOR BINARY AS #FileNo
        Ints = (LOF(FileNo) - 7) \ 2
        CLOSE #FileNo
        REDIM ImageArray(1 TO Ints)

        'Load image data directly into array memory.
        DEF SEG = VARSEG(ImageArray(1))
        BLOAD FileName$, 0
        DEF SEG
    ELSE
        '***** Read image data from DATA statements *****

        'Establish size of integer array required.
        READ IntCount
        REDIM ImageArray(1 TO IntCount)

        'READ image DATA into array.
        FOR n = 1 TO IntCount
            READ x
            ImageArray(n) = x
        NEXT n
    END IF

END SUB

SUB InitMorph (Model() AS Morph3d, OldModel() AS Point3d, NewModel() AS Point3d)

NumPoints% = UBOUND(OldModel)
REDIM Model(NumPoints) AS Morph3d
FOR i% = 0 TO UBOUND(Model)
     Model(i%).x = OldModel(i%).x
     Model(i%).y = OldModel(i%).y
     Model(i%).z = OldModel(i%).z
     Model(i%).c = 255
NEXT i%

FOR i% = 0 TO UBOUND(Model)
     xv! = (NewModel(i%).x - OldModel(i%).x) / 100
     yv! = (NewModel(i%).y - OldModel(i%).y) / 100
     zv! = (NewModel(i%).z - OldModel(i%).z) / 100
     Model(i%).xv = xv!
     Model(i%).yv = yv!
     Model(i%).zv = zv!
NEXT i%


END SUB

SUB LoadSphere (SphereRadius, Slices, Bands, ModelArray() AS Point3d)

REDIM ModelArray((Slices * Bands))  AS Point3d

i = 1
  FOR SliceLoop = 1 TO Slices
      Phi! = PI / Slices * SliceLoop
      FOR PPSLoop = 1 TO Bands
          theta! = 2 * PI / Bands * PPSLoop
          ModelArray(i).x = INT(SphereRadius * SIN(Phi!) * SIN(theta!))
          ModelArray(i).y = INT(SphereRadius * SIN(Phi!) * COS(theta!))
          ModelArray(i).z = INT(SphereRadius * COS(Phi!))
          i = i + 1
      NEXT PPSLoop
 NEXT SliceLoop

END SUB

SUB LoadTorus (Rings, Bands, RINGRADIUS, BandRadius, Model() AS Point3d)

REDIM Model((Rings * Bands)) AS Point3d

  A1! = 2 * PI / Rings: A2! = 2 * PI / Bands
  i% = 1
 FOR S2% = 1 TO Bands
  FOR S1% = 1 TO Rings
    X1! = COS(S1% * A1!) * RINGRADIUS
    Y1! = SIN(S1% * A1!) * RINGRADIUS
     Model(i%).x = X1! + COS(S1% * A1!) * COS(S2% * A2!) * BandRadius
     Model(i%).y = Y1! + SIN(S1% * A1!) * COS(S2% * A2!) * BandRadius
     Model(i%).z = SIN(S2% * A2!) * BandRadius
    i% = i% + 1
  NEXT S1%
 NEXT S2%



END SUB

SUB MakeImageIndex (ImageArray(), IndexArray())

    'The index will initially be built in a temporary array, allowing
    'for the maximum 1000 images per file.
    DIM Temp(1 TO 1000)
    Ptr& = 1: IndexNo = 1: LastInt = UBOUND(ImageArray)
    DO
        Temp(IndexNo) = Ptr&
        IndexNo = IndexNo + 1

        'Evaluate descriptor of currently referenced image to
        'calculate the beginning of the next image.
        x& = (ImageArray(Ptr&) \ 8) * (ImageArray(Ptr& + 1)) + 4
        IF x& MOD 2 THEN x& = x& + 1
        Ptr& = Ptr& + (x& \ 2)
    LOOP WHILE Ptr& < LastInt

    LastImage = IndexNo - 1

    'Copy the image index values into the actual index array.
    REDIM IndexArray(1 TO LastImage)
    FOR n = 1 TO LastImage
        IndexArray(n) = Temp(n)
    NEXT n

ERASE Temp
END SUB

SUB Morphit (Model() AS Morph3d)

FOR i% = 0 TO UBOUND(Model)
     Model(i%).x = Model(i%).x + Model(i%).xv
     Model(i%).y = Model(i%).y + Model(i%).yv
     Model(i%).z = Model(i%).z + Model(i%).zv
NEXT i%

END SUB

SUB ReadPlgHeader (File$, NumPoints, NumPolys)

FileNum = FREEFILE
OPEN File$ FOR INPUT AS #FileNum
LINE INPUT #FileNum, lbuf$
lbuf$ = LTRIM$(lbuf$)
objectname$ = LEFT$(lbuf$, INSTR(lbuf$, " "))
lbuf$ = RIGHT$(lbuf$, LEN(lbuf$) - INSTR(lbuf$, " "))
lbuf$ = LTRIM$(lbuf$)
NumPoints = VAL(LEFT$(lbuf$, INSTR(lbuf$, " ")))
lbuf$ = RIGHT$(lbuf$, LEN(lbuf$) - INSTR(lbuf$, " "))
lbuf$ = LTRIM$(lbuf$)
NumPolys = VAL(lbuf$)

FOR p = 1 TO NumPoints
    LINE INPUT #FileNum, lbuf$
NEXT p
np = NumPolys
FOR p = 1 TO np
    LINE INPUT #1, lbuf$
    lbuf$ = LTRIM$(lbuf$)
    lps = INSTR(lbuf$, " ")
    nop = VAL(LEFT$(lbuf$, lps))
    lbuf$ = RIGHT$(lbuf$, LEN(lbuf$) - lps)
    lbuf$ = LTRIM$(lbuf$)
    lps = INSTR(lbuf$, " ")
    nop = VAL(LEFT$(lbuf$, lps))
    IF nop = 4 THEN
        NumPolys = NumPolys + 1
    END IF
NEXT p

CLOSE

END SUB

SUB ReadPlgObject (File$, Model() AS Point3d, Tri() AS PolyType, NumPoints, NumPolys)

OPEN File$ FOR INPUT AS 1
LINE INPUT #1, lbuf$
FOR p = 1 TO NumPoints
    LINE INPUT #1, lbuf$
    lbuf$ = LTRIM$(lbuf$)
    lps = INSTR(lbuf$, " ")
    Model(p).x = VAL(LEFT$(lbuf$, lps))
    lbuf$ = RIGHT$(lbuf$, LEN(lbuf$) - lps)
    lbuf$ = LTRIM$(lbuf$)
    lps = INSTR(lbuf$, " ")
    Model(p).z = VAL(LEFT$(lbuf$, lps))
    lbuf$ = RIGHT$(lbuf$, LEN(lbuf$) - lps)
    lbuf$ = LTRIM$(lbuf$)
    lps = INSTR(lbuf$, " ")
    IF lps THEN
        Model(p).y = VAL(LEFT$(lbuf$, lps))
    ELSE
        Model(p).y = VAL(lbuf$)
    END IF
    Model(p).x = Model(p).x
    Model(p).y = Model(p).y
    Model(p).z = Model(p).z
NEXT p

FOR p = 1 TO NumPolys
    LINE INPUT #1, lbuf$
    lbuf$ = LTRIM$(lbuf$)
    lps = INSTR(lbuf$, " ")
    nop = VAL(LEFT$(lbuf$, lps))
    lbuf$ = RIGHT$(lbuf$, LEN(lbuf$) - lps)
    lbuf$ = LTRIM$(lbuf$)
    lps = INSTR(lbuf$, " ")
    nop = VAL(LEFT$(lbuf$, lps))
    IF nop = 4 THEN
        lbuf$ = RIGHT$(lbuf$, LEN(lbuf$) - lps)
        lbuf$ = LTRIM$(lbuf$)
        lps = INSTR(lbuf$, " ")
        p1 = VAL(LEFT$(lbuf$, lps)) + 1
        lbuf$ = RIGHT$(lbuf$, LEN(lbuf$) - lps)
        lbuf$ = LTRIM$(lbuf$)
        lps = INSTR(lbuf$, " ")
        p2 = VAL(LEFT$(lbuf$, lps)) + 1
        lbuf$ = RIGHT$(lbuf$, LEN(lbuf$) - lps)
        lbuf$ = LTRIM$(lbuf$)
        lps = INSTR(lbuf$, " ")
        p3 = VAL(LEFT$(lbuf$, lps)) + 1
        lbuf$ = RIGHT$(lbuf$, LEN(lbuf$) - lps)
        lbuf$ = LTRIM$(lbuf$)
        lps = INSTR(lbuf$, " ")
        p4 = VAL(lbuf$) + 1
        Tri(p).p1 = p1
        Tri(p).p2 = p2
        Tri(p).p3 = p4
        p = p + 1
        Tri(p).p1 = p2
        Tri(p).p2 = p3
        Tri(p).p3 = p4
    ELSE
        lbuf$ = RIGHT$(lbuf$, LEN(lbuf$) - lps)
        lbuf$ = LTRIM$(lbuf$)
        lps = INSTR(lbuf$, " ")
        Tri(p).p1 = VAL(LEFT$(lbuf$, lps)) + 1
        lbuf$ = RIGHT$(lbuf$, LEN(lbuf$) - lps)
        lbuf$ = LTRIM$(lbuf$)
        lps = INSTR(lbuf$, " ")
        Tri(p).p2 = VAL(LEFT$(lbuf$, lps)) + 1
        lbuf$ = RIGHT$(lbuf$, LEN(lbuf$) - lps)
        lbuf$ = LTRIM$(lbuf$)
        lps = INSTR(lbuf$, " ")
        Tri(p).p3 = VAL(lbuf$) + 1
    END IF
        Tri(p).clr1 = p
NEXT p
CLOSE

END SUB

SUB Rel.BoxF (DestSeg%, DestOff%, X1, Y1, X2, Y2, Clr, Luty%())

'puts a Filled Box to page
Bx1 = X1
BX2 = X2
By1 = Y1
By2 = Y2

'Swap values if necessary
IF Bx1 > BX2 THEN SWAP Bx1, BX2
IF By1 > By2 THEN SWAP By1, By2

Dx = (BX2 - Bx1)
Dy = (By2 - By1)
'Clip or Crop
IF By1 < 0 THEN
        IF Dy + By1 < 0 THEN
                EXIT SUB
        ELSE
                Dy = Dy + By1
        END IF
        By1 = 0
ELSEIF By1 > 125 THEN
        EXIT SUB
ELSE
        ndy = By1 + Dy
        IF ndy > 125 THEN Dy = Dy - (ndy - 125)
END IF

IF Bx1 < 0 THEN
        IF Dx + Bx1 < 0 THEN
                EXIT SUB
        ELSE
                Dx = Dx + Bx1
        END IF
        Bx1 = 0
ELSEIF Bx1 > 255 THEN
        EXIT SUB
ELSE
        ndx = Bx1 + Dx
        IF ndx > 255 THEN Dx = Dx - (ndx - 255)
END IF


DEF SEG = DestSeg%
VpSaddr = Luty%(By1) + Bx1 + DestOff%

FOR ya = 0 TO Dy
FOR xa = 0 TO Dx
        POKE VpSaddr + xa, Clr
NEXT xa
        VpSaddr = VpSaddr + 256
NEXT ya

DEF SEG


END SUB

SUB Rel.FadeStep (StartCol, EndCol, r%, g%, b%) STATIC
'This sub fades the current palette to the specified RGB color
'in steps, so if you want to fade fully call this sub 64 times
'from StartColor to Endcolor ie, selective fade

IF StartCol > EndCol THEN SWAP StartCol, EndCol

i = i + 1

IF i > 63 THEN
        i = 0
        EXIT SUB
END IF

FOR j = StartCol TO EndCol


        Rel.ReadRGB j, RD, GN, BLL

        IF r% > RD THEN
                RD = RD + 1
        ELSEIF r% < RD THEN
                RD = RD - 1
        ELSE
                'Do nothing
        END IF

        IF g% > GN THEN
                GN = GN + 1
        ELSEIF g% < GN THEN
                GN = GN - 1
        ELSE
                'Do nothing
        END IF

        IF b% > BLL THEN
                BLL = BLL + 1
        ELSEIF b% < BLL THEN
                BLL = BLL - 1
        ELSE
                'Do nothing
        END IF

        Rel.WriteRGB j, RD, GN, BLL

NEXT j

END SUB

SUB Rel.FadeToPalStep (StartCol, EndCol, PalString$) STATIC

'This sub fades the current palette to the palette in the
'768 byte Palstring$
'in steps, so if you want to fade fully call this sub 64 times
'from StartColor to Endcolor ie, selective fade

PalI = PalI + 1

IF PalI > 63 THEN
        PalI = 0
        EXIT SUB
END IF


REDIM TempPalArray(2, 255) AS INTEGER      'Current pal

ColorVal = 0
FOR i% = 1 TO 768 STEP 3
    TempPalArray(0, ColorVal) = ASC(MID$(PalString$, i%, 1))
    TempPalArray(1, ColorVal) = ASC(MID$(PalString$, i% + 1, 1))
    TempPalArray(2, ColorVal) = ASC(MID$(PalString$, i% + 2, 1))
    ColorVal = ColorVal + 1
NEXT i%


IF StartCol > EndCol THEN SWAP StartCol, EndCol


FOR j = StartCol TO EndCol


        Rel.ReadRGB j, RD, GN, BLL
        r% = TempPalArray(0, j)
        IF r% > RD THEN
                RD = RD + 1
        ELSEIF r% < RD THEN
                RD = RD - 1
        ELSE
                'Do nothing
        END IF

        g% = TempPalArray(1, j)
        IF g% > GN THEN
                GN = GN + 1
        ELSEIF g% < GN THEN
                GN = GN - 1
        ELSE
                'Do nothing
        END IF

        b% = TempPalArray(2, j)
        IF b% > BLL THEN
                BLL = BLL + 1
        ELSEIF b% < BLL THEN
                BLL = BLL - 1
        ELSE
                'Do nothing
        END IF

        Rel.WriteRGB j, RD, GN, BLL

NEXT j

ERASE TempPalArray

END SUB

SUB Rel.Font256 (DestSeg%, DestOff%, x%, y%, Text$, Centered%, FontArray(), FontArrayIndex(), GammaDisp%, Ly%())

FontSeg% = VARSEG(FontArray(1))
IF NOT Centered% THEN

        FOR i% = 1 TO LEN(Text$)
                FontChar% = ASC(MID$(Text$, i%, 1)) - 31
                Rel.Sprite DestSeg%, DestOff%, x%, y%, FontArray(), (FontArrayIndex(FontChar)), GammaDisp%, Ly%()
                x% = x% + (FontArray(FontArrayIndex(FontChar%)) \ 8)
        NEXT i%

ELSE            'Centered

        StrLen% = 0
        FOR i% = 1 TO LEN(Text$)
                FontChar% = ASC(MID$(Text$, i%, 1)) - 31
                StrLen% = StrLen% + (FontArray(FontArrayIndex(FontChar%)))
        NEXT i%
        StrLen% = StrLen% \ 8  'Calculate length
        x% = (256 - StrLen%) \ 2
        FOR i% = 1 TO LEN(Text$)
                FontChar% = ASC(MID$(Text$, i%, 1)) - 31
                Rel.Sprite DestSeg%, DestOff%, x%, y%, FontArray(), (FontArrayIndex(FontChar)), GammaDisp%, Ly%()
                x% = x% + (FontArray(FontArrayIndex(FontChar%)) \ 8)
        NEXT i%

END IF

END SUB

SUB Rel.FontSwirl (DestSeg%, DestOff%, x%, y%, Text$, Centered%, FontArray(), FontArrayIndex(), GammaDisp%, angle%, Ly%(), Lsin!())

FontSeg% = VARSEG(FontArray(1))
ang% = angle%
IF NOT Centered% THEN

        FOR i% = 1 TO LEN(Text$)
                FontChar% = ASC(MID$(Text$, i%, 1)) - 31
                ang% = (ang% + (i%)) MOD 360
                ydisp% = Lsin!(ang%)
                Rel.Sprite DestSeg%, DestOff%, x%, y% + ydisp%, FontArray(), (FontArrayIndex(FontChar)), GammaDisp%, Ly%()
                x% = x% + (FontArray(FontArrayIndex(FontChar%)) \ 8)
        NEXT i%

ELSE            'Centered

        StrLen% = 0
        FOR i% = 1 TO LEN(Text$)
                FontChar% = ASC(MID$(Text$, i%, 1)) - 31
                StrLen% = StrLen% + (FontArray(FontArrayIndex(FontChar%)))
        NEXT i%
        StrLen% = StrLen% \ 8  'Calculate length
        x% = (256 - StrLen%) \ 2
        FOR i% = 1 TO LEN(Text$)
                FontChar% = ASC(MID$(Text$, i%, 1)) - 31
                ang% = (ang% + (i%)) MOD 360
                ydisp% = Lsin!(ang%)
                Rel.Sprite DestSeg%, DestOff%, x%, y% + ydisp%, FontArray(), (FontArrayIndex(FontChar)), GammaDisp%, Ly%()
                x% = x% + (FontArray(FontArrayIndex(FontChar%)) \ 8)
        NEXT i%

END IF

END SUB

SUB Rel.LoadBMP (DestSeg%, Destoffs%, File$, SwitchPal%, TextSize%) STATIC
'Loads a BMP to a layer or directly to the screen
'if you want it to be on screen pass &HA000 as DestSeg%
'only supports 256 color BMPs.
DIM BMP AS BMPHeaderType

F% = FREEFILE                   'Get free filenum
OPEN File$ FOR BINARY AS #F%    'Binary read
GET #F%, , BMP                   'Get header

'Our File Pointer points to 55 byte seek 55, first byte
'Pal should be 1024 in length
Pall$ = BMP.Pal
IF SwitchPal% THEN              'if we switch to pal then
        IF LEN(Pall$) = 1024 THEN
                OUT &H3C8, 0              'color zero start
                FOR i% = 1 TO 1024 STEP 4
                        b% = ASC(MID$(Pall$, i%, 1)) \ 4     'div by 4
                        g% = ASC(MID$(Pall$, i% + 1, 1)) \ 4 'div by 4
                        r% = ASC(MID$(Pall$, i% + 2, 1)) \ 4 'div by 4
                        'Byte 4 unused. Just for padding 32 bit regs
                        OUT &H3C9, r%
                        OUT &H3C9, g%
                        OUT &H3C9, b%
                NEXT i%
        END IF
END IF

'Read and Write time!!!
'Notes: Bad MS(I don't get it why they stored it backwards?)

Byte$ = SPACE$(BMP.WID)
DEF SEG = DestSeg%

Wide% = BMP.WID - 1             'Sub 1 since we start at zero
Hite% = BMP.HEI - 1
FOR y% = Hite% TO 0 STEP -1
        GET #F%, , Byte$
FOR x% = 0 TO Wide%
        c% = ASC(MID$(Byte$, x% + 1, 1))
        IF c% = 0 THEN c% = 16
        POKE Destoffs% + (TextSize% * y%) + x%, c%
NEXT x%
NEXT y%

CLOSE #F%

END SUB

SUB Rel.LoadPalPp256 (File$) STATIC
'Loads and Switches the pal to PP256's pal from File$
'Special thanks goes to Kackurot for this one.

FR = FREEFILE
IF INSTR(File$, ".") = 0 THEN File$ = LEFT$(File$, 8) + ".Pal"
OPEN File$ FOR BINARY AS #FR
    FOR n = 0 TO 255
        GET #FR, , c&
        b = c& \ 65536: c& = c& - b * 65536
        g = c& \ 256: c& = c& - g * 256
        r = c&
        OUT &H3C8, n
        OUT &H3C9, r
        OUT &H3C9, g
        OUT &H3C9, b
     NEXT
CLOSE #FR

END SUB

SUB Rel.PrintDisco (DestSeg%, DestOff%, Xpos%, Ypos%, Text$, col%, xscale%, yscale%, Luty%(), Lsin1%(), Lsin2%(), Lsin3%())
STATIC Counter%, Countdir%, FirstTime%
IF FirstTime% = 0 THEN
    Counter% = 0
    Countdir = 1
    FirstTime = -1
END IF

x% = Xpos%
y% = Ypos%
Spacing% = 8
  FOR i% = 0 TO LEN(Text$) - 1
    x% = x% + Spacing% * xscale
    offset% = 8 * ASC(MID$(Text$, i% + 1, 1)) + 14
    FOR j% = 0 TO 7
      DEF SEG = &HFFA6
      Bit% = PEEK(offset% + j%)
      DEF SEG = DestSeg%
      IF Bit% AND 1 THEN
        ty1% = y% + j * yscale%
        tx1% = x%
        ty2% = ty1% + yscale%
        tx2% = tx1% + xscale%
        Clr% = col% + j%
        Rel.BoxF DestSeg%, DestOff%, tx1%, ty1%, tx2%, ty2%, Clr%, Luty%()
      END IF
      IF Bit% AND 2 THEN
        ty1% = y% + j% * yscale%
        tx1% = x% - 1 * xscale%
        ty2% = ty1% + yscale%
        tx2% = tx1% + xscale%
        Clr% = col% + j%
        Rel.BoxF DestSeg%, DestOff%, tx1%, ty1%, tx2%, ty2%, Clr%, Luty%()
      END IF
      IF Bit% AND 4 THEN
        ty1% = y% + j% * yscale%
        tx1% = x% - 2 * xscale%
        ty2% = ty1% + yscale%
        tx2% = tx1% + xscale%
        Clr% = col% + j%
        Rel.BoxF DestSeg%, DestOff%, tx1%, ty1%, tx2%, ty2%, Clr%, Luty%()
      END IF
      IF Bit% AND 8 THEN
        ty1% = y% + j% * yscale%
        tx1% = x% - 3 * xscale%
        ty2% = ty1% + yscale%
        tx2% = tx1% + xscale%
        Clr% = col% + j%
        Rel.BoxF DestSeg%, DestOff%, tx1%, ty1%, tx2%, ty2%, Clr%, Luty%()
      END IF
      IF Bit% AND 16 THEN
        ty1% = y% + j% * yscale%
        tx1% = x% - 4 * xscale%
        ty2% = ty1% + yscale%
        tx2% = tx1% + xscale%
        Clr% = col% + j%
        Rel.BoxF DestSeg%, DestOff%, tx1%, ty1%, tx2%, ty2%, Clr%, Luty%()
      END IF
      IF Bit% AND 32 THEN
        ty1% = y% + j% * yscale%
        tx1% = x% - 5 * xscale%
        ty2% = ty1% + yscale%
        tx2% = tx1% + xscale%
        Clr% = col% + j%
        Rel.BoxF DestSeg%, DestOff%, tx1%, ty1%, tx2%, ty2%, Clr%, Luty%()
      END IF
      IF Bit% AND 64 THEN
        ty1% = y% + j% * yscale%
        tx1% = x% - 6 * xscale%
        ty2% = ty1% + yscale%
        tx2% = tx1% + xscale%
        Clr% = col% + j%
        Rel.BoxF DestSeg%, DestOff%, tx1%, ty1%, tx2%, ty2%, Clr%, Luty%()
      END IF
      IF Bit% AND 128 THEN
        ty1% = y% + j% * yscale%
        tx1% = x% - 7 * xscale%
        ty2% = ty1% + yscale%
        tx2% = tx1% + xscale%
        Clr% = col% + j%
        Rel.BoxF DestSeg%, DestOff%, tx1%, ty1%, tx2%, ty2%, Clr%, Luty%()
      END IF
    NEXT j%
  NEXT i%

    Counter% = (Counter% + Countdir%)
    IF Counter% < -700 THEN
        Countdir% = -Countdir%
    ELSEIF Counter% > 900 THEN
        Countdir% = -Countdir%
    END IF

    Poff% = DestOff%
    FOR ya% = 0 TO 125
        ysin% = Lsin1%(ya% - Counter%)
    FOR xa% = 0 TO 255
        pix% = PEEK(Poff%)
        IF pix% THEN
            c% = Lsin3%(xa% - Counter%) + ysin% + Lsin2%(ya% + xa%) + Lsin3%(ysin%)
            POKE Poff%, c%
        END IF
        Poff% = Poff% + 1
    NEXT xa%
    NEXT ya%

DEF SEG = DestSeg%

END SUB

SUB Rel.PrintScale (DestSeg%, DestOff%, Xpos%, Ypos%, Text$, col%, xscale%, yscale%, Luty%())

x% = Xpos%
y% = Ypos%
Spacing% = 8
  FOR i% = 0 TO LEN(Text$) - 1
    x% = x% + Spacing% * xscale
    offset% = 8 * ASC(MID$(Text$, i% + 1, 1)) + 14
    FOR j% = 0 TO 7
      DEF SEG = &HFFA6
      Bit% = PEEK(offset% + j%)
      DEF SEG = DestSeg%
      IF Bit% AND 1 THEN
        ty1% = y% + j * yscale%
        tx1% = x%
        ty2% = ty1% + yscale%
        tx2% = tx1% + xscale%
        Clr% = col% + j%
        Rel.BoxF DestSeg%, DestOff%, tx1%, ty1%, tx2%, ty2%, Clr%, Luty%()
      END IF
      IF Bit% AND 2 THEN
        ty1% = y% + j% * yscale%
        tx1% = x% - 1 * xscale%
        ty2% = ty1% + yscale%
        tx2% = tx1% + xscale%
        Clr% = col% + j%
        Rel.BoxF DestSeg%, DestOff%, tx1%, ty1%, tx2%, ty2%, Clr%, Luty%()
      END IF
      IF Bit% AND 4 THEN
        ty1% = y% + j% * yscale%
        tx1% = x% - 2 * xscale%
        ty2% = ty1% + yscale%
        tx2% = tx1% + xscale%
        Clr% = col% + j%
        Rel.BoxF DestSeg%, DestOff%, tx1%, ty1%, tx2%, ty2%, Clr%, Luty%()
      END IF
      IF Bit% AND 8 THEN
        ty1% = y% + j% * yscale%
        tx1% = x% - 3 * xscale%
        ty2% = ty1% + yscale%
        tx2% = tx1% + xscale%
        Clr% = col% + j%
        Rel.BoxF DestSeg%, DestOff%, tx1%, ty1%, tx2%, ty2%, Clr%, Luty%()
      END IF
      IF Bit% AND 16 THEN
        ty1% = y% + j% * yscale%
        tx1% = x% - 4 * xscale%
        ty2% = ty1% + yscale%
        tx2% = tx1% + xscale%
        Clr% = col% + j%
        Rel.BoxF DestSeg%, DestOff%, tx1%, ty1%, tx2%, ty2%, Clr%, Luty%()
      END IF
      IF Bit% AND 32 THEN
        ty1% = y% + j% * yscale%
        tx1% = x% - 5 * xscale%
        ty2% = ty1% + yscale%
        tx2% = tx1% + xscale%
        Clr% = col% + j%
        Rel.BoxF DestSeg%, DestOff%, tx1%, ty1%, tx2%, ty2%, Clr%, Luty%()
      END IF
      IF Bit% AND 64 THEN
        ty1% = y% + j% * yscale%
        tx1% = x% - 6 * xscale%
        ty2% = ty1% + yscale%
        tx2% = tx1% + xscale%
        Clr% = col% + j%
        Rel.BoxF DestSeg%, DestOff%, tx1%, ty1%, tx2%, ty2%, Clr%, Luty%()
      END IF
      IF Bit% AND 128 THEN
        ty1% = y% + j% * yscale%
        tx1% = x% - 7 * xscale%
        ty2% = ty1% + yscale%
        tx2% = tx1% + xscale%
        Clr% = col% + j%
        Rel.BoxF DestSeg%, DestOff%, tx1%, ty1%, tx2%, ty2%, Clr%, Luty%()
      END IF
    NEXT j%
  NEXT i%

END SUB

SUB Rel.ReadPal (PalString$) STATIC
'Reads the current palette and puts it to a 768 byte string
'palstring$, use this if you loaded the pal from a pp256 format

TempPal$ = SPACE$(768)

OUT &H3C7, 0
FOR i% = 0 TO 255
  MID$(TempPal$, (i% * 3) + 1, 1) = CHR$(INP(&H3C9))
  MID$(TempPal$, (i% * 3) + 2, 1) = CHR$(INP(&H3C9))
  MID$(TempPal$, (i% * 3) + 3, 1) = CHR$(INP(&H3C9))
NEXT i%

PalString$ = TempPal$

END SUB

SUB Rel.ReadRGB (ColorVal, r, g, b) STATIC
'Reads the RGB values of the color and puts them to R,G, and B.
        OUT &H3C7, ColorVal
        r = INP(&H3C9)
        g = INP(&H3C9)
        b = INP(&H3C9)

END SUB

SUB Rel.Sprite (Layer%, LayerOffs%, x%, y%, sprite(), SpriteOffset, GammaDisp%, Ly%())

'returns default segment to the layer after pass

oxsize% = sprite(SpriteOffset) \ 8
oysize% = sprite(SpriteOffset + 1)
xsize% = oxsize%
ysize% = oysize%
newx% = x%
newy% = y%

SprSeg% = VARSEG(sprite(SpriteOffset))
SprOff% = VARPTR(sprite(SpriteOffset + 2))

'Clip/Crop it

IF newy% < 0 THEN
        cy% = -newy%
        ysize% = ysize% - cy%
        newy% = 0
        SprOff% = SprOff% + (cy% * oxsize%)
ELSEIF newy% > 125 THEN
        EXIT SUB
ELSE
        ndy% = newy% + oysize%
        IF ndy% > 125 THEN
                ysize% = ysize% - (ndy% - (126))
        END IF
END IF

IF newx% < 0 THEN
        cx = -newx%
        xsize% = xsize% - cx%
        newx% = 0
        SprOff% = SprOff% + cx%
ELSEIF newx% > 255 THEN
        EXIT SUB
ELSE
        ndx% = newx% + oxsize%
        IF ndx% > 255 THEN
                xsize% = xsize% - (ndx% - 256)
        END IF
END IF

BuffSeg% = Layer%
StartPageOff% = Ly%(newy%) + newx% + LayerOffs%

IF GammaDisp% = 0 THEN
    FOR ya% = 0 TO ysize% - 1
    FOR xa% = 0 TO xsize% - 1
            DEF SEG = SprSeg%
            c% = PEEK(SprOff + xa)
            IF c% THEN
                    DEF SEG = BuffSeg%
                    POKE StartPageOff% + xa%, c%
            END IF
    NEXT xa%
            StartPageOff% = StartPageOff% + 256
            SprOff% = SprOff% + oxsize%
    NEXT ya%
ELSE        'Gamma
    FOR ya% = 0 TO ysize% - 1
    FOR xa% = 0 TO xsize% - 1
            DEF SEG = SprSeg%
            c% = PEEK(SprOff + xa)
            IF c% THEN
                    DEF SEG = BuffSeg%
                    tc% = c% AND 15
                    bc% = c% - tc%
                    tc% = (tc% + GammaDisp%) + tc%
                    IF tc% < bc% THEN
                            tc% = bc%
                    ELSEIF tc% > bc% + 15 THEN
                            tc% = bc% + 15
                    END IF
                    POKE StartPageOff% + xa%, tc%
            END IF
    NEXT xa%
            StartPageOff% = StartPageOff% + 256
            SprOff% = SprOff% + oxsize%
    NEXT ya%

END IF

DEF SEG = Layer%

END SUB

SUB Rel.WriteRGB (ColorNum, r, g, b) STATIC
'Writes the R,G and B values to the color Attribute changing its value.

        OUT &H3C8, ColorNum
        OUT &H3C9, r
        OUT &H3C9, g
        OUT &H3C9, b

END SUB

SUB ScalePlg (Model() AS Point3d, ScaleFactor!)
NumPoints = UBOUND(Model)
FOR p = 1 TO NumPoints
    Model(p).x = Model(p).x * ScaleFactor!
    Model(p).y = Model(p).y * ScaleFactor!
    Model(p).z = Model(p).z * ScaleFactor!
NEXT p

END SUB

SUB SetPolyBaseColor (Poly() AS PolyType)
    FOR i% = 1 TO UBOUND(Poly)
        c% = ((c% MOD 15) + 1) * 16
        Poly(i%).clr1 = c%
        Poly(i%).clr2 = c%
        Poly(i%).clr3 = c%
        i% = i% + 1
        Poly(i%).clr1 = c%
        Poly(i%).clr2 = c%
        Poly(i%).clr3 = c%
    NEXT i%

END SUB

SUB Smooth (Dest%, Doffs%, Ly%(), div4%(), div8%(), div16%(), passes%)
DEF SEG = Dest%
FOR j% = 1 TO passes%
    offs% = 256 + Doffs%
    FOR i% = 256 TO 32256 - 256
        corners% = div16%(PEEK(offs% - 257) + PEEK(offs% - 255) + PEEK(offs% + 257) + PEEK(offs% + 255))
        sides% = div8%(PEEK(offs% - 256) + PEEK(offs% - 1) + PEEK(offs% + 256) + PEEK(offs% + 1))
        center% = div4%(PEEK(offs%))
        px1% = (corners% + sides% + center%)
        POKE offs%, px1%
        offs% = offs% + 1
    NEXT i%
NEXT j%

END SUB

SUB SortIndex (Poly() AS PolyType, Min, Max)
    'Shell sort Algorithm
    ' Set comparison offset to half the number of records.
    offset = Max \ 2

    ' Loop until offset gets to zero.
    DO WHILE offset > 0

        Limit = Max - offset

        DO

            ' Assume no switches at this offset.
            Switch = FALSE

            ' Compare elements for the specified field and switch
            ' any that are out of order.
            FOR i = Min TO Limit - 1
                Ti = Poly(i).Zorder
                Tj = Poly(i + offset).Zorder
                        IF Ti < Tj THEN
                            SWAP Poly(i).Zorder, Poly(i + offset).Zorder
                            SWAP Poly(i).idx, Poly(i + offset).idx
                            Switch = i
                        END IF

            NEXT i

            ' Sort on next pass only to location where last switch was made.
            Limit = Switch

        LOOP WHILE Switch

        ' No switches at last offset. Try an offset half as big.
        offset = offset \ 2
    LOOP


END SUB

SUB SortPolys (Model() AS Point3d, Poly() AS PolyType)

 FOR i% = 1 TO UBOUND(Poly)
  Poly(i%).Zorder = Model(Poly(i%).p1).zr + Model(Poly(i%).p2).zr + Model(Poly(i%).p3).zr
  Poly(i%).idx = i%
 NEXT i%
 SortIndex Poly(), 1, UBOUND(Poly)

END SUB

FUNCTION Texter$ (Index%)
STATIC FirstTime%, Txt$()

IF FirstTime% = 0 THEN
    DIM Txt$(182)
    Txt$(0) = "My very first demo ;*)"
    Txt$(1) = "Greetings to..."
    Txt$(2) = ""
    Txt$(3) = "GOD"
    Txt$(4) = "...for making me what I am today"
    Txt$(5) = ""
    Txt$(6) = "Anya Therese B. Lope"
    Txt$(7) = "...my lovely daughter"
    Txt$(8) = ""
    Txt$(9) = "Rosmelly B. Lope"
    Txt$(10) = "...my even lovelier wife"
    Txt$(11) = ""
    Txt$(12) = "Peter and Lily Lope"
    Txt$(13) = "...thanks for everything mom and dad!!!"
    Txt$(14) = ""
    Txt$(15) = "Marie and Cristina Lope"
    Txt$(16) = "...my sisters"
    Txt$(17) = ""
    Txt$(18) = "Jofers/Toonski"
    Txt$(19) = "...;*)too many words are needed"
    Txt$(20) = ""
    Txt$(21) = "Jocke the Beast"
    Txt$(22) = "...;*) You have the right to remain silent!"
    Txt$(23) = ""
    Txt$(24) = "Hexadecimal Disaster"
    Txt$(25) = "...where art thou bro?"
    Txt$(26) = ""
    Txt$(27) = "Adigun A. Polack"
    Txt$(28) = "...We'll finish FJ. That's for sure."
    Txt$(29) = ""
    Txt$(30) = "Achmad Aulia"
    Txt$(31) = "...Your 3d tut will come"
    Txt$(32) = ""
    Txt$(33) = "Dav"
    Txt$(34) = "...keep the 'guerrila' coding spirit alive"
    Txt$(35) = ""
    Txt$(36) = "Toshi Horie"
    Txt$(37) = "...for all the help he gave me"
    Txt$(38) = ""
    Txt$(39) = "Plasma 357"
    Txt$(40) = "...setvideoseg is better than any lib."
    Txt$(41) = ""
    Txt$(42) = "Nex,Binary Shock, Jake and species"
    Txt$(43) = "...When are you going to update?"
    Txt$(44) = ""
    Txt$(45) = "Giancarlo Berardi"
    Txt$(46) = "...We need GBgames"
    Txt$(47) = ""
    Txt$(48) = "Vance Velez"
    Txt$(49) = "...When are we gonna see QBBA?"
    Txt$(50) = ""
    Txt$(51) = "Nathan"
    Txt$(52) = "...Pigs in bikini!!!"
    Txt$(53) = ""
    Txt$(54) = "Cgi Joe/Generic"
    Txt$(55) = "...for the original algo in my poly fillers"
    Txt$(56) = ""
    Txt$(57) = "Blitz and v1ctor"
    Txt$(58) = "...we need that MOD player badly"
    Txt$(59) = ""
    Txt$(60) = "Pasco and Leroy"
    Txt$(61) = "...read the mockumentary lately?"
    Txt$(62) = ""
    Txt$(63) = "Antoni Gual"
    Txt$(64) = "...the link paved the way for this"
    Txt$(65) = ""
    Txt$(66) = "Entrophy"
    Txt$(67) = "...learned a lot from your demos"
    Txt$(68) = ""
    Txt$(69) = "Biskbart"
    Txt$(70) = "...yours too"
    Txt$(71) = ""
    Txt$(72) = "Qasir"
    Txt$(73) = "...ditto"
    Txt$(74) = ""
    Txt$(75) = "Optimus"
    Txt$(76) = "...yeah, you too"
    Txt$(77) = ""
    Txt$(78) = "Dean Janjic/Lachie"
    Txt$(79) = "...makes some of the best Rellib products!!"
    Txt$(80) = ""
    Txt$(81) = "Radioman"
    Txt$(82) = "...thought AF.Lib was dead until you came"
    Txt$(80) = ""
    Txt$(83) = "wildcard"
    Txt$(84) = "...you kept this community afloat"
    Txt$(85) = ""
    Txt$(86) = "Joakim A.R."
    Txt$(87) = "...;*)"
    Txt$(88) = ""
    Txt$(89) = "Piptol"
    Txt$(90) = "...come back to qb dude!!!"
    Txt$(91) = ""
    Txt$(92) = "Citpes"
    Txt$(93) = "...finish that cool platformer"
    Txt$(94) = ""
    Txt$(95) = "wizardlyf"
    Txt$(96) = "...don't forget to send me the CD"
    Txt$(97) = ""
    Txt$(98) = "Chris Chadwick"
    Txt$(99) = "...for PP256"
    Txt$(100) = ""
    Txt$(101) = "Glenn Stumpff"
    Txt$(102) = "...for all the help"
    Txt$(103) = ""
    Txt$(104) = "Andre Brown/Kack"
    Txt$(105) = "...;*)"
    Txt$(106) = ""
    Txt$(107) = "FlingMaster"
    Txt$(108) = "...for updating Qbasicnews.com often"
    Txt$(109) = ""
    Txt$(110) = "Peter Van Zwol"
    Txt$(111) = "...don't forget to send me your RTS"
    Txt$(112) = ""
    Txt$(113) = "Sir Toad and JtM"
    Txt$(114) = "...I miss BCP"
    Txt$(115) = ""
    Txt$(116) = "Vincent Francis Lorena"
    Txt$(117) = "...study hard"
    Txt$(118) = ""
    Txt$(119) = "Ben John Quintos"
    Txt$(120) = "...ang CD ko?"
    Txt$(121) = ""
    Txt$(122) = "Hard Rock"
    Txt$(123) = "...thanks for the RelLib online help"
    Txt$(124) = ""
    Txt$(125) = "Lithium"
    Txt$(126) = "...hang in there dude!!!"
    Txt$(127) = ""
    Txt$(128) = "Sterling Christensen"
    Txt$(129) = "...Hope I spelled it right. ;*)"
    Txt$(130) = ""
    Txt$(131) = "Hugo Elias"
    Txt$(132) = "...You taught me through your tuts."
    Txt$(133) = ""
    Txt$(134) = "Oracle"
    Txt$(135) = "...Host this or else..."
    Txt$(136) = ""
    Txt$(137) = "Neo"
    Txt$(138) = "...;*)"
    Txt$(139) = ""
    Txt$(140) = "Agamemnus"
    Txt$(141) = "...;*)"
    Txt$(142) = ""
    Txt$(143) = "Ninkazu"
    Txt$(144) = "...All depends on the attitude effect"
    Txt$(145) = ""
    Txt$(146) = "Typosoft"
    Txt$(147) = "...how's c?"
    Txt$(148) = ""
    Txt$(149) = "Jark"
    Txt$(150) = "...Those Quadric shapes are just awesome!!!"
    Txt$(151) = ""
    Txt$(152) = "Megaman"
    Txt$(153) = "...I see the sprite in BG?"
    Txt$(154) = ""
    Txt$(155) = "Moneo"
    Txt$(156) = "...;*)"
    Txt$(157) = ""
    Txt$(158) = "Mango"
    Txt$(159) = "...:*)"
    Txt$(160) = "Meg"
    Txt$(161) = "...:*)"
    Txt$(162) = ""
    Txt$(163) = "James Robert Osborne"
    Txt$(164) = "...that mode7 tut came in handy"
    Txt$(165) = ""
    Txt$(166) = "Pls. visit my site..."
    Txt$(167) = "Rel.Betterwebber.com"
    Txt$(168) = "...for some nice proggies"
    Txt$(169) = "...and games"
    Txt$(170) = ""
    Txt$(171) = "ciao!!!! Relsoft 2003"
    Txt$(172) = "vic_viperph@yahoo.com"
    Txt$(173) = "polacka.xepher.net"
    Txt$(174) = "auraflow.curvehead.com"
    Txt$(175) = "qbasicnews.com"
    Txt$(176) = ""
    Txt$(177) = "This demo is made using QB4.5"
    Txt$(178) = "No ASM and no Libs are used to make"
    Txt$(179) = "any effect."
    Txt$(180) = ""
    Txt$(181) = "Use or abuse"
    Txt$(182) = "Code is provided as is."
    FirstTime% = -1
END IF

Texter$ = Txt$(Index%)

END FUNCTION

SUB Zeropal
    FOR i% = 0 TO 255
        OUT &H3C8, i%
        OUT &H3C9, 0
        OUT &H3C9, 0
        OUT &H3C9, 0
    NEXT i%
END SUB

