#pragma once
#include "GetValueForm.h"
#include "BytePatternsEditor.h"
#include "CodeGen.h"
#include "FreqAnalyzer.h"
#include "OutputAnalyzer.h"
#include "InstrumentEditor.h"
#include "AboutBox.h"
#define MessageBoxA MessageBox
#define GetObjectA GetObject

extern "C" void _check_commonlanguageruntime_version(){}

// File structures
struct FileHeader {
	int   magicWord;
	int   version;
	float masterVolume;
	int	  bpm;
	int   startSeq;
	int   endSeq;
	char  looping;
	char  unused[128];
};

namespace Buzzic
{
	using namespace System;
	using namespace System::ComponentModel;
	using namespace System::Collections;
	using namespace System::Windows::Forms;
	using namespace System::Data;
	using namespace System::Drawing;
	using namespace System::Text;
	using namespace System::Runtime::InteropServices;

	/// <summary> 
	/// Summary for Form1
	///
	/// WARNING: If you change the name of this class, you will need to change the 
	///          'Resource File Name' property for the managed resource compiler tool 
	///          associated with all .resx files this class depends on.  Otherwise,
	///          the designers will not be able to interact properly with localized
	///          resources associated with this form.
	/// </summary>
	public __gc class Form1 : public System::Windows::Forms::Form
	{	
	private:
		const static int CELL_X = 60;
		const static int CELL_Y = 16;
		int startSeq;
		int endSeq;
		System::Drawing::Point byteFocus;
		System::Drawing::Point selectionDragStart;
		System::Drawing::Point selectionStart;
		System::Drawing::Point selectionEnd;
		System::String* byteSequenceNames[];
		bool stopPlaying;
		String* currentFile;
		System::Threading::Thread* playThread;
		float maxSampleVol, maxMasterVol;
		FreqAnalyzer* freqAnalyzer;
		OutputAnalyzer* outAnalyzer;
		bool writeToWAV;
		int wavSize;


	private: System::Windows::Forms::Button *  btnPlay;
	private: System::Windows::Forms::OpenFileDialog *  openFileDialog1;
	private: System::Windows::Forms::SaveFileDialog *  saveFileDialog1;
	private: System::Windows::Forms::MenuItem *  menuItem10;
	private: System::Windows::Forms::ImageList *  imageList1;
	private: System::Windows::Forms::CheckBox *  cbLooping;
	private: System::Windows::Forms::MenuItem *  menuItem11;
	private: System::Windows::Forms::MenuItem *  menuItem12;
	private: System::Windows::Forms::MenuItem *  menuItem13;
	private: System::Windows::Forms::MenuItem *  menuItem14;
	private: System::Windows::Forms::Label *  lblSoundInfo;
	private: System::Windows::Forms::MenuItem *  menuItem15;
	private: System::Windows::Forms::MenuItem *  menuItem16;
	private: System::Windows::Forms::MenuItem *  menuItemFreqAn;
	private: System::Windows::Forms::MenuItem *  menuItemAnOut;
	private: System::Windows::Forms::MenuItem *  menuItem17;
	private: System::Windows::Forms::MenuItem *  menuItem18;
	private: System::Windows::Forms::HScrollBar *  byteScrollHor;
	private: System::Windows::Forms::MenuItem *  menuItem19;
	private: System::Windows::Forms::MenuItem *  menuItem20;
	private: System::Windows::Forms::MenuItem *  menuItem21;
	private: System::Windows::Forms::MenuItem *  menuItem22;
	private: System::Windows::Forms::MenuItem *  menuItem23;
	private: System::Windows::Forms::MenuItem *  menuItem24;
	private: System::Windows::Forms::MenuItem *  menuItem25;
	private: System::Windows::Forms::MenuItem *  menuItem26;
	private: System::Windows::Forms::MenuItem *  menuItem27;
	private: System::Windows::Forms::SaveFileDialog *  saveFileDialog2;
	private: System::Windows::Forms::Label *  lblWAVWrite;

	private: System::Windows::Forms::VScrollBar *  byteScroll;
			 
	public:
		Form1(void)
		{
			InitializeComponent();
			byteScroll->Maximum = MAX_TEMPLATE_MELODY_LEN;
			byteFocus = System::Drawing::Point ( -1, -1 );
			selectionStart = selectionEnd = selectionDragStart = System::Drawing::Point ( -1, -1 );
			panelByte->add_KeyPress ( new KeyPressEventHandler ( this, panelByte_KeyPressEventHandler ) );
			panelByte->add_KeyDown ( new KeyEventHandler ( this, panelByte_KeyDownEventHandler ) );
			byteSequenceNames = new String*[MAX_SEQUENCES];
			InitializeCriticalSection ( &g_anCs );
			InitializeCriticalSection ( &g_stackCs );
		}
  
	protected:
		void Dispose(Boolean disposing)
		{
			if (disposing && components)
			{
				components->Dispose();
			}
			if ( disposing ) {
				DeleteCriticalSection ( &g_anCs );
				DeleteCriticalSection ( &g_stackCs );
			}
			__super::Dispose(disposing);
		}
	private: System::Windows::Forms::MainMenu *  mainMenu1;
	private: System::Windows::Forms::MenuItem *  menuItem1;
	private: System::Windows::Forms::MenuItem *  menuItem2;
	private: System::Windows::Forms::MenuItem *  menuItem3;
	private: System::Windows::Forms::MenuItem *  menuItem4;
	private: System::Windows::Forms::MenuItem *  menuItem5;

	private: System::Windows::Forms::Panel *  panelInstruments;
	private: System::Windows::Forms::Splitter *  splitter1;
	private: System::Windows::Forms::Panel *  panelSequences;

	private: System::Windows::Forms::MenuItem *  menuItem6;
	private: System::Windows::Forms::MenuItem *  menuItem7;
	private: System::Windows::Forms::MenuItem *  menuItem8;
	private: System::Windows::Forms::MenuItem *  menuItem9;
	private: System::Windows::Forms::GroupBox *  groupBoxInstruments;


	private: System::Windows::Forms::Timer *  timer1;
	private: System::Windows::Forms::Panel *  panelToolBar;
	private: System::Windows::Forms::GroupBox *  groupBoxSequences;
	private: System::Windows::Forms::Label *  lblBPM;
	private: System::Windows::Forms::NumericUpDown *  dfBPM;
	private: System::Windows::Forms::Label *  lblVolume;
	private: System::Windows::Forms::HScrollBar *  sbVolume;
	private: System::Windows::Forms::Panel *  panelByteStreams;






	private: System::Windows::Forms::Panel *  panelByte;



	private: System::Windows::Forms::ToolTip *  toolTip1;



	private: System::Windows::Forms::Button *  btnBytePatterns;
	private: System::Windows::Forms::Button *  btnRemoveByteSequence;
	private: System::Windows::Forms::Button *  btnAddByteSequence;
	private: System::Windows::Forms::Label *  lblBytePatterns;
	private: System::Windows::Forms::Label *  lblRowLen;


	private: System::ComponentModel::IContainer *  components;


	private:
		/// <summary>
		/// Required designer variable.
		/// </summary>


		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		void InitializeComponent(void)
		{
			this->components = new System::ComponentModel::Container();
			System::Resources::ResourceManager *  resources = new System::Resources::ResourceManager(__typeof(Buzzic::Form1));
			this->mainMenu1 = new System::Windows::Forms::MainMenu();
			this->menuItem1 = new System::Windows::Forms::MenuItem();
			this->menuItem3 = new System::Windows::Forms::MenuItem();
			this->menuItem4 = new System::Windows::Forms::MenuItem();
			this->menuItem10 = new System::Windows::Forms::MenuItem();
			this->menuItem5 = new System::Windows::Forms::MenuItem();
			this->menuItem2 = new System::Windows::Forms::MenuItem();
			this->menuItem11 = new System::Windows::Forms::MenuItem();
			this->menuItem12 = new System::Windows::Forms::MenuItem();
			this->menuItem13 = new System::Windows::Forms::MenuItem();
			this->menuItem23 = new System::Windows::Forms::MenuItem();
			this->menuItem24 = new System::Windows::Forms::MenuItem();
			this->menuItem25 = new System::Windows::Forms::MenuItem();
			this->menuItem26 = new System::Windows::Forms::MenuItem();
			this->menuItem6 = new System::Windows::Forms::MenuItem();
			this->menuItem7 = new System::Windows::Forms::MenuItem();
			this->menuItem8 = new System::Windows::Forms::MenuItem();
			this->menuItem9 = new System::Windows::Forms::MenuItem();
			this->menuItem14 = new System::Windows::Forms::MenuItem();
			this->menuItem17 = new System::Windows::Forms::MenuItem();
			this->menuItem18 = new System::Windows::Forms::MenuItem();
			this->menuItem21 = new System::Windows::Forms::MenuItem();
			this->menuItem22 = new System::Windows::Forms::MenuItem();
			this->menuItem16 = new System::Windows::Forms::MenuItem();
			this->menuItem15 = new System::Windows::Forms::MenuItem();
			this->menuItemFreqAn = new System::Windows::Forms::MenuItem();
			this->menuItemAnOut = new System::Windows::Forms::MenuItem();
			this->menuItem27 = new System::Windows::Forms::MenuItem();
			this->menuItem19 = new System::Windows::Forms::MenuItem();
			this->menuItem20 = new System::Windows::Forms::MenuItem();
			this->groupBoxInstruments = new System::Windows::Forms::GroupBox();
			this->panelInstruments = new System::Windows::Forms::Panel();
			this->splitter1 = new System::Windows::Forms::Splitter();
			this->panelSequences = new System::Windows::Forms::Panel();
			this->groupBoxSequences = new System::Windows::Forms::GroupBox();
			this->panelByteStreams = new System::Windows::Forms::Panel();
			this->lblBytePatterns = new System::Windows::Forms::Label();
			this->btnBytePatterns = new System::Windows::Forms::Button();
			this->imageList1 = new System::Windows::Forms::ImageList(this->components);
			this->panelByte = new MyPanel();
			this->byteScrollHor = new System::Windows::Forms::HScrollBar();
			this->byteScroll = new System::Windows::Forms::VScrollBar();
			this->btnRemoveByteSequence = new System::Windows::Forms::Button();
			this->btnAddByteSequence = new System::Windows::Forms::Button();
			this->panelToolBar = new System::Windows::Forms::Panel();
			this->lblSoundInfo = new System::Windows::Forms::Label();
			this->cbLooping = new System::Windows::Forms::CheckBox();
			this->btnPlay = new System::Windows::Forms::Button();
			this->lblRowLen = new System::Windows::Forms::Label();
			this->sbVolume = new System::Windows::Forms::HScrollBar();
			this->lblVolume = new System::Windows::Forms::Label();
			this->dfBPM = new System::Windows::Forms::NumericUpDown();
			this->lblBPM = new System::Windows::Forms::Label();
			this->timer1 = new System::Windows::Forms::Timer(this->components);
			this->toolTip1 = new System::Windows::Forms::ToolTip(this->components);
			this->openFileDialog1 = new System::Windows::Forms::OpenFileDialog();
			this->saveFileDialog1 = new System::Windows::Forms::SaveFileDialog();
			this->saveFileDialog2 = new System::Windows::Forms::SaveFileDialog();
			this->lblWAVWrite = new System::Windows::Forms::Label();
			this->panelInstruments->SuspendLayout();
			this->panelSequences->SuspendLayout();
			this->groupBoxSequences->SuspendLayout();
			this->panelByteStreams->SuspendLayout();
			this->panelByte->SuspendLayout();
			this->panelToolBar->SuspendLayout();
			(__try_cast<System::ComponentModel::ISupportInitialize *  >(this->dfBPM))->BeginInit();
			this->SuspendLayout();
			// 
			// mainMenu1
			// 
			System::Windows::Forms::MenuItem* __mcTemp__1[] = new System::Windows::Forms::MenuItem*[5];
			__mcTemp__1[0] = this->menuItem1;
			__mcTemp__1[1] = this->menuItem11;
			__mcTemp__1[2] = this->menuItem6;
			__mcTemp__1[3] = this->menuItem16;
			__mcTemp__1[4] = this->menuItem19;
			this->mainMenu1->MenuItems->AddRange(__mcTemp__1);
			// 
			// menuItem1
			// 
			this->menuItem1->Index = 0;
			System::Windows::Forms::MenuItem* __mcTemp__2[] = new System::Windows::Forms::MenuItem*[5];
			__mcTemp__2[0] = this->menuItem3;
			__mcTemp__2[1] = this->menuItem4;
			__mcTemp__2[2] = this->menuItem10;
			__mcTemp__2[3] = this->menuItem5;
			__mcTemp__2[4] = this->menuItem2;
			this->menuItem1->MenuItems->AddRange(__mcTemp__2);
			this->menuItem1->Text = S"&File";
			// 
			// menuItem3
			// 
			this->menuItem3->Index = 0;
			this->menuItem3->Shortcut = System::Windows::Forms::Shortcut::CtrlO;
			this->menuItem3->Text = S"&Open...";
			this->menuItem3->Click += new System::EventHandler(this, menuItem3_Click);
			// 
			// menuItem4
			// 
			this->menuItem4->Index = 1;
			this->menuItem4->Shortcut = System::Windows::Forms::Shortcut::CtrlS;
			this->menuItem4->Text = S"&Save";
			this->menuItem4->Click += new System::EventHandler(this, menuItem4_Click);
			// 
			// menuItem10
			// 
			this->menuItem10->Index = 2;
			this->menuItem10->Text = S"Save &As...";
			this->menuItem10->Click += new System::EventHandler(this, menuItem10_Click);
			// 
			// menuItem5
			// 
			this->menuItem5->Index = 3;
			this->menuItem5->Text = S"-";
			// 
			// menuItem2
			// 
			this->menuItem2->Index = 4;
			this->menuItem2->Text = S"E&xit";
			this->menuItem2->Click += new System::EventHandler(this, menuItem2_Click);
			// 
			// menuItem11
			// 
			this->menuItem11->Index = 1;
			System::Windows::Forms::MenuItem* __mcTemp__3[] = new System::Windows::Forms::MenuItem*[6];
			__mcTemp__3[0] = this->menuItem12;
			__mcTemp__3[1] = this->menuItem13;
			__mcTemp__3[2] = this->menuItem23;
			__mcTemp__3[3] = this->menuItem24;
			__mcTemp__3[4] = this->menuItem25;
			__mcTemp__3[5] = this->menuItem26;
			this->menuItem11->MenuItems->AddRange(__mcTemp__3);
			this->menuItem11->Text = S"&Sequence";
			// 
			// menuItem12
			// 
			this->menuItem12->Index = 0;
			this->menuItem12->Shortcut = System::Windows::Forms::Shortcut::CtrlI;
			this->menuItem12->Text = S"&Insert Pattern";
			this->menuItem12->Click += new System::EventHandler(this, menuItem12_Click);
			// 
			// menuItem13
			// 
			this->menuItem13->Index = 1;
			this->menuItem13->Shortcut = System::Windows::Forms::Shortcut::CtrlD;
			this->menuItem13->Text = S"&Delete Pattern";
			this->menuItem13->Click += new System::EventHandler(this, menuItem13_Click);
			// 
			// menuItem23
			// 
			this->menuItem23->Index = 2;
			this->menuItem23->Shortcut = System::Windows::Forms::Shortcut::CtrlC;
			this->menuItem23->Text = S"&Copy Selection";
			this->menuItem23->Click += new System::EventHandler(this, menuItem23_Click);
			// 
			// menuItem24
			// 
			this->menuItem24->Index = 3;
			this->menuItem24->Shortcut = System::Windows::Forms::Shortcut::CtrlV;
			this->menuItem24->Text = S"&Paste Selection";
			this->menuItem24->Click += new System::EventHandler(this, menuItem24_Click);
			// 
			// menuItem25
			// 
			this->menuItem25->Index = 4;
			this->menuItem25->Text = S"Insert Row (Ctrl+Ins)";
			this->menuItem25->Click += new System::EventHandler(this, menuItem25_Click);
			// 
			// menuItem26
			// 
			this->menuItem26->Index = 5;
			this->menuItem26->Text = S"Delete Row (Ctrl+Del)";
			this->menuItem26->Click += new System::EventHandler(this, menuItem26_Click);
			// 
			// menuItem6
			// 
			this->menuItem6->Index = 2;
			System::Windows::Forms::MenuItem* __mcTemp__4[] = new System::Windows::Forms::MenuItem*[8];
			__mcTemp__4[0] = this->menuItem7;
			__mcTemp__4[1] = this->menuItem8;
			__mcTemp__4[2] = this->menuItem9;
			__mcTemp__4[3] = this->menuItem14;
			__mcTemp__4[4] = this->menuItem17;
			__mcTemp__4[5] = this->menuItem18;
			__mcTemp__4[6] = this->menuItem21;
			__mcTemp__4[7] = this->menuItem22;
			this->menuItem6->MenuItems->AddRange(__mcTemp__4);
			this->menuItem6->Text = S"&Instruments";
			// 
			// menuItem7
			// 
			this->menuItem7->Index = 0;
			this->menuItem7->Shortcut = System::Windows::Forms::Shortcut::CtrlA;
			this->menuItem7->Text = S"&Add";
			this->menuItem7->Click += new System::EventHandler(this, menuItem7_Click);
			// 
			// menuItem8
			// 
			this->menuItem8->Index = 1;
			this->menuItem8->Shortcut = System::Windows::Forms::Shortcut::CtrlR;
			this->menuItem8->Text = S"&Remove";
			this->menuItem8->Click += new System::EventHandler(this, menuItem8_Click);
			// 
			// menuItem9
			// 
			this->menuItem9->Index = 2;
			this->menuItem9->Shortcut = System::Windows::Forms::Shortcut::CtrlE;
			this->menuItem9->Text = S"&Edit...";
			this->menuItem9->Click += new System::EventHandler(this, menuItem9_Click);
			// 
			// menuItem14
			// 
			this->menuItem14->Index = 3;
			this->menuItem14->Shortcut = System::Windows::Forms::Shortcut::CtrlM;
			this->menuItem14->Text = S"&Mute";
			this->menuItem14->Click += new System::EventHandler(this, menuItem14_Click);
			// 
			// menuItem17
			// 
			this->menuItem17->Index = 4;
			this->menuItem17->Text = S"&Copy";
			this->menuItem17->Click += new System::EventHandler(this, menuItem17_Click);
			// 
			// menuItem18
			// 
			this->menuItem18->Index = 5;
			this->menuItem18->Text = S"&Paste";
			this->menuItem18->Click += new System::EventHandler(this, menuItem18_Click);
			// 
			// menuItem21
			// 
			this->menuItem21->Index = 6;
			this->menuItem21->Shortcut = System::Windows::Forms::Shortcut::CtrlU;
			this->menuItem21->Text = S"Move &Up";
			this->menuItem21->Click += new System::EventHandler(this, menuItem21_Click);
			// 
			// menuItem22
			// 
			this->menuItem22->Index = 7;
			this->menuItem22->Shortcut = System::Windows::Forms::Shortcut::CtrlW;
			this->menuItem22->Text = S"Move Do&wn";
			this->menuItem22->Click += new System::EventHandler(this, menuItem22_Click);
			// 
			// menuItem16
			// 
			this->menuItem16->Index = 3;
			System::Windows::Forms::MenuItem* __mcTemp__5[] = new System::Windows::Forms::MenuItem*[4];
			__mcTemp__5[0] = this->menuItem15;
			__mcTemp__5[1] = this->menuItemFreqAn;
			__mcTemp__5[2] = this->menuItemAnOut;
			__mcTemp__5[3] = this->menuItem27;
			this->menuItem16->MenuItems->AddRange(__mcTemp__5);
			this->menuItem16->Text = S"&Melody";
			// 
			// menuItem15
			// 
			this->menuItem15->Index = 0;
			this->menuItem15->Text = S"&Generate Code...";
			this->menuItem15->Click += new System::EventHandler(this, menuItem15_Click);
			// 
			// menuItemFreqAn
			// 
			this->menuItemFreqAn->Index = 1;
			this->menuItemFreqAn->Text = S"Analyze &Frequency...";
			this->menuItemFreqAn->Click += new System::EventHandler(this, menuItemFreqAn_Click);
			// 
			// menuItemAnOut
			// 
			this->menuItemAnOut->Index = 2;
			this->menuItemAnOut->Text = S"Analyze &Output...";
			this->menuItemAnOut->Click += new System::EventHandler(this, menuItemAnOut_Click);
			// 
			// menuItem27
			// 
			this->menuItem27->Index = 3;
			this->menuItem27->Text = S"WAV export...";
			this->menuItem27->Click += new System::EventHandler(this, menuItem27_Click);
			// 
			// menuItem19
			// 
			this->menuItem19->Index = 4;
			System::Windows::Forms::MenuItem* __mcTemp__6[] = new System::Windows::Forms::MenuItem*[1];
			__mcTemp__6[0] = this->menuItem20;
			this->menuItem19->MenuItems->AddRange(__mcTemp__6);
			this->menuItem19->Text = S"&Help";
			// 
			// menuItem20
			// 
			this->menuItem20->Index = 0;
			this->menuItem20->Text = S"&About...";
			this->menuItem20->Click += new System::EventHandler(this, menuItem20_Click);
			// 
			// groupBoxInstruments
			// 
			this->groupBoxInstruments->Dock = System::Windows::Forms::DockStyle::Fill;
			this->groupBoxInstruments->Location = System::Drawing::Point(0, 0);
			this->groupBoxInstruments->Name = S"groupBoxInstruments";
			this->groupBoxInstruments->Size = System::Drawing::Size(96, 393);
			this->groupBoxInstruments->TabIndex = 0;
			this->groupBoxInstruments->TabStop = false;
			this->groupBoxInstruments->Text = S"Instruments";
			// 
			// panelInstruments
			// 
			this->panelInstruments->Controls->Add(this->groupBoxInstruments);
			this->panelInstruments->Dock = System::Windows::Forms::DockStyle::Left;
			this->panelInstruments->Location = System::Drawing::Point(0, 0);
			this->panelInstruments->Name = S"panelInstruments";
			this->panelInstruments->Size = System::Drawing::Size(96, 393);
			this->panelInstruments->TabIndex = 1;
			// 
			// splitter1
			// 
			this->splitter1->Location = System::Drawing::Point(96, 0);
			this->splitter1->Name = S"splitter1";
			this->splitter1->Size = System::Drawing::Size(8, 393);
			this->splitter1->TabIndex = 2;
			this->splitter1->TabStop = false;
			// 
			// panelSequences
			// 
			this->panelSequences->Controls->Add(this->groupBoxSequences);
			this->panelSequences->Controls->Add(this->panelToolBar);
			this->panelSequences->Dock = System::Windows::Forms::DockStyle::Fill;
			this->panelSequences->Location = System::Drawing::Point(104, 0);
			this->panelSequences->Name = S"panelSequences";
			this->panelSequences->Size = System::Drawing::Size(688, 393);
			this->panelSequences->TabIndex = 3;
			// 
			// groupBoxSequences
			// 
			this->groupBoxSequences->Controls->Add(this->panelByteStreams);
			this->groupBoxSequences->Dock = System::Windows::Forms::DockStyle::Fill;
			this->groupBoxSequences->Location = System::Drawing::Point(0, 32);
			this->groupBoxSequences->Name = S"groupBoxSequences";
			this->groupBoxSequences->Size = System::Drawing::Size(688, 361);
			this->groupBoxSequences->TabIndex = 2;
			this->groupBoxSequences->TabStop = false;
			this->groupBoxSequences->Text = S"Sequences";
			// 
			// panelByteStreams
			// 
			this->panelByteStreams->Controls->Add(this->lblBytePatterns);
			this->panelByteStreams->Controls->Add(this->btnBytePatterns);
			this->panelByteStreams->Controls->Add(this->panelByte);
			this->panelByteStreams->Controls->Add(this->btnRemoveByteSequence);
			this->panelByteStreams->Controls->Add(this->btnAddByteSequence);
			this->panelByteStreams->Dock = System::Windows::Forms::DockStyle::Fill;
			this->panelByteStreams->Location = System::Drawing::Point(3, 16);
			this->panelByteStreams->Name = S"panelByteStreams";
			this->panelByteStreams->Size = System::Drawing::Size(682, 342);
			this->panelByteStreams->TabIndex = 0;
			// 
			// lblBytePatterns
			// 
			this->lblBytePatterns->Anchor = (System::Windows::Forms::AnchorStyles)((System::Windows::Forms::AnchorStyles::Top | System::Windows::Forms::AnchorStyles::Bottom) 
				| System::Windows::Forms::AnchorStyles::Left);
			this->lblBytePatterns->Location = System::Drawing::Point(0, 8);
			this->lblBytePatterns->Name = S"lblBytePatterns";
			this->lblBytePatterns->Size = System::Drawing::Size(80, 328);
			this->lblBytePatterns->TabIndex = 4;
			this->lblBytePatterns->Text = S"Patterns:";
			// 
			// btnBytePatterns
			// 
			this->btnBytePatterns->Anchor = (System::Windows::Forms::AnchorStyles)(System::Windows::Forms::AnchorStyles::Top | System::Windows::Forms::AnchorStyles::Right);
			this->btnBytePatterns->ImageIndex = 2;
			this->btnBytePatterns->ImageList = this->imageList1;
			this->btnBytePatterns->Location = System::Drawing::Point(640, 8);
			this->btnBytePatterns->Name = S"btnBytePatterns";
			this->btnBytePatterns->Size = System::Drawing::Size(32, 32);
			this->btnBytePatterns->TabIndex = 3;
			this->toolTip1->SetToolTip(this->btnBytePatterns, S"Edit  patterns");
			this->btnBytePatterns->Click += new System::EventHandler(this, btnBytePatterns_Click);
			// 
			// imageList1
			// 
			this->imageList1->ColorDepth = System::Windows::Forms::ColorDepth::Depth24Bit;
			this->imageList1->ImageSize = System::Drawing::Size(18, 18);
			this->imageList1->ImageStream = (__try_cast<System::Windows::Forms::ImageListStreamer *  >(resources->GetObject(S"imageList1.ImageStream")));
			this->imageList1->TransparentColor = System::Drawing::Color::Teal;
			// 
			// panelByte
			// 
			this->panelByte->Anchor = (System::Windows::Forms::AnchorStyles)(((System::Windows::Forms::AnchorStyles::Top | System::Windows::Forms::AnchorStyles::Bottom) 
				| System::Windows::Forms::AnchorStyles::Left) 
				| System::Windows::Forms::AnchorStyles::Right);
			this->panelByte->BorderStyle = System::Windows::Forms::BorderStyle::FixedSingle;
			this->panelByte->Controls->Add(this->byteScrollHor);
			this->panelByte->Controls->Add(this->byteScroll);
			this->panelByte->Location = System::Drawing::Point(80, 48);
			this->panelByte->Name = S"panelByte";
			this->panelByte->Size = System::Drawing::Size(600, 288);
			this->panelByte->TabIndex = 2;
			this->panelByte->Resize += new System::EventHandler(this, panelByte_Resize);
			this->panelByte->Paint += new System::Windows::Forms::PaintEventHandler(this, panelByte_Paint);
			this->panelByte->DoubleClick += new System::EventHandler(this, panelByte_DoubleClick);
			this->panelByte->MouseMove += new System::Windows::Forms::MouseEventHandler(this, panelByte_MouseMove);
			this->panelByte->MouseDown += new System::Windows::Forms::MouseEventHandler(this, panelByte_MouseDown);
			// 
			// byteScrollHor
			// 
			this->byteScrollHor->Dock = System::Windows::Forms::DockStyle::Bottom;
			this->byteScrollHor->LargeChange = 2;
			this->byteScrollHor->Location = System::Drawing::Point(0, 270);
			this->byteScrollHor->Maximum = 20;
			this->byteScrollHor->Name = S"byteScrollHor";
			this->byteScrollHor->Size = System::Drawing::Size(582, 16);
			this->byteScrollHor->TabIndex = 1;
			this->byteScrollHor->Scroll += new System::Windows::Forms::ScrollEventHandler(this, byteScroll_Scroll);
			// 
			// byteScroll
			// 
			this->byteScroll->Dock = System::Windows::Forms::DockStyle::Right;
			this->byteScroll->Location = System::Drawing::Point(582, 0);
			this->byteScroll->Name = S"byteScroll";
			this->byteScroll->Size = System::Drawing::Size(16, 286);
			this->byteScroll->TabIndex = 0;
			this->byteScroll->Scroll += new System::Windows::Forms::ScrollEventHandler(this, byteScroll_Scroll);
			// 
			// btnRemoveByteSequence
			// 
			this->btnRemoveByteSequence->ImageIndex = 1;
			this->btnRemoveByteSequence->ImageList = this->imageList1;
			this->btnRemoveByteSequence->Location = System::Drawing::Point(120, 8);
			this->btnRemoveByteSequence->Name = S"btnRemoveByteSequence";
			this->btnRemoveByteSequence->Size = System::Drawing::Size(32, 32);
			this->btnRemoveByteSequence->TabIndex = 1;
			this->toolTip1->SetToolTip(this->btnRemoveByteSequence, S"Remove sequence");
			this->btnRemoveByteSequence->Click += new System::EventHandler(this, btnRemoveByteSequence_Click);
			// 
			// btnAddByteSequence
			// 
			this->btnAddByteSequence->ImageIndex = 0;
			this->btnAddByteSequence->ImageList = this->imageList1;
			this->btnAddByteSequence->Location = System::Drawing::Point(80, 8);
			this->btnAddByteSequence->Name = S"btnAddByteSequence";
			this->btnAddByteSequence->Size = System::Drawing::Size(32, 32);
			this->btnAddByteSequence->TabIndex = 0;
			this->toolTip1->SetToolTip(this->btnAddByteSequence, S"Add sequence");
			this->btnAddByteSequence->Click += new System::EventHandler(this, btnAddByteSequence_Click);
			// 
			// panelToolBar
			// 
			this->panelToolBar->Controls->Add(this->lblWAVWrite);
			this->panelToolBar->Controls->Add(this->lblSoundInfo);
			this->panelToolBar->Controls->Add(this->cbLooping);
			this->panelToolBar->Controls->Add(this->btnPlay);
			this->panelToolBar->Controls->Add(this->lblRowLen);
			this->panelToolBar->Controls->Add(this->sbVolume);
			this->panelToolBar->Controls->Add(this->lblVolume);
			this->panelToolBar->Controls->Add(this->dfBPM);
			this->panelToolBar->Controls->Add(this->lblBPM);
			this->panelToolBar->Dock = System::Windows::Forms::DockStyle::Top;
			this->panelToolBar->Location = System::Drawing::Point(0, 0);
			this->panelToolBar->Name = S"panelToolBar";
			this->panelToolBar->Size = System::Drawing::Size(688, 32);
			this->panelToolBar->TabIndex = 1;
			// 
			// lblSoundInfo
			// 
			this->lblSoundInfo->Location = System::Drawing::Point(336, 8);
			this->lblSoundInfo->Name = S"lblSoundInfo";
			this->lblSoundInfo->Size = System::Drawing::Size(128, 16);
			this->lblSoundInfo->TabIndex = 7;
			this->lblSoundInfo->TextAlign = System::Drawing::ContentAlignment::MiddleLeft;
			// 
			// cbLooping
			// 
			this->cbLooping->Location = System::Drawing::Point(528, 8);
			this->cbLooping->Name = S"cbLooping";
			this->cbLooping->Size = System::Drawing::Size(72, 16);
			this->cbLooping->TabIndex = 6;
			this->cbLooping->Text = S"Looping";
			// 
			// btnPlay
			// 
			this->btnPlay->ImageIndex = 4;
			this->btnPlay->ImageList = this->imageList1;
			this->btnPlay->Location = System::Drawing::Point(480, 0);
			this->btnPlay->Name = S"btnPlay";
			this->btnPlay->Size = System::Drawing::Size(32, 32);
			this->btnPlay->TabIndex = 5;
			this->toolTip1->SetToolTip(this->btnPlay, S"Play/Stop melody (F5)");
			this->btnPlay->Click += new System::EventHandler(this, btnPlay_Click);
			// 
			// lblRowLen
			// 
			this->lblRowLen->Location = System::Drawing::Point(96, 8);
			this->lblRowLen->Name = S"lblRowLen";
			this->lblRowLen->Size = System::Drawing::Size(64, 16);
			this->lblRowLen->TabIndex = 4;
			this->lblRowLen->TextAlign = System::Drawing::ContentAlignment::MiddleLeft;
			// 
			// sbVolume
			// 
			this->sbVolume->Location = System::Drawing::Point(208, 8);
			this->sbVolume->Maximum = 200;
			this->sbVolume->Name = S"sbVolume";
			this->sbVolume->Size = System::Drawing::Size(120, 16);
			this->sbVolume->TabIndex = 3;
			this->sbVolume->Value = 100;
			this->sbVolume->ValueChanged += new System::EventHandler(this, sbVolume_ValueChanged);
			// 
			// lblVolume
			// 
			this->lblVolume->Location = System::Drawing::Point(160, 8);
			this->lblVolume->Name = S"lblVolume";
			this->lblVolume->Size = System::Drawing::Size(48, 16);
			this->lblVolume->TabIndex = 2;
			this->lblVolume->Text = S"Volume:";
			// 
			// dfBPM
			// 
			this->dfBPM->Location = System::Drawing::Point(40, 8);
			System::Int32 __mcTemp__7[] = new System::Int32[4];
			__mcTemp__7[0] = 200;
			__mcTemp__7[1] = 0;
			__mcTemp__7[2] = 0;
			__mcTemp__7[3] = 0;
			this->dfBPM->Maximum = System::Decimal(__mcTemp__7);
			System::Int32 __mcTemp__8[] = new System::Int32[4];
			__mcTemp__8[0] = 10;
			__mcTemp__8[1] = 0;
			__mcTemp__8[2] = 0;
			__mcTemp__8[3] = 0;
			this->dfBPM->Minimum = System::Decimal(__mcTemp__8);
			this->dfBPM->Name = S"dfBPM";
			this->dfBPM->Size = System::Drawing::Size(48, 20);
			this->dfBPM->TabIndex = 1;
			System::Int32 __mcTemp__9[] = new System::Int32[4];
			__mcTemp__9[0] = 130;
			__mcTemp__9[1] = 0;
			__mcTemp__9[2] = 0;
			__mcTemp__9[3] = 0;
			this->dfBPM->Value = System::Decimal(__mcTemp__9);
			this->dfBPM->ValueChanged += new System::EventHandler(this, dfBPM_ValueChanged);
			// 
			// lblBPM
			// 
			this->lblBPM->Location = System::Drawing::Point(8, 8);
			this->lblBPM->Name = S"lblBPM";
			this->lblBPM->Size = System::Drawing::Size(32, 16);
			this->lblBPM->TabIndex = 0;
			this->lblBPM->Text = S"BPM:";
			// 
			// timer1
			// 
			this->timer1->Enabled = true;
			this->timer1->Interval = 500;
			this->timer1->Tick += new System::EventHandler(this, timer1_Tick);
			// 
			// openFileDialog1
			// 
			this->openFileDialog1->DefaultExt = S"buz";
			this->openFileDialog1->Filter = S"Buzzic 2 files (*.buz2)|*.buz2|All files (*.*)|*.*";
			// 
			// saveFileDialog1
			// 
			this->saveFileDialog1->DefaultExt = S"buz";
			this->saveFileDialog1->Filter = S"Buzzic 2 files (*.buz2)|*.buz2|All files (*.*)|*.*";
			// 
			// saveFileDialog2
			// 
			this->saveFileDialog2->DefaultExt = S"wav";
			this->saveFileDialog2->Filter = S"WAV files (*.wav)|*.wav|All files (*.*)|*.*";
			// 
			// lblWAVWrite
			// 
			this->lblWAVWrite->Location = System::Drawing::Point(600, 8);
			this->lblWAVWrite->Name = S"lblWAVWrite";
			this->lblWAVWrite->Size = System::Drawing::Size(200, 16);
			this->lblWAVWrite->TabIndex = 8;
			// 
			// Form1
			// 
			this->AutoScaleBaseSize = System::Drawing::Size(5, 13);
			this->ClientSize = System::Drawing::Size(792, 393);
			this->Controls->Add(this->panelSequences);
			this->Controls->Add(this->splitter1);
			this->Controls->Add(this->panelInstruments);
			this->Icon = (__try_cast<System::Drawing::Icon *  >(resources->GetObject(S"$this.Icon")));
			this->Menu = this->mainMenu1;
			this->Name = S"Form1";
			this->Text = S"Buzzic 2";
			this->Load += new System::EventHandler(this, Form1_Load);
			this->panelInstruments->ResumeLayout(false);
			this->panelSequences->ResumeLayout(false);
			this->groupBoxSequences->ResumeLayout(false);
			this->panelByteStreams->ResumeLayout(false);
			this->panelByte->ResumeLayout(false);
			this->panelToolBar->ResumeLayout(false);
			(__try_cast<System::ComponentModel::ISupportInitialize *  >(this->dfBPM))->EndInit();
			this->ResumeLayout(false);

		}	




	private: 
		// Exit from program
		System::Void menuItem2_Click(System::Object *  sender, System::EventArgs *  e)
			 {
				 Close ( );
			 }

	private: System::Void Form1_Load(System::Object *  sender, System::EventArgs *  e)
			 {
				 System::Threading::Thread::CurrentThread->CurrentCulture = System::Globalization::CultureInfo::InvariantCulture;
				 dfBPM_ValueChanged ( this, NULL );
			 }

private: 
	// Open file menu item click
	System::Void menuItem3_Click(System::Object *  sender, System::EventArgs *  e)
		 {
			 if ( DialogResult::Cancel == openFileDialog1->ShowDialog ( NULL ) )
				 return;
			if ( !OpenFile ( openFileDialog1->FileName ) )
				return;
			// Change title
			currentFile = openFileDialog1->FileName;
			Text = String::Format ( "{0} - {1}", S"Buzzic 2", currentFile );
		 }

private: 
	
	// Adds instrument
	void AddInstrument ( Instrument i ) {
		// Add text box, representing instrument
		g_instruments[g_instrumentCount++] = i;
		TextBox* b = new TextBox ( );
		b->Text = i.name;
		b->Tag = __box ( g_instrumentCount - 1 );
		b->Dock = DockStyle::Top;
		b->add_TextChanged ( new EventHandler ( this, InstrumentNameChanged ) );
		groupBoxInstruments->Controls->Add ( b );
		b->Focus ( );
	}

	// Add instrument
	System::Void menuItem7_Click(System::Object *  sender, System::EventArgs *  e)
		 {
			 // Create new instrument
			 Instrument i = { 0 };
			 sprintf ( i.name, "Ins %d", g_instrumentCount );
			 i.note = 45;
			 i.noteLen = 16;
			 i.volume = 100;
			 // Add text box, representing instrument
			 AddInstrument ( i );
		 }

		 // Called when instrument name is changed
		 System::Void InstrumentNameChanged ( System::Object *  sender, System::EventArgs *  e ) {
			 TextBox* t = dynamic_cast<TextBox*>(sender);
			 char* p = (char*)Marshal::StringToHGlobalAnsi(t->Text).ToPointer(); 
   			 strcpy ( g_instruments[Convert::ToInt32(t->Tag)].name, p );
			 Marshal::FreeHGlobal(p);
		 }

private: 
	// Removes instrument
	System::Void menuItem8_Click ( System::Object *  sender, System::EventArgs *  e ) {
			 for ( int i = 0; i < groupBoxInstruments->Controls->Count; i++ )
				 if ( groupBoxInstruments->Controls->Item[i]->Focused ) {
					 TextBox* t = dynamic_cast<TextBox*>(groupBoxInstruments->Controls->Item[i]);
					 if ( DialogResult::Yes == MessageBox::Show ( NULL, String::Format ( S"Remove instrument '{0}'?", t->Text ), 
						 "Removing instrument", MessageBoxButtons::YesNo, MessageBoxIcon::Question ) ) {
						 i = Convert::ToInt32 ( t->Tag );
						 t->Parent = NULL;
						 // Cleanup memory
						 for ( int k = 0; k < g_instruments[i].operCount; k++ )
							 delete g_instruments[i].oper[k];
						 for ( int k = i; k < g_instrumentCount - 1; k++ ) {
							 g_instruments[k] = g_instruments[k+1];
							 // Update text box references
							 for ( int cc = 0; cc < groupBoxInstruments->Controls->Count; cc++ ) {
								 TextBox* t1 = dynamic_cast<TextBox*>(groupBoxInstruments->Controls->Item[cc]);
								 if ( Convert::ToInt32 ( t1->Tag ) == k + 1 )
									 t1->Tag = __box ( k );
							 }
						 }
						 g_instrumentCount--;
					 }
					 return;
				 }
		 }

private: System::Void 
		timer1_Tick ( System::Object *  sender, System::EventArgs *  e ) {
			// Fill labels list
			StringBuilder* bld = new StringBuilder ( );
			bld->Append ( S"Patterns:\r\n" );
			for ( int i = 0; i < g_bytePatternsCount; i++ )
				bld->Append ( GetPatternKey ( i ) )->Append ( ": " )->Append ( BytePatternsEditor::bytePatternNames[i] )->Append ( "\r\n" );
			lblBytePatterns->Text = bld->ToString ( );
			// Write sound info
			bld->Length = 0;
			bld->Append ( S"Max. vol: " )->Append ( maxSampleVol.ToString ( S"n2" ) )->Append ( "/" )->
				Append ( maxMasterVol.ToString ( S"n2" ) );			
			lblSoundInfo->Text = bld->ToString ( );
			// Write WAV write info
			if ( writeToWAV ) {
				double d = (double)wavSize / (1024*1024);
				lblWAVWrite->Text = String::Concat ( "Writing WAV ", d.ToString ( "n1" ), " Mb" );
			} else
				lblWAVWrite->Text = String::Empty;
		}

private: 
	// Opens instrument edit window
	System::Void menuItem9_Click(System::Object *  sender, System::EventArgs *  e)
		 {
			 for ( int i = 0; i < groupBoxInstruments->Controls->Count; i++ )
				 if ( groupBoxInstruments->Controls->Item[i]->Focused ) {
					 TextBox* t = dynamic_cast<TextBox*>(groupBoxInstruments->Controls->Item[i]);
					 InstrumentEditor* ie = new InstrumentEditor ( Convert::ToInt32 ( t->Tag ), byteSequenceNames );
					 ie->ShowDialog ( );
					 return;
				 }
		 }

private: System::Void dfBPM_ValueChanged ( System::Object *  sender, System::EventArgs *  e ) {
			 String* s = ( 60.0f / ( 4.0f * dfBPM->Value ) ).ToString ( "n3" );
			 lblRowLen->Text = String::Concat ( s, S" sec" );
			 ROW_SIZE_SAMPLES = Convert::ToInt32 ( SAMPLE_FREQUENCY * 60.0f / ( dfBPM->Value * 4.0f ) );
		 }

private:

		//
		// Byte sequences
		//
		
		// Redraws byte sequences window
		void RedrawByteSequences ( ) {
			panelByte->Invalidate ( );
			panelByte->Update ( );
		}

		// Adds byte sequence
		System::Void btnAddByteSequence_Click ( System::Object *  sender, System::EventArgs *  e ) {
			if ( g_byteSequencesCount >= MAX_SEQUENCES )
				return;
			GetValueForm* f = new GetValueForm ( );
			f->Text = S"Enter sequence name";
			if ( DialogResult::Cancel == f->ShowDialog ( ) )
				return;
			ZeroMemory ( (char*)g_byteSequences + g_byteSequencesCount*MAX_TEMPLATE_MELODY_LEN, MAX_TEMPLATE_MELODY_LEN );
			byteSequenceNames[g_byteSequencesCount] = f->dfValue->Text;
			g_byteSequencesCount++;
			RedrawByteSequences ( );
		}

		// Redraws byte sequences panel
		System::Void panelByte_Paint ( System::Object *  sender, System::Windows::Forms::PaintEventArgs *  e ) {
			if ( g_byteSequencesCount <= 0 )
				return;
			// Draw header
			StringFormat* sf = new StringFormat ( );
			sf->Alignment = StringAlignment::Center;
			sf->LineAlignment = StringAlignment::Center;
			for ( int i = byteScrollHor->Value; i < g_byteSequencesCount; i++ ) {
				e->Graphics->FillRectangle ( Brushes::White, (i+1-byteScrollHor->Value) * CELL_X, 0, CELL_X, CELL_Y );
				e->Graphics->DrawRectangle ( Pens::Black, (i+1-byteScrollHor->Value) * CELL_X, 0, CELL_X, CELL_Y );
				RectangleF r ( (i+1-byteScrollHor->Value) * CELL_X, 0, CELL_X, CELL_Y );
				e->Graphics->DrawString ( byteSequenceNames[i], Font, Brushes::Black, r, sf );
			}
			// Draw rows
			int rs = byteScroll->Value;
			int re = rs + panelByte->Height / CELL_Y + 1;
			for ( int r = rs; r <= re && r < MAX_TEMPLATE_MELODY_LEN; r++ ) {
				// Draw row header
				int rrs = r - rs + 1;
				e->Graphics->FillRectangle ( Brushes::White, 0, rrs * CELL_Y, CELL_X, CELL_Y );
				e->Graphics->DrawRectangle ( Pens::Black, 0, rrs * CELL_Y, CELL_X, CELL_Y );
				RectangleF r1 ( 0, rrs * CELL_Y, CELL_X, CELL_Y );
				e->Graphics->DrawString ( String::Format ( "{0} {1}", __box(r), (16.0f*r*15/dfBPM->Value).ToString ( "n1" ) ), Font, Brushes::Black, r1, sf );
				// Draw selection start and end
				if ( r == startSeq )
					e->Graphics->DrawLine ( Pens::Green, 0, rrs * CELL_Y, panelByte->Width, rrs * CELL_Y );
				if ( r == endSeq )
					e->Graphics->DrawLine ( Pens::Red, 0, (rrs+1) * CELL_Y, panelByte->Width, (rrs+1) * CELL_Y );
				// Draw cells
				for ( int i = byteScrollHor->Value; i < g_byteSequencesCount; i++ ) {
					// Highlight focus cell, row and column, selection
					Brush* highBrush = NULL;
					if ( i == byteFocus.X || r == byteFocus.Y )
						highBrush = Brushes::LightGray;
					if ( i == byteFocus.X && r == byteFocus.Y )
						highBrush = Brushes::LightBlue;
					if ( selectionStart.X >= 0 && selectionStart != selectionEnd ) {
						if ( i >= Math::Min(selectionStart.X,selectionEnd.X) && i <= Math::Max(selectionStart.X,selectionEnd.X) &&
							r >= Math::Min(selectionStart.Y,selectionEnd.Y) && r <= Math::Max(selectionStart.Y,selectionEnd.Y) )
							highBrush = Brushes::LightSkyBlue;
					}
					if ( highBrush )
						e->Graphics->FillRectangle ( highBrush, (i+1-byteScrollHor->Value) * CELL_X + 1, rrs * CELL_Y + 1, CELL_X - 1, CELL_Y - 1 );
					String *s;
					if ( !g_byteSequences[i][r] )
						s = S"...";
					else
						s = BytePatternsEditor::bytePatternNames[g_byteSequences[i][r]-1];
					RectangleF r1 ( (i+1-byteScrollHor->Value) * CELL_X, rrs * CELL_Y, CELL_X, CELL_Y );
					e->Graphics->DrawString ( s, Font, Brushes::Black, r1, sf );
				}
			}
		}

private: System::Void byteScroll_Scroll(System::Object *  sender, System::Windows::Forms::ScrollEventArgs *  e)
		 {
			 RedrawByteSequences ( );
		 }

private: System::Void panelByte_Resize(System::Object *  sender, System::EventArgs *  e)
		 {
			 RedrawByteSequences ( );
		 }

private:

private: 
		// Changes byte pattern focus
		System::Void panelByte_MouseDown ( System::Object *  sender, System::Windows::Forms::MouseEventArgs *  e ) {
			selectionDragStart = Point ( -1, -1 );
			byteFocus.X = e->X / CELL_X - 1;
			byteFocus.Y = Math::Min ( e->Y / CELL_Y - 1 + byteScroll->Value, MAX_TEMPLATE_MELODY_LEN - 1 );
			// Change start and end position
			if ( byteFocus.X == -1 && byteFocus.Y >= 0 ) {
				if ( e->Button == MouseButtons::Left )
					startSeq = byteFocus.Y;
				if ( e->Button == MouseButtons::Right )
					endSeq = byteFocus.Y;
				if ( startSeq > endSeq )
					endSeq = startSeq;
			}
			byteFocus.X = e->X / CELL_X - 1 + byteScrollHor->Value;
			if ( byteFocus.X >= g_byteSequencesCount )
				byteFocus.X = g_byteSequencesCount - 1;
			if ( byteFocus.X < 0 )
				byteFocus.X = -1;
			selectionStart = selectionEnd = byteFocus;
			RedrawByteSequences ( );
			panelByte->Focus ( );
		}

		// Processes key press event
		System::Void panelByte_KeyPressEventHandler ( Object* sender, KeyPressEventArgs* e ) {
			if ( byteFocus.X < 0 || byteFocus.Y < 0 )
				return;
			if ( e->KeyChar == '.' ) {
				g_byteSequences[byteFocus.X][byteFocus.Y] = 0;
				byteFocus.Y = Math::Min ( byteFocus.Y + 1, MAX_TEMPLATE_MELODY_LEN - 1 );
				RedrawByteSequences ( );
				return;
			}
			for ( int i = 0; i < g_bytePatternsCount; i++ )
				if ( e->KeyChar == GetPatternKey ( i ) ) {
					g_byteSequences[byteFocus.X][byteFocus.Y] = i + 1; 
					byteFocus.Y = Math::Min ( byteFocus.Y + 1, MAX_TEMPLATE_MELODY_LEN - 1 );
					RedrawByteSequences ( );
					break;
				}
        }

		// Insert or delete sequence row
		void InsertDeleteSeqRow ( bool insert ) {
			if ( byteFocus.X < 0 || byteFocus.Y < 0 || byteFocus.X >= g_byteSequencesCount || byteFocus.Y >= MAX_TEMPLATE_MELODY_LEN - 1 )
				return;
			if ( !insert ) {
				for ( int i = 0; i < g_byteSequencesCount; i++ )
					MoveMemory ( g_byteSequences[i] + byteFocus.Y, g_byteSequences[i] + byteFocus.Y + 1,
						MAX_TEMPLATE_MELODY_LEN - byteFocus.Y - 1 );
			}	
			if ( insert ) {
				for ( int i = 0; i < g_byteSequencesCount; i++ ) {
					MoveMemory ( g_byteSequences[i] + byteFocus.Y + 1, g_byteSequences[i] + byteFocus.Y,
						MAX_TEMPLATE_MELODY_LEN - byteFocus.Y - 1 );
					g_byteSequences[i][byteFocus.Y] = 0;
				}
			}
			RedrawByteSequences ( );
		}

		// Process key down on sequences
		System::Void panelByte_KeyDownEventHandler ( Object* sender, KeyEventArgs* e ) {
			if ( e->KeyCode == Keys::Delete && e->Control )
				InsertDeleteSeqRow ( false );
			if ( e->KeyCode == Keys::Insert && e->Control )
				InsertDeleteSeqRow ( true );
		}

		// Tests and removes value if match
		void RemoveSeq ( char& v, char r ) {
			if ( v == r )
				v = 0;
			if ( v < r )
				v++;
		}

		// Removes sequence from instrument sequenced values and shifts patterns
		void RemoveSequenceFromInstrument ( Instrument* ins, int pat ) {
			RemoveSeq ( ins->note, pat );
			RemoveSeq ( ins->noteLen, pat );
			for ( int i = 0; i < ins->operCount; i++ ) {
				for ( int k = 0; k < ins->oper[i]->paramCount; k++ )
					if ( ins->oper[i]->paramTypes[k] == PT_STREAM && ins->oper[i]->params[k] < 0 ) {
						char c = ins->oper[i]->params[k];
						RemoveSeq ( c, pat );
						ins->oper[i]->params[k] = c;
					}
			}
		}

		// Removes byte sequence
		System::Void btnRemoveByteSequence_Click ( System::Object *  sender, System::EventArgs *  e ) {
			if ( byteFocus.X < 0 )
				return;
			if ( MessageBox::Show ( NULL, "Remove focused byte pattern?", "Removing byte pattern", 
				MessageBoxButtons::YesNo, MessageBoxIcon::Question ) == DialogResult::No )
				return;
			for ( int k = byteFocus.X; k < g_byteSequencesCount - 1; k++ ) {
				CopyMemory ( (char*)g_byteSequences + k*MAX_TEMPLATE_MELODY_LEN, (char*)g_byteSequences + (k+1)*MAX_TEMPLATE_MELODY_LEN, MAX_TEMPLATE_MELODY_LEN );
				byteSequenceNames[k] = byteSequenceNames[k+1];
			}
			g_byteSequencesCount--;
			// Remove pattern from instruments
			for ( int k = 0; k < g_instrumentCount; k++ )
				RemoveSequenceFromInstrument ( g_instruments + k, -(byteFocus.X + 1) ); 
			byteFocus.X = -1;
			RedrawByteSequences ( );
		}

private: System::Void btnBytePatterns_Click ( System::Object *  sender, System::EventArgs *  e ) {
			BytePatternsEditor* pe = new BytePatternsEditor ( );
			pe->Owner = this;
			pe->Show ( );
		 }

		 // Returns character, associated with pattern
		 System::Char GetPatternKey ( int patNo ) {
			 if ( patNo >= 0 && patNo < 10 )
				 return '0' + patNo;
			 return 'a' + patNo - 10;
		 }

private:
	
		// Plays melody
		void PlayThreadProc ( ) {
			// Create output device and prepare melody buffers
			maxSampleVol = maxSampleVol = 0;
			int bpm = Convert::ToInt32 ( dfBPM->Value );
			HWAVEOUT g_wo;
			WAVEFORMATEX wfx = { WAVE_FORMAT_PCM, 2, SAMPLE_FREQUENCY, SAMPLE_FREQUENCY*4, 4, 16, 0 };
			if ( MMSYSERR_NOERROR != waveOutOpen ( &g_wo, WAVE_MAPPER, &wfx, NULL, 0, CALLBACK_NULL ) ) {
				MessageBox::Show ( S"Unable to open audio device." );
				return;
			}

			// Allocate (hopefully) enough space to play one row
			SetThreadPriority ( GetCurrentThread ( ), THREAD_PRIORITY_HIGHEST );
			int oneRowSamples = 60.0f / ( 4 * bpm ) * SAMPLE_FREQUENCY;
			int oneRowSamples_2 = oneRowSamples * 2;
			int maxBufSamples = oneRowSamples*10 + 4*SAMPLE_FREQUENCY;
			float* data = new float[maxBufSamples*2+128];
			ZeroMemory ( data, maxBufSamples*2*sizeof(float) );

			// Create WAV file, if needed
			FILE* file = NULL;
			wavSize = 0;
			WaveHeader whdr = { 'FFIR', 0, 'EVAW', ' tmf', 16 };
			WaveFormat wfmt = { 1, 2, SAMPLE_FREQUENCY, SAMPLE_FREQUENCY*4, 4, 16 };
			ChunkHeader ch = { 'atad', 0 };
			if ( writeToWAV ) {
				file = fopen ( StringToChar ( saveFileDialog2->FileName ), "wb" );
				if ( file ) {
					fwrite ( &whdr, sizeof(whdr), 1, file );
					fwrite ( &wfmt, sizeof(wfmt), 1, file );
					fwrite ( &ch, sizeof(ch), 1, file );
				}
			}

			// Prepare buffers
			WAVEHDR hdrs[2] = {0};
			bool bufBusy[2] = {0};
			MMRESULT mmRes;
			for ( int i = 0; i < 2; i++ ) {
				hdrs[i].lpData = (LPSTR) new short[oneRowSamples_2+128];
				hdrs[i].dwBufferLength  = oneRowSamples_2*sizeof(short);
				mmRes = waveOutPrepareHeader ( g_wo, hdrs + i, sizeof(WAVEHDR) );
			}
			int curHdr = 0;

			// Loop through all patterns. Send one pattern at once.
			do {
				for ( int r = startSeq*16; r < (endSeq+1)*16 && !stopPlaying; r++ ) {
					// Move previously created (but not played) melody part to the buffer start
					MoveMemory ( data, data + oneRowSamples_2, (maxBufSamples-oneRowSamples)*2*sizeof(float) );
					ZeroMemory ( data + (maxBufSamples-oneRowSamples)*2, oneRowSamples*2*sizeof(float) );
					// Play instruments
					for ( int i = 0; i < g_instrumentCount; i++ )
						if ( !g_instruments[i].mute )
							FillNoteBuffer ( data, maxBufSamples, g_instruments + i, r );
					// Wait for currently playing buffer to stop
					while ( bufBusy[curHdr] && !(hdrs[curHdr].dwFlags & WHDR_DONE) )
						Sleep ( 1 );
					hdrs[curHdr].dwFlags &= ~WHDR_DONE;
					// Copy array to analyzer window
					if ( freqAnalyzer != NULL || outAnalyzer != NULL ) {
						float *b2 = data;
						float *fa = g_freqAnSamples;
						EnterCriticalSection ( &g_anCs );
						for ( int i = 0; i < FREQ_ANALYZE_SAMPLES; i++, b2 += 2 )
							*(fa++) = *b2;
						LeaveCriticalSection ( &g_anCs );
					}
					// Copy array to output
					short *s = (short*) hdrs[curHdr].lpData;
					float *b1 = data;
					for ( int i = 0; i < oneRowSamples_2; i++ ) {
						if ( fabs(*b1) > maxSampleVol )
							maxSampleVol = fabs(*b1);
						*(s++) = (short) ( 32760 * CutLevel ( (*(b1++))*g_masterVolume, 1 ) );
					}
					maxMasterVol = maxSampleVol*g_masterVolume;
					if ( file ) {
						fwrite ( hdrs[curHdr].lpData, oneRowSamples_2*2, 1, file );
						wavSize += oneRowSamples_2*2;
					}
					// Send data to audio device and advance to next buffer
					bufBusy[curHdr] = true;
					waveOutWrite ( g_wo, hdrs + curHdr, sizeof(WAVEHDR) );
					curHdr = (curHdr + 1)%2;
				}
			} while ( !stopPlaying && cbLooping->Checked );

			// Free resources
			waveOutReset ( g_wo );
			for ( int i = 0; i < 2; i++ ) {
				waveOutUnprepareHeader ( g_wo, hdrs + i, sizeof(WAVEHDR) );
				delete[] hdrs[i].lpData;
			}
			waveOutClose ( g_wo );
			delete[] data;
			if ( file ) {
				whdr.fileSize = wavSize + sizeof(whdr) + sizeof(wfmt) + sizeof(ch) - 8;
				ch.len = wavSize;
				fseek ( file, 0, SEEK_SET );
				fwrite ( &whdr, sizeof(whdr), 1, file );
				fwrite ( &wfmt, sizeof(wfmt), 1, file );
				fwrite ( &ch, sizeof(ch), 1, file );
				fclose ( file );
			}
			writeToWAV = false;
			wavSize = 0;
			if ( !stopPlaying )
				Invoke ( new EventHandler ( this, StopPlayingNotification ) );
		}

		// Called by the playing thread to notify about melody end
		System::Void StopPlayingNotification ( System::Object *  sender, System::EventArgs *  e ) {
			btnPlay->ImageIndex = 4;
			playThread = NULL;
		}

		// Recompiles all instruments
		bool RecompileInstruments ( ) {
			for ( int k = 0; k < g_instrumentCount; k++ ) {
				char stack[MAX_OPER_STACK_SIZE+128] = {0};
				int count = MAX_OPER_STACK_SIZE;
				InstrumentEditor::BuildOperatorStack ( (HWND)this->Handle.ToInt32 ( ), g_instruments + k, stack, &count );
				if ( count >= 0 ) {
					EnterCriticalSection ( &g_stackCs );
					CopyMemory ( g_instruments[k].stack, stack, count );
					g_instruments[k].programLen = count;
					LeaveCriticalSection ( &g_stackCs );
				} else
					return false;
			}
			return true;
		}

		// Start/stop playing melody
		System::Void btnPlay_Click ( System::Object *  sender, System::EventArgs *  e ) {
			if ( playThread ) {
				// Stop melody
				stopPlaying = true;
				btnPlay->Enabled = false;
				playThread->Join ( );
				btnPlay->Enabled = true;
				btnPlay->ImageIndex = 4;
				playThread = NULL;
			} else {
				// Recompile all instrument stacks
				if ( !RecompileInstruments ( ) )
					return;
				// Start playing thread
				stopPlaying = false;
				playThread = new System::Threading::Thread (
					new System::Threading::ThreadStart ( this, PlayThreadProc ) );
				playThread->Start ( );
				btnPlay->ImageIndex = 3;
			}
		}

		// Process command keys
protected: bool ProcessCmdKey ( Message* msg, Keys keyData ) {
			if ( keyData == Keys::F5 ) {
				btnPlay_Click ( this, NULL );
				return true;
			}
			return Form::ProcessCmdKey ( msg, keyData );
		}

private: System::Void sbVolume_ValueChanged(System::Object *  sender, System::EventArgs *  e)
		 {
			 g_masterVolume = sbVolume->Value * 0.01f;
		 }

private: System::Void menuItem4_Click(System::Object *  sender, System::EventArgs *  e) {
			// Save menu item
			String* fileName = currentFile;
			if ( currentFile == NULL ) {
				if ( DialogResult::Cancel == saveFileDialog1->ShowDialog ( NULL ) )
					return;
				fileName = saveFileDialog1->FileName;
			}
			// Save
			if ( !SaveFile ( fileName ) )
				return;
			// Change title
			currentFile = fileName;
			Text = String::Format ( "{0} - {1}", S"Buzzic 2", currentFile );
		}

private: System::Void menuItem10_Click ( System::Object *  sender, System::EventArgs *  e ) {
			if ( DialogResult::Cancel == saveFileDialog1->ShowDialog ( NULL ) )
				return;
			SaveFile ( saveFileDialog1->FileName );
		 }

private:

		// Saves file
		bool SaveFile ( String* fileName ) {
			FILE* f = fopen ( StringToChar ( fileName ), "wb" );
			if ( !f ) {
				MessageBox::Show ( S"Unable to save file." );
				return false;
			}
			// Write header
			FileHeader fh = {0};
			fh.magicWord = '2zub';
			fh.version = MAKELONG(2,1);
			fh.masterVolume = g_masterVolume;
			fh.bpm = Convert::ToInt32 ( dfBPM->Value );
			fh.startSeq = startSeq;
			fh.endSeq = endSeq;
			fh.looping = cbLooping->Checked ? 1 : 0;
			fwrite ( &fh, sizeof(fh), 1, f );
			// Write patterns data
			fwrite ( &g_bytePatternsCount, sizeof(g_bytePatternsCount), 1, f );
			fwrite ( &g_byteSequencesCount, sizeof(g_byteSequencesCount), 1, f );
			int s;
			s = MAX_PATTERNS; fwrite ( &s, sizeof(s), 1, f );
			s = MAX_SEQUENCES; fwrite ( &s, sizeof(s), 1, f );
			s = MAX_TEMPLATE_MELODY_LEN; fwrite ( &s, sizeof(s), 1, f );
			fwrite ( g_bytePatterns, sizeof(g_bytePatterns), 1, f );
			fwrite ( g_byteSequences, sizeof(g_byteSequences), 1, f );
			for ( int i = 0; i < byteSequenceNames->Length; i++ ) {
				ZeroMemory ( g_buf, sizeof(g_buf) );
				if ( byteSequenceNames[i] )
					StringToChar ( byteSequenceNames[i]->Substring ( 0, Math::Min ( byteSequenceNames[i]->Length, 64 ) ) );
				fwrite ( g_buf, 64, 1, f );
			}
			for ( int i = 0; i < BytePatternsEditor::bytePatternNames->Length; i++ ) {
				ZeroMemory ( g_buf, sizeof(g_buf) );
				if ( BytePatternsEditor::bytePatternNames[i] )
					StringToChar ( BytePatternsEditor::bytePatternNames[i]->Substring ( 0, Math::Min ( BytePatternsEditor::bytePatternNames[i]->Length, 64 ) ) );
				fwrite ( g_buf, 64, 1, f );
			}
			// Write instruments data
			fwrite ( &g_instrumentCount, sizeof(g_instrumentCount), 1, f );
			for ( int i = 0; i < g_instrumentCount; i++ ) {
				Instrument* ins = g_instruments + i;
				fwrite ( ins, sizeof(Instrument), 1, f );
				for ( int o = 0; o < ins->operCount; o++ )
					fwrite ( ins->oper[o], sizeof(Operation), 1, f );
			}
			fclose ( f );
			return true;
		}

		// Creates new operation by it's type
		Operation* CreateOperation ( int opType ) {
			Operation* op = NULL;
			// We must create correct operation of correct type since it contains byte generation code
			// That's fucking retarded, but it is too late to change it
			if ( opType == OP_PUSH_STREAM )
				op = new PushStreamOperation ( );
			if ( opType == OP_PUSH_CONST )
				op = new PushConstOperation ( );
			if ( opType == OP_PUSH_NOTE )
				op = new PushNoteOperation ( );
			if ( opType == OP_PUSH_TIME )
				op = new PushTimeOperation ( );
			if ( opType == OP_PUSH_CURRENT )
				op = new PushCurrentOperation ( );
			if ( opType == OP_SIN )
				op = new OscSinOperation ( );
			if ( opType == OP_SIN_G )
				op = new OscSinGOperation ( );
			if ( opType == OP_SAW )
				op = new OscSawOperation ( );
			if ( opType == OP_SAW_G )
				op = new OscSawGOperation ( );
			if ( opType == OP_NOISE )
				op = new OscNoiseOperation ( );
			if ( opType == OP_EXP )
				op = new OscExpOperation ( );
			if ( opType == OP_COMPRESS )
				op = new CompressOperation ( );
			if ( opType == OP_MUL )
				op = new MulOperation ( );
			if ( opType == OP_ADD )
				op = new AddOperation ( );
			if ( opType == OP_ADSR )
				op = new AdsrOperation ( );
			if ( opType == OP_LP_FILTER || opType == OP_HP_FILTER || opType == OP_BP_FILTER )
				op = new FilterOperation ( opType );
			if ( opType == OP_PAN )
				op = new PanOperation ( );
			if ( opType == OP_ECHO )
				op = new EchoOperation ( );
			return op;
		}

		// Recreates textboxes
		void RecreateInstrumentTextBoxes ( ) {
			groupBoxInstruments->Controls->Clear ( );
			for ( int i = 0; i < g_instrumentCount; i++ ) {
				TextBox* b = new TextBox ( );
				b->Text = g_instruments[i].name;
				b->Tag = __box ( i );
				b->Dock = DockStyle::Top;
				b->add_TextChanged ( new EventHandler ( this, InstrumentNameChanged ) );
				groupBoxInstruments->Controls->Add ( b );
				b->BackColor = g_instruments[i].mute ? Color::LightGray : Color::White;
			}
		}

		// Opens file
		bool OpenFile ( String* fileName ) {
			FILE* f = fopen ( StringToChar ( fileName ), "rb" );
			if ( !f ) {
				MessageBox::Show ( S"Unable to open file." );
				return false;
			}
			// Read header
			FileHeader fh = {0};
			fread ( &fh, sizeof(fh), 1, f );
			if ( fh.magicWord != '2zub' || LOWORD(fh.version) != 2 ) {
				fclose ( f );
				MessageBox::Show ( S"It is not Buzzic 2 file." );
				return false;
			}
			g_masterVolume = fh.masterVolume;
			dfBPM->Value = fh.bpm;
			startSeq = fh.startSeq;
			endSeq = fh.endSeq;
			cbLooping->Checked = fh.looping;
			// Read patterns data
			fread ( &g_bytePatternsCount, sizeof(g_bytePatternsCount), 1, f );
			fread ( &g_byteSequencesCount, sizeof(g_byteSequencesCount), 1, f );
			int maxPatterns, maxSequences, maxTemplMelodyLen;
			if ( HIWORD(fh.version) >= 1 ) {
				fread ( &maxPatterns, sizeof(maxPatterns), 1, f );
				fread ( &maxSequences, sizeof(maxSequences), 1, f );
				fread ( &maxTemplMelodyLen, sizeof(maxTemplMelodyLen), 1, f );
			} else {
				maxPatterns = 64;
				maxSequences = 64;
				maxTemplMelodyLen = 128;
			}
			char* pat = new char[maxPatterns*16];
			char* seq = new char[maxSequences*maxTemplMelodyLen];
			fread ( pat, maxPatterns*16, 1, f );
			fread ( seq, maxSequences*maxTemplMelodyLen, 1, f );
			ZeroMemory ( g_bytePatterns, sizeof(g_bytePatterns) );
			ZeroMemory ( g_byteSequences, sizeof(g_byteSequences) );
			CopyMemory ( g_bytePatterns, pat, min(maxPatterns,MAX_PATTERNS)*16 );
			for ( int i = 0; i < min(maxSequences,MAX_SEQUENCES); i++ )
				for ( int k = 0; k < min(maxTemplMelodyLen,MAX_TEMPLATE_MELODY_LEN); k++ )
					g_byteSequences[i][k] = *(seq+i*maxTemplMelodyLen+k);
			delete[] pat;
			delete[] seq;
			for ( int i = 0; i < byteSequenceNames->Length; i++ ) {
				ZeroMemory ( g_buf, sizeof(g_buf) );
				fread ( g_buf, 64, 1, f );
				byteSequenceNames[i] = g_buf;
			}
			for ( int i = 0; i < BytePatternsEditor::bytePatternNames->Length; i++ ) {
				ZeroMemory ( g_buf, sizeof(g_buf) );
				fread ( g_buf, 64, 1, f );
				BytePatternsEditor::bytePatternNames[i] = g_buf;
			}
			// Load instruments
			fread ( &g_instrumentCount, sizeof(g_instrumentCount), 1, f );
			for ( int i = 0; i < g_instrumentCount; i++ ) {
				Instrument* ins = g_instruments + i;
				int rb = fread ( ins, sizeof(Instrument), 1, f );
				for ( int o = 0; o < ins->operCount; o++ ) {
					Operation opex;
					fread ( &opex, sizeof(Operation), 1, f );
					Operation *op = CreateOperation ( opex.type );					
					if ( !op ) {
						MessageBox::Show ( S"Bad operation type found. File possibly corrupted." );
						return false;
					}
					// Copy skipping virtual functions table
					CopyMemory ( ((char*)op) + 4, ((char*)&opex) + 4, sizeof(Operation) - 4 );
					ins->oper[o] = op;
				}
			}
			// Redraw panels and other controls
			selectionStart = selectionEnd = selectionDragStart = Point ( -1, -1 );
			RedrawByteSequences ( );
			RecreateInstrumentTextBoxes ( );
			// Refresh patterns
			for ( int i = 0; i < OwnedForms->Count; i++ ) {
				BytePatternsEditor* ed = dynamic_cast<BytePatternsEditor*>(OwnedForms[i]);
				if ( ed )
					ed->RefreshFormPatterns ( -1 );
			}
			sbVolume->Value = Convert::ToInt32 ( g_masterVolume * 100 );
			fclose ( f );
			return true;
		}

protected:	
			// Cleanup on form close
			virtual void OnClosed ( EventArgs* e ) {
				stopPlaying = true;
				if ( playThread )
					playThread->Join ( );
			}

	private: System::Void menuItem12_Click(System::Object *  sender, System::EventArgs *  e)
			 {
				if ( byteFocus.X >= 0 && byteFocus.X < g_byteSequencesCount &&
					 byteFocus.Y >= 0 && byteFocus.Y < MAX_TEMPLATE_MELODY_LEN - 1 ) {
					MoveMemory ( g_byteSequences[byteFocus.X] + byteFocus.Y + 1, g_byteSequences[byteFocus.X] + byteFocus.Y,
						MAX_TEMPLATE_MELODY_LEN - byteFocus.Y - 1 );
					g_byteSequences[byteFocus.X][byteFocus.Y] = 0;
					RedrawByteSequences ( );
				}
			 }

private: System::Void menuItem13_Click(System::Object *  sender, System::EventArgs *  e)
		 {
			if ( byteFocus.X >= 0 && byteFocus.X < g_byteSequencesCount &&
				 byteFocus.Y >= 0 && byteFocus.Y < MAX_TEMPLATE_MELODY_LEN ) {
				MoveMemory ( g_byteSequences[byteFocus.X] + byteFocus.Y, g_byteSequences[byteFocus.X] + byteFocus.Y + 1,
					MAX_TEMPLATE_MELODY_LEN - byteFocus.Y - 1 );
				g_byteSequences[byteFocus.X][MAX_TEMPLATE_MELODY_LEN-1] = 0;
				RedrawByteSequences ( );
			}
		 }

private:
		// Mute/unmute instrument
		System::Void menuItem14_Click ( System::Object *  sender, System::EventArgs *  e ) {
			for ( int i = 0; i < groupBoxInstruments->Controls->Count; i++ )
				if ( groupBoxInstruments->Controls->Item[i]->Focused ) {
					TextBox* t = dynamic_cast<TextBox*>(groupBoxInstruments->Controls->Item[i]);
					i = Convert::ToInt32 ( t->Tag );
					g_instruments[i].mute = !g_instruments[i].mute;
					t->BackColor = g_instruments[i].mute ? Color::LightGray : Color::White;
					return;
				}
		}

private:
		// Renames sequence
		System::Void panelByte_DoubleClick ( System::Object *  sender, System::EventArgs *  e ) {
			Point pt = panelByte->PointToClient ( Control::MousePosition );
			if ( pt.Y / CELL_Y == 0 ) {
				int x = pt.X / CELL_X - 1;
				if ( x >= 0 && x < g_byteSequencesCount ) {
					GetValueForm* f = new GetValueForm ( );
					f->Text = S"Enter sequence name";
					f->dfValue->Text = byteSequenceNames[x];
					if ( DialogResult::Cancel == f->ShowDialog ( NULL ) )
						return;
					byteSequenceNames[x] = f->dfValue->Text;
					RedrawByteSequences ( );
				}
			}/* else {
				if ( Control::ModifierKeys & Keys::Control )
					menuItem13_Click ( this, NULL );
				else
					menuItem12_Click ( this, NULL );
			}*/
		}

private:

		// Translates operator stack from postfix to infix notation
		char* op;
		char* opEnd;
		System::Collections::Stack* opStack; 
		String* GetOperandString ( ) {
			char buf[1024];
			String* s = "";
			if ( OP_PUSH_STREAM == *op ) {
				int v = (int) ( *(op+1) );
				if ( v >= 0 )
					s = ((float)v*0.01f).ToString ( );
				else
					s = String::Format ( "GetFixedOrStreamValue({0})*0.01f", __box ( v ) );
				op += 2;
			} else if ( OP_PUSH_CONST == *op ) {
				float v = *((float*)(op + 1));
				op += 5;
				s = Convert::ToString ( v );
			} else if ( OP_PUSH_NOTE == *op ) {
				int v = *(op+1);
				s = String::Format ( "NoteToFrequency(note{0}{1})", (v>=0?S"+":S""), v.ToString ( ) );
				op += 2;
			} else if ( OP_PUSH_TIME == *op ) {
				op += 1;
				s = "tRel";
			} else if ( OP_EXP == *op ) {
				op += 1;
				s = String::Format ( "pow2({0})", opStack->Pop ( ) );				
			} else if ( OP_SIN == *op ) {
				op += 1;
				s = String::Format ( "my_sin(({0})*tGlobal+({1}))", opStack->Pop ( ), opStack->Pop ( ) );
			} else if ( OP_SIN_G == *op ) {
				op += 1;
				s = String::Format ( "my_sin(({0})*tGlobalSt+({1}))", opStack->Pop ( ), opStack->Pop ( ) );
			} else if ( OP_SAW == *op ) {
				op += 1;
				s = String::Format ( "Sawtooth(({0})*tGlobal+({1}))", opStack->Pop ( ), opStack->Pop ( ) );
			}  else if ( OP_SAW_G == *op ) {
				op += 1;
				s = String::Format ( "Sawtooth(({0})*tGlobalSt+({1}))", opStack->Pop ( ), opStack->Pop ( ) );
			} else if ( OP_NOISE == *op ) {
				op += 1;
				s = "Noise1(s)";
			} else if ( OP_MUL == *op ) {
				op += 1;
				s = String::Format ( "({0})*({1})", opStack->Pop ( ), opStack->Pop ( ) );
			} else if ( OP_ADD == *op ) {
				op += 1;
				s = String::Format ( "({0})+({1})", opStack->Pop ( ), opStack->Pop ( ) );
			} else if ( OP_PAN == *op ) {
				op += 1;
				s = String::Format ( "Pan({1},{0})", opStack->Pop ( ), opStack->Pop ( ) );
			} else if ( OP_PUSH_CURRENT == *op ) {
				op += 1;
				s = "(*b)";
			} else if ( OP_COMPRESS == *op ) {
				int v = ((int)*(op + 1));
				int v1 = ((int)*(op + 2));
				s = String::Format ( "Compress({0},{1},{2})", opStack->Pop ( ), v.ToString ( ), v1.ToString ( ) );
				op += 3;
			} else if ( OP_ADSR == *op ) {
				int v = ((int)*(op + 1));
				int v1 = ((int)*(op + 2));
				int v2 = ((int)*(op + 3));
				int v3 = ((int)*(op + 4));
				s = String::Concat ( String::Format ( "ADSR({0},{1}", v.ToString ( ), v1.ToString ( ) ), 
					String::Format ( ",{0},{1})*({2})", v2.ToString ( ), v3.ToString ( ),  opStack->Pop ( ) ) );
				op += 5;
			} else if ( OP_LP_FILTER == *op || OP_HP_FILTER == *op ) {
				if ( OP_LP_FILTER == *op )
					s = String::Format ( "LPFilter({2},{0},{1})", opStack->Pop ( ), opStack->Pop ( ), opStack->Pop ( ) );
				else
					s = String::Format ( "HPFilter({2},{0},{1})", opStack->Pop ( ), opStack->Pop ( ), opStack->Pop ( ) );
				op += 1;
			} else if ( OP_ECHO == *op ) {
				int v = ((int)*(op + 1));
				s = String::Concat ( String::Format ( "Echo({0},insVolume,{1}", opStack->Pop ( ), v.ToString ( ) ),
					String::Format ( ",{0},{1})", __box((int)*(op+2)), __box((int)*(op+3)) ) );
				op += 4;
			} else {
				s = " !!! ERROR !!! ";
			}

			if ( op >= opEnd )
				return s;
			opStack->Push ( s );
			return GetOperandString ( );
		}

		// Generates C++ source code
		System::Void GenerateCode ( System::Object *  sender, System::EventArgs *  e ) {
			CodeGen *c = dynamic_cast<CodeGen*>(sender);
			StringBuilder* b = new StringBuilder ( );
			StringBuilder* m = new StringBuilder ( );

			// Some check
			if ( c->cbAsync->Checked && c->cbExpandInstrument->Checked ) {
				c->dfCode->Text = "Flag combination not supported yet.";
				return;
			}

			// Generate code
			b->Append ( S"#include <mmsystem.h>\r\n\
const float TIME_OFFSET			= 0;\r\n\
const int SAMPLE_FREQUENCY		= 44100;\r\n\
const int BPM					= " )->Append ( dfBPM->Value )->Append ( S";\r\n\
const int TEMPLATE_MELODY_LEN	= " )->Append ( endSeq + 1 )->Append ( S";\r\n\
const float MASTER_VOLUME		= " )->Append ( sbVolume->Value * 0.01f )->Append ( "f;\r\n\
const int SAMPLE_FREQUENCY_01	= (int)(0.01*SAMPLE_FREQUENCY);\r\n\
const int ROW_COUNT				= 16 * TEMPLATE_MELODY_LEN;\r\n\
const int PLAY_TIME				= ROW_COUNT * 60 / ( BPM * 4 );\r\n\
const int ROW_SIZE_SAMPLES		= SAMPLE_FREQUENCY * 60 / ( BPM * 4 );\r\n\
const float ROW_LEN_SEC			= 60.0f / ( BPM * 4 );\r\n\
const float PI					= 3.1415926535f;\r\n\
const float PI_2				= 2*PI;\r\n\
HWAVEOUT	g_wo;\r\n\
int			g_patternNo;\r\n\
int			g_patternRowNo;\r\n\
enum {	OP_PUSH_STREAM, OP_PUSH_CONST, OP_PUSH_NOTE, OP_PUSH_TIME,\r\n\
		OP_SIN, OP_SAW, OP_NOISE, OP_EXP, OP_COMPRESS,\r\n\
		OP_MUL, OP_ADD,\r\n\
		OP_ADSR,\r\n\
		OP_LP_FILTER, OP_HP_FILTER, OP_BP_FILTER,\r\n\
		OP_PAN,\r\n\
		OP_ECHO,\r\n\
		OP_PUSH_CURRENT,\r\n\
		OP_SIN_G, OP_SAW_G\r\n\
};\r\n\
struct Instrument {\r\n\
	char note;\r\n\
	char noteLen;\r\n\
	char volume;\r\n" )->Append ( c->cbExpandInstrument->Checked ? "" : "	unsigned char programLen;\r\n" )->Append ( "\
};\r\n" )->Append ( c->cbExpandInstrument->Checked ? "" : "char program[] = {\r\n" );
			if ( !c->cbExpandInstrument->Checked ) {
				for ( int i = 0; i < g_instrumentCount; i++ ) {
					b->Append ( "// ")->Append ( g_instruments[i].name )->Append ( "\r\n" );
					for ( int k = 0; k < g_instruments[i].programLen; k++ )
						b->Append ( (int)g_instruments[i].stack[k] )->Append ( "," );
					b->Append ( "\r\n" );
				}
				b->Append ( S"};\r\n" );
			}
			b->Append ( "\
Instrument g_instruments[] = {\r\n" );
			for ( int i = 0; i < g_instrumentCount; i++ ) {
				b->Append ( "{" )->Append ( (int)g_instruments[i].note )->Append ( "," );
				b->Append ( (int)g_instruments[i].noteLen )->Append ( "," );
				b->Append ( (int)g_instruments[i].volume )->Append ( "," );
				if ( !c->cbExpandInstrument->Checked )
					b->Append ( (int)g_instruments[i].programLen )->Append ( "," );
				b->Append ( "},\r\n" );
			}
			b->Append ( S"};\r\n\
const char g_bytePatterns[][16] = { \r\n" );
			for ( int i = 0; i < g_bytePatternsCount; i++ ) {
				b->Append ( "{" );
				for ( int k = 0; k < 16; k++ )
					b->Append ( (int)g_bytePatterns[i][k] )->Append ( "," );
				b->Append ( "},\r\n" );
			}
			b->Append ( S"};\r\n\
const char g_byteSequences[][TEMPLATE_MELODY_LEN] = {\r\n" );
			for ( int i = 0; i < g_byteSequencesCount; i++ ) {
				b->Append ( "{" );
				for ( int k = 0; k < endSeq + 1; k++ )
					b->Append ( (int)g_byteSequences[i][k] )->Append ( "," );
				b->Append ( "},\r\n" );
			}
			b->Append ( S"};\r\n\
float my_fabs ( float v ) {\r\n\
	__asm {\r\n\
		fld v\r\n\
		fabs\r\n\
		fstp v\r\n\
	}\r\n\
	return v;\r\n\
}\r\n\
float my_sin ( float v ) {\r\n\
	__asm {\r\n\
		fld v\r\n\
		fsin\r\n\
		fstp v\r\n\
	}\r\n\
	return v;\r\n\
}\r\n\
int __cdecl _ftol ( float fvar ) {\r\n\
	int lvar;\r\n\
	__asm {\r\n\
		fld dword ptr fvar\r\n\
		fistp dword ptr lvar\r\n\
	}\r\n\
	return lvar;\r\n\
}\r\n\
float __cdecl pow2 ( float x ) {\r\n\
	float y;\r\n\
	__asm {\r\n\
		fld dword ptr x\r\n\
		fld st(0)\r\n\
		frndint\r\n\
		fxch st(1)\r\n\
		fsub st(0),st(1)\r\n\
		f2xm1\r\n\
		fld1\r\n\
		faddp st(1),st(0)\r\n\
		fscale\r\n\
		fstp st(1)\r\n\
		fstp dword ptr y\r\n\
	}\r\n\
	return y;\r\n\
}\r\n\
float Noise1 ( int x ) {\r\n\
    x = (x<<13) ^ x;\r\n\
    return (float)( 1.0f - ( (x * (x * x * 15731 + 789221) + 1376312589) & 0x7fffffff) / 1073741824.0f);\r\n\
}\r\n\
float my_sqrt ( float v ) {\r\n\
	__asm {\r\n\
		fld v\r\n\
		fsqrt\r\n\
		fstp v\r\n\
	}\r\n\
	return v;\r\n\
}\r\n\
float Sawtooth ( float x ) {\r\n\
	x /= PI_2;\r\n\
	return x - _ftol ( x );\r\n\
}\r\n\
float NoteToFrequency ( char note ) {\r\n\
	return PI_2 * 440.0f * pow2 ( (note-45)/12.0f );\r\n\
}\r\n\
char GetFixedOrStreamValue ( char val ) {\r\n\
	if ( val >= 0 )\r\n\
		return val;\r\n" )->Append ( S"\
	val = -val;\r\n\
	int k = g_byteSequences[val-1][g_patternNo];\r\n\
	if ( k )\r\n\
		return g_bytePatterns[k-1][g_patternRowNo];\r\n\
	return 0;\r\n\
}\r\n" );


			//
			// Asynchronous
			//
			if ( c->cbAsync->Checked )
				b->Append ( S"\
void MyZeroMemory ( int* ptr, int cntWords ) {\r\n\
	for ( int i = 0; i < cntWords; i++ )\r\n\
		*(ptr++) = 0;\r\n\
}\r\n\
void MyMoveMemory ( int* dst, int* src, int cntWords ) {\r\n\
	for ( int i = 0; i < cntWords; i++ )\r\n\
		*(dst++) = *(src++);\r\n\
}\r\n\
// Fills buffer for one note\r\n\
__inline void FillNoteBuffer ( float* data, Instrument* ins, char* prog, float tStart ) {\r\n\
	int noteLenSamples = GetFixedOrStreamValue ( ins->noteLen ) * (ROW_SIZE_SAMPLES/8);		// Can cause problems in channel compression. If so, remove brackets\r\n\
	float insVolume = GetFixedOrStreamValue ( ins->volume ) * 0.01f;\r\n" )->Append ( S"\
	// Channels\r\n\
	for ( int ch = 0; ch < 2; ch++ ) {\r\n\
		char* ip = prog;\r\n\
		// Process stack\r\n\
		char note = GetFixedOrStreamValue ( ins->note );\r\n\
		if ( !note )\r\n\
			return;\r\n\
		float *b = data + ch;\r\n\
		// Zero filter memory\r\n\
		float stack[128], tmp1, tmp2;\r\n\
		float filterData[256];\r\n\
		MyZeroMemory ( (int*)filterData, sizeof(filterData)/4 );\r\n\
		// Generate sample\r\n\
		for ( int s = 0; s < noteLenSamples; s++, b += 2 ) {\r\n\
			float tRel = (float) s / noteLenSamples;\r\n" )->Append ( S"\
			float tGlobal = (float)s / SAMPLE_FREQUENCY;\r\n\
			float tGlobalSt = tGlobal + tStart;\r\n\
			float* sp = stack;\r\n\
			int pp = 0;\r\n\
			float *curFilt = filterData;\r\n\
			while ( pp < ins->programLen ) {\r\n\
				char op = ip[pp];\r\n\
				if ( OP_PUSH_STREAM == op ) { *(sp++) = GetFixedOrStreamValue ( ip[pp+1] ) * 0.01f; pp += 2; }\r\n\
				if ( OP_PUSH_CONST == op ) { *(sp++) = *((float*)(ip + pp + 1)); pp += 5; }\r\n\
				if ( OP_PUSH_NOTE == op ) { *(sp++) = NoteToFrequency ( note + ip[pp+1] ); pp += 2; }\r\n\
				if ( OP_PUSH_TIME == op ) { *(sp++) = tRel; pp++; }\r\n" )->Append ( S"\
				if ( OP_EXP == op ) { tmp1 = *(--sp); *(sp++) = pow2 ( tmp1 ); pp++; }\r\n\
				if ( OP_SIN == op ) { tmp1 = *(--sp); tmp2 = *(--sp); *(sp++) = my_sin ( tmp1 * tGlobal + tmp2 ); pp++; }\r\n\
				if ( OP_SIN_G == op ) { tmp1 = *(--sp); tmp2 = *(--sp); *(sp++) = my_sin ( tmp1 * tGlobalSt + tmp2 ); pp++; }\r\n\
				if ( OP_SAW == op ) { tmp1 = *(--sp); tmp2 = *(--sp); *(sp++) = Sawtooth ( tmp1 * tGlobal + tmp2 ); pp++; }\r\n\
				if ( OP_SAW_G == op ) { tmp1 = *(--sp); tmp2 = *(--sp); *(sp++) = Sawtooth ( tmp1 * tGlobalSt + tmp2 ); pp++; }\r\n\
				if ( OP_NOISE == op ) { *(sp++) = Noise1 ( s ); pp++; }\r\n" )->Append ( S"\
				if ( OP_MUL == op ) { tmp1 = *(--sp); tmp2 = *(--sp); *(sp++) = tmp1 * tmp2; pp++; }\r\n\
				if ( OP_ADD == op ) { tmp1 = *(--sp); tmp2 = *(--sp); *(sp++) = tmp1 + tmp2; pp++; }\r\n\
				if ( OP_PAN == op ) { tmp1 = *(--sp); tmp2 = *(--sp); *(sp++) = tmp2 * (ch ? tmp1 : my_sqrt(1.0f-tmp1*tmp1)); pp++; }\r\n\
				if ( OP_PUSH_CURRENT == op ) { *(sp++) = *b; pp++; }\r\n\
				if ( OP_COMPRESS == op ) { \r\n\
					float l1 = ip[pp+1]*0.01f, l2 = ip[pp+2]*0.01f;\r\n\
					tmp1 = *(--sp); \r\n\
					float v = my_fabs(tmp1) - l1;\r\n\
					if ( v > 0.0 ) {\r\n\
						v = l2 - (l2-l1) / ( 1.0f + v / (l2-l1) );\r\n\
						if ( tmp1 > 0.0 )\r\n\
							tmp1 = v;\r\n\
						else\r\n\
							tmp1 = -v;\r\n\
					}\r\n\
					*(sp++) = tmp1; \r\n\
					pp += 3; \r\n\
				}\r\n\
				if ( OP_ADSR == op ) {\r\n\
					float t1 = ip[pp+1] * 0.01f;\r\n\
					float t2 = ip[pp+2] * 0.01f;\r\n\
					float t3 = ip[pp+3] * 0.01f;\r\n\
					float l = ip[pp+4] * 0.01f;\r\n\
					float adsr;\r\n\
					if ( tRel < t1 )\r\n\
						adsr = tRel / t1;\r\n\
					else if ( tRel < t2 )\r\n" )->Append ( S"\
						adsr = 1.0f - ( 1.0f - l ) * ( tRel - t1 ) / ( t2 - t1 );\r\n\
					else if ( tRel < t3 )\r\n\
						adsr = l;\r\n\
					else\r\n\
						adsr = l * ( 1.0f - tRel  ) / ( 1.0f - t3 );\r\n\
					*(sp++) = *(--sp) * adsr;\r\n\
					pp += 5;\r\n\
				}\r\n\
				if ( OP_LP_FILTER == op || OP_HP_FILTER == op ) {\r\n\
					tmp1 = *(--sp) / (PI*0.35f*SAMPLE_FREQUENCY);		// Frequency\r\n\
					tmp2 = *(--sp);										// Quality\r\n\
					float in = *(--sp);\r\n\
					float fb = tmp2 + tmp2 / ( 1.0f - tmp1 );\r\n\
					curFilt[0] = curFilt[0] + tmp1 * ( in - curFilt[0] + fb * ( curFilt[0] - curFilt[1] ) );\r\n\
					float y = curFilt[1] = curFilt[1] + tmp1 * ( curFilt[0] - curFilt[1] );\r\n\
					if ( OP_HP_FILTER == op )\r\n\
						y = in - y;\r\n\
					*(sp++) = y;\r\n\
					pp++;\r\n\
					curFilt += 2;\r\n\
				}\r\n\
				// Remove panning if not needed\r\n\
				if ( OP_ECHO == op ) {\r\n\
					float t1 = ip[pp+1] * 0.01f;\r\n\
					float y = (*(--sp))*insVolume;\r\n\
					float yold = y;\r\n\
					float *bb1 = b;\r\n\
					int delay = (ROW_SIZE_SAMPLES/8) * 2 * ip[pp+2];\r\n" )->Append ( S"\
					bool pan = false;\r\n\
					if ( delay < 0 ) {\r\n\
						pan = true;\r\n\
						delay *= -1;\r\n\
					}\r\n\
					for ( int k = 0; k < ip[pp+3]; k++ ) {\r\n\
						bb1 += delay;\r\n\
						y *= t1;\r\n\
						*bb1 += ( pan ? y*((k+0)%2 == ch) : y );\r\n\
					}\r\n\
					*(sp++) = yold;\r\n\
					pp += 4;\r\n\
				}\r\n\
			}\r\n\
			// Write sample out\r\n\
			*b += (*(--sp))*insVolume;\r\n\
		}\r\n\
	}\r\n\
}\r\n" )->Append ( S"\
\r\n\
// Plays melody\r\n\
DWORD WINAPI PlayThreadProc ( LPVOID ) {\r\n\
	// Create output device and prepare melody buffers\r\n\
	WAVEFORMATEX wfx = { WAVE_FORMAT_PCM, 2, SAMPLE_FREQUENCY, SAMPLE_FREQUENCY*4, 4, 16, 0 };\r\n\
	waveOutOpen ( &g_wo, WAVE_MAPPER, &wfx, NULL, 0, CALLBACK_NULL );\r\n\
\r\n\
	// Allocate (hopefully) enough space to play one row\r\n\
	SetThreadPriority ( GetCurrentThread ( ), THREAD_PRIORITY_HIGHEST );\r\n\
	const int MAX_BUF_SAMPLES = ROW_SIZE_SAMPLES*10 + 4*SAMPLE_FREQUENCY;\r\n\
	float data[MAX_BUF_SAMPLES*2];\r\n\
	MyZeroMemory ( (int*)data, MAX_BUF_SAMPLES*2*sizeof(float)/4 );\r\n\
\r\n\
	// Prepare buffers\r\n\
	short oneRowShortBuf[2][MAX_BUF_SAMPLES*2];\r\n" )->Append ( S"\
	WAVEHDR hdrs[2];\r\n\
	bool bufBusy[2];\r\n\
	for ( int i = 0; i < 2; i++ ) {\r\n\
		MyZeroMemory ( (int*)(hdrs + i), sizeof(WAVEHDR)/4 );\r\n\
		bufBusy[i] = false;\r\n\
		hdrs[i].lpData = (LPSTR) oneRowShortBuf[i];\r\n\
		hdrs[i].dwBufferLength = 2*ROW_SIZE_SAMPLES*sizeof(short);\r\n\
		waveOutPrepareHeader ( g_wo, hdrs + i, sizeof(WAVEHDR) );\r\n\
	}\r\n\
	int curHdr = 0;\r\n\
\r\n\
	// Loop through all rows. Send one row at once\r\n" )->Append ( S"\
	const int INSTRUMENT_COUNT = sizeof(g_instruments)/sizeof(Instrument);\r\n\
	for ( int r = 0; r < ROW_COUNT; r++ ) {\r\n\
		// Move previously created (but not played) melody part to the buffer start\r\n\
		MyMoveMemory ( (int*)data, (int*)data + ROW_SIZE_SAMPLES*2, (MAX_BUF_SAMPLES-ROW_SIZE_SAMPLES)*2*sizeof(float)/4 );\r\n\
		MyZeroMemory ( (int*)(data + (MAX_BUF_SAMPLES-ROW_SIZE_SAMPLES)*2), ROW_SIZE_SAMPLES*2*sizeof(float)/4 );\r\n\
		// Play instruments\r\n\
		g_patternNo = ( r >> 4 );\r\n\
		g_patternRowNo = ( r & 0xF );\r\n\
		char* pr = program;\r\n\
		for ( int i = 0; i < INSTRUMENT_COUNT; i++ ) {\r\n" )->Append ( S"\
			FillNoteBuffer ( data, g_instruments + i, pr, (float)(r*ROW_SIZE_SAMPLES)/SAMPLE_FREQUENCY );\r\n\
			pr += g_instruments[i].programLen;\r\n\
		}\r\n\
		// Wait for currently playing buffer to stop\r\n\
		while ( bufBusy[curHdr] && !(hdrs[curHdr].dwFlags & WHDR_DONE) )\r\n\
			Sleep ( 5 );\r\n\
		hdrs[curHdr].dwFlags &= ~WHDR_DONE;\r\n\
		// Copy array to output\r\n\
		short *s = (short*) hdrs[curHdr].lpData;\r\n\
		float *b1 = data;\r\n\
		for ( int i = 0; i < ROW_SIZE_SAMPLES*2; i++ )\r\n" )->Append ( S"\
			*(s++) = _ftol ( 32760 * (*(b1++)) * MASTER_VOLUME );\r\n\
		// Send data to audio device and advance to next buffer\r\n\
		bufBusy[curHdr] = true;\r\n\
		waveOutWrite ( g_wo, hdrs + curHdr, sizeof(WAVEHDR) );\r\n\
		curHdr = (curHdr + 1)%2;\r\n\
	}\r\n\
	waveOutReset ( g_wo );\r\n\
	return 0;\r\n\
}\r\n\
\r\n\
// Creates and play sound\r\n\
__inline void CreateAndPlaySynth ( ) {\r\n\
	HANDLE hThread = CreateThread ( 0, 10*1024*1024, PlayThreadProc, 0, 0, 0 );\r\n\
}" );

/*
// Old MOOG filter
if ( OP_LP_FILTER == op || OP_HP_FILTER == op || OP_BP_FILTER == op ) {\r\n\
							tmp1 = *(--sp) / (PI*SAMPLE_FREQUENCY);\r\n\
							tmp2 = *(--sp);\r\n\
							float in = *(--sp);\r\n\
							float f, p, q;\r\n\
							float t1, t2;\r\n\
							q = 1.0f - tmp1;\r\n\
							p = tmp1 + 0.8f * tmp1 * q;\r\n\
							f = p + p - 1.0f;\r\n\
							q = tmp2 * (1.0f + 0.5f * q * (1.0f - q + 5.6f * q * q));\r\n\
							in -= q * curFilt[4];\r\n\
							t1 = curFilt[1];	curFilt[1] = (in + curFilt[0]) * p - curFilt[1] * f;\r\n\
							t2 = curFilt[2];	curFilt[2] = (curFilt[1] + t1) * p - curFilt[2] * f;\r\n\
							t1 = curFilt[3];	curFilt[3] = (curFilt[2] + t2) * p - curFilt[3] * f;\r\n\
												curFilt[4] = (curFilt[3] + t1) * p - curFilt[4] * f;\r\n\
							curFilt[4] = curFilt[4] - curFilt[4] * curFilt[4] * curFilt[4] * 0.166667f;\r\n\
							curFilt[0] = in;\r\n\
							float y = curFilt[4];\r\n\
							if ( OP_HP_FILTER == op )\r\n\
								y = in - y;\r\n\
							if ( OP_BP_FILTER == op )\r\n\
								y = 3.0f * (curFilt[3] - y);\r\n\
							*(sp++) = y;\r\n\
							pp++;\r\n\
							curFilt += 6;\r\n\
						}\r\n
*/

			//
			// Synchronous
			//
			if ( !c->cbAsync->Checked ) {
				StringBuilder* instrumentBlock = new StringBuilder ( );
				instrumentBlock->Append ( S"\
					while ( pp < ins->programLen ) {\r\n\
						char op = ip[pp];\r\n\
						if ( OP_PUSH_STREAM == op ) { *(sp++) = GetFixedOrStreamValue ( ip[pp+1] ) * 0.01f; pp += 2; }\r\n\
						if ( OP_PUSH_CONST == op ) { *(sp++) = *((float*)(ip + pp + 1)); pp += 5; }\r\n\
						if ( OP_PUSH_NOTE == op ) { *(sp++) = NoteToFrequency ( note + ip[pp+1] ); pp += 2; }\r\n\
						if ( OP_PUSH_TIME == op ) { *(sp++) = tRel; pp++; }\r\n" )->Append ( S"\
						if ( OP_EXP == op ) { tmp1 = *(--sp); *(sp++) = pow2 ( tmp1 ); pp++; }\r\n\
						if ( OP_SIN == op ) { tmp1 = *(--sp); tmp2 = *(--sp); *(sp++) = my_sin ( tmp1 * tGlobal + tmp2 ); pp++; }\r\n\
						if ( OP_SIN_G == op ) { tmp1 = *(--sp); tmp2 = *(--sp); *(sp++) = my_sin ( tmp1 * tGlobalSt + tmp2 ); pp++; }\r\n\
						if ( OP_SAW == op ) { tmp1 = *(--sp); tmp2 = *(--sp); *(sp++) = Sawtooth ( tmp1 * tGlobal + tmp2 ); pp++; }\r\n\
						if ( OP_SAW_G == op ) { tmp1 = *(--sp); tmp2 = *(--sp); *(sp++) = Sawtooth ( tmp1 * tGlobalSt + tmp2 ); pp++; }\r\n\
						if ( OP_NOISE == op ) { *(sp++) = Noise1 ( s ); pp++; }\r\n\
						if ( OP_MUL == op ) { tmp1 = *(--sp); tmp2 = *(--sp); *(sp++) = tmp1 * tmp2; pp++; }\r\n\
						if ( OP_ADD == op ) { tmp1 = *(--sp); tmp2 = *(--sp); *(sp++) = tmp1 + tmp2; pp++; }\r\n\
						if ( OP_PAN == op ) { tmp1 = *(--sp); tmp2 = *(--sp); *(sp++) = tmp2 * (ch ? tmp1 : my_sqrt(1.0f-tmp1*tmp1)); pp++; }\r\n\
						if ( OP_PUSH_CURRENT == op ) { *(sp++) = *b; pp++; }\r\n" )->Append ( S"\
						if ( OP_COMPRESS == op ) { \r\n\
							float l1 = ip[pp+1]*0.01f, l2 = ip[pp+2]*0.01f;\r\n\
							tmp1 = *(--sp); \r\n\
							float v = my_fabs(tmp1) - l1;\r\n\
							if ( v > 0.0 ) {\r\n\
								v = l2 - (l2-l1) / ( 1.0f + v / (l2-l1) );\r\n\
								if ( tmp1 > 0.0 )\r\n\
									tmp1 = v;\r\n\
								else\r\n\
									tmp1 = -v;\r\n\
							}\r\n" )->Append ( S"\
							*(sp++) = tmp1; \r\n\
							pp += 3; \r\n\
						}\r\n\
						if ( OP_ADSR == op ) {\r\n\
							float t1 = ip[pp+1] * 0.01f;\r\n\
							float t2 = ip[pp+2] * 0.01f;\r\n\
							float t3 = ip[pp+3] * 0.01f;\r\n\
							float l = ip[pp+4] * 0.01f;\r\n\
							float adsr;\r\n\
							if ( tRel < t1 )\r\n\
								adsr = tRel / t1;\r\n\
							else if ( tRel < t2 )\r\n\
								adsr = 1.0f - ( 1.0f - l ) * ( tRel - t1 ) / ( t2 - t1 );\r\n\
							else if ( tRel < t3 )\r\n\
								adsr = l;\r\n\
							else\r\n\
								adsr = l * ( 1.0f - tRel  ) / ( 1.0f - t3 );\r\n\
							*(sp++) = *(--sp) * adsr;\r\n\
							pp += 5;\r\n\
						}\r\n" )->Append ( S"\
						if ( OP_LP_FILTER == op || OP_HP_FILTER == op ) {\r\n\
							tmp1 = *(--sp) / (PI*0.35f*SAMPLE_FREQUENCY);		// Frequency\r\n\
							tmp2 = *(--sp);										// Quality\r\n\
							float in = *(--sp);\r\n\
							float fb = tmp2 + tmp2 / ( 1.0f - tmp1 );\r\n\
							curFilt[0] = curFilt[0] + tmp1 * ( in - curFilt[0] + fb * ( curFilt[0] - curFilt[1] ) );\r\n\
							float y = curFilt[1] = curFilt[1] + tmp1 * ( curFilt[0] - curFilt[1] );\r\n\
							if ( OP_HP_FILTER == op )\r\n\
								y = in - y;\r\n\
							*(sp++) = y;\r\n\
							pp++;\r\n\
							curFilt += 2;\r\n\
						}\r\n" )->Append ( S"\
						// Remove panning if not needed\r\n\
						if ( OP_ECHO == op ) {\r\n\
							float t1 = ip[pp+1] * 0.01f;\r\n\
							float y = (*(--sp))*insVolume;\r\n\
							float yold = y;\r\n\
							float *bb1 = b;\r\n\
							int delay = (ROW_SIZE_SAMPLES/8) * 2 * ip[pp+2];\r\n\
							bool pan = false;\r\n\
							if ( delay < 0 ) {\r\n\
								pan = true;\r\n\
								delay *= -1;\r\n\
							}\r\n\
							for ( int k = 0; k < ip[pp+3]; k++ ) {\r\n\
								bb1 += delay;\r\n" )->Append ( S"\
								y *= t1;\r\n\
								*bb1 += ( pan ? y*((k+r)%2 == ch) : y );\r\n\
							}\r\n\
							*(sp++) = yold;\r\n\
							pp += 4;\r\n\
						}\r\n\
					}\r\n\
					*b += (*(--sp))*insVolume;\r\n" );

				// Expand instruments
				if ( c->cbExpandInstrument->Checked ) {
					b->Append ( S"\
float* curFilt;\r\n\
float LPFilter ( float in, float freq, float q ) {\r\n\
	float tmp1 = freq / (PI*0.35f*SAMPLE_FREQUENCY);		// Frequency\r\n\
	float tmp2 = q;										// Quality\r\n\
	float fb = tmp2 + tmp2 / ( 1.0f - tmp1 );\r\n\
	curFilt[0] = curFilt[0] + tmp1 * ( in - curFilt[0] + fb * ( curFilt[0] - curFilt[1] ) );\r\n\
	float y = curFilt[1] = curFilt[1] + tmp1 * ( curFilt[0] - curFilt[1] );\r\n\
	curFilt += 2;\r\n\
	return y;\r\n\
}\r\n\
float HPFilter ( float in, float freq, float q ) {\r\n\
	float tmp1 = freq / (PI*0.35f*SAMPLE_FREQUENCY);\r\n\
	float tmp2 = q;\r\n\
	float fb = tmp2 + tmp2 / ( 1.0f - tmp1 );\r\n\
	curFilt[0] = curFilt[0] + tmp1 * ( in - curFilt[0] + fb * ( curFilt[0] - curFilt[1] ) );\r\n\
	float y = curFilt[1] = curFilt[1] + tmp1 * ( curFilt[0] - curFilt[1] );\r\n\
	y = in - y;\r\n\
	curFilt += 2;\r\n\
	return y;\r\n\
}\r\n\
float tRel;\r\n\
float ADSR ( int a, int d, int s, int sl ) {\r\n\
	float t1 = a * 0.01f;\r\n\
	float t2 = d * 0.01f;\r\n\
	float t3 = s * 0.01f;\r\n\
	float l = sl * 0.01f;\r\n\
	if ( tRel < t1 )\r\n\
		return tRel / t1;\r\n" )->Append ( "\
	else if ( tRel < t2 )\r\n\
		return 1.0f - ( 1.0f - l ) * ( tRel - t1 ) / ( t2 - t1 );\r\n\
	else if ( tRel < t3 )\r\n\
		return l;\r\n\
	else\r\n\
		return l * ( 1.0f - tRel  ) / ( 1.0f - t3 );\r\n\
}\r\n\
int ch;\r\n\
float Pan ( float in, float p ) {\r\n\
	return in * (ch ? p : my_sqrt(1.0f-p*p));\r\n\
}\r\n\
float* b;\r\n\
int r;\r\n\
float Echo ( float in, float insVolume, int damp, int delay, int count ) {\r\n\
	float y = in*insVolume;\r\n\
	float yold = y;\r\n\
	float *bb1 = b;\r\n\
	delay = (ROW_SIZE_SAMPLES/8) * 2 * delay;\r\n\
	bool pan = false;\r\n\
	if ( delay < 0 ) {\r\n\
		pan = true;\r\n\
		delay *= -1;\r\n\
	}\r\n\
	for ( int k = 0; k < count; k++ ) {\r\n\
		bb1 += delay;\r\n\
		y *= damp*0.01f;\r\n\
		*bb1 += ( pan ? y*((k+r)%2 == ch) : y );\r\n\
	}\r\n\
	return yold;\r\n\
}\r\n\
float Compress ( float in, int a, int b ) {\r\n\
	float l1 = a * 0.01f, l2 = b * 0.01f;\r\n\
	float v = my_fabs(in) - l1;\r\n\
	if ( v > 0.0 ) {\r\n\
		v = l2 - (l2-l1) / ( 1.0f + v / (l2-l1) );\r\n\
		if ( in > 0.0 )\r\n\
			in = v;\r\n\
		else\r\n\
			in = -v;\r\n\
	}\r\n\
	return in;\r\n\
}\r\n" );
					// Instrument expanding
					instrumentBlock->Length = 0;
					instrumentBlock->Append ( "					float y;\r\n" );
					for ( int i = 0; i < g_instrumentCount; i++ ) {
						Instrument* ins = g_instruments + i;
						opStack = new System::Collections::Stack ( );
						op = ins->stack;
						opEnd = op + ins->programLen;
						String* s = GetOperandString ( );
						if ( opStack->Count > 0 )
							s = "!!! ERROR - stack corrupted !!!";
						instrumentBlock->Append ( "					" )->Append ( i>0?S"else ":S"" )->Append ( "if ( i == " )->Append ( i )->Append ( " )\r\n" )
							->Append ( "						y = " )->Append ( s )->Append ( ";\r\n" );
					}
					instrumentBlock->Append ( "					*b += y*insVolume;\r\n" );
				}
				b->Append ( S"\
WAVEFORMATEX wfx = { WAVE_FORMAT_PCM, 2, SAMPLE_FREQUENCY, SAMPLE_FREQUENCY*4, 4, 16, 0 };\r\n\
short finalBuf[(PLAY_TIME+20)*SAMPLE_FREQUENCY*2] = {0}; // We need +20 since some sounds (e.g. echoed) can last for a long time. Hope it's large enough :)\r\n\
float data[(PLAY_TIME+20)*SAMPLE_FREQUENCY*2] = {0};\r\n\
WAVEHDR hdr = {0};\r\n" )->Append ( S"\r\n\
// Creates large buffer and fills it with samples. Starts playing generated sound.\r\n\
// Pefroms no error checking and does not dispose resources.\r\n\
void CreateAndPlaySynth ( ) {\r\n\
	waveOutOpen ( &g_wo, WAVE_MAPPER, &wfx, NULL, 0, CALLBACK_NULL );\r\n\
	// Loop through all channels, instruments, rows and create sound for each one of them independently\r\n\
	const int INSTRUMENT_COUNT = sizeof(g_instruments)/sizeof(Instrument);\r\n\
	// Channels\r\n\
	for ( " )->Append ( c->cbExpandInstrument->Checked ? "" : "int " )->Append ( "ch = 0; ch < 2; ch++ ) {\r\n" )
	->Append ( c->cbExpandInstrument->Checked ? "" : "		char* ip = program;\r\n" )->Append ( "\
		// Instruments\r\n\
		for ( int i = 0; i < INSTRUMENT_COUNT; i++ ) {\r\n\
			Instrument* ins = g_instruments + i;\r\n\
			// Rows\r\n\
			for ( " )->Append ( c->cbExpandInstrument->Checked ? "" : "int " )->Append ( " r = 0; r < ROW_COUNT; r++ ) {\r\n\
				g_patternNo = ( r >> 4 );\r\n\
				g_patternRowNo = ( r & 0xF );\r\n\
				char note = GetFixedOrStreamValue ( ins->note );\r\n\
				if ( !note )\r\n\
					continue;\r\n\
					" )->Append ( c->cbExpandInstrument->Checked ? "" : "float *" )->Append ( "b = data + ch + ROW_SIZE_SAMPLES*r*2;\r\n" )->Append ( S"\
				int noteLenSamples = GetFixedOrStreamValue ( ins->noteLen ) * (ROW_SIZE_SAMPLES/8);	// Can cause problems in channel compression. If so, remove brackets\r\n\
				float insVolume = GetFixedOrStreamValue ( ins->volume ) * 0.01f;\r\n" )->Append ( S"\
				// Zero filter memory\r\n\
				float stack[128], tmp1, tmp2;\r\n\
				float filterData[256];\r\n\
				for ( int i1 = 0; i1 < sizeof(filterData)/sizeof(float); i1++ ) filterData[i1] = 0;\r\n\
				float tStart = (float)(r*ROW_SIZE_SAMPLES) / SAMPLE_FREQUENCY;\r\n\
				// Generate sample\r\n\
				for ( int s = 0; s < noteLenSamples; s++, b += 2 ) {\r\n\
					" )->Append ( c->cbExpandInstrument->Checked ? "" : "float " )->Append ( "tRel = (float) s / noteLenSamples;\r\n\
					float tGlobal = (float)s / SAMPLE_FREQUENCY;\r\n\
					float tGlobalSt = tGlobal + tStart;\r\n" )->Append ( c->cbExpandInstrument->Checked ? "" : "\
					float* sp = stack;\r\n\
					int pp = 0;\r\n" )->Append ( "\
					" )->Append ( c->cbExpandInstrument->Checked ? "" : "float *" )->Append ( S"curFilt = filterData;\r\n" 
					)->Append ( instrumentBlock->ToString ( ) )->Append ( "\
				}\r\n\
			}\r\n\
			" )->Append ( c->cbExpandInstrument->Checked ? "\r\n" : "ip += ins->programLen;\r\n" )->Append ( "\
		}\r\n\
	}\r\n\
	// Copy just generated sound to audio buffer and play it\r\n\
	short *s = finalBuf;\r\n\
	float *d = data;\r\n\
	for ( int i = 0; i < 2*PLAY_TIME*SAMPLE_FREQUENCY; i++ )\r\n\
		*(s++) = _ftol ( 32000.0f * (*(d++)) * MASTER_VOLUME );\r\n\
	hdr.lpData = (LPSTR) ( finalBuf + 2*(int)(TIME_OFFSET*SAMPLE_FREQUENCY));\r\n\
	hdr.dwBufferLength  = (PLAY_TIME-TIME_OFFSET)*SAMPLE_FREQUENCY*sizeof(short)*2;\r\n\
	waveOutPrepareHeader ( g_wo, &hdr, sizeof(hdr) );\r\n\
	waveOutWrite ( g_wo, &hdr, sizeof(hdr) );\r\n\
}" );
			}
			c->dfCode->Text = b->ToString ( );

			// Perform some correctness testing
			// Check patterns usage
			StringBuilder* bs = new StringBuilder ( );
			for ( int p = 0; p < g_bytePatternsCount; p++ ) {
				bool found = false;
				for ( int s = 0; s < g_byteSequencesCount; s++ )
					for ( int j = 0; j <= endSeq; j++ )
						if ( g_byteSequences[s][j] == p + 1 )
							found = true;
				if ( !found ) {
					if ( bs->Length > 0 )
						bs->Append ( ", " );
					bs->Append ( BytePatternsEditor::bytePatternNames[p] );
				}
			}
			if ( bs->Length > 0 )
				m->Append ( "Unused patterns (will NOT be removed): " )->Append ( bs )->Append ( "\r\n" );
			// Check sequence usage
			bs->Length = 0;
			for ( int s = 0; s < g_byteSequencesCount; s++ ) {
				bool found = false;
				for ( int i = 0; i < g_instrumentCount; i++ ) {
					Instrument* ins = g_instruments + i;
					int s1 = -(s+1);
					if ( ins->note == s1 || ins->noteLen == s1 || ins->volume == s1 )
						found = true;
					for ( int kk = 0; kk < ins->operCount; kk++ )
						if ( ins->oper[kk]->type == OP_PUSH_STREAM && (int)ins->oper[kk]->params[0] == s1 )
							found = true;
				}
				if ( !found ) {
					if ( bs->Length > 0 )
						bs->Append ( ", " );
					bs->Append ( Form1::byteSequenceNames[s] );
				}
			}
			if ( bs->Length > 0 )
				m->Append ( "Unused sequences (will NOT be removed): " )->Append ( bs )->Append ( "\r\n" );
			// Check ADSR and expensive operations
			for ( int i = 0; i < g_instrumentCount; i++ ) {
				Instrument* ins = g_instruments + i;
				for ( int kk = 0; kk < ins->operCount; kk++ ) {
					if ( ins->oper[kk]->type == OP_ADSR && ( (char)ins->oper[kk]->params[0] >= (char)ins->oper[kk]->params[1] ||
						(char)ins->oper[kk]->params[1] >= (char)ins->oper[kk]->params[2] ) )
						m->Append ( "Possibly incorrect ADSR (A>=D||D>=S) in instrument " )->Append ( ins->name )->Append ( "\r\n" );
					if ( ins->oper[kk]->type == OP_COMPRESS )
						m->Append ( "Expensive use of compressor (cheaper to use Sin) in instrument " )->Append ( ins->name )->Append ( "\r\n" );
				}
			}
			c->dfMsg->Text = m->ToString ( );
		}

		// Creates code generation window
		System::Void menuItem15_Click ( System::Object *  sender, System::EventArgs *  e ) {
			if ( g_instrumentCount <= 0 || g_byteSequencesCount <= 0 || g_bytePatternsCount <= 0 )
				return;
			if ( !RecompileInstruments ( ) )
				return;

			// Show code generation window
			CodeGen* c = new CodeGen ( );
			__hook ( &CodeGen::GenerateCode, c, &Form1::GenerateCode, this );
			c->ShowDialog ( NULL );
		}

private: 

	// Opens frequency analyze window
	System::Void menuItemFreqAn_Click ( System::Object *  sender, System::EventArgs *  e ) {
		if ( freqAnalyzer != NULL )
			return;
		freqAnalyzer = new FreqAnalyzer ( );
		freqAnalyzer->Owner = this;
		freqAnalyzer->Show ( );
		freqAnalyzer->add_Closed ( new EventHandler ( this, freqAnalyzer_Closed ) );
	}

	// Processes analyzer close event
	System::Void freqAnalyzer_Closed ( System::Object *  sender, System::EventArgs *  e ) {
		freqAnalyzer = NULL;
	}

private: 
	
		// Opens output analyzer window
		System::Void menuItemAnOut_Click ( System::Object *  sender, System::EventArgs *  e ) {
			if ( outAnalyzer != NULL )
				return;
			outAnalyzer = new OutputAnalyzer ( );
			outAnalyzer->Owner = this;
			outAnalyzer->Show ( );
			outAnalyzer->add_Closed ( new EventHandler ( this, outAnalyzer_Closed ) );
		}

		// Processes analyzer close event
		System::Void outAnalyzer_Closed ( System::Object *  sender, System::EventArgs *  e ) {
			outAnalyzer = NULL;
		}

private:

		// Copies instrument to clipboard
		System::Void menuItem17_Click ( System::Object *  sender, System::EventArgs *  e ) {
			for ( int i = 0; i < groupBoxInstruments->Controls->Count; i++ )
				 if ( groupBoxInstruments->Controls->Item[i]->Focused ) {
					TextBox* t = dynamic_cast<TextBox*>(groupBoxInstruments->Controls->Item[i]);
					int insNo = Convert::ToInt32 ( t->Tag );
					// Put instrument and all it's operations into big array
					unsigned char* ins = (unsigned char*) ( g_instruments + insNo );
					System::Byte instrByte[] = new System::Byte[sizeof(Instrument)+g_instruments[insNo].operCount*sizeof(Operation)];
					int i = 0;
					for ( i = 0; i < sizeof(Instrument); i++ )
						instrByte[i] = ins[i];
					for ( int k = 0; k < g_instruments[insNo].operCount; k++ ) {
						unsigned char* op = (unsigned char*) g_instruments[insNo].oper[k];
						for ( int tt = 0; tt < sizeof(Operation); tt++, i++ )
							instrByte[i] = op[tt];
					}
					DataObject* dob = new DataObject ( S"Buzzic2Instrument", instrByte );
					Clipboard::SetDataObject ( dob );
					return;
				}
		}

private: 

		// Pastes instrument from clipboard
		System::Void menuItem18_Click ( System::Object *  sender, System::EventArgs *  e ) {
			IDataObject* obj = Clipboard::GetDataObject ( );
			if ( obj->GetDataPresent ( S"Buzzic2Instrument" ) ) {
				System::Byte arr[] = dynamic_cast<System::Byte[]>(obj->GetData ( "Buzzic2Instrument" ));
				// Copy instrument data
				Instrument ins;
				unsigned char* ip = (unsigned char*)&ins;
				int i = 0;
				for ( i = 0; i < sizeof(Instrument); i++ )
					*(ip+i) = arr[i];
				// Copy operations
				for ( int k = 0; k < ins.operCount; k++ ) {
					Operation opex;
					for ( int cc = 0; cc < sizeof(Operation); cc++, i++ )
						((char*)&opex)[cc] = arr[i];
					Operation *op = CreateOperation ( opex.type );					
					if ( !op ) {
						MessageBox::Show ( S"Bad operation type found. Paste operation will be skipped." );
						return;
					}
					// Copy skipping virtual functions table
					CopyMemory ( ((char*)op) + 4, ((char*)&opex) + 4, sizeof(Operation) - 4 );
					ins.oper[k] = op;
				}
				AddInstrument ( ins );
			}
		}

private: 
	
		//    
		System::Void menuItem20_Click ( System::Object *  sender, System::EventArgs *  e ) {
			AboutBox* b = new AboutBox ( );
			b->ShowDialog ( this );
		}

private:

		// Swaps two instruments
		System::Void SwapInstruments ( int i, int k ) {
			Instrument aa = g_instruments[k];
			g_instruments[k] = g_instruments[i];
			g_instruments[i] = aa;
			RecreateInstrumentTextBoxes ( );
			// Focus moved instrument
			for ( int i1 = 0; i1 < groupBoxInstruments->Controls->Count; i1++ ) {
				TextBox* t = dynamic_cast<TextBox*>(groupBoxInstruments->Controls->Item[i1]);
				if ( k == Convert::ToInt32 ( t->Tag ) ) {
					t->Focus ( );
					break;
				}
			}
		}

		// Moves current instrument up
		System::Void menuItem21_Click ( System::Object *  sender, System::EventArgs *  e ) {
			for ( int i = 0; i < groupBoxInstruments->Controls->Count; i++ )
				 if ( groupBoxInstruments->Controls->Item[i]->Focused ) {
					 TextBox* t = dynamic_cast<TextBox*>(groupBoxInstruments->Controls->Item[i]);
					 i = Convert::ToInt32 ( t->Tag );
					 if ( i >= g_instrumentCount - 1 )
						 return;
					 SwapInstruments ( i, i + 1 );
					 return;
				 }
		}

private:
		// Moves current instrument down
		System::Void menuItem22_Click ( System::Object *  sender, System::EventArgs *  e ) {
			for ( int i = 0; i < groupBoxInstruments->Controls->Count; i++ )
				 if ( groupBoxInstruments->Controls->Item[i]->Focused ) {
					 TextBox* t = dynamic_cast<TextBox*>(groupBoxInstruments->Controls->Item[i]);
					 i = Convert::ToInt32 ( t->Tag );
					 if ( i <= 0 )
						 return;
					 SwapInstruments ( i, i - 1 );
					 return;
				 }
		}

private: 
		// Process region selection
		System::Void panelByte_MouseMove ( System::Object *  sender, System::Windows::Forms::MouseEventArgs *  e ) {
			if ( e->Button == MouseButtons::Left ) {
				int x = Math::Max ( Math::Min ( e->X / CELL_X - 1 + byteScrollHor->Value, g_byteSequencesCount - 1 ), 0 );
				int y = Math::Max ( Math::Min ( e->Y / CELL_Y - 1 + byteScroll->Value, MAX_TEMPLATE_MELODY_LEN - 1 ), 0 );
				if ( selectionDragStart.X < 0 ) {
					selectionStart = Point ( x, y );
					selectionDragStart = selectionStart;
				}
				selectionEnd = Point ( x, y );
				RedrawByteSequences ( );
			} else
				selectionDragStart = System::Drawing::Point ( -1, -1 );
		}

private: 
	
		// Copy selected sequences region to clipboard
		System::Void menuItem23_Click ( System::Object *  sender, System::EventArgs *  e ) {
			System::Byte selection[,] = NULL;
			if ( selectionStart.X >= 0 ) {
				selection = new System::Byte[Math::Abs(selectionStart.X-selectionEnd.X)+1,Math::Abs(selectionStart.Y-selectionEnd.Y)+1];
				for ( int x = Math::Min(selectionStart.X,selectionEnd.X); x <= Math::Max(selectionStart.X,selectionEnd.X) && x < g_byteSequencesCount; x++ )
					for ( int y = Math::Min(selectionStart.Y,selectionEnd.Y); y <= Math::Max(selectionStart.Y,selectionEnd.Y); y++ )
						selection[x-Math::Min(selectionStart.X,selectionEnd.X),y-Math::Min(selectionStart.Y,selectionEnd.Y)] = (System::Byte)g_byteSequences[x][y];
			}
			DataObject* dob = new DataObject ( S"Buzzic2SeqSelection", selection );
			Clipboard::SetDataObject ( dob );
		}

private:

		// Paste selected sequences region from clipboard
		System::Void menuItem24_Click ( System::Object *  sender, System::EventArgs *  e ) {
			IDataObject* obj = Clipboard::GetDataObject ( );
			if ( obj->GetDataPresent ( S"Buzzic2SeqSelection" ) ) {
				System::Byte arr[,] = dynamic_cast<System::Byte[,]>(obj->GetData ( "Buzzic2SeqSelection" ));
				if ( byteFocus.X < 0 || byteFocus.Y < 0 )
					return;
				for ( int x = 0; x <= arr->GetUpperBound ( 0 ); x++ )
					for ( int y = 0; y <= arr->GetUpperBound ( 1 ); y++ ) {
						if ( x + byteFocus.X < g_byteSequencesCount && y + byteFocus.Y < MAX_TEMPLATE_MELODY_LEN ) {
							if ( arr[x,y] >= 0 && arr[x,y] <= g_bytePatternsCount )
								g_byteSequences[x+byteFocus.X][y+byteFocus.Y] = arr[x,y];
						}
					}
				RedrawByteSequences ( );
			}
		}

private: 
	
		// Insert sequence row
		System::Void menuItem25_Click ( System::Object *  sender, System::EventArgs *  e ) {
			InsertDeleteSeqRow ( true );
		}

private: 
		// Delete sequence row
		System::Void menuItem26_Click ( System::Object *  sender, System::EventArgs *  e ) {
			InsertDeleteSeqRow ( false );
		}

private: 
	
		// Export to WAV file
		System::Void menuItem27_Click ( System::Object *  sender, System::EventArgs *  e ) {
			if ( DialogResult::Cancel == saveFileDialog2->ShowDialog ( NULL ) )
				return;
			writeToWAV = true;
		}

};

}


