#pragma inline
#pragma off (check_stack)

#include <time.h>

typedef unsigned char byte;
typedef unsigned short word;
typedef unsigned int dword;

#define SCREEN_HEIGHT 199
#define SCREEN_WIDTH 319
#define SCREEN_BYTEPERLINE 320
#define SCREEN_BYTELEN (SCREEN_WIDTH * SCREEN_HEIGHT)
#define SCREEN_BYTEPERPIXEL 1
#define SCREEN_DWORDLEN ( (SCREEN_WIDTH * SCREEN_HEIGHT) / 4 )

char * VGA = (char *)0xa0000;

int randoseed = 50;

int zbuffer[0xffff];

//------------------------------------------------------------------------
void opengraph();
#pragma aux opengraph=\
        "mov eax,13h"\
        "int 10h"\
        modify [eax];
//------------------------------------------------------------------------
void closegraph();
#pragma aux closegraph=\
        "mov eax,3h"\
        "int 10h"\
        modify [eax];
//------------------------------------------------------------------------
void putpixel(int x,int y,int color,char * segment);
#pragma aux putpixel=\
        "shl edi,6"\
        "lea edi,[edi*4+edi]"\
        "lea edi,[edi+esi]"\
        "mov [edi+ebx],al"\
        parm [ebx] [edi] [eax] [esi]\
        modify [edi ebx];
//------------------------------------------------------------------------
void putpixelz(unsigned int x,unsigned int y,unsigned int color,int z,char * segment)
{
//register unsigned char *vidmem;
register int offset;

offset = y*320+x;

if (zbuffer[offset] > z)
   {
   zbuffer[offset] = z;
   segment[offset] = (char)color;
//   vidmem = (char *) offset + segment;
//   *(vidmem) = color;
   }

}
//------------------------------------------------------------------------
void waitvbl(void);
#pragma aux waitvbl=\
        "cli"\
        "mov dx,3dah"\
        "l1:"\
        "in al,dx"\
        "test al,8"\
        "jnz l1"\
        "l2:"\
        "in al,dx"\
        "test al,8"\
        "jz l2"\
        "sti"\
        modify [ax dx];
//------------------------------------------------------------------------
void setrgb(int color,int r,int g,int b);
#pragma aux setrgb=\
        "mov edx,03c8h"\
        "out dx,al"\
        "inc edx"\
        "mov eax,ebx"\
        "out dx,al"\
        "mov eax,esi"\
        "out dx,al"\
        "mov eax,edi"\
        "out dx,al"\
        modify [eax ebx esi edi edx]    \
        parm [eax] [ebx] [esi] [edi];
//------------------------------------------------------------------------
void setrgbpalet(unsigned char * palette)
{
_asm {
      mov  ecx,768
      mov  esi,palette

      mov dx,3c8h
      mov al,0
      out dx,al
      inc dx
      rep outsb
      }

}
//------------------------------------------------------------------------
void clearscreen(char * segment);
#pragma aux clearscreen=         \
        "cli"\
        "mov ecx,16300"          \
        "xor eax,eax"            \
        "cld"                    \
        "rep stosd"              \
        "sti"\
        modify [edi ecx eax]     \
        parm [edi];
//------------------------------------------------------------------------
void flip(char * source,char * dest);
#pragma aux flip=           \
        "mov ecx,16000"          \
        "rep movsd"             \
        modify [esi edi ecx]\
        parm [esi] [edi];
//------------------------------------------------------------------------
void flipEx(char * source,char * dest)
     {
     register count;
     for(count=0;count<64000;count++)
        {
        if ( *(source) != 0)  *(dest)= *(source);
        source++;
        dest++;
        }
     }
//------------------------------------------------------------------------
void fadeout()
{
byte r,g,b;
        _asm {
        cli
        mov ecx,255
l1:
        mov eax,ecx
        mov edx,3c7h
        out dx,al
        inc dx
        inc dx
        in al,dx
        cmp al,0
        je j1
        dec al
j1:
        mov r,al
        in al,dx
        cmp al,0
        je j2
        dec al
j2:
        mov g,al
        in al,dx
        cmp al,0
        je j3
        dec al

j3:
        mov b,al
        mov edx,3c8h
        mov eax,ecx
        out dx,al
        inc dx
        mov al,r
        out dx,al
        mov al,g
        out dx,al
        mov al,b
        out dx,al
        loop l1
        sti
        }
}
//------------------------------------------------------------------------
void delay(int ms)
     {
     register start,end;
     start = end = clock();
     while( (end -  start) < ms) end = clock();
     }

int randome(int max)
     {
     register a;
     a= inp(0x40);
     a%=max;
     return a;
     }