#pragma off (check_stack)

struct vertex
       {
       float x,y,z;
       } triangle[3];

//--- draw poly global variables..

float startx,endx,startxinc,endxinc,starty,endy;
float startz,endz,startzinc,endzinc;

//------------------------------------------------------------------------
//--- poligonun yarisini cizen rutin / drawes part of polygon
void drawHline(char * segment)
{
// endy ekran koordinatlari icinde degilse endy'yi ekranin en sonuna getir
// if endy out of screen then set endy to scren height..
if (endy > SCREEN_HEIGHT) endy = SCREEN_HEIGHT;

// starty 0'dan kucuk ise 0 yap..(diger degiskenleri ayarla)
// if starty out of screen then set starty to 0 (adjust other variables)
if (starty < 0)
        {
        starty = -starty;
        startx += startxinc * starty;
        endx += endxinc * starty;
        startz += startzinc * starty;
        endz += endzinc * starty;
        starty = 0;
        }

// poligon yarimini ciz / draw part
while (starty <= endy)
 {
 static float xk;
 static float ex;
 static float zdepth;
 static float zinc;

 // x uzunlugunu bul / find x size
 xk = startx - endx;
 if ( xk > 0)
       {
       zdepth = endz;
       zinc = (endz - startz)  / -xk;   //(xk - ex);
       ex = startx;
       xk = endx;
       } else
  if (xk < 0)
       {
       zdepth = startz;
       zinc = (startz - endz)  / xk;    //(ex - xk);
       xk = startx;
       ex = endx;
       } else
       // xk == 0'dir cizim yapma..
       goto NEXT_LOOP;

    //--- son x koordinati ekran siniri disinda ise ekran uzunluguna ayarla..
    //--- if endx out of screen then set to screen width
    if (ex > SCREEN_WIDTH) ex = SCREEN_WIDTH;

    //--- baslangic x koordinati 0'dan kucuk ise 0 yap.. (z degerini ayarla)
    //--- if startx out of screen than set to 0 (adjust z base)
    if (xk < 0)
       {
       zdepth += zinc * (-xk);
       xk= 0;
       }


    // cizim baslangici / ??..hmm..
    {
    register int segoffset;

    // ekran koordinatini hesapla / calculate screen offset
    segoffset = starty;
    _asm {
         mov eax,segoffset
         shl eax,6
         lea eax,[eax*4+eax]
         mov segoffset,eax
         }
    segoffset += xk;

    // yatay cizgiyi cizmeye basla / start scanline
    while(xk <= ex)
       {
       // z buffer'i kontrol et.. / check z buffer
       if ( zbuffer[segoffset] > zdepth)
          {
          // daha ustte pikseli ciz / draw pixel..
          register int color;
          zbuffer[segoffset] = zdepth;
          color = 286 - (zdepth * 220 / (zoff+MAX_Z));
          segment[segoffset] = (char)color;
          }
       // sonraki piksel / next pixel..
       xk++;
       segoffset++;
       zdepth+=zinc;
       }
    }

// poligon degiskenlerini hesapla / calculate polygon values...
NEXT_LOOP:
 startx += startxinc;
 endx += endxinc;

 startz += startzinc;
 endz += endzinc;
 starty++;
 }

}
//------------------------------------------------------------------------
void swappoint(struct vertex * t1,struct vertex * t2)
     {
     register float temp;

     temp = t1->x;
     t1->x = t2->x;
     t2->x = temp;

     temp = t1->y;
     t1->y = t2->y;
     t2->y = temp;

     temp = t1->z;
     t1->z = t2->z;
     t2->z = temp;
     }
//------------------------------------------------------------------------
void drawpoly(char * segment)
{
float ylength,xlength;

// y sirasini bul / sort by y order..
if (triangle[0].y > triangle[1].y) swappoint(&triangle[0],&triangle[1]);
if (triangle[0].y > triangle[2].y) swappoint(&triangle[0],&triangle[2]);
if (triangle[1].y > triangle[2].y) swappoint(&triangle[1],&triangle[2]);

// y ve x uzunluklarini bul / find x and y size..
ylength = triangle[2].y - triangle[0].y;
xlength = triangle[2].x - triangle[0].x;
if ( (ylength != 0) && (xlength !=0) )
   {
   // x,y,z length size..
   startx = triangle[0].x; endx = triangle[0].x;
   startz = triangle[0].z; endz = triangle[0].z;
   starty = triangle[0].y; endy = triangle[1].y;

   startxinc = xlength / ylength;
   startzinc = (triangle[2].z - triangle[0].z) / ylength;

   endxinc = (triangle[1].x - triangle[0].x) / (triangle[1].y - triangle[0].y);
   endzinc = (triangle[1].z - triangle[0].z) / (triangle[1].y - triangle[0].y);

   // poligon yarisi / draw first polygon part..
   drawHline(segment);

   endx -= endxinc;
   startx -= startxinc;
   startz -= startzinc;

   starty = triangle[1].y; endy = triangle[2].y;
   endx = triangle[1].x;
   endz = triangle[1].z;

   endxinc = (triangle[2].x - triangle[1].x) / (triangle[2].y - triangle[1].y);
   endzinc = (triangle[2].z - triangle[1].z) / (triangle[2].y - triangle[1].y);

   // diger poligon yarisi / draw second polygon part..
   drawHline(segment);
   }
}
