#define WIN32_LEAN_AND_MEAN
#define WIN32_EXTRA_LEAN
#include "IntroTimer.h"

static LARGE_INTEGER m_prev_end_of_frame; 
static LARGE_INTEGER m_high_perf_timer_freq; 
float ElaspedTime = 0;

IntroTimer::IntroTimer(void)
{
	timeBeginPeriod(1);
}

IntroTimer::~IntroTimer(void)
{
}

void IntroTimer::EndTimer()
{
	timeEndPeriod(1);
}

void IntroTimer::RunTimer()
{
	// note: BE SURE YOU CALL timeBeginPeriod(1) at program startup!!!
	// note: BE SURE YOU CALL timeEndPeriod(1) at program exit!!!
	// note: that will require linking to winmm.lib
	// note: never use static initializers (like this) with Winamp plug-ins!	 
	int max_fps = 60;

	LARGE_INTEGER t;
	QueryPerformanceCounter(&t);

	if (m_prev_end_of_frame.QuadPart != 0)
	{
		int ticks_to_wait = (int)m_high_perf_timer_freq.QuadPart / max_fps;
		int done = 0;
		do
		{
			QueryPerformanceCounter(&t);

			int ticks_passed = (int)((__int64)t.QuadPart - (__int64)m_prev_end_of_frame.QuadPart);
			int ticks_left = ticks_to_wait - ticks_passed;

			if (t.QuadPart < m_prev_end_of_frame.QuadPart)    // time wrap
				done = 1;
			if (ticks_passed >= ticks_to_wait)
				done = 1;

			if (!done)
			{
				// if > 0.002s left, do Sleep(1), which will actually sleep some 
				//   steady amount, probably 1-2 ms,
				//   and do so in a nice way (cpu meter drops; laptop battery spared).
				// otherwise, do a few Sleep(0)'s, which just give up the timeslice,
				//   but don't really save cpu or battery, but do pass a tiny
				//   amount of time.
				if (ticks_left > (int)m_high_perf_timer_freq.QuadPart*2/1000)
					Sleep(1);
				else                        
					for (int i=0; i<10; i++) 
						Sleep(0);  // causes thread to give up its timeslice
			}
		}
		while (!done);            
	}

	m_prev_end_of_frame = t;
}
