#include "fwScroller.h"
#include "../introbits/logo.h"

// scroller text
static char* txt = 
	"                                                                                                "
	"                                                                                    "
	"Menger's Mice are eating my Cheeze Cube! Raizor's entry to the Spinning Cube DBF Challenge. "
	"As per usual, this is pretty quick and dirty. I've used bits of a half finished intro for the base and cribbed "
	"some code from various sources for a lot of the raymarching (IQ and GLSL Sandbox examples mainly). The intro is based around "
	"a raymarched Menger Sponge (basically a cube with cubes cut out of it. The sponge algorithm is iterative, so you "
	"get smaller and smaller cubes being cut out at each iteration). I'm using some of IQ's suggested operations and modifiers "
	"to distort the shape (or more specifically the marching ray), which gives that mouse munched corner effect on the sponge. The "
	"twist modifier just twists the cube in the X/Y planes in time with the music. "
	"There's also an ever-expanding sphere in the corner of the sponge, which I use to do a boolean subtraction to cut a sphere "
	"shaped hole in the sponge. "
	"I've used 4kLang to provide the sounds and the "
	"tune is by Melw/SQNY from their Dollop 4k intro. I originally planned to release this as a 4k but I was a good few bytes over "
	"and Shader Minifier was playing havok with my GLSL shader code. So, the shader and music got dropped into the fat ass old intro "
	"mashup thingy you see before you...                    "
	"Time for some greets: Shockwave, Hellfire, Padman, Ferris, Kirl, NeriakX, CombatKing, Jim, RBZ, Jace, Va!n (get well soon!), Benny, "
	"Pot Noodle, Hot Shot, Clyde, Stone Monkey, Energy, Pixel Outlaw, BlackSheep8Bit, Knurz, Canopy, Psionice, Optimus any anyone "
	"I've forgotten! "
	"Your eyes are probably hurting a bit by now. I've gone a bit crazy with the post processing effects, so this looks quite a "
	"bit like a Razor1911 cracktro :) That's not such a bad thing I guess. "
	"Anyway, 4Klang doesn't let me loop the tune, so let's finish this text up before everything goes quiet. Thanks for watching. Raizor. "
	"p.s. I'll chuck the source on the DBF forum after the compo is finished. It might be handy for figuring how to sync to 4klang or something. Peace out..."
    "                                                                                                                             "
		"                                                                                                                             "
		"                                                                                                                             "
		"                                                                                                                             "
		"Go on, just press escape. You're just sitting in silence now, taking a very boring journey up a color-cycling anal passage..."
		"                                                                                                                             "
         "                                                                                                                             "
		 "                                                                                                                             "
		"This really is the end....                                 ";

float pixSize = 1.0f / 256.f;
float charSize = 9;
int charsPerLine = 16;
float fCharSize = 0.03515625f;//charSize * pixSize;
float tpms = 1000.0f/60.0f;

fwScroller::fwScroller(void)
{
}

fwScroller::~fwScroller(void)
{
}

void fwScroller::DrawChar(char ch, float x, float y, float z, float scale)
{
	float xo = pixSize + 0;
	int line =(ch-32)/charsPerLine;
	int lineChar = (ch-32)%charsPerLine;

	float typ = ((float)line*fCharSize) + (pixSize*line) + pixSize + pixSize;
	float txp = ((float)lineChar*fCharSize) + (pixSize*lineChar);


	glTexCoord2f(txp,typ+fCharSize);
	glVertex3f(x, y, z);

	glTexCoord2f(txp, typ);
	glVertex3f(x, y+(fCharSize*scale), z);

	glTexCoord2f(txp+fCharSize, typ);
	glVertex3f(x+(fCharSize*scale), y+(fCharSize*scale), z);

	glTexCoord2f(txp+fCharSize, typ+fCharSize);
	glVertex3f(x+(fCharSize*scale), y, z);
}

static int oset = 0;

void fwScroller::Draw(double timeIn)
{
	glDisable(GL_DEPTH_TEST);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	glEnable(GL_BLEND);
	glPushMatrix();
	{
		glColor4f(1,1,1,1);
		glEnable(GL_TEXTURE_2D);
		glBindTexture(GL_TEXTURE_2D, logo::textureId);
		glTranslatef(0,0,-1.8f);

		// some shitty smoothing for the delta timing
		// round float delta to an int to keep things regular
		// * note: BROKEN
		double xo = -(timeIn-3.0f)*0.2f;
		float scale = 0.4f;
				
		glBegin(GL_QUADS);
		{		
			int i = 0;

			while(txt[i]!=0)
			{
				float posx = (float)(xo+(fCharSize*i*scale));
				if (posx > -1.1 && posx < 1.1)
				{
					DrawChar(txt[i], posx, -0.295f, 0.50f, scale);
				}				
				i++;
			}
			
		}
		glBindTexture(GL_TEXTURE_2D, 0);
		glDisable(GL_TEXTURE_2D);
		glEnd();
	}
	glDisable(GL_BLEND);
	glPopMatrix();
	glEnable(GL_DEPTH_TEST);


}
