#include "logo.h"

GLuint logo::textureId;
GLuint logo::lookupTextureId;

void Material(void)
{
	// -------------------------------------------
	// Material parameters:


	GLfloat material_Ka[] = {0.0f, 5.0f, 0.0f, 1.0f};
	GLfloat material_Kd[] = {0.1f, 0.5f, 0.1f, 1.0f};
	GLfloat material_Ks[] = {0.0f, 1.0f, 0.0f, 1.0f};
	GLfloat material_Ke[] = {0.1f, 0.51f, 0.1f, 1.0f};
	GLfloat material_Se = 80.0f;

	glMaterialfv(GL_FRONT_AND_BACK, GL_AMBIENT, material_Ka);
	glMaterialfv(GL_FRONT_AND_BACK, GL_DIFFUSE, material_Kd);
	glMaterialfv(GL_FRONT_AND_BACK, GL_SPECULAR, material_Ks);
	glMaterialfv(GL_FRONT_AND_BACK, GL_EMISSION, material_Ke);
	glMaterialf(GL_FRONT_AND_BACK, GL_SHININESS, material_Se);                                                                                                                                
}

void DemoLight(void)
{
	/*
	lookAt(0.0f,0.0f,4.0f, 
		0.0,0.0,-1.0,
		0.0f,1.0f,0.0f);*/

	glShadeModel(GL_SMOOTH);
	glEnable(GL_LIGHTING);
	glEnable(GL_LIGHT0);
	glEnable(GL_NORMALIZE);

	// Light model parameters:
	// -------------------------------------------

	GLfloat lmKa[] = {0.0, 0.0, 0.0, 0.0 };
	glLightModelfv(GL_LIGHT_MODEL_AMBIENT, lmKa);

	glLightModelf(GL_LIGHT_MODEL_LOCAL_VIEWER, 1.0);
	glLightModelf(GL_LIGHT_MODEL_TWO_SIDE, 0.0);

	// -------------------------------------------
	// Spotlight Attenuation

	GLfloat spot_direction[] = {-1.0, -1.0, -1.0 };
	GLint spot_exponent = 30;
	GLint spot_cutoff = 180;

	glLightfv(GL_LIGHT0, GL_SPOT_DIRECTION, spot_direction);
	glLighti(GL_LIGHT0, GL_SPOT_EXPONENT, spot_exponent);
	glLighti(GL_LIGHT0, GL_SPOT_CUTOFF, spot_cutoff);

	GLfloat Kc = 1.0;
	GLfloat Kl = 0.0;
	GLfloat Kq = 0.0;

	glLightf(GL_LIGHT0, GL_CONSTANT_ATTENUATION,Kc);
	glLightf(GL_LIGHT0, GL_LINEAR_ATTENUATION, Kl);
	glLightf(GL_LIGHT0, GL_QUADRATIC_ATTENUATION, Kq);


	// ------------------------------------------- 
	// Lighting parameters:

	GLfloat light_pos[] = {5.0f, 5.0f, 0.0f, 1.0f};
	GLfloat light_Ka[]  = {0.2f, 0.8f, 0.0f, 1.0f};
	GLfloat light_Kd[]  = {0.2f, 0.8f, 0.2f, 1.0f};
	GLfloat light_Ks[]  = {0.0f, 1.0f, 0.0f, 1.0f};

	glLightfv(GL_LIGHT0, GL_POSITION, light_pos);
	glLightfv(GL_LIGHT0, GL_AMBIENT, light_Ka);
	glLightfv(GL_LIGHT0, GL_DIFFUSE, light_Kd);
	glLightfv(GL_LIGHT0, GL_SPECULAR, light_Ks);
}

void DemoLight2(void)
{
	/*
	lookAt(0.0f,0.0f,4.0f, 
		0.0,0.0,-1.0,
		0.0f,1.0f,0.0f);*/

	glShadeModel(GL_SMOOTH);
	glEnable(GL_LIGHTING);
	glEnable(GL_LIGHT1);
	glEnable(GL_NORMALIZE);

	// Light model parameters:
	// -------------------------------------------

	GLfloat lmKa[] = {0.0, 0.0, 0.0, 0.0 };
	glLightModelfv(GL_LIGHT_MODEL_AMBIENT, lmKa);

	glLightModelf(GL_LIGHT_MODEL_LOCAL_VIEWER, 1.0);
	glLightModelf(GL_LIGHT_MODEL_TWO_SIDE, 0.0);

	// -------------------------------------------
	// Spotlight Attenuation

	GLfloat spot_direction[] = {0.0, -2.0, 0.0 };
	GLint spot_exponent = 30;
	GLint spot_cutoff = 180;

	glLightfv(GL_LIGHT1, GL_SPOT_DIRECTION, spot_direction);
	glLighti(GL_LIGHT1, GL_SPOT_EXPONENT, spot_exponent);
	glLighti(GL_LIGHT1, GL_SPOT_CUTOFF, spot_cutoff);

	GLfloat Kc = 1.0;
	GLfloat Kl = 0.0;
	GLfloat Kq = 0.0;

	glLightf(GL_LIGHT1, GL_CONSTANT_ATTENUATION,Kc);
	glLightf(GL_LIGHT1, GL_LINEAR_ATTENUATION, Kl);
	glLightf(GL_LIGHT1, GL_QUADRATIC_ATTENUATION, Kq);


	// ------------------------------------------- 
	// Lighting parameters:

	GLfloat light_pos[] = {0.0f, 5.0f, 0.0f, 1.0f};
	GLfloat light_Ka[]  = {0.0f, 0.5f, 0.0f, 1.0f};
	GLfloat light_Kd[]  = {0.0f, 0.8f, 0.2f, 1.0f};
	GLfloat light_Ks[]  = {0.0f, 1.0f, 0.0f, 1.0f};

	glLightfv(GL_LIGHT1, GL_POSITION, light_pos);
	glLightfv(GL_LIGHT1, GL_AMBIENT, light_Ka);
	glLightfv(GL_LIGHT1, GL_DIFFUSE, light_Kd);
	glLightfv(GL_LIGHT1, GL_SPECULAR, light_Ks);
}

void DemoLight3(void)
{
	/*
	lookAt(0.0f,0.0f,4.0f, 
		0.0,0.0,-1.0,
		0.0f,1.0f,0.0f);*/

	glShadeModel(GL_SMOOTH);
	glEnable(GL_LIGHTING);
	glEnable(GL_LIGHT3);
	glEnable(GL_NORMALIZE);

	// Light model parameters:
	// -------------------------------------------

	GLfloat lmKa[] = {0.0, 0.0, 0.0, 0.0 };
	glLightModelfv(GL_LIGHT_MODEL_AMBIENT, lmKa);

	glLightModelf(GL_LIGHT_MODEL_LOCAL_VIEWER, 1.0);
	glLightModelf(GL_LIGHT_MODEL_TWO_SIDE, 0.0);

	// -------------------------------------------
	// Spotlight Attenuation

	GLfloat spot_direction[] = {2.0, 2.0, -10.0 };
	GLint spot_exponent = 30;
	GLint spot_cutoff = 180;

	glLightfv(GL_LIGHT3, GL_SPOT_DIRECTION, spot_direction);
	glLighti(GL_LIGHT3, GL_SPOT_EXPONENT, spot_exponent);
	glLighti(GL_LIGHT3, GL_SPOT_CUTOFF, spot_cutoff);

	GLfloat Kc = 1.0;
	GLfloat Kl = 0.0;
	GLfloat Kq = 0.0;

	glLightf(GL_LIGHT3, GL_CONSTANT_ATTENUATION,Kc);
	glLightf(GL_LIGHT3, GL_LINEAR_ATTENUATION, Kl);
	glLightf(GL_LIGHT3, GL_QUADRATIC_ATTENUATION, Kq);


	// ------------------------------------------- 
	// Lighting parameters:

	GLfloat light_pos[] = {0.0f, -5.0f, 0.0f, 1.0f};
	GLfloat light_Ka[]  = {0.1f, 0.8f, 0.0f, 1.0f};
	GLfloat light_Kd[]  = {0.1f, 1.0f, 0.0f, 1.0f};
	GLfloat light_Ks[]  = {0.2f, 1.0f, 0.0f, 1.0f};

	glLightfv(GL_LIGHT3, GL_POSITION, light_pos);
	glLightfv(GL_LIGHT3, GL_AMBIENT, light_Ka);
	glLightfv(GL_LIGHT3, GL_DIFFUSE, light_Kd);
	glLightfv(GL_LIGHT3, GL_SPECULAR, light_Ks);
}

logo::logo(void)
{
	pixelSize.x = 2.0f / 256.0f;
	pixelSize.y = 2.0f / 256.0f;	
	CheckGlError();
	oglGenBuffersARB(1, &vboVerts3);
	oglGenBuffersARB(1, &vboNormals);
	oglGenBuffersARB(1, &vboColors);
	oglGenBuffersARB(1, &vboTexCoords1);
	oglGenBuffersARB(1, &vboTexCoords2);
	oglGenBuffersARB(1, &vboTexCoords3);
	CheckGlError();
	GLint width, height, icomps;
	GLenum eFormat;
	GLbyte *pixels = gltLoadPNG(IDR_PNG_LOGOFONT, &width, &height, &icomps, &eFormat );
	glGenTextures(1, &textureId);
	glBindTexture(GL_TEXTURE_2D, textureId);
	glTexImage2D(GL_TEXTURE_2D, 0, icomps, width, height, 0, eFormat, GL_UNSIGNED_BYTE, pixels );
	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR); // Linear Filtering
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR); // Linear Filtering
	CheckGlError();
	getBlocks(pixels);
	CheckGlError();
	transforms = new vertex[360*100];

	initShader(&_shaderIdLogo, shaderVertFromResource(IDS_SHADER_LOGO_VERT), shaderFragFromResource(IDS_SHADER_LOGO_FRAG), "Logo");
	CheckGlError();
	vertex v, v2;

	fbo512_2 = globalFboManager->fbos[1];
	fboFullscreen = globalFboManager->fbos[2];
	fboFullscreen2 = globalFboManager->fbos[3];
	
	for(int i=0; i<360*100; i++)
	{
		/*
		v.x = i*0.001f;
		v.y = 0;
		v.z = 0;
		RotateVertexX(v, v2, )*/
	}

	msys_mallocFree(pixels);
}

int logo::createCube(int idx, int cubeNumVal, color4f color)
{
	int index = idx;
	float cubeNum = (float)cubeNumVal;
	
	// target vertex pos
	// front 
	populateVertex4(&verts4[index++], -cubeSize, -cubeSize, +cubeSize, cubeNum);
	populateVertex4(&verts4[index++], -cubeSize, +cubeSize, +cubeSize, cubeNum);
	populateVertex4(&verts4[index++], +cubeSize, +cubeSize, +cubeSize, cubeNum);
	populateVertex4(&verts4[index++], +cubeSize, -cubeSize, +cubeSize, cubeNum);

	// back 
	populateVertex4(&verts4[index++], -cubeSize, -cubeSize, -cubeSize, cubeNum);
	populateVertex4(&verts4[index++], -cubeSize, +cubeSize, -cubeSize, cubeNum);
	populateVertex4(&verts4[index++], +cubeSize, +cubeSize, -cubeSize, cubeNum);
	populateVertex4(&verts4[index++], +cubeSize, -cubeSize, -cubeSize, cubeNum);

	// top
	populateVertex4(&verts4[index++], -cubeSize, -cubeSize, +cubeSize, cubeNum);
	populateVertex4(&verts4[index++], -cubeSize, -cubeSize, -cubeSize, cubeNum);
	populateVertex4(&verts4[index++], +cubeSize, -cubeSize, -cubeSize, cubeNum);
	populateVertex4(&verts4[index++], +cubeSize, -cubeSize, +cubeSize, cubeNum);

	// bottom
	populateVertex4(&verts4[index++], -cubeSize, +cubeSize, +cubeSize, cubeNum);
	populateVertex4(&verts4[index++], -cubeSize, +cubeSize, -cubeSize, cubeNum);
	populateVertex4(&verts4[index++], +cubeSize, +cubeSize, -cubeSize, cubeNum);
	populateVertex4(&verts4[index++], +cubeSize, +cubeSize, +cubeSize, cubeNum);

	// left
	populateVertex4(&verts4[index++], -cubeSize, -cubeSize, -cubeSize, cubeNum);
	populateVertex4(&verts4[index++], -cubeSize, +cubeSize, -cubeSize, cubeNum);
	populateVertex4(&verts4[index++], -cubeSize, +cubeSize, +cubeSize, cubeNum);
	populateVertex4(&verts4[index++], -cubeSize, -cubeSize, +cubeSize, cubeNum);

	// right
	populateVertex4(&verts4[index++], +cubeSize, -cubeSize, -cubeSize, cubeNum);
	populateVertex4(&verts4[index++], +cubeSize, +cubeSize, -cubeSize, cubeNum);
	populateVertex4(&verts4[index++], +cubeSize, +cubeSize, +cubeSize, cubeNum);
	populateVertex4(&verts4[index++], +cubeSize, -cubeSize, +cubeSize, cubeNum);

	// colors
	index = idx;
	for(int i=0; i<24; i++)
	{
		populateColor4f(&vertCols[index++], color.r, color.g, color.b, color.a);
	}
		
	// normals
	index = idx;

	// front
	populateVertex(&bn[index++], 0.0f, 0.0f, 1.0f);
	populateVertex(&bn[index++], 0.0f, 0.0f, 1.0f);
	populateVertex(&bn[index++], 0.0f, 0.0f, 1.0f);
	populateVertex(&bn[index++], 0.0f, 0.0f, 1.0f);

	// back
	populateVertex(&bn[index++], 0.0f, 0.0f, -1.0f);
	populateVertex(&bn[index++], 0.0f, 0.0f, -1.0f);
	populateVertex(&bn[index++], 0.0f, 0.0f, -1.0f);
	populateVertex(&bn[index++], 0.0f, 0.0f, -1.0f);

	// top
	populateVertex(&bn[index++], 0.0f, -1.0f, 0.0f);
	populateVertex(&bn[index++], 0.0f, -1.0f, 0.0f);
	populateVertex(&bn[index++], 0.0f, -1.0f, 0.0f);
	populateVertex(&bn[index++], 0.0f, -1.0f, 0.0f);

	// bottom
	populateVertex(&bn[index++], 0.0f, 1.0f, 0.0f);
	populateVertex(&bn[index++], 0.0f, 1.0f, 0.0f);
	populateVertex(&bn[index++], 0.0f, 1.0f, 0.0f);
	populateVertex(&bn[index++], 0.0f, 1.0f, 0.0f);


	// left
	populateVertex(&bn[index++], -1.0f, 0.0f, 0.0f);
	populateVertex(&bn[index++], -1.0f, 0.0f, 0.0f);
	populateVertex(&bn[index++], -1.0f, 0.0f, 0.0f);
	populateVertex(&bn[index++], -1.0f, 0.0f, 0.0f);

	// right
	populateVertex(&bn[index++], 1.0f, 0.0f, 0.0f);
	populateVertex(&bn[index++], 1.0f, 0.0f, 0.0f);
	populateVertex(&bn[index++], 1.0f, 0.0f, 0.0f);
	populateVertex(&bn[index++], 1.0f, 0.0f, 0.0f);
	
	return index;
}

void logo::getBlocks(GLbyte* pixels)
{
	cubeSize = 1.0f / 256.f;
	numblocks = 0;
	objectStack *s = new objectStack(256*256);

	int startY = 240;

	float halfSize = 108.0f;

	float st = -2.0f;
	CheckGlError();

	for(int x=0; x<256; x++)
	{
		for(int y=startY; y<256; y++)
		{			
			GLubyte cr = pixels[(x*4)+(y*256*4)];
			GLubyte cg = pixels[(x*4)+(y*256*4)+1];
			GLubyte cb = pixels[(x*4)+(y*256*4)+2];
			GLubyte ca = pixels[(x*4)+(y*256*4)+3];

			if (cr  > 0 || cg > 0 || cb > 0)
			{
				logoBlock *b = new logoBlock();
				b->targetPos.x = ((float)x*cubeSize*2)-(108*cubeSize);
				b->targetPos.y = (((float)y-startY)*cubeSize*2)-(16*cubeSize);
				b->targetPos.z = 0;

				b->startTime = 0;
				b->percent = b->percent2 = 0;

				if (cr == 255)
				{
					b->height = 4;
				}else if (cr==191)
				{
					b->height = 3;
					cr = cg = cb = ca = 255;
				}else{
					b->height = 2;
				}

				b->currentPos.x = (float)0;
				b->currentPos.y = (float)0;
				b->currentPos.z = 0;
				b->color.r = cr / 256.0f;
				b->color.g = cg / 256.0f;
				b->color.b = cb / 256.0f;
				b->color.a = ca / 256.0f;

				b->scalex = 1;
				b->scaley = 2;
				b->scalez = 1;

				b->startTime = st;
				st+=0.0012f;

				s->push((void*)b);
				numblocks++;

				if (cr!=255)
				{
					int layers = 2;
					for(int i=0; i<layers; i++)
					{				
						for (int j=0; j<2; j++)
						{
							float z = cubeSize*(i+1);
							if (j==0)
							{
								z = -z;
							}
							logoBlock *b = new logoBlock();
							b->targetPos.x = ((float)x*cubeSize*2)-(108*cubeSize);
							b->targetPos.y = (((float)y-startY)*cubeSize*2)-(16*cubeSize);
							b->targetPos.z = z;

							b->startTime = 0;
							b->percent = b->percent2 = 0;

							b->currentPos.x = (float)0;
							b->currentPos.y = (float)0;
							b->currentPos.z = 0;
							b->color.r = cr / 256.0f;
							b->color.g = cg / 256.0f;
							b->color.b = cb / 256.0f;
							b->color.a = ca / 256.0f;

							b->scalex = 1;
							b->scaley = 2;
							b->scalez = 1;

							b->startTime = st;

							s->push((void*)b);
							numblocks++;
						}
					}
				}

			}
		}
	}	
	CheckGlError();

	blocks = new logoBlock*[numblocks]; 

	int idx = 0;

	verts4 = new vertex4[numblocks*24];
	tc4_1 = new vertex4[numblocks*24];
	tc4_2 = new vertex4[numblocks*24];
	tc4_3 = new vertex4[numblocks*24];
	verts4 = new vertex4[numblocks*24];
	bn = new vertex[numblocks*24];
	vertCols = new color4f[numblocks*24];

	for(int i=0; i<numblocks; i++)
	{
		logoBlock *b = (logoBlock*)s->items[i];
		idx = createCube(idx, i, b->color);
		blocks[i] = b;
	}
	
	CheckGlError();
	rng = new RNG();

	indices = new int[numblocks*24];

	int tcidx = 0;

	// set source positions
	for(int i=0; i<numblocks; i++)
	{
		logoBlock *b = blocks[i];

		float amt = 1.0f;

		float vx = rng->rFloat()*amt;
		float vy = rng->rFloat()*amt;
		float vz = rng->rFloat()*amt;
		
		float vxp = rng->rFloat()*amt;
		float vyp = rng->rFloat()*amt;
		float vzp = rng->rFloat()*amt;


		if (vx >= 0.5f)
		{
			b->currentPos.x =  -vxp;
		}else{
			b->currentPos.x =  +vxp;
		}
		
		if (vy >= 0.5f)
		{
			b->currentPos.y = -vyp;
		}else{
			b->currentPos.y = vyp;
		}
		
		if (vz >= 0.5f)
		{
			b->currentPos.z = -vzp;
		}else{
			b->currentPos.z = vzp;
		}

		b->currentPos.z += 1.0f;

		float speed = rng->rFloat()*0.3f;
		for(int i=0; i<24; i++)
		{
			// target
			tc4_1[tcidx].x = b->targetPos.x;
			tc4_1[tcidx].y = b->targetPos.y;
			tc4_1[tcidx].z = b->targetPos.z;
			tc4_1[tcidx].w = b->startTime;

			// source
			tc4_2[tcidx].x = b->currentPos.x;
			tc4_2[tcidx].y = b->currentPos.y;
			tc4_2[tcidx].z = b->currentPos.z;
			tc4_2[tcidx].w = b->height;

			vertex v;
			CrossProduct(&v, &b->targetPos, &b->currentPos);

			// cross product
			tc4_3[tcidx].x = v.x;
			tc4_3[tcidx].y = v.y;
			tc4_3[tcidx].z = v.z;
			tc4_3[tcidx].w = 1.0f + (speed);

			tcidx++;
		}

	}
	CheckGlError();

	// upload vertex data to vbo
	oglBindBufferARB(GL_ARRAY_BUFFER_ARB, vboVerts3);
	oglBufferDataARB(GL_ARRAY_BUFFER_ARB, numblocks*24*sizeof(vertex4), &verts4[0], GL_STATIC_DRAW_ARB);
	oglBindBufferARB(GL_ARRAY_BUFFER_ARB, 0);
	CheckGlError();

	// normals
	oglBindBufferARB(GL_ARRAY_BUFFER_ARB, vboNormals);
	oglBufferDataARB(GL_ARRAY_BUFFER_ARB, numblocks*24*sizeof(vertex), &bn[0], GL_STATIC_DRAW_ARB);
	oglBindBufferARB(GL_ARRAY_BUFFER_ARB, 0);
	CheckGlError();

	// colors
	oglBindBufferARB(GL_ARRAY_BUFFER_ARB, vboColors);
	oglBufferDataARB(GL_ARRAY_BUFFER_ARB, numblocks*24*sizeof(color4f), &vertCols[0], GL_STATIC_DRAW_ARB);
	oglBindBufferARB(GL_ARRAY_BUFFER_ARB, 0);
	CheckGlError();

	// target positions into texcoord 1
	oglBindBufferARB(GL_ARRAY_BUFFER_ARB, vboTexCoords1);
	oglBufferDataARB(GL_ARRAY_BUFFER_ARB, numblocks*24*sizeof(vertex4), &tc4_1[0], GL_STATIC_DRAW_ARB);
	oglBindBufferARB(GL_ARRAY_BUFFER_ARB, 0);
	CheckGlError();

	// current positions into texcoord 2
	oglBindBufferARB(GL_ARRAY_BUFFER_ARB, vboTexCoords2);
	oglBufferDataARB(GL_ARRAY_BUFFER_ARB, numblocks*24*sizeof(vertex4), &tc4_2[0], GL_STATIC_DRAW_ARB);
	oglBindBufferARB(GL_ARRAY_BUFFER_ARB, 0);
	CheckGlError();

	// mid positions into texcoord 2
	oglBindBufferARB(GL_ARRAY_BUFFER_ARB, vboTexCoords3);
	oglBufferDataARB(GL_ARRAY_BUFFER_ARB, numblocks*24*sizeof(vertex4), &tc4_3[0], GL_STATIC_DRAW_ARB);
	oglBindBufferARB(GL_ARRAY_BUFFER_ARB, 0);
	CheckGlError();

	for(int i=0; i<24*numblocks; i++)
	{		
		indices[i] = i;
	}
}

#define lerpy(t, a, b) ( a + t * (b - a) )

void logo::drawCube(float offsetX, float offsetY, float offsetZ, color4f color)
{
	_glColor4f(color);
	// front 
	glVertex3f(offsetX-cubeSize, offsetY-cubeSize, offsetZ+cubeSize);
	glVertex3f(offsetX-cubeSize, offsetY+cubeSize, offsetZ+cubeSize);
	glVertex3f(offsetX+cubeSize, offsetY+cubeSize, offsetZ+cubeSize);
	glVertex3f(offsetX+cubeSize, offsetY-cubeSize, offsetZ+cubeSize);

	// back 
	glVertex3f(offsetX-cubeSize, offsetY-cubeSize, offsetZ-cubeSize);
	glVertex3f(offsetX-cubeSize, offsetY+cubeSize, offsetZ-cubeSize);
	glVertex3f(offsetX+cubeSize, offsetY+cubeSize, offsetZ-cubeSize);
	glVertex3f(offsetX+cubeSize, offsetY-cubeSize, offsetZ-cubeSize);

	// top
	glVertex3f(offsetX-cubeSize, offsetY-cubeSize, offsetZ+cubeSize);
	glVertex3f(offsetX-cubeSize, offsetY-cubeSize, offsetZ-cubeSize);
	glVertex3f(offsetX+cubeSize, offsetY-cubeSize, offsetZ-cubeSize);
	glVertex3f(offsetX+cubeSize, offsetY-cubeSize, offsetZ+cubeSize);

	// bottom
	glVertex3f(offsetX-cubeSize, offsetY+cubeSize, offsetZ+cubeSize);
	glVertex3f(offsetX-cubeSize, offsetY+cubeSize, offsetZ-cubeSize);
	glVertex3f(offsetX+cubeSize, offsetY+cubeSize, offsetZ-cubeSize);
	glVertex3f(offsetX+cubeSize, offsetY+cubeSize, offsetZ+cubeSize);

	// left
	glVertex3f(offsetX-cubeSize, offsetY-cubeSize, offsetZ-cubeSize);
	glVertex3f(offsetX-cubeSize, offsetY+cubeSize, offsetZ-cubeSize);
	glVertex3f(offsetX-cubeSize, offsetY+cubeSize, offsetZ+cubeSize);
	glVertex3f(offsetX-cubeSize, offsetY-cubeSize, offsetZ+cubeSize);

	// right
	glVertex3f(offsetX+cubeSize, offsetY-cubeSize, offsetZ-cubeSize);
	glVertex3f(offsetX+cubeSize, offsetY+cubeSize, offsetZ-cubeSize);
	glVertex3f(offsetX+cubeSize, offsetY+cubeSize, offsetZ+cubeSize);
	glVertex3f(offsetX+cubeSize, offsetY-cubeSize, offsetZ+cubeSize);
}

void logo::draw(double timeIn)
{	
	float time = (float)timeIn;

		
	glPushMatrix();
	{
		glLoadIdentity();	

		/*

		fboFullscreen2->BindFbo(true);
		glClearColor(0,0,0,0); // red
		glClear( GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT );
		glColor4f(1,1,1,1);
		glBegin(GL_QUADS);
		float qs = 0.15f;
		glVertex3f(0-qs,0-qs,-1);
		glVertex3f(0-qs,0+qs,-1);
		glVertex3f(0+qs,0+qs,-1);
		glVertex3f(0+qs,0-qs,-1);
		glEnd();
		glClear( GL_DEPTH_BUFFER_BIT );
		fboFullscreen2->BindFbo(false);*/

		DemoLight();
		DemoLight2();
		DemoLight3();
		glEnable(GL_COLOR_MATERIAL);

		

		glEnableClientState(GL_VERTEX_ARRAY);	
		oglBindBufferARB( GL_ARRAY_BUFFER, vboVerts3 );
		glVertexPointer(4, GL_FLOAT, 0, 0);
		CheckGlError();

		glEnableClientState(GL_NORMAL_ARRAY);	
		oglBindBufferARB( GL_ARRAY_BUFFER, vboNormals );
		glNormalPointer(GL_FLOAT, 0, 0);
		CheckGlError();

		glEnableClientState(GL_COLOR_ARRAY);	
		oglBindBufferARB( GL_ARRAY_BUFFER, vboColors );
		glColorPointer(4, GL_FLOAT, 0, 0);
		CheckGlError();

		oglClientActiveTextureARB(GL_TEXTURE0);
		glEnable(GL_TEXTURE_2D);
		glEnableClientState(GL_TEXTURE_COORD_ARRAY);	
		oglBindBufferARB( GL_ARRAY_BUFFER, vboTexCoords1 );
		glTexCoordPointer(4, GL_FLOAT, 0, 0);
		CheckGlError();

		oglClientActiveTextureARB(GL_TEXTURE1);
		glEnable(GL_TEXTURE_2D);
		glEnableClientState(GL_TEXTURE_COORD_ARRAY);	
		oglBindBufferARB( GL_ARRAY_BUFFER, vboTexCoords2 );
		glTexCoordPointer(4, GL_FLOAT, 0, 0);
		CheckGlError();

		oglClientActiveTextureARB(GL_TEXTURE2);
		glEnable(GL_TEXTURE_2D);
		glEnableClientState(GL_TEXTURE_COORD_ARRAY);	
		oglBindBufferARB( GL_ARRAY_BUFFER, vboTexCoords3 );
		glTexCoordPointer(4, GL_FLOAT, 0, 0);
		CheckGlError();
		
		float zm = 0.03f;
		float zval = time < 10 ? time*zm : 10*zm;
		glTranslatef(0,zval,-1.5);

		float rotSpeed = time <= 10 ? 10-time : 0;
		float rval = time <= 10 ? time * 36 : 0;
		glRotatef(rval, 0, rotSpeed, 0);	
		glEnable(GL_DEPTH_TEST);

		glColor4f(1,0.1f,0.2f,1);
				
		float rv = -45+180;
		
		oglUseProgram(_shaderIdLogo);		
		setShaderParam1f(_shaderIdLogo, "time", time);

		glRotatef(rv, 1, 0, 0);

		int i =0;
		
		logoBlock *b = blocks[i];
			
		float pctInv = 1-b->percent;
		float rvc = i*(pctInv)*1;
		float xs = (pctInv*0.002f);

		if (time > b->startTime)
		{
			float tv = (time - b->startTime) * 0.1f;
			if (tv <= 1.0f)
			{
				b->percent = tv;
			}else{
				b->percent = 1;
				tv -= 1.0f;
				if (tv <= 1.0f)
				{
					b->percent2 = tv;
				}else{
					b->percent2 = 1;
					tv -= 1.0f;
				}
			}
		}

		if (b->percent > 0.8f)
		{
			b->percent2 = (b->percent - 0.8f * 0.5f);
		}

		vertex v;
		CheckGlError();

		//glTranslatef(v.x, v.y, v.z);
		//glRotatef(rvc, 1, 2, 3);			
				
		//glScalef(1.001f+xs, 1.001f+xs, 1.001f+xs);
		CheckGlError();

		//_glColor4f(b->color);

		// draw black for cubes
		//setShaderParam1i(_shaderIdLogo, "black", 1);
		//fboFullscreen2->BindFbo(true);
		//glDrawElements(GL_QUADS, 24*numblocks, GL_UNSIGNED_INT, indices);
		//fboFullscreen2->BindFbo(false);

		fbo512_2->BindTexture(1);
		// draw cubes
		setShaderParam1i(_shaderIdLogo, "black", 0);
		//fboFullscreen2->BindFbo(true);
		glClearColor(0,0,0,0); // red
		glClear( GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT );
		glPushMatrix();
		{
			glTranslatef(0,0.16f, 0);
			glDrawElements(GL_QUADS, 24*numblocks, GL_UNSIGNED_INT, indices);
		}
		glPopMatrix();
		//fboFullscreen2->BindFbo(false);

		fbo512_2->BindTexture(0);

		CheckGlError();


		//glScalef(.999f+xs, .999f+xs, .999f+xs);
		//glRotatef(-rvc, 1, 2, 3);
		//glTranslatef(-v.x, -v.y, -v.z);

		oglUseProgram(0);
		CheckGlError();
		
		glDisableClientState(GL_VERTEX_ARRAY);
		glDisableClientState(GL_NORMAL_ARRAY);
		glDisableClientState(GL_COLOR_ARRAY);
		
		oglClientActiveTextureARB(GL_TEXTURE2);
		glDisableClientState(GL_TEXTURE_COORD_ARRAY);
		
		oglClientActiveTextureARB(GL_TEXTURE1);
		glDisableClientState(GL_TEXTURE_COORD_ARRAY);

		oglClientActiveTextureARB(GL_TEXTURE0);
		glDisableClientState(GL_TEXTURE_COORD_ARRAY);
		CheckGlError();
	}
	glPopMatrix();
	
	glDisable(GL_COLOR_MATERIAL);
	glDisable(GL_LIGHTING);
	glDisable(GL_LIGHT1);
	glDisable(GL_LIGHT2);
	glDisable(GL_LIGHT3);
	glDisable(GL_TEXTURE_2D);



	//GodRays();
}

float lightPositionOnScreenX = 0;
float lightPositionOnScreenY = 0;
float exposure = 0.0014f;
float decay = 1.0f;
float density = 0.84f;
float weight = 5.65f;

void logo::GodRays() // not used
{

	fbo *fbox2 = fboFullscreen2;
	glEnable(GL_TEXTURE_2D);


	oglActiveTextureARB(GL_TEXTURE0);
	fbox2->BindTexture(1);
	
	
	glClear( GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT );
	glPushMatrix();
	{
		ViewOrtho(fbox2->info.width, fbox2->info.height);
		glViewport(0, 0, globalScreenInfo.width, globalScreenInfo.height); // change viewport to match screen size
		glColor4f(1,1,1,1);
		glBegin(GL_QUADS);
		{
			glTexCoord2f(0,1);
			glVertex2i(0,0);

			glTexCoord2f(0,0);
			glVertex2i(0,fbox2->info.height);

			glTexCoord2f(1,0);
			glVertex2i(fbox2->info.width, fbox2->info.height);

			glTexCoord2f(1,1);
			glVertex2i(fbox2->info.width, 0);
		}		
		glEnd();
		ViewPerspective();
	}
	glPopMatrix();
	

	fbox2->BindTexture(0);
	glDisable(GL_TEXTURE_2D);
}

logo::~logo(void)
{
}


