//--------------------------------------------------------------------------//
// iq . 2003/2008 . code for 64 kb intros by RGBA                           //
//--------------------------------------------------------------------------//


#include "sys/msys.h"
#include "sys/extra/msys_extra.h"
#include "resources/resource.h"
#include "intro.h"
#include "introbits/fractal.h"
#include "scroller/fwScroller.h"
#include "introbits/logo.h"
#include "sys/GL/fbo/fboManager.h"

typedef struct
{
    long    mTo;
	int     mSeed;
}IntroObject;

GLfloat fAspect;
static IntroObject intro;
float frames = 0.0f;
int _noMusic;
SCREEN_INFO* screen;

int patternNum = -1;
int prevPatternNum = -1;
int rowNum = -1;
int prevRowNum = -1;
float angle =0;
bool music = false;

extern double timeVal;

GLint _shaderIdPostFx;

GLint _shaderPostFx;
GLint windowWidth = 512;               // window size
GLint windowHeight = 512;
GLint textureWidth = 512;              // texture size
GLint textureHeight = 512;
GLint maxTexSize;                       // maximum allowed size for 1D/2D texture
GLfloat texCoordOffsets[18];

GLuint fb, fbTex, depth_rb, recTex, ptex;

fractal *_julia;
logo *_logo;

fwScroller* _scroller;

fboManager *_fboMan;
fbo *fbo1024, *fboFullscreen, *fbo512, *fbo512_2;
GLuint textureId;

extern int SynthNotesPrev[17];
extern int SynthNotes[17];
extern bool SynthNoteHandled[17];

extern float quitValX;
extern float quitValY;
extern double quitTime;
extern bool quit;

void initTex()
{
	GLint width, height, icomps;
	GLenum eFormat;
	GLbyte *pixels = gltLoadPNG(IDR_PNG_LOGO, &width, &height, &icomps, &eFormat );
	glGenTextures(1, &textureId);
	glBindTexture(GL_TEXTURE_2D, textureId);
	glTexImage2D(GL_TEXTURE_2D, 0, icomps, width, height, 0, eFormat, GL_UNSIGNED_BYTE, pixels );
	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP_TO_EDGE);
	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP_TO_EDGE);
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR); // Linear Filtering
	glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR); // Linear Filtering

	msys_mallocFree(pixels);
}

void initFbo()
{
	_fboMan = globalFboManager;
	fboInfo finfo;
	finfo.name = "Fullscreen";
	finfo.numColorBuffers = 1;
	finfo.generateMipMaps = false;
	finfo.internalFormat = GL_RGBA8;
	finfo.format = GL_BGRA;
	finfo.dataType = GL_UNSIGNED_BYTE;
	finfo.width = 1024;	
	finfo.pixelData = NULL;
	finfo.height = 1024;	
	finfo.magFilter = GL_LINEAR;
	finfo.minFilter = GL_LINEAR;
	finfo.wrapModeX = GL_CLAMP_TO_EDGE;
	finfo.wrapModeY = GL_CLAMP_TO_EDGE;
	fbo1024 = _fboMan->addFbo(finfo);

	finfo.name = "512_1";
	finfo.numColorBuffers = 1;
	finfo.width = 512;
	finfo.height = 512;
	finfo.magFilter = GL_LINEAR;
	finfo.minFilter = GL_LINEAR;
	finfo.wrapModeX = GL_MIRRORED_REPEAT;
	finfo.wrapModeY = GL_MIRRORED_REPEAT;
	fbo512 = _fboMan->addFbo(finfo);

	finfo.name = "512_2";
	finfo.numColorBuffers = 2;
	finfo.width = globalScreenInfo.width;
	finfo.height =  globalScreenInfo.height;
	finfo.magFilter = GL_LINEAR;
	finfo.minFilter = GL_LINEAR;
	finfo.wrapModeX = GL_MIRRORED_REPEAT;
	finfo.wrapModeY = GL_MIRRORED_REPEAT;
	fbo512_2 = _fboMan->addFbo(finfo);

	finfo.name = "Fullscreen2";
	finfo.numColorBuffers = 2;
	finfo.width = globalScreenInfo.width;
	finfo.height =  globalScreenInfo.height;
	finfo.magFilter = GL_LINEAR;
	finfo.minFilter = GL_LINEAR;
	finfo.wrapModeX = GL_MIRRORED_REPEAT;
	finfo.wrapModeY = GL_MIRRORED_REPEAT;
	fboFullscreen = _fboMan->addFbo(finfo);
}


int intro_init(int nomusic, IntroProgressDelegate *pd, SCREEN_INFO *screenInfo )
{
	//_noMusic = true;//nomusic;
    // progress report, (from 0 to 200)
    pd->func( pd->obj, 0 );
	CheckGlError();
	screen = screenInfo;

	initFbo();
	CheckGlError();
	//MsgBox("msg", "hello");	

	_julia = new fractal();	
	_scroller = new fwScroller();
	CheckGlError();
	_logo = new logo();
	CheckGlError();

	initTex();

    // init your stuff here (mzk player, intro, ...)
    // remember to call pd->func() regularly to update the loading bar

    // Prevent a divide by zero, when window is too short
    // (you cant make a window of zero width).
    if(screenInfo->height == 0)
        screenInfo->height = 1;
	
    glViewport(0, 0, screenInfo->width, screenInfo->height);
        
	glShadeModel( GL_SMOOTH );
	glEnable(GL_DEPTH_TEST);
	glDepthFunc(GL_LEQUAL);

	glClearColor( 0, 0, 0, 0 );

    // Reset the coordinate system before modifying
    glMatrixMode(GL_PROJECTION);
    glLoadIdentity();
	
    // Set the clipping volume
	if (screenInfo->widescreen)
	{
		gluPerspective(30.0, 1.77f, 1.0, 10000.0);
	}else{
		gluPerspective(30.0, screenInfo->aspect, 1.0, 10000.0);
	}
    
    pd->func( pd->obj, 50 );

    intro.mTo = msys_timerGet();

	pd->func( pd->obj, 100 );
	if (!_noMusic)
	{
		//msys_debugPrintf("* INIT MUSIC\n");
		// load and play XM file from resource
		//mod = loadAndPlayMod(IDR_XMAUDIO1);
		//pd->func( pd->obj, 200 );
	}
	CheckGlError();
	initShader(&_shaderPostFx, shaderVertFromResource(IDS_SHADER_TV_VERT), shaderFragFromResource(IDS_SHADER_TV_FRAG), "Fx");
	CheckGlError();
	glMatrixMode(GL_MODELVIEW);
	return 1;
}

void intro_end( void )
{    
    // deallicate your stuff here
}

#define lerpx(t, a, b) ( a + t * (b - a) )

static float deform = 5.0f;
static float flash = 0.0f;
static bool flashed = false;
static float split = 0.0f;
static float distortMod = 1.0f;
static float distort1 = 0.525f;
static float distort2 = 0.525f;
static float distort3 = 0.525f;
extern bool quitting;


void DrawPostFx(float time)
{
	if (quitting)
	{
		quitValY = 1.0f - (float)((timeVal - quitTime)*2.0f);
		flash = 1.0f - quitValY;
		if (quitValY < 0.005f) 
		{
			quitValY = 0.005f;
		}
		
		if (quitValY < 0.21f)
		{
			quitValX = 2.0f - (float)((timeVal - quitTime)*2.0f);
			if (quitValX < 0.001f) 
			{
				quitValX = 0.001f;
				quit = true;
			}
		}
	}
	glClear( GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT );
	fbo *fbox = fboFullscreen;
	// draw 1024x1024 fbo to screen
	glDisable(GL_DEPTH_TEST);
	oglUseProgram(_shaderPostFx);

	oglActiveTextureARB(GL_TEXTURE0);
	fbox->BindTexture(1);	

	float fadeUp = 0.1f;

	if (time > 10.0f - fadeUp && time <= 10.0f)
	{
		flash = (time - (10-fadeUp)) * 20.0f;
	}

	float fadeDown = 0.3f;

	if (time > 10.0f && time < 10.0f + fadeDown)
	{
		flash = time - 10.0f;
		flash = fadeDown - flash;
		flash = 20.0f * flash;
	}

	if (flash < 0) flash = 0;

	setShaderParam1i(_shaderPostFx, "screen_w", globalScreenInfo.width);
	setShaderParam1i(_shaderPostFx, "screen_h", globalScreenInfo.height);
	setShaderParam1f(_shaderPostFx, "time", time);
	setShaderParam1f(_shaderPostFx, "value1", flash); // white add for flash fx
	setShaderParam1f(_shaderPostFx, "value2", 100); // color splitting
	setShaderParam1f(_shaderPostFx, "deform_value", deform); // screen glass distortion
	setShaderParam1i(_shaderPostFx, "texture", 0);
	setShaderParam1f(_shaderPostFx, "distort1", distort1*distortMod);
	setShaderParam1f(_shaderPostFx, "distort2", distort2*distortMod);
	setShaderParam1f(_shaderPostFx, "distort3", distort3*distortMod);
	

	glPushMatrix();
	{
		glLoadIdentity();
		glTranslatef(0,0,-1);

		float scaleX = 0.5f;
		float scaleY = 0.33f;

		glBegin(GL_QUADS);
		{
			glTexCoord3f(0, 0, 0);
			glVertex3f(-scaleX*quitValX, -scaleY*quitValY, 0);

			glTexCoord3f(0, 1, 0);
			glVertex3f(-scaleX*quitValX, scaleY*quitValY, 0);

			glTexCoord3f(1, 1, 0);
			glVertex3f(scaleX*quitValX, scaleY*quitValY, 0);

			glTexCoord3f(1, 0, 0);
			glVertex3f(scaleX*quitValX, -scaleY*quitValY, 0);
		}		
		glEnd();

		/*
		ViewOrtho(fbox->info.width, fbox->info.height);
		glViewport(0, 0, globalScreenInfo.width, globalScreenInfo.height); // change viewport to match screen size
		
		glBegin(GL_QUADS);
		{
			glTexCoord3f(0,1, 0);
			glVertex2f((-50*quitValX),(-50*quitValY));

			glTexCoord3f(0, 0, 0);
			glVertex2f((-50*quitValX),(float)(fbox->info.height+50)*quitValY);

			glTexCoord3f(1,0, 0);
			glVertex2f((float)(fbox->info.width+50)*quitValX, (float)(fbox->info.height+50)*quitValY);

			glTexCoord3f(1,1, 0);
			glVertex2f((float)(fbox->info.width+50)*quitValX, (-50*quitValY));
		}		
		glEnd();
		ViewPerspective();*/
	}
	glPopMatrix();
	oglUseProgram(0);
	fbox->BindTexture(0);
	glEnable(GL_DEPTH_TEST);

	float mult = 6.1f;

	if ((float)timeVal*mult < 4.5f)
	{
		deform = 4.5f - ((float)timeVal*mult);
	}else{
		deform = 0.5f;
	}
}

void DrawLogo()
{
	// drawlogo
	glPushMatrix();
	{
		glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
		glEnable(GL_BLEND);

		glColor4f(1,1,1,1);
		glEnable(GL_TEXTURE_2D);
		glDisable(GL_DEPTH_TEST);
		glTranslatef(0,0,-1);
				
		glBindTexture(GL_TEXTURE_2D, textureId);

		float scale = 0.82f;

		float sizeX = 0.7f*scale;
		float sizeY = 0.13f*scale;

		float startX = 0.0f - (sizeX/2.0f);
		float startY = 0.080f;

		glBegin(GL_QUADS);
		{
			glTexCoord2f(0,1);
			glVertex3f(startX, startY, 0);

			glTexCoord2f(0, 0);
			glVertex3f(startX, startY+sizeY, 0);

			glTexCoord2f(1,0);
			glVertex3f(startX+sizeX, startY+sizeY, 0);

			glTexCoord2f(1,1);
			glVertex3f(startX+sizeX, startY, 0);
		}		
		glEnd();


		glBindTexture(GL_TEXTURE_2D, 0);
		glDisable(GL_TEXTURE_2D);
		glDisable(GL_BLEND);
		glEnable(GL_DEPTH_TEST);
	}
	glPopMatrix();
}

bool distorting1 = false;
bool distorting2 = false;
bool distorting3 = false;

float dmodinc = 0.0f;

int intro_do( void )
{
	//timeVal +=8;
	//timeVal+=15;

	//time += 60;
	CheckGlError();
	// detect beat
	// pattern number
	CheckGlError();
	glClearColor(0,0,0,0); // red
	glClear( GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT );

	//_writer->Draw(time);

	//

	//_julia->DrawFboPlasma((float)timeVal);
	glViewport(0, 0, globalScreenInfo.width, globalScreenInfo.height); // change viewport to match screen size

	float introStart = 10;

	fboFullscreen->BindFbo(true);

	if (timeVal <=introStart)
	{
		_logo->draw((float)timeVal);
	}else{
		_julia->Draw((float)timeVal, false);
	}
	
	float part1start = 0+introStart;
	float part1end = 1+introStart;

	float part2start = 1+introStart;
	float part2end = 2+introStart;

	float part3start = 2+introStart;
	float part3end = 4+introStart;

	float fxtime = 0;

	//part1start = part1end = part2start = part2end = part3start = part3end = 0;

	glColor4f(1,1,1,1);

	glEnable(GL_DEPTH_TEST);
	glPushMatrix();
	{
		glLoadIdentity();
		glTranslatef(0,0,-1);
		float pixelSizeX = 1.0f / globalScreenInfo.width;
		float pixelSizeY = 1.0f / globalScreenInfo.height;
		
		if (timeVal >= part1start && timeVal <= part1end)
		{
			fxtime = (float)(((timeVal-introStart)-(part1start-introStart)) / (part1end-introStart)) * 0.5f;
			// dropping dot
			glColor4f(0,0,0,1);
			glBegin(GL_QUADS);
				glVertex3f(-1,-1,0);
				glVertex3f(-1,1,0);
				glVertex3f( 1,1,0);
				glVertex3f( 1,-1,0);
			glEnd();	

			glColor4f(1,1,1,1);
			glBegin(GL_QUADS);
				glVertex3f(0-pixelSizeX,0.5f-pixelSizeY-fxtime,0);
				glVertex3f(0-pixelSizeX,0.5f+pixelSizeY-fxtime,0);
				glVertex3f(0+pixelSizeX,0.5f+pixelSizeY-fxtime,0);
				glVertex3f(0+pixelSizeX,0.5f-pixelSizeY-fxtime,0);
			glEnd();
		}
		
		if (timeVal >= part2start && timeVal <= part2end)
		{
			fxtime = (float)(((timeVal-introStart)-(part2start-introStart)) / (part2end-introStart));
			glColor4f(0,0,0,1);
			glBegin(GL_QUADS);
				glVertex3f(-1,-1,0);
				glVertex3f(-1,1,0);
				glVertex3f( 1,1,0);
				glVertex3f( 1,-1,0);
			glEnd();	
				
			// white lines
			glColor4f(1,1,1,1);
			// bottom 
			glBegin(GL_LINES);
				glVertex3f( 0-fxtime,0,0);
				glVertex3f( 0+fxtime,0,0);
			glEnd();
		}
		
		if (timeVal >= part3start && timeVal <= part3end)
		{
			fxtime = (float)(((timeVal-introStart)-(part3start-introStart)) / (part3end-introStart))*2;
			
			// black bars
			glColor4f(0,0,0,1);

			float ypBot = lerpx(fxtime, 0, -0.20f);
			float ypTop = lerpx(fxtime, 0, 0.13625f);

			// bottom
			glBegin(GL_QUADS);
			glVertex3f(-1,-1,0);
			glVertex3f(-1,ypBot,0);
			glVertex3f( 1,ypBot,0);
			glVertex3f( 1,-1,0);
			glEnd();

			// top
			glBegin(GL_QUADS);
			glVertex3f(-1,ypTop,0);
			glVertex3f(-1,1,0);
			glVertex3f( 1,1,0);
			glVertex3f( 1,ypTop,0);
			glEnd();

			
			// white lines
			glColor4f(1,1,1,1);
			// bottom 
			glBegin(GL_LINES);
				glVertex3f(-1,ypBot,0);
				glVertex3f( 1,ypBot,0);
			glEnd();

			// top
			glBegin(GL_LINES);
				glVertex3f(-1,ypTop,0);
				glVertex3f( 1,ypTop,0);
			glEnd();
		}
		
		if (timeVal > part3end)
		{
			// black bars
			glColor4f(0,0,0,1);
			// bottom
			glBegin(GL_QUADS);
			glVertex3f(-1,-1,0);
			glVertex3f(-1,-0.20f,0);
			glVertex3f( 1,-0.20f,0);
			glVertex3f( 1,-1,0);
			glEnd();

			// top
			glBegin(GL_QUADS);
				glVertex3f(-1,0.15f,0);
				glVertex3f(-1,1,0);
				glVertex3f( 1,1,0);
				glVertex3f( 1,0.15f,0);
			glEnd();

			// white lines
			glColor4f(1,1,1,1);

			glDisable(GL_DEPTH_TEST);
						
			glBegin(GL_LINES);
			// bottom 
			glVertex3f(-1, -0.20f,0);
			glVertex3f( 1, -0.20f,0);
			// top
			glVertex3f(-1, 0.13625f,0);
			glVertex3f( 1, 0.13625f,0);

			glEnd();
			glEnable(GL_DEPTH_TEST);

		}

	}
	glPopMatrix();
	
	if (timeVal > 10)
	{
		DrawLogo();
		
	}

	

	// scroller
	_scroller->Draw(timeVal);

	

	fboFullscreen->BindFbo(false);
	
	//DrawPostFx(time);

	
	glColor3f(1,1,1);
	oglUseProgram(_shaderPostFx);
	glPushMatrix();
	{
		fboFullscreen->BindTexture(1);
		DrawPostFx((float)timeVal);	
	}
	glPopMatrix();
	oglUseProgram(0);
	CheckGlError();
	//glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT );
	//glViewport(0, 0, globalScreenInfo.width, globalScreenInfo.height); // change viewport to match screen size
	//ViewPerspective();
	
	CheckGlError();
	frames+=1.0f;		

	if (!SynthNoteHandled[1] && SynthNotes[1] == 48)
	{		
		split = 10.0f;
	}

	if (!SynthNoteHandled[11] && (SynthNotes[11] == 60 || SynthNotes[11] == 58  || SynthNotes[11] == 62)) 
	{
		distorting1 = true;
		dmodinc = 0.0001f;
		distortMod = 1.04f;
		distort1 *= 1.01f;
		distort2 *= 1.02f;
		distort3 *= 1.03f;
	}

	if (distortMod > 1.0f)
	{
		distortMod-=dmodinc;
		dmodinc*=0.999f;
		if (distortMod < 1.0f) distortMod = 1.0f;
	}

	if (distort1 > 0.525f)
	{
		distort1-=dmodinc;
		dmodinc*=0.999f;
	}

	if (distort2 > 0.525f)
	{
		distort2-=dmodinc;
		dmodinc*=0.999f;
	}

	if (distort2 > 0.525f)
	{
		distort2-=dmodinc;
		dmodinc*=0.999f;
	}

	for(int i=0; i<17; i++)
	{
		SynthNoteHandled[i] = true;
	}

	return( 0 );
}