#include "bmFontChar.h"

bmFontChar::bmFontChar(unsigned char charVal, int x, int y, int width, int height, int xOff, int yOff, int xAdvance, int textureWidth, int textureHeight)
{
	this->CharVal = charVal;
	this->PixelWidth = width;
	this->PixelHeight = height;
	this->_Width = (float)width/(float)textureWidth;
	this->_Height =(float) height/(float)textureHeight;
	this->PixelXOffset = xOff;
	this->PixelYOffset = yOff;
	this->PixelXAdvance = xAdvance;
	this->TextureWidth = textureWidth;
	this->TextureHeight = textureHeight;
	this->_XOffset = (float)xOff/(float)textureWidth;
	this->_YOffset = (float)yOff/(float)textureHeight;
	this->_XAdvance = (float)xAdvance/(float)textureWidth;

	this->_uBL = (float)x / (float)textureWidth;
	this->_vBL = (float)y / (float)textureHeight;

	this->_uBR = (float)x / (float)textureWidth + ((float)width/(float)textureWidth);
	this->_vBR = (float)y / (float)textureHeight;

	this->_uTR = (float)x / (float)textureWidth + ((float)width/(float)textureWidth);
	this->_vTR = (float)y / (float)textureHeight + ((float)height/(float)textureHeight);

	this->_uTL = (float)x / (float)textureWidth;
	this->_vTL = (float)y / (float)textureHeight + ((float)height/(float)textureHeight);
}

bmFontChar::~bmFontChar(void)
{
}
