#include "sphere.h"

#define space 10

float tsin(double d)
{
	return msys_sinf((float)d);
}

float tcos(double d)
{
	return msys_cosf((float)d);
}

sphere::sphere(double R, double H, double K, double Z)
{
	vertexCount = (90 / space) * (360 / space) * 4;
	vertices = new vertex[vertexCount];
	vertexNormals = new vertex[vertexCount];
	texCoords = new vertexTexCoord[vertexCount];

	float PI = (float)M_PI;

	radius =R;

	int n = 0;
	float a;
	float b;

	for( b = 0; b <= 90 - space; b+=space) // rings
	{
		for( a = 0; a <= 360 - space; a+=space) // rows
		{

			vertices[n].x = (float)(R * tsin((a) / 180.0f * M_PI) * tsin((b) / 180.0f * M_PI) - H);

			vertices[n].y = (float)(R * tcos((a) / 180.0f * M_PI) * tsin((b) / 180.0f * M_PI) + K);

			vertices[n].z = (float)(R * tcos((b) / 180.0f * M_PI) - Z);

			texCoords[n].v = (2.0f * b) / 360.0f;

			texCoords[n].u = (a) / 360.0f;

			n++;

			vertices[n].x = (float)(R * tsin((a) / 180.0f * M_PI) * tsin((b + space) / 180.0f * M_PI) - H);

			vertices[n].y = (float)(R * tcos((a) / 180.0f * M_PI) * tsin((b + space) / 180.0f * M_PI) + K);

			vertices[n].z = (float)(R * tcos((b + space) / 180.0f * M_PI) - Z);

			texCoords[n].v = (2.0f * (b + space)) / 360.0f;

			texCoords[n].u = (a) / 360.0f;

			n++;

			vertices[n].x = (float)(R * tsin((a + space) / 180.0f * M_PI) * tsin((b) / 180.0f * M_PI) - H);

			vertices[n].y = (float)(R * tcos((a + space) / 180.0f * M_PI) * tsin((b) / 180.0f * M_PI) + K);

			vertices[n].z = (float)(R * tcos((b) / 180 * M_PI) - Z);

			texCoords[n].v = (2 * b) / 360;

			texCoords[n].u = (a + space) / 360;

			n++;

			vertices[n].x = (float)(R * tsin((a + space) / 180.0f * M_PI) * tsin((b + space) / 180.0f * M_PI) - H);

			vertices[n].y = (float)(R * tcos((a + space) / 180.0f * M_PI) * tsin((b + space) / 180.0f * M_PI) + K);

			vertices[n].z = (float)(R * tcos((b + space) / 180.0f * M_PI) - Z);

			texCoords[n].v = (2 * (b + space)) / 360;

			texCoords[n].u = (a + space) / 360;

			n++;
		}

	}

	//CalcNormals();
}

void sphere::CalcNormals()
{
	/*
	int idx = 0;

	for( int b = 0; b <= 90 - space; b+=space) // rings
	{
		for( int a = 0; a <= 360 - space; a+=space) // rows
		{
			vertex *vn, *v, *vr, *vbr;
				
			for (int i=0; i<4; i++)
			{
				v = &vertices[idx+i];
				vn = &vertexNormals[idx+i];

				vr = &vertices[idx+i+2];		
				vbr = &vertices[idx+i+3];	
				GetFaceNormal(vn, v, vr, vbr);
			}

			idx+=4;
	
			vertex *norm, *vtx, *vtxRight, *vtxBelowRight;			
			int ysub = y > 0 ? y -1 : maxy;

			vtx = &vertices[y+(x*_stepsY)];
			norm = &normals[y+(x*_stepsY)];
			vtxRight = &vertices[y+(rOffset)];
			vtxBelowRight = &vertices[ysub+(rOffset)];
			GetFaceNormal(norm, vtx, vtxRight, vtxBelowRight); // top right
		}
	}*/
}


void sphere::Draw()
{

		int b;
		float scale = (float)(0.0125f * radius);
		//glScalef (scale, scale, scale);
		glBegin (GL_TRIANGLE_STRIP);

		// left half
		for ( b = 0; b < vertexCount; b++){

			glTexCoord2f (texCoords[b].u, texCoords[b].v);
			//glNormal3f(vertexNormals[b].x, vertexNormals[b].y, vertexNormals[b].z);
			glVertex3f (vertices[b].x, vertices[b].y, vertices[b].z);

		}

		// right half
		for ( b = 0; b < vertexCount; b++){
			glTexCoord2f (texCoords[b].u, -texCoords[b].v);
			//glNormal3f(vertexNormals[b].x, vertexNormals[b].y, -vertexNormals[b].z);
			glVertex3f (vertices[b].x, vertices[b].y, -vertices[b].z);
		}

		glEnd();
}

sphere::~sphere(void)
{
	delete(vertices);
	delete(vertexNormals);
	delete(texCoords);
}
