 // SUNSPOT PASS 4a FS
 // blur filter
 
 uniform sampler2D textureToBlur;
 uniform float surfaceWidth;
 uniform float surfaceHeight;
  
 void main()
 {	
	vec4 sample[5];
	vec2 textCoord = gl_TexCoord[0].st;
	float pixelSizeX = 1.0 / surfaceWidth;
	float pixelSizeY = 1.0 / surfaceHeight;
	
    sample[0] = texture2D(textureToBlur, vec2(textCoord.s, textCoord.t) );
	sample[1] = texture2D(textureToBlur, vec2(textCoord.s+pixelSizeX, textCoord.t) );
	sample[2] = texture2D(textureToBlur, vec2(textCoord.s-pixelSizeX, textCoord.t) );
	sample[3] = texture2D(textureToBlur, vec2(textCoord.s, textCoord.t+pixelSizeY) );
	sample[4] = texture2D(textureToBlur, vec2(textCoord.s, textCoord.t-pixelSizeY) );
	gl_FragColor = (sample[1] + sample[2] + sample[3] +sample[4])/4.0;
 }
 