#include "xfader.h"

col ColorFromHSV(float hue, float saturation, float value)
{
    int hi = (long)(msys_ifloorf(hue / 60)) % 6;
    double f = hue / 60 - msys_ifloorf(hue / 60);

    value = value * 255;
    int v = (long)(value);
    int p = (long)(value * (1 - saturation));
    int q = (long)(value * (1 - f * saturation));
    int t = (long)(value * (1 - (1 - f) * saturation));

	col c;
	
    if (hi == 0)        
	{
		//return Color.FromArgb(255, v, t, p);
		c.r = (float)(255/q); c.g = (float)(255/t); c.b = (float)(255/p);
	}else if (hi == 1)
	{
		//return Color.FromArgb(255, v, t, p);
		c.r = (float)(255/q); c.g = (float)(255/v); c.b = (float)(255/p);
	}else if (hi == 2)
	{
		//return Color.FromArgb(255, v, t, p);
		c.r = (float)(255/p); c.g = (float)(255/v); c.b = (float)(255/t);
	}else if (hi == 3)
	{
		//return Color.FromArgb(255, v, t, p);
		c.r = (float)(255/p); c.g = (float)(255/q); c.b = (float)(255/v);
	}else if (hi == 4)
	{
		//return Color.FromArgb(255, v, t, p);
		c.r = (float)(255/t); c.g = (float)(255/p); c.b = (float)(255/v);
	}else
	{
		//return Color.FromArgb(255, v, t, p);
		c.r = (float)(255/v); c.g = (float)(255/p); c.b = (float)(255/q);
	}
	return c;
}

void HSVtoRGB( float *r, float *g, float *b, float h, float s, float v )
{
	//NSLog(@"Hue %f",h);
	int i;
	float f, p, q, t;
	if( s == 0 ) {
		// achromatic (grey)
		*r = *g = *b = v;
		return;
	}
	h /= 60;			// sector 0 to 5
	i = msys_ifloorf( h );
	f = h - i;			// factorial part of h
	p = v * ( 1 - s );
	q = v * ( 1 - s * f );
	t = v * ( 1 - s * ( 1 - f ) );
	switch( i ) {
		case 0:
			*r = v;
			*g = t;
			*b = p;
			break;
		case 1:
			*r = q;
			*g = v;
			*b = p;
			break;
		case 2:
			*r = p;
			*g = v;
			*b = t;
			break;
		case 3:
			*r = p;
			*g = q;
			*b = v;
			break;
		case 4:
			*r = t;
			*g = p;
			*b = v;
			break;
		default:		// case 5:
			*r = v;
			*g = p;
			*b = q;
			break;
	}
}

void rgb_to_hsv(col c, float *h, float *s, float *v)
{
   float min, max, delta, rc, gc, bc;
   int r = (int)(255*c.r);
   int g = (int)(255*c.g);
   int b = (int)(255*c.b);

   rc = (float)(r / 255.0);
   gc = (float)(g / 255.0);
   bc = (float)(b / 255.0);
   max = max(rc, max(gc, bc));
   min = min(rc, min(gc, bc));
   delta = max - min;
   *v = max;

   if (max != 0.0)
      *s = delta / max;
   else
      *s = 0.0;

   if (*s == 0.0) {
      *h = 0.0; 
   }
   else {
      if (rc == max)
	 *h = (gc - bc) / delta;
      else if (gc == max)
	 *h = 2 + (bc - rc) / delta;
      else if (bc == max)
	 *h = 4 + (rc - gc) / delta;

      *h *= 60.0;
      if (*h < 0)
	 *h += 360.0;
    }
}

col xfader::nextColorForIndex(int index)
{
	index = index % (_numCols-1);
	return cols[index];
}

int xfader::getRandomIndex()
{
	int index = msys_rand(&_randCounter) % (_numCols-1);
	_randCounter++;
	return index;
}

col xfader::nextColor()
{
	if ((int)colIndex<_numCols-1)
	{
		colIndex++;
	}else{
		colIndex=0;
	}
	return cols[colIndex];
}

xfader::xfader()
{
	_numCols = 3623422;
	_randCounter = 0;

	cols = (col*)msys_mallocAlloc(sizeof(col) * _numCols);

	colIndex = 0;

	curCol.r = 1.0f;
	curCol.g = 0.0f;
	curCol.b = 0.0f;

	float h, s, v;
	float r, g, b;
	rgb_to_hsv(curCol, &h, &s, &v);

	int colIdx = 0;

	for(float hv=0; hv<360.0f; hv+=0.0001f)
	{
		HSVtoRGB(&r, &g, &b, hv, 1.0f, 1.0f);
		col c;
		c.r = r;
		c.g = g;
		c.b = b;
		cols[colIdx] = c;
		colIdx++;
	}
}