{Ŀ}
{  IVS_VESA.PAS - VESA BIOS Driver - 640x480 15bit include file           }
{                  Work started     : 1998.08.01.                          }
{                  Last modification: 2001.07.02.                          }
{             OS - GO32V2                                                  }
{                                                                          }
{            IVS - Inquisition Video Server for Free Pascal                }
{                  Code by Karoly Balogh (a.k.a. Charlie/iNQ) and          }
{                          Marton Ekler (a.k.a. mrc!/iNQ)                  }
{                  Copyright (C) 1998-2001 Inquisition                     }
{}

Procedure VESA_CopyHi15Bit_Banked_Scaled; Assembler;
Var CurrentBank : Word;
Asm
 XOR  EDX,EDX
 MOV  EAX,VESA_PhysScrAddr
 DIV  VESA_WinSize
 MOV  CurrentBank,AX
 PUSH EDX

 PUSH CurrentBank
 CALL VESA_SwitchBank
 POP  EDX

 PUSH GS
 MOV  ESI,IVS_VirtualScreen
 MOV  GS,VESA_SegA000
 MOV  EDI,EDX
 MOV  EDX,VESA_WinSize

 MOV  ECX,200
 CLD
 @CycleHead1:
  PUSH  ECX
  MOV   ECX,2
  @CycleHead2:
   PUSH ECX
   MOV  ECX,320
   @CycleHead3:
    MOV   EAX,[ESI]
    ROR   EAX,8
    SHR   AH,3
    SHR   AX,3
    ROL   EAX,5
    MOV   BX,AX
    ROL   EAX,16
    MOV   AX,BX
    MOV   GS:[EDI],EAX
    ADD   EDI,4
    CMP   EDI,EDX
    JB    @NoBankSwitch
      INC CurrentBank
      PUSHAD
      PUSH CurrentBank
      CALL VESA_SwitchBank
      MOV  GS,VESA_SegA000
      POPAD
      XOR EDI,EDI
    @NoBankSwitch:
    ADD   ESI,4
   LOOP @CycleHead3
   SUB  ESI,320*4
   POP  ECX
  LOOP @CycleHead2
  ADD  ESI,320*4
  POP  ECX
 LOOP @CycleHead1
 POP  GS
End;

Procedure VESA_CopyHi15Bit_Banked_Laced; Assembler;
Var CurrentBank : Word;
Asm
 XOR  EDX,EDX
 MOV  EAX,VESA_PhysScrAddr
 DIV  VESA_WinSize
 MOV  CurrentBank,AX
 PUSH EDX

 PUSH CurrentBank
 CALL VESA_SwitchBank
 POP  EDX

 PUSH GS
 MOV  ESI,IVS_VirtualScreen
 MOV  GS,VESA_SegA000
 MOV  EDI,EDX
 MOV  EDX,VESA_WinSize

 MOV  ECX,200
 CLD
 @CycleHead1:
  PUSH ECX
  MOV  ECX,320
  @CycleHead2:
   MOV   EAX,[ESI]
   ROR   EAX,8
   SHR   AH,3
   SHR   AX,3
   ROL   EAX,5
   MOV   BX,AX
   ROL   EAX,16
   MOV   AX,BX
   MOV   GS:[EDI],EAX
   ADD   EDI,4
   CMP   EDI,EDX
   JB    @NoBankSwitch
     INC CurrentBank
     PUSHAD
     PUSH CurrentBank
     CALL VESA_SwitchBank
     MOV  GS,VESA_SegA000
     POPAD
     XOR EDI,EDI
   @NoBankSwitch:
   ADD   ESI,4
  LOOP @CycleHead2
  MOV  ECX,320
  @CycleHead3:
   ADD   EDI,4
   CMP   EDI,EDX
   JB    @NoBankSwitch2
     INC CurrentBank
     PUSHAD
     PUSH CurrentBank
     CALL VESA_SwitchBank
     MOV  GS,VESA_SegA000
     POPAD
     XOR EDI,EDI
   @NoBankSwitch2:
  LOOP @CycleHead3
  POP  ECX
 LOOP @CycleHead1
 POP  GS
End;

Procedure VESA_CopyHi15Bit_Linear_Scaled; Assembler;
Asm
 PUSH ES
 MOV  ESI,IVS_VirtualScreen
 MOV  ES,VESA_SegLFB
 MOV  EDI,VESA_PhysScrAddr
 MOV  ECX,200
 CLD
 @CycleHead1:
  MOV  EDX,320
  @CycleHead2: {  First Scanline  }
   MOV   EAX,[ESI]
   ROR   EAX,8 {  32->15 Pixel Conversion  }
   SHR   AH,3
   SHR   AX,3
   ROL   EAX,5
   MOV   BX,AX
   ROL   EAX,16
   MOV   AX,BX
   STOSD
   ADD   ESI,4
   DEC   EDX
  JNZ  @CycleHead2
  SUB  ESI,320*4
  MOV  EDX,320
  @CycleHead3: {  Second Scanline  }
   MOV   EAX,[ESI]
   ROR   EAX,8 {  32->15 Pixel Conversion  }
   SHR   AH,3
   SHR   AX,3
   ROL   EAX,5
   MOV   BX,AX
   ROL   EAX,16
   MOV   AX,BX
   STOSD
   ADD   ESI,4
   DEC   EDX
  JNZ  @CycleHead3
  DEC  ECX
 JNZ  @CycleHead1
 POP  ES
End;

Procedure VESA_CopyHi15Bit_Linear_Laced; Assembler;
Asm
 PUSH ES
 MOV  ESI,IVS_VirtualScreen
 MOV  ES,VESA_SegLFB
 MOV  EDI,VESA_PhysScrAddr
 MOV  ECX,200
 CLD
 @CycleHead1:
  MOV  EDX,320
  @CycleHead2: {  First Scanline  }
   MOV   EAX,[ESI]
   ROR   EAX,8 {  32->15 Pixel Conversion  }
   SHR   AH,3
   SHR   AX,3
   ROL   EAX,5
   MOV   BX,AX
   ROL   EAX,16
   MOV   AX,BX
   STOSD
   ADD   ESI,4
   DEC   EDX
  JNZ  @CycleHead2
  ADD  EDI,320*4
  DEC  ECX
 JNZ  @CycleHead1
 POP  ES
End;

Procedure VESA_CopyHi15Bit_Linear_Bilinear; Assembler;
Asm
 PUSH ES
 MOV  ESI,IVS_VirtualScreen
 MOV  ES,VESA_SegLFB
 MOV  EDI,VESA_PhysScrAddr
 MOV  ECX,200
 @Loop2:
   PUSH ECX
   MOV ECX,320
 @Loop1:
   PUSH ECX

   MOV EAX,[ESI]
   MOV EDX,EAX
   MOV EBX,[ESI+4]

   ROR   EAX,8 {  First Pixel  }
   SHR   AH,3
   SHR   AX,3
   ROL   EAX,5

   MOV CX,AX

   MOV EAX,EBX
   MOV EBX,EDX
   SHR AL,1
   SHR AH,1
   ROR EAX,16
   SHR AL,1
   SHR BL,1
   SHR BH,1
   ROR EBX,16
   SHR BL,1
   ADD AL,BL
   ROR EAX,16
   ROR EBX,16
   ADD AL,BL
   ADD AH,BH

   ROR   EAX,8 {  Second Pixel  }
   SHR   AH,3
   SHR   AX,3
   ROL   EAX,5

   SHL EAX,16
   MOV AX,CX

   STOSD

   MOV EAX,[ESI+1280]
   SHR AL,1
   SHR AH,1
   ROR EAX,16
   SHR AL,1
   ROR EBX,16
   ADD AL,BL
   ROR EAX,16
   ROR EBX,16
   ADD AL,BL
   ADD AH,BH

   MOV EDX,EAX

   ROR   EAX,8 {  Third Pixel  }
   SHR   AH,3
   SHR   AX,3
   ROL   EAX,5

   MOV CX,AX

   MOV EAX,[ESI+4]
   MOV EBX,[ESI+1284]
   SHR AL,1
   SHR AH,1
   ROR EAX,16
   SHR AL,1
   SHR BL,1
   SHR BH,1
   ROR EBX,16
   SHR BL,1
   ADD AL,BL
   ROR EAX,16
   ROR EBX,16
   ADD AL,BL
   ADD AH,BH

   SHR AL,1
   SHR AH,1
   ROR EAX,16
   SHR AL,1

   SHR DL,1
   SHR DH,1
   ROR EDX,16
   SHR DL,1

   ADD AL,DL
   ROR EAX,16
   ROR EDX,16
   ADD AL,DL
   ADD AH,DH

   ROR   EAX,8 {  Fourth Pixel  }
   SHR   AH,3
   SHR   AX,3
   ROL   EAX,5
   SHL EAX,16
   MOV AX,CX

   ADD EDI,1276
   STOSD
   SUB EDI,1280

   ADD ESI,4

   POP ECX
 DEC ECX
 JNZ @Loop1
 ADD EDI,1280
 POP ECX
 DEC ECX
 JNZ @Loop2
 POP  ES
End;

{  320x200/15bit hicolor  }
Const VESA_HighResHiColor15 : IVS_TVideoMode =
           (VMWidth  :640; VMHeight  :480;
            VMBFWidth:320; VMBFHeight:200;
            VMColours:32768; VMBPP:15;
            VMName:'doubled hicolor';
            VMMode:0;
            VMDoubleBuf:IVS_VMEnabled;
            VMVSync    :IVS_VMDisabled;
            VMAvailable:True;
            VMCopy_Banked:(CP_Normal  :@IVS_DummyProc;
                           CP_Scaled  :@VESA_CopyHi15Bit_Banked_Scaled;
                           CP_Laced   :@VESA_CopyHi15Bit_Banked_Laced;
                           CP_Bilinear:@IVS_DummyProc);
            VMCopy_Linear:(CP_Normal  :@IVS_DummyProc;
                           CP_Scaled  :@VESA_CopyHi15Bit_Linear_Scaled;
                           CP_Laced   :@VESA_CopyHi15Bit_Linear_Laced;
                           CP_Bilinear:@VESA_CopyHi15Bit_Linear_Bilinear));

{  VBE_HI15.PAS - (C) 1998-2001 Charlie/Inquisition et. al.  }
