{Ŀ}
{  IVS_UTIL.PAS - Additional Drawing Routines                             }
{                  Work started     : 1998.08.01.                          }
{                  Last modification: 2001.07.02.                          }
{             OS - Platform Independent                                    }
{                                                                          }
{            IVS - Inquisition Video Server for Free Pascal                }
{                  Code by Karoly Balogh (a.k.a. Charlie/iNQ) and          }
{                          Marton Ekler (a.k.a. mrc!/iNQ)                  }
{                  Copyright (C) 1998-2001 Inquisition                     }
{}
{$ASMMODE INTEL}
{$MODE FPC}

{$NOTES ON} {  Enable this if you modify the source!  }
{$HINTS ON} {  Enable this if you modify the source!  }
Unit IVS_Util;

Interface

Procedure IVS_ClearScreen(Screen: Pointer);
Procedure IVS_BackGroundClearScreen(Image, Screen: Pointer);
Procedure IVS_PutPixel(X,Y: DWord; Color: DWord; Screen: Pointer);

Procedure IVS_ConvertBGRToXRGB(Image: Pointer; Size: DWord);

Implementation

Procedure IVS_ClearScreen(Screen: Pointer); Assembler;
Asm
  MOV EDI,Screen
  MOV ECX,64000
  XOR EAX,EAX
  REP STOSD
End ['EDI','EAX','ECX'];

Procedure IVS_BackGroundClearScreen(Image, Screen: Pointer); Assembler;
Asm
  MOV EDI,Screen
  MOV ESI,Image
  MOV ECX,64000
  XOR EAX,EAX
  REP MOVSD
End ['EDI','ESI','EAX','ECX'];

Procedure IVS_PutPixel(X,Y: DWord; Color: DWord; Screen: Pointer); Assembler;
Asm
  CMP X,320
  JAE @Exit
  CMP Y,200
  JAE @Exit
  MOV EDI,Screen
  MOV EAX,320
  MUL Y
  ADD EAX,X
  SHL EAX,2
  ADD EDI,EAX
  MOV EAX,Color
  MOV [EDI],EAX
  @Exit:
End ['EDI','EAX'];

Procedure IVS_ConvertBGRToXRGB(Image: Pointer; Size: DWord); Assembler;
Asm
  MOV ESI,Image
  MOV EDI,Image
  MOV EAX,4
  MOV EBX,Size
  DEC EBX
  MUL EBX
  ADD EDI,EAX
  MOV EAX,3
  MUL EBX
  ADD ESI,EAX
  MOV ECX,Size
  @ConvLoop:
    MOV EAX,[ESI]
    MOV BH,AH
    ROR EAX,16
    MOV AH,BH
    MOV [EDI],EAX
    SUB ESI,3
    SUB EDI,4
  DEC ECX
  JNZ @ConvLoop
End ['ESI','EDI','EAX','EBX','ECX'];

Begin
End.

{  IVS_UTIL.PAS - (C) 1998-2001 Charlie/Inquisition et. al.  }
{  LIMITED VERSION  }
