{Ŀ}
{  IVS_SYS .PAS - Main System Routines                                    }
{                  Work started     : 1998.08.01.                          }
{                  Last modification: 2001.07.02.                          }
{             OS - GO32V2                                                  }
{                                                                          }
{            IVS - Inquisition Video Server for Free Pascal                }
{                  Code by Karoly Balogh (a.k.a. Charlie/iNQ) and          }
{                          Marton Ekler (a.k.a. mrc!/iNQ)                  }
{                  Copyright (C) 1998-2001 Inquisition                     }
{}
{$INCLUDE IVS_SET.INC}
{$MODE FPC}

{$NOTES OFF} {  Enable this if you modify the source!  }
{$HINTS OFF} {  Enable this if you modify the source!  }
Unit IVS_Sys;

Interface

Uses IVS_Var {  System variables and types  }
     {$IFDEF _IVS_VGA_INCLUDE_}
      ,IVS_VGA
     {$ENDIF}
     {$IFDEF _IVS_VESA_INCLUDE_}
      ,IVS_VESA
     {$ENDIF}
     {$IFDEF _IVS_DIVE_INCLUDE_}
      ,IVS_DIVE
     {$ENDIF}
     {$IFDEF _IVS_DDRAW_INCLUDE_}
      ,IVS_DDRW
     {$ENDIF}
     {$IFDEF _IVS_IDSMODE_}
     {$ELSE}
      ,IVS_USER,CRT
     {$ENDIF}
     ;

{  Sets up the devices & allocates virtual framebuffer memory  }
Function IVS_InitSystem : Boolean;

{  Shuts down the system, and deallocates framebuffer memory  }
Function IVS_DoneSystem : Boolean;

{  Select best available device and mode  }
Function IVS_AutoSelectMode : Boolean;
{  Calls an user interface function which allows easy manual setup of  }
{  the system  }
Function IVS_ManualSelectMode : Boolean;
{  Force mode selection by device and mode number.  }
{  This is included here for IDS compatibility, and should NOT be used  }
{  from any external programs!  }
Function IVS_ForceMode(DevNum : DWord; ModeNum : DWord) : Boolean;

Function IVS_Init : Boolean;
Function IVS_Done : Boolean;

{  Flips the two backbuffers  }
Procedure IVS_Flip;

{  >>> P U B L I C  V A R I A B L E S <<<  }

Var IVS_DevicesNum  : DWord;   {  Number of the video devices  }
    IVS_DevicesInit : Boolean; {  True if devices was initialized  }
    IVS_ModeInit    : Boolean; {  True if an IVS mode is enabled  }

    IVS_VideoDevices     : Array[1..IVS_MaxDevices] Of IVS_PVideoDevice;
    IVS_CurrentDevice    : IVS_PVideoDevice;
    IVS_CurrentDriver    : IVS_PVideoDriver;
    IVS_CurrentDeviceNum : DWord;
    IVS_CurrentModeNum   : DWord;
    IVS_CurrentModeSetup : IVS_TModeSetup;

Implementation

{  >>> I N T E R N A L  F U N C T I O N S <<<  }

{  Inits and includes device drivers. Called by IVS_InitSystem  }
Function IVS_InitDevices : Boolean;
Begin
 IVS_InitDevices:=False;
 {  Exit if device driver already initialized  }
 If IVS_DevicesInit Then Exit;

 IVS_DevicesNum:=0;

 {$IFDEF _IVS_VESA_INCLUDE_}
  Inc(IVS_DevicesNum);
  IVS_VESADevInit; {  Init VESA  }
  IVS_VideoDevices[IVS_DevicesNum]:=@IVS_VESADevice; {  Include VESA  }
  If Not IVS_VideoDevices[IVS_DevicesNum]^.DevAvail Then Dec(IVS_DevicesNum);
 {$ENDIF}

 {$IFDEF _IVS_VGA_INCLUDE_}
  Inc(IVS_DevicesNum);
  IVS_VGADevInit; {  Init VGA  }
  IVS_VideoDevices[IVS_DevicesNum]:=@IVS_VGADevice; {  Include VGA  }
  If Not IVS_VideoDevices[IVS_DevicesNum]^.DevAvail Then Dec(IVS_DevicesNum);
 {$ENDIF}

 {$IFDEF _IVS_DIVE_INCLUDE_}
  Inc(IVS_DevicesNum);
  IVS_DIVEDevInit; {  Init DIVE  }
  IVS_VideoDevices[IVS_DevicesNum]:=@IVS_DIVEDevice; {  Include DIVE  }
  If Not IVS_VideoDevices[IVS_DevicesNum]^.DevAvail Then Dec(IVS_DevicesNum);
 {$ENDIF}

 {$IFDEF _IVS_DIVE_INCLUDE_}
  Inc(IVS_DevicesNum);
  IVS_DDRAWDevInit; {  Init DirectDraw  }
  IVS_VideoDevices[IVS_DevicesNum]:=@IVS_DDRAWDevice; {  Include DirectDraw  }
  If Not IVS_VideoDevices[IVS_DevicesNum]^.DevAvail Then Dec(IVS_DevicesNum);
 {$ENDIF}

 IVS_DevicesInit:=(IVS_DevicesNum>0);
 IVS_InitDevices:=IVS_DevicesInit;
End;

Function IVS_GetDisplayModeFlags(VMMode : IVS_TVideoMode; AccessLinear : Boolean) : Byte;
Var BufNormal, BufScaled, BufLaced, BufBilinear : Byte;
    BufModeStruc : IVS_TCopyProc;
Begin
 With VMMode Do Begin
   If Not AccessLinear Then Begin
     BufModeStruc:=VMCopy_Banked;
    End Else Begin
     BufModeStruc:=VMCopy_Linear;
    End;

   With BufModeStruc Do Begin
     If CP_Normal  <>@IVS_DummyProc Then BufNormal:=1   Else BufNormal:=0;
     If CP_Scaled  <>@IVS_DummyProc Then BufScaled:=1   Else BufScaled:=0;
     If CP_Laced   <>@IVS_DummyProc Then BufLaced:=1    Else BufLaced:=0;
     If CP_Bilinear<>@IVS_DummyProc Then BufBilinear:=1 Else BufBilinear:=0;
    End;
  End;
 IVS_GetDisplayModeFlags:=
     (BufBilinear Shl 3)+(BufLaced Shl 2)+(BufScaled Shl 1)+BufNormal;
End;

Function IVS_DetectSingleMode(DisplayFlags : Byte) : Boolean;
Begin
 IVS_DetectSingleMode:=False;
 If (DisplayFlags=IVS_DMNotSupport) Or (DisplayFlags=IVS_DMNormal) Or
    (DisplayFlags=IVS_DMScaled) Or (DisplayFlags=IVS_DMLaced) Or
    (DisplayFlags=IVS_DMBilinear) Then IVS_DetectSingleMode:=True;
End;

Function IVS_GetModeSetup(DeviceNum : Word; ModeNum : Word) : IVS_TModeSetup;
Var BufModeSetup : IVS_TModeSetup;
Begin
 With BufModeSetup Do Begin
   With IVS_VideoDevices[DeviceNum]^ Do Begin

     {  Query Modeflags  }
     MSDispFlagsLFB   :=IVS_GetDisplayModeFlags(DevModeList[ModeNum],True);
     MSDispFlagsBanked:=IVS_GetDisplayModeFlags(DevModeList[ModeNum],False);
     MSDispFlags:=MSDispFlagsLFB;
     If MSDispFlags=0 Then MSDispFlags:=MSDispFlagsBanked;

     {  Setting default modeflag  }
     MSDispMode:=IVS_DMNotSupport;
     If Boolean(MSDispFlags And IVS_DMNormal)   Then MSDispMode:=IVS_DMNormal   Else
     If Boolean(MSDispFlags And IVS_DMScaled)   Then MSDispMode:=IVS_DMScaled   Else
     If Boolean(MSDispFlags And IVS_DMLaced)    Then MSDispMode:=IVS_DMLaced    Else
     If Boolean(MSDispFlags And IVS_DMBilinear) Then MSDispMode:=IVS_DMBilinear;

     {  Setting Framebuffer flag  }
     MSLinear:=IVS_VMNotSupport;
     If (MSDispFlagsLFB<>IVS_DMNotSupport) And (MSDispFlagsBanked=IVS_DMNotSupport) Then
       MSLinear:=IVS_VMSupport;
     If (MSDispFlagsLFB<>IVS_DMNotSupport) And (MSDispFlagsBanked<>IVS_DMNotSupport) Then
       MSLinear:=IVS_VMEnabled;

     {  Setting Double buffering and Vertical Sync flags  }
     With DevModeList[ModeNum] Do Begin
       MSDoubleBuf:=VMDoubleBuf;
       MSVSync:=VMVSync;
      End;

    End;
  End;
 IVS_GetModeSetup:=BufModeSetup;
End;


{  >>> P U B L I C  F U N C T I O N S <<<  }

{  Sets up the system. Inits devices & virtual framebuffer memory.  }
{  This procedure _MUST_ be called _FIRST_.  }
Function IVS_InitSystem : Boolean;
Begin
 IVS_InitSystem:=False;
 {$IFDEF _IVS_SYS_DEBUGMODE_}
  WriteLn('IVS_INIT: ',IVS_Name,' version ',IVS_VersionStr,' ',IVS_AdditionalVersionStr);
  WriteLn('IVS_INIT: Copyright (C) 1998-2001 by Charlie and mrc! of Inquisition');
 {$ENDIF}

 {  Inits devices  }
 If Not IVS_InitDevices Then Exit;

 {  Allocating backbuffer memory  }
 If IVS_VirtualScreen=Nil  Then GetMem(IVS_VirtualScreen,256000);
 If IVS_PrevVirtScreen=Nil Then GetMem(IVS_PrevVirtScreen,256000);

 IVS_InitSystem:=True;
End;

{  Shuts down the system. Deallocates virtual framebuffer memory.  }
{  This procedure _MUST_ be called _LAST_.  }
Function IVS_DoneSystem : Boolean;
Begin
 IVS_DoneSystem:=False;
 If Not IVS_DevicesInit Then Begin
   {  Exit if the devices wasn't initialized  }
   Exit;
  End;

 {  Deallocating backbuffer memory  }
 If IVS_VirtualScreen<>Nil  Then FreeMem(IVS_VirtualScreen,256000);
 If IVS_PrevVirtScreen<>Nil Then FreeMem(IVS_PrevVirtScreen,256000);

 IVS_DoneSystem:=True;
End;


{  >>> MODE INIT AND CLOSE FUNCTIONS <<<  }

{  Select best available device and mode  }
Function IVS_AutoSelectMode : Boolean;
Var Counter   : Word;
Begin
 IVS_AutoSelectMode:=False;
 If Not IVS_DevicesInit Then Begin
   {  Exit if the devices wasn't initialized  }
   Exit;
  End;

 {  Detecting every device  }
 For Counter:=1 To IVS_DevicesNum Do Begin
   IVS_VideoDevices[Counter]^.DevDriver^.DrvDetect;
  End;

 {  Search the first device which has valid best mode number.  }
 {  That is the best mode and device available.  }
 Counter:=1;
 Repeat
   IVS_CurrentDeviceNum:=Counter; {  The first device is the best  }
   IVS_CurrentDevice:=IVS_VideoDevices[IVS_CurrentDeviceNum];
   IVS_CurrentDriver:=IVS_CurrentDevice^.DevDriver;
 Until IVS_CurrentDevice^.DevBestMode<>$0FFFF;

 IVS_CurrentModeNum:=IVS_CurrentDevice^.DevBestMode;

 IVS_CurrentModeSetup:=IVS_GetModeSetup(IVS_CurrentDeviceNum,IVS_CurrentModeNum);
 IVS_AutoSelectMode:=True;
End;

{  Calls an user interface function which allows easy manual setup of  }
{  the system  }
Function IVS_ManualSelectMode : Boolean;
Var Pressed        : Char;
    ValidSelection : Boolean;
    Counter        : Word;
    Counter2       : Word;
    CurrentMode    : Word;
    CurrentDevice  : Word;
    ModeSetup      : IVS_TModeSetup;
    PrevMode       : Word;
    PrevDevice     : Word;
    CompileCoder   : String;
Begin
 IVS_ManualSelectMode:=False;
 {  Exit if the devices wasn't initialized  }
 If Not IVS_AutoSelectMode Then Exit;

 {$IFDEF _IVS_SYS_DEBUGMODE_}
  WriteLn('IVS_INIT: Starting manual videomode selection...');
 {$ENDIF}

 {$IFDEF _IVS_IDSMODE_}
 {$ELSE}
  IVS_UIDrawSetupBackGround;

  {  Drawing the system infos  }
  TextColor(DarkGray);
  {$WARNINGS OFF} CompileCoder:={$I %CODER%}; {$WARNINGS ON}
  If CompileCoder='' Then CompileCoder:='an unknown guy';
  GotoXY(3,4); WriteLn('Compiled by ',CompileCoder,' at ',{$I %TIME},' on ',{$I %DATE%});
  GotoXY(3,5); WriteLn('Free Pascal Compiler version : ',{$I %FPCVERSION%},#13,#10);
  GotoXY(3,7); WriteLn('Included Device Drivers : ',IVS_DevicesNum);
  For Counter:=1 To IVS_DevicesNum Do Begin
    GotoXY(3,7+Counter);
    WriteLn(' - ',IVS_VideoDevices[Counter]^.DevName);
   End;

  {  Main menu loop  }
  ValidSelection:=False;
  CurrentMode:=IVS_CurrentModeNum;
  CurrentDevice:=IVS_CurrentDeviceNum;
  PrevMode:=$FFFF;
  PrevDevice:=$FFFF;
  Repeat

    {  Recalculating flags if mode changed  }
    If (PrevMode<>CurrentMode) Or (PrevDevice<>CurrentDevice) Then Begin
      ModeSetup:=IVS_GetModeSetup(CurrentDevice,CurrentMode);
      PrevMode:=CurrentMode;
      PrevDevice:=CurrentDevice;
     End;

    {  Drawing the custom features  }
    With ModeSetup Do Begin

      TextColor(DarkGray);
      GotoXY(4,18); Write('Visualization mode is '); IVS_UIWriteDisplayMode(MSDispMode);
      If Not IVS_DetectSingleMode(MSDispFlags) Then TextColor(DarkGray)
                                               Else TextColor(LightGray);
      GotoXY(60,18); Write('(toggle with F1)');

      TextColor(DarkGray);
      GotoXY(4,19); Write('Linear videomemory access is '); IVS_UIWriteCustomSetting(MSLinear);
      TextColor(LightGray);
      If (MSLinear=IVS_VMEnabled) And
         Boolean(MSDispFlagsBanked And MSDispMode) Then TextColor(DarkGray) Else
      If (MSLinear=IVS_VMDisabled) And
         Boolean(MSDispFlagsLFB And MSDispMode) Then TextColor(DarkGray);
      GotoXY(60,19); Write('(toggle with F2)');

      TextColor(DarkGray);
      GotoXY(4,20); Write('Hardware double buffering '); IVS_UIWriteCustomSetting(MSDoubleBuf);
      If MSDoubleBuf>1 Then TextColor(DarkGray) Else TextColor(LightGray);
      GotoXY(60,20); Write('(toggle with F3)');

      TextColor(DarkGray);
      GotoXY(4,21); Write('Vertical retrace syncronization '); IVS_UIWriteCustomSetting(MSVSync);
      If MSVSync>1 Then TextColor(DarkGray) Else TextColor(LightGray);
      GotoXY(60,21); Write('(toggle with F4)');

     End;

    {  Drawing the mode selection menu  }
    GotoXY(5,27);
    For Counter:=1 To IVS_DevicesNum Do Begin
      GotoXY(4,WhereY+2); TextColor(White);
      Write(' ',IVS_VideoDevices[Counter]^.DevName);
      For Counter2:=IVS_VideoDevices[Counter]^.DevModeNum-1 DownTo 0 Do Begin
        If (CurrentDevice=Counter) And (CurrentMode=Counter2) Then Begin
          If IVS_VideoDevices[Counter]^.DevModeList[Counter2].VMAvailable Then Begin
            TextColor(White); TextBackGround(Blue);
           End Else Begin
            TextColor(LightGray); TextBackGround(Blue);
           End;
         End Else Begin
          If IVS_VideoDevices[Counter]^.DevModeList[Counter2].VMAvailable Then Begin
            TextColor(Black); TextBackGround(LightGray);
           End Else Begin
            TextColor(DarkGray); TextBackGround(LightGray);
           End;
         End;
        With IVS_VideoDevices[Counter]^.DevModeList[Counter2] Do Begin
          GotoXY(4,WhereY+1);
          Write('  ',VMWidth,'x',VMHeight,' ',VMBPP,' bit ',VMName);
          Write(' ':45-WhereX);
         End;
        TextColor(DarkGray); TextBackGround(LightGray);
       End;
     End;

    {  Checking keyboard  }
    Pressed:=Readkey;
    Case Pressed Of
      #0  : Begin
              Pressed:=Readkey;
              Case Pressed Of
                #72 : Begin {  Cursor Up  }
                        With IVS_VideoDevices[CurrentDevice]^ Do Begin
                          If CurrentMode<DevModeNum-1 Then Inc(CurrentMode) Else
                          If ((CurrentMode=DevModeNum-1) And (CurrentDevice>1)) Then Begin
                            CurrentMode:=0; Dec(CurrentDevice);
                           End;
                         End;
                       End;
                #80 : Begin {  Cursor Down  }
                        With IVS_VideoDevices[CurrentDevice]^ Do Begin
                          If CurrentMode>0 Then Dec(CurrentMode) Else
                          If ((CurrentMode=0) And (CurrentDevice<IVS_DevicesNum)) Then Begin
                            Inc(CurrentDevice); CurrentMode:=IVS_VideoDevices[CurrentDevice]^.DevModeNum-1;
                           End;
                         End;
                       End;
                #59 : Begin {  F1  }
                        With ModeSetup Do Begin
                          If Not IVS_DetectSingleMode(MSDispFlags) Then Begin
                            Repeat
                              MSDispMode:=MSDispMode Shl 1;
                              If MSDispMode>8 Then MSDispMode:=1;
                            Until Boolean(MSDispFlags And MSDispMode);
                           End;
                         End;
                       End;
                #60 : Begin {  F2  }
                        With ModeSetup Do Begin
                          If (MSLinear=IVS_VMEnabled) And
                             Boolean(MSDispFlagsBanked And MSDispMode) Then Begin
                            MSLinear:=IVS_VMDisabled;
                            MSDispFlags:=MSDispFlagsBanked;
                           End Else
                          If (MSLinear=IVS_VMDisabled) And
                             Boolean(MSDispFlagsLFB And MSDispMode) Then Begin
                            MSLinear:=IVS_VMEnabled;
                            MSDispFlags:=MSDispFlagsLFB;
                           End;
                         End;
                       End;
                #61 : Begin {  F3  }
                        With ModeSetup Do Begin
                          If MSDoubleBuf=IVS_VMEnabled Then MSDoubleBuf:=IVS_VMDisabled Else
                          If MSDoubleBuf=IVS_VMDisabled Then MSDoubleBuf:=IVS_VMEnabled;
                         End;
                       End;
                #62 : Begin {  F4  }
                        With ModeSetup Do Begin
                          If MSVSync=IVS_VMEnabled Then MSVSync:=IVS_VMDisabled Else
                          If MSVSync=IVS_VMDisabled Then MSVSync:=IVS_VMEnabled;
                         End;
                       End;
               End;
             End;
      #13 : Begin
              If IVS_VideoDevices[CurrentDevice]^.DevModeList[CurrentMode].VMAvailable Then Begin
                ValidSelection:=True;
                IVS_ManualSelectMode:=True;
                IVS_CurrentModeNum:=CurrentMode;
                IVS_CurrentDeviceNum:=CurrentDevice;
                IVS_CurrentModeSetup:=ModeSetup;

                IVS_CurrentDevice:=IVS_VideoDevices[IVS_CurrentDeviceNum];
                IVS_CurrentDriver:=IVS_CurrentDevice^.DevDriver;
                IVS_UIRestoreScreen;
                {$IFDEF _IVS_SYS_DEBUGMODE_}
                 WriteLn('IVS_INIT: Videomode selected: ',IVS_CurrentDevice^.DevName,'-',IVS_CurrentModeNum);
                {$ENDIF}
               End;
             End;
      #27 : Begin
              IVS_UIRestoreScreen;
              {$IFDEF _IVS_SYS_DEBUGMODE_}
               WriteLn('IVS_FAIL: Videomode selection terminated by the user!');
              {$ENDIF}
              ValidSelection:=True;
             End;
     End;

  Until ValidSelection;
  While Keypressed Do Readkey;
 {$ENDIF}
End;

{  Force mode selection by device and mode number.  }
{  Not implemented yet.  }
Function IVS_ForceMode(DevNum : DWord; ModeNum : DWord) : Boolean;
Begin
 IVS_ForceMode:=False;
End;

Function IVS_Init : Boolean;
Var ModeSwitchOK : Boolean;
Begin
 IVS_Init:=False;
 If Not IVS_DevicesInit Then Begin
   {  Exit if the devices wasn't initialized  }
   Exit;
  End;

 {  Switching mode on  }
 ModeSwitchOK:=IVS_CurrentDriver^.DrvInit(IVS_CurrentModeNum,IVS_CurrentModeSetup);
 If ModeSwitchOK Then Begin
   IVS_Copy:=IVS_CurrentDriver^.DrvCopy;
   IVS_Init:=True;
  End;
End;

Function IVS_Done : Boolean;
Begin
 IVS_Done:=False;
 If Not IVS_DevicesInit Then Begin
   {  Exit if the devices wasn't initialized  }
   Exit;
  End;

 {  Shutting down videomode  }
 IVS_CurrentDriver^.DrvClose;
 IVS_Copy:=@IVS_DummyProc;
End;

{  >>> BACKBUFFER RELEATED FUNCTIONS <<<  }

{  Flips the two backbuffers  }
Procedure IVS_Flip;
Var Buffer : Pointer;
Begin
 Buffer:=IVS_VirtualScreen;
 IVS_VirtualScreen:=IVS_PrevVirtScreen;
 IVS_PrevVirtScreen:=Buffer;
End;


{  >>> I N I T  C O D E <<<  }

Begin
 IVS_DevicesInit:=False;
 IVS_Copy:=@IVS_DummyProc;
End.

{  IVS_SYS.PAS - (C) 1998-2001 Charlie/Inquisition et. al.  }

{  History:  }
{  1.0.3 - Some preliminary code added for the upcoming OS/2 DIVE and     }
{          Windows DirectDraw support. [2001.07.02. Charlie]              }
{  1.0.2 - Debug mode coder name compile-time warning and empty string    }
{          fix when no environment variable set.                          }
{          [2001.01.17. Charlie]                                          }
{  1.0.1 - IVS_ManualSelectMode messed up screen if unsupported mode      }
{          was selected [2000.10.15 - mrc!]                               }
{  1.0.0 - Initial version [2000.08.29. Charlie]                          }
