


// includes.
#include <stdio.h>
#include <stdlib.h>
#include <stddef.h>
#include <conio.h>
#include <time.h>

typedef	unsigned long	UD;
typedef	long		SD;
typedef unsigned short	UW;
typedef short		SW;
typedef unsigned char	UB;
typedef char		SB;



#define HEADER_SIZE		8

#define	CMD_HARD_INIT		0
#define	CMD_READ_SECTOR		1
#define CMD_WRITE_SECTOR	2
#define CMD_DODISK		3
#define CMD_SHUTDOWN		4


#define TIMING		256




#define 	UCHAR_MAX	(255)
#define		CHAR_BIT	(8)
#define		CRCPOLY		0xEDB88320L
#define		UPDATE_CRC(r,c) r=crctable[ ((UB)(r)^(UB)(c))&0xff ]^(r>>CHAR_BIT)
typedef		unsigned long	UCRC;

static UCRC   crctable[UCHAR_MAX + 1];


UD	calc_crc(char *ptr,UD size);






UB	command_buffer[8];
char	bcrc32[4];
UD	vcrc32,ccrc;

static	char	*ret_ok="LEO!";
static	char	*ret_false="AAAA";
static	UB	tampon[512*10];



UD	get_dword(char *pt)
 {
 UD	ret;


	ret=*pt++;
	ret|=(*pt++)<<8;
	ret|=(*pt++)<<16;
	ret|=(*pt++)<<24;
	return ret;

 }

void	bell(void)
 {
	putchar(7);
 }






int	receive_block(UB *ptr,int size)
 {
 register UB	data,o;
 UB *optr;
 int	osize;


	optr=ptr;
	osize=size;



	do {

	  do {
	    data=inp(0x379);
	  } while (data&0x80);


	  o=(data&0x78)<<1;

	  do {
	    data=inp(0x379);
	  } while (!(data&0x80));


	  o |= ((data&0x78)>>3);

	  *ptr++=o;

	} while (--size);



	// reception du CRC32

	ptr=bcrc32+4;

	size=4;
	do {

	  do {
	    data=inp(0x379);
	  } while (data&0x80);


	  o=(data&0x78)<<1;

	  do {
	    data=inp(0x379);
	  } while (!(data&0x80));


	  o |= ((data&0x78)>>3);

	  *(--ptr)=o;

	} while (--size);


	//vcrc32=get_dword(bcrc32);


	vcrc32=*((UD *)bcrc32);
	ccrc=calc_crc(optr,osize);


	if (vcrc32==ccrc) return 0;


	return (-1);

 }


void	mwait(UD v)
 {

	v<<=2;

	do {
	} while (--v);

 }


void	send_block(UB *ptr,int size)
 {
 register UB	data,strobe;





	ccrc=calc_crc(ptr,(UD)size);


#if 0
	mwait(32767);
	mwait(32767);
	mwait(32767);
	mwait(32767);
	mwait(32767);
	mwait(32767);
	mwait(32767);
#endif
	mwait(32767);

	do {

	  data=*ptr++;
	  outp(0x378,data);		// Ecrit data.
	  strobe=inp(0x37a);
	  strobe^=1;
	  outp(0x37a,strobe);		// Ecrit data.
	  mwait(TIMING);

	} while (--size);


	size=4;
	do {

	  data=(ccrc>>24);
	  ccrc<<=8;

	  outp(0x378,data);		// Ecrit data.
	  strobe=inp(0x37a);
	  strobe^=1;
	  outp(0x37a,strobe);		// Ecrit data.
	  mwait(TIMING);

	} while (--size);


 }




int	wait_cmd(void)
 {
 int	cmd;



	printf("Waiting command from ATARI...\n");


	receive_block(command_buffer,HEADER_SIZE);

	cmd=command_buffer[0]<<8 | command_buffer[1];


	return cmd;


 }


void	make_crctable(void)
 {
 UD	i, j;
 UCRC	r;


	for (i = 0; i <= UCHAR_MAX; i++) {
	  r = i;
	  for (j=CHAR_BIT;j>0;j--) {
	    if (r & 1)
	      r=(r>>1)^CRCPOLY;
	    else
	      r>>=1;
	  }
	  crctable[i]=r;
	}
 }


UD	calc_crc(char *ptr,UD size)
 {
 UD	crc;


	crc=0;

	while (size--) UPDATE_CRC(crc,*ptr++);

	return (crc);
 }


void	p_cmd(char *message)
 {


	printf("COMMAND:%s\n",message);
 }


void	test(void)
 {
 UB	data;


	do {
	  data=inp(0x379);

	  data&=0x78;
	  data>>=3;

	  printf("DATA=$%02X\n",data);

	} while (!kbhit());

	while (kbhit()) getch();


 }




void	test_send(void)
 {
 FILE	*in;
 UW	i;


	in=fopen("harddisk.exe","rb");
	if (!in) {
		printf("error\n");
		exit(1);
	}

	fread(tampon,1,4*1024,in);
	fclose(in);

	//memset(tampon,0xaa,4*1024);


	for (i=0;i<(4*1024);i+=4) {
	  tampon[i]=0;
	  tampon[i+1]=0x34;
	  tampon[i+2]=0x56;
	  tampon[i+3]=0x78;
	}



	for (i=0;i<8;i++) {
	  send_block(tampon,4*1024);
	  printf("%d\n",i);
	}


	exit(1);

 }









void	main(void)
 {
 int	cmd;
 FILE	*out;
 UD	offset,nb;
 FILE	*hard_disk;
 UB	*buffer;
 UW	ret;



	make_crctable();
	outp(0x37a,0);		// strobe a zero.


//	test_send();

	#if 0
	out=fopen("disk.bin","wb");
	if (!out) {
	  printf("Merde.\n");
	  exit(1);
	}
	#endif

	//hard_disk=fopen("disk.emu","rb");
	hard_disk=fopen("disk.emu","rb+wb");
	if (!hard_disk) {
	  printf("Blairo\n");
	  exit(1);
	}



	printf(	"ATARI-ST hard-disk simulator.\n"
		"Code,Hardware and Idea by Leonard/OXYGENE.\n\n"
		"Serveur waiting...\n\n");





	for (;;) {


	  cmd=wait_cmd();

	  if (cmd==CMD_SHUTDOWN) {
	    p_cmd("SHUTDOWN !!");
	    break;
	  }


	  switch (cmd) {
	  case CMD_HARD_INIT:
	    p_cmd("Hard-Disk emulator initializing");


	    send_block(ret_ok,4);


	    break;


	  case CMD_DODISK:
	    p_cmd("Receiving sector.");


	    send_block(ret_ok,4);

	    printf("return ok sended.\n");

	    if (receive_block(tampon,512*9)) {
	      printf("Erreur reception.\n");
	      exit(1);
	    }

	    fwrite(tampon,1,512*9,out);

	    printf("tampon written\n");

	    send_block(ret_ok,4);


	    break;



	  case CMD_READ_SECTOR:


	    p_cmd("READ SECTOR.");
	    send_block(ret_ok,4);


	    offset= command_buffer[2]<<24;
	    offset|=command_buffer[3]<<16;
	    offset|=command_buffer[4]<<8;
	    offset|=command_buffer[5];

	    nb  = command_buffer[6]<<8;
	    nb |= command_buffer[7];


	    printf("Sector:%ld Nb:%ld\n",(offset/512),nb);


	    nb*=512;


	    buffer=(UB *)malloc(nb);
	    if (!buffer) {
	      printf("MALLOC error.\n");
	      exit(1);
	    }

	    fseek(hard_disk,offset,SEEK_SET);
	    fread(buffer,1,nb,hard_disk);

	    send_block(buffer,nb);

	    free(buffer);


	    break;


	  case CMD_WRITE_SECTOR:


	    p_cmd("WRITE SECTOR.");
	    send_block(ret_ok,4);


	    offset= command_buffer[2]<<24;
	    offset|=command_buffer[3]<<16;
	    offset|=command_buffer[4]<<8;
	    offset|=command_buffer[5];

	    nb  = command_buffer[6]<<8;
	    nb |= command_buffer[7];


	    printf("Sector:%ld Nb:%ld\n",(offset/512),nb);


	    nb*=512;


	    buffer=(UB *)malloc(nb);
	    if (!buffer) {
	      printf("MALLOC error.\n");
	      exit(1);
	    }


	    ret=receive_block(buffer,nb);

	    mwait(65536);

	    if (ret)
	      send_block(ret_false,4);
	    else {
	      fseek(hard_disk,offset,SEEK_SET);
	      if (fwrite(buffer,1,nb,hard_disk)!=nb) {
		printf("PC WRITING ERROR !!%c\n",7);
		send_block(ret_false,4);
	      } else {
	        send_block(ret_ok,4);
	      }
	    }

	    free(buffer);



	    break;




	  default:
	    printf("%cERROR:Unknow command !!\n",7);
	    printf("Cmd received:$%04X\n",cmd);
	    exit(1);
	    break;



	  }



	}



	printf("\nSystem halted.\n");


	fclose(out);


 }


