/*
 * $Id: timer.cpp 131 2007-11-07 20:10:05Z ehaase $
 *
 * What We Are
 *
 * Copyright (C) 1994 - 2007 Enver Haase
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */



#include "timer.hpp"

Timer::Timer(){
	init();
}

void Timer::init(void)
{
    this->init(0);
}

void Timer::init(DWORD elapsedAlready)
{
    ticksAtInit = timeGetTime() - elapsedAlready;
}

DWORD Timer::elapsed(void){
	return (timeGetTime() - ticksAtInit);
}

bool Timer::isElapsed(DWORD milliSeconds){
    // believe it or not: even though it's called ticks,
    // Microsoft has specified GetTickCount() as returning
    // milliseconds.
	return ( (ticksAtInit+milliSeconds) <= GetTickCount() );
}
