/*
 * $Id: bitmap.hpp 165 2007-11-14 18:51:07Z hangman $
 *
 * What We Are
 *
 * Copyright (C) 1994 - 2007 Enver Haase
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */
 
#ifndef BITMAP_HPP
#define BITMAP_HPP

#pragma warning( disable : 4290 )

#include "../main.hpp"
#include "../exceptions.hpp"

/* Magic number in every .BMP file (if it's not there, the file is corrupt) */
#define BITMAP_ID     0x4D42

// container structure for bitmaps .BMP file
typedef struct BITMAP_FILE_TAG
        {
        BITMAPFILEHEADER bitmapfileheader;  // this contains the bitmapfile header
        BITMAPINFOHEADER bitmapinfoheader;  // this is all the info including the palette
        PALETTEENTRY     palette[256];      // we will store the palette here
        UCHAR            *buffer;           // this is a pointer to the data
} BITMAP_FILE, *BITMAP_FILE_PTR;

class Bitmap{
    private:
		BITMAP_FILE bitmap_file;
		LPDIRECTDRAWSURFACE7 pdds;
		LPDIRECTDRAWSURFACE7 createOffscreenSurface(LPDIRECTDRAW7 pdd, int width, int height);
	    void Flip_Bitmap(UCHAR *image, int bytes_per_line, int height);
		void Bitmap::copyToSurface();
        /**
         * Opens a bitmap file and loads the data into bitmap
         */
        SIZE loadBitmap(std::string &filename) throw (BitmapCreateError);
        void throwException(std::string filename, std::string reason) throw (BitmapCreateError);
    public:
        /**
         * Create a Bitmap object from a bitmap file.
         * Expects 8, 16 or 24 bit uncompressed input *.BMP files.
         * Tries to read from a Windows RCDATA resource of name
         * 'filename' first, if not found tries to load from the
         * file system.
         * If the input bitmap file is 24-bit, the resulting
         * Bitmap object is still only 16-bit, however.
         */
        Bitmap(LPDIRECTDRAW7 pdd, std::string &filename) throw (BitmapCreateError);

		/**
         * Destructor.
         */
        ~Bitmap();

		/**
         * It's the user's responsibility to make sure this bitmap
         * object was created from a "palettized" bitmap file; otherwise
         * the result is undefined.
         */
        LPPALETTEENTRY getPaletteEntries(void);
             
        /**
		 *
		 */
        void Blit(LPDIRECTDRAWSURFACE7 dest_pdds, RECT destRectangle);

		/**
		 *
		 */
		void Blit(LPDIRECTDRAWSURFACE7 dest_pdds, RECT destRectangle, RECT sourceRectangle);

        /**
         * Returns the height of this Bitmap.
         */
        int getHeight(void);

        /**
         * Returns the width of this Bitmap.
         */
        int getWidth(void);
};

#endif /* BITMAP_HPP */
