function love.load()
	music = love.audio.newSource("data/bagger.xm")
	music:setLooping(true)
	
	dots = love.graphics.newImage("data/dots.png")
	logo = love.graphics.newImage("data/logo.png")
	love.graphics.setBackgroundColor(250,250,250)
	
	love.audio.play(music)
	love.audio.setVolume(0.5)
end

function love.update(dt)
	circle:update(dt)
	circle2:update(dt)
	circle3:update(dt)
	r, g, b = math.random(dt/20, 200), math.random(dt/20, 200), math.random(dt/20, 200)
end

function love.keypressed(k)
	if k == 'escape' then
		love.event.push('q')
	end
end

function love.draw()
	centertarget()
	love.graphics.setColor(255, 255, 255)
	love.graphics.setColor(r, g, b)
	circle:render()
	circle2:render()
	circle3:render()
	love.graphics.setColor(250,250,250)
	love.graphics.draw(logo, 400, 350, 0, 2, 2, 155, 0)
end

circle = {
	x = 400, 
	y = 250, 
	a = 0
}

circle2 = {
	x = 400, 
	y = 250, 
	a = 0
}

circle3 = {
	x = 400, 
	y = 250, 
	a = 0
}


function circle:update(dt)
	self.a = self.a + 10 * dt
end

function circle2:update(dt)
	self.a = self.a + 10 * dt
end

function circle3:update(dt)
	self.a = self.a + 10 * dt
end

function circle:render()
	local r = 1 + math.sin(self.a*math.pi/20) 
	for i = 1,10 do
		love.graphics.draw(dots, self.x, self.y, (i * math.pi*2/10), 1.5, 1.5, 16, 64+10*r)
	end
end

function circle2:render()
	local r = 1 + math.sin(self.a*math.pi/20) 
	for i = 1,10 do
		love.graphics.draw(dots, self.x, self.y, (i * math.pi*2/10), 1.5, 1.5, 8, 64+10*r*5)
	end
end

function circle3:render()
	local r = 1 + math.sin(self.a*math.pi/20) 
	for i = 1,10 do
		love.graphics.draw(dots, self.x, self.y, (i * math.pi*2/10), 1.5, 1.5, 2, 64+10*r*10)
	end
end

function centertarget()
	love.graphics.setColor(0,100,200)
	love.graphics.circle("line",400,250,60,12)
	love.graphics.setColor(0,200,100)
	love.graphics.circle("line",400,250,50,12)
	love.graphics.setColor(100,0,200)
	love.graphics.circle("line",400,250,40,12)
	love.graphics.setColor(200,100,0)
	love.graphics.circle("line",400,250,30,12)
	love.graphics.setColor(100,200,0)
	love.graphics.circle("line",400,250,20,12)
	love.graphics.setColor(0,200,100)
	love.graphics.circle("line",400,250,10,12)
	love.graphics.setColor(0,100,200)
	love.graphics.circle("line",400,250,5,12)
	love.graphics.circle("line",400,250,4,12)
	love.graphics.circle("line",400,250,3,12)
	love.graphics.circle("line",400,250,2,12)
	love.graphics.circle("line",400,250,1,12)
end