/*
 * Decompiled with CFR 0.152.
 */
package vitamin;

import java.util.HashMap;
import java.util.Map;
import javax.media.opengl.GL;
import vitamin.VSamplerState;
import vitamin.VTexture;

public class VTextureManager {
    GL _gl;
    private int _numTextures = 0;
    private Map<Integer, VTexture> _texturePool = null;

    VTextureManager(GL gl) {
        if (this._texturePool == null) {
            this._texturePool = new HashMap<Integer, VTexture>();
        }
    }

    public int loadTexture(String filename) {
        if (this._texturePool == null) {
            return -1;
        }
        VTexture tex = new VTexture(this._gl);
        tex.loadImageFromFile(filename, true);
        try {
            this._texturePool.put(this._numTextures, tex);
            int texID = this._numTextures++;
            return texID;
        }
        catch (Exception e) {
            System.err.println("(VGL)  Failed to load texture: " + filename);
            return 0;
        }
    }

    public int createRenderTarget(int target, int w, int h, int format, VSamplerState sampler) {
        if (this._texturePool == null) {
            return -1;
        }
        VTexture tex = new VTexture(this._gl);
        tex.create(target, w, h, format, sampler);
        try {
            this._texturePool.put(this._numTextures, tex);
            int texID = this._numTextures++;
            return texID;
        }
        catch (Exception e) {
            System.err.println("(VGL) Failed to create texture!");
            return 0;
        }
    }

    public int createRenderDepth(int w, int h, int format, VSamplerState sampler) {
        if (this._texturePool == null) {
            return -1;
        }
        VTexture tex = new VTexture(this._gl);
        tex.createDepth(w, h, format, sampler);
        try {
            this._texturePool.put(this._numTextures, tex);
            int texID = this._numTextures++;
            return texID;
        }
        catch (Exception e) {
            System.err.println("(VGL) Failed to create texture!");
            return 0;
        }
    }

    public int addTexture(String filename) {
        if (this._texturePool == null || this._texturePool.size() <= 0) {
            return -1;
        }
        VTexture tex = null;
        tex = new VTexture(this._gl, filename);
        try {
            this._texturePool.put(this._numTextures, tex);
            int texID = this._numTextures++;
            return texID;
        }
        catch (Exception e) {
            System.err.println("(VGL) Failed to load texture: " + filename);
            return 0;
        }
    }

    public void removeTexture(int texid) {
        VTexture tex = this._texturePool.get(texid);
        if (tex._targetID != 0) {
            if (tex._targetID == 36161) {
                int[] tmp = new int[]{tex.getId()};
                this._gl.glDeleteRenderbuffersEXT(1, tmp, 0);
            } else {
                int[] tmp = new int[]{tex.getId()};
                this._gl.glDeleteTextures(1, tmp, 0);
            }
            tex._id = 0;
        }
    }

    public int getNumOfTextures() {
        return this._numTextures;
    }

    public VTexture getTexture(int id) {
        if (id >= 0 && id < this._texturePool.size()) {
            return this._texturePool.get(id);
        }
        return null;
    }

    public VTexture getTexture(String filename) {
        if (filename == null) {
            return null;
        }
        VTexture tex = null;
        int i = 0;
        while (i < this._numTextures) {
            tex = this._texturePool.get(i);
            if (tex._fileName.equals(filename)) {
                return tex;
            }
            ++i;
        }
        return null;
    }

    public int getTextureId(int id) {
        if (id >= 0 && id < this._texturePool.size()) {
            return this._texturePool.get(id).getId();
        }
        return 0;
    }

    public int getTextureId(String filename) {
        if (filename == null) {
            return 0;
        }
        VTexture tex = null;
        int i = 0;
        while (i < this._numTextures) {
            tex = this._texturePool.get(i);
            if (tex._fileName.equals(filename)) {
                return tex.getId();
            }
            ++i;
        }
        return 0;
    }
}

