/*
 * Decompiled with CFR 0.152.
 */
package vitamin;

import java.nio.Buffer;
import java.nio.IntBuffer;
import javax.media.opengl.GL;
import javax.media.opengl.GLException;
import vitamin.VImage;
import vitamin.VSamplerState;

public class VTexture {
    public static int[] GLInternalFormats;
    public static int[] GLFormats;
    public static int[] GLDataTypes;
    public String _name;
    String _fileName;
    public int _id;
    public int _targetID;
    VSamplerState _samplerState;
    int _format;
    int _width;
    int _height;
    GL _gl;

    static {
        int[] nArray = new int[19];
        nArray[1] = 6409;
        nArray[2] = 6410;
        nArray[3] = 6407;
        nArray[4] = 32849;
        nArray[5] = 6408;
        nArray[6] = 32856;
        nArray[7] = 36233;
        nArray[8] = 36232;
        nArray[9] = 36227;
        nArray[10] = 36226;
        nArray[11] = 34837;
        nArray[12] = 34836;
        nArray[13] = 6402;
        nArray[14] = 33189;
        nArray[15] = 33190;
        nArray[16] = 35056;
        nArray[17] = 6407;
        nArray[18] = 6408;
        GLInternalFormats = nArray;
        int[] nArray2 = new int[19];
        nArray2[1] = 6409;
        nArray2[2] = 6410;
        nArray2[3] = 32993;
        nArray2[4] = 6408;
        nArray2[5] = 6408;
        nArray2[6] = 6408;
        nArray2[7] = 36233;
        nArray2[8] = 36232;
        nArray2[9] = 36227;
        nArray2[10] = 36226;
        nArray2[11] = 34837;
        nArray2[12] = 34836;
        nArray2[13] = 6402;
        nArray2[14] = 33189;
        nArray2[15] = 33190;
        nArray2[16] = 35056;
        nArray2[17] = 32993;
        nArray2[18] = 32993;
        GLFormats = nArray2;
        int[] nArray3 = new int[18];
        nArray3[1] = 5121;
        nArray3[2] = 5121;
        nArray3[3] = 5121;
        nArray3[4] = 5121;
        nArray3[5] = 5121;
        nArray3[6] = 5121;
        nArray3[7] = 5123;
        nArray3[8] = 5123;
        nArray3[9] = 5125;
        nArray3[10] = 5125;
        nArray3[11] = 5126;
        nArray3[12] = 5126;
        nArray3[13] = 6402;
        nArray3[14] = 5123;
        nArray3[15] = 5125;
        nArray3[16] = 34042;
        nArray3[17] = 5121;
        GLDataTypes = nArray3;
    }

    public VTexture(GL gl) {
        this._gl = gl;
        this._name = null;
        this._targetID = 3553;
    }

    public VTexture(GL gl, String filename) {
        this._gl = gl;
        this._name = filename;
        this._targetID = 3553;
    }

    void release() {
        int[] texId = new int[]{this._id};
        try {
            this._gl.glDeleteTextures(1, texId, 0);
        }
        catch (GLException e) {
            System.err.println("(VTexture)  " + (Object)((Object)e));
        }
    }

    public void create(int target, int width, int height, int surfaceFormat, VSamplerState samp) {
        switch (target) {
            case 3552: {
                this._targetID = 3552;
                break;
            }
            case 3553: {
                this._targetID = 3553;
                break;
            }
            case 32879: {
                this._targetID = 32879;
                break;
            }
            case 34067: {
                this._targetID = 34067;
                break;
            }
            case 34037: {
                this._targetID = 34037;
                break;
            }
        }
        this._width = width;
        this._height = height;
        this._format = surfaceFormat;
        int srcType = GLDataTypes[surfaceFormat];
        int internalFormat = GLInternalFormats[surfaceFormat];
        int srcFormat = GLFormats[surfaceFormat];
        int[] id = new int[1];
        this._gl.glGenTextures(1, id, 0);
        this._id = id[0];
        this._gl.glBindTexture(this._targetID, this._id);
        this._gl.glTexParameteri(this._targetID, 10242, samp._wrapS);
        this._gl.glTexParameteri(this._targetID, 10243, samp._wrapT);
        this._gl.glTexParameteri(this._targetID, 10241, samp._minFilter);
        this._gl.glTexParameteri(this._targetID, 10240, samp._magFilter);
        this._gl.glTexImage2D(this._targetID, 0, internalFormat, this._width, this._height, 0, srcFormat, srcType, null);
        this._gl.glBindRenderbufferEXT(this._targetID, 0);
    }

    public void createDepth(int width, int height, int surfaceFormat, VSamplerState samp) {
        this._targetID = 36161;
        this._width = width;
        this._height = height;
        this._format = surfaceFormat;
        int[] id = new int[1];
        this._gl.glGenRenderbuffersEXT(1, id, 0);
        this._id = id[0];
        this._gl.glBindRenderbufferEXT(36161, this._id);
        this._gl.glRenderbufferStorageEXT(36161, GLInternalFormats[surfaceFormat], this._width, this._height);
        this._gl.glBindRenderbufferEXT(this._targetID, 0);
    }

    public boolean loadImageFromFile(String filename, boolean mipmap) {
        boolean isLoaded = false;
        this._fileName = filename;
        VImage img = new VImage();
        if (!img.loadFromFile(this._fileName)) {
            System.err.println("(VTexture)  Failed to load imagefile: " + filename);
            return false;
        }
        this._width = img.getWidth();
        this._height = img.getHeight();
        switch (img.getFormat()) {
            case 0: {
                this._format = 1;
                break;
            }
            case 4: {
                this._format = 1;
                break;
            }
            case 1: {
                this._format = 3;
                break;
            }
            case 2: {
                this._format = 5;
                break;
            }
            case 3: {
                this._format = 5;
                break;
            }
            case 5: {
                this._format = 17;
                break;
            }
            default: {
                this._format = 5;
            }
        }
        int internalFormat = GLInternalFormats[this._format];
        int srcFormat = GLFormats[this._format];
        int srcType = GLDataTypes[this._format];
        System.out.println("(VTexture) Texture Info: " + this._width + ", " + this._height + ",  Format: " + this._format);
        this.setSamplerState(10497, 10497, 9987, 9729, 16);
        int[] id = new int[1];
        this._gl.glGenTextures(1, id, 0);
        this._id = id[0];
        this._gl.glBindTexture(this._targetID, this._id);
        this._gl.glTexParameteri(this._targetID, 10242, this._samplerState._wrapS);
        this._gl.glTexParameteri(this._targetID, 10243, this._samplerState._wrapT);
        this._gl.glTexParameteri(this._targetID, 10241, this._samplerState._minFilter);
        this._gl.glTexParameteri(this._targetID, 10240, this._samplerState._magFilter);
        if (mipmap) {
            this._gl.glTexParameteri(this._targetID, 33169, 1);
        }
        this._gl.glTexImage2D(this._targetID, 0, internalFormat, this._width, this._height, 0, srcFormat, srcType, (Buffer)IntBuffer.wrap(img.getData()));
        isLoaded = true;
        img = null;
        System.out.println("(VTexture) Texture '" + filename + "' loaded with id: " + this._id);
        return isLoaded;
    }

    void grabBuffer() {
        if (this._targetID != 3553 || this._targetID != 34037) {
            System.err.println("(VTexture)  Can't update texture. gltarget isn't supported");
            return;
        }
        this._gl.glBindTexture(this._targetID, this._id);
        this._gl.glPixelStorei(3317, 1);
        this._gl.glCopyTexSubImage2D(this._targetID, 0, 0, 0, this._width, this._height, this._width, this._height);
        this._gl.glBindTexture(this._targetID, 0);
    }

    void update(int[] pixels) {
        if (this._targetID != 3553 || this._targetID != 34037) {
            System.err.println("(VTexture)  Can't update texture. gltarget isn't supported");
            return;
        }
        int srcFormat = GLFormats[this._format];
        int srcType = GLDataTypes[this._format];
        this._gl.glBindTexture(this._targetID, this._id);
        this._gl.glPixelStorei(3317, 1);
        this._gl.glTexSubImage2D(this._targetID, 0, 0, 0, this._width, this._height, srcFormat, srcType, (Buffer)IntBuffer.wrap(pixels));
        this._gl.glBindTexture(this._targetID, 0);
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getName() {
        return this._name;
    }

    public void setSamplerState(VSamplerState s) {
        this._samplerState = s;
    }

    public void setSamplerState(int wrapS, int wrapT, int minFilter, int magFilter, int aniso) {
        this._samplerState = new VSamplerState();
        this._samplerState._anisotropy = aniso;
        this._samplerState._lod = 1.0f;
        this._samplerState._magFilter = magFilter;
        this._samplerState._minFilter = minFilter;
        this._samplerState._wrapR = 9729;
        this._samplerState._wrapS = wrapS;
        this._samplerState._wrapT = wrapT;
    }

    public int getId() {
        return this._id;
    }

    public int id() {
        return this._id;
    }
}

