/*
 * Decompiled with CFR 0.152.
 */
package vitamin;

import com.sun.opengl.util.BufferUtil;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.media.opengl.GL;
import vitamin.Shader;
import vitamin.VStringUtil;

public class ShaderGLSL
extends Shader {
    private int _glslProgram;
    private int _vertexShaderId;
    private int _fragmentShaderId;
    private int _geometryShaderId;

    public ShaderGLSL(GL gl, String name) {
        this._gl = gl;
        this._type = 3;
        this._name = name;
    }

    public int getProgram() {
        return this._glslProgram;
    }

    public void load(String vfile, String ffile) {
        if (vfile != null) {
            this.loadVertexShader(vfile);
        }
        if (ffile != null) {
            this.loadFragmentShader(ffile);
        }
        this.compile();
    }

    public void load(String vfile, String ffile, String gfile) {
        if (vfile != null) {
            this.loadVertexShader(vfile);
        }
        if (ffile != null) {
            this.loadFragmentShader(ffile);
        }
        if (gfile != null) {
            this.loadGeometryShader(gfile);
        }
        this.compile();
    }

    public void loadVertexShader(String filename) {
        this._vertexShaderId = this._gl.glCreateShaderObjectARB(35633);
        String source = VStringUtil.join(VStringUtil.loadStrings(filename), "\n");
        this._gl.glShaderSourceARB(this._vertexShaderId, 1, new String[]{source}, null, 0);
        this._vertexShaderEnabled = true;
    }

    public void loadFragmentShader(String filename) {
        this._fragmentShaderId = this._gl.glCreateShaderObjectARB(35632);
        String source = VStringUtil.join(VStringUtil.loadStrings(filename), "\n");
        this._gl.glShaderSourceARB(this._fragmentShaderId, 1, new String[]{source}, null, 0);
        this._fragmentShaderEnabled = true;
    }

    public void loadGeometryShader(String filename) {
        this._geometryShaderId = this._gl.glCreateShaderObjectARB(36313);
        String source = VStringUtil.join(VStringUtil.loadStrings(filename), "\n");
        this._gl.glShaderSourceARB(this._geometryShaderId, 1, new String[]{source}, null, 0);
        this._geometryShaderEnabled = true;
    }

    public void compile() {
        this._glslProgram = this._gl.glCreateProgramObjectARB();
        if (this._vertexShaderEnabled) {
            this._gl.glCompileShaderARB(this._vertexShaderId);
            this._gl.glAttachObjectARB(this._glslProgram, this._vertexShaderId);
        }
        if (this._fragmentShaderEnabled) {
            this._gl.glCompileShaderARB(this._fragmentShaderId);
            this._gl.glAttachObjectARB(this._glslProgram, this._fragmentShaderId);
        }
        this._gl.glLinkProgramARB(this._glslProgram);
        this._gl.glValidateProgramARB(this._glslProgram);
        this.checkLogInfo("(ShaderGLSL)  GLSL program validation: ", this._glslProgram);
    }

    @Override
    public void enable() {
        this._gl.glUseProgram(this._glslProgram);
    }

    @Override
    public void disable() {
        this._gl.glUseProgram(0);
    }

    @Override
    public void setTextureParameter(String param, int texUnit) {
        int location = this._gl.glGetUniformLocation(this._glslProgram, param);
        this._gl.glUniform1i(location, texUnit);
    }

    @Override
    public void setParameter1d(String param, double x) {
        int location = this._gl.glGetUniformLocation(this._glslProgram, param);
        this._gl.glUniform1f(location, (float)x);
    }

    @Override
    public void setParameter1f(String param, float x) {
        int location = this._gl.glGetUniformLocation(this._glslProgram, param);
        this._gl.glUniform1f(location, x);
    }

    @Override
    public void setParameter1i(String param, int x) {
        int location = this._gl.glGetUniformLocation(this._glslProgram, param);
        this._gl.glUniform1i(location, x);
    }

    @Override
    public void setParameter2f(String param, float x, float y) {
        int location = this._gl.glGetUniformLocation(this._glslProgram, param);
        this._gl.glUniform2f(location, x, y);
    }

    @Override
    public void setParameter3f(String param, float x, float y, float z) {
        int location = this._gl.glGetUniformLocation(this._glslProgram, param);
        this._gl.glUniform3f(location, x, y, z);
    }

    @Override
    public void setParameter3fv(String param, float[] v) {
        int location = this._gl.glGetUniformLocation(this._glslProgram, param);
        this._gl.glUniform3fv(location, 3, v, 0);
    }

    @Override
    public void setParameter4f(String param, float x, float y, float z, float w) {
        int location = this._gl.glGetUniformLocation(this._glslProgram, param);
        this._gl.glUniform4f(location, x, y, z, w);
    }

    @Override
    public void setParameter4fv(String param, float[] v) {
        int location = this._gl.glGetUniformLocation(this._glslProgram, param);
        this._gl.glUniform4fvARB(location, 4, v, 0);
    }

    @Override
    public void setMatrixParameterSemantic(String param, int matrix, int matrixType) {
    }

    @Override
    public void setMatrixParameterSemantic(String param, float[] v) {
    }

    @Override
    public void setParameterSemantic(String param, float x) {
    }

    @Override
    public void setParameterSemantic(String param, float x, float y) {
    }

    @Override
    public void setParameterSemantic(String param, float x, float y, float z) {
    }

    @Override
    public void setParameterSemantic(String param, float x, float y, float z, float w) {
    }

    @Override
    public void setParameter4x4d(String param, double[] v) {
        System.err.println("(ShaderGLSL)  setParameter4x4d: function not implemented");
    }

    @Override
    public void setParameter4x4f(String param, float[] v) {
        int location = this._gl.glGetUniformLocation(this._glslProgram, param);
        this._gl.glUniformMatrix4fv(location, 16, false, v, 0);
    }

    @Override
    public void setParameter4x4f(String semanticName, int matrix, int matrixType) {
        System.err.println("(ShaderGLSL)  This function isn't supported for GLSL shaders.");
    }

    @Override
    public void setParameter4x4fBySemantic(String semanticName, int matrix, int matrixType) {
        System.err.println("(ShaderGLSL)  This function isn't supported for GLSL shaders.");
    }

    protected void checkLogInfo(String title, int obj) {
        IntBuffer iVal = BufferUtil.newIntBuffer((int)1);
        this._gl.glGetObjectParameterivARB(obj, 35716, iVal);
        int length = iVal.get();
        if (length <= 1) {
            System.err.println("(ShaderGLSL)  checkloginfo: ERROR!");
            return;
        }
        ByteBuffer infoLog = BufferUtil.newByteBuffer((int)length);
        iVal.flip();
        this._gl.glGetInfoLogARB(obj, length, iVal, infoLog);
        byte[] infoBytes = new byte[length];
        infoLog.get(infoBytes);
        System.err.println("(ShaderGLSL)  " + title);
        System.err.println("(ShaderGLSL)  " + new String(infoBytes));
    }
}

