/*
 * Decompiled with CFR 0.152.
 */
package vitamin.math;

import vitamin.math.Matrix;
import vitamin.math.Plane;
import vitamin.math.Vector3;

public class Frustum {
    private static final int FRUSTUM_LEFT = 0;
    private static final int FRUSTUM_RIGHT = 1;
    private static final int FRUSTUM_TOP = 2;
    private static final int FRUSTUM_BOTTOM = 3;
    private static final int FRUSTUM_FAR = 4;
    private static final int FRUSTUM_NEAR = 5;
    Matrix projMatrix;
    Matrix viewMatrix;
    Matrix finalMatrix;
    Plane[] _planes = new Plane[6];

    public Frustum() {
        int i = 0;
        while (i < 6) {
            this._planes[i] = new Plane();
            ++i;
        }
        this.projMatrix = new Matrix();
        this.projMatrix.identity();
        this.viewMatrix = new Matrix();
        this.viewMatrix.identity();
        this.finalMatrix = new Matrix();
        this.finalMatrix.identity();
    }

    public void compute(Matrix clipMatrix) {
        float[] mvp = new float[16];
        int i = 0;
        while (i < 16) {
            mvp[i] = clipMatrix._M[i];
            ++i;
        }
        this._planes[0] = new Plane(mvp[12] - mvp[0], mvp[13] - mvp[1], mvp[14] - mvp[2], mvp[15] - mvp[3]);
        this._planes[1] = new Plane(mvp[12] + mvp[0], mvp[13] + mvp[1], mvp[14] + mvp[2], mvp[15] + mvp[3]);
        this._planes[2] = new Plane(mvp[12] - mvp[4], mvp[13] - mvp[5], mvp[14] - mvp[6], mvp[15] - mvp[7]);
        this._planes[3] = new Plane(mvp[12] + mvp[4], mvp[13] + mvp[5], mvp[14] + mvp[6], mvp[15] + mvp[7]);
        this._planes[4] = new Plane(mvp[12] - mvp[8], mvp[13] - mvp[9], mvp[14] - mvp[10], mvp[15] - mvp[11]);
        this._planes[5] = new Plane(mvp[12] + mvp[8], mvp[13] + mvp[9], mvp[14] + mvp[10], mvp[15] + mvp[11]);
    }

    public void build(Matrix clipMatrix) {
        float[] m = new float[16];
        int i = 0;
        while (i < 16) {
            m[i] = clipMatrix._M[i];
            ++i;
        }
        this._planes[0]._normal.x = m[3] - m[0];
        this._planes[0]._normal.y = m[7] - m[4];
        this._planes[0]._normal.z = m[11] - m[8];
        this._planes[0]._d = m[15] - m[12];
        this._planes[1]._normal.x = m[3] + m[0];
        this._planes[1]._normal.y = m[7] + m[4];
        this._planes[1]._normal.z = m[11] + m[8];
        this._planes[1]._d = m[15] + m[12];
        this._planes[2]._normal.x = m[3] - m[1];
        this._planes[2]._normal.y = m[7] - m[5];
        this._planes[2]._normal.z = m[11] - m[9];
        this._planes[2]._d = m[15] - m[13];
        this._planes[3]._normal.x = m[3] + m[1];
        this._planes[3]._normal.y = m[7] + m[5];
        this._planes[3]._normal.z = m[11] + m[9];
        this._planes[3]._d = m[15] + m[13];
        this._planes[4]._normal.x = m[3] - m[2];
        this._planes[4]._normal.y = m[7] - m[6];
        this._planes[4]._normal.z = m[11] - m[10];
        this._planes[4]._d = m[15] - m[14];
        this._planes[5]._normal.x = m[3] + m[2];
        this._planes[5]._normal.y = m[7] + m[6];
        this._planes[5]._normal.z = m[11] + m[10];
        this._planes[5]._d = m[15] + m[14];
        i = 0;
        while (i < 6) {
            this._planes[i].normalize();
            ++i;
        }
    }

    public void build(Matrix viewMatrix, Matrix projMatrix) {
        this.finalMatrix = projMatrix.mul(viewMatrix);
        float[] m = new float[16];
        int i = 0;
        while (i < 16) {
            m[i] = this.finalMatrix._M[i];
            ++i;
        }
        this._planes[0]._normal.x = m[3] - m[0];
        this._planes[0]._normal.y = m[7] - m[4];
        this._planes[0]._normal.z = m[11] - m[8];
        this._planes[0]._d = m[15] - m[12];
        this._planes[1]._normal.x = m[3] + m[0];
        this._planes[1]._normal.y = m[7] + m[4];
        this._planes[1]._normal.z = m[11] + m[8];
        this._planes[1]._d = m[15] + m[12];
        this._planes[2]._normal.x = m[3] - m[1];
        this._planes[2]._normal.y = m[7] - m[5];
        this._planes[2]._normal.z = m[11] - m[9];
        this._planes[2]._d = m[15] - m[13];
        this._planes[3]._normal.x = m[3] + m[1];
        this._planes[3]._normal.y = m[7] + m[5];
        this._planes[3]._normal.z = m[11] + m[9];
        this._planes[3]._d = m[15] + m[13];
        this._planes[4]._normal.x = m[3] - m[2];
        this._planes[4]._normal.y = m[7] - m[6];
        this._planes[4]._normal.z = m[11] - m[10];
        this._planes[4]._d = m[15] - m[14];
        this._planes[5]._normal.x = m[3] + m[2];
        this._planes[5]._normal.y = m[7] + m[6];
        this._planes[5]._normal.z = m[11] + m[10];
        this._planes[5]._d = m[15] + m[14];
        i = 0;
        while (i < 6) {
            this._planes[i].normalize();
            ++i;
        }
    }

    public void build(float angle, float ratio, float near, float far, Vector3 camPos, Vector3 lookAt, Vector3 up) {
        float radians = (float)Math.tan((double)angle * Math.PI / 180.0 * 0.5);
        float nearH = near * radians;
        float nearW = nearH * ratio;
        float farH = far * radians;
        float farW = farH * ratio;
        Vector3 zVec = Vector3.sub(camPos, lookAt);
        zVec.normalize();
        Vector3 xVec = Vector3.cross(up, zVec);
        xVec.normalize();
        Vector3 yVec = Vector3.cross(zVec, xVec);
        Vector3 zNear = Vector3.mul(zVec, near);
        Vector3 vecN = Vector3.sub(camPos, zNear);
        Vector3 zFar = Vector3.mul(zVec, far);
        Vector3 vecF = Vector3.sub(camPos, zFar);
        Vector3 xNearW = Vector3.mul(xVec, nearW);
        Vector3 xFarW = Vector3.mul(xVec, farW);
        Vector3 yNearH = Vector3.mul(yVec, nearH);
        Vector3 yFarH = Vector3.mul(yVec, farH);
        Vector3 nearTopLeft = Vector3.add(vecN, yNearH);
        nearTopLeft.sub(xNearW);
        Vector3 nearTopRight = Vector3.add(vecN, yNearH);
        nearTopRight.add(xNearW);
        Vector3 nearBottomLeft = Vector3.sub(vecN, yNearH);
        nearBottomLeft.sub(xNearW);
        Vector3 nearBottomRight = Vector3.sub(vecN, yNearH);
        nearBottomRight.add(xNearW);
        Vector3 farTopLeft = Vector3.add(vecF, yFarH);
        farTopLeft.sub(xFarW);
        Vector3 farTopRight = Vector3.add(vecF, yFarH);
        farTopRight.add(xFarW);
        Vector3 farBottomLeft = Vector3.sub(vecF, yFarH);
        farBottomLeft.sub(xFarW);
        Vector3 farBottomRight = Vector3.sub(vecF, yFarH);
        farBottomRight.add(xFarW);
        this._planes[0].redefine(nearTopRight, nearTopLeft, farTopLeft);
        this._planes[1].redefine(nearBottomLeft, nearBottomRight, farBottomRight);
        this._planes[2].redefine(nearTopLeft, nearBottomLeft, farBottomLeft);
        this._planes[3].redefine(nearBottomRight, nearTopRight, farBottomRight);
        this._planes[4].redefine(nearTopLeft, nearTopRight, nearBottomRight);
        this._planes[5].redefine(farTopRight, farTopLeft, farBottomLeft);
    }

    public boolean isPointVisible(Vector3 p) {
        float distance = 0.0f;
        int i = 0;
        while (i < 6) {
            distance = this._planes[i].distance(p);
            if (distance < 0.0f) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isSphereVisible(Vector3 center, float radius) {
        float distance = 0.0f;
        int i = 0;
        while (i < 6) {
            distance = this._planes[i].distance(center);
            if (distance < -radius) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

